/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.formplugin.reportscheme;

import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.bill.OperationStatus;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.OrmLocaleValue;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.SqlBuilder;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.ListSelectedRow;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.exception.KDBizException;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.control.Control;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.control.events.BeforeItemClickEvent;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.ListShowParameter;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.DispatchServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.TimeServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.epm.eb.business.bizrule.RuleRelationService;
import kd.epm.eb.business.examinev2.service.ExamineServiceImpl;
import kd.epm.eb.business.memberf7.NewF7Utils;
import kd.epm.eb.business.reportscheme.entity.TebSchemeAssign;
import kd.epm.eb.business.reportscheme.service.ReportSchemeAssignService;
import kd.epm.eb.business.reportscheme.service.ReportSchemeService;
import kd.epm.eb.business.reportscheme.service.ReportSchemeTemplateSortService;
import kd.epm.eb.business.userremember.service.UserRememberService;
import kd.epm.eb.common.cache.IModelCacheHelper;
import kd.epm.eb.common.cache.ModelCacheContext;
import kd.epm.eb.common.cache.impl.Dimension;
import kd.epm.eb.common.cache.impl.Member;
import kd.epm.eb.common.constant.BgBaseConstant;
import kd.epm.eb.common.dao.memberQuote.MemberQuoteDao;
import kd.epm.eb.common.enums.ApplicationTypeEnum;
import kd.epm.eb.common.enums.RangeEnum;
import kd.epm.eb.common.enums.SysDimensionEnum;
import kd.epm.eb.common.enums.memberQuote.MemberQuoteResourceEnum;
import kd.epm.eb.common.enums.memberQuote.MemberTypeEnum;
import kd.epm.eb.common.member.f7.MemberF7Parameter;
import kd.epm.eb.common.model.BizModel;
import kd.epm.eb.common.reportprocess.entity.dto.TemplateEntityDto;
import kd.epm.eb.common.reportprocess.entity.request.BaseRptProcessRequest;
import kd.epm.eb.common.reportprocess.helper.MemberHelper;
import kd.epm.eb.common.reportprocess.helper.SchemeRecordDeleteEntityHelper;
import kd.epm.eb.common.reportprocess.service.impl.ReportProcessAggService;
import kd.epm.eb.common.reportprocess.service.impl.ReportProcessConfig;
import kd.epm.eb.common.thread.EpmThreadPools;
import kd.epm.eb.common.utils.GlobalIdUtil;
import kd.epm.eb.common.utils.IDUtils;
import kd.epm.eb.common.utils.ModelUtils;
import kd.epm.eb.formplugin.AbstractFormPlugin;
import kd.epm.eb.spread.template.BgTemplate;
import kd.epm.eb.spread.template.IBaseEntry;
import kd.epm.eb.spread.template.ITemplateModel;
import kd.epm.eb.spread.template.TemplateModelHelper;
import kd.epm.eb.spread.template.TemplateModelJSONUtil;
import kd.epm.eb.spread.utils.ReportVar.ReportVarUtil;
import kd.epm.eb.spread.utils.ReportVar.TemplateVarCommonUtil;
import kd.epm.eb.spread.utils.ReportVar.TemplateVarUtil;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.collections4.MapUtils;
import org.apache.commons.lang.StringUtils;

public class ReportSchemeAssignPlugin
extends AbstractFormPlugin
implements BeforeF7SelectListener {
    private static final String ENTRYENTITY = "entryentity";
    private static final String SCHEME_TEXT = "schemetext";
    private static final String YEAR = "year";
    private static final String VERSION = "version";
    private static final String DATATYPE = "datatype";
    private static final String SCHEME = "scheme";
    private static final String BIZRANGE = "bizrange";
    private static final String BTN_OK = "btn_confirm";
    private static final String MODEL = "model";
    private static final String APPLYSCOPE = "applyscope";
    private static final String ENTRY_VAR = "entryentity3";
    public static final String VARIABLE_VALUE = "variable";
    private static final String ADD_VAR = "btn_add";
    private static final String DEL_VAR = "btn_del";
    public static final String BD_DIMENSION = "dimension";
    public static final String BD_VARIABLE = "variablenumber";
    public static final String VARIABLE_JSON = "variablejson";
    private static final ReportProcessAggService reportProcessAggService = ReportProcessAggService.getInstance();
    private static final ReportSchemeAssignService reportSchemeAssignService = ReportSchemeAssignService.getInstance();
    private static final Log log = LogFactory.getLog(ReportSchemeAssignPlugin.class);

    public void afterCreateNewData(EventObject e) {
        ArrayList<String> applyScopes;
        ArrayList<String> bizRanges;
        ArrayList<String> schemeIds;
        FormShowParameter formShowParameter = this.getView().getFormShowParameter();
        String model = (String)formShowParameter.getCustomParam(MODEL);
        if (kd.epm.eb.common.utils.StringUtils.isEmpty((String)model)) {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u4f53\u7cfb\u4e3a\u7a7a\u3002", (String)"ReportSchemeAssignPlugin_0", (String)"epm-eb-formplugin", (Object[])new Object[0]));
            return;
        }
        this.getModel().setValue(MODEL, (Object)model);
        ArrayList<Long> assignIds = new ArrayList<Long>(16);
        if (!OperationStatus.VIEW.equals((Object)formShowParameter.getStatus())) {
            this.getView().setVisible(Boolean.valueOf(true), new String[]{BTN_OK, "flexpanelap5"});
            String schemeIdStr = (String)formShowParameter.getCustomParam("schemeIds");
            if (kd.epm.eb.common.utils.StringUtils.isEmpty((String)schemeIdStr)) {
                this.getView().showErrorNotification(ResManager.loadKDString((String)"\u7ec4\u7ec7\u7f16\u5236\u65b9\u6848\u4e3a\u7a7a\u3002", (String)"ReportSchemeAssignPlugin_1", (String)"epm-eb-formplugin", (Object[])new Object[0]));
                return;
            }
            schemeIds = (ArrayList<String>)SerializationUtils.fromJsonString((String)schemeIdStr, List.class);
            String bizRangeStr = (String)formShowParameter.getCustomParam("bizRanges");
            if (kd.epm.eb.common.utils.StringUtils.isEmpty((String)bizRangeStr)) {
                this.getView().showErrorNotification(ResManager.loadKDString((String)"\u4e1a\u52a1\u6a21\u578b\u4e3a\u7a7a\u3002", (String)"ReportSchemeAssignPlugin_2", (String)"epm-eb-formplugin", (Object[])new Object[0]));
                return;
            }
            bizRanges = (ArrayList<String>)SerializationUtils.fromJsonString((String)bizRangeStr, List.class);
            String applyScopeStr = (String)formShowParameter.getCustomParam("applyScopes");
            if (kd.epm.eb.common.utils.StringUtils.isEmpty((String)applyScopeStr)) {
                this.getView().showErrorNotification(ResManager.loadKDString((String)"\u7f16\u5236\u5e94\u7528\u8303\u56f4\u4e3a\u7a7a\u3002", (String)"ReportSchemeAssignPlugin_14", (String)"epm-eb-formplugin", (Object[])new Object[0]));
                return;
            }
            applyScopes = (List)SerializationUtils.fromJsonString((String)applyScopeStr, List.class);
            String showText = (String)formShowParameter.getCustomParam("showText");
            this.getModel().setValue(SCHEME_TEXT, (Object)showText);
        } else {
            DynamicObject dynamicObject;
            this.getView().setVisible(Boolean.valueOf(false), new String[]{BTN_OK, "flexpanelap5"});
            Long id = (Long)formShowParameter.getCustomParam("id");
            if (id == null || id == 0L) {
                this.getView().showErrorNotification(ResManager.loadKDString((String)"\u5f53\u524d\u6570\u636e\u4e0d\u5b58\u5728\u3002", (String)"ReportSchemeAssignPlugin_36", (String)"epm-eb-formplugin", (Object[])new Object[0]));
            }
            if ((dynamicObject = BusinessDataServiceHelper.loadSingle((Object)id, (String)"eb_schemeassign")) == null) {
                this.getView().showErrorNotification(ResManager.loadKDString((String)"\u5f53\u524d\u6570\u636e\u4e0d\u5b58\u5728\u3002", (String)"ReportSchemeAssignPlugin_36", (String)"epm-eb-formplugin", (Object[])new Object[0]));
                return;
            }
            applyScopes = new ArrayList<String>(16);
            applyScopes.add(dynamicObject.getString(APPLYSCOPE));
            schemeIds = new ArrayList<String>(16);
            schemeIds.add(dynamicObject.getString("scheme.id"));
            bizRanges = new ArrayList<String>(16);
            bizRanges.add(dynamicObject.getString("bizrange.id"));
            this.getModel().setValue(SCHEME_TEXT, (Object)dynamicObject.getString("name"));
            this.getModel().setValue("description", (Object)dynamicObject.getString("description"));
            assignIds.add(dynamicObject.getLong("id"));
        }
        this.setEntryValue(schemeIds, bizRanges, applyScopes);
        this.fillSchemeAssignDimInfo(schemeIds, assignIds);
        this.loadVariableEntry(schemeIds, assignIds);
    }

    @Override
    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addClickListeners(new String[]{ADD_VAR, DEL_VAR});
        BasedataEdit year = (BasedataEdit)this.getControl(YEAR);
        year.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        BasedataEdit version = (BasedataEdit)this.getControl(VERSION);
        version.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        BasedataEdit datatype = (BasedataEdit)this.getControl(DATATYPE);
        datatype.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        BasedataEdit dimension = (BasedataEdit)this.getControl(BD_DIMENSION);
        dimension.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        BasedataEdit var = (BasedataEdit)this.getControl(BD_VARIABLE);
        var.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        this.addItemClickListeners(new String[]{"toolbarap"});
        this.addClickListeners(new String[]{VARIABLE_VALUE});
    }

    private void setEntryValue(List<String> schemeIds, List<String> bizRanges, List<String> applyScopes) {
        if (schemeIds.size() == 0 || bizRanges.size() == 0 || applyScopes.size() == 0) {
            return;
        }
        int[] rows = this.getModel().batchCreateNewEntryRow(ENTRYENTITY, schemeIds.size());
        for (int i = 0; i < rows.length; ++i) {
            this.getModel().setValue(SCHEME, (Object)schemeIds.get(i), rows[i]);
            this.getModel().setValue(BIZRANGE, (Object)bizRanges.get(i), rows[i]);
            this.getModel().setValue(APPLYSCOPE, (Object)applyScopes.get(i), rows[i]);
        }
    }

    @Override
    public void beforeF7Select(BeforeF7SelectEvent e) {
        String key = e.getProperty().getName();
        if (YEAR.equals(key) || VERSION.equals(key) || DATATYPE.equals(key)) {
            Long modelId = this.getModelId();
            String dimNumber = this.getDimNumber(key);
            if (dimNumber != null) {
                MemberF7Parameter f7Param = NewF7Utils.singleF7((Long)modelId, (DynamicObject)NewF7Utils.getDimension((Long)modelId, (String)dimNumber), (String)ListSelectedRow.class.getName());
                f7Param.setVerifyPermission(false);
                if (YEAR.equals(key)) {
                    f7Param.setCanSelectBudgetPeriodRoot(false);
                } else {
                    f7Param.setOnlySelLeaf(true);
                    f7Param.setShowDisableVisible(false);
                }
                NewF7Utils.openF7((BeforeF7SelectEvent)e, (MemberF7Parameter)f7Param);
            }
        } else if (BD_DIMENSION.equals(key)) {
            this.dimensionSelect(e);
        } else if (BD_VARIABLE.equals(key)) {
            this.variableSelect(e);
        }
    }

    private void dimensionSelect(BeforeF7SelectEvent e) {
        if (!TemplateVarCommonUtil.checkIsVar((String)"isNeedVar", (String)"").booleanValue()) {
            return;
        }
        ListShowParameter showParameter = (ListShowParameter)e.getFormShowParameter();
        List filters = showParameter.getListFilterParameter().getQFilters();
        QFilter qFilter = new QFilter("model.id", "=", (Object)this.getModelId());
        HashSet<Long> dimensionIds = new HashSet<Long>(16);
        String selects = "id, dimension.id";
        DynamicObjectCollection variableDimension = QueryServiceHelper.query((String)"eb_dimensionvariable", (String)selects, (QFilter[])new QFilter[]{qFilter});
        if (variableDimension != null) {
            for (DynamicObject variable : variableDimension) {
                dimensionIds.add(variable.getLong("dimension.id"));
            }
        }
        HashSet dimensionId_new = new HashSet(16);
        DynamicObjectCollection bizModel = QueryServiceHelper.query((String)"eb_businessmodel", (String)"viewentry.dimension.id", (QFilter[])new QFilter[]{qFilter, new QFilter("id", "=", (Object)this.getBizModelId())});
        if (bizModel != null) {
            HashSet<Long> finalDimensionIds = dimensionIds;
            bizModel.forEach(p -> {
                long dimensionId = p.getLong("viewentry.dimension.id");
                if (finalDimensionIds.contains(dimensionId)) {
                    dimensionId_new.add(dimensionId);
                }
            });
            dimensionIds = dimensionId_new;
        }
        filters.add(new QFilter("id", "in", dimensionIds));
        e.setFormShowParameter((FormShowParameter)showParameter);
    }

    private void variableSelect(BeforeF7SelectEvent e) {
        if (!TemplateVarCommonUtil.checkIsVar((String)"isNeedVar", (String)"").booleanValue()) {
            return;
        }
        ListShowParameter showParameter = (ListShowParameter)e.getFormShowParameter();
        List filters = showParameter.getListFilterParameter().getQFilters();
        QFilter qFilter = new QFilter("model.id", "=", (Object)this.getModelId());
        EntryGrid entryGrid = (EntryGrid)this.getControl(ENTRY_VAR);
        int[] rows = entryGrid.getSelectRows();
        DynamicObject dimension = (DynamicObject)this.getModel().getValue(BD_DIMENSION, rows[0]);
        if (dimension == null) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u7ef4\u5ea6\u3002", (String)"ReportSchemeEditPlugin_9", (String)"epm-eb-formplugin", (Object[])new Object[0]));
            e.setCancel(Boolean.TRUE.booleanValue());
            return;
        }
        if (SysDimensionEnum.BudgetPeriod.getNumber().equals(dimension.getString("number"))) {
            qFilter.and(new QFilter("grouptype", "!=", (Object)"2").or("number", "=", (Object)"@BaseY"));
        }
        qFilter.and(new QFilter("dimension.id", "=", (Object)dimension.getLong("id")));
        HashSet<Long> variableIds = new HashSet<Long>(16);
        int maxSize = entryGrid.getEntryData().getEndIndex();
        for (int i = 0; i < maxSize; ++i) {
            DynamicObject variable;
            if (i == rows[0] || (variable = (DynamicObject)this.getModel().getValue(BD_VARIABLE, i)) == null) continue;
            variableIds.add(variable.getLong("id"));
        }
        if (variableIds.size() > 0) {
            qFilter.and(new QFilter("id", "not in", variableIds));
        }
        qFilter.and(new QFilter("grouptype", "!=", (Object)"2").or("number", "=", (Object)"@BaseY"));
        filters.add(qFilter);
        showParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, "variableSelect"));
        showParameter.setMultiSelect(true);
        e.setFormShowParameter((FormShowParameter)showParameter);
    }

    protected String getDimNumber(String propertyKey) {
        if (YEAR.equals(propertyKey)) {
            return SysDimensionEnum.BudgetPeriod.getNumber();
        }
        return SysDimensionEnum.getNumberByLowerCaseNumber((String)propertyKey);
    }

    public void itemClick(ItemClickEvent evt) {
        super.itemClick(evt);
        String key = evt.getItemKey();
        if (BTN_OK.equals(key)) {
            this.assign();
            UserRememberService.getInstance().deleteUserRemember(null, ApplicationTypeEnum.BGM.getIndex() + '`' + "bgm_rptpreparation" + "`" + this.getModelId());
        }
    }

    private void assign() {
        DynamicObject year = (DynamicObject)this.getModel().getValue(YEAR);
        DynamicObject version = (DynamicObject)this.getModel().getValue(VERSION);
        DynamicObject datatype = (DynamicObject)this.getModel().getValue(DATATYPE);
        DynamicObjectCollection dynamicObjects = this.getModel().getEntryEntity(ENTRYENTITY);
        HashMap<Long, Long> schemeBizmMap = new HashMap<Long, Long>(16);
        HashMap<Long, String> schemeApsMap = new HashMap<Long, String>(16);
        HashSet<Long> schemeIds = new HashSet<Long>(16);
        HashMap<Long, DynamicObject> schemeDynamicObjectMap = new HashMap<Long, DynamicObject>(16);
        for (DynamicObject dynamicObject : dynamicObjects) {
            schemeBizmMap.put(dynamicObject.getDynamicObject(SCHEME).getLong("id"), dynamicObject.getDynamicObject(BIZRANGE).getLong("id"));
            schemeApsMap.put(dynamicObject.getDynamicObject(SCHEME).getLong("id"), dynamicObject.getString(APPLYSCOPE));
            schemeIds.add(dynamicObject.getDynamicObject(SCHEME).getLong("id"));
            schemeDynamicObjectMap.put(dynamicObject.getDynamicObject(SCHEME).getLong("id"), dynamicObject);
        }
        long yearId = year.getLong("id");
        long versionId = version.getLong("id");
        long dataTypeId = datatype.getLong("id");
        String versionName = version.getString("name");
        String datatypeName = datatype.getString("name");
        Map<String, List<Long>> templateMap = this.getTemplateBySchemeIds(new ArrayList<Long>(schemeBizmMap.keySet()));
        List<Long> schemeSet = this.getSchemesGroup(year.getLong("id"), version.getLong("id"), datatype.getLong("id"));
        if (this.isExistSameAssign(templateMap.get("apply"), schemeSet).booleanValue()) {
            return;
        }
        if (!this.checkAssignCondition(schemeIds, versionId, versionName, dataTypeId, datatypeName)) {
            return;
        }
        Map<String, Map<Long, Long>> map = this.filterSaveData(schemeIds, schemeBizmMap, yearId, versionId, dataTypeId);
        try {
            if (!schemeBizmMap.isEmpty()) {
                Map<Long, Long> schemeAssignMap = this.saveRecord(yearId, versionId, dataTypeId, map, schemeApsMap);
                this.saveSchemeVarInfo(schemeAssignMap);
                this.createReportProcess(yearId, versionId, dataTypeId, schemeAssignMap, schemeDynamicObjectMap);
                this.copySchemeTemplateSortToAssign(schemeAssignMap);
            }
        }
        catch (Exception e) {
            log.error((Throwable)e);
            if (e instanceof KDBizException) {
                throw e;
            }
            throw new KDBizException(ResManager.loadResFormat((String)"\u4e0b\u8fbe\u53d1\u751f\u5f02\u5e38\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u67e5\u770b\u65e5\u5fd7\u3002Trace ID\uff1a%1\u3002", (String)"ReportSchemeAssignPlugin_38", (String)"epm-eb-formplugin", (Object[])new Object[]{RequestContext.get().getTraceId()}));
        }
        HashSet templateIds = new HashSet(16);
        templateMap.values().forEach(x -> templateIds.addAll(x));
        String traceId = RequestContext.getOrCreate().getTraceId();
        Optional first = schemeBizmMap.values().stream().findFirst();
        Long bizmodelId = 0L;
        if (first.isPresent()) {
            bizmodelId = (Long)first.get();
        }
        Long finalBizmodelId = bizmodelId;
        EpmThreadPools.CommPools.execute(() -> {
            RequestContext.getOrCreate().setTraceId(traceId);
            RuleRelationService.getInstance().reassignRuleToTemplateIds(this.getModelId(), templateIds, finalBizmodelId.longValue());
        });
        this.getView().returnDataToParent((Object)ResManager.loadKDString((String)"\u4e0b\u8fbe\u6210\u529f\u3002", (String)"ReportSchemeAssignPlugin_15", (String)"epm-eb-formplugin", (Object[])new Object[0]));
        this.getView().close();
    }

    private void copySchemeTemplateSortToAssign(Map<Long, Long> schemeAssignMap) {
        if (schemeAssignMap == null || schemeAssignMap.size() == 0) {
            return;
        }
        for (Map.Entry<Long, Long> entry : schemeAssignMap.entrySet()) {
            ReportSchemeTemplateSortService.getInstance().copyTemplateSort(entry.getKey(), entry.getValue());
        }
    }

    private Map<String, Map<Long, Long>> filterSaveData(Set<Long> schemeIds, Map<Long, Long> schemeBizmMap, long yearId, long versionId, long datatypeId) {
        HashMap<String, Map<Long, Long>> result = new HashMap<String, Map<Long, Long>>(16);
        HashMap newData = new HashMap(16);
        HashMap oldData = new HashMap(16);
        if (schemeIds.isEmpty()) {
            result.put("newData", schemeBizmMap);
            result.put("oldData", oldData);
            return result;
        }
        HashSet ids = new HashSet(16);
        QFilter qFilter = new QFilter(SCHEME, "in", schemeIds);
        qFilter.and(YEAR, "=", (Object)yearId);
        qFilter.and(VERSION, "=", (Object)versionId);
        qFilter.and(DATATYPE, "=", (Object)datatypeId);
        qFilter.and(MODEL, "=", (Object)this.getModelId());
        DynamicObjectCollection dynamicObjectCollection = QueryServiceHelper.query((String)"eb_schemeassign", (String)"id, scheme, bizrange", (QFilter[])qFilter.toArray());
        HashMap schemeAndAssign = new HashMap(16);
        HashMap schemeAndBiz = new HashMap(16);
        dynamicObjectCollection.forEach(e -> {
            schemeAndAssign.put(e.getLong(SCHEME), e.getLong("id"));
            schemeAndBiz.put(e.getLong(SCHEME), e.getLong(BIZRANGE));
        });
        schemeBizmMap.forEach((k, v) -> {
            if (schemeAndAssign.containsKey(k)) {
                ids.add(schemeAndAssign.get(k));
                oldData.put(k, schemeAndAssign.get(k));
            } else {
                newData.put(k, v);
            }
        });
        if (!ids.isEmpty()) {
            OrmLocaleValue description = (OrmLocaleValue)this.getModel().getValue("description");
            String schemetext = (String)this.getModel().getValue(SCHEME_TEXT);
            ReportSchemeAssignService.getInstance().updateModifyMsg(ids, description, schemetext);
        }
        result.put("newData", newData);
        result.put("oldData", oldData);
        return result;
    }

    private Map<Long, Long> createSchemeAssignMap(Object[] schemeObjs) {
        HashMap<Long, Long> schemeAssignMap = new HashMap<Long, Long>(16);
        if (schemeObjs == null || schemeObjs.length == 0) {
            return schemeAssignMap;
        }
        for (Object object : schemeObjs) {
            DynamicObject dynamicObject = (DynamicObject)object;
            schemeAssignMap.put(dynamicObject.getLong(SCHEME), dynamicObject.getLong("id"));
        }
        return schemeAssignMap;
    }

    private Map<Long, Long> createSchemeViewMap() {
        HashMap<Long, Long> schemeViewMap = new HashMap<Long, Long>(16);
        DynamicObjectCollection dynamicObjects = this.getModel().getEntryEntity(ENTRYENTITY);
        for (DynamicObject dynamicObject : dynamicObjects) {
            long schemeId = dynamicObject.getDynamicObject(SCHEME).getLong("id");
            schemeViewMap.put(schemeId, dynamicObject.getDynamicObject(SCHEME).getLong("orgview.id"));
        }
        return schemeViewMap;
    }

    private DynamicObjectCollection queryTemplateOrgRecord(Set<Long> schemeIdSet) {
        QFilter qFilter = new QFilter(SCHEME, "in", schemeIdSet);
        qFilter.and(new QFilter("templatetype", "=", (Object)"0").or(new QFilter("templatetype", "=", (Object)" ")));
        return QueryServiceHelper.query((String)"eb_templateorg", (String)"id,scheme.id,template.id,org.id,orgrange", (QFilter[])new QFilter[]{qFilter});
    }

    private void createReportProcess(Long yearId, Long versionId, Long dataTypeId, Map<Long, Long> schemeAssignMap, Map<Long, DynamicObject> schemeDynamicObjectMap) {
        Map<Long, Long> schemeViewMap = this.createSchemeViewMap();
        Set<Long> schemeIdSet = schemeAssignMap.keySet();
        Long modelId = this.getModelId();
        DynamicObjectCollection dynamicObjects = this.queryTemplateOrgRecord(schemeIdSet);
        if (kd.epm.eb.common.utils.CollectionUtils.isEmpty((Collection)dynamicObjects)) {
            return;
        }
        List recordIdList = dynamicObjects.stream().map(x -> x.getLong("id")).collect(Collectors.toList());
        Map recordDeleteEntity = SchemeRecordDeleteEntityHelper.queryDeleteEntityByRecordId(recordIdList);
        ArrayList<BaseRptProcessRequest> saveRptProcessRequestList = new ArrayList<BaseRptProcessRequest>(16);
        HashMap<Long, List> viewTemplateEntityDtoListMap = new HashMap<Long, List>(16);
        HashMap<Long, List> schemeEntityListMap = new HashMap<Long, List>(16);
        LinkedHashMap memberRefMap = Maps.newLinkedHashMap();
        IModelCacheHelper modelCache = ModelCacheContext.getOrCreate((Long)this.getModelId());
        for (DynamicObject dynamicObject : dynamicObjects) {
            Iterator templateid = dynamicObject.getLong("template.id");
            Long orgid = dynamicObject.getLong("org.id");
            Long schemeid = dynamicObject.getLong("scheme.id");
            Integer orgrange = dynamicObject.getInt("orgrange");
            Long viewId = schemeViewMap.get(schemeid);
            if (IDUtils.isEmptyLong(templateid).booleanValue() || IDUtils.isEmptyLong((Long)orgid).booleanValue() || IDUtils.isEmptyLong((Long)viewId).booleanValue()) continue;
            TemplateEntityDto templateEntityDto = new TemplateEntityDto(templateid, orgid, orgrange);
            templateEntityDto.setDeleteEntity((Set)recordDeleteEntity.get(dynamicObject.getLong("id")));
            List templateEntityDtoList = viewTemplateEntityDtoListMap.computeIfAbsent(viewId, t -> new ArrayList(16));
            templateEntityDtoList.add(templateEntityDto);
            List shcemeEntityList = schemeEntityListMap.computeIfAbsent(schemeid, t -> new ArrayList(10));
            shcemeEntityList.add(templateEntityDto);
        }
        for (Map.Entry entry : schemeEntityListMap.entrySet()) {
            Long schemeId = (Long)entry.getKey();
            List shcemeEntityList = (List)entry.getValue();
            HashSet<Member> memberSet = new HashSet<Member>(16);
            ArrayList<String> msgs = new ArrayList<String>(shcemeEntityList.size());
            for (TemplateEntityDto templateEntityDto : shcemeEntityList) {
                Set memberRefSet = memberRefMap.computeIfAbsent(templateEntityDto.getTemplateId(), f -> Sets.newLinkedHashSet());
                List members = MemberHelper.getEntityMemberByView((IModelCacheHelper)modelCache, (Long)schemeViewMap.get(schemeId), (Long)templateEntityDto.getEntityId(), (Integer)templateEntityDto.getEntityRange());
                if (members.isEmpty()) {
                    Member member = modelCache.getMember("Entity", schemeViewMap.get(schemeId), templateEntityDto.getEntityId());
                    RangeEnum range = RangeEnum.getRangeByVal((int)templateEntityDto.getEntityRange());
                    if (member != null) {
                        msgs.add(ResManager.loadResFormat((String)"\"%1\"\u7ec4\u7ec7\"%2\"\u6ca1\u6709\u542f\u7528\u7684\u6210\u5458", (String)"ReportSchemeAssignPlugin_39", (String)"epm-eb-formplugin", (Object[])new Object[]{member.getName(), range.getName()}));
                    }
                }
                for (Member member1 : members) {
                    if (member1.isDisable()) continue;
                    Set deleteEntity = templateEntityDto.getDeleteEntity();
                    if (kd.epm.eb.common.utils.CollectionUtils.isNotEmpty((Collection)deleteEntity)) {
                        if (deleteEntity.contains(member1.getId())) continue;
                        memberSet.add(member1);
                        memberRefSet.add(member1.getId());
                        continue;
                    }
                    memberSet.add(member1);
                    memberRefSet.add(member1.getId());
                }
            }
            if (!kd.epm.eb.common.utils.CollectionUtils.isEmpty(memberSet)) continue;
            msgs.add(ResManager.loadResFormat((String)"\u65b9\u6848%1\u6ca1\u6709\u542f\u7528\u7684\u7ec4\u7ec7\u6210\u5458\uff0c\u4e0d\u5141\u8bb8\u4e0b\u8fbe\u3002", (String)"ReportSchemeAssignPlugin_24", (String)"epm-eb-formplugin", (Object[])new Object[]{schemeDynamicObjectMap.get(schemeId).getDynamicObject(SCHEME).getString("name")}));
            throw new KDBizException(kd.epm.eb.common.utils.StringUtils.join(msgs, (char)','));
        }
        for (Map.Entry entry : viewTemplateEntityDtoListMap.entrySet()) {
            Long viewId = (Long)entry.getKey();
            List value = (List)entry.getValue();
            BaseRptProcessRequest saveRptProcessRequest = new BaseRptProcessRequest(modelId, viewId, yearId, dataTypeId, versionId, value);
            saveRptProcessRequestList.add(saveRptProcessRequest);
        }
        ReportProcessConfig config = new ReportProcessConfig();
        config.setTemplateOrgIds((Map)memberRefMap);
        reportProcessAggService.saveReportProcess(saveRptProcessRequestList, modelId, config);
    }

    private boolean checkAssignCondition(Set<Long> schemeIds, long versionId, String versionName, long dataTypeId, String dataTypeName) {
        ArrayList yearValidMsg = new ArrayList(16);
        ArrayList<String> errorMsg = new ArrayList<String>(16);
        HashMap<Long, ITemplateModel> templateModelMap = new HashMap<Long, ITemplateModel>(16);
        Map<String, Map<String, String>> currentVarValues = this.getCurrentVarValues();
        SqlBuilder sqlBuilder = new SqlBuilder();
        sqlBuilder.append("select ftemplateid, fschemeid from t_eb_templateorg where ftemplatetype = '0' and ", new Object[0]);
        sqlBuilder.appendIn(" fschemeid ", schemeIds.toArray());
        sqlBuilder.append(" group by ftemplateid, fschemeid", new Object[0]);
        HashSet<Long> templateList = new HashSet<Long>(16);
        DataSet ds = DB.queryDataSet((String)"reportSchemeAssignCheck", (DBRoute)DBRoute.of((String)"epm"), (SqlBuilder)sqlBuilder);
        Object object = null;
        try {
            if (ds != null) {
                while (ds.hasNext()) {
                    Row row = ds.next();
                    templateList.add(row.getLong("ftemplateid"));
                }
            }
        }
        catch (Throwable row) {
            object = row;
            throw row;
        }
        finally {
            if (ds != null) {
                if (object != null) {
                    try {
                        ds.close();
                    }
                    catch (Throwable row) {
                        ((Throwable)object).addSuppressed(row);
                    }
                } else {
                    ds.close();
                }
            }
        }
        DynamicObjectCollection templateObjList = QueryServiceHelper.query((String)"eb_templateentity", (String)"id,number,name,model.id,dataset.id, varbaseforeb, data", (QFilter[])new QFilter[]{new QFilter("id", "in", templateList)});
        for (DynamicObject templateObj : templateObjList) {
            Set memberIdSet;
            Set pageDataTypeMemberSet;
            Set memberIdSet2;
            Set pageVersionMemberSet;
            long templateId = templateObj.getLong("id");
            String templateData = templateObj.getString("data");
            String templateName = templateObj.getString("name");
            boolean isExistVar = "1".equals(templateObj.getString("varbaseforeb"));
            ITemplateModel templateModel = (ITemplateModel)templateModelMap.get(templateId);
            if (templateModel != null || (templateModel = TemplateModelJSONUtil.parseITemplateModel((String)templateData)) == null) continue;
            templateModelMap.put(templateId, templateModel);
            BgTemplate bgTemplate = templateModel.getTemplateBaseInfo();
            if (bgTemplate == null) {
                bgTemplate = new BgTemplate();
                templateModel.setTemplateBaseInfo(bgTemplate);
            }
            bgTemplate.setId(Long.valueOf(templateObj.getLong("id")));
            bgTemplate.setModelID(Long.valueOf(templateObj.getLong("model.id")));
            bgTemplate.setDatasetID(Long.valueOf(templateObj.getLong("dataset.id")));
            bgTemplate.setNumber(templateObj.getString("number"));
            bgTemplate.setName(templateObj.getString("name"));
            Map<String, String> yearVarValues = currentVarValues.get(SysDimensionEnum.BudgetPeriod.getNumber());
            if (yearVarValues != null && yearVarValues.size() > 0 && isExistVar) {
                HashMap templateVarInfo = new HashMap(16);
                TemplateVarCommonUtil.getVarDimFromTemplateData((ITemplateModel)templateModel, templateVarInfo, (boolean)false);
                List formulaVar = ReportVarUtil.checkYearVarHasFomula(templateVarInfo);
                if (CollectionUtils.isNotEmpty((Collection)formulaVar)) {
                    yearValidMsg.addAll(ReportVarUtil.getNoValiadPeriodVar((Long)this.getModelId(), (String)templateName, (List)formulaVar, yearVarValues));
                }
            }
            if (kd.epm.eb.common.utils.CollectionUtils.isNotEmpty((Collection)(pageVersionMemberSet = TemplateModelHelper.getPageMembersFromEBTemplate((Long)this.getModelId(), (Long)templateId, (ITemplateModel)templateModel, (String)SysDimensionEnum.Version.getNumber(), currentVarValues))) && !(memberIdSet2 = pageVersionMemberSet.stream().map(IBaseEntry::getId).collect(Collectors.toSet())).contains(versionId)) {
                errorMsg.add(ResManager.loadResFormat((String)"\u7248\u672c\uff1a%1\uff0c\u4e0d\u5728\u6a21\u677f%2\u8303\u56f4\u5185\u3002", (String)"ReportSchemeAssignPlugin_12", (String)"epm-eb-formplugin", (Object[])new Object[]{versionName, templateName}));
            }
            if (!kd.epm.eb.common.utils.CollectionUtils.isNotEmpty((Collection)(pageDataTypeMemberSet = TemplateModelHelper.getPageMembersFromEBTemplate((Long)this.getModelId(), (Long)templateId, (ITemplateModel)templateModel, (String)SysDimensionEnum.DataType.getNumber(), currentVarValues))) || (memberIdSet = pageDataTypeMemberSet.stream().map(IBaseEntry::getId).collect(Collectors.toSet())).contains(dataTypeId)) continue;
            errorMsg.add(ResManager.loadResFormat((String)"\u6570\u636e\u7c7b\u578b\uff1a%1\uff0c\u4e0d\u5728\u6a21\u677f\"%2\"\u8303\u56f4\u5185\u3002", (String)"ReportSchemeAssignPlugin_13", (String)"epm-eb-formplugin", (Object[])new Object[]{dataTypeName, templateName}));
        }
        if (kd.epm.eb.common.utils.CollectionUtils.isNotEmpty(yearValidMsg)) {
            this.getView().showErrorNotification(((Object)yearValidMsg).toString());
            return false;
        }
        if (kd.epm.eb.common.utils.CollectionUtils.isNotEmpty(errorMsg)) {
            this.getView().showMessage(ResManager.loadKDString((String)"\u4e0b\u8fbe\u6570\u636e\u4e0d\u5728\u7f16\u5236\u8868\u7684\u8303\u56f4\u5185\uff0c\u8bf7\u68c0\u67e5\u7f16\u5236\u6a21\u677f\u3002", (String)"ReportSchemeAssignPlugin_11", (String)"epm-eb-formplugin", (Object[])new Object[0]), String.join((CharSequence)"\n", errorMsg), null);
            return false;
        }
        return this.checkVarInfo(schemeIds);
    }

    private Map<String, Map<String, String>> getCurrentVarValues() {
        DynamicObjectCollection entryEntity = this.getModel().getEntryEntity(ENTRY_VAR);
        if (kd.epm.eb.common.utils.CollectionUtils.isEmpty((Collection)entryEntity)) {
            return new HashMap<String, Map<String, String>>(0);
        }
        HashMap<String, Map<String, String>> returnMap = new HashMap<String, Map<String, String>>(16);
        for (DynamicObject object : entryEntity) {
            String json = object.getString(VARIABLE_JSON);
            String dimNum = object.getDynamicObject(BD_DIMENSION).getString("number");
            String varNum = object.getDynamicObject(BD_VARIABLE).getString("number");
            String varName = object.getDynamicObject(BD_VARIABLE).getString("name");
            String varInfo = varNum + "!" + varName;
            Map valueMap = (Map)SerializationUtils.fromJsonString((String)json, Map.class);
            HashMap<String, String> varValue = (HashMap<String, String>)returnMap.get(dimNum);
            if (varValue == null) {
                varValue = new HashMap<String, String>(16);
                varValue.put(varInfo, valueMap.get("number").toString());
                returnMap.put(dimNum, varValue);
                continue;
            }
            varValue.put(varInfo, valueMap.get("number").toString());
        }
        return returnMap;
    }

    @Override
    public void beforeItemClick(BeforeItemClickEvent evt) {
        super.beforeItemClick(evt);
        String key = evt.getItemKey();
        if (BTN_OK.equals(key)) {
            DynamicObject model = (DynamicObject)this.getModel().getValue(MODEL);
            if (model == null) {
                this.getView().showErrorNotification(ResManager.loadKDString((String)"\u4f53\u7cfb\u4e0d\u5b58\u5728\u3002", (String)"ReportSchemeAssignPlugin_4", (String)"epm-eb-formplugin", (Object[])new Object[0]));
                evt.setCancel(true);
                return;
            }
            DynamicObject year = (DynamicObject)this.getModel().getValue(YEAR);
            if (year == null) {
                this.getView().showErrorNotification(ResManager.loadKDString((String)"\u8d22\u5e74\u672a\u586b\u5199\u3002", (String)"ReportSchemeAssignPlugin_5", (String)"epm-eb-formplugin", (Object[])new Object[0]));
                evt.setCancel(true);
                return;
            }
            DynamicObject version = (DynamicObject)this.getModel().getValue(VERSION);
            if (version == null) {
                this.getView().showErrorNotification(ResManager.loadKDString((String)"\u7248\u672c\u672a\u586b\u5199\u3002", (String)"ReportSchemeAssignPlugin_6", (String)"epm-eb-formplugin", (Object[])new Object[0]));
                evt.setCancel(true);
                return;
            }
            DynamicObject datatype = (DynamicObject)this.getModel().getValue(DATATYPE);
            if (datatype == null) {
                this.getView().showErrorNotification(ResManager.loadKDString((String)"\u6570\u636e\u7c7b\u578b\u672a\u586b\u5199\u3002", (String)"ReportSchemeAssignPlugin_7", (String)"epm-eb-formplugin", (Object[])new Object[0]));
                evt.setCancel(true);
                return;
            }
            DynamicObjectCollection entry = this.getModel().getEntryEntity(ENTRYENTITY);
            if (entry == null || entry.size() == 0) {
                this.getView().showErrorNotification(ResManager.loadKDString((String)"\u65b9\u6848\u8bfb\u53d6\u5931\u8d25\u3002", (String)"ReportSchemeAssignPlugin_8", (String)"epm-eb-formplugin", (Object[])new Object[0]));
                evt.setCancel(true);
                return;
            }
            DynamicObjectCollection varEntry = this.getModel().getEntryEntity(ENTRY_VAR);
            if (kd.epm.eb.common.utils.CollectionUtils.isNotEmpty((Collection)varEntry)) {
                for (DynamicObject object : varEntry) {
                    if (!kd.epm.eb.common.utils.StringUtils.isEmpty((String)object.getString(VARIABLE_VALUE))) continue;
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u586b\u5199\u53d8\u91cf\u503c\u4fe1\u606f\u3002", (String)"ReportSchemeAssignPlugin_34", (String)"epm-eb-formplugin", (Object[])new Object[0]));
                    evt.setCancel(true);
                    return;
                }
            }
        }
    }

    private Map<Long, Long> saveRecord(Long yearId, Long versionId, Long datatypeId, Map<String, Map<Long, Long>> map, Map<Long, String> schemeApsMap) {
        DynamicObject model = (DynamicObject)this.getModel().getValue(MODEL);
        if (model == null) {
            throw new KDBizException("model is null");
        }
        Map<Long, Long> schemeBizmMap = map.get("newData");
        Map<Long, Long> oldData = map.get("oldData");
        Long modelId = model.getLong("id");
        ArrayList<TebSchemeAssign> list = new ArrayList<TebSchemeAssign>(schemeBizmMap.size());
        Long userId = this.getUserId();
        Date time = TimeServiceHelper.now();
        int seq = ReportSchemeAssignService.getInstance().getMaxSeq(modelId);
        OrmLocaleValue description = (OrmLocaleValue)this.getModel().getValue("description");
        String name = (String)this.getModel().getValue(SCHEME_TEXT);
        for (Map.Entry<Long, Long> entry : schemeBizmMap.entrySet()) {
            Long key = entry.getKey();
            String applyScope = schemeApsMap.get(key);
            TebSchemeAssign obj = new TebSchemeAssign(key, yearId, datatypeId, versionId, userId, modelId, entry.getValue(), ++seq, time, applyScope, description, name);
            obj.setCreatedate(time);
            list.add(obj);
        }
        if (!oldData.isEmpty()) {
            DynamicObject[] ids = BusinessDataServiceHelper.load((String)"eb_schemeassign", (String)"id,scheme,applyscope", (QFilter[])new QFilter[]{new QFilter("id", "in", oldData.values())});
            if (ids != null && ids.length > 0) {
                for (DynamicObject id : ids) {
                    String applyscope = schemeApsMap.get(id.getLong("scheme.id"));
                    if (!kd.epm.eb.common.utils.StringUtils.isNotEmpty((String)applyscope)) continue;
                    id.set(APPLYSCOPE, (Object)applyscope);
                }
            }
            SaveServiceHelper.save((DynamicObject[])ids);
        }
        Object[] objects = ReportSchemeAssignService.getInstance().saveAssignRecord(list);
        Map<Long, Long> map2 = this.createSchemeAssignMap(objects);
        map2.putAll(oldData);
        return map2;
    }

    public String getCurrentDimNumber(String controlKey) {
        return null;
    }

    @Override
    public Long getModelId() {
        DynamicObject value = (DynamicObject)this.getModel().getValue(MODEL);
        if (value == null) {
            return 0L;
        }
        return value.getLong("id");
    }

    private Boolean isExistSameAssign(List<Long> templateSet, List<Long> schemeSet) {
        DynamicObjectCollection dynamicObjects = ReportSchemeService.getInstance().queryRecordBySchemeAndTemplate(schemeSet, templateSet);
        if (dynamicObjects.size() != 0) {
            for (DynamicObject dynamicObject : dynamicObjects) {
                long templateId = dynamicObject.getLong("applytemplate");
                String templateName = dynamicObject.getString("applytemplate.name");
                String schemeName = dynamicObject.getString("scheme.name");
                if (!templateSet.contains(templateId)) continue;
                DynamicObject year = (DynamicObject)this.getModel().getValue(YEAR);
                DynamicObject version = (DynamicObject)this.getModel().getValue(VERSION);
                DynamicObject datatype = (DynamicObject)this.getModel().getValue(DATATYPE);
                this.getView().showTipNotification(ResManager.loadResFormat((String)"\u6a21\u677f\u201c%1\u201d\u5728\u65b9\u6848\u201c%2\u201d\u4e2d\u4e0b\u8fbe\u5230%3-%4-%5\uff0c\u8bf7\u91cd\u65b0\u8bbe\u7f6e\u65b9\u6848\u7684\u6a21\u677f\u8303\u56f4\u3002", (String)"ReportSchemeAssignPlugin_16", (String)"epm-eb-formplugin", (Object[])new Object[]{templateName, schemeName, year.get("name"), version.get("name"), datatype.get("name")}));
                return true;
            }
        }
        return false;
    }

    private Map<String, List<Long>> getTemplateBySchemeIds(List<Long> schemeIds) {
        HashMap<String, List<Long>> templateMap = new HashMap<String, List<Long>>(16);
        DynamicObjectCollection dynamicObjects = ReportSchemeService.getInstance().queryTemplateBySchemeIds(schemeIds);
        ArrayList<Long> applyTemplateList = new ArrayList<Long>(16);
        ArrayList<Long> budgetTemplateList = new ArrayList<Long>(16);
        if (dynamicObjects != null) {
            for (DynamicObject dynamicObject : dynamicObjects) {
                String templateType = dynamicObject.getString("templatetype");
                if (kd.epm.eb.common.utils.StringUtils.isEmpty((String)templateType)) {
                    templateType = "0";
                }
                if ("0".equals(templateType)) {
                    budgetTemplateList.add(dynamicObject.getLong("template"));
                    continue;
                }
                if (!"1".equals(templateType)) continue;
                applyTemplateList.add(dynamicObject.getLong("applytemplate"));
            }
        }
        templateMap.put("apply", applyTemplateList);
        templateMap.put("budget", budgetTemplateList);
        return templateMap;
    }

    private List<Long> getSchemesGroup(long year, long version, long datatype) {
        DynamicObjectCollection schemeObjects = ReportSchemeAssignService.getInstance().querySchemesGroup(Long.valueOf(year), Long.valueOf(version), Long.valueOf(datatype), this.getModelId());
        Set<Long> selReportSchemeIds = this.getSelReportSchemeIds();
        HashSet<Long> schemeSet = new HashSet<Long>(16);
        for (DynamicObject dynamicObject : schemeObjects) {
            Long schemeId = dynamicObject.getLong(SCHEME);
            if (selReportSchemeIds.contains(schemeId)) continue;
            schemeSet.add(schemeId);
        }
        return new ArrayList<Long>(schemeSet);
    }

    public void click(EventObject evt) {
        super.click(evt);
        String itemKey = ((Control)evt.getSource()).getKey();
        if (VARIABLE_VALUE.equals(itemKey)) {
            this.variableValueClick();
        } else if (ADD_VAR.equals(itemKey)) {
            this.addVarRow();
        } else if (DEL_VAR.equals(itemKey)) {
            this.delVarRow();
        }
    }

    private void addVarRow() {
        this.getModel().createNewEntryRow(ENTRY_VAR);
    }

    private void delVarRow() {
        EntryGrid entryGrid = (EntryGrid)this.getControl(ENTRY_VAR);
        int[] selectRows = entryGrid.getSelectRows();
        if (selectRows == null || selectRows.length == 0) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u4e00\u884c\u6570\u636e\u3002", (String)"ReportSchemeEditPlugin_10", (String)"epm-eb-formplugin", (Object[])new Object[0]));
            return;
        }
        this.getModel().deleteEntryRow(ENTRY_VAR, selectRows[0]);
        this.getView().updateView(ENTRY_VAR);
    }

    private void variableValueClick() {
        Long memberId;
        Map memberInfoMap;
        String memberJson;
        DynamicObject dimension = (DynamicObject)this.getModel().getValue(BD_DIMENSION);
        if (dimension == null) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u7ef4\u5ea6\u3002", (String)"ReportSchemeEditPlugin_9", (String)"epm-eb-formplugin", (Object[])new Object[0]));
            return;
        }
        CloseCallBack closeCallBack = new CloseCallBack((IFormPlugin)this, "selectMember");
        MemberF7Parameter f7Param = NewF7Utils.multipleF7((Long)this.getModelId(), (DynamicObject)NewF7Utils.getDimension((Long)dimension.getLong("id")), (String)ListSelectedRow.class.getName());
        f7Param.setBusModelId(this.getBizModelId());
        DynamicObject dynamicObject = (DynamicObject)this.getModel().getValue(BD_VARIABLE);
        if (dynamicObject == null) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u53d8\u91cf\u7f16\u7801\u3002", (String)"BizRuleVariablePlugin_4", (String)"epm-eb-formplugin", (Object[])new Object[0]));
            return;
        }
        String grouptype = dynamicObject.getString("grouptype");
        if ("2".equals(grouptype)) {
            f7Param.setCanSelectRoot(false);
            f7Param.addCustomCommFilter(new QFilter("level", "=", (Object)2));
        }
        if (SysDimensionEnum.BudgetPeriod.getNumber().equals(dimension.getString("number"))) {
            f7Param.setCanSelectBudgetPeriodRoot(false);
        }
        if (kd.epm.eb.common.utils.StringUtils.isNotEmpty((String)(memberJson = (String)this.getModel().getValue(VARIABLE_JSON))) && (memberInfoMap = (Map)SerializationUtils.fromJsonString((String)memberJson, Map.class)) != null && IDUtils.isNotNull((Long)(memberId = (Long)memberInfoMap.get("id")))) {
            f7Param.setSelectId(memberId);
            f7Param.setViewId(MapUtils.getLong((Map)memberInfoMap, (Object)"viewId", (Long)0L));
        }
        f7Param.setShowDisableVisible(false);
        f7Param.setEnableView(true);
        NewF7Utils.openF7((IFormView)this.getView(), (MemberF7Parameter)f7Param, (CloseCallBack)closeCallBack);
    }

    @Override
    public void closedCallBack(ClosedCallBackEvent evt) {
        super.closedCallBack(evt);
        String key = evt.getActionId();
        if ("selectMember".equals(key)) {
            EntryGrid entryGrid = (EntryGrid)this.getControl(ENTRY_VAR);
            int row = entryGrid.getSelectRows()[0];
            long dimId = ((DynamicObject)this.getModel().getValue(BD_DIMENSION, row)).getLong("id");
            ListSelectedRowCollection memberInfo = (ListSelectedRowCollection)evt.getReturnData();
            if (memberInfo == null) {
                return;
            }
            for (ListSelectedRow memberDetails : memberInfo) {
                DynamicObject dim = (DynamicObject)this.getModel().getValue(BD_DIMENSION, row);
                if (dim != null && dim.getLong("id") == dimId) {
                    Long viewId = MapUtils.getLong((Map)memberDetails.getDataMap(), (Object)"viewid", (Long)0L);
                    HashMap<String, Object> memberInfoMap = new HashMap<String, Object>(16);
                    memberInfoMap.put("id", memberDetails.getPrimaryKeyValue());
                    memberInfoMap.put("name", memberDetails.getName());
                    memberInfoMap.put("number", memberDetails.getNumber());
                    memberInfoMap.put("viewId", viewId);
                    String groupType = ((DynamicObject)this.getModel().getValue(BD_VARIABLE, row)).getString("grouptype");
                    if ("2".equals(groupType) && !"2".equals(memberDetails.getDataMap().get("level").toString())) continue;
                    this.getModel().setValue(VARIABLE_VALUE, (Object)memberDetails.getName(), row);
                    String memberJson = SerializationUtils.toJsonString(memberInfoMap);
                    this.getModel().setValue(VARIABLE_JSON, (Object)memberJson, row++);
                    continue;
                }
                break;
            }
        } else if ("variableSelect".equals(key)) {
            EntryGrid entryGrid = (EntryGrid)this.getControl(ENTRY_VAR);
            int row = entryGrid.getSelectRows()[0];
            long dimId = ((DynamicObject)this.getModel().getValue(BD_DIMENSION, row)).getLong("id");
            int maxRow = this.getModel().getEntryRowCount(ENTRY_VAR);
            ListSelectedRowCollection varInfo = (ListSelectedRowCollection)evt.getReturnData();
            if (varInfo == null) {
                return;
            }
            Object firstVar = null;
            Object memberName = this.getModel().getValue(VARIABLE_VALUE, row);
            Object memberJson = this.getModel().getValue(VARIABLE_JSON, row);
            int index = row;
            for (ListSelectedRow detail : varInfo) {
                if (index >= maxRow) {
                    this.getModel().createNewEntryRow(ENTRY_VAR);
                } else {
                    DynamicObject dim = (DynamicObject)this.getModel().getValue(BD_DIMENSION, index);
                    if (dim != null && dim.getLong("id") != dimId) break;
                }
                this.getModel().setValue(BD_DIMENSION, (Object)dimId, index);
                if (firstVar == null) {
                    firstVar = detail.getPrimaryKeyValue();
                }
                this.getModel().setValue(BD_VARIABLE, detail.getPrimaryKeyValue(), index++);
            }
            this.getModel().setValue(BD_VARIABLE, firstVar, row);
            this.getModel().setValue(VARIABLE_VALUE, memberName, row);
            this.getModel().setValue(VARIABLE_JSON, memberJson, row);
        }
    }

    private boolean checkVarInfo(Set<Long> schemeIds) {
        DynamicObjectCollection varEntryCollection = this.getModel().getEntryEntity(ENTRY_VAR);
        ArrayList templateIds = new ArrayList(16);
        HashSet applyTemplateIds = new HashSet(16);
        reportSchemeAssignService.getSchemeTemplateInfoMap(schemeIds, templateIds, applyTemplateIds);
        String checkInfo = TemplateVarUtil.checkVarInTemplate((BizModel)ModelUtils.getBizModel((Long)this.getModelId()), (DynamicObjectCollection)varEntryCollection, templateIds, applyTemplateIds);
        if (kd.epm.eb.common.utils.StringUtils.isNotEmpty((String)checkInfo)) {
            this.getView().showTipNotification(checkInfo);
            return false;
        }
        return true;
    }

    private void fillSchemeAssignDimInfo(List<String> schemeIds, List<Long> assignIds) {
        QFilter qFilter = new QFilter(MODEL, "=", (Object)this.getModelId());
        if (assignIds.isEmpty()) {
            qFilter.and(SCHEME, "in", (Object)IDUtils.toLongs(schemeIds));
        } else {
            qFilter.and("id", "in", assignIds);
        }
        DynamicObjectCollection query = QueryServiceHelper.query((String)"eb_schemeassign", (String)"scheme.name,year,datatype,version,description", (QFilter[])qFilter.toArray(), (String)"assigntime desc", (int)1);
        if (kd.epm.eb.common.utils.CollectionUtils.isNotEmpty((Collection)query)) {
            DynamicObject object = (DynamicObject)query.get(0);
            this.getModel().setValue(YEAR, (Object)object.getLong(YEAR));
            this.getModel().setValue(DATATYPE, (Object)object.getLong(DATATYPE));
            this.getModel().setValue(VERSION, (Object)object.getLong(VERSION));
            this.getModel().setValue("description", (Object)object.getString("description"));
        }
    }

    private void loadVariableEntry(List<String> schemeIds, List<Long> assignIds) {
        IDataModel model = this.getModel();
        model.deleteEntryData(ENTRY_VAR);
        if (kd.epm.eb.common.utils.CollectionUtils.isEmpty(schemeIds)) {
            return;
        }
        Map variableInfo = assignIds.isEmpty() ? reportSchemeAssignService.getSchemeVariableInfo(IDUtils.toLongs(schemeIds)) : reportSchemeAssignService.getSchemeVariableByAssignId(assignIds);
        HashMap<Long, Set<Long>> schemeIdRelTemplateIds = new HashMap<Long, Set<Long>>(16);
        HashMap<Long, Map<String, List<String>>> templateIdToVarInfoMap = new HashMap<Long, Map<String, List<String>>>(16);
        DynamicObjectCollection allocateRecord = QueryServiceHelper.query((String)"eb_templateorg", (String)"scheme,templatetype,template,applytemplate", (QFilter[])new QFilter(SCHEME, "in", (Object)IDUtils.toLongs(schemeIds)).toArray());
        Set templateIds = allocateRecord.stream().map(x -> {
            String templateType = x.getString("templatetype");
            if ("1".equals(templateType)) {
                return x.getLong("applytemplate");
            }
            return x.getLong("template");
        }).collect(Collectors.toSet());
        Map templateVarInfoInScheme = TemplateVarCommonUtil.getTemplateVarInfoInScheme(schemeIdRelTemplateIds, templateIdToVarInfoMap, (DynamicObjectCollection)allocateRecord);
        HashSet varNumbers = new HashSet(16);
        varNumbers.addAll(ExamineServiceImpl.getInstance().listExamineVarInfos(this.getModelId(), templateIds));
        for (List value : templateVarInfoInScheme.values()) {
            varNumbers.addAll(value);
        }
        Map variablesIdMap = TemplateVarCommonUtil.getVariablesId(varNumbers, (Long)this.getModelId());
        HashSet<Object> allVariable = new HashSet<Object>(16);
        allVariable.addAll(variableInfo.keySet());
        if (!variablesIdMap.isEmpty()) {
            allVariable.addAll(variablesIdMap.values());
        }
        if (allVariable.isEmpty()) {
            return;
        }
        IModelCacheHelper modelCacheHelper = this.getIModelCacheHelper();
        model.beginInit();
        model.deleteEntryData(ENTRY_VAR);
        int[] rows = model.batchCreateNewEntryRow(ENTRY_VAR, allVariable.size());
        int i = 0;
        for (Map.Entry entry : variablesIdMap.entrySet()) {
            String dimNum_varNum = (String)entry.getKey();
            Long varId = (Long)entry.getValue();
            String dimNum = dimNum_varNum.split("_")[0];
            Dimension dimension = modelCacheHelper.getDimension(dimNum);
            if (dimension == null) continue;
            model.setValue(BD_DIMENSION, (Object)dimension.getId(), rows[i]);
            model.setValue(BD_VARIABLE, (Object)varId, rows[i]);
            Map varInfo = (Map)variableInfo.get(varId);
            if (varInfo != null) {
                model.setValue(VARIABLE_VALUE, varInfo.get("variableValue"), rows[i]);
                model.setValue(VARIABLE_JSON, varInfo.get("variableJson"), rows[i]);
            }
            ++i;
        }
        for (Map.Entry entry : variableInfo.entrySet()) {
            if (variablesIdMap.values().contains(entry.getKey())) continue;
            model.setValue(BD_DIMENSION, ((Map)entry.getValue()).get(BD_DIMENSION), rows[i]);
            model.setValue(BD_VARIABLE, entry.getKey(), rows[i]);
            Map varInfo = (Map)entry.getValue();
            if (varInfo != null) {
                model.setValue(VARIABLE_VALUE, varInfo.get("variableValue"), rows[i]);
                model.setValue(VARIABLE_JSON, varInfo.get("variableJson"), rows[i]);
            }
            ++i;
        }
        model.endInit();
        this.getView().updateView(ENTRY_VAR);
        this.cacheSchemeVariableInfo(schemeIdRelTemplateIds, templateIdToVarInfoMap, variablesIdMap);
    }

    private void cacheSchemeVariableInfo(Map<Long, Set<Long>> schemeIdRelTemplateIds, Map<Long, Map<String, List<String>>> templateIdToVarInfoMap, Map<String, Long> variablesIdMap) {
        HashMap schemeIdToVarIds = new HashMap(schemeIdRelTemplateIds.size());
        for (Map.Entry<Long, Set<Long>> entryMap : schemeIdRelTemplateIds.entrySet()) {
            Long schemeId = entryMap.getKey();
            HashSet<Long> varIds = new HashSet<Long>(16);
            for (Long templateId : entryMap.getValue()) {
                Map<String, List<String>> dimVarInfoInfoMap = templateIdToVarInfoMap.get(templateId);
                if (dimVarInfoInfoMap == null) continue;
                for (Map.Entry<String, List<String>> dimVarInfo : dimVarInfoInfoMap.entrySet()) {
                    String dimNum = dimVarInfo.getKey();
                    List<String> varNums = dimVarInfo.getValue();
                    if (kd.epm.eb.common.utils.CollectionUtils.isEmpty(varNums)) continue;
                    for (String varNum : varNums) {
                        Long varId;
                        if (varNum.startsWith("@NextY") || varNum.startsWith("@BaseY") || varNum.startsWith("@LastY")) {
                            varNum = "@BaseY";
                        }
                        if (IDUtils.isEmptyLong((Long)(varId = variablesIdMap.get(dimNum + "_" + varNum))).booleanValue()) continue;
                        varIds.add(varId);
                    }
                }
            }
            schemeIdToVarIds.put(schemeId, varIds);
        }
        log.info("schemeIdRelTemplateIds:" + SerializationUtils.toJsonString(schemeIdRelTemplateIds));
        log.info("templateIdToVarInfoMap:" + SerializationUtils.toJsonString(templateIdToVarInfoMap));
        log.info("variablesIdMap:" + SerializationUtils.toJsonString(variablesIdMap));
        log.info("schemeIdToVarIds:" + SerializationUtils.toJsonString(schemeIdToVarIds));
        this.getPageCache().put("cache_schemeIdToVarIds", SerializationUtils.serializeToBase64(schemeIdToVarIds));
    }

    private void saveSchemeVarInfo(Map<Long, Long> schemeAssignMap) {
        if (kd.epm.eb.common.utils.CollectionUtils.isEmpty(schemeAssignMap)) {
            return;
        }
        Map<Long, Map<String, Object>> varIdToValueInfo = this.getVarIdToValueInfo();
        HashMap<Long, Set<Long>> schemeIdToVarIds = new HashMap<Long, Set<Long>>(schemeAssignMap.size());
        for (Map.Entry<Long, Long> entry : schemeAssignMap.entrySet()) {
            schemeIdToVarIds.put(entry.getKey(), varIdToValueInfo.keySet());
        }
        if (schemeIdToVarIds == null || schemeIdToVarIds.size() == 0) {
            return;
        }
        String delSql = "delete from t_eb_schemevariable where fid in (" + kd.epm.eb.common.utils.StringUtils.join((Object[])schemeAssignMap.values().toArray(), (String)",") + ")";
        String insertSql = "insert into t_eb_schemevariable(fid,fentryid,fseq,fdimension,fvariablenumber,fvariable,fvariablejsontext) values(?,?,?,?,?,?,?)";
        DB.execute((DBRoute)BgBaseConstant.epm, (String)delSql);
        List<Object[]> varObject = this.packageVarObject(schemeAssignMap, varIdToValueInfo, schemeIdToVarIds);
        if (kd.epm.eb.common.utils.CollectionUtils.isNotEmpty(varObject)) {
            DB.executeBatch((DBRoute)BgBaseConstant.epm, (String)insertSql, varObject);
        }
        this.addVarQuote(schemeIdToVarIds, varIdToValueInfo);
    }

    private void addVarQuote(Map<Long, Set<Long>> schemeIdToVarIds, Map<Long, Map<String, Object>> varIdToValueInfo) {
        DynamicObjectCollection entryEntity = this.getModel().getEntryEntity(ENTRY_VAR);
        if (entryEntity == null || entryEntity.isEmpty()) {
            DispatchServiceHelper.invokeBizService((String)"epm", (String)"eb", (String)"MemberQuoteService", (String)"delete", (Object[])new Object[]{MemberQuoteResourceEnum.Scheme.getType(), schemeIdToVarIds.keySet()});
            return;
        }
        LinkedList<MemberQuoteDao> quotes = new LinkedList<MemberQuoteDao>();
        for (Map.Entry<Long, Set<Long>> entry : schemeIdToVarIds.entrySet()) {
            Long schemeId = entry.getKey();
            Set<Long> varIds = entry.getValue();
            if (kd.epm.eb.common.utils.CollectionUtils.isEmpty(varIds)) continue;
            this.fillSchemeVarQuote(quotes, schemeId, varIds, varIdToValueInfo);
        }
        if (quotes.size() > 0) {
            DispatchServiceHelper.invokeBizService((String)"epm", (String)"eb", (String)"MemberQuoteService", (String)"save", (Object[])new Object[]{quotes});
        }
    }

    private void fillSchemeVarQuote(List<MemberQuoteDao> quotes, Long schemeId, Set<Long> varIds, Map<Long, Map<String, Object>> varIdToValueInfo) {
        for (Long varId : varIds) {
            Map memberInfoMap;
            String memberId;
            Map<String, Object> varValueInfo;
            if (IDUtils.isNotNull((Long)varId)) {
                quotes.add(new MemberQuoteDao(this.getModelId(), Long.valueOf(0L), Long.valueOf(0L), varId, MemberTypeEnum.VARIABLE, MemberQuoteResourceEnum.Scheme, schemeId));
            }
            if ((varValueInfo = varIdToValueInfo.get(varId)) == null) continue;
            Long dimId = (Long)varValueInfo.get(BD_DIMENSION);
            String varJson = (String)varValueInfo.get(VARIABLE_JSON);
            if (!kd.epm.eb.common.utils.StringUtils.isNotEmpty((String)varJson) || !kd.bos.util.StringUtils.isNotEmpty((String)(memberId = (memberInfoMap = (Map)SerializationUtils.fromJsonString((String)varJson, Map.class)).get("id").toString()))) continue;
            quotes.add(new MemberQuoteDao(this.getModelId(), this.getBizModelId(), dimId, Long.valueOf(memberId), MemberQuoteResourceEnum.Scheme, schemeId));
        }
    }

    private Map<Long, Map<String, Object>> getVarIdToValueInfo() {
        DynamicObjectCollection entryEntity = this.getModel().getEntryEntity(ENTRY_VAR);
        if (kd.epm.eb.common.utils.CollectionUtils.isEmpty((Collection)entryEntity)) {
            return new HashMap<Long, Map<String, Object>>(0);
        }
        HashMap<Long, Map<String, Object>> varIdToVarValueInfo = new HashMap<Long, Map<String, Object>>(entryEntity.size());
        for (DynamicObject object : entryEntity) {
            HashMap<String, Object> varValueInfo = new HashMap<String, Object>(4);
            varValueInfo.put(BD_DIMENSION, object.getLong("dimension.id"));
            varValueInfo.put(BD_VARIABLE, object.getLong("variablenumber.id"));
            varValueInfo.put(VARIABLE_VALUE, object.getString(VARIABLE_VALUE));
            varValueInfo.put(VARIABLE_JSON, object.getString("variableJson"));
            varIdToVarValueInfo.put(object.getLong("variablenumber.id"), varValueInfo);
        }
        return varIdToVarValueInfo;
    }

    private List<Object[]> packageVarObject(Map<Long, Long> schemeAssignMap, Map<Long, Map<String, Object>> varIdToVarValueInfo, Map<Long, Set<Long>> schemeIdToVarIds) {
        ArrayList<Object[]> objs = new ArrayList<Object[]>(16);
        for (Map.Entry<Long, Long> entry : schemeAssignMap.entrySet()) {
            int seq = 1;
            Set<Long> varIds = schemeIdToVarIds.get(entry.getKey());
            if (kd.epm.eb.common.utils.CollectionUtils.isEmpty(varIds)) continue;
            long[] ids = GlobalIdUtil.genGlobalLongIds((int)varIds.size());
            int i = 0;
            for (Long varId : varIds) {
                Map<String, Object> varValueInfo = varIdToVarValueInfo.get(varId);
                if (varValueInfo == null) continue;
                Object[] obj = new Object[]{entry.getValue(), ids[i++], seq++, varValueInfo.get(BD_DIMENSION), varValueInfo.get(BD_VARIABLE), varValueInfo.get(VARIABLE_VALUE), varValueInfo.get(VARIABLE_JSON)};
                objs.add(obj);
            }
        }
        return objs;
    }

    private Long getBizModelId() {
        return IDUtils.toLong(this.getFormCustomParam("bizModelId"));
    }

    public void propertyChanged(PropertyChangedArgs e) {
        String name = e.getProperty().getName();
        if (VARIABLE_VALUE.equals(name)) {
            String newVal = (String)e.getChangeSet()[0].getNewValue();
            if (kd.epm.eb.common.utils.StringUtils.isEmpty((String)newVal)) {
                this.getModel().setValue(VARIABLE_JSON, null);
            }
        } else if (BD_DIMENSION.equals(name)) {
            int rowIndex = e.getChangeSet()[0].getRowIndex();
            this.getModel().setValue(BD_VARIABLE, null, rowIndex);
            this.getModel().setValue(VARIABLE_VALUE, null, rowIndex);
            this.getModel().setValue(VARIABLE_JSON, null, rowIndex);
        }
    }

    private Set<Long> getSelReportSchemeIds() {
        String schemeIdStr = (String)this.getView().getFormShowParameter().getCustomParam("schemeIds");
        if (StringUtils.isNotEmpty((String)schemeIdStr)) {
            List schemeIds = (List)SerializationUtils.fromJsonString((String)schemeIdStr, List.class);
            return IDUtils.toLongs(new HashSet(schemeIds));
        }
        return new HashSet<Long>(0);
    }
}

