/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.formplugin.reportscheme;

import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.ILocaleString;
import kd.bos.dataentity.entity.OrmLocaleValue;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.resource.promptenum.MultiLangEnumBridge;
import kd.bos.dataentity.serialization.DataEntitySerializer;
import kd.bos.dataentity.serialization.DataEntitySerializerOption;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.SqlBuilder;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.entity.AppMetadataCache;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.list.IListDataProvider;
import kd.bos.entity.operate.result.IOperateInfo;
import kd.bos.entity.operate.result.OperateErrorInfo;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.entity.tree.TreeNode;
import kd.bos.entity.validate.ErrorLevel;
import kd.bos.entity.validate.ValidateResult;
import kd.bos.exception.KDBizException;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IPageCache;
import kd.bos.form.ShowType;
import kd.bos.form.container.Tab;
import kd.bos.form.control.Control;
import kd.bos.form.control.Search;
import kd.bos.form.control.TreeView;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.form.control.events.TabSelectEvent;
import kd.bos.form.control.events.TabSelectListener;
import kd.bos.form.control.events.TreeNodeCheckEvent;
import kd.bos.form.control.events.TreeNodeCheckListener;
import kd.bos.form.events.BeforeClosedEvent;
import kd.bos.form.events.BeforeCreateListColumnsArgs;
import kd.bos.form.events.BeforeCreateListDataProviderArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.SetFilterEvent;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.form.i18n.MMPMsgUtils;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.BillList;
import kd.bos.list.DynamicTextListColumn;
import kd.bos.list.IListColumn;
import kd.bos.list.ListColumn;
import kd.bos.list.ListFilterParameter;
import kd.bos.list.ListOperationColumn;
import kd.bos.list.ListShowParameter;
import kd.bos.list.events.CreateListColumnsListener;
import kd.bos.list.events.CreateListDataProviderListener;
import kd.bos.list.plugin.IListPlugin;
import kd.bos.mvc.list.ListDataProvider;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.DispatchServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.TimeServiceHelper;
import kd.bos.servicehelper.operation.DeleteServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.epm.eb.business.bizrule.RuleRelationService;
import kd.epm.eb.business.reportscheme.entity.TebScheme;
import kd.epm.eb.business.reportscheme.entity.TebTemplateAssignOrg;
import kd.epm.eb.business.reportscheme.service.ReportSchemeAssignService;
import kd.epm.eb.business.reportscheme.service.ReportSchemeService;
import kd.epm.eb.business.reportscheme.service.ReportSchemeTemplateSortService;
import kd.epm.eb.common.cache.IModelCacheHelper;
import kd.epm.eb.common.cache.ModelCacheContext;
import kd.epm.eb.common.cache.impl.Dimension;
import kd.epm.eb.common.cache.impl.Member;
import kd.epm.eb.common.cache.propertycache.MemberPropCacheService;
import kd.epm.eb.common.cache.propertycache.entity.MemberPropCache;
import kd.epm.eb.common.ebcommon.common.enums.RangeEnum;
import kd.epm.eb.common.enums.ApplicationTypeEnum;
import kd.epm.eb.common.enums.RptSchemeStatusEnum;
import kd.epm.eb.common.enums.ShowTypeEnum;
import kd.epm.eb.common.enums.SysDimensionEnum;
import kd.epm.eb.common.reportprocess.entity.dto.TemplateEntityDto;
import kd.epm.eb.common.reportprocess.entity.request.BaseRptProcessRequest;
import kd.epm.eb.common.reportprocess.service.impl.ReportProcessAggService;
import kd.epm.eb.common.thread.EpmThreadPools;
import kd.epm.eb.common.utils.BusinessModelServiceHelper;
import kd.epm.eb.common.utils.CacheServiceHelper;
import kd.epm.eb.common.utils.CollectionUtils;
import kd.epm.eb.common.utils.GlobalIdUtil;
import kd.epm.eb.common.utils.IDUtils;
import kd.epm.eb.common.utils.NewEbAppUtil;
import kd.epm.eb.common.utils.ObjectSerialUtil;
import kd.epm.eb.common.utils.StringUtils;
import kd.epm.eb.common.utils.UserUtils;
import kd.epm.eb.formplugin.AbstractBasePlugin;
import kd.epm.eb.formplugin.reportscheme.dto.AddDeleteEntityConfirmDto;
import kd.epm.eb.formplugin.reportscheme.dto.UnAllocateConfirmDto;
import kd.epm.eb.formplugin.reportscheme.helper.ReportSchemeEditHelper;
import kd.epm.eb.formplugin.utils.TreeSearchUtil;
import org.apache.commons.collections4.MapUtils;
import org.apache.commons.lang3.tuple.MutableTriple;
import org.apache.commons.lang3.tuple.Triple;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ReportSchemeEditPlugin
extends AbstractBasePlugin
implements BeforeF7SelectListener,
TabSelectListener,
TreeNodeCheckListener,
CreateListDataProviderListener,
CreateListColumnsListener,
IListPlugin {
    private static final String TOOLBARAP = "toolbarap";
    private static final String SAVE = "btn_save";
    private static final String ASSIGN = "btn_assign";
    private static final String ALLOCATE = "btn_allocate";
    private static final String UNALLOCATE = "btn_unallocate";
    private static final String BIZRANGE = "bizrange";
    private static final String VIEWRANGE = "orgview";
    private static final String NUMBER = "number";
    private static final String APPLYSCOPE = "applyscope";
    private static final String MODEL = "model";
    private static final String SHOWWAY = "showway";
    private static final String BILLLISTAP = "billlistap";
    private static final String SHOWWAY_TEMP = "1";
    private static final String TEMPSHOWTYPE = "tempshowtype";
    public static final String TYPE_NAME = "2";
    public static final String TYPE_NAMEANDNUMBER = "3";
    private static final String ORGSHOWTYPE = "orgshowtype";
    private static final String ORGRANGETYPE = "orgrangetype";
    public static final String TEMPLATETREE = "templatetree";
    private static final String TEMPLATETREE_CACHE = "templatetree_cache";
    public static final String TEMPLATECACHEIDS = "cacheTmpIds";
    public static final String TEMPLATE_CHECKEDIDS_CACHE = "cache_selected_template";
    public static final int MAX_LEVEL = 20;
    private static final String TEMPSEARCHAP = "tempsearchap";
    private static final String TEMPBEFORE = "tempbefore";
    private static final String TEMPNEXT = "tempnext";
    private static final String ORG_TREE = "orgtree";
    private static final String ORG_TREE_CACHE = "orgtreecache";
    private static final String ORGSEARCHAP = "orgsearchap";
    private static final String ORGBEFORE = "orgbefore";
    private static final String ORGNEXT = "orgnext";
    private static final String PROP_TREE = "proptree";
    private static final String PROP_TREE_CACHE = "proptreecache";
    private static final String PROPSEARCHAP = "propsearchap";
    private static final String PROPBEFORE = "propbefore";
    private static final String PROPNEXT = "propnext";
    private static final String ASSIGN_CLOSECALLBACK = "assigncloseback";
    private static final String SETDELETE_CLOSECALLBACK = "selectDeleteEntity";
    private static final String TEMPLATE_TYPE_CHACH = "template_type_chach";
    private static final String BTN_TEMPLATESORT = "btn_templatesort";
    private Map<String, String> templateTypeMap;
    private static final String OPERATIONRESULT_CAHCE = "operationResultCache";
    private static final String UNALLOCATE_CAHCE = "unallocateCache";
    private static final String BTN_ADDDEL = "btn_adddel";
    private static final String BTN_CANCELDEL = "btn_canceldel";
    private static final String SELECT_TAB_CACHE = "selectTabCache";
    private static final String ADDDELETE_CAHCE = "adddeleteCache";
    private static final String COMMITCHECK = "commitcheck";

    public void initialize() {
        BillList billList = (BillList)this.getControl(BILLLISTAP);
        billList.addCreateListDataProviderListener((CreateListDataProviderListener)this);
        billList.addCreateListColumnsListener((CreateListColumnsListener)this);
        billList.addSetFilterListener(this::setFilter);
    }

    public void setFilter(SetFilterEvent setFilterEvent) {
        QFilter qFilter1 = this.getqFilter();
        if (CollectionUtils.isNotEmpty((Collection)setFilterEvent.getQFilters())) {
            ArrayList qFilters = new ArrayList(setFilterEvent.getQFilters());
            setFilterEvent.getQFilters().clear();
            for (QFilter qFilter : qFilters) {
                if (qFilter.getProperty().equals("templatenumber")) {
                    setFilterEvent.getQFilters().add(new QFilter("template.number", qFilter.getCP(), qFilter.getValue()).or(new QFilter("applytemplate.number", qFilter.getCP(), qFilter.getValue())));
                    continue;
                }
                if (qFilter.getProperty().equals("templatename")) {
                    setFilterEvent.getQFilters().add(new QFilter("template.name", qFilter.getCP(), qFilter.getValue()).or(new QFilter("applytemplate.name", qFilter.getCP(), qFilter.getValue())));
                    continue;
                }
                setFilterEvent.getQFilters().add(qFilter);
            }
        }
        setFilterEvent.getQFilters().add(qFilter1);
        setFilterEvent.setOrderBy("allocatetime desc,recordseq");
    }

    @Override
    public void beforeBindData(EventObject e) {
        BillList billList = (BillList)this.getControl(BILLLISTAP);
        if (billList != null) {
            billList.getListModel().setMaxReturnData(1000000);
        }
    }

    @Override
    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addItemClickListeners(new String[]{TOOLBARAP});
        this.addClickListeners(new String[]{TEMPBEFORE, TEMPNEXT, ORGBEFORE, ORGNEXT, PROPBEFORE, PROPNEXT, BTN_ADDDEL, BTN_CANCELDEL});
        Tab tabap = (Tab)this.getView().getControl("tabap");
        tabap.addTabSelectListener((TabSelectListener)this);
        Tab tabrecord = (Tab)this.getView().getControl("tabrecord");
        tabrecord.addTabSelectListener((TabSelectListener)this);
        BasedataEdit bizRange = (BasedataEdit)this.getControl(BIZRANGE);
        bizRange.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        BasedataEdit viewRange = (BasedataEdit)this.getControl(VIEWRANGE);
        viewRange.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        Search search = (Search)this.getView().getControl(TEMPSEARCHAP);
        search.addEnterListener(event -> {
            if (event.getText() != null && !"".equals(event.getText())) {
                TreeSearchUtil.searchMember(event.getText().toLowerCase().trim(), this.getView(), this.getPageCache(), new TreeSearchUtil.TreeSearchParam(TEMPLATETREE, TEMPLATETREE_CACHE));
            } else {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u8f93\u5165\u7f16\u7801\u6216\u540d\u79f0\u540e\u6309\u56de\u8f66\u952e\u3002", (String)"ReportSchemeEditPlugin_1", (String)"epm-eb-formplugin", (Object[])new Object[0]));
            }
        });
        Search orgSearch = (Search)this.getView().getControl(ORGSEARCHAP);
        orgSearch.addEnterListener(event -> {
            if (event.getText() != null && !"".equals(event.getText())) {
                TreeSearchUtil.searchMember(event.getText().toLowerCase().trim(), this.getView(), this.getPageCache(), new TreeSearchUtil.TreeSearchParam(ORG_TREE, ORG_TREE_CACHE));
            } else {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u8f93\u5165\u7f16\u7801\u6216\u540d\u79f0\u540e\u6309\u56de\u8f66\u952e\u3002", (String)"ReportSchemeEditPlugin_1", (String)"epm-eb-formplugin", (Object[])new Object[0]));
            }
        });
        Search propSearch = (Search)this.getView().getControl(PROPSEARCHAP);
        propSearch.addEnterListener(event -> {
            if (event.getText() != null && !"".equals(event.getText())) {
                TreeSearchUtil.searchMember(event.getText().toLowerCase().trim(), this.getView(), this.getPageCache(), new TreeSearchUtil.TreeSearchParam(PROP_TREE, PROP_TREE_CACHE));
            } else {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u8f93\u5165\u7f16\u7801\u6216\u540d\u79f0\u540e\u6309\u56de\u8f66\u952e\u3002", (String)"ReportSchemeEditPlugin_1", (String)"epm-eb-formplugin", (Object[])new Object[0]));
            }
        });
        TreeView treeView = (TreeView)this.getControl(TEMPLATETREE);
        treeView.addTreeNodeCheckListener((TreeNodeCheckListener)this);
        TreeView orgTreeView = (TreeView)this.getControl(ORG_TREE);
        orgTreeView.addTreeNodeCheckListener((TreeNodeCheckListener)this);
        TreeView propTreeView = (TreeView)this.getControl(PROP_TREE);
        propTreeView.addTreeNodeCheckListener((TreeNodeCheckListener)this);
    }

    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        this.initModelData();
        this.getView().setVisible(Boolean.valueOf(false), new String[]{BTN_CANCELDEL});
        this.getView().setVisible(Boolean.valueOf(true), new String[]{BTN_ADDDEL});
    }

    public void afterLoadData(EventObject e) {
        this.getModel().setValue(SHOWWAY, (Object)SHOWWAY_TEMP);
        this.getModel().setValue(TEMPSHOWTYPE, (Object)TYPE_NAME);
        this.getModel().setValue(ORGSHOWTYPE, (Object)TYPE_NAME);
        this.getModel().setValue(ORGRANGETYPE, (Object)RangeEnum.VALUE_10.getValue());
        this.getView().setVisible(Boolean.valueOf(false), new String[]{BTN_CANCELDEL});
        this.getView().setVisible(Boolean.valueOf(true), new String[]{BTN_ADDDEL});
        this.setInitData();
        this.lockScheme();
        this.setNewEbModel(this.getModelId());
    }

    private void setInitData() {
        if (this.initModelData()) {
            return;
        }
        this.refreshAllEntry(false);
    }

    private boolean initModelData() {
        String model = (String)this.getView().getFormShowParameter().getCustomParam(MODEL);
        if (StringUtils.isEmpty((String)model)) {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u4f53\u7cfb\u4e3a\u7a7a\u3002", (String)"ReportSchemeEditPlugin_0", (String)"epm-eb-formplugin", (Object[])new Object[0]));
            return true;
        }
        this.getPageCache().put(MODEL, model);
        this.getModel().setValue(MODEL, (Object)model);
        this.setNewEbModel(IDUtils.toLong((Object)model));
        return false;
    }

    private void setNewEbModel(Long model) {
        if (NewEbAppUtil.isNewEbModel((Long)model)) {
            this.getView().setVisible(Boolean.valueOf(false), new String[]{BIZRANGE});
            DynamicObjectCollection query = QueryServiceHelper.query((String)"eb_businessmodel", (String)"id", (QFilter[])new QFilter[]{new QFilter(MODEL, "=", (Object)model)});
            if (query != null && !query.isEmpty()) {
                this.getModel().setValue(BIZRANGE, (Object)((DynamicObject)query.get(0)).getLong("id"));
            }
        }
    }

    private void refreshAllEntry(boolean isNeedDelete) {
        this.refreshTemplateTree();
        this.refrehsOrgTree();
    }

    private void refrehsOrgTree() {
        TreeView treeView = (TreeView)this.getControl(ORG_TREE);
        treeView.deleteAllNodes();
        this.getPageCache().remove(ORG_TREE_CACHE);
        TreeView propTreeView = (TreeView)this.getControl(PROP_TREE);
        propTreeView.deleteAllNodes();
        this.getPageCache().remove(PROP_TREE_CACHE);
        Long orgView = this.getOrgView();
        if (orgView == null || orgView == 0L) {
            return;
        }
        ReportSchemeEditHelper.refreshOrgTree(ShowTypeEnum.getShowTypeByValue((String)((String)this.getModel().getValue(ORGSHOWTYPE))), this.getModelId(), (TreeView)this.getControl(ORG_TREE), this.getPageCache(), ORG_TREE_CACHE, orgView, ((DynamicObject)this.getModel().getValue(BIZRANGE)).getLong("id"));
        ReportSchemeEditHelper.refreshOrgPropTree(ShowTypeEnum.getShowTypeByValue((String)((String)this.getModel().getValue(ORGSHOWTYPE))), this.getModelId(), (TreeView)this.getControl(PROP_TREE), this.getPageCache(), PROP_TREE_CACHE, orgView);
    }

    private void refreshTemplateTree() {
        TreeView treeView = (TreeView)this.getControl(TEMPLATETREE);
        treeView.deleteAllNodes();
        ArrayList<TreeNode> selectTreeNodeList = new ArrayList<TreeNode>(16);
        ReportSchemeEditHelper.getAllNode(ShowTypeEnum.getShowTypeByValue((String)((String)this.getModel().getValue(TEMPSHOWTYPE))), selectTreeNodeList, this.getPageCache(), TEMPLATETREE_CACHE, this.getBizRangeId(), this.getModelId(), treeView, TEMPLATE_TYPE_CHACH);
    }

    @Override
    public Long getModelId() {
        String modelid = this.getPageCache().get(MODEL);
        if (StringUtils.isEmpty((String)modelid)) {
            DynamicObject value = (DynamicObject)this.getModel().getValue(MODEL);
            if (value == null) {
                return 0L;
            }
            modelid = value.getString("id");
            this.getPageCache().put(MODEL, modelid);
        }
        return Long.parseLong(modelid);
    }

    private long getBizRangeId() {
        String bizRangeId = this.getPageCache().get(BIZRANGE);
        if (StringUtils.isEmpty((String)bizRangeId)) {
            DynamicObject value = (DynamicObject)this.getModel().getValue(BIZRANGE);
            if (value == null) {
                return 0L;
            }
            bizRangeId = value.getString("id");
            this.getPageCache().put(BIZRANGE, bizRangeId);
        }
        return Long.parseLong(bizRangeId);
    }

    private Long getOrgView() {
        DynamicObject value = (DynamicObject)this.getModel().getValue(VIEWRANGE);
        if (value != null) {
            return value.getLong("id");
        }
        return BusinessModelServiceHelper.getInstance().getViewId(Long.valueOf(this.getBizRangeId()), SysDimensionEnum.Entity.getNumber(), this.getModelId());
    }

    @Override
    public void beforeF7Select(BeforeF7SelectEvent beforeF7SelectEvent) {
        String key = beforeF7SelectEvent.getProperty().getName();
        if (BIZRANGE.equals(key)) {
            ListShowParameter showParameter = (ListShowParameter)beforeF7SelectEvent.getFormShowParameter();
            ArrayList<QFilter> qFilterList = new ArrayList<QFilter>(16);
            qFilterList.add(new QFilter(MODEL, "=", (Object)this.getModelId()));
            showParameter.setListFilterParameter(new ListFilterParameter(qFilterList, null));
        } else if (VIEWRANGE.equals(key)) {
            long bizRangeId = this.getBizRangeId();
            if (IDUtils.isNull((long)bizRangeId)) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u4e1a\u52a1\u6a21\u578b\u3002", (String)"ReportSchemeEditPlugin_55", (String)"epm-eb-formplugin", (Object[])new Object[0]));
                beforeF7SelectEvent.setCancel(true);
            }
            Map viewsByBusModel = this.getIModelCacheHelper().getViewGroupViewsByBusModel(Long.valueOf(this.getBizRangeId()));
            List baseEntityId = null;
            if (MapUtils.isNotEmpty((Map)viewsByBusModel)) {
                baseEntityId = (List)viewsByBusModel.get("Entity");
            }
            ListShowParameter showParameter = (ListShowParameter)beforeF7SelectEvent.getFormShowParameter();
            ArrayList<QFilter> qFilterList = new ArrayList<QFilter>(16);
            List dimensionListByBusModel = this.getIModelCacheHelper().getDimensionListByBusModel(Long.valueOf(this.getBizRangeId()));
            Optional<Dimension> first = dimensionListByBusModel.stream().filter(x -> x.getNumber().equals(SysDimensionEnum.Entity.getNumber())).findFirst();
            if (!first.isPresent()) {
                beforeF7SelectEvent.setCancel(true);
                return;
            }
            Dimension dimension = first.get();
            qFilterList.add(new QFilter(MODEL, "=", (Object)this.getModelId()));
            qFilterList.add(new QFilter("dimension", "=", (Object)dimension.getId()));
            qFilterList.add(new QFilter("id", "in", (Object)baseEntityId));
            showParameter.setListFilterParameter(new ListFilterParameter(qFilterList, null));
        }
    }

    public void itemClick(ItemClickEvent evt) {
        String itemKey = evt.getItemKey();
        if (ALLOCATE.equals(itemKey)) {
            this.allocate();
        } else if (UNALLOCATE.equals(itemKey)) {
            Set<TemplateEntityDto> apListCheckResult;
            DynamicObject[] result;
            ArrayList<TemplateEntityDto> needUnAllocate = new ArrayList<TemplateEntityDto>(10);
            ArrayList<TemplateEntityDto> needUnAllocateDtos = new ArrayList<TemplateEntityDto>(10);
            ArrayList<TemplateEntityDto> aplist = new ArrayList<TemplateEntityDto>(10);
            HashMap<Long, String> templateInfoMap = new HashMap<Long, String>(16);
            HashMap<Long, String> orgInfoMap = new HashMap<Long, String>(16);
            HashMap<Integer, String> orgRangeNames = new HashMap<Integer, String>(16);
            for (RangeEnum rangeEnum : RangeEnum.values()) {
                orgRangeNames.put(rangeEnum.getValue(), rangeEnum.getName());
            }
            BillList billList = (BillList)this.getControl(BILLLISTAP);
            ListSelectedRowCollection rows_temp = billList.getSelectedRows();
            int selectedRowCount = rows_temp.size();
            if (rows_temp.size() == 0) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u8981\u53cd\u5206\u914d\u7684\u6570\u636e\u3002", (String)"ReportSchemeEditPlugin_13", (String)"epm-eb-formplugin", (Object[])new Object[0]));
                return;
            }
            HashMap<TemplateEntityDto, Long> templateEntityDtoIdMap = new HashMap<TemplateEntityDto, Long>(rows_temp.size());
            ArrayList<Long> needUnAllocateRecordId = new ArrayList<Long>(rows_temp.size());
            for (int i = 0; i < rows_temp.size(); ++i) {
                Long id = IDUtils.toLong((Object)rows_temp.get(i).getPrimaryKeyValue());
                needUnAllocateRecordId.add(id);
            }
            QFilter qFilter = new QFilter("scheme", "=", this.getModel().getValue("id"));
            qFilter.and("id", "in", needUnAllocateRecordId);
            for (DynamicObject dynamicObject : result = BusinessDataServiceHelper.load((String)"eb_templateorg", (String)"id,template,templatetype,org,orgrange,applytemplate,deleteentity,deleteentity.entity", (QFilter[])qFilter.toArray())) {
                String templatetype = dynamicObject.getString("templatetype");
                Long templateId = dynamicObject.getLong("template.id");
                String templateNumber = dynamicObject.getString("template.number");
                String templateName = dynamicObject.getString("template.name");
                if (SHOWWAY_TEMP.equals(templatetype)) {
                    templateId = dynamicObject.getLong("applytemplate.id");
                    templateNumber = dynamicObject.getString("applytemplate.number");
                    templateName = dynamicObject.getString("applytemplate.name");
                }
                templateInfoMap.putIfAbsent(templateId, templateNumber + "_" + templateName);
                String orgnumber = dynamicObject.getString("org.number");
                if (StringUtils.isEmpty((String)orgnumber)) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u53cd\u5206\u914d\u5931\u8d25\uff0c\u6240\u9009\u884c\u4e2d\u6709\u7f3a\u5931\u4fe1\u606f\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u5904\u7406\u3002", (String)"ReportSchemeEditPlugin_36", (String)"epm-eb-formplugin", (Object[])new Object[0]));
                    return;
                }
                String orgName = dynamicObject.getString("org.name");
                Long orgId = dynamicObject.getLong("org.id");
                orgInfoMap.putIfAbsent(orgId, orgName);
                String rangeStr = dynamicObject.getString("orgrange");
                TemplateEntityDto templateEntityDto = new TemplateEntityDto(templateId, orgId, Integer.valueOf(Integer.parseInt(rangeStr)));
                long id = dynamicObject.getLong("id");
                if ("0".equals(templatetype)) {
                    templateEntityDto.setDeleteEntity(dynamicObject.getDynamicObjectCollection("deleteentity").stream().map(x -> x.getLong("entity.id")).collect(Collectors.toSet()));
                    needUnAllocate.add(templateEntityDto);
                    needUnAllocateDtos.add(templateEntityDto);
                    templateEntityDtoIdMap.put(templateEntityDto, id);
                    continue;
                }
                if (!SHOWWAY_TEMP.equals(templatetype)) continue;
                templateEntityDto.setDeleteEntity(dynamicObject.getDynamicObjectCollection("deleteentity").stream().map(x -> x.getLong("entity.id")).collect(Collectors.toSet()));
                aplist.add(templateEntityDto);
                needUnAllocateDtos.add(templateEntityDto);
                templateEntityDtoIdMap.put(templateEntityDto, id);
            }
            Set<TemplateEntityDto> templateEntityDtosWithData = null;
            if (needUnAllocate.size() > 0) {
                templateEntityDtosWithData = this.checkReportStatus(needUnAllocate);
            }
            if (aplist.size() > 0 && (apListCheckResult = this.checkApReportStatus(aplist)) != null) {
                if (templateEntityDtosWithData == null) {
                    templateEntityDtosWithData = apListCheckResult;
                } else {
                    templateEntityDtosWithData.addAll(apListCheckResult);
                }
            }
            OperationResult operationResult = new OperationResult();
            if (templateEntityDtosWithData != null && templateEntityDtosWithData.size() > 0) {
                ArrayList validIds = new ArrayList(16);
                HashMap<Integer, String> billNos = new HashMap<Integer, String>(16);
                String title = ResManager.loadKDString((String)"\u53cd\u5206\u914d\u7ed3\u679c", (String)"ReportSchemeEditPlugin_29", (String)"epm-eb-formplugin", (Object[])new Object[0]);
                String failed = ResManager.loadKDString((String)"\u5931\u8d25", (String)"ReportSchemeEditPlugin_31", (String)"epm-eb-formplugin", (Object[])new Object[0]);
                for (int i = 0; i < needUnAllocateDtos.size(); ++i) {
                    TemplateEntityDto dto = (TemplateEntityDto)needUnAllocateDtos.get(i);
                    String msg = ResManager.loadResFormat((String)"\u6a21\u677f\u201c%1\u201d\u53cd\u5206\u914d\u7f16\u5236\u7ec4\u7ec7\u201c%2\u201d", (String)"ReportSchemeEditPlugin_30", (String)"epm-eb-formplugin", (Object[])new Object[]{templateInfoMap.get(dto.getTemplateId()), (String)orgInfoMap.get(dto.getEntityId()) + (String)orgRangeNames.get(dto.getEntityRange())});
                    billNos.put(i, msg);
                    if (templateEntityDtosWithData.contains(dto)) {
                        OperateErrorInfo operateErrorInfo = new OperateErrorInfo();
                        operateErrorInfo.setTitle(title);
                        operateErrorInfo.setLevel(ErrorLevel.Error);
                        operateErrorInfo.setMessage(msg + failed);
                        operationResult.addErrorInfo(operateErrorInfo);
                        continue;
                    }
                    operationResult.addSuccessPkId((Object)i);
                    validIds.add(templateEntityDtoIdMap.get(dto));
                }
                operationResult.setBillNos(billNos);
                operationResult.setBillCount(rows_temp.size());
                needUnAllocateRecordId.clear();
                needUnAllocateRecordId.addAll(validIds);
                if (needUnAllocateRecordId.size() > 0) {
                    this.getPageCache().put(OPERATIONRESULT_CAHCE, SerializationUtils.toJsonString((Object)operationResult));
                } else {
                    String context = ResManager.loadKDStringExt((String)"\u88ab\u53cd\u5206\u914d\u7684\u62a5\u8868\u5c06\u4e0d\u4f1a\u663e\u793a\u4e8e\u62a5\u8868\u7f16\u5236\u5217\u8868\u5f53\u524d\u65b9\u6848\u4e2d\uff0c\u7ee7\u7eed\u64cd\u4f5c\u5c06\u53cd\u5206\u914d\uff1a", (String)"BGMD-C-263417", (String)"prompt-bgm", (Object[])new Object[0]);
                    this.showOperationResultMulti(operationResult, MMPMsgUtils.getMessageInfo((String)ResManager.loadKDStringExt((String)"\u53cd\u5206\u914d\u7ed3\u679c", (String)"BGMD-C-002448", (String)"prompt-bgm", (Object[])new Object[0]), (String)"BGMD-C-002448"), UNALLOCATE, context);
                }
            } else {
                operationResult.setBillCount(needUnAllocateDtos.size());
                operationResult.setSuccessPkIds(needUnAllocate.stream().map(x -> x.getEntityId()).collect(Collectors.toList()));
            }
            if (needUnAllocateRecordId.size() > 0) {
                Long id = (Long)this.getModel().getValue("id");
                DynamicObjectCollection query = QueryServiceHelper.query((String)"eb_templateorg", (String)"id", (QFilter[])new QFilter[]{new QFilter("scheme", "=", (Object)id)});
                if (needUnAllocateRecordId.size() >= query.size()) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u7f16\u5236\u65b9\u6848\u81f3\u5c11\u5305\u542b\u4e00\u884c\u5df2\u5206\u914d\u7684\u8bb0\u5f55\u3002", (String)"ReportSchemeEditPlugin_3", (String)"epm-eb-formplugin", (Object[])new Object[0]));
                    this.getPageCache().remove(OPERATIONRESULT_CAHCE);
                    return;
                }
                ArrayList<Long> needDeleteRecordIds = new ArrayList<Long>(16);
                ArrayList<TemplateEntityDto> needUnAllocateRecords = new ArrayList<TemplateEntityDto>(10);
                for (Long recordId : needUnAllocateRecordId) {
                    needDeleteRecordIds.add(recordId);
                    Optional<DynamicObject> record = Arrays.stream(result).filter(x -> recordId.equals(x.getLong("id"))).findFirst();
                    if (!record.isPresent()) continue;
                    DynamicObject dynamicObject = record.get();
                    String templatetype = dynamicObject.getString("templatetype");
                    Long templateId = "0".equals(templatetype) ? dynamicObject.getLong("template.id") : dynamicObject.getLong("applytemplate.id");
                    Long orgId = dynamicObject.getLong("org.id");
                    String range = dynamicObject.getString("orgrange");
                    TemplateEntityDto templateEntityDto = new TemplateEntityDto(templateId, orgId, Integer.valueOf(Integer.parseInt(range)));
                    needUnAllocateRecords.add(templateEntityDto);
                }
                UnAllocateConfirmDto unAllocateCofirmDto = new UnAllocateConfirmDto();
                unAllocateCofirmDto.setNeedUnAllocate(needUnAllocateDtos);
                unAllocateCofirmDto.setNeedUnAllocateRecords(needUnAllocateRecords);
                unAllocateCofirmDto.setNeedDeleteRecordIds(needDeleteRecordIds);
                unAllocateCofirmDto.setRows_temp(rows_temp.size());
                this.getPageCache().put(UNALLOCATE_CAHCE, SerializationUtils.toJsonString((Object)unAllocateCofirmDto));
                String title = ResManager.loadKDStringExt((String)"\u88ab\u53cd\u5206\u914d\u7684\u62a5\u8868\u5c06\u4e0d\u4f1a\u663e\u793a\u4e8e\u62a5\u8868\u7f16\u5236\u5217\u8868\u5f53\u524d\u65b9\u6848\u4e2d\uff0c\u7ee7\u7eed\u64cd\u4f5c\u5c06\u53cd\u5206\u914d\uff1a", (String)"BGMD-C-263417", (String)"prompt-bgm", (Object[])new Object[0]);
                this.showOperationResultMulti(operationResult, ResManager.loadKDStringExt((String)"\u53cd\u5206\u914d\u7ed3\u679c", (String)"BGMD-C-002448", (String)"prompt-bgm", (Object[])new Object[0]), UNALLOCATE, title);
            }
        } else if (SAVE.equals(itemKey)) {
            Long id = (Long)this.getModel().getValue("id");
            if (!this.checkNumberAndName()) {
                return;
            }
            boolean isEmptyScheme = QueryServiceHelper.exists((String)"eb_templateorg", (QFilter[])new QFilter[]{new QFilter("scheme", "=", (Object)id)});
            if (!isEmptyScheme) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u7f16\u5236\u65b9\u6848\u81f3\u5c11\u5305\u542b\u4e00\u884c\u5df2\u5206\u914d\u7684\u8bb0\u5f55\u3002", (String)"ReportSchemeEditPlugin_3", (String)"epm-eb-formplugin", (Object[])new Object[0]));
                return;
            }
            this.save(itemKey, null, null);
        } else if (ASSIGN.equals(itemKey)) {
            this.assignScheme();
        } else if (BTN_TEMPLATESORT.equals(itemKey)) {
            this.checkPerm();
            if (!ReportSchemeTemplateSortService.getInstance().schemeHasAssignBudgetTemplate(IDUtils.toLong((Object)this.getModel().getValue("id")))) {
                String info = ResManager.loadKDString((String)"\u8bf7\u5148\u5206\u914d\u9884\u7b97\u6a21\u677f\u540e\u518d\u8fdb\u884c\u6392\u5e8f\u3002", (String)"", (String)"epm-eb-formplugin", (Object[])new Object[0]);
                this.getView().showTipNotification(info);
                return;
            }
            this.openTemplateSortDialog();
        }
    }

    public void checkPerm() {
        this.checkPerm(BTN_TEMPLATESORT);
    }

    public void checkPerm(String button) {
        String formId = "eb_rptschemelist";
        if (ApplicationTypeEnum.EB.getAppnum().equalsIgnoreCase(this.getAppId())) {
            formId = "eb_ebrptschemelist_nbg";
        }
        this.checkPerm(button, formId);
    }

    public void checkPerm(String button, String formId) {
        String appid = this.getAppId();
        DispatchServiceHelper.invokeBizService((String)"epm", (String)"eb", (String)"EPMPermissionService", (String)"checkPermission", (Object[])new Object[]{this.getModelId(), UserUtils.getUserId(), AppMetadataCache.getAppInfo((String)appid).getId(), formId, button});
    }

    public String getAppId() {
        if (NewEbAppUtil.isNewEbModel((Long)this.getModelId())) {
            return ApplicationTypeEnum.EB.getAppnum();
        }
        return ApplicationTypeEnum.BGMD.getAppnum();
    }

    private void openTemplateSortDialog() {
        FormShowParameter formShowParameter = new FormShowParameter();
        formShowParameter.setFormId("eb_rptscheme_templatesort");
        formShowParameter.getOpenStyle().setShowType(ShowType.Modal);
        formShowParameter.setCustomParam("schemeId", this.getModel().getValue("id"));
        formShowParameter.setCustomParam("schemeNumber", this.getModel().getValue(NUMBER));
        formShowParameter.setCustomParam("modelId", (Object)this.getModelId());
        this.getView().showForm(formShowParameter);
    }

    private void deleteReportProcessWhenunallocate(List<TemplateEntityDto> needUnAllocate, List<TemplateEntityDto> needUnAllocateRecords) {
        Long schemeId = (Long)this.getModel().getValue("id");
        DynamicObjectCollection schemeAssignRecords = ReportSchemeAssignService.getInstance().queryRecordByScheme(Collections.singletonList(schemeId));
        if (CollectionUtils.isNotEmpty((Collection)schemeAssignRecords)) {
            ArrayList<Triple<Long, Long, Long>> pdvTripleList = new ArrayList<Triple<Long, Long, Long>>(10);
            for (DynamicObject dynamicObject : schemeAssignRecords) {
                MutableTriple triple = MutableTriple.of((Object)dynamicObject.getLong("year"), (Object)dynamicObject.getLong("datatype"), (Object)dynamicObject.getLong("version"));
                pdvTripleList.add((Triple<Long, Long, Long>)triple);
            }
            if (needUnAllocate.size() != 0) {
                this.deleteReportProcess(schemeId, pdvTripleList, needUnAllocateRecords);
            }
        }
    }

    private void assignScheme() {
        Long id = (Long)this.getModel().getValue("id");
        if (IDUtils.isEmptyLong((Long)id).booleanValue() || !QueryServiceHelper.exists((String)"eb_rptscheme", (Object)id)) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u4fdd\u5b58\u5f53\u524d\u65b9\u6848\u3002", (String)"ReportSchemeEditPlugin_32", (String)"epm-eb-formplugin", (Object[])new Object[0]));
            return;
        }
        boolean isEmptyScheme = QueryServiceHelper.exists((String)"eb_templateorg", (QFilter[])new QFilter[]{new QFilter("scheme", "=", (Object)id)});
        if (!isEmptyScheme) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u6240\u9009\u65b9\u6848\u5df2\u5206\u914d\u7684\u6a21\u677f\u4e0d\u5b58\u5728\u6216\u4e0d\u5b58\u5728\u5df2\u5206\u914d\u8bb0\u5f55\uff0c\u8bf7\u5c06\u6a21\u677f\u5206\u914d\u7ec4\u7ec7\u540e\u518d\u8fdb\u884c\u4e0b\u8fbe\u3002", (String)"ReportSchemeListPlugin_21", (String)"epm-eb-formplugin", (Object[])new Object[0]));
            return;
        }
        String selects = "id,name,number,bizrange,status,applyscope";
        DynamicObject scheme = QueryServiceHelper.queryOne((String)"eb_rptscheme", (String)selects, (QFilter[])new QFilter("id", "=", (Object)id).toArray());
        if (scheme != null) {
            String status;
            String status1 = (String)this.getModel().getValue("status");
            if (StringUtils.notEquals((String)status1, (String)(status = scheme.getString("status")))) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u4fdd\u5b58\u5f53\u524d\u65b9\u6848\u3002", (String)"ReportSchemeEditPlugin_32", (String)"epm-eb-formplugin", (Object[])new Object[0]));
                return;
            }
            if (!RptSchemeStatusEnum.ENABLE.getNumber().equals(status) || !RptSchemeStatusEnum.ENABLE.getNumber().equals(status1)) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u4e0d\u5141\u8bb8\u4e0b\u8fbe\u5df2\u7981\u7528\u6216\u5df2\u5173\u95ed\u65b9\u6848\u3002", (String)"ReportSchemeEditPlugin_40", (String)"epm-eb-formplugin", (Object[])new Object[0]));
                return;
            }
            this.openAssignPage(scheme.getString("id"), scheme.getString(BIZRANGE), scheme.getString(APPLYSCOPE), scheme.getString("name"));
        }
    }

    private void openAssignPage(String schemeId, String bizModelId, String applyScope, String showText) {
        FormShowParameter showParameter = new FormShowParameter();
        showParameter.setFormId("eb_assignscheme_new");
        showParameter.getOpenStyle().setShowType(ShowType.Modal);
        showParameter.setCustomParam("bizRanges", (Object)SerializationUtils.toJsonString(Collections.singletonList(bizModelId)));
        showParameter.setCustomParam("bizModelId", (Object)bizModelId);
        showParameter.setCustomParam("schemeIds", (Object)SerializationUtils.toJsonString(Collections.singletonList(schemeId)));
        showParameter.setCustomParam(MODEL, (Object)String.valueOf(this.getModelId()));
        showParameter.setCustomParam("showText", (Object)showText);
        showParameter.setCustomParam("applyScopes", (Object)SerializationUtils.toJsonString(Collections.singletonList(applyScope)));
        showParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, ASSIGN_CLOSECALLBACK));
        this.getView().showForm(showParameter);
    }

    @Override
    public void closedCallBack(ClosedCallBackEvent closedCallBackEvent) {
        super.closedCallBack(closedCallBackEvent);
        String key = closedCallBackEvent.getActionId();
        if (ASSIGN_CLOSECALLBACK.equals(key)) {
            if (closedCallBackEvent.getReturnData() != null) {
                this.getView().showSuccessNotification((String)closedCallBackEvent.getReturnData());
                MultiLangEnumBridge opName = new MultiLangEnumBridge("\u65b9\u6848\u4e0b\u8fbe", "ReportSchemeListPlugin_22", "epm-eb-formplugin");
                OrmLocaleValue name = (OrmLocaleValue)this.getModel().getValue("name");
                MultiLangEnumBridge opMsg = new MultiLangEnumBridge("\u65b9\u6848\u540d\u79f0\uff1a%1$s\u3002", "ReportSchemeListPlugin_23", "epm-eb-formplugin");
                this.writeLog(name.getLocaleValue(), "assign", opName, opMsg, new String[]{name.getLocaleValue()});
            }
        } else if (UNALLOCATE.equals(key)) {
            Object returnData = closedCallBackEvent.getReturnData();
            if (returnData != null && "ok".equals((String)returnData)) {
                String unallocateCache = this.getPageCache().get(UNALLOCATE_CAHCE);
                if (StringUtils.isNotEmpty((String)unallocateCache)) {
                    UnAllocateConfirmDto unAllocateCofirmDto = (UnAllocateConfirmDto)SerializationUtils.fromJsonString((String)unallocateCache, UnAllocateConfirmDto.class);
                    if (unAllocateCofirmDto.getNeedDeleteRecordIds().size() > 0) {
                        this.deleteReportProcessWhenunallocate(unAllocateCofirmDto.getNeedUnAllocate(), unAllocateCofirmDto.getNeedUnAllocateRecords());
                    }
                    ReportSchemeService.getInstance().deleteRecordById(unAllocateCofirmDto.getNeedDeleteRecordIds());
                    this.refreshAllocateEntry(false);
                    Long schemeId = (Long)this.getModel().getValue("id");
                    if (IDUtils.isNotNull((Long)schemeId)) {
                        DynamicObject dyScheme = BusinessDataServiceHelper.loadSingle((Object)schemeId, (String)"eb_rptscheme");
                        this.updateSchemeScopy(dyScheme);
                    }
                    if (unAllocateCofirmDto.getRows_temp() != null && unAllocateCofirmDto.getRows_temp().intValue() == unAllocateCofirmDto.getNeedUnAllocateRecords().size()) {
                        MultiLangEnumBridge opName = new MultiLangEnumBridge("\u53cd\u5206\u914d", "ReportSchemeEditPlugin_53", "epm-eb-formplugin");
                        MultiLangEnumBridge opMsg = new MultiLangEnumBridge("\u53cd\u5206\u914d\u6210\u529f\u3002", "ReportSchemeEditPlugin_35", "epm-eb-formplugin");
                        this.getView().showSuccessNotification(opMsg.loadKDString());
                        this.writeLog(null, "unAssign", opName, opMsg, null);
                    }
                }
                this.refreshAllocateEntry(false);
            }
            this.getPageCache().remove(UNALLOCATE_CAHCE);
        } else if (BTN_ADDDEL.equals(key)) {
            Object returnData = closedCallBackEvent.getReturnData();
            if (returnData != null && "ok".equals((String)returnData)) {
                String addDeleteCache = this.getPageCache().get(ADDDELETE_CAHCE);
                if (StringUtils.isEmpty((String)addDeleteCache)) {
                    log.info("\u7f13\u5b58\u4fe1\u606f\u4e3a\u7a7a");
                    return;
                }
                AddDeleteEntityConfirmDto addDeleteEntityConfirmDto = (AddDeleteEntityConfirmDto)SerializationUtils.fromJsonString((String)addDeleteCache, AddDeleteEntityConfirmDto.class);
                BillList billList = (BillList)this.getControl(BILLLISTAP);
                ListSelectedRowCollection rows_temp = billList.getSelectedRows();
                Set<Long> selectOrg = this.getSelectOrg(Boolean.TRUE);
                Set collect = rows_temp.stream().map(x -> x.getPrimaryKeyValue()).collect(Collectors.toSet());
                QFilter qFilter = new QFilter("id", "in", (Object)IDUtils.toLongs(collect));
                DynamicObject[] dynamicObjects = BusinessDataServiceHelper.load((String)"eb_templateorg", (String)"id,org,orgrange,deleteentity,deleteentity.entity,templatetype,template,applytemplate", (QFilter[])qFilter.toArray());
                if (dynamicObjects == null || dynamicObjects.length == 0) {
                    log.info("\u5206\u914d\u8bb0\u5f55\u4e0d\u5b58\u5728");
                    return;
                }
                Map<Long, Set<Long>> failRecordMap = addDeleteEntityConfirmDto.getFailRecordMap();
                DynamicObjectType deleteentity = dynamicObjects[0].getDynamicObjectCollection("deleteentity").getDynamicObjectType();
                HashMap<String, Set> rangeCahce = new HashMap<String, Set>(16);
                IModelCacheHelper orCreate = ModelCacheContext.getOrCreate((Long)this.getModelId());
                HashSet<Long> needDelRecord = new HashSet<Long>(16);
                for (DynamicObject dynamicObject : dynamicObjects) {
                    Set<Object> needDeleteEntity = new HashSet(16);
                    if (!failRecordMap.isEmpty() && failRecordMap.containsKey(dynamicObject.getLong("id"))) {
                        needDeleteEntity = failRecordMap.get(dynamicObject.getLong("id"));
                    }
                    DynamicObjectCollection dynamicObjectCollection = new DynamicObjectCollection(deleteentity, (Object)dynamicObject);
                    String rangeKey = dynamicObject.getString("org.id") + "_" + dynamicObject.getInt("orgrange");
                    Set set = rangeCahce.computeIfAbsent(rangeKey, x -> new HashSet(16));
                    DynamicObjectCollection oldDelete = dynamicObject.getDynamicObjectCollection("deleteentity");
                    Set<Object> oldDeleteSet = new HashSet(16);
                    if (CollectionUtils.isNotEmpty((Collection)oldDelete)) {
                        oldDeleteSet = oldDelete.stream().map(x -> x.getLong("entity.id")).collect(Collectors.toSet());
                    }
                    if (CollectionUtils.isEmpty((Collection)set)) {
                        List orgrange = orCreate.getMember(SysDimensionEnum.Entity.getNumber(), this.getOrgView(), dynamicObject.getString("org.number"), dynamicObject.getInt("orgrange"));
                        set.addAll(orgrange.stream().map(x -> x.getId()).collect(Collectors.toSet()));
                    }
                    int orgrange = dynamicObject.getInt("orgrange");
                    for (Long aLong : selectOrg) {
                        if (needDeleteEntity.contains(aLong)) continue;
                        if (set.contains(aLong) && !oldDeleteSet.contains(aLong)) {
                            DynamicObject dynamicObject1 = dynamicObjectCollection.addNew();
                            dynamicObject1.set("entity", (Object)aLong);
                        }
                        if (!set.contains(aLong) || orgrange != RangeEnum.VALUE_10.getValue()) continue;
                        needDelRecord.add(dynamicObject.getLong("id"));
                    }
                    if (!CollectionUtils.isNotEmpty((Collection)dynamicObjectCollection)) continue;
                    dynamicObject.getDynamicObjectCollection("deleteentity").addAll((Collection)dynamicObjectCollection);
                }
                try (TXHandle tx = TX.required();){
                    try {
                        this.deleteReportProcessWhenunallocate(addDeleteEntityConfirmDto.getNeedUnAllocate(), addDeleteEntityConfirmDto.getNeedUnAllocate());
                        SaveServiceHelper.save((DynamicObject[])dynamicObjects);
                        if (CollectionUtils.isNotEmpty(needDelRecord)) {
                            DeleteServiceHelper.delete((String)"eb_templateorg", (QFilter[])new QFilter[]{new QFilter("id", "in", needDelRecord)});
                        }
                    }
                    catch (Throwable e) {
                        tx.markRollback();
                        throw new KDBizException(e.getMessage());
                    }
                }
                this.refreshAllocateEntry(false);
            }
            this.getPageCache().remove(ADDDELETE_CAHCE);
        }
    }

    private Set<TemplateEntityDto> checkApReportStatus(List<TemplateEntityDto> list) {
        if (list.size() == 0) {
            return null;
        }
        Long id = (Long)this.getModel().getValue("id");
        if (IDUtils.isEmptyLong((Long)id).booleanValue()) {
            return null;
        }
        DynamicObjectCollection dynamicObjects = ReportSchemeAssignService.getInstance().queryRecordByScheme(Collections.singletonList(id));
        if (dynamicObjects == null || dynamicObjects.size() == 0) {
            return null;
        }
        IModelCacheHelper modelCacheHelper = this.getIModelCacheHelper();
        HashSet<TemplateEntityDto> result = new HashSet<TemplateEntityDto>(16);
        if (ReportSchemeService.getInstance().isExistApReport(id, list, modelCacheHelper, this.getOrgView()).booleanValue()) {
            DynamicObjectCollection existObj = ReportSchemeService.getInstance().queryApRecordBySchemeId(id);
            Set tempOrgRanges = list.stream().map(e -> String.format("%s_%s_%s", e.getTemplateId(), e.getEntityId(), e.getEntityRange())).collect(Collectors.toSet());
            for (DynamicObject dynamicObject : existObj) {
                Integer orgRange;
                Long orgId;
                Long templateId = dynamicObject.getLong("applytemplate");
                if (!tempOrgRanges.contains(String.format("%s_%s_%s", templateId, orgId = Long.valueOf(dynamicObject.getLong("org")), orgRange = Integer.valueOf(dynamicObject.getInt("orgrange"))))) continue;
                result.add(new TemplateEntityDto(templateId, orgId, orgRange));
            }
        }
        return result;
    }

    private Set<TemplateEntityDto> checkReportStatus(List<TemplateEntityDto> needUnAllocate) {
        Long id = (Long)this.getModel().getValue("id");
        if (IDUtils.isEmptyLong((Long)id).booleanValue()) {
            return null;
        }
        DynamicObjectCollection dynamicObjects = ReportSchemeAssignService.getInstance().queryRecordByScheme(Collections.singletonList(id));
        if (dynamicObjects == null || dynamicObjects.size() == 0) {
            return null;
        }
        ArrayList<MutableTriple> pdvTripleList = new ArrayList<MutableTriple>(10);
        for (DynamicObject dynamicObject : dynamicObjects) {
            MutableTriple triple = MutableTriple.of((Object)dynamicObject.getLong("year"), (Object)dynamicObject.getLong("datatype"), (Object)dynamicObject.getLong("version"));
            pdvTripleList.add(triple);
        }
        ReportProcessAggService instance = ReportProcessAggService.getInstance();
        List deleteRptProcessRequest = instance.createDeleteRptProcessRequestV2(this.getOrgView(), this.getModelId(), pdvTripleList, needUnAllocate);
        return instance.checkRequestHasApproveBill(deleteRptProcessRequest, this.getModelId(), false);
    }

    private void save(String key, List<Map<String, String>> allocateLis_temp, Set<Long> hasReocrdId) {
        Long id = (Long)this.getModel().getValue("id");
        boolean isNew = false;
        if (id != null && id != 0L) {
            if (ALLOCATE.equals(key)) {
                String range = (String)this.getModel().getValue(ORGRANGETYPE);
                ReportSchemeService.getInstance().deleteRecordByIdTemplateIdAndOrgId(id, this.getSelectTemplate(), this.getSelectOrg(Boolean.TRUE), hasReocrdId, range);
            }
        } else {
            id = GlobalIdUtil.genGlobalLongId();
            isNew = true;
        }
        TebScheme scheme = this.getScheme(id, allocateLis_temp);
        DynamicObject schemeObj = ReportSchemeService.getInstance().saveScheme(scheme, isNew);
        this.updateSchemeScopy(schemeObj);
        Long bizRangeId = scheme.getBizRangeId();
        Set templateIds = scheme.getAllocateRecords().stream().map(TebTemplateAssignOrg::getTemplateId).collect(Collectors.toSet());
        String traceId = RequestContext.getOrCreate().getTraceId();
        EpmThreadPools.CommPools.execute(() -> {
            RequestContext.getOrCreate().setTraceId(traceId);
            RuleRelationService.getInstance().reassignRuleToTemplateIds(this.getModelId(), templateIds, bizRangeId.longValue());
        });
        this.getModel().setValue("id", (Object)id);
        this.setFieldDisabled();
        if (ALLOCATE.equals(key)) {
            this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u5206\u914d\u6210\u529f\u3002", (String)"TemplateUserPermPlugin_13", (String)"epm-eb-formplugin", (Object[])new Object[0]));
        } else {
            this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u4fdd\u5b58\u6210\u529f\u3002", (String)"ReportSchemeEditPlugin_6", (String)"epm-eb-formplugin", (Object[])new Object[0]));
        }
        MultiLangEnumBridge opName = new MultiLangEnumBridge("\u4fdd\u5b58\u65b9\u6848", "ReportSchemeEditPlugin_57", "epm-eb-formplugin");
        MultiLangEnumBridge opDesc = new MultiLangEnumBridge("\u4fdd\u5b58\u6210\u529f,\u5f00\u5173\u72b6\u6001%1$s", "ReportSchemeEditPlugin_58", "epm-eb-formplugin");
        this.writeLog(null, "save", opName, opDesc, new String[]{String.valueOf(scheme.isCommitcheck())});
        if (isNew) {
            this.lockScheme();
        }
    }

    private void updateSchemeScopy(DynamicObject schemeObj) {
        if (schemeObj != null) {
            QFilter qFilter = new QFilter("scheme", "=", (Object)schemeObj.getLong("id"));
            QFilter qFilter1 = new QFilter("templatetype", "=", (Object)SHOWWAY_TEMP);
            QFilter qFilter2 = new QFilter("templatetype", "=", (Object)"0");
            boolean hasApplyRecord = QueryServiceHelper.exists((String)"eb_templateorg", (QFilter[])new QFilter[]{qFilter, qFilter1});
            boolean hasBudgetRecord = QueryServiceHelper.exists((String)"eb_templateorg", (QFilter[])new QFilter[]{qFilter, qFilter2});
            if (hasApplyRecord && hasBudgetRecord) {
                schemeObj.set(APPLYSCOPE, (Object)Character.valueOf('0'));
            } else if (hasApplyRecord) {
                schemeObj.set(APPLYSCOPE, (Object)Character.valueOf('2'));
            } else {
                schemeObj.set(APPLYSCOPE, (Object)Character.valueOf('1'));
            }
            SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{schemeObj});
        }
    }

    private void setFieldDisabled() {
        this.getView().setEnable(Boolean.FALSE, new String[]{NUMBER, BIZRANGE, VIEWRANGE});
    }

    private TebScheme getScheme(Long id, List<Map<String, String>> allocateLis_temp) {
        if (id == null) {
            throw new KDBizException(ResManager.loadKDString((String)"\u65b9\u6848\u4e0d\u5b58\u5728\u3002", (String)"ReportSchemeEditPlugin_8", (String)"epm-eb-formplugin", (Object[])new Object[0]));
        }
        RequestContext context = RequestContext.get();
        Long modelId = this.getModelId();
        Date now = TimeServiceHelper.now();
        TebScheme scheme = new TebScheme();
        scheme.setId(id);
        scheme.setNumber((String)this.getModel().getValue(NUMBER));
        scheme.setName((ILocaleString)this.getModel().getValue("name"));
        scheme.setApplyscope(this.getModel().getValue(APPLYSCOPE).toString());
        scheme.setBizRangeId(Long.valueOf(((DynamicObject)this.getModel().getValue(BIZRANGE)).getLong("id")));
        scheme.setStatus((String)this.getModel().getValue("status"));
        Object description = this.getModel().getValue("description");
        scheme.setDescription(description == null ? "" : description.toString());
        scheme.setCreatorId(Long.valueOf(Long.parseLong(context.getUserId())));
        scheme.setCreateTime(now);
        scheme.setModifierId(Long.valueOf(Long.parseLong(context.getUserId())));
        scheme.setCommitcheck(((Boolean)this.getModel().getValue(COMMITCHECK)).booleanValue());
        scheme.setModifyTime(now);
        int seq = this.getMaxSeq(modelId) + 1;
        scheme.setSeq(seq);
        scheme.setModelId(modelId);
        scheme.setBizRangeId(Long.valueOf(this.getBizRangeId()));
        scheme.setOrgViewId(this.getOrgView());
        scheme.setAllocateRecords(this.getTempAssignOrgRecord(id, allocateLis_temp));
        return scheme;
    }

    private List<TebTemplateAssignOrg> getTempAssignOrgRecord(Long schemeId, List<Map<String, String>> allocateLis_temp) {
        if (allocateLis_temp == null || allocateLis_temp.size() == 0) {
            return new ArrayList<TebTemplateAssignOrg>(16);
        }
        ArrayList<TebTemplateAssignOrg> list = new ArrayList<TebTemplateAssignOrg>(allocateLis_temp.size());
        Long userId = UserUtils.getUserId();
        Date time = TimeServiceHelper.now();
        int seq = 1;
        for (Map<String, String> map : allocateLis_temp) {
            Long id = IDUtils.toLong((Object)map.get("id"));
            if (id == null) {
                id = GlobalIdUtil.genGlobalLongId();
            }
            Long tempateId = IDUtils.toLong((Object)map.get("templateId"));
            Long orgId = IDUtils.toLong((Object)map.get("orgId"));
            String orgRange = map.get("range");
            String templateType = map.get("templatetype");
            TebTemplateAssignOrg templateAssignOrg = templateType.equals("0") ? new TebTemplateAssignOrg(id, tempateId, orgId, orgRange, userId, time, schemeId, seq, templateType) : (templateType.equals(SHOWWAY_TEMP) ? new TebTemplateAssignOrg(id, orgId, orgRange, userId, time, schemeId, seq, tempateId, templateType) : null);
            if (templateAssignOrg == null) continue;
            list.add(templateAssignOrg);
            ++seq;
        }
        return list;
    }

    private int getMaxSeq(Long modelId) {
        int maxSeq = ReportSchemeService.getInstance().getMaxSeq(modelId);
        return maxSeq;
    }

    private void deleteReportProcess(Long schemeId, List<Triple<Long, Long, Long>> pdvTripleList, List<TemplateEntityDto> needUnAllocate) {
        Long modelId = this.getModelId();
        ReportProcessAggService instance = ReportProcessAggService.getInstance();
        List deleteRptProcessRequests = instance.createDeleteRptProcessRequestV2(this.getOrgView(), this.getModelId(), pdvTripleList, needUnAllocate);
        deleteRptProcessRequests.forEach(v -> v.setCancelType(BaseRptProcessRequest.CancelType.UNALLOC));
        instance.deleteReportProcess(deleteRptProcessRequests, modelId);
    }

    private boolean checkNumberAndName() {
        Long id = (Long)this.getModel().getValue("id");
        String number = (String)this.getModel().getValue(NUMBER);
        if (StringUtils.isEmpty((String)number)) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u8f93\u5165\u7f16\u7801\u3002", (String)"ReportSchemeEditPlugin_34", (String)"epm-eb-formplugin", (Object[])new Object[0]));
            return false;
        }
        OrmLocaleValue name = (OrmLocaleValue)this.getModel().getValue("name");
        if (!this.checkAllowNumStart(number)) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u7f16\u7801\u53ea\u80fd\u5305\u542b\u534a\u89d2\u6570\u5b57\u3001\u534a\u89d2\u5b57\u6bcd\u6216-\uff0c\u8bf7\u4fee\u6539\u540e\u91cd\u8bd5\u3002", (String)"ReportSchemeEditPlugin_22", (String)"epm-eb-formplugin", (Object[])new Object[0]), Integer.valueOf(5000));
            return false;
        }
        boolean existRepeatNumber = ReportSchemeService.getInstance().exist(this.getModelId(), NUMBER, number, id);
        if (existRepeatNumber) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u5df2\u5b58\u5728\u8be5\u7f16\u7801\u7684\u65b9\u6848\uff0c\u8bf7\u4fee\u6539\u540e\u91cd\u8bd5\u3002", (String)"ReportSchemeEditPlugin_23", (String)"epm-eb-formplugin", (Object[])new Object[0]));
            return false;
        }
        if (StringUtils.isEmpty((String)name.toString())) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bed\u8a00\u73af\u5883\u540d\u79f0\u4e3a\u7a7a\uff0c\u8bf7\u8f93\u5165\u540d\u79f0\u4fe1\u606f\u3002", (String)"ReportSchemeEditPlugin_4", (String)"epm-eb-formplugin", (Object[])new Object[0]));
            return false;
        }
        boolean existRepeatName = ReportSchemeService.getInstance().exist(this.getModelId(), "name", name.toString().trim(), id);
        if (existRepeatName) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u4f53\u7cfb\u4e2d\u5df2\u5b58\u5728\u8be5\u540d\u79f0\u7684\u65b9\u6848\uff0c\u8bf7\u4fee\u6539\u540e\u91cd\u8bd5\u3002", (String)"ReportSchemeEditPlugin_5", (String)"epm-eb-formplugin", (Object[])new Object[0]));
            return false;
        }
        return true;
    }

    private boolean checkAllowNumStart(String number) {
        Pattern pattern = Pattern.compile("^(?!_)[a-zA-Z0-9\\-]+$");
        Matcher matcher = pattern.matcher(number);
        return matcher.matches() && !number.contains(".") && !number.contains(",") && !number.contains("\uff0c");
    }

    private void allocate() {
        if (!this.checkNumberAndName()) {
            return;
        }
        Long id = (Long)this.getModel().getValue("id");
        TreeView treeView = (TreeView)this.getControl(TEMPLATETREE);
        List selectedNodes = treeView.getTreeState().getSelectedNodes();
        Map<Long, Set<Long>> orgTemplateMap = this.getOrgTemplateMap();
        selectedNodes.removeIf(e -> (Boolean)e.get("isParent") != false || "".equals(e.get("parentid")));
        Map<Long, Set<Long>> OrgTemplateData = this.getOrgTemplateData();
        TreeView orgTree = (TreeView)this.getControl(ORG_TREE);
        ArrayList<Object> orgSelect = orgTree.getTreeState().getSelectedNodes();
        orgSelect.removeIf(e -> "".equals(e.get("parentid")));
        TreeView propTree = (TreeView)this.getControl(PROP_TREE);
        List propSelect = propTree.getTreeState().getSelectedNodeId();
        IModelCacheHelper modelCacheHelper = ModelCacheContext.getOrCreate((Long)this.getModelId());
        if (CollectionUtils.isNotEmpty((Collection)propSelect)) {
            String range = (String)this.getModel().getValue(ORGRANGETYPE);
            Set<Object> orgSelectIdSet = new HashSet(16);
            if (range.equals(RangeEnum.VALUE_10.getValue() + "") && CollectionUtils.isNotEmpty((Collection)orgSelect)) {
                orgSelectIdSet = orgSelect.stream().map(x -> IDUtils.toLong(x.get("id"))).collect(Collectors.toSet());
            }
            MemberPropCache memberPropCache = MemberPropCacheService.getOrCreate((Long)this.getModelId());
            Dimension dimension = modelCacheHelper.getDimension(SysDimensionEnum.Entity.getNumber());
            for (String relationId : propSelect) {
                List members = memberPropCache.getMembersByPropValues(dimension.getId(), this.getOrgView(), IDUtils.toLong((Object)relationId));
                if (!CollectionUtils.isNotEmpty((Collection)members)) continue;
                DynamicObject value = (DynamicObject)this.getModel().getValue(VIEWRANGE);
                for (Member member : members) {
                    Member dimensionMember = dimension.getMember(Long.valueOf(value.getLong("id")), member.getNumber());
                    if (dimensionMember == null) continue;
                    HashMap tempMember = new HashMap(3);
                    if (orgSelectIdSet.contains(member.getId())) continue;
                    tempMember.put("id", member.getId() + "");
                    tempMember.put(NUMBER, dimensionMember.getNumber());
                    tempMember.put("range", RangeEnum.VALUE_10.getValue());
                    if (CollectionUtils.isEmpty((Collection)orgSelect)) {
                        orgSelect = new ArrayList<Object>(16);
                    }
                    orgSelect.add(tempMember);
                }
            }
        }
        if (CollectionUtils.isEmpty((Collection)selectedNodes) || CollectionUtils.isEmpty((Collection)orgSelect)) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u68c0\u67e5\u662f\u5426\u5df2\u52fe\u9009\u6a21\u677f\u548c\u7ec4\u7ec7\uff0c\u6216\u6240\u9009\u7ec4\u7ec7\u5c5e\u6027\u662f\u5426\u5173\u8054\u7ec4\u7ec7\u3002", (String)"ReportSchemeEditPlugin_11", (String)"epm-eb-formplugin", (Object[])new Object[0]));
            return;
        }
        HashSet orgMaps = Sets.newHashSet((Iterable)orgSelect);
        Map<String, Long> existKeys = this.getExistKeys();
        ArrayList<Map<String, String>> allocateLis_temp = new ArrayList<Map<String, String>>(16);
        int expectSize = orgMaps.size() * selectedNodes.size();
        long[] ids = GlobalIdUtil.genGlobalLongIds((int)expectSize);
        int i = 0;
        int j = 0;
        int k = 0;
        int x2 = 0;
        Map templates = ReportSchemeService.getInstance().getTemplateByID(this.getModelId());
        HashSet<Long> hasRecordId = new HashSet<Long>(16);
        for (Map orgMap : orgMaps) {
            String range = (String)this.getModel().getValue(ORGRANGETYPE);
            if (orgMap.containsKey("range")) {
                range = orgMap.get("range") + "";
            }
            String orgId = (String)orgMap.get("id");
            Member member = modelCacheHelper.getMember(SysDimensionEnum.Entity.getNumber(), this.getOrgView(), IDUtils.toLong((Object)orgId));
            if (member == null) {
                this.getView().showTipNotification(ResManager.loadResFormat((String)"\u7ec4\u7ec7\uff1a%1\u4e0d\u5b58\u5728\uff0c\u8bf7\u68c0\u67e5\u7ec4\u7ec7\u662f\u5426\u5df2\u5220\u9664\u3002", (String)"ReportSchemeEditPlugin_37", (String)"epm-eb-formplugin", (Object[])new Object[]{orgMap.get("text")}));
                return;
            }
            String orgNumber = member.getNumber();
            for (Map selectedNode : selectedNodes) {
                HashMap<String, String> map = new HashMap<String, String>(16);
                String templateId = (String)selectedNode.get("id");
                DynamicObject templateDyn = (DynamicObject)templates.get(templateId);
                if (templateDyn == null) {
                    this.getView().showTipNotification(ResManager.loadResFormat((String)"\u6a21\u677f\u201c%1\u201d\u4e0d\u5b58\u5728\uff0c\u8bf7\u68c0\u67e5\u6a21\u677f\u662f\u5426\u5df2\u5220\u9664\u3002", (String)"ReportSchemeEditPlugin_45", (String)"epm-eb-formplugin", (Object[])new Object[]{selectedNode.get("text")}));
                    return;
                }
                String key = orgId + "_" + templateId + "_" + range;
                if (existKeys.containsKey(key)) {
                    hasRecordId.add(existKeys.get(key));
                    continue;
                }
                String templateType = this.getTemplateType(selectedNode);
                Set<Object> orgSet = new HashSet(16);
                if (SHOWWAY_TEMP.equals(templateType)) {
                    orgSet = this.getOrgs(orgNumber, Integer.parseInt(range));
                    if (orgSet.size() == 0) {
                        ++k;
                        continue;
                    }
                    if (this.isOutOfLimit(orgSet, orgTemplateMap).booleanValue()) {
                        ++j;
                        continue;
                    }
                    if (SHOWWAY_TEMP.equals(templateType) && this.isOutOfLimit(orgSet, OrgTemplateData).booleanValue()) {
                        ++x2;
                        continue;
                    }
                }
                map.put("templatetype", templateType);
                map.put("orgId", orgId);
                map.put("orgNumber", orgNumber);
                map.put("range", String.valueOf(range));
                map.put("templateId", templateId);
                map.put("templateName", templateDyn.getString("name"));
                map.put("templateNumber", templateDyn.getString(NUMBER));
                map.put("id", String.valueOf(ids[i]));
                ++i;
                allocateLis_temp.add(map);
                if (!SHOWWAY_TEMP.equals(templateType)) continue;
                this.addWillAllocateRecords(orgTemplateMap, orgSet, IDUtils.toLong((Object)templateId));
            }
        }
        if (allocateLis_temp.size() + j + k < expectSize) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u91cd\u590d\u7684\u6a21\u677f\u3001\u7ec4\u7ec7\u4e0e\u7ec4\u7ec7\u8303\u56f4\u7ec4\u5408\u4e0d\u4f1a\u6dfb\u52a0\u5230\u5df2\u5206\u914d\u5217\u8868\u3002", (String)"ReportSchemeEditPlugin_12", (String)"epm-eb-formplugin", (Object[])new Object[0]));
        }
        if (j > 0) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u6bcf\u4e2a\u7ec4\u7ec7\u6700\u591a\u53ea\u80fd\u5206\u914d\u5341\u4e2a\u7533\u62a5\u6a21\u677f\u3002", (String)"ReportSchemeEditPlugin_21", (String)"epm-eb-formplugin", (Object[])new Object[0]));
        }
        if (k > 0) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u4e0d\u5b58\u5728\u4efb\u4f55\u7ec4\u7ec7\u6210\u5458\u7684\u8bb0\u5f55\u4e0d\u4f1a\u6dfb\u52a0\u5230\u5df2\u5206\u914d\u5217\u8868\u3002", (String)"ReportSchemeEditPlugin_27", (String)"epm-eb-formplugin", (Object[])new Object[0]));
        }
        if (x2 > 0) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u540c\u4e00\u7ec4\u7ec7\u8303\u56f4\u4e0b\u4e0d\u80fd\u5206\u914d\u8d85\u8fc7\u5341\u4e2a\u7533\u62a5\u6a21\u677f\u3002", (String)"ReportSchemeEditPlugin_39", (String)"epm-eb-formplugin", (Object[])new Object[0]));
        }
        if (allocateLis_temp.size() == 0) {
            return;
        }
        this.save(ALLOCATE, allocateLis_temp, hasRecordId);
        treeView.uncheckNodes(treeView.getTreeState().getSelectedNodeId());
        orgTree.uncheckNodes(orgTree.getTreeState().getSelectedNodeId());
        propTree.uncheckNodes(propTree.getTreeState().getSelectedNodeId());
        this.refreshAllocateEntry(false);
        MultiLangEnumBridge opName = new MultiLangEnumBridge("\u5206\u914d", "ReportSchemeEditPlugin_54", "epm-eb-formplugin");
        MultiLangEnumBridge opMsg = new MultiLangEnumBridge("\u5206\u914d\u6210\u529f\u3002", "ReportSchemeEditPlugin_28", "epm-eb-formplugin");
        this.writeLog(null, "assign", opName, opMsg, null);
    }

    private String getTemplateType(Map<String, Object> selectedNode) {
        String templateType = null;
        if (this.templateTypeMap != null && this.templateTypeMap.size() > 0) {
            templateType = this.templateTypeMap.get((String)selectedNode.get("id"));
        } else {
            String treeCache = this.getPageCache().get(TEMPLATE_TYPE_CHACH);
            if (treeCache != null) {
                this.templateTypeMap = (Map)ObjectSerialUtil.deSerializedBytes((String)treeCache);
                if (this.templateTypeMap != null && this.templateTypeMap.size() > 0) {
                    templateType = this.templateTypeMap.get((String)selectedNode.get("id"));
                }
            }
        }
        return templateType;
    }

    private void addWillAllocateRecords(Map<Long, Set<Long>> orgTemplateMap, Set<Long> orgSet, Long templateId) {
        if (orgSet != null) {
            for (Long orgId : orgSet) {
                Set set = orgTemplateMap.computeIfAbsent(orgId, k -> new HashSet(16));
                set.add(templateId);
                orgTemplateMap.put(orgId, set);
            }
        }
    }

    private Boolean isOutOfLimit(Set<Long> orgIds, Map<Long, Set<Long>> orgTemplateMap) {
        for (Long orgId : orgIds) {
            if (orgTemplateMap.get(orgId) == null || orgTemplateMap.get(orgId).size() != 10) continue;
            return true;
        }
        return false;
    }

    private Map<Long, Set<Long>> getOrgTemplateMap() {
        QFilter qFilter = new QFilter("scheme", "=", this.getModel().getValue("id"));
        qFilter.and("templatetype", "=", (Object)SHOWWAY_TEMP);
        DynamicObjectCollection result = QueryServiceHelper.query((String)"eb_templateorg", (String)"id,org.id,org.number,org.name,orgrange,applytemplate.id,applytemplate.name,applytemplate.number", (QFilter[])qFilter.toArray());
        HashMap<Long, Set<Long>> map = new HashMap<Long, Set<Long>>(16);
        for (DynamicObject dynamicObject : result) {
            Long templateId = dynamicObject.getLong("applytemplate.id");
            String orgNumber = dynamicObject.getString("org.number");
            int orgRange = dynamicObject.getInt("orgrange");
            Set<Long> orgs = this.getOrgs(orgNumber, orgRange);
            for (Long id : orgs) {
                Set set = map.computeIfAbsent(id, k -> new HashSet(16));
                set.add(templateId);
                map.put(id, set);
            }
        }
        return map;
    }

    private Map<Long, Set<Long>> getOrgTemplateData() {
        Long schemeId = (Long)this.getModel().getValue("id");
        DynamicObjectCollection dynamicObjects = this.queryTemplateOrgBySchemeid(schemeId);
        HashMap<Long, Set<Long>> map = new HashMap<Long, Set<Long>>(16);
        for (DynamicObject dynamicObject : dynamicObjects) {
            String templateType = dynamicObject.getString("templatetype");
            if (!SHOWWAY_TEMP.equals(templateType)) continue;
            Long templateId = dynamicObject.getLong("applytemplate.id");
            String orgNumber = dynamicObject.getString("org.number");
            int orgRange = dynamicObject.getInt("orgrange");
            Set<Long> orgs = this.getOrgs(orgNumber, orgRange);
            for (Long id : orgs) {
                Set set = map.computeIfAbsent(id, k -> new HashSet(16));
                set.add(templateId);
                map.put(id, set);
            }
        }
        return map;
    }

    public DynamicObjectCollection queryTemplateOrgBySchemeid(Long schemeId) {
        String selectFields = "id,applytemplate.id,applytemplate.number,applytemplate.name,org,org.number,org.id,org.name,allocater,allocatetime,orgrange,recordseq,templatetype";
        QFilter qf = new QFilter("scheme", "=", (Object)schemeId);
        return QueryServiceHelper.query((String)"eb_templateorg", (String)selectFields, (QFilter[])new QFilter[]{qf}, (String)"recordseq");
    }

    private Set<Long> getOrgs(String orgNumber, int range) {
        HashSet<Long> set = new HashSet<Long>(16);
        IModelCacheHelper modelCacheHelper = ModelCacheContext.getOrCreate((Long)this.getModelId());
        List members = modelCacheHelper.getMember(SysDimensionEnum.Entity.getNumber(), this.getOrgView(), orgNumber, range);
        if (members != null) {
            for (Member member : members) {
                if (member.isDisable()) continue;
                set.add(member.getId());
            }
        }
        return set;
    }

    private Map<String, Long> getExistKeys() {
        HashMap<String, Long> temp = new HashMap<String, Long>(16);
        DynamicObjectCollection entryEntity = this.getHistoryReocrd(IDUtils.toLong((Object)this.getModel().getValue("id")));
        if (entryEntity != null && entryEntity.size() > 0) {
            for (DynamicObject dynamicObject : entryEntity) {
                if (dynamicObject == null || IDUtils.toLong((Object)dynamicObject.getLong("org.id")) == null) continue;
                String templatetype = dynamicObject.getString("templatetype");
                String templateId = "0".equals(templatetype) ? dynamicObject.getString("template.id") : dynamicObject.getString("applytemplate.id");
                StringBuilder sb = new StringBuilder();
                sb.append(dynamicObject.getString("org.id")).append("_").append(templateId).append("_").append(dynamicObject.getString("orgrange"));
                temp.put(sb.toString(), dynamicObject.getLong("id"));
            }
        }
        return temp;
    }

    public void propertyChanged(PropertyChangedArgs e) {
        String key = e.getProperty().getName();
        if (TEMPSHOWTYPE.equals(key)) {
            TreeView treeView = (TreeView)this.getControl(TEMPLATETREE);
            TreeView.TreeState treeState = treeView.getTreeState();
            List checkedNodeIds = treeState.getCheckedNodeIds();
            if (CollectionUtils.isNotEmpty((Collection)checkedNodeIds)) {
                this.getPageCache().put(TEMPLATE_CHECKEDIDS_CACHE, SerializationUtils.serializeToBase64((Object)checkedNodeIds));
            }
            this.refreshTemplateTree();
        } else if (ORGSHOWTYPE.equals(key)) {
            this.refrehsOrgTree();
        } else if (SHOWWAY.equals(key)) {
            this.refreshAllocateEntry(false);
        } else if (BIZRANGE.equals(key)) {
            DynamicObject newVal = (DynamicObject)e.getChangeSet()[0].getNewValue();
            if (newVal != null) {
                this.getPageCache().put(BIZRANGE, newVal.getString("id"));
                this.getModel().setValue(VIEWRANGE, null);
                this.getView().setEnable(Boolean.TRUE, new String[]{VIEWRANGE});
                this.refreshTemplateTree();
                this.refreshAllocateEntry(true);
            } else {
                this.getPageCache().put(BIZRANGE, null);
                this.getView().setEnable(Boolean.FALSE, new String[]{VIEWRANGE});
                this.cleanEntryAndTree();
            }
        } else if (VIEWRANGE.equals(key)) {
            DynamicObject newVal = (DynamicObject)e.getChangeSet()[0].getNewValue();
            if (newVal != null) {
                this.getPageCache().put(VIEWRANGE, newVal.getString("id"));
                this.refrehsOrgTree();
                if (this.isNewEbForm()) {
                    this.refreshTemplateTree();
                }
                this.refreshAllocateEntry(true);
            } else {
                this.getPageCache().put(BIZRANGE, null);
                this.getView().setEnable(Boolean.FALSE, new String[]{VIEWRANGE});
                this.cleanEntryAndTree();
            }
        } else if (APPLYSCOPE.equals(key)) {
            this.refreshTemplateTree();
        }
    }

    private void cleanEntryAndTree() {
        TreeView treeView = (TreeView)this.getControl(TEMPLATETREE);
        treeView.deleteAllNodes();
        TreeView orgTreeView = (TreeView)this.getControl(ORG_TREE);
        orgTreeView.deleteAllNodes();
        TreeView propTreeView = (TreeView)this.getControl(PROP_TREE);
        propTreeView.deleteAllNodes();
        this.getPageCache().remove(TEMPLATETREE_CACHE);
        this.getPageCache().remove(TEMPLATECACHEIDS);
        this.getPageCache().remove(ORG_TREE_CACHE);
        this.getPageCache().remove(PROP_TREE_CACHE);
        BillList billList = (BillList)this.getView().getControl(BILLLISTAP);
        billList.clearData();
    }

    public void click(EventObject evt) {
        String key;
        super.click(evt);
        Control control = (Control)evt.getSource();
        switch (key = control.getKey()) {
            case "tempbefore": {
                TreeSearchUtil.getLeftOrRight(this.getPageCache(), this.getView(), new TreeSearchUtil.TreeSearchParam(TEMPLATETREE, TEMPLATETREE_CACHE, TreeSearchUtil.SearchBtnStatus.LEFT));
                break;
            }
            case "tempnext": {
                TreeSearchUtil.getLeftOrRight(this.getPageCache(), this.getView(), new TreeSearchUtil.TreeSearchParam(TEMPLATETREE, TEMPLATETREE_CACHE, TreeSearchUtil.SearchBtnStatus.RIGHT));
                break;
            }
            case "orgbefore": {
                TreeSearchUtil.getLeftOrRight(this.getPageCache(), this.getView(), new TreeSearchUtil.TreeSearchParam(ORG_TREE, ORG_TREE_CACHE, TreeSearchUtil.SearchBtnStatus.LEFT));
                break;
            }
            case "orgnext": {
                TreeSearchUtil.getLeftOrRight(this.getPageCache(), this.getView(), new TreeSearchUtil.TreeSearchParam(ORG_TREE, ORG_TREE_CACHE, TreeSearchUtil.SearchBtnStatus.RIGHT));
                break;
            }
            case "propbefore": {
                TreeSearchUtil.getLeftOrRight(this.getPageCache(), this.getView(), new TreeSearchUtil.TreeSearchParam(PROP_TREE, PROP_TREE_CACHE, TreeSearchUtil.SearchBtnStatus.LEFT));
                break;
            }
            case "propnext": {
                TreeSearchUtil.getLeftOrRight(this.getPageCache(), this.getView(), new TreeSearchUtil.TreeSearchParam(PROP_TREE, PROP_TREE_CACHE, TreeSearchUtil.SearchBtnStatus.RIGHT));
                break;
            }
            case "btn_adddel": {
                this.addDelete();
                break;
            }
            case "btn_canceldel": {
                this.cancelDelete();
                break;
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    private void addDelete() {
        Set<TemplateEntityDto> apListCheckResult;
        BillList billList = (BillList)this.getControl(BILLLISTAP);
        ListSelectedRowCollection rows_temp = billList.getSelectedRows();
        Set<Long> selectOrg = this.getSelectOrg(Boolean.FALSE);
        if (rows_temp.size() <= 0 || CollectionUtils.isEmpty(selectOrg)) {
            this.getView().showTipNotification(ResManager.loadKDStringExt((String)"\u8bf7\u9009\u62e9\u7ec4\u7ec7\u548c\u5206\u914d\u8bb0\u5f55\u3002", (String)"BGMD-W-488118", (String)"prompt-bgm", (Object[])new Object[0]));
            return;
        }
        Set collect = rows_temp.stream().map(x -> x.getPrimaryKeyValue()).collect(Collectors.toSet());
        HashMap<Long, String> templateInfoMap = new HashMap<Long, String>(16);
        HashMap<Long, String> orgInfoMap = new HashMap<Long, String>(16);
        QFilter qFilter = new QFilter("id", "in", (Object)IDUtils.toLongs(collect));
        DynamicObject[] dynamicObjects = BusinessDataServiceHelper.load((String)"eb_templateorg", (String)"id,org,orgrange,deleteentity,deleteentity.entity,templatetype,template,applytemplate", (QFilter[])qFilter.toArray());
        if (dynamicObjects == null || dynamicObjects.length == 0) {
            log.info("\u5206\u914d\u8bb0\u5f55\u4e0d\u5b58\u5728");
            return;
        }
        HashMap<Integer, String> orgRangeNames = new HashMap<Integer, String>(16);
        for (RangeEnum rangeEnum : RangeEnum.values()) {
            orgRangeNames.put(rangeEnum.getValue(), rangeEnum.getName());
        }
        ArrayList<TemplateEntityDto> needUnAllocate = new ArrayList<TemplateEntityDto>(10);
        ArrayList<TemplateEntityDto> needUnAllocateAp = new ArrayList<TemplateEntityDto>(10);
        HashMap<String, Set> rangeCahce = new HashMap<String, Set>(16);
        IModelCacheHelper orCreate = ModelCacheContext.getOrCreate((Long)this.getModelId());
        String title = ResManager.loadKDStringExt((String)"\u79fb\u9664\u7ed3\u679c", (String)"BGMD-C-587078", (String)"prompt-bgm", (Object[])new Object[0]);
        ArrayList<OperateErrorInfo> outOfRangeList = new ArrayList<OperateErrorInfo>(16);
        for (Long aLong : selectOrg) {
            Member member = orCreate.getMember(SysDimensionEnum.Entity.getNumber(), this.getOrgView(), aLong);
            orgInfoMap.put(aLong, member.getName());
        }
        for (DynamicObject dynamicObject : dynamicObjects) {
            void var21_27;
            Iterator templatetype = dynamicObject.getString("templatetype");
            Long l = dynamicObject.getLong("template.id");
            String templateName = dynamicObject.getString("template.name");
            if (SHOWWAY_TEMP.equals(templatetype)) {
                Long l2 = dynamicObject.getLong("applytemplate.id");
                templateName = dynamicObject.getString("applytemplate.name");
            }
            templateInfoMap.putIfAbsent((Long)var21_27, templateName);
            String orgName = dynamicObject.getString("org.name");
            Long orgid = dynamicObject.getLong("org.id");
            orgInfoMap.putIfAbsent(orgid, orgName);
            for (Long orgId : selectOrg) {
                TemplateEntityDto templateEntityDto;
                String rangeKey = dynamicObject.getString("org.id") + "_" + dynamicObject.getInt("orgrange");
                Set set = rangeCahce.computeIfAbsent(rangeKey, x -> new HashSet(16));
                if (CollectionUtils.isEmpty((Collection)set)) {
                    List orgrange = orCreate.getMember(SysDimensionEnum.Entity.getNumber(), this.getOrgView(), dynamicObject.getString("org.number"), dynamicObject.getInt("orgrange"));
                    set.addAll(orgrange.stream().map(x -> x.getId()).collect(Collectors.toSet()));
                }
                if (!set.contains(orgId)) {
                    OperateErrorInfo operateErrorInfo = new OperateErrorInfo();
                    String msg = ResManager.loadResFormat((String)"%1$s,%2$s\uff08%3$s\uff09\u79fb\u9664%4$s\u5931\u8d25\uff0c\u79fb\u9664\u7ec4\u7ec7\u4e0d\u5728\u5206\u914d\u8303\u56f4\u5185\u3002", (String)"ReportSchemeEditPlugin_46", (String)"epm-eb-formplugin", (Object[])new Object[]{templateInfoMap.get(var21_27), orgInfoMap.get(orgId), orgRangeNames.get(dynamicObject.getInt("orgrange")), orgInfoMap.get(orgId)});
                    operateErrorInfo.setTitle(this.getRealMsg(title));
                    operateErrorInfo.setLevel(ErrorLevel.Error);
                    operateErrorInfo.setMessage(this.getRealMsg(MMPMsgUtils.getMessageInfo((String)msg, (String)"BGMD-N-166660")));
                    outOfRangeList.add(operateErrorInfo);
                    continue;
                }
                Member member = orCreate.getMember(SysDimensionEnum.Entity.getNumber(), this.getOrgView(), orgId);
                if (member != null) {
                    orgInfoMap.put(orgId, member.getName());
                }
                if ("0".equals(templatetype)) {
                    templateEntityDto = new TemplateEntityDto((Long)var21_27, orgId, Integer.valueOf(RangeEnum.VALUE_10.getValue()));
                    templateEntityDto.setRecordId(Long.valueOf(dynamicObject.getLong("id")));
                    needUnAllocate.add(templateEntityDto);
                    continue;
                }
                templateEntityDto = new TemplateEntityDto((Long)var21_27, orgId, Integer.valueOf(RangeEnum.VALUE_10.getValue()));
                templateEntityDto.setRecordId(Long.valueOf(dynamicObject.getLong("id")));
                needUnAllocateAp.add(templateEntityDto);
            }
        }
        Set<TemplateEntityDto> templateEntityDtosWithData = null;
        if (needUnAllocate.size() > 0) {
            templateEntityDtosWithData = this.checkReportStatus(needUnAllocate);
        }
        if (needUnAllocateAp.size() > 0 && (apListCheckResult = this.checkApReportStatus(needUnAllocateAp)) != null) {
            if (templateEntityDtosWithData == null) {
                templateEntityDtosWithData = apListCheckResult;
            } else {
                templateEntityDtosWithData.addAll(apListCheckResult);
            }
        }
        OperationResult operationResult = new OperationResult();
        boolean isAllSuccess = true;
        ArrayList<Object> successObj = new ArrayList<Object>(16);
        if (templateEntityDtosWithData != null && templateEntityDtosWithData.size() > 0) {
            for (TemplateEntityDto templateEntityDto : templateEntityDtosWithData) {
                Optional<DynamicObject> first = Arrays.stream(dynamicObjects).filter(x -> IDUtils.equals((Object)x.getLong("id"), (Object)templateEntityDtosWithDatum.getRecordId())).findFirst();
                if (!first.isPresent()) continue;
                DynamicObject dynamicObject = first.get();
                String msg = ResManager.loadResFormat((String)"%1$s-%2$s\uff08%3$s\uff09\u79fb\u9664%4$s\u5931\u8d25\uff0c\u8bf7\u68c0\u67e5\u5bf9\u5e94\u5b9e\u4f8b\u72b6\u6001\u662f\u5426\u4e3a\u5df2\u63d0\u4ea4\u3001\u5df2\u5ba1\u6838\u3002", (String)"ReportSchemeEditPlugin_56", (String)"epm-eb-formplugin", (Object[])new Object[]{templateInfoMap.get(templateEntityDto.getTemplateId()), orgInfoMap.get(dynamicObject.getLong("org.id")), orgRangeNames.get(dynamicObject.getInt("orgrange")), orgInfoMap.get(templateEntityDto.getEntityId())});
                OperateErrorInfo operateErrorInfo = new OperateErrorInfo();
                operateErrorInfo.setTitle(this.getRealMsg(title));
                operateErrorInfo.setLevel(ErrorLevel.Error);
                operateErrorInfo.setMessage(msg);
                operationResult.addErrorInfo(operateErrorInfo);
                isAllSuccess = false;
            }
            if (!isAllSuccess) {
                this.getSuccessMsg(templateInfoMap, orgInfoMap, dynamicObjects, orgRangeNames, needUnAllocate, needUnAllocateAp, templateEntityDtosWithData, successObj);
            }
        } else {
            this.getSuccessMsg(templateInfoMap, orgInfoMap, dynamicObjects, orgRangeNames, needUnAllocate, needUnAllocateAp, null, successObj);
        }
        if (CollectionUtils.isNotEmpty(outOfRangeList)) {
            for (OperateErrorInfo operateErrorInfo : outOfRangeList) {
                operationResult.addErrorInfo(operateErrorInfo);
            }
        }
        operationResult.setSuccessPkIds(successObj);
        operationResult.setBillCount(dynamicObjects.length * selectOrg.size());
        HashMap<Long, Set<Long>> failRecordMap = new HashMap<Long, Set<Long>>(16);
        if (templateEntityDtosWithData != null && templateEntityDtosWithData.size() > 0) {
            for (TemplateEntityDto templateEntityDtosWithDatum : templateEntityDtosWithData) {
                Set set = failRecordMap.computeIfAbsent(templateEntityDtosWithDatum.getRecordId(), x -> new HashSet(16));
                set.add(templateEntityDtosWithDatum.getEntityId());
            }
        }
        AddDeleteEntityConfirmDto addDeleteEntityConfirmDto = new AddDeleteEntityConfirmDto();
        failRecordMap.entrySet().removeIf(entry -> entry.getKey() == null);
        addDeleteEntityConfirmDto.setFailRecordMap(failRecordMap);
        needUnAllocate.addAll(needUnAllocateAp);
        addDeleteEntityConfirmDto.setNeedUnAllocate(needUnAllocate);
        this.getPageCache().put(ADDDELETE_CAHCE, SerializationUtils.toJsonString((Object)addDeleteEntityConfirmDto));
        String opTitle = ResManager.loadKDStringExt((String)"\u8bf7\u786e\u8ba4\u4ece\u5df2\u5206\u914d\u8bb0\u5f55\u4e2d\u79fb\u9664\u7ec4\u7ec7\u3002", (String)"BGMD-N-435380", (String)"prompt-bgm", (Object[])new Object[0]);
        this.showOperationResultMulti(operationResult, ResManager.loadKDStringExt((String)"\u79fb\u9664\u7ed3\u679c", (String)"BGMD-C-587078", (String)"prompt-bgm", (Object[])new Object[0]), BTN_ADDDEL, opTitle);
    }

    private void getSuccessMsg(Map<Long, String> templateInfoMap, Map<Long, String> orgInfoMap, DynamicObject[] dynamicObjects, Map<Integer, String> orgRangeNames, List<TemplateEntityDto> needUnAllocate, List<TemplateEntityDto> needUnAllocateAp, Set<TemplateEntityDto> templateEntityDtosWithData, List<Object> successObj) {
        String msg;
        DynamicObject dynamicObject;
        Optional<DynamicObject> first;
        if (CollectionUtils.isNotEmpty(needUnAllocate)) {
            for (TemplateEntityDto templateEntityDto : needUnAllocate) {
                if (CollectionUtils.isNotEmpty(templateEntityDtosWithData) && templateEntityDtosWithData.contains(templateEntityDto) || !(first = Arrays.stream(dynamicObjects).filter(x -> IDUtils.equals((Object)x.getLong("id"), (Object)templateEntityDto.getRecordId())).findFirst()).isPresent()) continue;
                dynamicObject = first.get();
                msg = ResManager.loadResFormat((String)"%1$s,%2$s\uff08%3$s\uff09\u79fb\u9664%4$s", (String)"ReportSchemeEditPlugin_47", (String)"epm-eb-formplugin", (Object[])new Object[]{templateInfoMap.get(templateEntityDto.getTemplateId()), orgInfoMap.get(dynamicObject.getLong("org.id")), orgRangeNames.get(dynamicObject.getInt("orgrange")), orgInfoMap.get(templateEntityDto.getEntityId())});
                successObj.add(msg);
            }
        }
        if (CollectionUtils.isNotEmpty(needUnAllocateAp)) {
            for (TemplateEntityDto templateEntityDto : needUnAllocateAp) {
                if (CollectionUtils.isNotEmpty(templateEntityDtosWithData) && templateEntityDtosWithData.contains(templateEntityDto) || !(first = Arrays.stream(dynamicObjects).filter(x -> IDUtils.equals((Object)x.getLong("id"), (Object)templateEntityDto.getRecordId())).findFirst()).isPresent()) continue;
                dynamicObject = first.get();
                msg = ResManager.loadResFormat((String)"%1$s,%2$s\uff08%3$s\uff09\u79fb\u9664%4$s", (String)"ReportSchemeEditPlugin_47", (String)"epm-eb-formplugin", (Object[])new Object[]{templateInfoMap.get(templateEntityDto.getTemplateId()), orgInfoMap.get(dynamicObject.getLong("org.id")), orgRangeNames.get(dynamicObject.getInt("orgrange")), orgInfoMap.get(templateEntityDto.getEntityId())});
                successObj.add(msg);
            }
        }
    }

    private void cancelDelete() {
        BillList billList = (BillList)this.getControl(BILLLISTAP);
        ListSelectedRowCollection rows_temp = billList.getSelectedRows();
        Set<Long> selectOrg = this.getSelectOrg(Boolean.TRUE);
        if (rows_temp.size() <= 0 || CollectionUtils.isEmpty(selectOrg)) {
            this.getView().showTipNotification(ResManager.loadKDStringExt((String)"\u8bf7\u9009\u62e9\u7ec4\u7ec7\u548c\u5206\u914d\u8bb0\u5f55\u3002", (String)"BGMD-W-488118", (String)"prompt-bgm", (Object[])new Object[0]));
            return;
        }
        Set collect = rows_temp.stream().map(x -> x.getPrimaryKeyValue()).collect(Collectors.toSet());
        QFilter qFilter = new QFilter("id", "in", (Object)IDUtils.toLongs(collect));
        DynamicObject[] dynamicObjects = BusinessDataServiceHelper.load((String)"eb_templateorg", (String)"id,org,orgrange,deleteentity,deleteentity.entity,templatetype,template,applytemplate", (QFilter[])qFilter.toArray());
        if (dynamicObjects == null || dynamicObjects.length == 0) {
            log.info("\u5206\u914d\u8bb0\u5f55\u4e0d\u5b58\u5728");
            return;
        }
        DynamicObjectType deleteentity = dynamicObjects[0].getDynamicObjectCollection("deleteentity").getDynamicObjectType();
        for (DynamicObject dynamicObject : dynamicObjects) {
            DynamicObjectCollection deleteentity1 = dynamicObject.getDynamicObjectCollection("deleteentity");
            Set recordDelete = deleteentity1.stream().map(x -> x.getLong("entity.id")).collect(Collectors.toSet());
            if (Collections.disjoint(recordDelete, selectOrg)) continue;
            DynamicObjectCollection dynamicObjectCollection = new DynamicObjectCollection(deleteentity, (Object)dynamicObject);
            for (Long aLong : recordDelete) {
                if (selectOrg.contains(aLong)) continue;
                DynamicObject dynamicObject1 = dynamicObjectCollection.addNew();
                dynamicObject1.set("entity", (Object)aLong);
            }
            dynamicObject.getDynamicObjectCollection("deleteentity").clear();
            if (!CollectionUtils.isNotEmpty((Collection)dynamicObjectCollection)) continue;
            dynamicObject.getDynamicObjectCollection("deleteentity").addAll((Collection)dynamicObjectCollection);
        }
        try (TXHandle tx = TX.required();){
            try {
                SaveServiceHelper.save((DynamicObject[])dynamicObjects);
            }
            catch (Throwable e) {
                tx.markRollback();
                throw new KDBizException(e.getMessage());
            }
        }
        this.refreshAllocateEntry(false);
    }

    public void treeNodeCheck(TreeNodeCheckEvent treeNodeCheckEvent) {
        this.refreshAllocateEntry(false);
    }

    protected QFilter getqFilter() {
        Long schemeId = -1L;
        Long id = (Long)this.getModel().getValue("id");
        if (IDUtils.isNotNull((Long)id)) {
            schemeId = id;
        }
        QFilter qFilter = new QFilter("scheme", "=", (Object)schemeId);
        if (-1L == schemeId) {
            return new QFilter("id", "=", (Object)0);
        }
        Set<Long> templateIdset = this.getSelectTemplate();
        if (CollectionUtils.isNotEmpty(templateIdset)) {
            qFilter.and("template", "in", templateIdset).or(new QFilter("scheme", "=", (Object)schemeId).and(new QFilter("applytemplate", "in", templateIdset)));
        }
        String selectTabKey = this.getPageCache().get(SELECT_TAB_CACHE);
        Set<Long> orgSelectSet = this.getSelectOrg(Boolean.TRUE);
        if ("deletetab".equals(selectTabKey)) {
            if (CollectionUtils.isNotEmpty(orgSelectSet)) {
                qFilter.and("deleteentity.entity.id", "in", orgSelectSet);
            } else {
                qFilter.and("deleteentity", "is not null", (Object)"");
            }
            return qFilter;
        }
        QFilter qFilterParent = null;
        if (CollectionUtils.isNotEmpty(orgSelectSet)) {
            Set set;
            IModelCacheHelper orCreate = ModelCacheContext.getOrCreate((Long)this.getModelId());
            HashSet parentOrgSet = new HashSet(16);
            for (Long aLong : orgSelectSet) {
                Member member = orCreate.getMember(SysDimensionEnum.Entity.getNumber(), this.getOrgView(), aLong);
                if (member == null) continue;
                List parents = orCreate.getParents(this.getOrgView(), member, Boolean.FALSE.booleanValue());
                parentOrgSet.addAll(parents.stream().map(x -> x.getId()).collect(Collectors.toSet()));
            }
            if (CollectionUtils.isNotEmpty(parentOrgSet) && (set = ReportSchemeService.getInstance().queryRecordId(schemeId, templateIdset, parentOrgSet, this.getModelId(), this.getOrgView(), orgSelectSet)) != null && CollectionUtils.isNotEmpty((Collection)set)) {
                qFilterParent = new QFilter("scheme", "=", (Object)schemeId);
                qFilterParent.and("id", "in", (Object)set);
            }
            qFilter.and("org", "in", orgSelectSet);
        }
        return qFilterParent == null ? qFilter : qFilter.or(qFilterParent);
    }

    private void refreshAllocateEntry(boolean isNeedDelete) {
        log.info("refreshAllocateEntry start");
        long l = System.currentTimeMillis();
        Long id = (Long)this.getModel().getValue("id");
        if (id == null || id == 0L) {
            return;
        }
        if (isNeedDelete) {
            ReportSchemeService.getInstance().deleteRecord(id);
            return;
        }
        QFilter qFilter1 = this.getqFilter();
        BillList billList = (BillList)this.getView().getControl(BILLLISTAP);
        billList.setFilter(qFilter1);
        billList.setOrderBy("allocatetime desc,recordseq");
        billList.setClearSelection(true);
        billList.refresh();
    }

    private DynamicObjectCollection getHistoryReocrd(Long schemeId) {
        Set<Long> templateIdset = this.getSelectTemplate();
        Set<Long> orgSelectSet = this.getSelectOrg(Boolean.TRUE);
        DynamicObjectCollection dynamicObjectCollection = ReportSchemeService.getInstance().queryReocrdBySchemeIdTemplateIdAndOrgId(schemeId, templateIdset, orgSelectSet);
        return dynamicObjectCollection;
    }

    @NotNull
    private Set<Long> getSelectOrg(Boolean needProp) {
        TreeView orgTree = (TreeView)this.getControl(ORG_TREE);
        List orgSelect = orgTree.getTreeState().getSelectedNodes();
        orgSelect.removeIf(e -> "".equals(e.get("parentid")));
        if (CollectionUtils.isEmpty((Collection)orgTree.getTreeState().getCheckedNodeIds())) {
            orgSelect.clear();
        }
        TreeView propTree = (TreeView)this.getControl(PROP_TREE);
        List propSelect = propTree.getTreeState().getSelectedNodeId();
        propSelect.removeIf(x -> "root".equals(x));
        Set<Long> orgSelectSet = orgSelect.stream().map(x -> IDUtils.toLong(x.get("id"))).collect(Collectors.toSet());
        if (CollectionUtils.isNotEmpty((Collection)propSelect) && needProp.booleanValue()) {
            MemberPropCache memberPropCache = MemberPropCacheService.getOrCreate((Long)this.getModelId());
            IModelCacheHelper modelCacheHelper = ModelCacheContext.getOrCreate((Long)this.getModelId());
            Dimension dimension = modelCacheHelper.getDimension(SysDimensionEnum.Entity.getNumber());
            for (String relationId : propSelect) {
                List members = memberPropCache.getMembersByPropValues(dimension.getId(), this.getOrgView(), IDUtils.toLong((Object)relationId));
                if (CollectionUtils.isNotEmpty((Collection)members)) {
                    DynamicObject value = (DynamicObject)this.getModel().getValue(VIEWRANGE);
                    for (Member member : members) {
                        Member dimensionMember = dimension.getMember(Long.valueOf(value.getLong("id")), member.getNumber());
                        if (dimensionMember == null) continue;
                        if (CollectionUtils.isEmpty(orgSelectSet)) {
                            orgSelectSet = new HashSet<Long>(16);
                        }
                        orgSelectSet.add(dimensionMember.getId());
                    }
                    continue;
                }
                orgSelectSet.add(0L);
            }
        }
        return orgSelectSet;
    }

    @NotNull
    private Set<Long> getSelectTemplate() {
        TreeView tempTree = (TreeView)this.getControl(TEMPLATETREE);
        List tempSelect = tempTree.getTreeState().getSelectedNodes();
        tempSelect.removeIf(e -> (Boolean)e.get("isParent") != false || "".equals(e.get("parentid")));
        Set<Long> templateIdset = tempSelect.stream().map(x -> IDUtils.toLong(x.get("id"))).collect(Collectors.toSet());
        return templateIdset;
    }

    public void tabSelected(TabSelectEvent tabSelectEvent) {
        String tabKey = tabSelectEvent.getTabKey();
        Tab tab = (Tab)tabSelectEvent.getSource();
        if ("tabap".equals(tab.getKey())) {
            this.getView().setVisible(Boolean.valueOf("tabentity".equals(tabKey)), new String[]{ORGRANGETYPE});
            this.getView().setEnable(Boolean.valueOf("tabentity".equals(tabKey)), new String[]{BTN_CANCELDEL, BTN_ADDDEL});
        } else if ("tabrecord".equals(tab.getKey())) {
            if ("recordtab".equals(tabKey)) {
                this.getView().setVisible(Boolean.valueOf(false), new String[]{BTN_CANCELDEL});
                this.getView().setVisible(Boolean.valueOf(true), new String[]{BTN_ADDDEL});
            } else if ("deletetab".equals(tabKey)) {
                this.getView().setVisible(Boolean.valueOf(true), new String[]{BTN_CANCELDEL});
                this.getView().setVisible(Boolean.valueOf(false), new String[]{BTN_ADDDEL});
            }
            String cacheTab = this.getPageCache().get(SELECT_TAB_CACHE);
            this.getPageCache().put(SELECT_TAB_CACHE, tabKey);
            if (StringUtils.isEmpty((String)cacheTab) || !cacheTab.equals(tabKey)) {
                this.refreshAllocateEntry(false);
            }
        }
    }

    public void beforeClosed(BeforeClosedEvent e) {
        super.beforeClosed(e);
        e.setCheckDataChange(false);
        this.unlockScheme();
    }

    public String getBizCtrlRangeKey() {
        return BIZRANGE;
    }

    public void afterSetBgDefaultField() {
        super.afterSetBgDefaultField();
        this.getModel().setValue(APPLYSCOPE, (Object)SHOWWAY_TEMP);
        this.getView().setVisible(Boolean.valueOf(false), new String[]{APPLYSCOPE});
    }

    public boolean triggerPropChange() {
        return true;
    }

    public void createListDataProvider(BeforeCreateListDataProviderArgs beforeCreateListDataProviderArgs) {
        beforeCreateListDataProviderArgs.setListDataProvider((IListDataProvider)new ListDataProvider(){

            public DynamicObjectCollection getData(int start, int limit) {
                DynamicObjectCollection allRows = super.getData(start, limit);
                DynamicObjectCollection clone = (DynamicObjectCollection)allRows.clone();
                List recordId = allRows.stream().map(e -> e.getLong("id")).collect(Collectors.toList());
                QFilter qcfPerm = new QFilter("id", "in", recordId);
                DynamicObject[] delete = BusinessDataServiceHelper.load((String)"eb_templateorg", (String)"id,deleteentity,deleteentity.entity", (QFilter[])new QFilter[]{qcfPerm});
                HashSet<Long> needDeleteIdSet = new HashSet<Long>(16);
                for (DynamicObject allRow : clone) {
                    String templatetype = allRow.getString("templatetype");
                    if ("0".equals(templatetype)) {
                        allRow.set("tempidshow", (Object)allRow.getString("template_id"));
                        DynamicObject template = allRow.getDynamicObject("template");
                        if (template != null) {
                            allRow.set("templatename", (Object)template.getString("name"));
                            allRow.set("templatenumber", (Object)template.getString(ReportSchemeEditPlugin.NUMBER));
                        }
                    } else {
                        allRow.set("tempidshow", allRow.get("applytemplate_id"));
                        DynamicObject applytemplate = allRow.getDynamicObject("applytemplate");
                        if (applytemplate != null) {
                            allRow.set("templatename", (Object)applytemplate.getString("name"));
                            allRow.set("templatenumber", (Object)applytemplate.getString(ReportSchemeEditPlugin.NUMBER));
                        }
                    }
                    allRow.set("recordidshow", (Object)allRow.getString("id"));
                    Optional<DynamicObject> first = Arrays.stream(delete).filter(x -> allRow.getLong("id") == x.getLong("id")).findFirst();
                    if (first.isPresent()) {
                        DynamicObject dynamicObject = first.get();
                        DynamicObjectCollection deleteentity = dynamicObject.getDynamicObjectCollection("deleteentity");
                        if (!CollectionUtils.isNotEmpty((Collection)deleteentity)) continue;
                        ArrayList<String> name = new ArrayList<String>(deleteentity.size());
                        for (DynamicObject object : deleteentity) {
                            DynamicObject entity = object.getDynamicObject("entity");
                            if (entity != null) {
                                name.add(entity.getString("name"));
                                continue;
                            }
                            needDeleteIdSet.add(object.getLong("id"));
                        }
                        allRow.set("deleteentityshow", (Object)String.join((CharSequence)",", name));
                        continue;
                    }
                    allRow.set("deleteentityshow", null);
                }
                if (needDeleteIdSet.size() > 0) {
                    SqlBuilder sqlBuilder = new SqlBuilder();
                    sqlBuilder.append("delete from t_eb_temporgdelentity where ", new Object[0]);
                    sqlBuilder.appendIn("fentryid", needDeleteIdSet.toArray());
                    DB.execute((DBRoute)DBRoute.of((String)"epm"), (SqlBuilder)sqlBuilder);
                    CacheServiceHelper.clearEntityCache((String)"eb_templateorg");
                }
                return clone;
            }
        });
    }

    public void createListColumns(BeforeCreateListColumnsArgs args) {
        Optional<IListColumn> first;
        List listColumns = args.getListColumns();
        ArrayList<IListColumn> result = new ArrayList<IListColumn>(listColumns.size());
        List<String> showByTemp = Arrays.asList("temp_num", "temp_name", "template.number", "template.name", "applytemplate.number", "applytemplate.name", "temp_type", "org_num", "org_name", "org_range");
        List<String> showByOrg = Arrays.asList("org_num", "org_name", "org_range", "temp_num", "temp_name", "template.number", "template.name", "applytemplate.number", "applytemplate.name", "temp_type");
        String value = (String)this.getModel().getValue(SHOWWAY);
        BillList billList = (BillList)this.getControl(BILLLISTAP);
        List listFieldsControlColumns = billList.getListFieldsControlColumns();
        log.info("showway:{}", (Object)value);
        if (SHOWWAY_TEMP.equals(value)) {
            for (String s : showByTemp) {
                first = listColumns.stream().filter(x -> ((ListColumn)x).getKey().equals(s)).findFirst();
                if (!first.isPresent()) continue;
                result.add(first.get());
            }
            listColumns.removeAll(result);
            result.addAll(listColumns);
        } else {
            for (String s : showByOrg) {
                first = listColumns.stream().filter(x -> ((ListColumn)x).getKey().equals(s)).findFirst();
                if (!first.isPresent()) continue;
                result.add(first.get());
            }
            listColumns.removeAll(result);
            result.addAll(listColumns);
        }
        args.setListColumns(result);
        ArrayList<Map> temp = new ArrayList<Map>(listFieldsControlColumns.size());
        for (int i = 0; i < result.size(); ++i) {
            Map map;
            Optional<Map> listFieldKey;
            DynamicTextListColumn iListColumn;
            IListColumn iListColumn1 = (IListColumn)result.get(i);
            if (iListColumn1 instanceof DynamicTextListColumn) {
                iListColumn = (DynamicTextListColumn)result.get(i);
                listFieldKey = listFieldsControlColumns.stream().filter(x -> x.get("listFieldKey").equals(iListColumn.getKey())).findFirst();
                if (!listFieldKey.isPresent()) continue;
                map = listFieldKey.get();
                map.put("seq", i + 1);
                temp.add(map);
                continue;
            }
            if (iListColumn1 instanceof ListOperationColumn) {
                iListColumn = (ListOperationColumn)result.get(i);
                listFieldKey = listFieldsControlColumns.stream().filter(arg_0 -> ReportSchemeEditPlugin.lambda$createListColumns$40((ListOperationColumn)iListColumn, arg_0)).findFirst();
                if (!listFieldKey.isPresent()) continue;
                map = listFieldKey.get();
                map.put("seq", i + 1);
                temp.add(map);
                continue;
            }
            iListColumn = (ListColumn)result.get(i);
            listFieldKey = listFieldsControlColumns.stream().filter(arg_0 -> ReportSchemeEditPlugin.lambda$createListColumns$41((ListColumn)iListColumn, arg_0)).findFirst();
            if (!listFieldKey.isPresent()) continue;
            map = listFieldKey.get();
            map.put("seq", i + 1);
            temp.add(map);
        }
        listFieldsControlColumns.clear();
        billList.setListFieldsControlColumns(temp);
    }

    private void lockScheme() {
        Long id = (Long)this.getModel().getValue("id");
        if (IDUtils.isNotNull((Long)id)) {
            boolean lock = ReportSchemeEditHelper.lock(id, this.getModelId());
            if (!lock) {
                ReportSchemeEditHelper.checkIsLockInPage(id, this.getModelId(), this.getView());
            } else {
                this.getPageCache().put("isLock", "TRUE");
            }
        }
    }

    private void unlockScheme() {
        Long id = (Long)this.getModel().getValue("id");
        String isLock = this.getPageCache().get("isLock");
        if (IDUtils.isNotNull((Long)id) && StringUtils.isNotEmpty((String)isLock)) {
            ReportSchemeEditHelper.unlock(id, this.getModelId());
        }
    }

    protected void showOperationResultMulti(OperationResult operationResult, String operateName, String operationKey, String title) {
        int successCount;
        int validError;
        operateName = this.getRealMsg(operateName);
        title = this.getRealMsg(title);
        this.errorInfoConvertToFormName(operationResult);
        List errorOrValidateInfos = operationResult.getAllErrorOrValidateInfo();
        FormShowParameter parameters = new FormShowParameter();
        parameters.getOpenStyle().setShowType(ShowType.Modal);
        parameters.setFormId("eb_confirm");
        parameters.setShowTitle(false);
        parameters.setCustomParam("operateName", (Object)operateName);
        HashMap<Object, Object> pkNumbers = new HashMap();
        if (operationResult.getSuccessPkIds() != null && !operationResult.getSuccessPkIds().isEmpty()) {
            if (!operationResult.getBillNos().isEmpty()) {
                pkNumbers.putAll(operationResult.getBillNos());
            } else {
                pkNumbers = this.getNumberById(operationResult.getSuccessPkIds());
            }
        }
        parameters.setCustomParam("pkNumbers", pkNumbers);
        IPageCache pageCache = this.getPageCache();
        DataEntitySerializerOption option = new DataEntitySerializerOption();
        option.setIncludeComplexProperty(true);
        String serialResult = DataEntitySerializer.serializerToString((Object)operationResult, (DataEntitySerializerOption)option);
        pageCache.put("operationresult", serialResult);
        ArrayList<String> list = new ArrayList<String>();
        int billCount = errorOrValidateInfos.size();
        for (int i = 0; i < 5 && i < billCount; ++i) {
            IOperateInfo errorInfo = (IOperateInfo)errorOrValidateInfos.get(i);
            list.add(errorInfo.getMessage());
        }
        parameters.setCustomParam("hasMore", (Object)(errorOrValidateInfos.size() > 5 ? 1 : 0));
        parameters.setCustomParam("errorMsg", list);
        String message = operationResult.getMessage();
        if (StringUtils.isNotEmpty((String)message) && operationResult.getMessageType() == 1) {
            parameters.setCustomParam("message", (Object)operationResult.getMessage());
        }
        String msg = (validError = (billCount = operationResult.getBillCount()) - (successCount = operationResult.getSuccessPkIds().size())) > 0 ? String.format(ResManager.loadKDString((String)"\u672c\u6b21\u64cd\u4f5c\u5171%1$s\u6761\u5355\u636e\uff0c\u9884\u8ba1\u6210\u529f%2$s\u6761\uff0c\u5931\u8d25%3$s\u6761\u3002", (String)"BGMD-N-355682", (String)"prompt-bgm", (Object[])new Object[0]), billCount, successCount, validError) : String.format(ResManager.loadKDString((String)"\u672c\u6b21\u64cd\u4f5c\u5171%1$s\u6761\u5355\u636e\uff0c\u9884\u8ba1\u6210\u529f%2$s\u6761\u3002", (String)"BGMD-N-568717", (String)"prompt-bgm", (Object[])new Object[0]), billCount, successCount);
        parameters.setCloseCallBack(new CloseCallBack((IFormPlugin)this, operationKey));
        parameters.setCustomParam("message", (Object)msg);
        parameters.setCustomParam("title", (Object)title);
        this.getView().showForm(parameters);
    }

    @Nullable
    private String getRealMsg(String title) {
        if (StringUtils.isNotEmpty((String)title) && title.contains("msgcode")) {
            Map o = (Map)SerializationUtils.fromJsonString((String)title, Map.class);
            title = o.getOrDefault("msg", title);
        }
        return title;
    }

    protected HashMap<Object, Object> getNumberById(List<Object> pkIds) {
        HashMap<Object, Object> map = new HashMap<Object, Object>();
        for (Object key : pkIds) {
            map.put(key, key);
        }
        return map;
    }

    /*
     * Unable to fully structure code
     */
    private void errorInfoConvertToFormName(OperationResult result) {
        if (result != null && result.getValidateResult() != null && result.getValidateResult().getValidateErrors() != null) {
            var2 = result.getValidateResult().getValidateErrors().iterator();
            block0: while (true) {
                if (!var2.hasNext()) {
                    result.setMessage(this.convertToFormName(result.getMessage()));
                    return;
                }
                res = (ValidateResult)var2.next();
                errorInfos = res.getAllErrorInfo();
                if (!kd.bos.util.CollectionUtils.isNotEmpty((Collection)errorInfos)) continue;
                var5 = errorInfos.iterator();
                while (true) {
                    if (var5.hasNext()) ** break;
                    continue block0;
                    info = (OperateErrorInfo)var5.next();
                    info.setMessage(this.convertToFormName(info.getMessage()));
                }
                break;
            }
        }
    }

    private String convertToFormName(String msg) {
        return msg;
    }

    private static /* synthetic */ boolean lambda$createListColumns$41(ListColumn iListColumn, Map x) {
        return x.get("listFieldKey").equals(iListColumn.getKey());
    }

    private static /* synthetic */ boolean lambda$createListColumns$40(ListOperationColumn iListColumn, Map x) {
        return x.get("listFieldKey").equals(iListColumn.getKey());
    }
}

