/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.formplugin.reportscheme;

import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.base.BaseShowParameter;
import kd.bos.bill.OperationStatus;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.ILocaleString;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.resource.promptenum.MultiLangEnumBridge;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.ArrayUtils;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.filter.ControlFilters;
import kd.bos.entity.filter.FilterParameter;
import kd.bos.exception.KDBizException;
import kd.bos.filter.CommonFilterColumn;
import kd.bos.filter.FilterColumn;
import kd.bos.filter.FilterContainer;
import kd.bos.filter.SchemeBaseDataFilterColumn;
import kd.bos.form.CloseCallBack;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.ShowType;
import kd.bos.form.control.Control;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.control.events.FilterContainerInitEvent;
import kd.bos.form.control.events.FilterContainerInitListener;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.form.control.events.RowClickEvent;
import kd.bos.form.control.events.RowClickEventListener;
import kd.bos.form.control.events.SearchClickEvent;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.HyperLinkClickEvent;
import kd.bos.form.events.HyperLinkClickListener;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.ComboItem;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.form.field.events.BeforeFilterF7SelectEvent;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.ListFilterParameter;
import kd.bos.list.ListShowParameter;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.DispatchServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.TimeServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.epm.eb.business.reportscheme.entity.TebScheme;
import kd.epm.eb.business.reportscheme.entity.TebTemplateAssignOrg;
import kd.epm.eb.business.reportscheme.service.ReportSchemeAssignService;
import kd.epm.eb.business.reportscheme.service.ReportSchemeService;
import kd.epm.eb.business.reportscheme.service.ReportSchemeTemplateSortService;
import kd.epm.eb.business.userremember.service.UserRememberService;
import kd.epm.eb.common.enums.ApplicationTypeEnum;
import kd.epm.eb.common.enums.RptSchemeStatusEnum;
import kd.epm.eb.common.enums.SysDimensionEnum;
import kd.epm.eb.common.enums.memberQuote.MemberQuoteResourceEnum;
import kd.epm.eb.common.reportprocess.entity.dto.TemplateEntityDto;
import kd.epm.eb.common.reportprocess.entity.request.BaseRptProcessRequest;
import kd.epm.eb.common.reportprocess.helper.SchemeRecordDeleteEntityHelper;
import kd.epm.eb.common.reportprocess.service.impl.ReportProcessAggService;
import kd.epm.eb.common.utils.BusinessModelServiceHelper;
import kd.epm.eb.common.utils.GlobalIdUtil;
import kd.epm.eb.common.utils.IDUtils;
import kd.epm.eb.common.utils.NewEbAppUtil;
import kd.epm.eb.common.utils.ObjectSerialUtil;
import kd.epm.eb.formplugin.AbstractListPlugin;
import kd.epm.eb.formplugin.reportscheme.helper.ReportSchemeEditHelper;
import kd.epm.eb.model.utils.ModelUtil;
import kd.epm.eb.model.utils.UserSelectUtil;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.tuple.MutableTriple;
import org.apache.commons.lang3.tuple.Triple;

public class ReportSchemeListPlugin
extends AbstractListPlugin
implements BeforeF7SelectListener,
FilterContainerInitListener,
RowClickEventListener {
    private static final String TOOLBAR = "toolbar";
    private static final String ADD = "btn_add";
    private static final String ASSIGN = "btn_assign";
    private static final String ENABLE = "btn_enable";
    private static final String UNABLE = "btn_unable";
    private static final String CLOSE = "btn_close";
    private static final String COPY = "btn_copy";
    private static final String DELETE = "btn_delete";
    private static final String REFRESH = "btn_refresh";
    private static final String ENTRYENTITY_LEFT = "entryentity";
    private static final String ENTRYENTITY_RIGHT = "entryentity1";
    private static final String RPT_SCHEME_LEFT = "rptscheme1";
    private static final String RPT_SCHEME_RIGHT = "rptscheme2";
    private static final String SCHEME_ASSIGN_VARIABLE = "variable";
    private static final String BIZRANGE_LEFT = "bizrange1";
    private static final String ORGVIEW_LEFT = "orgview";
    private static final String BIZRANGE_RIGHT = "bizrange2";
    private static final String RECORD_RIGHT = "assignrecord";
    private static final String STATUS = "status";
    private static final String DATATYPE = "datatype";
    private static final String YEAE = "year";
    private static final String VERSION = "version";
    private static final String ASSIGN_TIME = "assigntime";
    private static final String MODEL = "model";
    private static final String CANCEL_ASSIGN = "btn_cancel";
    private static final String BTN_REASSIGN = "btn_reassign";
    private static final String ADD_CLOSECALLBACK = "addcloseback";
    private static final String ASSIGN_CLOSECALLBACK = "assigncloseback";
    public static final String BTN_MULTIDIMRELATION = "btn_multidimrelation";
    private static final String APPLYSCOPE_LEFT = "applyscope1";
    private static final String APPLYSCOPE_RIGHT = "applyscope2";
    public static final String BTN_APPROVE_TYPE = "btn_approvetype";
    public static final String MODEL_COMBOITEMS = "MODEL_COMBOITEMS";
    public static final String MODEL_NAME = "model.name";
    public static final String MODEL_ID = "model.id";
    public static final String BUSMODEL_NAME = "bizrange.name";
    public static final String BUSMODEL_ID = "bizrange.id";
    public static final String ASSIGNTIME = "assigntime";
    public static final String SCHEME_STATUS = "scheme.status";
    private static final List<String> modelFilterList = Collections.singletonList("bizrange.id");
    private static final int MAX_NUMBER_COUNT = 50;
    private final ReportProcessAggService reportProcessAggService = ReportProcessAggService.getInstance();
    private static final Log log = LogFactory.getLog(ReportSchemeListPlugin.class);
    private List<ComboItem> model_comboItems = null;
    private Long modelIdFromQFilters = null;

    public void initialize() {
        super.initialize();
        FilterContainer fc = (FilterContainer)this.getControl("filtercontainerap");
        if (fc != null) {
            fc.getContext();
            fc.setBillFormId("eb_schemeassign");
            fc.addFilterContainerInitListener((FilterContainerInitListener)this);
            fc.addSearchClickListener(this::filterContainerSearchClick);
            fc.addBeforeF7SelectListener(this::filterContainerBeforeF7Select);
        }
    }

    public void afterCreateNewData(EventObject e) {
        Long modelId = UserSelectUtil.getModelIdAfterCreateNewData((IFormView)this.getView(), (String)MODEL, (boolean)false);
        if (IDUtils.isNotNull((Long)modelId)) {
            this.getModel().setValue(MODEL, (Object)modelId);
            this.modelChanged(modelId);
        } else {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u4f53\u7cfb\u3002", (String)"ReportSchemeListPlugin_0", (String)"epm-eb-formplugin", (Object[])new Object[0]));
        }
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        this.defaultSelectSchemeRow(Sets.newHashSet((Object[])new Integer[]{0}));
    }

    private void defaultSelectSchemeRow(Set<Integer> selectRows) {
        int rowCount = this.getModel().getEntryRowCount(ENTRYENTITY_LEFT);
        EntryGrid entryGrid = (EntryGrid)this.getControl(ENTRYENTITY_LEFT);
        if (CollectionUtils.isNotEmpty(selectRows)) {
            selectRows.removeIf(e -> e == null || e < 0 || e >= rowCount);
            if (!selectRows.isEmpty()) {
                int[] rows = ArrayUtils.toPrimitive((Integer[])selectRows.toArray(new Integer[0]));
                entryGrid.selectRows(rows, rows[0]);
                return;
            }
        }
        if (rowCount > 0) {
            entryGrid.selectRows(0);
        }
    }

    @Override
    public void registerListener(EventObject e) {
        super.registerListener(e);
        BasedataEdit model = (BasedataEdit)this.getControl(MODEL);
        model.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        this.addItemClickListeners(new String[]{TOOLBAR});
        this.addClickListeners(new String[]{CANCEL_ASSIGN, BTN_REASSIGN});
        EntryGrid entryGrid = (EntryGrid)this.getControl(ENTRYENTITY_LEFT);
        entryGrid.addHyperClickListener((HyperLinkClickListener)this);
        entryGrid.addRowClickListener((RowClickEventListener)this);
        EntryGrid entryGrid1 = (EntryGrid)this.getControl(ENTRYENTITY_RIGHT);
        entryGrid1.addHyperClickListener((HyperLinkClickListener)this);
    }

    public void itemClick(ItemClickEvent evt) {
        String key;
        super.itemClick(evt);
        switch (key = evt.getItemKey()) {
            case "btn_add": {
                this.openSchemeEditPage(null);
                break;
            }
            case "btn_assign": {
                this.assign();
                break;
            }
            case "btn_enable": 
            case "btn_unable": 
            case "btn_close": {
                this.enableAndUnable(key);
                break;
            }
            case "btn_copy": {
                this.copyScheme();
                break;
            }
            case "btn_delete": {
                List<Long> list = this.getSelectScheme();
                if (list == null) {
                    return;
                }
                if (this.beforeDelteScheme(list)) {
                    this.getView().showConfirm(ResManager.loadKDString((String)"\u8bf7\u786e\u8ba4\u662f\u5426\u5220\u9664\u6570\u636e?", (String)"ReportSchemeListPlugin_1", (String)"epm-eb-formplugin", (Object[])new Object[0]), MessageBoxOptions.YesNo, new ConfirmCallBackListener("confirmDel", (IFormPlugin)this));
                    break;
                }
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u6240\u9009\u65b9\u6848\u5b58\u5728\u5df2\u7ecf\u4e0b\u8fbe\u7684\u65b9\u6848\u3002", (String)"ReportSchemeListPlugin_2", (String)"epm-eb-formplugin", (Object[])new Object[0]));
                break;
            }
            case "btn_refresh": {
                if (IDUtils.isNull((Long)this.getModelId())) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u4f53\u7cfb\u3002", (String)"ReportSchemeListPlugin_0", (String)"epm-eb-formplugin", (Object[])new Object[0]));
                    return;
                }
                this.refreshLeftEntry();
                this.refreshRightEntry();
                break;
            }
            case "btn_multidimrelation": {
                this.openDimensionRelPage();
                break;
            }
            case "btn_approvetype": {
                this.openApproveTypeListPage();
            }
        }
    }

    private void copyScheme() {
        List<Long> ids = this.getSelectScheme();
        if (ids == null) {
            return;
        }
        DynamicObject[] objects = ReportSchemeService.getInstance().loadSchemes(ids.toArray(new Long[ids.size()]));
        boolean hasFail = false;
        for (DynamicObject object : objects) {
            boolean success = this.copy(object);
            if (success) continue;
            hasFail = true;
        }
        this.refreshLeftEntry();
        if (hasFail) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u5df2\u8df3\u8fc7\u540d\u79f0\u8fbe\u5230\u6700\u5927\u957f\u5ea6\u7684\u65b9\u6848\u3002", (String)"ReportSchemeListPlugin_13", (String)"epm-eb-formplugin", (Object[])new Object[0]));
        } else {
            MultiLangEnumBridge opName = new MultiLangEnumBridge("\u65b9\u6848\u590d\u5236", "ReportSchemeAssignPlugin_32", "epm-eb-formplugin");
            MultiLangEnumBridge opMsg = new MultiLangEnumBridge("\u590d\u5236\u6210\u529f\u3002", "ReportSchemeListPlugin_12", "epm-eb-formplugin");
            this.getView().showSuccessNotification(opMsg.loadKDString());
            this.writeLog(null, "copy", opName, opMsg, null);
        }
    }

    private boolean copy(DynamicObject obj) {
        ILocaleString scheme_name;
        ILocaleString nameCopy = scheme_name = obj.getLocaleString("name");
        for (Map.Entry entry : nameCopy.entrySet()) {
            if (entry.getValue() != null && ((String)entry.getValue()).length() > 46) {
                nameCopy.setItem((String)entry.getKey(), (Object)(((String)entry.getValue()).substring(0, 46) + "copy"));
                continue;
            }
            nameCopy.setItem((String)entry.getKey(), (Object)((String)entry.getValue() + "copy"));
        }
        TebScheme scheme = this.createScheme(obj, nameCopy);
        ReportSchemeService.getInstance().saveScheme(scheme, true);
        ReportSchemeTemplateSortService.getInstance().copyTemplateSort(Long.valueOf(obj.getLong("id")), scheme.getId());
        return true;
    }

    private TebScheme createScheme(DynamicObject obj, ILocaleString name) {
        long oldId = obj.getLong("id");
        RequestContext context = RequestContext.get();
        Long modelId = this.getModelId();
        Date now = TimeServiceHelper.now();
        TebScheme scheme = new TebScheme();
        long id = GlobalIdUtil.genGlobalLongId();
        scheme.setId(Long.valueOf(id));
        scheme.setNumber("RptScheme-" + System.currentTimeMillis());
        scheme.setName(name);
        scheme.setBizRangeId(Long.valueOf(obj.getLong(BUSMODEL_ID)));
        scheme.setOrgViewId(Long.valueOf(obj.getLong("orgview.id")));
        scheme.setStatus(obj.getString(STATUS));
        scheme.setApplyscope(obj.getString("applyscope"));
        scheme.setDescription(obj.getString("description"));
        scheme.setCreatorId(Long.valueOf(Long.parseLong(context.getUserId())));
        scheme.setCreateTime(now);
        scheme.setModifierId(Long.valueOf(Long.parseLong(context.getUserId())));
        scheme.setModifyTime(now);
        int seq = this.getMaxSeq(modelId) + 1;
        scheme.setSeq(seq);
        scheme.setModelId(modelId);
        DynamicObjectCollection oldRecords = this.getRecord(oldId);
        scheme.setAllocateRecords(this.getTempAssignOrgRecord(oldRecords, id));
        return scheme;
    }

    private DynamicObjectCollection getRecord(Long oldId) {
        DynamicObjectCollection dynamicObjects = ReportSchemeService.getInstance().queryRecordBySchemeId2(oldId);
        return dynamicObjects;
    }

    private List<TebTemplateAssignOrg> getTempAssignOrgRecord(DynamicObjectCollection entryData, Long schemeId) {
        ArrayList<TebTemplateAssignOrg> list = new ArrayList<TebTemplateAssignOrg>(entryData.size());
        Long userId = Long.parseLong(RequestContext.get().getUserId());
        Date time = TimeServiceHelper.now();
        int seq = 1;
        List recordIdList = entryData.stream().map(x -> x.getLong("id")).collect(Collectors.toList());
        Map recordDeleteEntity = SchemeRecordDeleteEntityHelper.queryDeleteEntityByRecordId(recordIdList);
        for (DynamicObject dynamicObject : entryData) {
            Long id = GlobalIdUtil.genGlobalLongId();
            Long orgId = dynamicObject.getLong("org");
            String orgRange = dynamicObject.getString("orgrange");
            String templatetype = dynamicObject.getString("templatetype");
            Long templateId = 0L;
            if (kd.bos.dataentity.utils.StringUtils.isEmpty((CharSequence)templatetype)) {
                templatetype = "0";
            }
            TebTemplateAssignOrg templateAssignOrg = null;
            Set set = (Set)recordDeleteEntity.get(dynamicObject.getLong("id"));
            if ("0".equals(templatetype)) {
                templateId = dynamicObject.getLong("template");
                templateAssignOrg = new TebTemplateAssignOrg(id, templateId, orgId, orgRange, userId, time, schemeId, seq, templatetype);
                if (CollectionUtils.isNotEmpty((Collection)set)) {
                    templateAssignOrg.setDeleteEntity(new ArrayList(set));
                }
            } else if ("1".equals(templatetype)) {
                templateId = dynamicObject.getLong("applytemplate.id");
                templateAssignOrg = new TebTemplateAssignOrg(id, orgId, orgRange, userId, time, schemeId, seq, templateId, templatetype);
                if (CollectionUtils.isNotEmpty((Collection)set)) {
                    templateAssignOrg.setDeleteEntity(new ArrayList(set));
                }
            }
            list.add(templateAssignOrg);
            ++seq;
        }
        return list;
    }

    private int getMaxSeq(Long modelId) {
        int maxSeq = ReportSchemeService.getInstance().getMaxSeq(modelId);
        return maxSeq;
    }

    private void enableAndUnable(String key) {
        List<Long> ids = this.getSelectScheme();
        if (ids == null) {
            return;
        }
        String status = RptSchemeStatusEnum.ENABLE.getNumber();
        String opName = RptSchemeStatusEnum.ENABLE.getName();
        MultiLangEnumBridge msg = new MultiLangEnumBridge("\u542f\u7528\u6210\u529f\u3002", "ReportSchemeListPlugin_3", "epm-eb-formplugin");
        if (UNABLE.equals(key)) {
            status = RptSchemeStatusEnum.DISABLE.getNumber();
            opName = RptSchemeStatusEnum.DISABLE.getName();
            msg = new MultiLangEnumBridge("\u7981\u7528\u6210\u529f\u3002", "ReportSchemeListPlugin_4", "epm-eb-formplugin");
        } else if (CLOSE.equals(key)) {
            status = RptSchemeStatusEnum.CLOSE.getNumber();
            opName = RptSchemeStatusEnum.CLOSE.getName();
            msg = new MultiLangEnumBridge("\u5173\u95ed\u6210\u529f\u3002", "ReportSchemeListPlugin_24", "epm-eb-formplugin");
        }
        ReportSchemeService.getInstance().updateStatus(status, ids);
        this.refreshLeftEntry();
        this.writeLog(null, null, msg, null, null);
        this.getView().showSuccessNotification(msg.loadKDString());
    }

    public void confirmCallBack(MessageBoxClosedEvent evt) {
        super.confirmCallBack(evt);
        String key = evt.getCallBackId();
        if ("confirmDel".equals(key) && MessageBoxResult.Yes.equals((Object)evt.getResult())) {
            List<Long> ids = this.getSelectScheme();
            if (ids == null) {
                return;
            }
            for (Long id : ids) {
                ReportSchemeEditHelper.checkIsLock(id, this.getModelId());
            }
            this.deleteScheme();
            this.refreshLeftEntry();
        }
    }

    private List<Long> getSelectScheme() {
        EntryGrid entryGrid = (EntryGrid)this.getControl(ENTRYENTITY_LEFT);
        int[] rows = entryGrid.getSelectRows();
        if (rows == null || rows.length == 0) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u81f3\u5c11\u9009\u62e9\u4e00\u4e2a\u65b9\u6848\u3002", (String)"ReportSchemeListPlugin_5", (String)"epm-eb-formplugin", (Object[])new Object[0]));
            return null;
        }
        ArrayList<Long> ids = new ArrayList<Long>(rows.length);
        for (int row : rows) {
            DynamicObject scheme = (DynamicObject)this.getModel().getValue(RPT_SCHEME_LEFT, row);
            if (scheme == null) continue;
            ids.add(scheme.getLong("id"));
        }
        return ids;
    }

    private boolean beforeDelteScheme(List<Long> ids) {
        DynamicObjectCollection dynamicObjects = ReportSchemeAssignService.getInstance().queryRecordByScheme(ids);
        return dynamicObjects == null || dynamicObjects.size() <= 0;
    }

    private void deleteScheme() {
        List<Long> ids = this.getSelectScheme();
        if (ids == null) {
            return;
        }
        ReportSchemeService.getInstance().deleteSchemes(ids);
        this.deleteDimQuote(new HashSet<Long>(ids));
        ReportSchemeTemplateSortService.getInstance().deleteTemplateSortByRelation(new HashSet<Long>(ids));
        MultiLangEnumBridge opName = new MultiLangEnumBridge("\u65b9\u6848\u5220\u9664", "ReportSchemeAssignPlugin_33", "epm-eb-formplugin");
        MultiLangEnumBridge opMsg = new MultiLangEnumBridge("\u5220\u9664\u6210\u529f\u3002", "ReportSchemeListPlugin_6", "epm-eb-formplugin");
        this.getView().showSuccessNotification(opMsg.loadKDString());
        this.writeLog(null, "delete", opName, opMsg, null);
    }

    public void deleteDimQuote(Set<Long> billIds) {
        if (billIds == null || billIds.size() == 0) {
            return;
        }
        DispatchServiceHelper.invokeBizService((String)"epm", (String)"eb", (String)"MemberQuoteService", (String)"delete", (Object[])new Object[]{MemberQuoteResourceEnum.Scheme.getType(), billIds});
    }

    private void assign() {
        EntryGrid entryGrid = (EntryGrid)this.getControl(ENTRYENTITY_LEFT);
        int[] rows = entryGrid.getSelectRows();
        if (rows == null || rows.length == 0 || rows.length > 1) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u52fe\u9009\u4e00\u4e2a\u65b9\u6848\u8fdb\u884c\u4e0b\u8fbe\u3002", (String)"ReportSchemeListPlugin_20", (String)"epm-eb-formplugin", (Object[])new Object[0]));
            return;
        }
        ArrayList<String> ids = new ArrayList<String>(rows.length);
        ArrayList<String> bizRangeIds = new ArrayList<String>(rows.length);
        ArrayList<String> applyScopes = new ArrayList<String>(rows.length);
        StringBuilder sb = new StringBuilder();
        for (int row : rows) {
            DynamicObject scheme = (DynamicObject)this.getModel().getValue(RPT_SCHEME_LEFT, row);
            DynamicObject bizRange = (DynamicObject)this.getModel().getValue(BIZRANGE_LEFT, row);
            String applyScope = (String)this.getModel().getValue(APPLYSCOPE_LEFT, row);
            String status = (String)this.getModel().getValue(STATUS, row);
            if (RptSchemeStatusEnum.DISABLE.getNumber().equals(status) || RptSchemeStatusEnum.CLOSE.getNumber().equals(status)) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u6240\u9009\u65b9\u6848\u5305\u542b\u6709\u5df2\u7981\u7528\u6216\u5173\u95ed\u7684\u65b9\u6848\uff0c\u8bf7\u91cd\u65b0\u9009\u62e9\u3002", (String)"ReportSchemeListPlugin_7", (String)"epm-eb-formplugin", (Object[])new Object[0]));
                return;
            }
            boolean isEmptyScheme = QueryServiceHelper.exists((String)"eb_templateorg", (QFilter[])new QFilter[]{new QFilter("scheme", "=", (Object)scheme.getLong("id"))});
            if (!isEmptyScheme) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u6240\u9009\u65b9\u6848\u5df2\u5206\u914d\u7684\u6a21\u677f\u4e0d\u5b58\u5728\u6216\u4e0d\u5b58\u5728\u5df2\u5206\u914d\u8bb0\u5f55\uff0c\u8bf7\u5c06\u6a21\u677f\u5206\u914d\u7ec4\u7ec7\u540e\u518d\u8fdb\u884c\u4e0b\u8fbe\u3002", (String)"ReportSchemeListPlugin_21", (String)"epm-eb-formplugin", (Object[])new Object[0]));
                return;
            }
            if (scheme == null || bizRange == null || applyScope == null) continue;
            ids.add(scheme.getString("id"));
            applyScopes.add(applyScope);
            String bizRangeId = bizRange.getString("id");
            sb.append(scheme.getString("name")).append(",");
            if (bizRangeIds.size() > 0 && !bizRangeIds.contains(bizRangeId)) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u4e00\u4e2a\u4e1a\u52a1\u6a21\u578b\u4e0b\u7684\u591a\u4e2a\u65b9\u6848\u624d\u80fd\u540c\u65f6\u6279\u91cf\u4e0b\u8fbe\u3002", (String)"ReportSchemeListPlugin_19", (String)"epm-eb-formplugin", (Object[])new Object[0]));
                return;
            }
            bizRangeIds.add(bizRangeId);
        }
        if (sb.length() > 0) {
            sb.deleteCharAt(sb.length() - 1);
        }
        if (!this.isExistSameTemplate(IDUtils.toLongs(ids)).booleanValue()) {
            this.openAssignPage(ids, bizRangeIds, applyScopes, sb.toString());
        }
    }

    private void openAssignPage(List<String> schemeIds, List<String> bizRangeIds, List<String> applyScopes, String showText) {
        FormShowParameter showParameter = new FormShowParameter();
        showParameter.setFormId("eb_assignscheme_new");
        showParameter.getOpenStyle().setShowType(ShowType.Modal);
        showParameter.setCustomParam("bizRanges", (Object)SerializationUtils.toJsonString(bizRangeIds));
        showParameter.setCustomParam("bizModelId", (Object)bizRangeIds.get(0));
        showParameter.setCustomParam("schemeIds", (Object)SerializationUtils.toJsonString(schemeIds));
        showParameter.setCustomParam(MODEL, (Object)String.valueOf(this.getModelId()));
        showParameter.setCustomParam("showText", (Object)showText);
        showParameter.setCustomParam("applyScopes", (Object)SerializationUtils.toJsonString(applyScopes));
        CloseCallBack closeCallBack = new CloseCallBack((IFormPlugin)this, ASSIGN_CLOSECALLBACK);
        showParameter.setCloseCallBack(closeCallBack);
        this.getView().showForm(showParameter);
    }

    @Override
    public void hyperLinkClick(HyperLinkClickEvent hyperLinkClickEvent) {
        super.hyperLinkClick(hyperLinkClickEvent);
        String key = hyperLinkClickEvent.getFieldName();
        if (RPT_SCHEME_LEFT.equals(key)) {
            int rowIndex = hyperLinkClickEvent.getRowIndex();
            DynamicObject value = (DynamicObject)this.getModel().getValue(RPT_SCHEME_LEFT, rowIndex);
            if (value != null) {
                this.openSchemeEditPage(value.getString("id"));
            }
        } else if (SCHEME_ASSIGN_VARIABLE.equals(key)) {
            FormShowParameter showParameter = new FormShowParameter();
            showParameter.setFormId("eb_assignscheme_new");
            showParameter.getOpenStyle().setShowType(ShowType.Modal);
            int rowIndex = hyperLinkClickEvent.getRowIndex();
            DynamicObject object = this.getModel().getEntryRowEntity(ENTRYENTITY_RIGHT, rowIndex);
            if (object == null) {
                return;
            }
            long id = object.getDynamicObject(RECORD_RIGHT).getLong("id");
            showParameter.setCustomParam(MODEL, (Object)(this.getModelId() + ""));
            showParameter.setCustomParam("id", (Object)id);
            showParameter.setStatus(OperationStatus.VIEW);
            CloseCallBack closeCallBack = new CloseCallBack((IFormPlugin)this, ASSIGN_CLOSECALLBACK);
            showParameter.setCloseCallBack(closeCallBack);
            this.getView().showForm(showParameter);
        }
    }

    private void openSchemeEditPage(String id) {
        Long modelId = this.getModelId();
        if (IDUtils.isNull((Long)modelId)) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u4f53\u7cfb\u3002", (String)"ReportSchemeListPlugin_0", (String)"epm-eb-formplugin", (Object[])new Object[0]));
            return;
        }
        BaseShowParameter showParameter = new BaseShowParameter();
        showParameter.setPageId("eb_rptscheme_" + this.getView().getPageId() + "_" + id);
        showParameter.setFormId("eb_rptscheme");
        showParameter.setCustomParam(MODEL, (Object)(modelId + ""));
        CloseCallBack closeCallBack = new CloseCallBack((IFormPlugin)this, ADD_CLOSECALLBACK);
        showParameter.setCloseCallBack(closeCallBack);
        showParameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
        showParameter.setShowTitle(true);
        if (kd.bos.dataentity.utils.StringUtils.isNotEmpty((CharSequence)id)) {
            showParameter.setPkId((Object)id);
            showParameter.setStatus(OperationStatus.EDIT);
            showParameter.setCustomParam("id", (Object)id);
            showParameter.setCaption(ResManager.loadKDString((String)"\u65b9\u6848\u4fee\u6539", (String)"ReportSchemeListPlugin_9", (String)"epm-eb-formplugin", (Object[])new Object[0]));
        } else {
            showParameter.setStatus(OperationStatus.ADDNEW);
            showParameter.setCaption(ResManager.loadKDString((String)"\u65b9\u6848\u65b0\u589e", (String)"ReportSchemeListPlugin_10", (String)"epm-eb-formplugin", (Object[])new Object[0]));
        }
        this.getView().showForm((FormShowParameter)showParameter);
    }

    @Override
    public void closedCallBack(ClosedCallBackEvent closedCallBackEvent) {
        super.closedCallBack(closedCallBackEvent);
        String key = closedCallBackEvent.getActionId();
        if (ADD_CLOSECALLBACK.equals(key)) {
            this.refreshLeftEntry();
            MultiLangEnumBridge opName = new MultiLangEnumBridge("\u65b9\u6848\u65b0\u589e", "ReportSchemeListPlugin_10", "epm-eb-formplugin");
            this.writeLog(null, "addnew", opName, null, null);
        } else if (ASSIGN_CLOSECALLBACK.equals(key)) {
            if (closedCallBackEvent.getReturnData() != null) {
                EntryGrid entryGrid = (EntryGrid)this.getControl(ENTRYENTITY_LEFT);
                int[] rows = entryGrid.getSelectRows();
                ArrayList<String> schemeName = new ArrayList<String>(rows.length);
                for (int row : rows) {
                    DynamicObject scheme = (DynamicObject)this.getModel().getValue(RPT_SCHEME_LEFT, row);
                    schemeName.add(scheme.getString("name"));
                }
                this.getView().showSuccessNotification((String)closedCallBackEvent.getReturnData());
                MultiLangEnumBridge opName = new MultiLangEnumBridge("\u65b9\u6848\u4e0b\u8fbe", "ReportSchemeListPlugin_22", "epm-eb-formplugin");
                MultiLangEnumBridge opDesc = new MultiLangEnumBridge("\u65b9\u6848\u540d\u79f0\uff1a%1$s\u3002", "ReportSchemeListPlugin_23", "epm-eb-formplugin");
                this.writeLog(null, "assign", opName, opDesc, new String[]{String.join((CharSequence)",", schemeName)});
            }
            this.refreshRightEntry();
        }
    }

    public void click(EventObject evt) {
        super.click(evt);
        Control control = (Control)evt.getSource();
        String key = control.getKey();
        if (CANCEL_ASSIGN.equals(key)) {
            this.cancelAssgin();
            this.refreshRightEntry();
        }
        if (BTN_REASSIGN.equals(key)) {
            this.reAssign();
            this.refreshRightEntry();
            UserRememberService.getInstance().deleteUserRemember(null, ApplicationTypeEnum.BGM.getIndex() + '`' + "bgm_rptpreparation" + "`" + this.getModelId());
        }
    }

    private void reAssign() {
        EntryGrid entryGrid = (EntryGrid)this.getControl(ENTRYENTITY_RIGHT);
        int[] rows = entryGrid.getSelectRows();
        if (rows == null || rows.length == 0) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u81f3\u5c11\u9009\u62e9\u4e00\u4e2a\u4e0b\u8fbe\u8bb0\u5f55\u3002", (String)"ReportSchemeListPlugin_11", (String)"epm-eb-formplugin", (Object[])new Object[0]));
            return;
        }
        HashSet<Long> schemeAssignIdSet = new HashSet<Long>(16);
        HashMap<Long, Set<Long>> schemeAssignMap = new HashMap<Long, Set<Long>>(16);
        Long modelId = this.getModelId();
        HashMap<Long, DynamicObject> templateMap = new HashMap<Long, DynamicObject>(16);
        ArrayList<String> yearValidMsg = new ArrayList<String>(16);
        ArrayList<String> errorMsg = new ArrayList<String>(16);
        HashMap<Long, DynamicObject> schemeAssignObjMap = new HashMap<Long, DynamicObject>(16);
        for (int row : rows) {
            DynamicObject entryRowEntity = this.getModel().getEntryRowEntity(ENTRYENTITY_RIGHT, row);
            long schemeAssignId = entryRowEntity.getLong("assignrecord.id");
            long schemeId = entryRowEntity.getLong("rptscheme2.id");
            schemeAssignObjMap.put(schemeAssignId, entryRowEntity);
            schemeAssignIdSet.add(schemeAssignId);
            Set longs = schemeAssignMap.computeIfAbsent(schemeId, t -> new HashSet(16));
            longs.add(schemeAssignId);
        }
        Map schemeVariableByAssignId = ReportSchemeAssignService.getInstance().getSchemeVariableByAssignId(new ArrayList(schemeAssignIdSet));
        HashMap<String, Map<String, String>> currentVarValues = new HashMap<String, Map<String, String>>(16);
        if (schemeVariableByAssignId != null) {
            Map objectMap = BusinessDataServiceHelper.loadFromCache((String)"epm_dimension", (String)"id, number", (QFilter[])new QFilter[]{new QFilter(MODEL, "=", (Object)modelId)});
            for (Map.Entry entry : schemeVariableByAssignId.entrySet()) {
                Long key = (Long)entry.getKey();
                DynamicObject dynamicObject = (DynamicObject)objectMap.get(key);
                if (dynamicObject == null) continue;
                HashMap map = new HashMap(16);
                for (Map.Entry stringObjectEntry : ((Map)entry.getValue()).entrySet()) {
                    map.put(stringObjectEntry.getKey(), stringObjectEntry.getValue().toString());
                }
                currentVarValues.put(dynamicObject.getString("number"), map);
            }
        }
        for (Map.Entry entry : schemeAssignMap.entrySet()) {
            Long schemeId = (Long)entry.getKey();
            Set value = (Set)entry.getValue();
            for (Long schemeAssignId : value) {
                DynamicObject entryRowEntity = (DynamicObject)schemeAssignObjMap.get(schemeAssignId);
                if (entryRowEntity == null) continue;
                long dataTypeId = entryRowEntity.getLong("datatype.id");
                String dataTypeName = entryRowEntity.getString("datatype.name");
                long versionId = entryRowEntity.getLong("version.id");
                String versionName = entryRowEntity.getString("version.name");
                ReportSchemeEditHelper.checkAssignVersionAndDataType(modelId, schemeId, versionId, dataTypeId, versionName, dataTypeName, templateMap, currentVarValues, yearValidMsg, errorMsg);
            }
        }
        if (kd.epm.eb.common.utils.CollectionUtils.isNotEmpty(yearValidMsg)) {
            this.getView().showErrorNotification(((Object)yearValidMsg).toString());
            return;
        }
        if (kd.epm.eb.common.utils.CollectionUtils.isNotEmpty(errorMsg)) {
            this.getView().showMessage(ResManager.loadKDString((String)"\u4e0b\u8fbe\u6570\u636e\u4e0d\u5728\u7f16\u5236\u8868\u7684\u8303\u56f4\u5185\uff0c\u8bf7\u68c0\u67e5\u7f16\u5236\u6a21\u677f\u3002", (String)"ReportSchemeAssignPlugin_11", (String)"epm-eb-formplugin", (Object[])new Object[0]), String.join((CharSequence)"\n", errorMsg), null);
            return;
        }
        this.reportProcessAggService.createReportProcessBySchemeAssign(this.getModelId(), schemeAssignIdSet);
        this.updateAssignRecord(schemeAssignIdSet);
        this.copySchemeTemplateSortToAssign(schemeAssignMap);
        MultiLangEnumBridge opName = new MultiLangEnumBridge("\u91cd\u65b0\u4e0b\u8fbe", "ReportSchemeAssignPlugin_31", "epm-eb-formplugin");
        MultiLangEnumBridge opMsg = new MultiLangEnumBridge("\u91cd\u65b0\u4e0b\u8fbe\u6210\u529f\u3002", "ReportSchemeListPlugin_16", "epm-eb-formplugin");
        this.getView().showSuccessNotification(opMsg.loadKDString());
        this.writeLog(null, "assign", opName, opMsg, null);
    }

    public void copySchemeTemplateSortToAssign(Map<Long, Set<Long>> schemeAssignMap) {
        if (schemeAssignMap == null || schemeAssignMap.size() == 0) {
            return;
        }
        for (Map.Entry<Long, Set<Long>> entry : schemeAssignMap.entrySet()) {
            Long key = entry.getKey();
            Set<Long> value = entry.getValue();
            ReportSchemeTemplateSortService.getInstance().copyTemplateSort(key, value);
        }
    }

    private void updateAssignRecord(Set<Long> assignIds) {
        DynamicObject[] load = BusinessDataServiceHelper.load((Object[])assignIds.toArray(), (DynamicObjectType)BusinessDataServiceHelper.newDynamicObject((String)"eb_schemeassign").getDynamicObjectType());
        HashMap<Long, String> applyscope = new HashMap<Long, String>(16);
        if (load != null && load.length > 0) {
            Set scheme = Arrays.stream(load).map(x -> x.getLong("scheme.id")).collect(Collectors.toSet());
            if (CollectionUtils.isNotEmpty(scheme)) {
                DynamicObjectCollection query = QueryServiceHelper.query((String)"eb_rptscheme", (String)"id,applyscope", (QFilter[])new QFilter[]{new QFilter("id", "in", scheme)});
                for (DynamicObject dynamicObject : query) {
                    applyscope.put(dynamicObject.getLong("id"), dynamicObject.getString("applyscope"));
                }
            }
            for (DynamicObject dynamicObject : load) {
                String s;
                dynamicObject.set("assigner", (Object)this.getUserId());
                dynamicObject.set("assigntime", (Object)TimeServiceHelper.now());
                if (applyscope.isEmpty() || !kd.bos.dataentity.utils.StringUtils.isEmpty((CharSequence)(s = (String)applyscope.get(dynamicObject.getLong("scheme.id"))))) continue;
                dynamicObject.set("applyscope", (Object)s);
            }
            SaveServiceHelper.save((DynamicObject[])load);
        }
    }

    private Long getOrgViewId(Long bizRangeId) {
        return BusinessModelServiceHelper.getInstance().getViewId(bizRangeId, SysDimensionEnum.Entity.getNumber(), this.getModelId());
    }

    private void cancelAssgin() {
        EntryGrid entryGrid = (EntryGrid)this.getControl(ENTRYENTITY_RIGHT);
        int[] rows = entryGrid.getSelectRows();
        if (rows == null || rows.length == 0) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u81f3\u5c11\u9009\u62e9\u4e00\u4e2a\u4e0b\u8fbe\u8bb0\u5f55\u3002", (String)"ReportSchemeListPlugin_11", (String)"epm-eb-formplugin", (Object[])new Object[0]));
            return;
        }
        ArrayList<Long> records = new ArrayList<Long>(rows.length);
        boolean isExist = false;
        int i = 0;
        int j = 0;
        ArrayList<Integer> toDeleteRows = new ArrayList<Integer>(16);
        for (int row : rows) {
            DynamicObject record = (DynamicObject)this.getModel().getValue(RECORD_RIGHT, row);
            DynamicObject scheme = (DynamicObject)this.getModel().getValue(RPT_SCHEME_RIGHT, row);
            DynamicObject bizRange = (DynamicObject)this.getModel().getValue(BIZRANGE_RIGHT, row);
            DynamicObject year = (DynamicObject)this.getModel().getValue(YEAE, row);
            DynamicObject version = (DynamicObject)this.getModel().getValue(VERSION, row);
            DynamicObject datatype = (DynamicObject)this.getModel().getValue(DATATYPE, row);
            if (record == null || bizRange == null || scheme == null) continue;
            ArrayList<Triple<Long, String, String>> list = new ArrayList<Triple<Long, String, String>>();
            this.createTripleList(scheme.getLong("id"), list);
            if (ReportSchemeService.getInstance().isExistApReport(this.getModelId(), Long.valueOf(scheme.getLong("id")), Long.valueOf(year.getLong("id")), Long.valueOf(version.getLong("id")), Long.valueOf(datatype.getLong("id"))).booleanValue()) {
                ++i;
                isExist = true;
                continue;
            }
            if (this.checkRptProcess(row)) {
                ++j;
                isExist = true;
                continue;
            }
            toDeleteRows.add(row);
            records.add(record.getLong("id"));
        }
        try (TXHandle tx = TX.requiresNew((String)"cancelAssign");){
            MultiLangEnumBridge opMsg;
            MultiLangEnumBridge opName = new MultiLangEnumBridge("\u53d6\u6d88\u4e0b\u8fbe", "ReportSchemeAssignPlugin_30", "epm-eb-formplugin");
            try {
                List<BaseRptProcessRequest> deleteRptProcessRequest = this.createDeleteRptProcessRequest(toDeleteRows.toArray(new Integer[0]));
                deleteRptProcessRequest.forEach(r -> r.setCancelType(BaseRptProcessRequest.CancelType.SCHEME));
                this.reportProcessAggService.deleteReportProcess(deleteRptProcessRequest, this.getModelId());
                ReportSchemeAssignService.getInstance().deleteAssignRecord(records);
                ReportSchemeTemplateSortService.getInstance().deleteTemplateSortByRelation(new HashSet(records));
                if (j > 0) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u62a5\u8868\u6a21\u677f\u5df2\u63d0\u4ea4\uff0c\u65b9\u6848\u4e0b\u8fbe\u8bb0\u5f55\u5c06\u65e0\u6cd5\u53d6\u6d88\u4e0b\u8fbe\u3002", (String)"ReportSchemeAssignPlugin_17", (String)"epm-eb-formplugin", (Object[])new Object[0]));
                }
                if (i > 0) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u6a21\u677f\u5df2\u751f\u6210\u5355\u636e\uff0c\u65b9\u6848\u4e0b\u8fbe\u8bb0\u5f55\u5c06\u65e0\u6cd5\u53d6\u6d88\u4e0b\u8fbe\u3002", (String)"ReportSchemeAssignPlugin_18", (String)"epm-eb-formplugin", (Object[])new Object[0]));
                }
                if (!isExist) {
                    opMsg = new MultiLangEnumBridge("\u4e0b\u8fbe\u5df2\u53d6\u6d88\u3002", "ReportSchemeAssignPlugin_19", "epm-eb-formplugin");
                    this.getView().showSuccessNotification(opMsg.loadKDString());
                    this.writeLog(null, "assign", opName, opMsg, null);
                }
            }
            catch (Exception exception) {
                log.error("cancelAssign:error", (Throwable)exception);
                tx.markRollback();
                opMsg = new MultiLangEnumBridge("\u53d6\u6d88\u4e0b\u8fbe\u53d1\u751f\u5f02\u5e38\u3002", "ReportSchemeAssignPlugin_20", "epm-eb-formplugin");
                this.getView().showErrorNotification(opMsg.loadKDString());
                this.writeLog(null, "assign", opName, opMsg, null, false);
            }
        }
    }

    private boolean checkRptProcess(int row) {
        Integer[] rows = new Integer[]{row};
        List<BaseRptProcessRequest> deleteRptProcessRequest = this.createDeleteRptProcessRequest(rows);
        return this.reportProcessAggService.checkRequestHasApproveBill(deleteRptProcessRequest, this.getModelId());
    }

    private List<BaseRptProcessRequest> createDeleteRptProcessRequest(Integer[] rows) {
        ArrayList<BaseRptProcessRequest> result = new ArrayList<BaseRptProcessRequest>(16);
        Long modelID = this.getModelId();
        DynamicObjectCollection assignRecordList = this.getModel().getEntryEntity(ENTRYENTITY_RIGHT);
        HashSet<Long> schemeIdSet = new HashSet<Long>(16);
        HashMap<Long, List> schemeAssignMap = new HashMap<Long, List>(16);
        Integer[] integerArray = rows;
        int n = integerArray.length;
        for (int i = 0; i < n; ++i) {
            int row = integerArray[i];
            DynamicObject dynamicObject = (DynamicObject)assignRecordList.get(row);
            DynamicObject scheme = dynamicObject.getDynamicObject(RPT_SCHEME_RIGHT);
            DynamicObject orgViewObj = scheme.getDynamicObject(ORGVIEW_LEFT);
            long orgViewId = orgViewObj.getLong("id");
            long yearId = dynamicObject.getLong("year.id");
            long versionId = dynamicObject.getLong("version.id");
            long dataTypeId = dynamicObject.getLong("datatype.id");
            long schemeId = scheme.getLong("id");
            schemeIdSet.add(schemeId);
            List pvdIdMapList = schemeAssignMap.computeIfAbsent(schemeId, t -> new ArrayList(16));
            HashMap<String, Long> pvdIdMap = new HashMap<String, Long>(16);
            pvdIdMap.put(YEAE, yearId);
            pvdIdMap.put(VERSION, versionId);
            pvdIdMap.put(DATATYPE, dataTypeId);
            pvdIdMap.put("orgviewid", orgViewId);
            pvdIdMapList.add(pvdIdMap);
        }
        QFilter filter = new QFilter("scheme", "in", schemeIdSet);
        Map dynamicObjectMap = BusinessDataServiceHelper.loadFromCache((String)"eb_templateorg", (QFilter[])filter.toArray());
        HashMap<Long, List> templateEntityDtoMap = new HashMap<Long, List>(16);
        for (Map.Entry entry : dynamicObjectMap.entrySet()) {
            DynamicObject value = (DynamicObject)entry.getValue();
            DynamicObject scheme = value.getDynamicObject("scheme");
            long schemeId = scheme.getLong("id");
            DynamicObject template = value.getDynamicObject("template");
            DynamicObject org = value.getDynamicObject("org");
            if (template == null || org == null) continue;
            int orgrange = value.getInt("orgrange");
            long templateId = template.getLong("id");
            long orgId = org.getLong("id");
            List templateEntityDtoList = templateEntityDtoMap.computeIfAbsent(schemeId, t -> new ArrayList(16));
            TemplateEntityDto templateEntityDto = new TemplateEntityDto(Long.valueOf(templateId), Long.valueOf(orgId), Integer.valueOf(orgrange));
            templateEntityDto.setDeleteEntity(value.getDynamicObjectCollection("deleteentity").stream().map(x -> x.getLong("entity.id")).collect(Collectors.toSet()));
            templateEntityDtoList.add(templateEntityDto);
        }
        for (Map.Entry entry : schemeAssignMap.entrySet()) {
            Long schemeId = (Long)entry.getKey();
            List pvdIdMapList = (List)entry.getValue();
            if (CollectionUtils.isEmpty((Collection)pvdIdMapList)) continue;
            for (Map pvdIdMap : pvdIdMapList) {
                Long year = (Long)pvdIdMap.get(YEAE);
                Long version = (Long)pvdIdMap.get(VERSION);
                Long datatype = (Long)pvdIdMap.get(DATATYPE);
                Long orgviewid = (Long)pvdIdMap.get("orgviewid");
                List templateEntityDtoList = (List)templateEntityDtoMap.get(schemeId);
                if (CollectionUtils.isEmpty((Collection)templateEntityDtoList)) continue;
                BaseRptProcessRequest baseRptProcessRequest = new BaseRptProcessRequest(modelID, orgviewid, year, datatype, version, templateEntityDtoList);
                baseRptProcessRequest.setSchemeId(schemeId);
                result.add(baseRptProcessRequest);
            }
        }
        return result;
    }

    private void createTripleList(Long schemeId, List<Triple<Long, String, String>> list) {
        DynamicObjectCollection records = ReportSchemeService.getInstance().queryRecordBySchemeId2(schemeId);
        if (records == null) {
            return;
        }
        for (DynamicObject record : records) {
            String templatetype = record.getString("templatetype");
            Long templateId = 0L;
            if (kd.bos.dataentity.utils.StringUtils.isEmpty((CharSequence)templatetype)) {
                templatetype = "0";
            }
            if ("0".equals(templatetype)) {
                templateId = record.getLong("template");
            } else if ("1".equals(templatetype)) {
                templateId = record.getLong("applytemplate");
            }
            String orgnumber = record.getString("org.number");
            String range = record.getString("orgrange");
            MutableTriple triple = MutableTriple.of((Object)templateId, (Object)orgnumber, (Object)range);
            list.add((Triple<Long, String, String>)triple);
        }
    }

    public void propertyChanged(PropertyChangedArgs e) {
        String name = e.getProperty().getName();
        if (kd.bos.dataentity.utils.StringUtils.equals((CharSequence)"defaultassign", (CharSequence)name)) {
            ChangeData[] changeSet = e.getChangeSet();
            ChangeData changeData = changeSet[0];
            Object newValue = changeData.getNewValue();
            if (((Boolean)newValue).booleanValue()) {
                EntryGrid entryGrid = (EntryGrid)this.getControl(ENTRYENTITY_RIGHT);
                int[] selectRows = entryGrid.getSelectRows();
                if (selectRows.length != 1) {
                    return;
                }
                DynamicObjectCollection entryentity1 = this.getModel().getEntryEntity(ENTRYENTITY_RIGHT);
                for (int i = 0; i < entryentity1.size(); ++i) {
                    if (i == selectRows[0]) continue;
                    this.getModel().setValue("defaultassign", (Object)0, i);
                }
            }
            this.updateDefaultAssign((Boolean)newValue);
        }
    }

    private void updateDefaultAssign(Boolean isOpen) {
        DynamicObject assignRecord = (DynamicObject)this.getModel().getValue(RECORD_RIGHT);
        if (assignRecord == null) {
            return;
        }
        long assignRecordId = assignRecord.getLong("id");
        if (isOpen.booleanValue()) {
            DB.execute((DBRoute)DBRoute.of((String)"epm"), (String)"update t_eb_schemeassign set fdefaultassign = ? where fdefaultassign = ? and fmodelid = ? ", (Object[])new Object[]{"0", "1", this.getModelId()});
            DB.execute((DBRoute)DBRoute.of((String)"epm"), (String)"update t_eb_schemeassign set fdefaultassign = ? where fid = ? ", (Object[])new Object[]{"1", assignRecordId});
        } else {
            DB.execute((DBRoute)DBRoute.of((String)"epm"), (String)"update t_eb_schemeassign set fdefaultassign = ? where fid = ? ", (Object[])new Object[]{"0", assignRecordId});
        }
    }

    public void modelChanged(Long modelId) {
        UserSelectUtil.saveUserSelectWhenModelChange((IFormView)this.getView(), (Long)modelId);
        this.refreshLeftEntry();
        this.refreshRightEntry();
    }

    private void refreshLeftEntry() {
        Set<Long> curSelectSchemeIds = this.getCurSelectSchemeIds();
        HashSet<Integer> selectSchemeRows = new HashSet<Integer>(16);
        List<QFilter> currentQFiltersLeftEntry = this.getCurrentQFiltersLeftEntry();
        IDataModel dataModel = this.getModel();
        dataModel.getDataEntity(true);
        dataModel.beginInit();
        dataModel.deleteEntryData(ENTRYENTITY_LEFT);
        String selects = "id,number,bizrange,status,applyscope,orgview";
        DynamicObjectCollection dynamicObjects = null;
        if (currentQFiltersLeftEntry != null && currentQFiltersLeftEntry.size() > 0) {
            log.info("refreshLeftEntry ==> currentQFiltersLeftEntry=" + currentQFiltersLeftEntry);
            dynamicObjects = ReportSchemeService.getInstance().querySchemeByQFilters(selects, currentQFiltersLeftEntry);
        } else {
            log.info("refreshLeftEntry ==> modelId=" + this.getModelId());
            dynamicObjects = ReportSchemeService.getInstance().querySchemeByModelId(selects, this.getModelId());
        }
        if (dynamicObjects != null && dynamicObjects.size() > 0) {
            dataModel.batchCreateNewEntryRow(ENTRYENTITY_LEFT, dynamicObjects.size());
            for (int i = 0; i < dynamicObjects.size(); ++i) {
                Long schemeId = ((DynamicObject)dynamicObjects.get(i)).getLong("id");
                dataModel.setValue(RPT_SCHEME_LEFT, (Object)schemeId, i);
                dataModel.setValue(BIZRANGE_LEFT, (Object)((DynamicObject)dynamicObjects.get(i)).getLong("bizrange"), i);
                dataModel.setValue(ORGVIEW_LEFT, (Object)((DynamicObject)dynamicObjects.get(i)).getLong(ORGVIEW_LEFT), i);
                dataModel.setValue(APPLYSCOPE_LEFT, (Object)((DynamicObject)dynamicObjects.get(i)).getLong("applyscope"), i);
                String status = ((DynamicObject)dynamicObjects.get(i)).getString(STATUS);
                dataModel.setValue(STATUS, (Object)status, i);
                if (!curSelectSchemeIds.contains(schemeId)) continue;
                selectSchemeRows.add(i);
            }
        }
        dataModel.endInit();
        this.getView().updateView(ENTRYENTITY_LEFT);
        this.defaultSelectSchemeRow(selectSchemeRows);
    }

    private void refreshRightEntry() {
        List<QFilter> currentQFiltersRightEntry = this.getCurrentQFiltersRightEntry();
        IDataModel dataModel = this.getModel();
        long modelId = this.getModelId();
        if (modelId == 0L) {
            return;
        }
        dataModel.getDataEntity(true);
        dataModel.beginInit();
        dataModel.deleteEntryData(ENTRYENTITY_RIGHT);
        Set<Long> schemeIds = this.getCurSelectSchemeIds();
        DynamicObject[] dynamicObjects = null;
        if (currentQFiltersRightEntry != null && currentQFiltersRightEntry.size() > 0) {
            currentQFiltersRightEntry.add(new QFilter("scheme.id", "in", schemeIds));
            log.info("refreshRightEntry ==> currentQFiltersRightEntry=" + currentQFiltersRightEntry);
            dynamicObjects = ReportSchemeAssignService.getInstance().queryRecordByQFilters(currentQFiltersRightEntry);
        } else {
            log.info("refreshRightEntry ==> modelId=" + this.getModelId());
            dynamicObjects = ReportSchemeAssignService.getInstance().queryRecordByModel(Long.valueOf(modelId), schemeIds);
        }
        if (dynamicObjects != null && dynamicObjects.length > 0) {
            List collect = Arrays.stream(dynamicObjects).sorted((x, y) -> y.getDate("assigntime").compareTo(x.getDate("assigntime"))).collect(Collectors.toList());
            dataModel.batchCreateNewEntryRow(ENTRYENTITY_RIGHT, collect.size());
            for (int i = 0; i < collect.size(); ++i) {
                dataModel.setValue(RPT_SCHEME_RIGHT, ((DynamicObject)collect.get(i)).get("scheme"), i);
                dataModel.setValue("name", (Object)((DynamicObject)collect.get(i)).getString("name"), i);
                dataModel.setValue("description", ((DynamicObject)collect.get(i)).get("description"), i);
                dataModel.setValue(BIZRANGE_RIGHT, (Object)((DynamicObject)collect.get(i)).getLong(BUSMODEL_ID), i);
                dataModel.setValue(APPLYSCOPE_RIGHT, ((DynamicObject)collect.get(i)).get("applyscope"), i);
                dataModel.setValue(YEAE, (Object)((DynamicObject)collect.get(i)).getLong("year.id"), i);
                dataModel.setValue(DATATYPE, (Object)((DynamicObject)collect.get(i)).getLong("datatype.id"), i);
                dataModel.setValue(VERSION, (Object)((DynamicObject)collect.get(i)).getLong("version.id"), i);
                dataModel.setValue("assigntime", ((DynamicObject)collect.get(i)).get("assigntime"), i);
                dataModel.setValue(RECORD_RIGHT, ((DynamicObject)collect.get(i)).get("id"), i);
                dataModel.setValue("defaultassign", ((DynamicObject)collect.get(i)).get("defaultassign"), i);
                DynamicObjectCollection dynamicObjectCollection = ((DynamicObject)collect.get(i)).getDynamicObjectCollection("entryentity3");
                if (!CollectionUtils.isNotEmpty((Collection)dynamicObjectCollection)) continue;
                StringBuilder sb = new StringBuilder();
                for (DynamicObject dynamicObject : dynamicObjectCollection) {
                    sb.append(dynamicObject.getString("variablenumber.name")).append(":").append(dynamicObject.getString(SCHEME_ASSIGN_VARIABLE)).append(";");
                }
                if (sb.length() <= 0) continue;
                sb.setLength(sb.length() - 1);
                dataModel.setValue(SCHEME_ASSIGN_VARIABLE, (Object)sb.toString(), i);
            }
        }
        dataModel.endInit();
        this.getView().updateView(ENTRYENTITY_RIGHT);
    }

    @Override
    public void beforeF7Select(BeforeF7SelectEvent e) {
        String key = e.getProperty().getName();
        if (MODEL.equals(key)) {
            ListShowParameter showParameter = (ListShowParameter)e.getFormShowParameter();
            ArrayList qFilterList = ((BasedataEdit)this.getControl(MODEL)).getQFilters();
            if (qFilterList == null) {
                qFilterList = new ArrayList();
            }
            qFilterList.addAll(ModelUtil.getModelFilter((IFormView)this.getView()));
            showParameter.setListFilterParameter(new ListFilterParameter(qFilterList, null));
        }
    }

    @Override
    public Long getModelId() {
        DynamicObject modelObj = (DynamicObject)this.getModel().getValue(MODEL);
        if (modelObj != null) {
            return modelObj.getLong("id");
        }
        return null;
    }

    private Boolean isExistSameTemplate(List<Long> schemeIds) {
        DynamicObjectCollection dynamicObjects = ReportSchemeService.getInstance().queryTemplateBySchemeIds(schemeIds);
        HashMap map = new HashMap(16);
        for (DynamicObject dynamicObject : dynamicObjects) {
            Set set = null;
            String templateType = dynamicObject.getString("templatetype");
            if (kd.bos.dataentity.utils.StringUtils.isEmpty((CharSequence)templateType)) {
                templateType = "0";
            }
            String templateName = null;
            Long templateId = 0L;
            if ("0".equals(templateType)) continue;
            if ("1".equals(templateType)) {
                templateId = dynamicObject.getLong("applytemplate");
                templateName = dynamicObject.getString("applytemplate.name");
            }
            set = map.get(templateId) == null ? new HashSet(16) : (Set)map.get(templateId);
            set.add(dynamicObject.getString("scheme.name"));
            map.put(templateId, set);
            if (set.size() <= 1) continue;
            this.getView().showTipNotification(ResManager.loadResFormat((String)"\u6a21\u677f%1\u5728\u65b9\u6848%2\u4e2d\u540c\u65f6\u5b58\u5728\uff0c\u4e0d\u80fd\u540c\u65f6\u4e0b\u8fbe\u3002", (String)"ReportSchemeListPlugin_14", (String)"epm-eb-formplugin", (Object[])new Object[]{templateName, ((Object)set).toString()}));
            return true;
        }
        return false;
    }

    private void openDimensionRelPage() {
        IFormView childFormView;
        FormShowParameter formShowParameter = new FormShowParameter();
        formShowParameter.setFormId("epm_multidimrelationlist");
        formShowParameter.setPageId(StringUtils.join((Object[])new String[]{formShowParameter.getFormId(), "_", this.getView().getPageId()}));
        formShowParameter.setCustomParam("modelId", (Object)this.getModelId());
        formShowParameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
        formShowParameter.setCloseCallBack(new CloseCallBack());
        formShowParameter.setCaption(ResManager.loadKDString((String)"\u7ef4\u5ea6\u6620\u5c04\u5173\u7cfb\u5217\u8868", (String)"ReportSchemeListPlugin_15", (String)"epm-eb-formplugin", (Object[])new Object[0]));
        IFormView parentView = this.getView().getParentView();
        if (parentView != null) {
            formShowParameter.setParentPageId(parentView.getPageId());
        }
        if ((childFormView = this.getView().getView(formShowParameter.getPageId())) != null) {
            childFormView.activate();
            this.getView().sendFormAction(childFormView);
        } else {
            this.getView().showForm(formShowParameter);
        }
    }

    public void afterSetBgDefaultField() {
        super.afterSetBgDefaultField();
        this.getView().setVisible(Boolean.valueOf(false), new String[]{BIZRANGE_LEFT, ORGVIEW_LEFT, BIZRANGE_RIGHT, APPLYSCOPE_LEFT, APPLYSCOPE_RIGHT});
    }

    private void openApproveTypeListPage() {
        IFormView childFormView;
        FormShowParameter formShowParameter = new FormShowParameter();
        formShowParameter.setFormId("eb_approvaltypelist_new");
        formShowParameter.setPageId(StringUtils.join((Object[])new String[]{formShowParameter.getFormId(), "_", this.getView().getPageId()}));
        Long modelId = this.getModelId();
        formShowParameter.setCustomParam(MODEL, (Object)modelId);
        formShowParameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
        IFormView parentView = this.getView().getParentView();
        if (parentView != null) {
            formShowParameter.setParentPageId(parentView.getPageId());
        }
        if (NewEbAppUtil.isNewEbForm((IFormView)this.getView()) || NewEbAppUtil.isNewEbModel((Long)modelId)) {
            formShowParameter.setCustomParam("newEbForm", (Object)"true");
        }
        if ((childFormView = this.getView().getView(formShowParameter.getPageId())) != null) {
            childFormView.activate();
            this.getView().sendFormAction(childFormView);
        } else {
            this.getView().showForm(formShowParameter);
        }
    }

    public void filterContainerInit(FilterContainerInitEvent event) {
        List commonFilterColumns = event.getCommonFilterColumns();
        List modelfilterCol = commonFilterColumns.stream().filter(e -> e.getFieldName().equals(MODEL_NAME)).collect(Collectors.toList());
        List busfilterCol = commonFilterColumns.stream().filter(e -> e.getFieldName().equals(BUSMODEL_NAME)).collect(Collectors.toList());
        List statusfilterCol = commonFilterColumns.stream().filter(e -> e.getFieldName().equals(SCHEME_STATUS)).collect(Collectors.toList());
        CommonFilterColumn modelcfc = (CommonFilterColumn)modelfilterCol.get(0);
        CommonFilterColumn buscfc = (CommonFilterColumn)busfilterCol.get(0);
        CommonFilterColumn statuscfc = (CommonFilterColumn)statusfilterCol.get(0);
        ControlFilters filters = modelcfc.getContext().getControlFilters();
        boolean modelChanged = false;
        if (filters != null) {
            String selectModelFilterName;
            if (filters.getFilter(MODEL_ID) != null && filters.getFilter(MODEL_ID).size() > 0) {
                String selectModelFilterId = filters.getFilter(MODEL_ID).get(0).toString();
                if (kd.bos.dataentity.utils.StringUtils.isNotEmpty((CharSequence)selectModelFilterId) && !IDUtils.equals((Object)this.getModelId(), (Object)selectModelFilterId)) {
                    this.getModel().setValue(MODEL, (Object)IDUtils.toLong((Object)selectModelFilterId));
                    modelChanged = true;
                }
            } else if (filters.getFilter(MODEL_NAME) != null && filters.getFilter(MODEL_NAME).size() > 0 && kd.bos.dataentity.utils.StringUtils.isNotEmpty((CharSequence)(selectModelFilterName = filters.getFilter(MODEL_NAME).get(0).toString()))) {
                this.getModel().setValue(MODEL, (Object)this.getModelIdFromName(selectModelFilterName, this.getModel_comboItems()));
            }
        } else if (IDUtils.isNotNull((Long)this.modelIdFromQFilters)) {
            this.getModel().setValue(MODEL, (Object)this.modelIdFromQFilters);
        }
        ArrayList model_comboItems = null;
        if (this.getPageCache().get(MODEL_COMBOITEMS) != null) {
            model_comboItems = (ArrayList)ObjectSerialUtil.deSerializedBytes((String)this.getPageCache().get(MODEL_COMBOITEMS));
        } else {
            ArrayList modelQFilters = new ArrayList(16);
            modelQFilters.addAll(ModelUtil.getModelFilter((IFormView)this.getView()));
            DynamicObjectCollection col = QueryServiceHelper.query((String)MODEL, (String)"epm_model", (String)"id,name", (QFilter[])modelQFilters.toArray(new QFilter[0]), null);
            ArrayList comboItems = new ArrayList(16);
            col.forEach(e -> comboItems.add(new ComboItem(new LocaleString(e.getString("name")), e.getString("id"))));
            model_comboItems = comboItems;
            this.getPageCache().put(MODEL_COMBOITEMS, ObjectSerialUtil.toByteSerialized(model_comboItems));
        }
        if (model_comboItems != null && !model_comboItems.isEmpty()) {
            modelcfc.setComboItems((List)model_comboItems);
            DynamicObject dynamicObject2 = (DynamicObject)this.getModel().getValue(MODEL);
            if (dynamicObject2 != null) {
                for (FilterColumn commonFilterColumn : commonFilterColumns) {
                    String fieldName = commonFilterColumn.getFieldName();
                    if (!MODEL_NAME.equals(fieldName)) continue;
                    commonFilterColumn.setDefaultValue(dynamicObject2.getString("id"));
                }
            } else {
                String defaultModelId = ((ComboItem)model_comboItems.get(0)).getValue();
                modelcfc.setDefaultValue(((ComboItem)model_comboItems.get(0)).getValue());
                this.getModel().setValue(MODEL, (Object)IDUtils.toLong((Object)defaultModelId));
            }
        } else {
            throw new KDBizException(ResManager.loadKDString((String)"\u5f53\u524d\u65e0\u4efb\u4f55\u4f53\u7cfb\u3002", (String)"OffsetPaperPlugin_12", (String)"epm-eb-formplugin", (Object[])new Object[0]));
        }
        Long modelId = this.getModelId();
        buscfc.getComboItems().clear();
        if (IDUtils.isNotNull((Long)modelId)) {
            DynamicObjectCollection busmodels = QueryServiceHelper.query((String)"eb_businessmodel", (String)"id, name, number", (QFilter[])new QFilter[]{new QFilter(MODEL_ID, "=", (Object)modelId)});
            ArrayList busmodel_comboItems = new ArrayList(16);
            busmodels.forEach(dynamicObject -> busmodel_comboItems.add(new ComboItem(new LocaleString(dynamicObject.getString("name")), dynamicObject.getString("id"))));
            buscfc.setComboItems(busmodel_comboItems);
            if (modelChanged) {
                buscfc.setDefValue(null);
            }
        }
        ArrayList<ComboItem> status_comboItems = new ArrayList<ComboItem>(16);
        status_comboItems.add(new ComboItem(new LocaleString(RptSchemeStatusEnum.ENABLE.getName()), "1"));
        status_comboItems.add(new ComboItem(new LocaleString(RptSchemeStatusEnum.DISABLE.getName()), "2"));
        status_comboItems.add(new ComboItem(new LocaleString(RptSchemeStatusEnum.CLOSE.getName()), "0"));
        statuscfc.setComboItems(status_comboItems);
        List schemeFilterColumns = event.getSchemeFilterColumns();
        if (schemeFilterColumns != null) {
            for (FilterColumn filterColumn : schemeFilterColumns) {
                if (!SCHEME_STATUS.equals(filterColumn.getFieldName())) continue;
                ((SchemeBaseDataFilterColumn)filterColumn).setComboItems(status_comboItems);
            }
        }
        if (this.isNewEbForm() || ModelUtil.isBGModel((Long)this.getModelId())) {
            event.getCommonFilterColumns().removeAll(busfilterCol);
        }
    }

    private void filterContainerSearchClick(SearchClickEvent searchClickEvent) {
        List qFilters;
        FilterParameter filterParameter = searchClickEvent.getFilterParameter();
        Map currentCommonFilter = searchClickEvent.getCurrentCommonFilter();
        List fastQFilters = searchClickEvent.getFastQFilters();
        if (CollectionUtils.isNotEmpty((Collection)fastQFilters)) {
            List<List<QFilter>> qFilterList = this.translateFastFilter(fastQFilters);
            if (CollectionUtils.isNotEmpty(qFilterList)) {
                this.getPageCache().put("fastFilters", SerializationUtils.serializeToBase64(qFilterList));
            } else {
                this.getPageCache().put("fastFilters", "");
            }
        } else {
            this.getPageCache().put("fastFilters", "");
        }
        if (currentCommonFilter != null && MODEL_ID.equals(((List)currentCommonFilter.get("FieldName")).get(0))) {
            Long modelId = IDUtils.toLong(((List)currentCommonFilter.get("Value")).get(0));
            this.getModel().setValue(MODEL, (Object)modelId);
            if (IDUtils.isNotEmptyLong((Long)modelId).booleanValue()) {
                UserSelectUtil.saveUserSelectWhenModelChange((IFormView)this.getView(), (Long)modelId);
            }
            for (String field : modelFilterList) {
                Object busModelValue = searchClickEvent.getFilterValue(field);
                if (busModelValue == null) continue;
                ((List)searchClickEvent.getFilterValues().get("customfilter")).removeIf(t -> ((List)t.get("FieldName")).get(0) != null && field.equals(((List)t.get("FieldName")).get(0)));
            }
        }
        if (this.validateQFilters(qFilters = filterParameter.getQFilters())) {
            if (CollectionUtils.isNotEmpty((Collection)qFilters)) {
                this.getPageCache().put("qFilters", SerializationUtils.serializeToBase64((Object)qFilters));
            } else {
                this.getPageCache().put("qFilters", "");
            }
            this.refreshLeftEntry();
            this.refreshRightEntry();
        }
    }

    public List<ComboItem> getModel_comboItems() {
        if (this.model_comboItems == null) {
            String str = this.getPageCache().get(MODEL_COMBOITEMS);
            if (kd.bos.dataentity.utils.StringUtils.isNotEmpty((CharSequence)str)) {
                this.model_comboItems = (List)ObjectSerialUtil.deSerializedBytes((String)str);
            } else {
                ArrayList modelQFilters = new ArrayList(16);
                modelQFilters.addAll(ModelUtil.getModelFilter((IFormView)this.getView()));
                DynamicObjectCollection col = QueryServiceHelper.query((String)MODEL, (String)"epm_model", (String)"id,name", (QFilter[])modelQFilters.toArray(new QFilter[0]), null);
                ArrayList<ComboItem> comboItems = new ArrayList<ComboItem>(16);
                col.forEach(e -> comboItems.add(new ComboItem(new LocaleString(e.getString("name")), e.getString("id"))));
                this.model_comboItems = comboItems;
                this.getPageCache().put(MODEL_COMBOITEMS, ObjectSerialUtil.toByteSerialized(this.model_comboItems));
            }
        }
        return this.model_comboItems;
    }

    private boolean validateQFilters(List<QFilter> qFilters) {
        if (qFilters != null) {
            Iterator<QFilter> it = qFilters.iterator();
            while (it.hasNext()) {
                Long busModelId;
                DynamicObject dynamicObject;
                QFilter qFilter = it.next();
                if (qFilter == null) continue;
                if (MODEL_NAME.equals(qFilter.getProperty()) || MODEL_ID.equals(qFilter.getProperty())) {
                    if ("=".equalsIgnoreCase(qFilter.getCP()) && (qFilter.getValue() instanceof String || qFilter.getValue() instanceof Long)) {
                        if (MODEL_ID.equals(qFilter.getProperty())) {
                            this.modelIdFromQFilters = IDUtils.toLong((Object)qFilter.getValue());
                            continue;
                        }
                        if (!MODEL_NAME.equals(qFilter.getProperty())) continue;
                        this.modelIdFromQFilters = this.getModelIdFromName((String)qFilter.getValue(), this.getModel_comboItems());
                        continue;
                    }
                    if (!"in".equalsIgnoreCase(qFilter.getCP()) || !(qFilter.getValue() instanceof List) || ((List)qFilter.getValue()).size() != 1) continue;
                    if (MODEL_ID.equals(qFilter.getProperty())) {
                        this.modelIdFromQFilters = IDUtils.toLong(((List)qFilter.getValue()).get(0));
                        continue;
                    }
                    if (!MODEL_NAME.equals(qFilter.getProperty())) continue;
                    this.modelIdFromQFilters = this.getModelIdFromName((String)((List)qFilter.getValue()).get(0), this.getModel_comboItems());
                    continue;
                }
                if (!BUSMODEL_ID.equals(qFilter.getProperty()) || !(qFilter.getValue() instanceof Long) || !IDUtils.isNotNull((Long)this.modelIdFromQFilters) || (dynamicObject = BusinessDataServiceHelper.loadSingleFromCache((Object)(busModelId = IDUtils.toLong((Object)qFilter.getValue())), (String)"eb_businessmodel", (String)MODEL_ID)) != null && IDUtils.equals((Object)this.modelIdFromQFilters, (Object)dynamicObject.getLong(MODEL_ID))) continue;
                it.remove();
            }
        }
        if (IDUtils.isNull((Long)this.modelIdFromQFilters)) {
            log.info("validateQFilters ==> qFilters=" + qFilters);
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u8fc7\u6ee4\u6761\u4ef6\u4e2d\u65e0\u6709\u6743\u4f53\u7cfb\u6216\u5305\u542b\u591a\u4e2a\u6709\u6743\u4f53\u7cfb\uff0c\u8bf7\u68c0\u67e5\u6216\u4fee\u6539\u6761\u4ef6\u540e\u91cd\u65b0\u67e5\u8be2\u3002", (String)"ReportSchemeAssignPlugin_26", (String)"epm-eb-formplugin", (Object[])new Object[0]));
            return false;
        }
        return true;
    }

    private Long getModelIdFromName(String modelName, List<ComboItem> model_comboItems) {
        if (kd.bos.dataentity.utils.StringUtils.isNotEmpty((CharSequence)modelName) && model_comboItems != null) {
            Set hasPermModelIds = model_comboItems.stream().map(e -> IDUtils.toLong((Object)e.getValue())).collect(Collectors.toSet());
            Map map = BusinessDataServiceHelper.loadFromCache((String)"epm_model", (String)"id,number,name", (QFilter[])new QFilter[]{new QFilter("name", "like", (Object)modelName)});
            if (map != null && map.size() == 1) {
                Long modelId = ((DynamicObject)map.entrySet().iterator().next().getValue()).getLong("id");
                if (hasPermModelIds.contains(modelId)) {
                    return modelId;
                }
                throw new KDBizException(ResManager.loadResFormat((String)"\u65e0\u4f53\u7cfb\u6743\u9650\uff1a%1", (String)"ReportSchemeAssignPlugin_27", (String)"epm-eb-formplugin", (Object[])new Object[]{modelName}));
            }
            if (map != null && map.size() > 1) {
                throw new KDBizException(ResManager.loadResFormat((String)"\u8fc7\u6ee4\u6761\u4ef6\u4e2d\u5339\u914d\u5230\u591a\u4e2a\u4f53\u7cfb\uff1a%1", (String)"ReportSchemeAssignPlugin_28", (String)"epm-eb-formplugin", (Object[])new Object[]{modelName}));
            }
            throw new KDBizException(ResManager.loadResFormat((String)"\u4f53\u7cfb\u4e0d\u5b58\u5728\uff1a%1", (String)"ReportSchemeAssignPlugin_29", (String)"epm-eb-formplugin", (Object[])new Object[]{modelName}));
        }
        return null;
    }

    private List<List<QFilter>> translateFastFilter(List<QFilter> fastQFilters) {
        ArrayList<List<QFilter>> qFilters = new ArrayList<List<QFilter>>(10);
        for (QFilter fastQFilter : fastQFilters) {
            String[] split;
            ArrayList<QFilter> filters = new ArrayList<QFilter>(10);
            String valueStr = (String)fastQFilter.getValue();
            if (StringUtils.isNotEmpty((CharSequence)valueStr) && (split = valueStr.split("#")).length == 2) {
                QFilter qFilter;
                String property = split[0];
                String value = split[1];
                if (property.contains(",")) {
                    String[] propertySplit;
                    for (String s : propertySplit = property.split(",")) {
                        if (value.contains("\b")) {
                            String[] strings;
                            for (String string : strings = value.split("\b")) {
                                QFilter qFilter2 = new QFilter(s, "like", (Object)("%" + string + "%"));
                                filters.add(qFilter2);
                            }
                            continue;
                        }
                        qFilter = new QFilter(s, "like", (Object)("%" + value + "%"));
                        filters.add(qFilter);
                    }
                } else if (value.contains("\b")) {
                    String[] strings;
                    for (String string : strings = value.split("\b")) {
                        qFilter = new QFilter(property, "like", (Object)("%" + string + "%"));
                        filters.add(qFilter);
                    }
                } else {
                    QFilter qFilter3 = new QFilter(property, "like", (Object)("%" + value + "%"));
                    filters.add(qFilter3);
                }
            }
            qFilters.add(filters);
        }
        return qFilters;
    }

    private List<List<QFilter>> getFastFilters() {
        String fastFiltersStr = this.getPageCache().get("fastFilters");
        if (kd.bos.dataentity.utils.StringUtils.isNotEmpty((CharSequence)fastFiltersStr)) {
            return (List)SerializationUtils.deSerializeFromBase64((String)fastFiltersStr);
        }
        return null;
    }

    private List<QFilter> getCurrentQFiltersLeftEntry() {
        LinkedList<QFilter> qFiltersLeftEntry = null;
        List<QFilter> currentQFiltersRightEntry = this.getCurrentQFiltersRightEntry();
        if (currentQFiltersRightEntry != null) {
            qFiltersLeftEntry = new LinkedList<QFilter>();
            List nests = null;
            for (QFilter qFilter : currentQFiltersRightEntry) {
                String filterProperty = qFilter.getProperty();
                if (filterProperty == null) continue;
                if (qFilter != null && filterProperty.startsWith("scheme.")) {
                    qFilter.__setProperty(qFilter.getProperty().replaceAll("scheme.", ""));
                    nests = qFilter.getNests(false);
                    if (nests != null && nests.size() > 0) {
                        for (QFilter.QFilterNest nest : nests) {
                            QFilter nestQfilter = nest.getFilter();
                            if (nestQfilter == null || nestQfilter.getProperty() == null || !nestQfilter.getProperty().startsWith("scheme.")) continue;
                            nestQfilter.__setProperty(nestQfilter.getProperty().replaceAll("scheme.", ""));
                        }
                    }
                    qFiltersLeftEntry.add(qFilter);
                    continue;
                }
                if (!filterProperty.startsWith("model.") && !filterProperty.startsWith("bizrange.")) continue;
                qFiltersLeftEntry.add(qFilter);
            }
        }
        return qFiltersLeftEntry;
    }

    private List<QFilter> getCurrentQFiltersRightEntry() {
        List<List<QFilter>> fastFilters;
        LinkedList<QFilter> qFiltersRightEntry = null;
        String qFilterStr = this.getPageCache().get("qFilters");
        if (kd.bos.dataentity.utils.StringUtils.isNotEmpty((CharSequence)qFilterStr)) {
            qFiltersRightEntry = (LinkedList<QFilter>)SerializationUtils.deSerializeFromBase64((String)qFilterStr);
        }
        if ((fastFilters = this.getFastFilters()) != null) {
            if (qFiltersRightEntry == null) {
                qFiltersRightEntry = new LinkedList<QFilter>();
            }
            for (List<QFilter> fastFilter : fastFilters) {
                QFilter valueQF = null;
                for (QFilter qFilter : fastFilter) {
                    if (valueQF == null) {
                        valueQF = qFilter;
                        continue;
                    }
                    valueQF.or(qFilter);
                }
                qFiltersRightEntry.add(valueQF);
            }
        }
        return qFiltersRightEntry;
    }

    public void filterContainerBeforeF7Select(BeforeFilterF7SelectEvent args) {
        super.filterContainerBeforeF7Select(args);
        String fieldName = args.getFieldName();
        ArrayList<QFilter> filters = new ArrayList<QFilter>(10);
        if (MODEL_ID.equals(fieldName) || MODEL_NAME.equals(fieldName)) {
            filters.addAll(ModelUtil.getModelFilter((IFormView)this.getView()));
        } else {
            filters.add(new QFilter(MODEL, "=", (Object)this.getModelId()));
        }
        args.setQfilters(filters);
    }

    public void entryRowClick(RowClickEvent evt) {
        String entryKey = ((EntryGrid)evt.getSource()).getEntryKey();
        if (ENTRYENTITY_LEFT.equals(entryKey)) {
            this.refreshRightEntry();
        }
    }

    private Set<Long> getCurSelectSchemeIds() {
        EntryGrid entryGrid = (EntryGrid)this.getControl(ENTRYENTITY_LEFT);
        int[] selectRows = entryGrid.getSelectRows();
        if (selectRows != null && selectRows.length > 0) {
            HashSet<Long> schemeIds = new HashSet<Long>(selectRows.length);
            for (int selectRow : selectRows) {
                DynamicObject scheme = (DynamicObject)this.getModel().getValue(RPT_SCHEME_LEFT, selectRow);
                if (scheme == null) continue;
                schemeIds.add(IDUtils.toLong((Object)scheme.getLong("id")));
            }
            return schemeIds;
        }
        return new HashSet<Long>(0);
    }
}

