/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.formplugin.reportscheme;

import java.util.EventObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.resource.promptenum.MultiLangEnumBridge;
import kd.bos.entity.datamodel.AbstractFormDataModel;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.control.Control;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.operate.SetEntryBottom;
import kd.bos.form.operate.SetEntryTop;
import kd.epm.eb.business.reportscheme.service.ReportSchemeTemplateSortService;
import kd.epm.eb.common.utils.IDUtils;
import kd.epm.eb.formplugin.AbstractFormPlugin;

public class ReportSchemeTemplateSortPlugin
extends AbstractFormPlugin {
    private static final String BTN_TOP = "btn_top";
    private static final String BTN_BOTTOM = "btn_bottom";
    private static final String BTN_RESET = "btn_reset";
    private static final String BTN_OK = "btn_ok";
    private static final String RESET_CALLBACK_ID = "resetSort";
    private static final String ENTRYENTITY = "entryentity";

    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        this.renderList();
    }

    private void renderList() {
        this.renderBySortScheme(false);
    }

    private void renderBySortScheme(boolean reset) {
        this.getModel().deleteEntryData(ENTRYENTITY);
        this.getModel().beginInit();
        AbstractFormDataModel model = (AbstractFormDataModel)this.getModel();
        model.batchCreateNewEntryRow(ENTRYENTITY, ReportSchemeTemplateSortService.getInstance().getTemplateSortListTableValueSetter(this.getSchemeId(), reset));
        this.getModel().endInit();
        this.getView().updateView(ENTRYENTITY);
    }

    private Long getSchemeId() {
        return IDUtils.toLong((Object)this.getView().getFormShowParameter().getCustomParam("schemeId"));
    }

    private String getSchemeNumber() {
        return IDUtils.toString((Object)this.getView().getFormShowParameter().getCustomParam("schemeNumber"));
    }

    @Override
    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addItemClickListeners(new String[]{"advcontoolbarap"});
        this.addClickListeners(new String[]{BTN_OK});
    }

    public void click(EventObject evt) {
        super.click(evt);
        String key = ((Control)evt.getSource()).getKey();
        if (BTN_OK.equals(key)) {
            this.saveSort();
        }
    }

    public void itemClick(ItemClickEvent evt) {
        super.itemClick(evt);
        String itemKey = evt.getItemKey();
        if (BTN_TOP.equals(itemKey)) {
            this.setTop();
        } else if (BTN_BOTTOM.equals(itemKey)) {
            this.setBottom();
        } else if (BTN_RESET.equals(itemKey)) {
            this.getView().showConfirm(ResManager.loadKDString((String)"\u7ee7\u7eed\u64cd\u4f5c\u5c06\u5bf9\u6240\u6709\u5df2\u5206\u914d\u7684\u6a21\u677f\u6309\u7f16\u7801\u8fdb\u884c\u6392\u5e8f\uff0c\u6b64\u64cd\u4f5c\u4e0d\u53ef\u9006\uff0c\u662f\u5426\u7ee7\u7eed\u64cd\u4f5c\uff1f", (String)"ReportSchemeTemplateSortPlugin_01", (String)"epm-eb-formplugin", (Object[])new Object[0]), MessageBoxOptions.OKCancel, new ConfirmCallBackListener(RESET_CALLBACK_ID));
        }
    }

    private void saveSort() {
        String schemeNumber = this.getSchemeNumber();
        this.writeLog(schemeNumber, "save", new MultiLangEnumBridge("\u6a21\u677f\u6392\u5e8f\u4fdd\u5b58", "ReportSchemeTemplateSortPlugin_02", "epm-eb-formplugin"), new MultiLangEnumBridge("\u65b9\u6848\u7f16\u7801\uff1a%1$s", "ReportSchemeTemplateSortPlugin_03", "epm-eb-formplugin"), new String[]{schemeNumber});
        ReportSchemeTemplateSortService.getInstance().saveTemplateSort(this.getModelId(), this.getSchemeId(), this.getModel().getEntryEntity(ENTRYENTITY));
        this.getView().close();
    }

    public void confirmCallBack(MessageBoxClosedEvent messageBoxClosedEvent) {
        super.confirmCallBack(messageBoxClosedEvent);
        if (RESET_CALLBACK_ID.equals(messageBoxClosedEvent.getCallBackId()) && messageBoxClosedEvent.getResult() == MessageBoxResult.Yes) {
            this.renderBySortScheme(true);
        }
    }

    @Override
    public Long getModelId() {
        return IDUtils.toLong((Object)this.getView().getFormShowParameter().getCustomParam("modelId"));
    }

    private void setTop() {
        SetEntryTop setEntryTop = new SetEntryTop(ENTRYENTITY, this.getView());
        setEntryTop.invokeOperation();
    }

    private void setBottom() {
        SetEntryBottom setEntryBottom = new SetEntryBottom(ENTRYENTITY, this.getView());
        setEntryBottom.invokeOperation();
    }
}

