/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.formplugin.reportscheme.custom;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.entity.datamodel.AbstractFormDataModel;
import kd.bos.entity.datamodel.TableValueSetter;
import kd.bos.form.IFormView;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.plugin.FormViewPluginProxy;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.epm.eb.business.approvetype.ApproveUtils;
import kd.epm.eb.business.reportscheme.service.ReportSchemeTemplateSortService;
import kd.epm.eb.common.enums.BgTaskStateEnum;
import kd.epm.eb.common.utils.DateTimeUtils;
import kd.epm.eb.formplugin.reportscheme.ReportPreparationListPlugin;
import kd.epm.eb.formplugin.versionconstrast.VersionConstrastHelper;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;

public class MyEntryGridControl
extends EntryGrid {
    private String cacheId = "";
    private DynamicObject schemeObj;
    private ReportPreparationListPlugin reportPreparationListPlugin;

    public DynamicObject getSchemeObj() {
        return this.schemeObj;
    }

    public void setSchemeObj(DynamicObject schemeObj) {
        this.schemeObj = schemeObj;
    }

    public String getCacheId() {
        return this.cacheId;
    }

    public void setCacheId(String cacheId) {
        this.cacheId = cacheId;
    }

    private IFormPlugin getFormPlugin(IFormView view, String pluginName) {
        IFormPlugin plugin = null;
        FormViewPluginProxy pluginProxy = (FormViewPluginProxy)view.getService(FormViewPluginProxy.class);
        if (StringUtils.isNotEmpty((CharSequence)pluginName)) {
            plugin = pluginProxy.getPlugin(pluginName);
        } else if (pluginProxy != null && pluginProxy.getPlugIns().size() > 0) {
            plugin = (IFormPlugin)pluginProxy.getPlugIns().get(0);
        }
        return plugin;
    }

    public ReportPreparationListPlugin getReportPreparationListPlugin() {
        if (this.reportPreparationListPlugin != null) {
            return this.reportPreparationListPlugin;
        }
        this.reportPreparationListPlugin = (ReportPreparationListPlugin)this.getFormPlugin(this.getView(), "kd.epm.eb.formplugin.reportscheme.ReportPreparationListPlugin");
        return this.reportPreparationListPlugin;
    }

    protected boolean onFetchPageData(int pageIndex, int pageRows) {
        int startRowIndex = (pageIndex - 1) * pageRows;
        ReportPreparationListPlugin reportPreparationListPlugin = this.getReportPreparationListPlugin();
        if (reportPreparationListPlugin == null) {
            reportPreparationListPlugin = new ReportPreparationListPlugin(this.getView(), this.getView().getModel(), this.getView().getPageCache());
        }
        List<Long> reportListByPage = reportPreparationListPlugin.initReportProcessList(pageIndex, pageRows, true);
        int rowCount = reportPreparationListPlugin.getReportPreparationListLocalSmall().getTotalRowCount();
        if (CollectionUtils.isEmpty(reportListByPage)) {
            return false;
        }
        this.deleteEntryData();
        HashSet<Long> ids = new HashSet<Long>(reportListByPage);
        List<DynamicObject> reportProcessDynamicList = this.getReportProcessDynamicList(ids);
        this.getModel().beginInit();
        this.setEntryPageInfo(pageRows, 0, 0);
        this.getModel().endInit();
        this.getModel().beginInit();
        this.renderEntryByPage(reportProcessDynamicList);
        this.setEntryPageInfo(pageRows, rowCount, startRowIndex);
        this.getModel().endInit();
        return true;
    }

    public List<DynamicObject> getReportProcessDynamicList(Set<Long> ids) {
        QFilter filter = new QFilter("id", "in", ids);
        DynamicObjectCollection reportProcessDynamicList = QueryServiceHelper.query((String)"eb_reportprocess", (String)"id, template.name, template.id,template.number, entity, entity.name, entity.number, status, modifydate, modifier.name, submituser.name, submitentity, submitentity.name, submitdate, approvebill, '' as approvedesc, '' as audittype, '' as auditor, '' as rejectopinion, '' as rejecthasmodify, '' as splitbills, 0 as versionconstrast", (QFilter[])filter.toArray());
        HashMap processTemplateMap = new HashMap(16);
        HashSet approveBillIds = new HashSet(16);
        Map<Long, Integer> orgSeqOfDeep = this.getReportPreparationListPlugin().getOrgSeqOfDeep();
        Long schemeAssignId = this.getReportPreparationListPlugin().getCurrentSchemeAssignId();
        Set<Long> templateIdSet = this.getReportPreparationListPlugin().getReportPreparationListLocal().getTemplateIdSet();
        Map templateSortMap = ReportSchemeTemplateSortService.getInstance().getTemplateSortMap(schemeAssignId, templateIdSet);
        List<DynamicObject> processDynamics = reportProcessDynamicList.stream().sorted((o1, o2) -> {
            String templateNum1 = o1.getString("template.number");
            String templateNum2 = o2.getString("template.number");
            long templateId1 = o1.getLong("template.id");
            long templateId2 = o2.getLong("template.id");
            if (StringUtils.isEmpty((CharSequence)templateNum1) && StringUtils.isEmpty((CharSequence)templateNum2)) {
                return 0;
            }
            if (StringUtils.isEmpty((CharSequence)templateNum1)) {
                return 1;
            }
            if (StringUtils.isEmpty((CharSequence)templateNum2)) {
                return -1;
            }
            processTemplateMap.put(o1.getLong("id"), templateId1);
            processTemplateMap.put(o2.getLong("id"), templateId2);
            approveBillIds.add(o1.getLong("approvebill"));
            approveBillIds.add(o2.getLong("approvebill"));
            int seq = templateNum1.compareTo(templateNum2);
            if (templateSortMap != null && templateSortMap.size() > 0) {
                Integer templateSeq1 = (Integer)templateSortMap.get(templateId1);
                Integer templateSeq2 = (Integer)templateSortMap.get(templateId2);
                if (templateSeq1 != null && templateSeq2 != null) {
                    seq = templateSeq1 - templateSeq2;
                }
            }
            if (seq == 0 && orgSeqOfDeep != null) {
                Integer entitySeq1 = (Integer)orgSeqOfDeep.get(o1.getLong("entity"));
                Integer entitySeq2 = (Integer)orgSeqOfDeep.get(o2.getLong("entity"));
                if (entitySeq1 == null && entitySeq2 == null) {
                    return 0;
                }
                if (entitySeq1 == null) {
                    return 1;
                }
                if (entitySeq2 == null) {
                    return -1;
                }
                return entitySeq1.compareTo(entitySeq2);
            }
            return seq;
        }).collect(Collectors.toList());
        ApproveUtils.getInstance().updateProcessDynamics(processDynamics, processTemplateMap, approveBillIds);
        new VersionConstrastHelper().updateProcessDynamics(processDynamics);
        return processDynamics;
    }

    public void setPageRows(int rows) {
        super.setPageRows(rows);
        this.getView().updateView(this.key);
        this.selectRow(0);
    }

    public void renderEntryByPage(DynamicObject processObj, int index) {
        this.getModel().setValue("scheme", (Object)this.schemeObj, index);
        this.getModel().setValue("process", (Object)processObj.getLong("id"), index);
        this.getModel().setValue("reportnumber", (Object)processObj.getString("template.number"), index);
        this.getModel().setValue("reportname", (Object)processObj.getString("template.name"), index);
        this.getModel().setValue("entityname", (Object)processObj.getString("entity.name"), index);
        this.getModel().setValue("status", (Object)this.getBgTaskStateDesc(processObj.getString("status")), index);
        String modifydate = processObj.getString("modifydate");
        if (StringUtils.isNotBlank((CharSequence)modifydate)) {
            this.getModel().setValue("modifydate", (Object)DateTimeUtils.formatFromStr((String)modifydate), index);
        }
        this.getModel().setValue("modifier", (Object)processObj.getString("modifier.name"), index);
        this.getModel().setValue("submituser", (Object)processObj.getString("submituser.name"), index);
        this.getModel().setValue("submitentity", (Object)processObj.getString("submitentity.name"), index);
        String submitdate = processObj.getString("submitdate");
        if (StringUtils.isNotBlank((CharSequence)submitdate)) {
            this.getModel().setValue("submitdate", (Object)DateTimeUtils.formatFromStr((String)submitdate), index);
        }
        this.getModel().setValue("approvebill", (Object)processObj.getLong("approvebill"), index);
        this.getModel().setValue("approvedesc", (Object)processObj.getString("approvedesc"), index);
        this.getModel().setValue("audittype", (Object)processObj.getString("audittype"), index);
        this.getModel().setValue("rejecthasmodify", (Object)processObj.getString("rejecthasmodify"), index);
        this.getModel().setValue("auditor", (Object)processObj.getString("auditor"), index);
        this.getModel().setValue("rejectopinion", (Object)processObj.getString("rejectopinion"), index);
        this.getModel().setValue("splitbills", (Object)processObj.getString("splitbills"), index);
    }

    public void renderEntryByPage(List<DynamicObject> reportProcessDynamicList) {
        AbstractFormDataModel model = (AbstractFormDataModel)this.getModel();
        TableValueSetter vs = new TableValueSetter(new String[]{"scheme", "process", "reportnumber", "reportname", "approvedesc", "entityname", "status", "modifydate", "modifier", "submituser", "submitentity", "submitdate", "approvebill", "audittype", "rejecthasmodify", "auditor", "rejectopinion", "splitbills", "versionconstrast"});
        boolean i = false;
        for (DynamicObject processObj : reportProcessDynamicList) {
            vs.addRow(new Object[]{this.schemeObj, processObj.getLong("id"), processObj.getString("template.number"), processObj.getString("template.name"), processObj.getString("approvedesc"), processObj.getString("entity.name"), this.getBgTaskStateDesc(processObj.getString("status")), DateTimeUtils.formatFromStr((String)processObj.getString("modifydate")), processObj.getString("modifier.name"), processObj.getString("submituser.name"), processObj.getString("submitentity.name"), DateTimeUtils.formatFromStr((String)processObj.getString("submitdate")), processObj.getLong("approvebill"), processObj.getString("audittype"), processObj.getString("rejecthasmodify"), processObj.getString("auditor"), processObj.getString("rejectopinion"), processObj.getString("splitbills"), processObj.getBoolean("versionconstrast")});
        }
        model.batchCreateNewEntryRow("billlist_entity", vs);
    }

    private String getBgTaskStateDesc(String status) {
        if (BgTaskStateEnum.INCOMPLETE.getNumber().equals(status)) {
            return ResManager.loadKDString((String)"\u5ba1\u6838\u672a\u901a\u8fc7", (String)"ReportPreparationListPlugin_55", (String)"epm-eb-formplugin", (Object[])new Object[0]);
        }
        for (BgTaskStateEnum value : BgTaskStateEnum.values()) {
            if (!StringUtils.equals((CharSequence)value.getNumber(), (CharSequence)status)) continue;
            return value.getName();
        }
        return "";
    }

    public void setEntryPageInfo(int pageSize, int rowCount, int startRowIndex) {
        DynamicObject billObj = this.getModel().getDataEntity(true);
        billObj.getDataEntityState().setEntryPageSize(this.getKey(), pageSize);
        billObj.getDataEntityState().setEntryRowCount(this.getKey(), rowCount);
        billObj.getDataEntityState().setEntryStartRowIndex(this.getKey(), startRowIndex);
    }

    public void deleteEntryData() {
        this.getModel().deleteEntryData(this.getKey());
    }

    public void selectRow(int pageIndex) {
        int pageRow = this.getPageRow();
        String totalSelect = this.getView().getPageCache().get("totalSelect");
        Set processIds = new HashSet(16);
        if (StringUtils.isNotEmpty((CharSequence)totalSelect)) {
            processIds = (Set)SerializationUtils.deSerializeFromBase64((String)totalSelect);
        }
        DynamicObjectCollection entryEntity = this.getModel().getEntryEntity(this.key);
        ArrayList<Integer> containIndex = new ArrayList<Integer>(16);
        for (int j = 0; j < entryEntity.size(); ++j) {
            long processId;
            DynamicObject dynamicObject = (DynamicObject)entryEntity.get(j);
            if (dynamicObject == null || !processIds.contains(processId = StringUtils.equals((CharSequence)"template_entity", (CharSequence)this.key) ? dynamicObject.getLong("tprocess.id") : dynamicObject.getLong("process.id"))) continue;
            containIndex.add(pageIndex * pageRow + j);
        }
        if (containIndex.size() > 0) {
            int[] rows = new int[containIndex.size()];
            for (int i = 0; i < containIndex.size(); ++i) {
                rows[i] = (Integer)containIndex.get(i);
            }
            this.selectRows(rows, rows[0]);
        }
    }

    public void setPageIndex(int pageIndex) {
        super.setPageIndex(pageIndex);
        this.getView().updateView(this.key);
        this.selectRow(pageIndex - 1);
        this.getView().getPageCache().put("currentPageIndex", String.valueOf(pageIndex));
    }
}

