/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.formplugin.reportscheme.helper;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.tree.TreeNode;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.epm.eb.business.templateperm.TemplatePermServiceHelper;
import kd.epm.eb.business.tree.EbTreeNode;
import kd.epm.eb.common.cache.IModelCacheHelper;
import kd.epm.eb.common.cache.ModelCacheContext;
import kd.epm.eb.common.cache.impl.BaseCache;
import kd.epm.eb.common.cache.impl.Member;
import kd.epm.eb.common.enums.RangeEnum;
import kd.epm.eb.common.enums.SysDimensionEnum;
import kd.epm.eb.common.reportprocess.entity.domain.ReportProcess;
import kd.epm.eb.common.reportprocess.service.impl.ReportProcessAggService;
import kd.epm.eb.common.reportprocess.service.impl.ReportProcessServiceImpl;
import kd.epm.eb.common.templateperm.TemplateTypeEnum;
import kd.epm.eb.common.templateperm.TemplateUserQueryResult;
import kd.epm.eb.common.utils.IDUtils;
import kd.epm.eb.common.utils.ModelServiceHelper;
import kd.epm.eb.formplugin.report.submission.controller.ReportSubmitRangeController;
import kd.epm.eb.formplugin.reportscheme.helper.EntityDimPermHelper;
import kd.epm.eb.formplugin.reportscheme.helper.TemplateEntityPermHelper;
import org.apache.commons.collections4.CollectionUtils;

public class ReportPreparationListHelper {
    private static final Log log = LogFactory.getLog(ReportPreparationListHelper.class);
    private TemplateEntityPermHelper templateEntityPermHelper = null;

    public IModelCacheHelper getModelCacheHelper(Long modelId) {
        if (IDUtils.isEmptyLong((Long)modelId).booleanValue()) {
            return null;
        }
        return ModelCacheContext.getOrCreate((Long)modelId);
    }

    public Set<Long> getEntityTreeIdSet(Long modelId, Long schemeId, Long dataSetId, Long entityViewId) {
        if (IDUtils.isEmptyLong((Long)modelId).booleanValue() || IDUtils.isEmptyLong((Long)schemeId).booleanValue() || IDUtils.isEmptyLong((Long)dataSetId).booleanValue()) {
            return Collections.emptySet();
        }
        TemplateEntityPermHelper templateEntityPermHelper = this.getTemplateEntityPermHelper();
        EntityDimPermHelper entityDimPermHelper = new EntityDimPermHelper();
        Set<Long> entityPermInScheme = templateEntityPermHelper.getEntityPermInScheme(schemeId, this.getModelCacheHelper(modelId), entityViewId);
        boolean modelManager = ModelServiceHelper.isModelManager((Long)modelId);
        if (!modelManager) {
            Set<Long> hasPermOrgIdSet = entityDimPermHelper.getHasPermOrgIdSet(modelId, dataSetId, entityViewId);
            if (hasPermOrgIdSet == null) {
                log.info("entity dim has not set perm.");
                return entityPermInScheme;
            }
            entityPermInScheme.retainAll(hasPermOrgIdSet);
        }
        return entityPermInScheme;
    }

    public Set<Long> getTemplateTreeIdSet(Long modelId, Long schemeId) {
        if (IDUtils.isEmptyLong((Long)modelId).booleanValue() || IDUtils.isEmptyLong((Long)schemeId).booleanValue()) {
            return Collections.emptySet();
        }
        TemplateEntityPermHelper templateEntityPermHelper = this.getTemplateEntityPermHelper();
        Set<Long> templatePermInScheme = templateEntityPermHelper.getTemplatePermInScheme(schemeId);
        boolean modelManager = ModelServiceHelper.isModelManager((Long)modelId);
        if (!modelManager) {
            Long schemeViewId = TemplatePermServiceHelper.getSchemeViewId((Long)schemeId);
            Set hasPermTemplateIdSet = TemplatePermServiceHelper.getUserHasPermTemplateIds((Long)modelId, (TemplateTypeEnum)TemplateTypeEnum.BUDGET, null, null, (Long)schemeViewId);
            templatePermInScheme.retainAll(hasPermTemplateIdSet);
        }
        return templatePermInScheme;
    }

    public Set<Long> parseEntityRangeIdSet(IModelCacheHelper modelCacheHelper, Long entityViewId, Long entityId, Integer entityRange) {
        Set<Long> result = Collections.emptySet();
        if (modelCacheHelper == null) {
            return result;
        }
        Member member = modelCacheHelper.getMember(SysDimensionEnum.Entity.getNumber(), entityViewId, entityId);
        if (member == null) {
            return result;
        }
        List member1 = modelCacheHelper.getMember(SysDimensionEnum.Entity.getNumber(), entityViewId, member.getNumber(), entityRange.intValue());
        return member1.stream().map(BaseCache::getId).collect(Collectors.toSet());
    }

    public TreeNode getEntityRootNode(IModelCacheHelper modelCacheHelper, Long viewId) {
        EbTreeNode rootNode = new EbTreeNode();
        if (modelCacheHelper == null) {
            rootNode.setText(ResManager.loadKDString((String)"\u7ec4\u7ec7", (String)"ReportPreparationListPlugin_38", (String)"epm-eb-formplugin", (Object[])new Object[0]));
            rootNode.setId("");
            rootNode.setParentid("");
            return rootNode;
        }
        Member rootEntityMember = modelCacheHelper.getRootMember(SysDimensionEnum.Entity.getNumber(), viewId);
        rootNode.setText(rootEntityMember.getName());
        rootNode.setParentid("");
        rootNode.setId(rootEntityMember.getId() + "");
        return rootNode;
    }

    public TreeNode getTemplateRootNode(Long modelId) {
        EbTreeNode rootNode = new EbTreeNode();
        rootNode.setText(ResManager.loadKDString((String)"\u6a21\u677f\u5206\u7c7b", (String)"ReportPreparationListPlugin_3", (String)"epm-eb-formplugin", (Object[])new Object[0]));
        rootNode.setId("");
        rootNode.setParentid("");
        if (IDUtils.isEmptyLong((Long)modelId).booleanValue()) {
            return rootNode;
        }
        QFilter filter = new QFilter("model", "=", (Object)modelId);
        filter.and("parent.id", "=", (Object)0);
        DynamicObjectCollection query = QueryServiceHelper.query((String)"eb_templatecatalog", (String)"id, parent.id, name", (QFilter[])filter.toArray());
        if (CollectionUtils.isEmpty((Collection)query)) {
            return rootNode;
        }
        DynamicObject dynamicObject = (DynamicObject)query.get(0);
        rootNode.setText(dynamicObject.getString("name"));
        rootNode.setId("");
        rootNode.setParentid("");
        return rootNode;
    }

    public boolean canAddReportProcess(Map<Long, Set<Map<String, Object>>> templateEntityRangeMap, Long templateId, Long entityId, IModelCacheHelper modelCache, Long entityViewId, Map<String, Set<Long>> entityRangeCache, TemplateUserQueryResult userTemplatePermDetails) {
        Set<Map<String, Object>> dispatchEntityMap = templateEntityRangeMap.get(templateId);
        if (CollectionUtils.isEmpty(dispatchEntityMap)) {
            return false;
        }
        Set dispatchEntityId = dispatchEntityMap.stream().map(x -> x.get("range")).collect(Collectors.toSet());
        if (!this.hasTemplateEntityPerm(entityId, templateId, userTemplatePermDetails)) {
            return false;
        }
        if (entityRangeCache == null) {
            entityRangeCache = new HashMap<String, Set<Long>>(16);
        }
        if (!dispatchEntityId.contains(entityId)) {
            boolean inDispatchEntityRange = false;
            for (Map<String, Object> entityRangeObj : dispatchEntityMap) {
                Set<Long> memIdSet = this.parseOrgMemberByRange(entityRangeCache, modelCache, entityViewId, entityRangeObj);
                if (!memIdSet.contains(entityId)) continue;
                inDispatchEntityRange = true;
                break;
            }
            return inDispatchEntityRange;
        }
        return true;
    }

    private boolean hasTemplateEntityPerm(long entityId, long templateId, TemplateUserQueryResult userTemplatePermDetails) {
        if (userTemplatePermDetails == null || userTemplatePermDetails.isHasAllPerm()) {
            return true;
        }
        Map templateEntityMap = userTemplatePermDetails.getTemplateEntityMap();
        if (templateEntityMap == null) {
            return false;
        }
        Set entityIds = (Set)templateEntityMap.get(templateId);
        boolean flag = CollectionUtils.isEmpty((Collection)entityIds) ? false : (entityIds.size() == 1 && entityIds.contains(0L) ? true : entityIds.contains(entityId));
        return flag;
    }

    private Set<Long> parseOrgMemberByRange(Map<String, Set<Long>> entityRangeCache, IModelCacheHelper modelCache, long entityViewId, Map<String, Object> entityRangeObj) {
        String entityRange;
        String cacheKey = entityRange = entityRangeObj.get("range").toString();
        if (entityRangeObj.containsKey("record")) {
            cacheKey = entityRange + "#" + entityRangeObj.get("record");
        }
        return entityRangeCache.computeIfAbsent(cacheKey, t -> {
            Object deleteEntity;
            long orgId;
            int range = RangeEnum.ONLY.getIndex();
            String[] split = entityRange.split("#");
            if (split.length > 1) {
                orgId = Long.parseLong(split[0]);
                RangeEnum rangeEnum = RangeEnum.getRangeByVal((String)split[1].trim());
                if (rangeEnum != null) {
                    range = rangeEnum.getIndex();
                }
            } else {
                orgId = Long.parseLong(entityRange);
            }
            ArrayList memberList = modelCache.getMember(SysDimensionEnum.Entity.getNumber(), Long.valueOf(entityViewId), Long.valueOf(orgId), range);
            if (memberList == null) {
                memberList = new ArrayList(0);
            }
            Set memberIdSet = memberList.stream().map(BaseCache::getId).collect(Collectors.toSet());
            if (entityRangeObj.containsKey("deleteentity") && (deleteEntity = entityRangeObj.get("deleteentity")) instanceof Set) {
                Set delIdSet = (Set)deleteEntity;
                memberIdSet.removeAll(delIdSet);
            }
            return memberIdSet;
        });
    }

    public TemplateEntityPermHelper getTemplateEntityPermHelper() {
        if (this.templateEntityPermHelper == null) {
            this.templateEntityPermHelper = new TemplateEntityPermHelper();
        }
        return this.templateEntityPermHelper;
    }

    public void setTemplateEntityPermHelper(TemplateEntityPermHelper templateEntityPermHelper) {
        this.templateEntityPermHelper = templateEntityPermHelper;
    }

    public List<ReportProcess> getCurrentEntityAllReportProcess(Long modelId, Long periodId, Long dataTypeId, Long versionId, IModelCacheHelper modelCacheHelper, Long orgViewId, Long schemeId, Long currentEntityId, Set<Long> templateIds) {
        HashSet<Long> entityIds = new HashSet<Long>(16);
        entityIds.add(currentEntityId);
        return this.getCurrentEntityAllReportProcess(modelId, periodId, dataTypeId, versionId, modelCacheHelper, orgViewId, schemeId, entityIds, templateIds);
    }

    public List<ReportProcess> getCurrentTemplateAllReportProcess(Long modelId, Long periodId, Long dataTypeId, Long versionId, IModelCacheHelper modelCacheHelper, Long orgViewId, Long schemeId, Long templateId, Set<Long> entityIds) {
        HashSet<Long> templateIds = new HashSet<Long>(16);
        templateIds.add(templateId);
        return this.getCurrentEntityAllReportProcess(modelId, periodId, dataTypeId, versionId, modelCacheHelper, orgViewId, schemeId, entityIds, templateIds);
    }

    private List<ReportProcess> getCurrentEntityAllReportProcess(Long modelId, Long periodId, Long dataTypeId, Long versionId, IModelCacheHelper modelCacheHelper, Long orgViewId, Long schemeId, Set<Long> entityIds, Set<Long> templateIds) {
        ArrayList<ReportProcess> result = new ArrayList<ReportProcess>(16);
        if (CollectionUtils.isEmpty(templateIds) || CollectionUtils.isEmpty(entityIds)) {
            return result;
        }
        List reportProcessList = ReportProcessServiceImpl.getInstance().getReportProcessList(modelId, periodId, dataTypeId, versionId, entityIds, templateIds);
        Map<Long, Set<Map<String, Object>>> templateEntityRangeMap = this.getTemplateEntityPermHelper().getTemplateEntityRangeMap(schemeId);
        TemplateUserQueryResult userTemplatePermDetails = TemplatePermServiceHelper.getUserTemplatePermDetails((Long)modelId, (TemplateTypeEnum)TemplateTypeEnum.BUDGET, templateIds, entityIds, (Long)orgViewId);
        HashMap<String, Set<Long>> entityRangeCache = new HashMap<String, Set<Long>>(16);
        for (ReportProcess reportProcess : reportProcessList) {
            Long entityId = reportProcess.getEntityId();
            Long templateId = reportProcess.getTemplateId();
            boolean b = this.canAddReportProcess(templateEntityRangeMap, templateId, entityId, modelCacheHelper, orgViewId, entityRangeCache, userTemplatePermDetails);
            if (!b) continue;
            result.add(reportProcess);
        }
        return result;
    }

    public Set<Long> commitOrgIsAllHaveRpt(Long modelId, Long periodId, Long dataTypeId, Long versionId, IModelCacheHelper modelCacheHelper, Long orgViewId, Long schemeId, Set<Long> entityIds, Set<Long> templateIds) {
        HashSet<Long> result = new HashSet<Long>(16);
        if (CollectionUtils.isEmpty(templateIds) || CollectionUtils.isEmpty(entityIds)) {
            return result;
        }
        Map<Long, Set<Map<String, Object>>> templateEntityRangeMap = this.getTemplateEntityPermHelper().getTemplateEntityRangeMap(schemeId);
        TemplateUserQueryResult userTemplatePermDetails = TemplatePermServiceHelper.getUserTemplatePermDetails((Long)modelId, (TemplateTypeEnum)TemplateTypeEnum.BUDGET, templateIds, entityIds, (Long)orgViewId);
        Map reportProcessMap = ReportProcessAggService.getInstance().getReportProcessMap(modelId, periodId, dataTypeId, versionId, entityIds, templateIds, ReportSubmitRangeController.RPTFILTERSTATUS);
        HashMap<String, Set<Long>> entityRangeCache = new HashMap<String, Set<Long>>(16);
        for (Long entityId : entityIds) {
            Set templateIdsFromRpt = (Set)reportProcessMap.get(entityId);
            if (CollectionUtils.isEmpty((Collection)templateIdsFromRpt)) {
                result.add(entityId);
                continue;
            }
            boolean flag = false;
            for (Long templateId : templateIdsFromRpt) {
                boolean b = this.canAddReportProcess(templateEntityRangeMap, templateId, entityId, modelCacheHelper, orgViewId, entityRangeCache, userTemplatePermDetails);
                if (!b) continue;
                flag = true;
                break;
            }
            if (flag) continue;
            result.add(entityId);
        }
        return result;
    }

    public Map<Long, Set<Long>> getCurrentUserReportProcessMap(Long modelId, Long periodId, Long dataTypeId, Long versionId, IModelCacheHelper modelCacheHelper, Long orgViewId, Long schemeId, Set<Long> entityIds, Set<Long> templateIds, Set<String> rptFilterStatus) {
        HashMap<Long, Set<Long>> result = new HashMap<Long, Set<Long>>(16);
        if (CollectionUtils.isEmpty(templateIds) || CollectionUtils.isEmpty(entityIds)) {
            return result;
        }
        Map<Long, Set<Map<String, Object>>> templateEntityRangeMap = this.getTemplateEntityPermHelper().getTemplateEntityRangeMap(schemeId);
        TemplateUserQueryResult userTemplatePermDetails = TemplatePermServiceHelper.getUserTemplatePermDetails((Long)modelId, (TemplateTypeEnum)TemplateTypeEnum.BUDGET, templateIds, entityIds, (Long)orgViewId);
        Map reportProcessMap = ReportProcessAggService.getInstance().getReportProcessMap(modelId, periodId, dataTypeId, versionId, entityIds, templateIds, rptFilterStatus);
        HashMap<String, Set<Long>> entityRangeCache = new HashMap<String, Set<Long>>(16);
        for (Long entityId : entityIds) {
            Set templateIdsFromRpt = (Set)reportProcessMap.get(entityId);
            if (CollectionUtils.isEmpty((Collection)templateIdsFromRpt)) continue;
            for (Long templateId : templateIdsFromRpt) {
                boolean b = this.canAddReportProcess(templateEntityRangeMap, templateId, entityId, modelCacheHelper, orgViewId, entityRangeCache, userTemplatePermDetails);
                if (!b) continue;
                Set longs = result.computeIfAbsent(entityId, t -> new HashSet(16));
                longs.add(templateId);
            }
        }
        return result;
    }

    public Map<Long, Set<ReportProcess>> getCurrentUserReportProcessListMap(Long modelId, Long periodId, Long dataTypeId, Long versionId, IModelCacheHelper modelCacheHelper, Long orgViewId, Long schemeId, Set<Long> entityIds, Set<Long> templateIds, Set<String> filterStatus) {
        LinkedHashMap<Long, Set<ReportProcess>> result = new LinkedHashMap<Long, Set<ReportProcess>>(16);
        if (CollectionUtils.isEmpty(templateIds) || CollectionUtils.isEmpty(entityIds)) {
            return result;
        }
        Map<Long, Set<Map<String, Object>>> templateEntityRangeMap = this.getTemplateEntityPermHelper().getTemplateEntityRangeMap(schemeId);
        TemplateUserQueryResult userTemplatePermDetails = TemplatePermServiceHelper.getUserTemplatePermDetails((Long)modelId, (TemplateTypeEnum)TemplateTypeEnum.BUDGET, templateIds, entityIds, (Long)orgViewId);
        Map reportProcessMap = ReportProcessAggService.getInstance().getReportProcessListMap(modelId, periodId, dataTypeId, versionId, entityIds, templateIds);
        HashMap<String, Set<Long>> entityRangeCache = new HashMap<String, Set<Long>>(16);
        for (Long entityId : entityIds) {
            List reportProcesses = (List)reportProcessMap.get(entityId);
            if (CollectionUtils.isEmpty((Collection)reportProcesses)) continue;
            ArrayList<Long> orderList = new ArrayList<Long>(templateIds);
            this.sortReportProcessByTemplate(orderList, reportProcesses);
            for (ReportProcess reportProcess : reportProcesses) {
                Long templateId = reportProcess.getTemplateId();
                boolean b = this.canAddReportProcess(templateEntityRangeMap, templateId, entityId, modelCacheHelper, orgViewId, entityRangeCache, userTemplatePermDetails);
                if (!b) continue;
                Set reportProcessesList = result.computeIfAbsent(entityId, t -> new LinkedHashSet(16));
                if (!filterStatus.contains(reportProcess.getStatus())) continue;
                reportProcessesList.add(reportProcess);
            }
        }
        return result;
    }

    public void sortReportProcessByTemplate(List<Long> orderList, List<ReportProcess> reportProcesses) {
        reportProcesses.sort((o1, o2) -> {
            int index1 = orderList.indexOf(o1.getTemplateId());
            int index2 = orderList.indexOf(o2.getTemplateId());
            if (index1 == -1) {
                index1 = Integer.MAX_VALUE;
            }
            if (index2 == -1) {
                index2 = Integer.MAX_VALUE;
            }
            return Integer.compare(index1, index2);
        });
    }
}

