/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.formplugin.reportscheme.helper;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.SqlBuilder;
import kd.bos.entity.tree.TreeNode;
import kd.bos.exception.KDBizException;
import kd.bos.form.IFormView;
import kd.bos.form.IPageCache;
import kd.bos.form.control.TreeView;
import kd.bos.mutex.DataMutex;
import kd.bos.mutex.impl.MutexFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.epm.eb.business.memberf7.NewF7Utils;
import kd.epm.eb.business.servicehelper.DimensionPropertyServiceHelper;
import kd.epm.eb.business.tree.CusPropertyTreeBuilder;
import kd.epm.eb.business.tree.DynamicTreeBuilder;
import kd.epm.eb.common.cache.IModelCacheHelper;
import kd.epm.eb.common.cache.ModelCacheContext;
import kd.epm.eb.common.enums.ShowTypeEnum;
import kd.epm.eb.common.enums.SysDimensionEnum;
import kd.epm.eb.common.member.f7.F7TreeUtils;
import kd.epm.eb.common.member.f7.MemberF7Parameter;
import kd.epm.eb.common.spread.util.GZIPUtils;
import kd.epm.eb.common.utils.BusinessModelServiceHelper;
import kd.epm.eb.common.utils.CollectionUtils;
import kd.epm.eb.common.utils.IDUtils;
import kd.epm.eb.common.utils.ObjectSerialUtil;
import kd.epm.eb.common.utils.QFBuilder;
import kd.epm.eb.common.utils.StringUtils;
import kd.epm.eb.common.utils.UserUtils;
import kd.epm.eb.formplugin.utils.TreeSearchUtil;
import kd.epm.eb.spread.template.BgTemplate;
import kd.epm.eb.spread.template.IBaseEntry;
import kd.epm.eb.spread.template.ITemplateModel;
import kd.epm.eb.spread.template.TemplateModelHelper;
import kd.epm.eb.spread.template.TemplateModelJSONUtil;
import kd.epm.eb.spread.template.TemplateMutexServiceHelper;
import kd.epm.eb.spread.utils.ReportVar.ReportVarUtil;
import kd.epm.eb.spread.utils.ReportVar.TemplateVarCommonUtil;
import org.jetbrains.annotations.NotNull;

public class ReportSchemeEditHelper {
    private static final String ENTITY_KEY = "eb_rptscheme";
    private static final String OPERATION_KEY = "alter";
    private static final String separation = "!!";
    private static final long LOCK_KEEP_TIME_MS = Long.parseLong(System.getProperty("mutex.maxkeeptime_h", "8")) * 60L * 60L * 1000L;

    public static void refreshOrgTree(ShowTypeEnum showType, Long modelId, TreeView treeView, IPageCache pageCache, String cacheKey, Long orgView, Long bizModel) {
        IModelCacheHelper modelCacheHelper = ModelCacheContext.getOrCreate((Long)modelId);
        MemberF7Parameter f7Parameter = NewF7Utils.multipleF7((Long)modelId, (Long)modelCacheHelper.getDimension(SysDimensionEnum.Entity.getNumber()).getId());
        f7Parameter.setVerifyPermission(true);
        QFilter qFilter = new QFilter("number", "not like", (Object)"%offsetentry");
        f7Parameter.setCustomFilters(qFilter.toSerializedString());
        f7Parameter.setShowDisableVisible(false);
        f7Parameter.setCanSelectRoot(false);
        f7Parameter.setShowType(showType);
        f7Parameter.setStepLoad(false);
        f7Parameter.setShowLeaf(true);
        f7Parameter.setBusModelId(bizModel);
        f7Parameter.setViewId(orgView);
        DynamicTreeBuilder dynamicTreeBuilder = DynamicTreeBuilder.get((MemberF7Parameter)f7Parameter);
        TreeNode treeNode = dynamicTreeBuilder.buildTree(treeView, pageCache, Collections.emptySet());
        treeNode.setDisabled(true);
        treeView.setRootVisible(false);
        String serializationOrg = SerializationUtils.toJsonString((Object)treeNode);
        pageCache.put(cacheKey, SerializationUtils.serializeToBase64((Object)GZIPUtils.compress((String)serializationOrg)));
    }

    public static void refreshOrgPropTree(ShowTypeEnum showType, Long modelId, TreeView treeView, IPageCache pageCache, String cacheKey, Long orgView) {
        IModelCacheHelper modelCacheHelper = ModelCacheContext.getOrCreate((Long)modelId);
        MemberF7Parameter f7Parameter = NewF7Utils.multipleF7((Long)modelId, (Long)modelCacheHelper.getDimension(SysDimensionEnum.Entity.getNumber()).getId());
        f7Parameter.setVerifyPermission(true);
        f7Parameter.setShowDisableVisible(false);
        f7Parameter.setShowCustomProperty(true);
        f7Parameter.setCanSelectRoot(false);
        f7Parameter.setShowType(showType);
        f7Parameter.setViewId(orgView);
        TreeNode propTreeNode = CusPropertyTreeBuilder.get((MemberF7Parameter)f7Parameter).buildTree(treeView, pageCache);
        List children = propTreeNode.getChildren();
        if (CollectionUtils.isNotEmpty((Collection)children)) {
            for (TreeNode child : children) {
                child.setDisabled(true);
                TreeNode node = propTreeNode.getTreeNode(child.getId());
                if (node == null || node.getChildren() == null || !node.getChildren().isEmpty()) continue;
                List<TreeNode> _children = ReportSchemeEditHelper.getChildrenNode(node, propTreeNode, showType);
                if (_children.isEmpty()) {
                    node.setChildren(null);
                    treeView.updateNode(node);
                    continue;
                }
                node.addChildren(_children);
                treeView.addNodes(_children);
            }
        } else {
            treeView.deleteAllNodes();
        }
        String serializationOrg = SerializationUtils.toJsonString((Object)propTreeNode);
        pageCache.put(cacheKey, SerializationUtils.serializeToBase64((Object)GZIPUtils.compress((String)serializationOrg)));
    }

    public static List<TreeNode> getChildrenNode(TreeNode parent, TreeNode root, ShowTypeEnum showType) {
        if (parent == null) {
            return null;
        }
        String propertyId = parent.getId();
        QFBuilder qfBuilder = new QFBuilder();
        List treeDatas = DimensionPropertyServiceHelper.getInstance().queryDimensionPropertyValue(IDUtils.toLong((Object)propertyId), "id,number,name", qfBuilder);
        if (treeDatas != null && !treeDatas.isEmpty()) {
            for (Map treeData : treeDatas) {
                treeData.put("parent.id", propertyId);
            }
            return ReportSchemeEditHelper.transTreeNodes(treeDatas, false, showType);
        }
        return Collections.emptyList();
    }

    public static List<TreeNode> transTreeNodes(@NotNull List<Map<String, Object>> nodeDatas, boolean hasProperty, ShowTypeEnum showType) {
        ArrayList<TreeNode> nodes = new ArrayList<TreeNode>(nodeDatas.size());
        for (Map<String, Object> nodeData : nodeDatas) {
            TreeNode node = ReportSchemeEditHelper.transNode(nodeData, hasProperty, showType);
            if (node == null) continue;
            nodes.add(node);
        }
        return nodes;
    }

    public static TreeNode transNode(@NotNull Map<String, Object> nodeData, boolean hasProperty, ShowTypeEnum showType) {
        TreeNode node = new TreeNode();
        node.setId(IDUtils.toString((Object)nodeData.get("id")));
        node.setParentid(IDUtils.toString((Object)nodeData.get("parent.id")));
        node.setText(F7TreeUtils.nodeShowType(nodeData, (String[])F7TreeUtils.getShowType((ShowTypeEnum)showType)));
        return node;
    }

    public static TreeNode getAllNode(ShowTypeEnum showType, List<TreeNode> selectNode, IPageCache pageCache, String cacheKey, Long bizRangeId, Long modelId, TreeView treeView, String typeCacheKey) {
        TreeNode rootNode = null;
        if (bizRangeId == null || bizRangeId == 0L) {
            return null;
        }
        String checkNodeStr = pageCache.get("cache_selected_template");
        HashSet<String> checkedNodeIds = new HashSet<String>(16);
        if (StringUtils.isNotEmpty((String)checkNodeStr)) {
            checkedNodeIds = new HashSet((Collection)SerializationUtils.deSerializeFromBase64((String)checkNodeStr));
        }
        HashMap<String, String> templateTypeMap = new HashMap<String, String>(16);
        TreeNode budgetNodes = ReportSchemeEditHelper.getAllBudgetTemplateNode(bizRangeId, showType, checkedNodeIds, selectNode, modelId, pageCache, templateTypeMap);
        TreeNode applyNodes = ReportSchemeEditHelper.getAllApplyTemplateNode(bizRangeId, showType, checkedNodeIds, selectNode, modelId, templateTypeMap);
        if (templateTypeMap.size() > 0) {
            pageCache.put(typeCacheKey, ObjectSerialUtil.toByteSerialized(templateTypeMap));
        }
        ArrayList<TreeNode> children = new ArrayList<TreeNode>(16);
        if (budgetNodes != null) {
            budgetNodes.setText(ResManager.loadKDString((String)"\u9884\u7b97\u6a21\u677f", (String)"ReportSchemeEditPlugin_24", (String)"epm-eb-formplugin", (Object[])new Object[0]));
            children.add(budgetNodes);
        }
        if (applyNodes != null) {
            applyNodes.setText(ResManager.loadKDString((String)"\u7533\u62a5\u6a21\u677f", (String)"ReportSchemeEditPlugin_25", (String)"epm-eb-formplugin", (Object[])new Object[0]));
            children.add(applyNodes);
        }
        if (budgetNodes != null || applyNodes != null) {
            rootNode = new TreeNode("", "", ResManager.loadKDString((String)"\u6a21\u677f\u5206\u7c7b", (String)"ReportSchemeEditPlugin_26", (String)"epm-eb-formplugin", (Object[])new Object[0]));
            HashMap<String, String> dataMap = new HashMap<String, String>(16);
            dataMap.put("type", "template");
            dataMap.put("flag", "0");
            rootNode.setData(dataMap);
            rootNode.setChildren(children);
        }
        String serializationtemplate = SerializationUtils.toJsonString(rootNode);
        pageCache.put(cacheKey, SerializationUtils.serializeToBase64((Object)GZIPUtils.compress((String)serializationtemplate)));
        if (rootNode != null) {
            ReportSchemeEditHelper.deleteNoTempCatalog(rootNode);
            rootNode.setParentid("");
            treeView.updateNode(rootNode);
            treeView.addNode(rootNode);
            treeView.expand(rootNode.getId());
            if (CollectionUtils.isNotEmpty(selectNode)) {
                treeView.checkNodes(selectNode);
            }
        }
        TreeSearchUtil.clearSearchPageCache(pageCache, new TreeSearchUtil.TreeSearchParam("templatetree", cacheKey));
        return rootNode;
    }

    public static TreeNode getAllBudgetTemplateNode(Long bizRangeId, ShowTypeEnum showType, Set<String> checkedIdSet, List<TreeNode> selectedNode, Long modelId, IPageCache pageCache, Map<String, String> templateTypeMap) {
        if (bizRangeId == null || bizRangeId == 0L) {
            return null;
        }
        List datasetIds = BusinessModelServiceHelper.getInstance().queryDataSetIds(bizRangeId);
        QFilter modelQf = new QFilter("model", "=", (Object)modelId);
        QFilter tempStatusQf = new QFilter("templatestatus", "!=", (Object)"A");
        QFilter datasetQf = new QFilter("dataset", "in", (Object)datasetIds);
        HashMap<String, ArrayList<TreeNode>> map = new HashMap<String, ArrayList<TreeNode>>(16);
        HashSet<String> templateIds = new HashSet<String>(16);
        try (DataSet templateDataSet = QueryServiceHelper.queryDataSet((String)"queryebtemplate", (String)"eb_templateentity", (String)"id,name,number,templatecatalog,templatetype,templatestatus", (QFilter[])new QFilter[]{modelQf, tempStatusQf, datasetQf}, (String)"number asc");){
            while (templateDataSet.hasNext()) {
                Row next = templateDataSet.next();
                TreeNode treeNode = new TreeNode();
                String id = next.getString("id");
                treeNode.setId(id);
                templateTypeMap.put(id, "0");
                templateIds.add(next.getString("id"));
                treeNode.setLongNumber(next.getString("number"));
                if ("2".equals(showType.getValue())) {
                    treeNode.setText(next.getString("name"));
                } else if ("3".equals(showType.getValue())) {
                    treeNode.setText(next.getString("number") + " " + next.getString("name"));
                } else {
                    treeNode.setText(next.getString("number"));
                }
                HashMap<String, String> dataMap = new HashMap<String, String>(16);
                dataMap.put("type", "template");
                dataMap.put("flag", "1");
                dataMap.put("templatetype", "0");
                treeNode.setData(dataMap);
                ArrayList<TreeNode> treeNodes = (ArrayList<TreeNode>)map.get(next.getString("templatecatalog"));
                treeNode.setParentid(next.getString("templatecatalog"));
                if (treeNodes == null) {
                    treeNodes = new ArrayList<TreeNode>(16);
                    map.put(next.getString("templatecatalog"), treeNodes);
                }
                treeNodes.add(treeNode);
                if (!CollectionUtils.isNotEmpty(checkedIdSet) || !checkedIdSet.contains(treeNode.getId())) continue;
                selectedNode.add(treeNode);
            }
        }
        pageCache.put("cacheTmpIds", SerializationUtils.serializeToBase64(templateIds));
        TreeNode rootNode = null;
        HashMap<String, TreeNode> catalogMap = new HashMap<String, TreeNode>(16);
        try (DataSet catalogDataSet = QueryServiceHelper.queryDataSet((String)"querytemplatecatalog", (String)"eb_templatecatalog", (String)"id,name,number,parent", (QFilter[])modelQf.toArray(), (String)"level,sequence");){
            while (catalogDataSet.hasNext()) {
                Row next = catalogDataSet.next();
                TreeNode treeNode = new TreeNode();
                treeNode.setId(next.getString("id"));
                treeNode.setLongNumber(next.getString("number"));
                treeNode.setText(next.getString("name"));
                HashMap<String, String> dataMap = new HashMap<String, String>(16);
                dataMap.put("type", "template");
                dataMap.put("flag", "0");
                dataMap.put("templatetype", "0");
                treeNode.setData(dataMap);
                catalogMap.put(next.getString("id"), treeNode);
                String parent = next.getString("parent");
                if (StringUtils.isEmpty((String)parent) || "0".equals(parent)) {
                    rootNode = treeNode;
                } else {
                    treeNode.setParentid(parent);
                    TreeNode treeNode1 = (TreeNode)catalogMap.get(parent);
                    if (treeNode1 != null) {
                        ArrayList<TreeNode> children = treeNode1.getChildren();
                        if (children == null) {
                            children = new ArrayList<TreeNode>(16);
                            treeNode1.setChildren(children);
                        }
                        children.add(treeNode);
                    }
                }
                if (!map.containsKey(next.getString("id"))) continue;
                List treeNodes = (List)map.get(next.getString("id"));
                treeNode.setChildren(treeNodes);
            }
        }
        return rootNode;
    }

    public static TreeNode getAllApplyTemplateNode(Long bizRangeId, ShowTypeEnum showType, Set<String> checkedIdSet, List<TreeNode> selectedNode, Long model, Map<String, String> templateTypeMap) {
        List datasetIds = BusinessModelServiceHelper.getInstance().queryDataSetIds(bizRangeId);
        QFilter modelQf = new QFilter("model", "=", (Object)model);
        QFilter tempStatusQf = new QFilter("templatestatus", "=", (Object)"1");
        QFilter datasetQf = new QFilter("dataset", "in", (Object)datasetIds);
        HashMap<String, ArrayList<TreeNode>> map = new HashMap<String, ArrayList<TreeNode>>(16);
        try (DataSet templateDataSet = QueryServiceHelper.queryDataSet((String)"queryApplyTemplate", (String)"eb_applytemplate", (String)"id,name,number,templatetype as templatecatalog,templatestatus", (QFilter[])new QFilter[]{modelQf, tempStatusQf, datasetQf}, (String)"number");){
            while (templateDataSet.hasNext()) {
                Row next = templateDataSet.next();
                TreeNode treeNode = new TreeNode();
                String id = next.getString("id");
                treeNode.setId(id);
                templateTypeMap.put(id, "1");
                treeNode.setLongNumber(next.getString("number"));
                if ("2".equals(showType.getValue())) {
                    treeNode.setText(next.getString("name"));
                } else if ("3".equals(showType.getValue())) {
                    treeNode.setText(next.getString("number") + " " + next.getString("name"));
                } else {
                    treeNode.setText(next.getString("number"));
                }
                HashMap<String, String> dataMap = new HashMap<String, String>(16);
                dataMap.put("type", "template");
                dataMap.put("flag", "1");
                dataMap.put("templatetype", "1");
                treeNode.setData(dataMap);
                ArrayList<TreeNode> treeNodes = (ArrayList<TreeNode>)map.get(next.getString("templatecatalog"));
                treeNode.setParentid(next.getString("templatecatalog"));
                if (treeNodes == null) {
                    treeNodes = new ArrayList<TreeNode>(16);
                    map.put(next.getString("templatecatalog"), treeNodes);
                }
                treeNodes.add(treeNode);
                if (!CollectionUtils.isNotEmpty(checkedIdSet) || !checkedIdSet.contains(treeNode.getId())) continue;
                selectedNode.add(treeNode);
            }
        }
        TreeNode rootNode = null;
        HashMap<String, TreeNode> catalogMap = new HashMap<String, TreeNode>(16);
        try (DataSet catalogDataSet = QueryServiceHelper.queryDataSet((String)"queryApplyTemplateCatalog", (String)"eb_applytemplatelog", (String)"id,name,number,parent", (QFilter[])modelQf.toArray(), (String)"level,sequence");){
            while (catalogDataSet.hasNext()) {
                Row next = catalogDataSet.next();
                TreeNode treeNode = new TreeNode();
                treeNode.setId(next.getString("id"));
                treeNode.setLongNumber(next.getString("number"));
                treeNode.setText(next.getString("name"));
                HashMap<String, String> dataMap = new HashMap<String, String>(16);
                dataMap.put("type", "template");
                dataMap.put("flag", "0");
                dataMap.put("templatetype", "1");
                treeNode.setData(dataMap);
                catalogMap.put(next.getString("id"), treeNode);
                String parent = next.getString("parent");
                if (StringUtils.isEmpty((String)parent) || "0".equals(parent)) {
                    rootNode = treeNode;
                } else {
                    treeNode.setParentid(parent);
                    TreeNode treeNode1 = (TreeNode)catalogMap.get(parent);
                    if (treeNode1 != null) {
                        ArrayList<TreeNode> children = treeNode1.getChildren();
                        if (children == null) {
                            children = new ArrayList<TreeNode>(16);
                            treeNode1.setChildren(children);
                        }
                        children.add(treeNode);
                    }
                }
                if (!map.containsKey(next.getString("id"))) continue;
                List treeNodes = (List)map.get(next.getString("id"));
                treeNode.setChildren(treeNodes);
            }
        }
        return rootNode;
    }

    public static void deleteNoTempCatalog(TreeNode root) {
        ArrayList<TreeNode> list = new ArrayList<TreeNode>(16);
        ReportSchemeEditHelper.getNeedDeleteList(root, list);
        if (list.size() == 0) {
            return;
        }
        for (TreeNode treeNode : list) {
            String nodeId = treeNode.getId();
            root.getTreeNode(nodeId, 20);
            root.deleteChildNode(nodeId);
        }
    }

    public static void getNeedDeleteList(TreeNode root, List<TreeNode> list) {
        if (root == null || root.getChildren() == null || root.getChildren().size() == 0) {
            return;
        }
        List childs = root.getChildren();
        for (TreeNode child : childs) {
            ReportSchemeEditHelper.getNeedDeleteList(child, list);
            Map dataMap = (Map)child.getData();
            if ("1".equals((String)dataMap.get("flag"))) {
                Map rootMap = (Map)root.getData();
                rootMap.put("flag", "1");
                continue;
            }
            list.add(child);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static boolean lock(Long schemeId, Long model) {
        try (DataMutex dataMutex = MutexFactory.createDataMutex();){
            boolean bl = dataMutex.require(String.valueOf(schemeId), String.valueOf(model), ENTITY_KEY, OPERATION_KEY, true);
            return bl;
        }
        catch (IOException ex) {
            throw new RuntimeException("IOException when closing data mutex!", ex);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static boolean unlock(Long schemeId, Long model) {
        Map<String, String> lockinfo = ReportSchemeEditHelper.getLockInfo(schemeId, model);
        String userid = lockinfo.get("userid");
        if (userid == null) return false;
        if (!userid.equals(UserUtils.getUserId().toString())) return false;
        try (DataMutex dataMutex = MutexFactory.createDataMutex();){
            boolean bl = dataMutex.release(String.valueOf(schemeId), ENTITY_KEY, OPERATION_KEY);
            return bl;
        }
        catch (IOException ex) {
            throw new RuntimeException("IOException when closing data mutex!", ex);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static Map<String, String> getLockInfo(Long schemeId, Long model) {
        try (DataMutex dataMutex = MutexFactory.createDataMutex();){
            Map lockinfo = dataMutex.getLockInfo(String.valueOf(schemeId), String.valueOf(model), ENTITY_KEY);
            Map map = lockinfo = lockinfo == null ? Collections.emptyMap() : lockinfo;
            return map;
        }
        catch (IOException ex) {
            throw new RuntimeException("IOException when closing data mutex!", ex);
        }
    }

    public static void checkIsLock(Long schemeId, Long model) {
        Map<String, String> lockinfo = ReportSchemeEditHelper.getLockInfo(schemeId, model);
        if (lockinfo == null || lockinfo.size() == 0) {
            return;
        }
        String lockTime = lockinfo.get("lockedTime");
        if (System.currentTimeMillis() - Long.parseLong(lockTime) > LOCK_KEEP_TIME_MS) {
            ReportSchemeEditHelper.unlock(schemeId, model);
        } else {
            ReportSchemeEditHelper.showTips(lockinfo, schemeId);
        }
    }

    public static void checkIsLockInPage(Long schemeId, Long model, IFormView view) {
        Map<String, String> lockinfo = ReportSchemeEditHelper.getLockInfo(schemeId, model);
        if (lockinfo == null || lockinfo.size() == 0) {
            return;
        }
        String lockTime = lockinfo.get("lockedTime");
        if (System.currentTimeMillis() - Long.parseLong(lockTime) > LOCK_KEEP_TIME_MS) {
            ReportSchemeEditHelper.unlock(schemeId, model);
        } else {
            if (lockinfo == null || lockinfo.size() == 0) {
                return;
            }
            String username = ReportSchemeEditHelper.getOrgNameById(IDUtils.toLong((Object)lockinfo.get("userid")));
            String msg = username == null ? ResManager.loadResFormat((String)"\u7528\u6237id\u4e3a%1\u6b63\u5728\u7f16\u8f91\uff0c\u53ea\u80fd\u67e5\u770b\u3002", (String)"ReportSchemeEditPlugin_44", (String)"epm-eb-formplugin", (Object[])new Object[]{lockinfo.get("userid")}) : ResManager.loadResFormat((String)"\u7528\u6237%1\u6b63\u5728\u7f16\u8f91\uff0c\u53ea\u80fd\u67e5\u770b\u3002", (String)"ReportSchemeEditPlugin_43", (String)"epm-eb-formplugin", (Object[])new Object[]{username});
            view.setEnable(Boolean.valueOf(false), new String[]{"btn_save", "btn_allocate", "btn_unallocate", "btn_assign", "btn_templatesort", "btn_adddel", "btn_canceldel"});
            view.showTipNotification(msg);
            view.getPageCache().put("checkIsLockInPage", "false");
        }
    }

    public static String getOrgNameById(Long orgid) {
        QFilter filter = new QFilter("id", "=", (Object)orgid);
        String username = null;
        try (DataSet dataSet = QueryServiceHelper.queryDataSet((String)TemplateMutexServiceHelper.class.getName(), (String)"bos_user", (String)"name", (QFilter[])new QFilter[]{filter}, null);){
            while (dataSet.hasNext()) {
                username = dataSet.next().getString("name");
            }
        }
        return username;
    }

    public static void showTips(Map<String, String> lockinfo, String schemeNum) {
        if (lockinfo == null || lockinfo.size() == 0) {
            return;
        }
        String username = ReportSchemeEditHelper.getOrgNameById(IDUtils.toLong((Object)lockinfo.get("userid")));
        String msg = username == null ? ResManager.loadResFormat((String)"\u7f16\u7801\u4e3a%1\u7684\u65b9\u6848\u6b63\u5728\u88ab\u7528\u6237id\u4e3a%2\u7684\u7528\u6237\u7f16\u8f91\uff0c\u8bf7\u5148\u8010\u5fc3\u7b49\u5f85\uff0c\u6025\u7528\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u5230\u7cfb\u7edf\u7ba1\u7406-\u7f51\u7edc\u4e92\u65a5\u4e2d\u89e3\u9501\u3002", (String)"ReportSchemeEditPlugin_41", (String)"epm-eb-formplugin", (Object[])new Object[]{schemeNum, lockinfo.get("userid")}) : ResManager.loadResFormat((String)"\u7f16\u7801\u4e3a%1\u7684\u65b9\u6848\u6b63\u5728\u88ab\u7528\u6237%2\u4f7f\u7528\uff0c\u8bf7\u5148\u8010\u5fc3\u7b49\u5f85\uff0c\u6025\u7528\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u5230\u7cfb\u7edf\u7ba1\u7406-\u7f51\u7edc\u4e92\u65a5\u4e2d\u89e3\u9501\u3002", (String)"ReportSchemeEditPlugin_42", (String)"epm-eb-formplugin", (Object[])new Object[]{schemeNum, username});
        throw new KDBizException(msg);
    }

    public static void showTips(Map<String, String> lockinfo, Long schemeId) {
        DynamicObject dynamicObject = BusinessDataServiceHelper.loadSingle((Object)schemeId, (String)ENTITY_KEY, (String)"id,number");
        if (dynamicObject != null) {
            ReportSchemeEditHelper.showTips(lockinfo, dynamicObject.getString("number"));
        }
    }

    public static boolean checkAssignVersionAndDataType(Long modelId, Long schemeId, Long versionId, Long dataTypeId, String versionName, String dataTypeName, Map<Long, DynamicObject> templateMap, Map<String, Map<String, String>> currentVarValues, Collection<String> yearValidMsg, List<String> errorMsg) {
        if (templateMap == null) {
            templateMap = new HashMap<Long, DynamicObject>(16);
        }
        HashMap<Long, ITemplateModel> templateModelMap = new HashMap<Long, ITemplateModel>(16);
        SqlBuilder sqlBuilder = new SqlBuilder();
        sqlBuilder.append("select ftemplateid from t_eb_templateorg where ftemplatetype = '0' and fschemeid = ? ", new Object[]{schemeId});
        sqlBuilder.append(" group by ftemplateid", new Object[0]);
        try (DataSet ds = DB.queryDataSet((String)"reportSchemeAssignCheck", (DBRoute)DBRoute.of((String)"epm"), (SqlBuilder)sqlBuilder);){
            if (ds != null) {
                while (ds.hasNext()) {
                    Set memberIdSet;
                    Set pageDataTypeMemberSet;
                    Set memberIdSet2;
                    Set pageVersionMemberSet;
                    Row row = ds.next();
                    long templateId = row.getLong("ftemplateid");
                    DynamicObject templateObj = templateMap.computeIfAbsent(templateId, t -> QueryServiceHelper.queryOne((String)"eb_templateentity", (String)"id,number,name,model.id,dataset.id, varbaseforeb, data", (QFilter[])new QFilter[]{new QFilter("id", "=", (Object)templateId)}));
                    String templateData = templateObj.getString("data");
                    String templateName = templateObj.getString("name");
                    boolean isExistVar = "1".equals(templateObj.getString("varbaseforeb"));
                    ITemplateModel templateModel = (ITemplateModel)templateModelMap.get(templateId);
                    if (templateModel != null || (templateModel = TemplateModelJSONUtil.parseITemplateModel((String)templateData)) == null) continue;
                    templateModelMap.put(templateId, templateModel);
                    BgTemplate bgTemplate = templateModel.getTemplateBaseInfo();
                    if (bgTemplate == null) {
                        bgTemplate = new BgTemplate();
                        templateModel.setTemplateBaseInfo(bgTemplate);
                    }
                    bgTemplate.setId(Long.valueOf(templateObj.getLong("id")));
                    bgTemplate.setModelID(Long.valueOf(templateObj.getLong("model.id")));
                    bgTemplate.setDatasetID(Long.valueOf(templateObj.getLong("dataset.id")));
                    bgTemplate.setNumber(templateObj.getString("number"));
                    bgTemplate.setName(templateObj.getString("name"));
                    Map<String, String> yearVarValues = currentVarValues.get(SysDimensionEnum.BudgetPeriod.getNumber());
                    if (yearVarValues != null && yearVarValues.size() > 0 && isExistVar) {
                        HashMap templateVarInfo = new HashMap(16);
                        TemplateVarCommonUtil.getVarDimFromTemplateData((ITemplateModel)templateModel, templateVarInfo, (boolean)false);
                        List formulaVar = ReportVarUtil.checkYearVarHasFomula(templateVarInfo);
                        if (org.apache.commons.collections4.CollectionUtils.isNotEmpty((Collection)formulaVar)) {
                            yearValidMsg.addAll(ReportVarUtil.getNoValiadPeriodVar((Long)modelId, (String)templateName, (List)formulaVar, yearVarValues));
                        }
                    }
                    if (CollectionUtils.isNotEmpty((Collection)(pageVersionMemberSet = TemplateModelHelper.getPageMembersFromEBTemplate((Long)modelId, (Long)templateId, (ITemplateModel)templateModel, (String)SysDimensionEnum.Version.getNumber(), currentVarValues))) && !(memberIdSet2 = pageVersionMemberSet.stream().map(IBaseEntry::getId).collect(Collectors.toSet())).contains(versionId)) {
                        errorMsg.add(ResManager.loadResFormat((String)"\u7248\u672c\uff1a%1\uff0c\u4e0d\u5728\u6a21\u677f%2\u8303\u56f4\u5185\u3002", (String)"ReportSchemeAssignPlugin_12", (String)"epm-eb-formplugin", (Object[])new Object[]{versionName, templateName}));
                    }
                    if (!CollectionUtils.isNotEmpty((Collection)(pageDataTypeMemberSet = TemplateModelHelper.getPageMembersFromEBTemplate((Long)modelId, (Long)templateId, (ITemplateModel)templateModel, (String)SysDimensionEnum.DataType.getNumber(), currentVarValues))) || (memberIdSet = pageDataTypeMemberSet.stream().map(IBaseEntry::getId).collect(Collectors.toSet())).contains(dataTypeId)) continue;
                    errorMsg.add(ResManager.loadResFormat((String)"\u6570\u636e\u7c7b\u578b\uff1a%1\uff0c\u4e0d\u5728\u6a21\u677f\"%2\"\u8303\u56f4\u5185\u3002", (String)"ReportSchemeAssignPlugin_13", (String)"epm-eb-formplugin", (Object[])new Object[]{dataTypeName, templateName}));
                }
            }
        }
        return true;
    }
}

