/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.formplugin.reportscheme.helper;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.SqlBuilder;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.epm.eb.common.cache.IModelCacheHelper;
import kd.epm.eb.common.cache.impl.Member;
import kd.epm.eb.common.enums.RangeEnum;
import kd.epm.eb.common.enums.SysDimensionEnum;
import kd.epm.eb.common.reportprocess.entity.dto.TemplateEntityDto;
import kd.epm.eb.common.reportprocess.helper.SchemeRecordDeleteEntityHelper;
import kd.epm.eb.common.utils.CollectionUtils;
import kd.epm.eb.common.utils.IDUtils;

public class TemplateEntityPermHelper {
    private static final Log log = LogFactory.getLog(TemplateEntityPermHelper.class);
    private Map<Long, Set<Map<String, Object>>> templateEntityRange;

    private SqlBuilder getFilterSchemeIdSql(Long schemeId) {
        SqlBuilder sqlBuilder = new SqlBuilder();
        Object[] params = new Object[]{schemeId};
        sqlBuilder.append("select ftemplateid,forgid,forgrange from t_eb_templateorg where fschemeid = ? ", params);
        return sqlBuilder;
    }

    private List<TemplateEntityDto> getTemplateEntityList(SqlBuilder sqlBuilder) {
        ArrayList<TemplateEntityDto> result = new ArrayList<TemplateEntityDto>(16);
        try (DataSet dataSet = DB.queryDataSet((String)"queryTemplateOrgList", (DBRoute)DBRoute.of((String)"epm"), (SqlBuilder)sqlBuilder);){
            while (dataSet != null && dataSet.hasNext()) {
                Row next = dataSet.next();
                Long templateId = next.getLong("ftemplateid");
                Long orgId = next.getLong("forgid");
                Integer orgrange = next.getInteger("forgrange");
                if (IDUtils.isEmptyLong((Long)templateId).booleanValue() || IDUtils.isEmptyLong((Long)orgId).booleanValue()) continue;
                TemplateEntityDto reportPreparationTemplateEntityDto = new TemplateEntityDto(templateId, orgId, orgrange);
                result.add(reportPreparationTemplateEntityDto);
            }
        }
        return result;
    }

    public Map<Long, Set<Map<String, Object>>> getTemplateEntityRangeMap(Long schemeId) {
        if (this.templateEntityRange != null) {
            return this.templateEntityRange;
        }
        HashMap<Long, Set> result = new HashMap<Long, Set>(16);
        long l = System.currentTimeMillis();
        QFilter qFilter = new QFilter("scheme", "=", (Object)schemeId);
        DynamicObjectCollection query = QueryServiceHelper.query((String)"eb_templateorg", (String)"id,org.id, orgrange, template.id", (QFilter[])qFilter.toArray());
        List recordIdList = query.stream().map(x -> x.getLong("id")).collect(Collectors.toList());
        Map recordDeleteEntity = SchemeRecordDeleteEntityHelper.queryDeleteEntityByRecordId(recordIdList);
        log.info("getTemplateEntityRangeMap recordSet:{}, time:{}", (Object)query.size(), (Object)(System.currentTimeMillis() - l));
        for (DynamicObject object : query) {
            Long template = object.getLong("template.id");
            Long org = object.getLong("org.id");
            String orgrange = object.getString("orgrange");
            Set maps = result.computeIfAbsent(template, t -> new HashSet(16));
            HashMap<String, Object> map = new HashMap<String, Object>(2);
            map.put("range", org + "#" + orgrange);
            Set deleteentity = (Set)recordDeleteEntity.get(object.getLong("id"));
            if (CollectionUtils.isNotEmpty((Collection)deleteentity)) {
                map.put("deleteentity", deleteentity);
                map.put("record", object.getLong("id"));
            }
            maps.add(map);
        }
        this.templateEntityRange = new HashMap<Long, Set<Map<String, Object>>>(result);
        return this.templateEntityRange;
    }

    public Set<Long> getEntityPermInScheme(Long schemeId, IModelCacheHelper modelCacheHelper, Long entityViewId) {
        if (IDUtils.isEmptyLong((Long)schemeId).booleanValue() || modelCacheHelper == null) {
            return Collections.emptySet();
        }
        LinkedHashSet<Long> result = new LinkedHashSet<Long>();
        SqlBuilder sqlBuilder = new SqlBuilder();
        sqlBuilder.append("select forgid, forgrange from t_eb_templateorg where fschemeid = ? ", new Object[]{schemeId});
        sqlBuilder.append(" group by forgid, forgrange", new Object[0]);
        try (DataSet dataSet = DB.queryDataSet((String)"getEntityPermInScheme", (DBRoute)DBRoute.of((String)"epm"), (SqlBuilder)sqlBuilder);){
            while (dataSet != null && dataSet.hasNext()) {
                Row next = dataSet.next();
                Long forgid = next.getLong("forgid");
                Integer forgrange = next.getInteger("forgrange");
                result.addAll(this.parseEntityRange(modelCacheHelper, entityViewId, forgid, forgrange));
            }
        }
        return result;
    }

    public Set<Long> getTemplatePermInScheme(Long schemeId) {
        LinkedHashSet<Long> result = new LinkedHashSet<Long>(16);
        SqlBuilder sqlBuilder = new SqlBuilder();
        sqlBuilder.append("select ftemplateid from t_eb_templateorg where fschemeid = ? ", new Object[]{schemeId});
        sqlBuilder.append(" group by ftemplateid", new Object[0]);
        try (DataSet dataSet = DB.queryDataSet((String)"getEntityPermInScheme", (DBRoute)DBRoute.of((String)"epm"), (SqlBuilder)sqlBuilder);){
            while (dataSet != null && dataSet.hasNext()) {
                Row next = dataSet.next();
                Long ftemplateid = next.getLong("ftemplateid");
                result.add(ftemplateid);
            }
        }
        return result;
    }

    public Set<Long> parseEntityRange(IModelCacheHelper modelCacheHelper, Long entityViewId, Long entityId, Integer range) {
        HashSet<Long> result = new HashSet<Long>(16);
        if (RangeEnum.ONLY.getIndex() == range.intValue()) {
            result.add(entityId);
            return result;
        }
        Member member = modelCacheHelper.getMember(SysDimensionEnum.Entity.getNumber(), entityViewId, entityId);
        if (member == null) {
            return result;
        }
        List member1 = modelCacheHelper.getMember(SysDimensionEnum.Entity.getNumber(), entityViewId, member.getNumber(), range.intValue());
        for (Member member2 : member1) {
            if (member2.getNumber().endsWith("offsetentry")) continue;
            result.add(member2.getId());
        }
        return result;
    }
}

