/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.formplugin.reportscheme.v2;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collection;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import kd.bos.entity.property.ComboProp;
import kd.bos.form.IPageCache;
import kd.bos.form.control.Control;
import kd.bos.form.field.ComboEdit;
import kd.bos.form.field.ComboItem;
import kd.epm.eb.common.ebcommon.common.enums.MemberDisplayTypeEnum;
import kd.epm.eb.common.enums.BgTemplateTypeEnum;
import kd.epm.eb.common.member.f7.MemberParamsUtils;
import kd.epm.eb.common.utils.IDUtils;
import kd.epm.eb.formplugin.AbstractFormPlugin;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;

public class ReportShowSettingPlugin
extends AbstractFormPlugin {
    private static final String BTN_OK = "btn_ok";
    private static final String PANEL_EMPTY_LINE = "emptylinepanel";
    private static final String COMBO_UNIT = "combo_unit";
    private static final String COMBO_DIM_MEM = "combo_dimmem";
    private static final String COMBO_EMPTY_LINE = "combo_emptyline";

    @Override
    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addClickListeners(new String[]{BTN_OK});
    }

    public void afterCreateNewData(EventObject e) {
        String cacheEmptyLine;
        String cacheUnit;
        super.afterCreateNewData(e);
        this.getView().setVisible(Boolean.valueOf(this.isDynamicReport()), new String[]{PANEL_EMPTY_LINE});
        long reportProcessId = this.getReportProcessId();
        IPageCache parentPageCache = this.getView().getParentView().getPageCache();
        ArrayList longNameNumKeys = Lists.newArrayList((Object[])new String[]{"btn_showlongnumber", "btn_showlongname", "btn_showlongnamenum"});
        ComboEdit comboEdit = (ComboEdit)this.getControl(COMBO_DIM_MEM);
        List longNameNumDisplayParams = MemberParamsUtils.getLongNameNumDisplayParamsByCache((long)((Long)this.getCustomFormParam("model")));
        if (CollectionUtils.isEmpty((Collection)longNameNumDisplayParams)) {
            List comboItems = ((ComboProp)comboEdit.getProperty()).getComboItems();
            List itemList = comboItems.stream().map(item -> {
                if (longNameNumKeys.contains(item.getValue())) {
                    return null;
                }
                return new ComboItem(item.getName(), item.getValue());
            }).filter(Objects::nonNull).collect(Collectors.toList());
            comboEdit.setComboItems(itemList);
        }
        if (StringUtils.isNotBlank((CharSequence)(cacheUnit = parentPageCache.get(COMBO_UNIT + reportProcessId)))) {
            this.getModel().setValue(COMBO_UNIT, (Object)cacheUnit);
        } else {
            String defaultUnit = (String)this.getFormCustomParam("defaultUnit");
            this.getModel().setValue(COMBO_UNIT, (Object)("btn_unit" + defaultUnit));
        }
        Integer showType = (Integer)this.getFormCustomParam("dimShowType");
        if (showType != null) {
            try {
                MemberDisplayTypeEnum memberDisplayTypeByIndex = MemberDisplayTypeEnum.getMemberDisplayTypeByIndex((int)showType);
                String btnKey = memberDisplayTypeByIndex.getBtnKey();
                if (CollectionUtils.isNotEmpty((Collection)longNameNumDisplayParams) || CollectionUtils.isEmpty((Collection)longNameNumDisplayParams) && !longNameNumKeys.contains(btnKey)) {
                    this.getModel().setValue(COMBO_DIM_MEM, (Object)btnKey);
                }
            }
            catch (Exception memberDisplayTypeByIndex) {
                // empty catch block
            }
        }
        if (StringUtils.isNotBlank((CharSequence)(cacheEmptyLine = parentPageCache.get(COMBO_EMPTY_LINE + reportProcessId)))) {
            this.getModel().setValue(COMBO_EMPTY_LINE, (Object)cacheEmptyLine);
        }
    }

    private long getReportProcessId() {
        return IDUtils.toLong(this.getFormCustomParam("reportProcessId"));
    }

    private boolean isDynamicReport() {
        String reportType = (String)this.getFormCustomParam("reportType");
        return BgTemplateTypeEnum.DYNAMIC.getNumber().equals(reportType);
    }

    public void click(EventObject evt) {
        String key = ((Control)evt.getSource()).getKey();
        if (BTN_OK.equals(key)) {
            long reportProcessId = this.getReportProcessId();
            IPageCache parentPageCache = this.getView().getParentView().getPageCache();
            String unit = this.getModel().getValue(COMBO_UNIT).toString();
            parentPageCache.put(COMBO_UNIT + reportProcessId, unit);
            String dimMem = this.getModel().getValue(COMBO_DIM_MEM).toString();
            HashMap<String, String> map = new HashMap<String, String>(3);
            map.put("unit", unit);
            map.put("dimShow", dimMem);
            if (this.isDynamicReport()) {
                String emptyLine = this.getModel().getValue(COMBO_EMPTY_LINE).toString();
                parentPageCache.put(COMBO_EMPTY_LINE + reportProcessId, emptyLine);
                map.put("emptyLine", emptyLine);
            }
            this.getView().returnDataToParent(map);
            this.getView().close();
        }
    }
}

