/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.formplugin.reportscheme.v2;

import java.util.ArrayList;
import java.util.Collection;
import java.util.EventObject;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.entity.datamodel.ListSelectedRow;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.tree.TreeNode;
import kd.bos.form.control.Control;
import kd.bos.form.control.Label;
import kd.bos.form.control.Search;
import kd.bos.form.control.TreeView;
import kd.bos.form.control.events.SearchEnterEvent;
import kd.bos.form.control.events.SearchEnterListener;
import kd.bos.form.control.events.TreeNodeClickListener;
import kd.bos.form.control.events.TreeNodeEvent;
import kd.bos.form.events.SetFilterEvent;
import kd.bos.list.BillList;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.epm.eb.common.cache.IModelCacheHelper;
import kd.epm.eb.common.cache.ModelCacheContext;
import kd.epm.eb.common.cache.impl.BaseCache;
import kd.epm.eb.common.cache.impl.Member;
import kd.epm.eb.common.enums.SysDimensionEnum;
import kd.epm.eb.common.utils.IDUtils;
import kd.epm.eb.formplugin.AbstractListPlugin;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.BooleanUtils;
import org.apache.commons.lang.StringUtils;

public class RptAssignSchemePlugin
extends AbstractListPlugin
implements TreeNodeClickListener,
SearchEnterListener {
    private IModelCacheHelper cacheHelper;

    @Override
    public void registerListener(EventObject e) {
        super.registerListener(e);
        TreeView periodTreeView = (TreeView)this.getControl("lefttree");
        periodTreeView.addTreeNodeClickListener((TreeNodeClickListener)this);
        this.addSearchListener(this, new String[]{"searchlist"});
        this.addClickListeners(new String[]{"btnok"});
        BillList billList = (BillList)this.getControl("billlistap");
        if (billList != null) {
            billList.addSetFilterListener(this::setFilter);
        }
    }

    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        QFilter qfilter = (QFilter)SerializationUtils.deSerializeFromBase64((String)((String)this.getFormCustomParam("qfilter")));
        DynamicObjectCollection query = QueryServiceHelper.query((String)"eb_schemeassign", (String)"year", (QFilter[])qfilter.toArray());
        this.buildPeriodTree(query);
        Label caption = (Label)this.getControl("caption");
        caption.setText(ResManager.loadKDString((String)"\u4e0b\u8fbe\u65b9\u6848\u9009\u62e9", (String)"RptAssignSchemePlugin_1", (String)"epm-eb-formplugin", (Object[])new Object[0]));
        this.getModel().setValue("cbchildren", (Object)true);
        this.refreshBill();
    }

    public void treeNodeClick(TreeNodeEvent evt) {
        Object nodeId = evt.getNodeId();
        this.getPageCache().put("currentTreeNodeId", String.valueOf(nodeId));
        this.refreshBill();
    }

    public void propertyChanged(PropertyChangedArgs e) {
        String name = e.getProperty().getName();
        if ("cbchildren".equals(name)) {
            this.refreshBill();
        }
    }

    public void setFilter(SetFilterEvent e) {
        Search control;
        String searchKey;
        super.setFilter(e);
        String qfilter = (String)this.getFormCustomParam("qfilter");
        QFilter baseFilter = (QFilter)SerializationUtils.deSerializeFromBase64((String)qfilter);
        ArrayList<QFilter> qFilters = new ArrayList<QFilter>(10);
        qFilters.add(baseFilter);
        String currentTreeNodeId = this.getPageCache().get("currentTreeNodeId");
        if (StringUtils.isNotEmpty((String)currentTreeNodeId)) {
            Member member = this.getModelCacheHelper().getMember(SysDimensionEnum.BudgetPeriod.getNumber(), IDUtils.toLong((Object)currentTreeNodeId));
            if (!SysDimensionEnum.BudgetPeriod.getNumber().equals(member.getNumber())) {
                Boolean cbChildren = (Boolean)this.getModel().getValue("cbchildren");
                if (BooleanUtils.isTrue((Boolean)cbChildren)) {
                    List allMembers = member.getAllMembers();
                    QFilter qFilter = new QFilter("year", "in", allMembers.stream().map(BaseCache::getId).collect(Collectors.toSet()));
                    qFilters.add(qFilter);
                } else {
                    qFilters.add(new QFilter("year", "=", (Object)member.getId()));
                }
            }
        }
        if (StringUtils.isNotEmpty((String)(searchKey = (control = (Search)this.getControl("searchlist")).getSearchKey()))) {
            QFilter qFilter = new QFilter("year.name", "ftlike", (Object)searchKey).or(new QFilter("version.name", "ftlike", (Object)searchKey)).or(new QFilter("name", "ftlike", (Object)searchKey)).or(new QFilter("scheme.name", "ftlike", (Object)searchKey));
            qFilters.add(qFilter);
        }
        e.getQFilters().addAll(qFilters);
    }

    @Override
    public Long getModelId() {
        String model = this.getPageCache().get("model");
        if (StringUtils.isNotEmpty((String)model)) {
            return IDUtils.toLong((Object)model);
        }
        return (Long)this.getFormCustomParam("model");
    }

    public void search(SearchEnterEvent evt) {
        this.refreshBill();
    }

    public void click(EventObject evt) {
        String key = ((Control)evt.getSource()).getKey();
        if ("btnok".equals(key)) {
            BillList billistap = (BillList)this.getControl("billlistap");
            ListSelectedRowCollection selectedRows = billistap.getSelectedRows();
            if (CollectionUtils.isEmpty((Collection)selectedRows)) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u6570\u636e\u3002", (String)"RptAssignSchemePlugin_2", (String)"epm-eb-formplugin", (Object[])new Object[0]));
            } else {
                ListSelectedRow listSelectedRow = selectedRows.get(0);
                Object primaryKeyValue = listSelectedRow.getPrimaryKeyValue();
                this.getView().returnDataToParent(primaryKeyValue);
                this.getView().close();
            }
        }
    }

    private void refreshBill() {
        BillList billList = (BillList)this.getView().getControl("billlistap");
        billList.setOrderBy("assigntime desc");
        billList.refresh();
    }

    private IModelCacheHelper getModelCacheHelper() {
        if (this.cacheHelper != null) {
            return this.cacheHelper;
        }
        this.cacheHelper = ModelCacheContext.getOrCreate((Long)this.getModelId());
        return this.cacheHelper;
    }

    private void buildPeriodTree(DynamicObjectCollection dynamicObjects) {
        if (CollectionUtils.isEmpty((Collection)dynamicObjects)) {
            return;
        }
        IModelCacheHelper cacheHelper = this.getModelCacheHelper();
        HashSet<Member> members = new HashSet<Member>(16);
        for (DynamicObject dynamicObject : dynamicObjects) {
            String[] split;
            Member member = cacheHelper.getMember(SysDimensionEnum.BudgetPeriod.getNumber(), Long.valueOf(dynamicObject.getLong("year")));
            members.add(member);
            String longNumber = member.getLongNumber();
            for (String num : split = longNumber.split("!")) {
                if (SysDimensionEnum.BudgetPeriod.getNumber().equals(num)) continue;
                Member parent = cacheHelper.getMember(SysDimensionEnum.BudgetPeriod.getNumber(), num);
                members.add(parent);
            }
        }
        List<Member> collect = members.stream().sorted((o1, o2) -> {
            int level2;
            int level1 = o1.getLevel();
            if (level1 == (level2 = o2.getLevel())) {
                int seq1 = o1.getSeq();
                int seq2 = o2.getSeq();
                if (o1.getLevel() == 2) {
                    return seq2 - seq1;
                }
                return seq1 - seq2;
            }
            return o1.getSeq() - o2.getSeq();
        }).collect(Collectors.toList());
        this.doBuildPeriodTree(collect);
    }

    private void doBuildPeriodTree(List<Member> members) {
        if (CollectionUtils.isEmpty(members)) {
            return;
        }
        TreeView treeView = (TreeView)this.getControl("lefttree");
        treeView.deleteAllNodes();
        TreeNode root = new TreeNode();
        IModelCacheHelper cacheHelper = this.getModelCacheHelper();
        Member rootMember = cacheHelper.getMember(SysDimensionEnum.BudgetPeriod.getNumber(), SysDimensionEnum.BudgetPeriod.getNumber());
        root.setId(String.valueOf(rootMember.getId()));
        root.setText(rootMember.getName());
        root.setLongNumber(rootMember.getNumber());
        treeView.addNode(root);
        LinkedHashMap<String, TreeNode> treeNodeMap = new LinkedHashMap<String, TreeNode>(members.size());
        for (Member member : members) {
            treeNodeMap.put(String.valueOf(member.getId()), new TreeNode(String.valueOf(member.getParentId()), String.valueOf(member.getId()), member.getName()));
        }
        for (Map.Entry entry : treeNodeMap.entrySet()) {
            TreeNode value = (TreeNode)entry.getValue();
            if (root.getId().equals(value.getParentid())) {
                root.addChild(value);
                continue;
            }
            TreeNode treeNode = this.findParentTreeNode(root, value.getParentid());
            if (treeNode == null) continue;
            treeNode.addChild(value);
        }
        treeView.expand(root.getId());
        treeView.focusNode(root);
        this.getView().updateView("lefttree");
    }

    private TreeNode findParentTreeNode(TreeNode node, String parentId) {
        if (StringUtils.equals((String)node.getId(), (String)parentId)) {
            return node;
        }
        List children = node.getChildren();
        if (children != null) {
            Optional<TreeNode> first = children.stream().filter(treeNode -> StringUtils.equals((String)treeNode.getId(), (String)parentId)).findFirst();
            if (first.isPresent()) {
                return first.get();
            }
            for (TreeNode child : children) {
                TreeNode parentNode = this.findParentTreeNode(child, parentId);
                if (parentNode == null) continue;
                return parentNode;
            }
        }
        return null;
    }
}

