/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.formplugin.rollingbudget;

import java.util.ArrayList;
import java.util.EventObject;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.bill.BillShowParameter;
import kd.bos.bill.OperationStatus;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.resource.promptenum.MultiLangEnumBridge;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.entity.datamodel.ListSelectedRow;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.exception.KDBizException;
import kd.bos.form.CloseCallBack;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.MessageTypes;
import kd.bos.form.ShowType;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.HyperLinkClickEvent;
import kd.bos.form.events.HyperLinkClickListener;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.events.SetFilterEvent;
import kd.bos.form.events.SetFilterListener;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.BillList;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.DispatchServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.DeleteServiceHelper;
import kd.epm.eb.business.quote.QuoteBuilder;
import kd.epm.eb.business.quote.QuoteCheckResult;
import kd.epm.eb.business.quote.QuoteRegDataCheck;
import kd.epm.eb.business.servicehelper.DimensionServiceHelper;
import kd.epm.eb.common.cache.impl.Dataset;
import kd.epm.eb.common.cache.impl.Member;
import kd.epm.eb.common.cache.impl.Model;
import kd.epm.eb.common.enums.ApplicationTypeEnum;
import kd.epm.eb.common.enums.SysDimensionEnum;
import kd.epm.eb.common.enums.memberQuote.MemberQuoteResourceEnum;
import kd.epm.eb.common.permission.MembPermRecordUtil;
import kd.epm.eb.common.shrek.controller.ShrekOlapServiceHelper;
import kd.epm.eb.common.shrek.domain.ShrekConfig;
import kd.epm.eb.common.shrek.service.ShrekConfigServiceHelper;
import kd.epm.eb.common.utils.DatasetServiceHelper;
import kd.epm.eb.common.utils.DimensionViewServiceHelper;
import kd.epm.eb.common.utils.IDUtils;
import kd.epm.eb.common.utils.OperationLogUtil;
import kd.epm.eb.common.utils.RollBudgetServiceHelper;
import kd.epm.eb.formplugin.AbstractListPlugin;
import kd.epm.eb.formplugin.utils.PluginUtils;
import kd.epm.eb.model.utils.ModelUtil;
import kd.epm.eb.model.utils.UserSelectUtil;
import org.apache.commons.lang.StringUtils;

public class EbRollBudgetPlugin
extends AbstractListPlugin
implements SetFilterListener,
BeforeF7SelectListener {
    private static final String BTN_REMOVE = "btn_remove";
    private static final String BTN_NEW = "btn_new";
    private static final String BTN_UPDATE = "btn_update";
    private static final String BTN_REFUSH = "btn_refush";

    public void initialize() {
        super.initialize();
        BillList billList = (BillList)this.getControl("billlistap");
        billList.addSetFilterListener((SetFilterListener)this);
    }

    @Override
    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addItemClickListeners(new String[]{"toolbarap"});
        BasedataEdit model = (BasedataEdit)this.getControl("model");
        model.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        BillList billList = (BillList)this.getControl("billlistap");
        billList.addHyperClickListener((HyperLinkClickListener)this);
        this.addClickListeners(new String[]{"imageup", "imagedown"});
    }

    public void click(EventObject evt) {
        super.click(evt);
    }

    @Override
    public void hyperLinkClick(HyperLinkClickEvent hyperLinkClickEvent) {
        super.hyperLinkClick(hyperLinkClickEvent);
        this.toUpdate();
    }

    public void propertyChanged(PropertyChangedArgs e) {
        Object obj;
        String propName = e.getProperty().getName();
        if ("MODEL".equalsIgnoreCase(propName) && (obj = this.getModel().getValue("model")) instanceof DynamicObject) {
            Long modelId = ((DynamicObject)obj).getLong("id");
            UserSelectUtil.saveUserSelectWhenModelChange((IFormView)this.getView(), (Long)modelId);
            this.reFreshBillList();
        }
    }

    @Override
    public void beforeF7Select(BeforeF7SelectEvent e) {
        String key = e.getProperty().getName();
        if ("model".equals(key) && ApplicationTypeEnum.BGMD == ModelUtil.queryApp((IFormView)this.getView())) {
            PluginUtils.setModelFilter(e, this.getView());
        }
    }

    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        Long modelId = UserSelectUtil.getModelIdAfterCreateNewData((IFormView)this.getView(), (String)"model", (boolean)false);
        if (!IDUtils.isNotNull((Long)modelId)) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u4f53\u7cfb", (String)"EbRollBudgetPlugin_1", (String)"epm-eb-formplugin", (Object[])new Object[0]));
            return;
        }
        this.getModel().setValue("model", (Object)modelId);
        this.reFreshBillList();
    }

    private void reFreshBillList() {
        BillList billList = (BillList)this.getControl("billlistap");
        billList.clearSelection();
        billList.refresh();
    }

    public void itemClick(ItemClickEvent evt) {
        String itemKey;
        super.itemClick(evt);
        switch (itemKey = evt.getItemKey()) {
            case "btn_new": {
                this.toNew();
                break;
            }
            case "btn_remove": {
                this.toRemove();
                break;
            }
            case "btn_update": {
                this.toUpdate();
                break;
            }
            case "btn_refush": {
                this.reFreshBillList();
                break;
            }
        }
    }

    private void toNew() {
        DynamicObject value = (DynamicObject)this.getModel().getValue("model");
        if (value == null) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u8f93\u5165\u4f53\u7cfb\u3002", (String)"EbRollBudgetPlugin_6", (String)"epm-eb-formplugin", (Object[])new Object[0]));
        } else {
            BillShowParameter param = new BillShowParameter();
            param.getOpenStyle().setShowType(ShowType.MainNewTabPage);
            param.setStatus(OperationStatus.ADDNEW);
            param.setFormId("eb_rollconfig");
            param.setCustomParam("model", (Object)value.getLong("id"));
            param.setCloseCallBack(new CloseCallBack((IFormPlugin)this, "bar_new"));
            this.getView().showForm((FormShowParameter)param);
        }
    }

    private void toRemove() {
        BillList billList = (BillList)this.getControl("billlistap");
        ListSelectedRowCollection rows = billList.getSelectedRows();
        Long model = ((DynamicObject)this.getModel().getValue("model")).getLong("id");
        String modelNumber = ((DynamicObject)this.getModel().getValue("model")).getString("shownumber");
        this.getPageCache().put("move_memId", null);
        this.getPageCache().put("move_parenId", null);
        this.getPageCache().put("move_dimId", null);
        if (rows.size() < 1) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u8981\u6267\u884c\u7684\u6570\u636e\u3002", (String)"EbRollBudgetPlugin_7", (String)"epm-eb-formplugin", (Object[])new Object[0]));
        } else if (rows.size() == 1) {
            rows.forEach(row -> {
                QFilter q1 = new QFilter("rollconfig", "=", row.getPrimaryKeyValue());
                DynamicObject dynamicObject = QueryServiceHelper.queryOne((String)"eb_rollinitrecord", (String)"id", (QFilter[])new QFilter[]{q1});
                if (dynamicObject != null) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u4e0d\u5141\u8bb8\u5220\u9664\u5df2\u6709\u521d\u59cb\u5316\u8bb0\u5f55\u7684\u6eda\u52a8\u9884\u7b97\u89c4\u5219\u3002", (String)"EbRollBudgetPlugin_8", (String)"epm-eb-formplugin", (Object[])new Object[0]));
                } else {
                    DynamicObject dataTypeDy;
                    boolean deleteDataType;
                    QFilter qFilter = new QFilter("model", "=", (Object)model);
                    QFilter qFilter2 = new QFilter("number", "=", (Object)SysDimensionEnum.DataType.getNumber());
                    DynamicObject dynamicObject1 = QueryServiceHelper.queryOne((String)"epm_dimension", (String)"id, number", (QFilter[])new QFilter[]{qFilter.and(qFilter2)});
                    Long dimensionId = dynamicObject1.getLong("id");
                    this.getPageCache().put("move_dimId", dimensionId.toString());
                    DynamicObject rollConfigDy = BusinessDataServiceHelper.loadSingle((Object)row.getPrimaryKeyValue(), (String)"eb_rollconfig", (String)"id,number,startdate.number");
                    boolean bl = deleteDataType = !QueryServiceHelper.exists((String)"eb_rollconfig", (QFilter[])new QFilter[]{new QFilter("model", "=", (Object)model), new QFilter("startdate.number", "=", (Object)rollConfigDy.getString("startdate.number")), new QFilter("number", "!=", (Object)rollConfigDy.getString("number"))});
                    if (deleteDataType && (dataTypeDy = RollBudgetServiceHelper.getInstance().getDataType(model, rollConfigDy.getString("startdate.number"))) != null) {
                        Long memId = dataTypeDy.getLong("id");
                        String parenId = dataTypeDy.getString("parent_id");
                        this.getPageCache().put("move_memId", memId.toString());
                        this.getPageCache().put("move_parenId", parenId);
                        this.getPageCache().put("move_number", dataTypeDy.getString("number"));
                        List objs = DimensionServiceHelper.getAllChildrenObject((String)"epm_datatypemembertree", (Long)model, (Long)dimensionId, (Long)memId, (String)"id,number", (boolean)true);
                        Set memberIds = objs.stream().map(p -> (Long)p.get("id")).collect(Collectors.toSet());
                        QuoteCheckResult quote = QuoteRegDataCheck.get().checkQuoteResult(QuoteBuilder.build((Long)model, (Long)dimensionId, memberIds));
                        if (quote.isHasQuote()) {
                            this.getView().showMessage(ResManager.loadKDString((String)"\u6570\u636e\u7c7b\u578b\u88ab\u5f15\u7528\uff0c\u53bb\u9664\u5f15\u7528\u624d\u53ef\u6267\u884c\u5220\u9664\u3002", (String)"EbRollBudgetPlugin_9", (String)"epm-eb-formplugin", (Object[])new Object[0]), quote.getMsg(), MessageTypes.Default);
                            return;
                        }
                    }
                    this.getView().showConfirm(ResManager.loadKDString((String)"\u786e\u8ba4\u5220\u9664\u6240\u9009\u8bb0\u5f55\uff1f", (String)"EbRollBudgetPlugin_10", (String)"epm-eb-formplugin", (Object[])new Object[0]), MessageBoxOptions.OKCancel, new ConfirmCallBackListener(BTN_REMOVE, (IFormPlugin)this));
                }
            });
        } else {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u4e0d\u5141\u8bb8\u540c\u65f6\u5220\u9664\u591a\u884c\u6570\u636e\u3002", (String)"EbRollBudgetPlugin_11", (String)"epm-eb-formplugin", (Object[])new Object[0]));
        }
    }

    protected List<Dataset> getDataSets(DynamicObject modelObj) {
        return DatasetServiceHelper.getDatasets((DynamicObject)modelObj, (String)SysDimensionEnum.DataType.getNumber());
    }

    private void deleteDimMember() {
        Long modelId = ((DynamicObject)this.getModel().getValue("model")).getLong("id");
        String selectMemberId = this.getPageCache().get("move_memId");
        String dimNum = SysDimensionEnum.DataType.getNumber();
        Long dimensionId = Long.valueOf(this.getPageCache().get("move_dimId"));
        String memberKey = "epm_datatypemembertree";
        String parenId = this.getPageCache().get("move_parenId");
        String move_number = this.getPageCache().get("move_number");
        LinkedList<Long> deleteIds = new LinkedList<Long>();
        LinkedList<String> deleteMemNum = new LinkedList<String>();
        List allChildenObject = DimensionServiceHelper.getAllChildrenObject((String)memberKey, (Long)modelId, (Long)dimensionId, (Long)Long.valueOf(selectMemberId), (String)"id,number", (boolean)true);
        for (Map ob : allChildenObject) {
            deleteIds.add((Long)ob.get("id"));
            deleteMemNum.add((String)ob.get("number"));
        }
        try (TXHandle tx = TX.requiresNew((String)"deleteMember");){
            try {
                DeleteServiceHelper.delete((String)memberKey, (QFilter[])new QFilter[]{new QFilter("id", "in", deleteIds)});
                DimensionServiceHelper.updateIsLeafByParentId((Long)Long.valueOf(parenId), (Long)modelId, (Long)dimensionId, (String)memberKey);
                MultiLangEnumBridge opName = new MultiLangEnumBridge("\u5220\u9664\u7ef4\u5ea6\u6210\u5458", "EbRollBudgetPlugin_12", "epm-eb-formplugin");
                MultiLangEnumBridge opDesc = new MultiLangEnumBridge("\u5220\u9664%1$s\u7ef4\u5ea6\u7684\u6210\u5458%2$s", "EbRollBudgetPlugin_14", "epm-eb-formplugin");
                this.writeLog(null, "delete", opName, opDesc, new String[]{dimNum, String.join((CharSequence)",", deleteMemNum)});
                MembPermRecordUtil.delDetailRecordByMembIds((Long)modelId, (Long)dimensionId, deleteIds);
                this.updateViewMembers(deleteIds);
            }
            catch (Throwable e) {
                tx.markRollback();
                throw new KDBizException(e.getMessage());
            }
            finally {
                if (deleteIds.size() > 0) {
                    this.syncOlapMember(allChildenObject, modelId, dimNum, parenId, move_number);
                }
            }
        }
    }

    private void syncOlapMember(List<Map<String, Object>> members, long modelId, String dimNum, String parenId, String delNumber) {
        if (members == null || members.isEmpty()) {
            return;
        }
        ArrayList memberNumbers = new ArrayList(members.size());
        members.forEach(m -> memberNumbers.add((String)m.get("number")));
        DynamicObject model = BusinessDataServiceHelper.loadSingle((Object)modelId, (String)"epm_model");
        if (ShrekOlapServiceHelper.needDMLOlap((DynamicObject)model)) {
            List deleteDataSets = DatasetServiceHelper.getDatasetsForDelete((DynamicObject)model, (String)dimNum);
            List updateDataSets = DatasetServiceHelper.getDatasets((DynamicObject)model, (String)dimNum);
            Model modelObj = Model.of((DynamicObject)model);
            ShrekConfig config = ShrekConfigServiceHelper.getDefaultConfig((DynamicObject)model);
            ShrekOlapServiceHelper.dropCubeMembers((Model)modelObj, (List)deleteDataSets, (String)dimNum, memberNumbers);
            String entityNumber = SysDimensionEnum.DataType.getMemberTreemodel();
            String selectFields = "id,number,dseq,aggoprt,isleaf,storagetype,level";
            long parentId = Long.parseLong(parenId);
            DynamicObject parent = BusinessDataServiceHelper.loadSingleFromCache((String)entityNumber, (String)selectFields, (QFilter[])new QFilter[]{new QFilter("id", "=", (Object)parentId)});
            List children = DimensionServiceHelper.queryChildren((String)selectFields, (long)parentId, (String)entityNumber);
            children = children.stream().filter(d -> !delNumber.equals(d.getString("number"))).collect(Collectors.toList());
            ShrekOlapServiceHelper.updateCubeMember((Model)modelObj, (List)updateDataSets, (String)dimNum, (Member)Member.of((DynamicObject)parent, children), (ShrekConfig)config);
        }
    }

    private void deleteQuto(List<Long> resourceIds) {
        if (resourceIds == null || resourceIds.size() == 0) {
            return;
        }
        DispatchServiceHelper.invokeBizService((String)"epm", (String)"eb", (String)"MemberQuoteService", (String)"delete", (Object[])new Object[]{MemberQuoteResourceEnum.RollBudget.getType(), resourceIds});
    }

    private void updateViewMembers(List<Long> deleteIds) {
        if (deleteIds.size() > 0) {
            List viewMemberIds = DimensionViewServiceHelper.getInstance().queryViewIdsByMemberId(deleteIds);
            for (Long viewMemberId : viewMemberIds) {
                this.deleteViewMember(viewMemberId);
            }
        }
    }

    private void deleteViewMember(Long viewMemberId) {
        Long parentId;
        String move_memId = this.getPageCache().get("move_memId");
        Long selectMemberId = move_memId != null ? Long.parseLong(move_memId) : 0L;
        if (viewMemberId != null) {
            selectMemberId = viewMemberId;
        }
        String dimId = this.getPageCache().get("move_dimId");
        Long modelId = ((DynamicObject)this.getModel().getValue("model")).getLong("id");
        String memberKey = "eb_viewmember";
        List allIds = DimensionServiceHelper.getAllViewChildrenId((String)memberKey, (Long)modelId, (Long)Long.valueOf(dimId), (Long)selectMemberId, (boolean)true);
        DynamicObject parent = QueryServiceHelper.queryOne((String)memberKey, (String)"parent", (QFilter[])new QFilter[]{new QFilter("id", "=", (Object)selectMemberId)});
        DeleteServiceHelper.delete((String)memberKey, (QFilter[])new QFilter[]{new QFilter("id", "in", (Object)allIds)});
        if (parent != null && (parentId = Long.valueOf(parent.getLong("parent"))) != null && parentId != 0L) {
            DimensionServiceHelper.updateIsLeafByParentId((Long)parentId, (Long)modelId, (Long)Long.parseLong(dimId), (String)memberKey);
        }
    }

    public void confirmCallBack(MessageBoxClosedEvent event) {
        super.confirmCallBack(event);
        String callBackId = event.getCallBackId();
        if (MessageBoxResult.Yes.getValue() == event.getResult().getValue() && BTN_REMOVE.equals(callBackId)) {
            BillList billList = (BillList)this.getControl("billlistap");
            ListSelectedRowCollection rows = billList.getSelectedRows();
            ArrayList<Long> deleteIds = new ArrayList<Long>(rows.size());
            for (ListSelectedRow row : rows) {
                deleteIds.add((Long)row.getPrimaryKeyValue());
            }
            DeleteServiceHelper.delete((IDataEntityType)BusinessDataServiceHelper.newDynamicObject((String)"eb_rollconfig").getDataEntityType(), (Object[])deleteIds.toArray());
            this.deleteQuto(deleteIds);
            String move_memId = this.getPageCache().get("move_memId");
            String move_number = this.getPageCache().get("move_number");
            if (StringUtils.isNotEmpty((String)move_memId) && StringUtils.isNotEmpty((String)move_number)) {
                this.deleteDimMember();
            }
            this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u5220\u9664\u6210\u529f\u3002", (String)"EbRollBudgetPlugin_15", (String)"epm-eb-formplugin", (Object[])new Object[0]));
            this.reFreshBillList();
            MultiLangEnumBridge opName = new MultiLangEnumBridge("\u5220\u9664", "EbRollBudgetPlugin_13", "epm-eb-formplugin");
            MultiLangEnumBridge opDescription = new MultiLangEnumBridge("\u5220\u9664ID\uff1a%1$s\u3002", "EbRollBudgetPlugin_18", "epm-eb-formplugin");
            OperationLogUtil.log((String)this.getView().getFormShowParameter().getAppId(), (String)this.getView().getFormShowParameter().getFormId(), null, (String)"delete", (MultiLangEnumBridge)opName, (MultiLangEnumBridge)opDescription, (String[])new String[]{((Object)deleteIds).toString()});
        }
    }

    private void toUpdate() {
        BillList billList = (BillList)this.getControl("billlistap");
        ListSelectedRowCollection rows = billList.getSelectedRows();
        if (rows.size() < 1) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u8981\u4fee\u6539\u7684\u8bb0\u5f55\u3002", (String)"EbRollBudgetPlugin_16", (String)"epm-eb-formplugin", (Object[])new Object[0]));
        } else if (rows.size() > 1) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u4e00\u884c\u8bb0\u5f55\u8fdb\u884c\u4fee\u6539\u3002", (String)"EbRollBudgetPlugin_17", (String)"epm-eb-formplugin", (Object[])new Object[0]));
        } else {
            Long pkId = (Long)rows.get(0).getPrimaryKeyValue();
            String pageId = this.getView().getPageId() + pkId;
            HashMap<String, String> openParameter = new HashMap<String, String>(16);
            openParameter.put("formId", "eb_rollconfig");
            openParameter.put("pkId", pkId.toString());
            FormShowParameter param = FormShowParameter.createFormShowParameter(openParameter);
            param.getOpenStyle().setShowType(ShowType.MainNewTabPage);
            param.setStatus(OperationStatus.EDIT);
            param.setPageId(pageId);
            param.setShowTitle(true);
            param.setCustomParam("rollconfigId", (Object)pkId);
            param.setCustomParam("status", (Object)"edit");
            DynamicObject value = (DynamicObject)this.getModel().getValue("model");
            if (value == null) {
                this.getView().showErrorNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u4f53\u7cfb", (String)"EbRollBudgetPlugin_1", (String)"epm-eb-formplugin", (Object[])new Object[0]));
                return;
            }
            param.setCustomParam("model", (Object)value.getLong("id"));
            param.setCloseCallBack(new CloseCallBack((IFormPlugin)this, "bar_close"));
            this.getView().showForm(param);
        }
    }

    @Override
    public void closedCallBack(ClosedCallBackEvent closedCallBackEvent) {
        super.closedCallBack(closedCallBackEvent);
        this.reFreshBillList();
    }

    public void setFilter(SetFilterEvent e) {
        BillList billList;
        if (e.getSource() instanceof BillList && "billlistap".equals((billList = (BillList)e.getSource()).getKey())) {
            e.getQFilters().add(new QFilter("model", "=", (Object)this.getModelId()));
            e.setOrderBy("id desc");
        }
    }

    @Override
    public Long getModelId() {
        Long modelId = 0L;
        DynamicObject model = (DynamicObject)this.getModel().getValue("model");
        if (model != null) {
            modelId = model.getLong("id");
        }
        return modelId;
    }
}

