/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.formplugin.rollingbudget;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.bill.OperationStatus;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.resource.promptenum.MultiLangEnumBridge;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.ListSelectedRow;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.ShowType;
import kd.bos.form.StyleCss;
import kd.bos.form.control.events.ClickListener;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.TextEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.form.operate.AbstractOperate;
import kd.bos.form.operate.FormOperate;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.ListFilterParameter;
import kd.bos.list.ListShowParameter;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.DispatchServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.TimeServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.epm.eb.business.memberf7.NewF7Utils;
import kd.epm.eb.business.servicehelper.DimensionServiceHelper;
import kd.epm.eb.common.cache.IModelCacheHelper;
import kd.epm.eb.common.cache.ModelCacheContext;
import kd.epm.eb.common.cache.impl.Dataset;
import kd.epm.eb.common.cache.impl.Dimension;
import kd.epm.eb.common.cache.impl.Member;
import kd.epm.eb.common.cache.impl.Model;
import kd.epm.eb.common.dao.memberQuote.MemberQuoteDao;
import kd.epm.eb.common.enums.SysDimensionEnum;
import kd.epm.eb.common.enums.dimensionEnums.MemberSourceEnum;
import kd.epm.eb.common.enums.memberQuote.MemberQuoteResourceEnum;
import kd.epm.eb.common.member.f7.MemberF7Parameter;
import kd.epm.eb.common.shrek.controller.ShrekOlapServiceHelper;
import kd.epm.eb.common.shrek.domain.ShrekConfig;
import kd.epm.eb.common.shrek.service.ShrekConfigServiceHelper;
import kd.epm.eb.common.utils.CubeUtils;
import kd.epm.eb.common.utils.DatasetServiceHelper;
import kd.epm.eb.common.utils.IDUtils;
import kd.epm.eb.common.utils.OperationLogUtil;
import kd.epm.eb.common.utils.RollBudgetServiceHelper;
import kd.epm.eb.common.utils.StringUtils;
import kd.epm.eb.common.utils.convert.Convert;
import kd.epm.eb.formplugin.AbstractFormPlugin;

public class EbRollConfigPlugin
extends AbstractFormPlugin
implements BeforeF7SelectListener {
    private static final String REFERENCERECORD = "referencerecord";
    public static final String STARTDATE = "startdate";
    public static final String DATATYPE = "datatype";
    public static final String ROLLVERSION = "rollversion";
    public static final String VERSION = "version";
    public static final String BASISTYPE = "basistype";
    public static final String ACTVERSION = "actversion";
    public static final String ROLLTEMPLATE = "rolltemplate";
    public static final String DATAVERSION = "dataversion";
    public static final String MODEL = "model";
    private RollBudgetServiceHelper instance = RollBudgetServiceHelper.getInstance();

    public void initialize() {
        super.initialize();
        TextEdit description = (TextEdit)this.getControl("description");
        description.addClickListener((ClickListener)this);
        this.addBeforeF7SelectListeners(STARTDATE, ROLLVERSION, VERSION, DATATYPE, ACTVERSION, ROLLTEMPLATE);
    }

    public void afterCreateNewData(EventObject e) {
        Map customParams = this.getView().getFormShowParameter().getCustomParams();
        IDataModel model = this.getModel();
        String modelId = customParams.get(MODEL).toString();
        this.getPageCache().put(MODEL, modelId);
        model.setValue(MODEL, (Object)modelId);
        DynamicObject dynamicObject = this.queryDimMember("epm_versionmembertree", "ACTUAL", Long.valueOf(modelId), "id");
        model.setValue(ACTVERSION, (Object)dynamicObject.getString("id"));
        this.setStartDateFilter(Convert.toLong((Object)modelId));
    }

    public void afterBindData(EventObject e) {
        if ("edit".equals(this.getView().getFormShowParameter().getCustomParam("status"))) {
            Map customParams = this.getView().getFormShowParameter().getCustomParams();
            String modelId = customParams.get(MODEL).toString();
            this.getPageCache().put(MODEL, modelId);
            String name = this.getModel().getValue("name").toString();
            if (name == null) {
                this.getView().setEnable(Boolean.TRUE, new String[]{ROLLVERSION, DATATYPE, VERSION, BASISTYPE, ROLLTEMPLATE, REFERENCERECORD, "description"});
            }
            this.setViewEnable(Convert.toLong((Object)modelId));
            this.getModel().setDataChanged(false);
        }
    }

    private List<String> queryAuditTrialIds(Long id, String source) {
        LinkedList<String> auditTrialIds = new LinkedList<String>();
        if (IDUtils.isEmptyLong((Long)id).booleanValue() || StringUtils.isEmpty((String)source)) {
            return auditTrialIds;
        }
        try (DataSet ds = DB.queryDataSet((String)"auditTrial", (DBRoute)DBRoute.of((String)"epm"), (String)"select ftrialid from t_eb_rollinitrecordtrial where fid = ? and fsource = ?", (Object[])new Object[]{id, source});){
            if (ds != null) {
                Row row = null;
                while (ds.hasNext()) {
                    row = ds.next();
                    auditTrialIds.add(row.getString("ftrialid"));
                }
            }
        }
        return auditTrialIds;
    }

    @Override
    public void beforeDoOperation(BeforeDoOperationEventArgs evt) {
        super.beforeDoOperation(evt);
        String type = ((AbstractOperate)evt.getSource()).getOperateKey();
        if (type.equals("save")) {
            this.rolltemplateIsNull(evt);
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs args) {
        super.afterDoOperation(args);
        String opType = ((FormOperate)args.getSource()).getType();
        if ("save".equals(opType)) {
            Long id = IDUtils.toLong((Object)this.getModel().getValue("id"));
            Boolean result = this.checkResult();
            if (result.equals(Boolean.FALSE)) {
                DynamicObject epm_datatypemembertree = this.fillDataTypeMember();
                Object[] save = SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{epm_datatypemembertree});
                DynamicObject dataType_rollBudget = BusinessDataServiceHelper.loadSingle((String)"epm_datatypemembertree", (String)"isLeaf", (QFilter[])new QFilter[]{new QFilter(MODEL, "=", (Object)this.getModelId()), new QFilter("number", "=", (Object)"RollBudget")});
                if (dataType_rollBudget != null) {
                    dataType_rollBudget.set("isLeaf", (Object)"0");
                    SaveServiceHelper.update((DynamicObject)dataType_rollBudget);
                }
                this.refreshCache(epm_datatypemembertree);
                this.addDataTypeMemberQuote(epm_datatypemembertree);
                if (ShrekOlapServiceHelper.isStartShrek()) {
                    this.syncOlapData((DynamicObject)save[0]);
                }
            }
            this.addDimMemberQuote();
            MultiLangEnumBridge opName = new MultiLangEnumBridge("\u6eda\u52a8\u9884\u7b97\u65b0\u589e", "EbRollConfigPlugin_8", "epm-eb-formplugin");
            MultiLangEnumBridge opDescription = new MultiLangEnumBridge("\u4fee\u6539\u5185\u5bb9\uff1a%1$s", "EbRollConfigPlugin_10", "epm-eb-formplugin");
            if (this.getView().getFormShowParameter().getStatus().getValue() == OperationStatus.EDIT.getValue()) {
                opName = new MultiLangEnumBridge("\u6eda\u52a8\u9884\u7b97\u4fee\u6539", "EbRollConfigPlugin_9", "epm-eb-formplugin");
            }
            OperationLogUtil.log((String)this.getView().getFormShowParameter().getAppId(), (String)this.getView().getFormShowParameter().getFormId(), null, (String)"edit", (MultiLangEnumBridge)opName, (MultiLangEnumBridge)opDescription, (String[])new String[]{IDUtils.toString((Object)id)});
        }
    }

    private void addDataTypeMemberQuote(DynamicObject dataTypeMemberObject) {
        IModelCacheHelper modelCacheHelper = ModelCacheContext.getOrCreate((Long)this.getModelId());
        Map dimensionMap = modelCacheHelper.getDimensionMap();
        Long modelId = modelCacheHelper.getModelobj().getId();
        Long quoteId = (Long)this.getModel().getValue("id");
        LinkedList<MemberQuoteDao> quotes = new LinkedList<MemberQuoteDao>();
        String trgDTNumber = dataTypeMemberObject.getString("number");
        if (trgDTNumber != null) {
            Dimension dimension = (Dimension)dimensionMap.get(SysDimensionEnum.DataType.getNumber());
            quotes.add(new MemberQuoteDao(modelId, Long.valueOf(0L), dimension.getId(), dimension.getMember(Long.valueOf(0L), trgDTNumber).getId(), MemberQuoteResourceEnum.RollBudget, quoteId));
        }
        if (quotes.size() > 0) {
            DispatchServiceHelper.invokeBizService((String)"epm", (String)"eb", (String)"MemberQuoteService", (String)"save", (Object[])new Object[]{quotes});
        }
    }

    protected void syncOlapData(DynamicObject dyTree) {
        DynamicObject modelObj = (DynamicObject)this.getModel().getValue(MODEL);
        modelObj = BusinessDataServiceHelper.loadSingle((Object)modelObj.get("id"), (String)"epm_model");
        String dimensionNumber = SysDimensionEnum.DataType.getNumber();
        List<Dataset> datasets = this.getDataSets(modelObj, dyTree);
        if (datasets.size() > 0) {
            ShrekConfig config = ShrekConfigServiceHelper.getDefaultConfig((DynamicObject)modelObj);
            Model model = Model.of((DynamicObject)modelObj);
            String selectFields = "id,number,dseq,aggoprt,isleaf,storagetype,level";
            DynamicObject rollBudget = this.queryDimMember("epm_datatypemembertree", "RollBudget", modelObj.getLong("id"), selectFields);
            List children = DimensionServiceHelper.queryChildren((String)selectFields, (long)rollBudget.getLong("id"), (String)"epm_datatypemembertree");
            ShrekOlapServiceHelper.addCubeMembers((Model)model, datasets, (String)dimensionNumber, (List)Member.of(Collections.singletonList(dyTree), (boolean)false), (ShrekConfig)config);
            ShrekOlapServiceHelper.updateCubeMember((Model)model, datasets, (String)dimensionNumber, (Member)Member.of((DynamicObject)rollBudget, (Collection)children), (ShrekConfig)config);
        }
    }

    protected List<Dataset> getDataSets(DynamicObject modelObj, DynamicObject dyTree) {
        return DatasetServiceHelper.getDatasets((DynamicObject)modelObj, (String)SysDimensionEnum.DataType.getNumber());
    }

    private DynamicObject fillDataTypeMember() {
        DynamicObject epm_datatypemembertree = BusinessDataServiceHelper.newDynamicObject((String)"epm_datatypemembertree");
        DynamicObject creator = (DynamicObject)this.getModel().getValue("creator");
        DynamicObject model = (DynamicObject)this.getModel().getValue(MODEL);
        DynamicObject dimension = DimensionServiceHelper.queryDimensionByNumber((Long)model.getLong("id"), (String)"id,number", (String)"DataType");
        String number = ((DynamicObject)this.getModel().getValue(STARTDATE)).getString("number") + "RollBudget";
        String name = this.getModel().getValue("name").toString();
        epm_datatypemembertree.set("number", (Object)number);
        epm_datatypemembertree.set("name", (Object)name);
        DynamicObject biz = this.queryAppSceByNumber(model.getLong("id"), "002", ResManager.loadKDString((String)"\u6eda\u52a8\u9884\u7b97", (String)"EbRollConfigPlugin_2", (String)"epm-eb-formplugin", (Object[])new Object[0]), "id");
        epm_datatypemembertree.set("bizmodel", (Object)biz.getLong("id"));
        DynamicObject parent = this.queryDimMember("epm_datatypemembertree", "RollBudget", model.getLong("id"), "id, level, longnumber");
        epm_datatypemembertree.set("parent", (Object)parent.getLong("id"));
        epm_datatypemembertree.set("aggoprt", (Object)"5");
        String dataVersionId = ((DynamicObject)this.getModel().getValue(ACTVERSION)).getString("id");
        epm_datatypemembertree.set(DATAVERSION, (Object)dataVersionId);
        String periodNumber = ((DynamicObject)this.getModel().getValue(STARTDATE)).getString("number");
        String[] splits = periodNumber.split("\\.");
        int year = Integer.parseInt(splits[0].replaceFirst("FY", ""));
        int month = Integer.parseInt(splits[1].replaceFirst("M", ""));
        epm_datatypemembertree.set("datestart", (Object)new Date(year - 1900, month - 1, 1));
        epm_datatypemembertree.set("description", this.getModel().getValue("description"));
        epm_datatypemembertree.set("status", (Object)"C");
        epm_datatypemembertree.set("enable", (Object)"1");
        int level = parent.getInt("level") + 1;
        epm_datatypemembertree.set("level", (Object)level);
        epm_datatypemembertree.set("createtime", (Object)TimeServiceHelper.now());
        epm_datatypemembertree.set("modifytime", (Object)TimeServiceHelper.now());
        epm_datatypemembertree.set("isleaf", (Object)"1");
        epm_datatypemembertree.set("creator", (Object)creator);
        epm_datatypemembertree.set("modifier", (Object)creator);
        int dSeq = DimensionServiceHelper.getDSeq((long)parent.getLong("id"), (String)"epm_datatypemembertree");
        epm_datatypemembertree.set("dseq", (Object)dSeq);
        epm_datatypemembertree.set("longnumber", (Object)(parent.getString("longnumber") + "!" + number));
        epm_datatypemembertree.set("membersource", (Object)MemberSourceEnum.ADD.getIndex());
        epm_datatypemembertree.set("shownumber", (Object)number);
        epm_datatypemembertree.set(MODEL, (Object)model);
        epm_datatypemembertree.set("dimension", (Object)dimension);
        return epm_datatypemembertree;
    }

    private void rolltemplateIsNull(BeforeDoOperationEventArgs evt) {
        String basistype_value = (String)this.getModel().getValue(BASISTYPE);
        DynamicObjectCollection rolltemplateList = (DynamicObjectCollection)this.getModel().getValue(ROLLTEMPLATE);
        if ("2".equals(basistype_value) && rolltemplateList.size() == 0) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u4f9d\u636e\u7c7b\u578b\u9009\u62e9\u201c\u6a21\u677f\u590d\u5236\u201d\uff0c\u6eda\u52a8\u6a21\u677f\u4e3a\u5fc5\u586b\u9879\u3002", (String)"EbRollConfigPlugin_5", (String)"epm-eb-formplugin", (Object[])new Object[0]));
            evt.cancel = true;
            return;
        }
    }

    private Boolean checkResult() {
        IDataModel model = this.getModel();
        Long modelId = model.getDataEntity().getLong("model_id");
        DynamicObject startPeriod = model.getDataEntity().getDynamicObject(STARTDATE);
        ArrayList<QFilter> filters = new ArrayList<QFilter>(16);
        filters.add(new QFilter(MODEL, "=", (Object)modelId));
        filters.add(new QFilter("longnumber", "like", (Object)"DataType!RollBudget!%"));
        filters.add(new QFilter("isleaf", "=", (Object)Boolean.TRUE));
        if (startPeriod != null) {
            filters.add(new QFilter("number", "like", (Object)(startPeriod.getString("number") + "%")));
        }
        return QueryServiceHelper.exists((String)"epm_datatypemembertree", (QFilter[])filters.toArray(new QFilter[0]));
    }

    @Override
    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addItemClickListeners(new String[]{"tbmain"});
        this.addItemClickListeners(new String[]{"advcontoolbarap"});
    }

    public void click(EventObject evt) {
        super.click(evt);
    }

    public void itemClick(ItemClickEvent evt) {
        String itemKey;
        super.itemClick(evt);
        switch (itemKey = evt.getItemKey()) {
            case "barrollinit": {
                this.toRollInit();
                break;
            }
            case "referencerecord": {
                this.toRollGist();
                break;
            }
            case "historyrecord": {
                this.toHistoryRecord();
                break;
            }
        }
    }

    public void propertyChanged(PropertyChangedArgs e) {
        DynamicObject newValue;
        super.propertyChanged(e);
        if (STARTDATE.equals(e.getProperty().getName()) && (newValue = (DynamicObject)e.getChangeSet()[0].getNewValue()) != null) {
            String startDateName = newValue.getString("name");
            this.getView().getModel().setValue("name", (Object)ResManager.loadResFormat((String)"%1\u6eda\u52a8\u9884\u7b97", (String)"EbRollConfigPlugin_0", (String)"epm-eb-formplugin", (Object[])new Object[]{startDateName}));
        }
    }

    @Override
    public void closedCallBack(ClosedCallBackEvent closedCallBackEvent) {
        super.closedCallBack(closedCallBackEvent);
        String dimNumber = closedCallBackEvent.getActionId();
        Long modelId = this.getModelId();
        if (REFERENCERECORD.equals(dimNumber)) {
            ListSelectedRowCollection returnData = (ListSelectedRowCollection)closedCallBackEvent.getReturnData();
            if (returnData != null && returnData.size() > 0) {
                Long id = (Long)returnData.get(0).getPrimaryKeyValue();
                DynamicObject rollinitrecord = BusinessDataServiceHelper.loadSingle((Object)id, (String)"eb_rollinitrecord");
                IDataModel model = this.getModel();
                DynamicObject dataType = RollBudgetServiceHelper.getInstance().getDataType(modelId, rollinitrecord.getString("rollconfig.startdate.number"));
                model.setValue(DATATYPE, (Object)dataType.getLong("id"));
                model.setValue(VERSION, (Object)rollinitrecord.getLong("rollconfig.rollversion.id"));
                model.setValue(BASISTYPE, (Object)rollinitrecord.getString("rollconfig.basistype"));
                List rolltemList = this.instance.queryTemplateById(Long.valueOf(rollinitrecord.getLong("rollconfig.id")), modelId);
                if (rolltemList != null && rolltemList.size() > 0) {
                    Long[] tems = new Long[rolltemList.size()];
                    QFilter q2 = new QFilter("id", "in", (Object)rolltemList);
                    DynamicObjectCollection rolltemplateList = QueryServiceHelper.query((String)"eb_templateentity", (String)"id, name, number", (QFilter[])new QFilter[]{q2});
                    for (int i = 0; i < rolltemplateList.size(); ++i) {
                        tems[i] = ((DynamicObject)rolltemplateList.get(i)).getLong("id");
                    }
                    model.setValue(ROLLTEMPLATE, (Object)tems);
                }
            }
        } else if ("barrollinit".equals(dimNumber)) {
            this.setViewEnable(modelId);
        }
    }

    private void setViewEnable(Long modelId) {
        String id = this.getModel().getValue("id").toString();
        DynamicObject rollinitrecord = this.instance.queryOneRecord(Long.valueOf(id), modelId);
        if (rollinitrecord != null) {
            this.getView().setEnable(Boolean.FALSE, new String[]{"bar_save", ROLLVERSION, DATATYPE, VERSION, BASISTYPE, ROLLTEMPLATE, REFERENCERECORD, "description"});
            this.getPageCache().put("bar_save", "disable");
        }
    }

    private void addDimMemberQuote() {
    }

    private void toRollInit() {
        String bar_save = this.getPageCache().get("bar_save");
        if ("disable".equals(bar_save)) {
            this.openRollInitPage();
        } else {
            boolean dataChanged = this.getModel().getDataChanged();
            if (dataChanged) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u65b9\u6848\u914d\u7f6e\u5df2\u6539\u53d8\u8bf7\u5148\u4fdd\u5b58\u3002", (String)"EbRollConfigPlugin_11", (String)"epm-eb-formplugin", (Object[])new Object[0]));
                return;
            }
            this.openRollInitPage();
        }
    }

    private void openRollInitPage() {
        FormShowParameter form = new FormShowParameter();
        form.getOpenStyle().setShowType(ShowType.Modal);
        form.setStatus(OperationStatus.ADDNEW);
        form.setFormId("eb_rollinit");
        form.setCaption(ResManager.loadKDString((String)"\u6eda\u52a8\u521d\u59cb\u5316\u4fe1\u606f\u786e\u8ba4", (String)"EbRollConfigPlugin_6", (String)"epm-eb-formplugin", (Object[])new Object[0]));
        form.setCloseCallBack(new CloseCallBack((IFormPlugin)this, "barrollinit"));
        Long model = ((DynamicObject)this.getModel().getValue(MODEL)).getLong("id");
        Long startdate = ((DynamicObject)this.getModel().getValue(STARTDATE)).getLong("id");
        Long datatype = ((DynamicObject)this.getModel().getValue(DATATYPE)).getLong("id");
        Long rollversion = ((DynamicObject)this.getModel().getValue(ROLLVERSION)).getLong("id");
        Long version = ((DynamicObject)this.getModel().getValue(VERSION)).getLong("id");
        Long actualVersion = ((DynamicObject)this.getModel().getValue(ACTVERSION)).getLong("id");
        String basistype = (String)this.getModel().getValue(BASISTYPE);
        Long id = (Long)this.getView().getModel().getValue("id");
        String number = (String)this.getModel().getValue("number");
        DynamicObjectCollection rolltemplate = (DynamicObjectCollection)this.getModel().getValue(ROLLTEMPLATE);
        ArrayList<Long> rolltemplateIds = new ArrayList<Long>(16);
        for (DynamicObject dynamicObject : rolltemplate) {
            long templateid = dynamicObject.getDynamicObject("fbasedataid").getLong("id");
            rolltemplateIds.add(templateid);
        }
        DynamicObject dynamicObjectDataType = RollBudgetServiceHelper.getInstance().getDataType(model, ((DynamicObject)this.getModel().getValue(STARTDATE)).getString("number"));
        HashMap<String, Object> params = new HashMap<String, Object>(16);
        params.put(MODEL, model);
        params.put(STARTDATE, startdate);
        params.put(DATATYPE, datatype);
        params.put(ROLLVERSION, rollversion);
        params.put(VERSION, version);
        params.put(ACTVERSION, actualVersion);
        params.put(BASISTYPE, basistype);
        if (dynamicObjectDataType != null) {
            params.put("trgdatatype", dynamicObjectDataType.getLong("id"));
        }
        params.put("id", id);
        params.put("rollConfigNumber", number);
        params.put("rollConfigId", id);
        params.put("name", id);
        params.put("rolltemplateIds", SerializationUtils.serializeToBase64(rolltemplateIds));
        form.setCustomParams(params);
        this.getView().showForm(form);
    }

    private void toRollGist() {
        ListShowParameter listShowParameter = this.selImportReferencerecord();
        listShowParameter.setLookUp(true);
        listShowParameter.setMultiSelect(false);
        listShowParameter.setCustomParam("btn", (Object)REFERENCERECORD);
        Long modelId = this.getModelId();
        List<Long> rocords = this.getRocords(modelId);
        QFilter qf = new QFilter("id", "in", rocords);
        listShowParameter.getListFilterParameter().setFilter(qf);
        listShowParameter.getListFilterParameter().setOrderBy("rollconfig.number");
        listShowParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, REFERENCERECORD));
        this.getView().showForm((FormShowParameter)listShowParameter);
    }

    private void toHistoryRecord() {
        ListShowParameter listShowParameter = this.createRollinitrecordPage();
        this.getView().showForm((FormShowParameter)listShowParameter);
    }

    @Override
    public void beforeF7Select(BeforeF7SelectEvent f7) {
        String key;
        switch (key = ((BasedataEdit)f7.getSource()).getKey()) {
            case "startdate": 
            case "rollversion": 
            case "version": 
            case "datatype": 
            case "actversion": 
            case "rolltemplate": {
                this.setF7Filter(f7, key);
                break;
            }
        }
    }

    private void setF7Filter(BeforeF7SelectEvent f7, String actionId) {
        String dimensionNum;
        ListShowParameter showParameter = (ListShowParameter)f7.getFormShowParameter();
        ArrayList<QFilter> qFilterList = ((BasedataEdit)this.getControl(actionId)).getQFilters();
        if (qFilterList == null) {
            qFilterList = new ArrayList<QFilter>(16);
        }
        DynamicObject modelObj = (DynamicObject)this.getModel().getValue(MODEL);
        Long modelId = modelObj.getLong("id");
        qFilterList.add(new QFilter(MODEL, "=", (Object)modelId));
        if (ROLLTEMPLATE.equals(actionId)) {
            List<Long> dataSetIds = this.queryDataSetIds();
            qFilterList.add(new QFilter("templatestatus", "!=", (Object)"A"));
            qFilterList.add(new QFilter("dataset", "in", dataSetIds));
        }
        showParameter.setListFilterParameter(new ListFilterParameter(qFilterList, null));
        showParameter.setCustomParam(MODEL, (Object)modelId);
        f7.setFormShowParameter((FormShowParameter)showParameter);
        if (STARTDATE.equals(actionId)) {
            MemberF7Parameter f7Param = NewF7Utils.singleF7((Long)modelId, (DynamicObject)NewF7Utils.getDimension((Long)modelId, (String)SysDimensionEnum.BudgetPeriod.getNumber()), (String)ListSelectedRow.class.getName());
            f7Param.setOnlySelLeaf(true);
            NewF7Utils.openF7((BeforeF7SelectEvent)f7, (MemberF7Parameter)f7Param);
        } else if (!ROLLTEMPLATE.equals(actionId) && (dimensionNum = this.getDimNumByAction(actionId)) != null) {
            MemberF7Parameter f7Param = NewF7Utils.singleF7((Long)modelId, (DynamicObject)NewF7Utils.getDimension((Long)modelId, (String)dimensionNum), (String)ListSelectedRow.class.getName());
            f7Param.setOnlySelLeaf(true);
            NewF7Utils.openF7((BeforeF7SelectEvent)f7, (MemberF7Parameter)f7Param);
        }
    }

    protected String getDimNumByAction(String actionId) {
        String dimensionNum = null;
        switch (actionId) {
            case "startdate": {
                dimensionNum = SysDimensionEnum.BudgetPeriod.getNumber();
                break;
            }
            case "rollversion": 
            case "version": 
            case "actversion": {
                dimensionNum = SysDimensionEnum.Version.getNumber();
                break;
            }
            case "datatype": {
                dimensionNum = SysDimensionEnum.DataType.getNumber();
                break;
            }
        }
        return dimensionNum;
    }

    private void addBeforeF7SelectListeners(String ... keys) {
        for (String key : keys) {
            BasedataEdit basedataEdit = (BasedataEdit)this.getControl(key);
            basedataEdit.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        }
    }

    private ListShowParameter createRollinitrecordPage() {
        ListShowParameter listShowParameter = new ListShowParameter();
        listShowParameter.setFormId("eb_rollinitrecordlist");
        listShowParameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
        Long id = (Long)this.getView().getModel().getValue("id");
        QFilter qFilter = new QFilter("rollconfig", "=", (Object)id);
        listShowParameter.getListFilterParameter().setFilter(qFilter);
        listShowParameter.getListFilterParameter().setOrderBy("executedate desc");
        listShowParameter.setCustomParam("rollconfig", (Object)id);
        listShowParameter.setCustomParam(MODEL, (Object)String.valueOf(this.getModelId()));
        listShowParameter.setCustomParam("btn", (Object)"historyrecord");
        return listShowParameter;
    }

    private ListShowParameter selImportReferencerecord() {
        ListShowParameter listShowParameter = new ListShowParameter();
        listShowParameter.setFormId("bos_listf7");
        listShowParameter.setBillFormId("eb_rollinitrecord");
        listShowParameter.getOpenStyle().setShowType(ShowType.Modal);
        listShowParameter.setCaption(ResManager.loadKDString((String)"\u9009\u62e9\u8981\u5bfc\u5165\u7684\u6eda\u52a8\u6570\u636e", (String)"EbRollConfigPlugin_7", (String)"epm-eb-formplugin", (Object[])new Object[0]));
        Long modelId = ((DynamicObject)this.getModel().getValue(MODEL)).getLong("id");
        DynamicObjectCollection rollList = this.instance.queryRollConfigByModelId(modelId);
        ArrayList<Long> arrayList = new ArrayList<Long>(10);
        if (rollList != null && rollList.size() > 0) {
            for (DynamicObject dy : rollList) {
                arrayList.add(dy.getLong("id"));
            }
        }
        QFilter qFilter = new QFilter("rollconfig", "in", arrayList);
        listShowParameter.getListFilterParameter().setFilter(qFilter);
        listShowParameter.getListFilterParameter().setOrderBy("executedate desc");
        StyleCss css = new StyleCss();
        css.setWidth("960px");
        css.setHeight("580px");
        listShowParameter.getOpenStyle().setInlineStyleCss(css);
        return listShowParameter;
    }

    private void setStartDateFilter(Long modelId) {
        BasedataEdit f7Fiter = (BasedataEdit)this.getControl(STARTDATE);
        QFilter filter1 = new QFilter(MODEL, "=", (Object)modelId);
        QFilter filter2 = new QFilter("isleaf", "like", (Object)"1");
        ArrayList<QFilter> filterList = new ArrayList<QFilter>(16);
        filterList.add(filter1);
        filterList.add(filter2);
        f7Fiter.setQFilters(filterList);
    }

    @Override
    public Long getModelId() {
        String modelId = this.getPageCache().get(MODEL);
        if (StringUtils.isEmpty((String)modelId)) {
            return 0L;
        }
        return Long.valueOf(modelId);
    }

    public String getCurrentDimNumber(String controlKey) {
        if (STARTDATE.equals(controlKey)) {
            return "BudgetPeriod";
        }
        if (VERSION.equals(controlKey) || ROLLVERSION.equals(controlKey) || ACTVERSION.equals(controlKey)) {
            return "Version";
        }
        if (DATATYPE.equals(controlKey)) {
            return "DataType";
        }
        return null;
    }

    private DynamicObject queryDimMember(String entityNum, String memberNumber, Long modelId, String fields) {
        QFilter q1 = new QFilter(MODEL, "=", (Object)modelId);
        QFilter q2 = new QFilter("number", "=", (Object)memberNumber);
        DynamicObject dynamicObject = QueryServiceHelper.queryOne((String)entityNum, (String)fields, (QFilter[])new QFilter[]{q1.and(q2)});
        return dynamicObject;
    }

    private DynamicObject queryAppSceByNumber(Long modelId, String number, String name, String fields) {
        QFilter q = new QFilter("number", "=", (Object)number);
        QFilter q3 = new QFilter(MODEL, "=", (Object)modelId);
        return QueryServiceHelper.queryOne((String)"eb_applicationscenario", (String)fields, (QFilter[])new QFilter[]{q.and(q3)});
    }

    private List<Long> queryDataSetIds() {
        DynamicObject dynamicObject;
        Long modelId = IDUtils.toLong((Object)this.getPageCache().get(MODEL));
        DynamicObjectCollection dys = this.queryBusModel(modelId, (dynamicObject = this.queryAppSceByNumber(modelId, "002", ResManager.loadKDString((String)"\u6eda\u52a8\u9884\u7b97", (String)"EbRollConfigPlugin_2", (String)"epm-eb-formplugin", (Object[])new Object[0]), "id")).getLong("id"));
        if (dys == null || dys.size() == 0) {
            return null;
        }
        ArrayList<Long> busModelIds = new ArrayList<Long>(10);
        for (DynamicObject dy : dys) {
            busModelIds.add(dy.getLong("id"));
        }
        DynamicObjectCollection dataSets = this.queryDateSet(modelId, busModelIds);
        if (dataSets == null || dataSets.size() == 0) {
            return null;
        }
        ArrayList<Long> dataSetIds = new ArrayList<Long>(10);
        for (DynamicObject dy : dataSets) {
            dataSetIds.add(dy.getLong("id"));
        }
        return dataSetIds;
    }

    private DynamicObjectCollection queryBusModel(Long modelId, Long appScenarioId) {
        QFilter qf = new QFilter(MODEL, "=", (Object)modelId);
        QFilter qf2 = new QFilter("scenarioentry.appscenario", "=", (Object)appScenarioId);
        DynamicObjectCollection dys = QueryServiceHelper.query((String)"eb_businessmodel", (String)"id", (QFilter[])new QFilter[]{qf.and(qf2)});
        return dys;
    }

    private DynamicObjectCollection queryDateSet(Long modelId, List<Long> busModelIds) {
        QFilter qf = new QFilter(MODEL, "=", (Object)modelId);
        QFilter qf2 = new QFilter("businessmodel", "in", busModelIds);
        DynamicObjectCollection dys = QueryServiceHelper.query((String)"eb_dataset", (String)"id", (QFilter[])new QFilter[]{qf.and(qf2)});
        return dys;
    }

    private void refreshCache(DynamicObject dynamicObject) {
        Long modelId = this.getModelId();
        if (dynamicObject != null) {
            CubeUtils.get().checkDimension(modelId, Long.valueOf(dynamicObject.getLong("dimension_id")));
        }
        ModelCacheContext.getOrCreate((Long)modelId, (boolean)true);
    }

    private List<Long> getRocords(Long modelId) {
        ArrayList<Long> records = new ArrayList<Long>(10);
        String sql = "select max(c.fid) as fid from (select t1.fid, t1.frollconfig, t2.frollversion, t1.fexecutedate from t_eb_rollinit t1 join t_eb_rollconfig t2 on t1.frollconfig = t2.fid  where t1.fmodelid  = " + modelId + " \n) c group by c.frollconfig, c.frollversion";
        try (DataSet ds = DB.queryDataSet((String)"", (DBRoute)DBRoute.of((String)"epm"), (String)sql, null);){
            while (ds != null && ds.hasNext()) {
                Row row = ds.next();
                records.add(row.getLong("fid"));
            }
        }
        return records;
    }
}

