/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.formplugin.rollingbudget;

import java.util.ArrayList;
import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.resource.promptenum.MultiLangEnumBridge;
import kd.bos.entity.datamodel.ListField;
import kd.bos.entity.datamodel.ListSelectedRow;
import kd.bos.entity.filter.SortType;
import kd.bos.entity.list.IListDataProvider;
import kd.bos.entity.property.TextProp;
import kd.bos.form.FormShowParameter;
import kd.bos.form.ShowType;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.form.events.BeforeCreateListDataProviderArgs;
import kd.bos.form.events.HyperLinkClickArgs;
import kd.bos.list.BillList;
import kd.bos.list.ListShowParameter;
import kd.bos.list.events.CreateListDataProviderListener;
import kd.bos.list.events.ListRowClickEvent;
import kd.bos.list.events.ListRowClickListener;
import kd.bos.mvc.list.ListDataProvider;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.TimeServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.epm.eb.common.cache.IModelCacheHelper;
import kd.epm.eb.common.cache.ModelCacheContext;
import kd.epm.eb.common.cache.impl.Member;
import kd.epm.eb.common.enums.CopyDataEnum;
import kd.epm.eb.common.enums.SysDimensionEnum;
import kd.epm.eb.common.utils.CollectionUtils;
import kd.epm.eb.common.utils.IDUtils;
import kd.epm.eb.common.utils.OperationLogUtil;
import kd.epm.eb.common.utils.RollBudgetServiceHelper;
import kd.epm.eb.common.utils.StringUtils;
import kd.epm.eb.formplugin.AbstractListPlugin;

public class EbRollInitListPlugin
extends AbstractListPlugin
implements ListRowClickListener,
CreateListDataProviderListener {
    private static final String BILLLISTKEY = "billlistap";
    private static final String CANCEL = "cancel";
    private static final String REFRESH = "refresh";
    private RollBudgetServiceHelper instance = RollBudgetServiceHelper.getInstance();

    @Override
    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addItemClickListeners(new String[]{"toolbarap"});
    }

    public void initialize() {
        super.initialize();
        BillList billList = (BillList)this.getControl(BILLLISTKEY);
        billList.addCreateListDataProviderListener((CreateListDataProviderListener)this);
        billList.addListRowClickListener((ListRowClickListener)this);
    }

    @Override
    public void billListHyperLinkClick(HyperLinkClickArgs args) {
        Long rollinit = Long.valueOf(this.getPageCache().get("currentClickRowEntryKey"));
        QFilter qFilter = new QFilter("id", "=", (Object)rollinit);
        ArrayList<Long> templatelist = new ArrayList<Long>(16);
        DynamicObject rollinitrecord = QueryServiceHelper.queryOne((String)"eb_rollinitrecord", (String)"rollconfig", (QFilter[])new QFilter[]{qFilter});
        if (rollinitrecord != null) {
            Long rollconfigid = rollinitrecord.getLong("rollconfig");
            QFilter qFilter1 = new QFilter("id", "=", (Object)rollconfigid);
            DynamicObjectCollection rolltemList = QueryServiceHelper.query((String)"eb_rollconfig", (String)"rolltemplate.fbasedataid_id", (QFilter[])new QFilter[]{qFilter1});
            if (rolltemList != null) {
                for (DynamicObject tem : rolltemList) {
                    templatelist.add(tem.getLong("rolltemplate.fbasedataid_id"));
                }
            }
        }
        if ("rolltemplate".equals(args.getFieldName())) {
            this.toRolltemplateList(args, templatelist);
        } else if ("rollconfig_number".equals(args.getFieldName())) {
            FormShowParameter formShowParameter = new FormShowParameter();
            formShowParameter.setFormId("eb_rollinitrecord");
            formShowParameter.getOpenStyle().setShowType(ShowType.Modal);
            formShowParameter.getShowParameter().setCustomParam("templatelist", templatelist);
            formShowParameter.getShowParameter().setCustomParam("rollinitRecordId", (Object)rollinit);
            this.getView().showForm(formShowParameter);
            args.setCancel(true);
        }
    }

    public void listRowClick(ListRowClickEvent evt) {
        ListSelectedRow currentClickRow = evt.getCurrentListSelectedRow();
        String keyValue = currentClickRow == null ? null : String.valueOf(currentClickRow.getPrimaryKeyValue());
        this.getPageCache().put("currentClickRowEntryKey", keyValue);
    }

    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        String modelId = (String)this.getView().getFormShowParameter().getCustomParam("model");
        this.getPageCache().put("model", modelId);
        this.updateStatus();
    }

    private void toRolltemplateList(HyperLinkClickArgs args, List<Long> templatelist) {
        ListShowParameter listShowParameter = new ListShowParameter();
        listShowParameter.setFormId("eb_rolltemplatelist");
        listShowParameter.getOpenStyle().setShowType(ShowType.Modal);
        QFilter qFilter = null;
        if (templatelist != null && templatelist.size() > 0) {
            qFilter = new QFilter("id", "in", templatelist);
        }
        listShowParameter.getListFilterParameter().setFilter(qFilter);
        this.getView().showForm((FormShowParameter)listShowParameter);
        args.setCancel(true);
    }

    public void createListDataProvider(BeforeCreateListDataProviderArgs arg0) {
        arg0.setListDataProvider((IListDataProvider)new ListDataProvider(){

            public DynamicObjectCollection getData(int start, int limit) {
                List listFields = super.getListFields();
                for (ListField field : listFields) {
                    if (!field.getFieldName().contains("executedate")) continue;
                    field.setSortType(SortType.DESC);
                }
                DynamicObjectCollection allRows = super.getData(start, limit);
                ArrayList<Long> mainIds = new ArrayList<Long>(16);
                for (DynamicObject row : allRows) {
                    mainIds.add(row.getLong("id"));
                }
                DynamicObjectCollection rollinitrecordList = EbRollInitListPlugin.this.instance.getInitRecords(mainIds);
                if (rollinitrecordList == null || rollinitrecordList.size() == 0) {
                    return allRows;
                }
                HashMap templateMap = new HashMap(16);
                for (DynamicObject rollinitrecord : rollinitrecordList) {
                    DynamicObjectCollection rolltemList = EbRollInitListPlugin.this.getTemplateById(rollinitrecord.getLong("rollconfig.id"));
                    ArrayList<Long> list = new ArrayList<Long>(16);
                    if (rolltemList == null || rolltemList.size() <= 0) continue;
                    for (DynamicObject rolltem : rolltemList) {
                        list.add(rolltem.getLong("rolltemplate.fbasedataid_id"));
                    }
                    String templatesId = rollinitrecord.getString("rollconfig.id");
                    if (templateMap.get(templatesId) != null) continue;
                    DynamicObjectCollection templateRows = EbRollInitListPlugin.this.getTemplates(list);
                    templateRows.forEach(temRow -> {
                        String templateName = temRow.getString("name");
                        if (templateMap.get(templatesId) != null) {
                            templateMap.put(templatesId, (String)templateMap.get(templatesId) + "," + templateName);
                        } else {
                            templateMap.put(templatesId, templateName);
                        }
                    });
                }
                TextProp rolltemplate = null;
                DynamicObjectCollection dynamicObjectCollection = EbRollInitListPlugin.this.instance.queryRecordByConfigIds(mainIds);
                Map<Long, List<DynamicObject>> results = dynamicObjectCollection.stream().collect(Collectors.groupingBy(x -> x.getLong("id")));
                for (DynamicObject row : allRows) {
                    for (Map.Entry<Long, List<DynamicObject>> longListEntry : results.entrySet()) {
                        if (row.getLong("id") != longListEntry.getKey().longValue()) continue;
                        Map<String, List<DynamicObject>> source = longListEntry.getValue().stream().filter(x -> StringUtils.isNotEmpty((String)x.getString("entry_trial.source"))).collect(Collectors.groupingBy(x -> x.getString("entry_trial.source")));
                        EbRollInitListPlugin.this.handleTrialShow(row, source, "1", "trgaudittrial");
                        EbRollInitListPlugin.this.handleTrialShow(row, source, "0", "srcaudittrial");
                    }
                    String entryentityId = ((DynamicObject)row.get("rollconfig")).getString("id");
                    String temRow2 = (String)templateMap.get(entryentityId);
                    if (rolltemplate == null) {
                        rolltemplate = new TextProp();
                        rolltemplate.setName("rolltemplate");
                        row.getDataEntityType().getProperties().add((Object)rolltemplate);
                    }
                    row.set("rolltemplate", (Object)temRow2);
                }
                return allRows;
            }
        });
    }

    private void handleTrialShow(DynamicObject row, Map<String, List<DynamicObject>> source, String s, String srctrialshow) {
        List<DynamicObject> tarTrialdyns = source.get(s);
        if (CollectionUtils.isEmpty(tarTrialdyns)) {
            return;
        }
        ArrayList<String> tarTrialName = new ArrayList<String>(tarTrialdyns.size());
        IModelCacheHelper modelCacheHelper = ModelCacheContext.getOrCreate((Long)tarTrialdyns.get(0).getLong("model"));
        for (DynamicObject dynamicObject : tarTrialdyns) {
            Member member = modelCacheHelper.getMember(SysDimensionEnum.AuditTrail.getNumber(), null, Long.valueOf(dynamicObject.getLong("entry_trial.trial")));
            if (member == null) continue;
            tarTrialName.add(member.getName());
        }
        row.set(srctrialshow, (Object)String.join((CharSequence)",", tarTrialName));
    }

    public void itemClick(ItemClickEvent evt) {
        super.itemClick(evt);
        String key = evt.getItemKey();
        if (CANCEL.equals(key)) {
            BillList billList = (BillList)this.getControl(BILLLISTKEY);
            Object pkid = billList.getFocusRowPkId();
            if (pkid == null) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u4e00\u6761\u6570\u636e\u3002", (String)"EbRollInitListPlugin_0", (String)"epm-eb-formplugin", (Object[])new Object[0]));
                return;
            }
            Long id = (Long)pkid;
            DynamicObject record = BusinessDataServiceHelper.loadSingle((Object)id, (String)"eb_rollinitrecord");
            if (record != null) {
                if (!CopyDataEnum.EXECUTING.getIndex().equals(record.getString("executestate"))) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u975e\u6267\u884c\u4e2d\u7684\u6eda\u52a8\u590d\u5236\u4efb\u52a1\u65e0\u6cd5\u53d6\u6d88\u3002", (String)"EbRollInitListPlugin_1", (String)"epm-eb-formplugin", (Object[])new Object[0]));
                    return;
                }
                record.set("executestate", (Object)CopyDataEnum.CANCEL.getIndex());
                record.set("msg", (Object)ResManager.loadKDString((String)"\u5df2\u53d6\u6d88\u6267\u884c", (String)"EbRollInitListPlugin_2", (String)"epm-eb-formplugin", (Object[])new Object[0]));
                record.set("iscancel", (Object)true);
                SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{record});
                this.refreshBillList();
                MultiLangEnumBridge opName = new MultiLangEnumBridge("\u6eda\u52a8\u590d\u5236\u53d6\u6d88\u6267\u884c", "EbRollInitListPlugin_4", "epm-eb-formplugin");
                MultiLangEnumBridge opDescription = new MultiLangEnumBridge("\u6267\u884cID\uff1a%1$s\u3002", "EbRollInitListPlugin_5", "epm-eb-formplugin");
                OperationLogUtil.log((String)this.getView().getFormShowParameter().getAppId(), (String)this.getView().getFormShowParameter().getFormId(), null, (String)CANCEL, (MultiLangEnumBridge)opName, (MultiLangEnumBridge)opDescription, (String[])new String[]{IDUtils.toString((Object)id)});
            }
        } else if (REFRESH.equals(key)) {
            this.refreshBillList();
            this.updateStatus();
        }
    }

    private void updateStatus() {
        DynamicObjectCollection ds = QueryServiceHelper.query((String)"query_top1", (String)"eb_rollinitrecord", (String)"id,lastmodifytime,executestate", (QFilter[])new QFilter[]{new QFilter("model", "=", (Object)this.getModelId())}, (String)"executedate desc", (int)1);
        if (ds != null && ds.size() > 0) {
            DynamicObject d = (DynamicObject)ds.get(0);
            if (CopyDataEnum.EXECUTING.getIndex().equals(d.getString("executestate"))) {
                Date now = TimeServiceHelper.now();
                if (d.getDate("lastmodifytime") == null) {
                    Long id = d.getLong("id");
                    DynamicObject record = BusinessDataServiceHelper.loadSingle((Object)id, (String)"eb_rollinitrecord");
                    record.set("msg", (Object)ResManager.loadKDString((String)"\u6eda\u52a8\u590d\u5236\u6267\u884c\u5931\u8d25\u3002", (String)"EbRollInitListPlugin_3", (String)"epm-eb-formplugin", (Object[])new Object[0]));
                    record.set("lastmodifytime", (Object)TimeServiceHelper.now());
                    record.set("executestate", (Object)CopyDataEnum.FAILED.getIndex());
                    SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{record});
                    return;
                }
                Date begin = d.getDate("lastmodifytime");
                long second = (now.getTime() - begin.getTime()) / 1000L;
                if (second >= 1200L) {
                    Long id = d.getLong("id");
                    DynamicObject record = BusinessDataServiceHelper.loadSingle((Object)id, (String)"eb_rollinitrecord");
                    record.set("msg", (Object)ResManager.loadKDString((String)"\u6eda\u52a8\u590d\u5236\u6267\u884c\u5931\u8d25\u3002", (String)"EbRollInitListPlugin_3", (String)"epm-eb-formplugin", (Object[])new Object[0]));
                    record.set("executestate", (Object)CopyDataEnum.FAILED.getIndex());
                    SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{record});
                }
            }
        }
    }

    @Override
    public Long getModelId() {
        String modelId = this.getPageCache().get("model");
        if (StringUtils.isEmpty((String)modelId)) {
            return 0L;
        }
        return Long.valueOf(modelId);
    }

    private void refreshBillList() {
        QFilter qFilter1 = this.getqFilter();
        BillList billList = (BillList)this.getView().getControl(BILLLISTKEY);
        billList.setFilter(qFilter1);
        billList.setOrderBy("executedate desc");
        billList.setClearSelection(true);
        billList.refresh();
    }

    protected QFilter getqFilter() {
        String formId = this.getView().getFormShowParameter().getFormId();
        QFilter qFilter = null;
        if ("eb_rollinitrecordlist".equals(formId)) {
            String rollconfig = this.getView().getFormShowParameter().getCustomParam("rollconfig").toString();
            qFilter = new QFilter("rollconfig", "=", (Object)Long.valueOf(rollconfig));
        } else {
            List<Long> configIds = this.getConfigIds();
            qFilter = new QFilter("rollconfig", "in", configIds);
        }
        return qFilter;
    }

    private List<Long> getConfigIds() {
        DynamicObjectCollection rollList = this.instance.queryRollConfigByModelId(this.getModelId());
        ArrayList<Long> arrayList = new ArrayList<Long>(10);
        if (rollList == null || rollList.size() == 0) {
            return null;
        }
        for (DynamicObject dy : rollList) {
            arrayList.add(dy.getLong("id"));
        }
        return arrayList;
    }

    private DynamicObjectCollection getTemplates(List<Long> list) {
        QFilter q2 = new QFilter("id", "in", list);
        DynamicObjectCollection templateRows = QueryServiceHelper.query((String)"eb_templateentity", (String)"id, name, number", (QFilter[])new QFilter[]{q2});
        return templateRows;
    }

    private DynamicObjectCollection getTemplateById(Long id) {
        QFilter q1 = new QFilter("id", "=", (Object)id);
        DynamicObjectCollection rolltemList = QueryServiceHelper.query((String)"eb_rollconfig", (String)"id, rolltemplate.id, rolltemplate.fbasedataid_id", (QFilter[])new QFilter[]{q1});
        return rolltemList;
    }
}

