/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.formplugin.rollingbudget;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.UUID;
import java.util.stream.Collectors;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.resource.promptenum.MultiLangEnumBridge;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.ListSelectedRow;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.exception.KDBizException;
import kd.bos.form.CloseCallBack;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.FormConfig;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.ShowType;
import kd.bos.form.control.Control;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.lang.Lang;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.olap.dataSources.SelectCommandInfo;
import kd.bos.orm.query.QFilter;
import kd.bos.schedule.api.JobInfo;
import kd.bos.schedule.api.JobType;
import kd.bos.schedule.form.JobForm;
import kd.bos.schedule.form.JobFormInfo;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.TimeServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.epm.eb.business.memberf7.NewF7Utils;
import kd.epm.eb.common.cache.IModelCacheHelper;
import kd.epm.eb.common.cache.ModelCacheContext;
import kd.epm.eb.common.cache.impl.BaseCache;
import kd.epm.eb.common.cache.impl.Dataset;
import kd.epm.eb.common.cache.impl.Dimension;
import kd.epm.eb.common.cache.impl.Model;
import kd.epm.eb.common.enums.CopyDataEnum;
import kd.epm.eb.common.enums.SysDimensionEnum;
import kd.epm.eb.common.member.f7.MemberF7Parameter;
import kd.epm.eb.common.model.Member;
import kd.epm.eb.common.shrek.controller.ShrekOlapReader;
import kd.epm.eb.common.shrek.controller.ShrekOlapServiceHelper;
import kd.epm.eb.common.utils.CollectionUtils;
import kd.epm.eb.common.utils.DatasetServiceHelper;
import kd.epm.eb.common.utils.IDUtils;
import kd.epm.eb.common.utils.LogStats;
import kd.epm.eb.common.utils.OperationLogUtil;
import kd.epm.eb.common.utils.QFBuilder;
import kd.epm.eb.common.utils.StringUtils;
import kd.epm.eb.common.utils.UserUtils;
import kd.epm.eb.formplugin.AbstractFormPlugin;
import kd.epm.eb.formplugin.rollingbudget.RollInitObject;
import kd.epm.eb.formplugin.rollingbudget.dto.RollBudgetRequest;
import org.jetbrains.annotations.NotNull;

public class EbRollInitV2Plugin
extends AbstractFormPlugin {
    private static final Log log = LogFactory.getLog(EbRollInitV2Plugin.class);
    private static final String SRCAUDITTRIAL = "srcaudittrial";
    private static final String TRGAUDITTRIAL = "trgaudittrial";
    private static final String RUN = "barexecute";
    private static final String BACK_RUN = "backrun";
    private static final String PROGRESS_PAGE = "progresspage";
    private static final String CACHEKEY_PROGRESS = "cache_progress";
    private static final int HEART_RATE = 1200;
    private static final String FLAG_MSG = "existOlapData";
    private static final String SRC_ENTITY = "srcentity";
    private static final String TAR_ENTITY = "tarentity";
    private static final String SRC_TRIAL = "srctrial";
    private static final String TAR_TRIAL = "tartrial";
    private static final String CONFIG_FAIL = "2";
    public static final int MAX_MONTH = 60;
    public static final String[] DIMARRAY = new String[]{SysDimensionEnum.DataType.getNumber(), SysDimensionEnum.BudgetPeriod.getNumber(), SysDimensionEnum.AuditTrail.getNumber(), SysDimensionEnum.Version.getNumber()};

    @Override
    public void registerListener(EventObject e) {
        super.registerListener(e);
        super.addItemClickListeners(new String[]{"toolbarap"});
        super.addClickListeners(new String[]{SRCAUDITTRIAL, TRGAUDITTRIAL});
    }

    public void click(EventObject evt) {
        super.click(evt);
        Control source = (Control)evt.getSource();
        switch (source.getKey()) {
            case "srcaudittrial": {
                this.toAudittrialList(SRCAUDITTRIAL);
                break;
            }
            case "trgaudittrial": {
                this.toAudittrialList(TRGAUDITTRIAL);
                break;
            }
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    public void itemClick(ItemClickEvent evt) {
        super.itemClick(evt);
        String key = evt.getItemKey();
        if (RUN.equals(key)) {
            RollInitObject rollInitObject = this.createRollInitObject();
            if (this.checkCopyRunning(rollInitObject)) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u5f53\u524d\u4f53\u7cfb\u5b58\u5728\u6b63\u5728\u6267\u884c\u7684\u590d\u5236\u4efb\u52a1\uff0c\u8bf7\u7a0d\u540e\u91cd\u8bd5", (String)"EbRollInitV2Plugin_0", (String)"epm-eb-formplugin", (Object[])new Object[0]));
                return;
            }
            String msg = this.check(rollInitObject);
            if (StringUtils.isNotEmpty((String)msg)) {
                if (!FLAG_MSG.equals(msg)) {
                    this.getView().showTipNotification(msg);
                    return;
                }
                this.getView().showConfirm(ResManager.loadKDString((String)"\u76ee\u6807\u7ef4\u5ea6\u7ec4\u5408\u4e0b\u5df2\u7ecf\u5b58\u5728\u6570\u636e\uff0c\u7ee7\u7eed\u6267\u884c\u5c06\u8986\u76d6\u5df2\u6709\u6570\u636e\uff0c\u8bf7\u786e\u8ba4\u3002", (String)"EbRollInitV2Plugin_1", (String)"epm-eb-formplugin", (Object[])new Object[0]), MessageBoxOptions.OKCancel, new ConfirmCallBackListener("copy_comfirm", (IFormPlugin)this));
            } else {
                this.beginExecute(key, rollInitObject, false);
            }
            String id = this.getPageCache().get("id");
            MultiLangEnumBridge opName = new MultiLangEnumBridge("\u6eda\u52a8\u9884\u7b97\u521d\u59cb\u5316", "EbRollInitV2Plugin_25", "epm-eb-formplugin");
            MultiLangEnumBridge opDesc = new MultiLangEnumBridge("\u521d\u59cb\u5316ID\uff1a%1$s\u3002", "EbRollInitV2Plugin_26", "epm-eb-formplugin");
            OperationLogUtil.log((String)this.getBizAppId(), (String)this.getBizEntityNumber(), null, (String)"init", (MultiLangEnumBridge)opName, (MultiLangEnumBridge)opDesc, (String[])new String[]{id});
        }
    }

    private JobInfo createJobInfo(RollBudgetRequest rollBudgetRequest, IFormView formView) {
        JobInfo jobInfo = new JobInfo();
        jobInfo.setRunByLang(Lang.get());
        jobInfo.setTaskClassname("kd.epm.eb.formplugin.rollingbudget.job.RollBudgetTask");
        String jobName = ResManager.loadKDString((String)"\u6eda\u52a8\u9884\u7b97", (String)"EbRollInitV2Plugin_27", (String)"epm-eb-formplugin", (Object[])new Object[0]);
        jobInfo.setName(jobName);
        jobInfo.setId(UUID.randomUUID().toString());
        jobInfo.setCanStop(Boolean.valueOf(true));
        jobInfo.setFailNotify(true);
        jobInfo.setTimeout(3600);
        jobInfo.setOverTime(true);
        jobInfo.setExecuteTime(3600);
        jobInfo.setJobType(JobType.REALTIME);
        jobInfo.setRunByUserId(UserUtils.getUserId().longValue());
        jobInfo.setAppId(formView.getFormShowParameter().getServiceAppId());
        jobInfo.setFailNotify(true);
        jobInfo.setSuccessNotify(true);
        HashMap<String, Object> customParams = new HashMap<String, Object>(16);
        customParams.put("pageId", formView.getPageId());
        customParams.put("appId", formView.getFormShowParameter().getServiceAppId());
        FormConfig formConfig = formView.getFormShowParameter().getFormConfig();
        customParams.put("formConfig", formConfig.getEntityTypeId());
        customParams.put("parentPageId", formView.getFormShowParameter().getPageId());
        customParams.put("rootPageId", formView.getFormShowParameter().getRootPageId());
        customParams.put("modelId", rollBudgetRequest.getModelId());
        customParams.put("schemeNumbers", SerializationUtils.toJsonString(rollBudgetRequest.getSchemeNumbers()));
        customParams.put("transportLogId", rollBudgetRequest.getTransportLogId());
        customParams.put("loginIp", RequestContext.get().getLoginIP());
        customParams.put("initType", (String)this.getModel().getValue("inittype"));
        customParams.put("hasData", rollBudgetRequest.getHasData());
        customParams.put("srcAuditTrailNumbers", SerializationUtils.toJsonString(rollBudgetRequest.getSrcAuditTrailNumbers()));
        customParams.put("tarAuditTrailNumbers", SerializationUtils.toJsonString(rollBudgetRequest.getTarAuditTrailNumbers()));
        jobInfo.setParams(customParams);
        return jobInfo;
    }

    private boolean checkCopyRunning(RollInitObject rollInitObject) {
        DynamicObjectCollection ds = QueryServiceHelper.query((String)"query_top1", (String)"eb_rollinitrecord", (String)"id,lastmodifytime,executestate", (QFilter[])new QFilter[]{new QFilter("model", "=", (Object)this.getModelId())}, (String)"executedate desc", (int)1);
        if (ds != null && ds.size() > 0) {
            DynamicObject d = (DynamicObject)ds.get(0);
            if (CopyDataEnum.EXECUTING.getIndex().equals(d.getString("executestate"))) {
                rollInitObject.setLogRecordId(d.getLong("id"));
                Date now = TimeServiceHelper.now();
                if (d.getDate("lastmodifytime") == null) {
                    this.saveExecuteLog(rollInitObject, ResManager.loadKDString((String)"\u6570\u636e\u590d\u5236\u5931\u8d25", (String)"EbRollInitV2Plugin_2", (String)"epm-eb-formplugin", (Object[])new Object[0]), CopyDataEnum.FAILED.getIndex());
                    this.updateInitStatus(CONFIG_FAIL);
                    return false;
                }
                Date begin = d.getDate("lastmodifytime");
                long second = (now.getTime() - begin.getTime()) / 1000L;
                if (second >= 1200L) {
                    this.saveExecuteLog(rollInitObject, ResManager.loadKDString((String)"\u6570\u636e\u590d\u5236\u5931\u8d25", (String)"EbRollInitV2Plugin_2", (String)"epm-eb-formplugin", (Object[])new Object[0]), CopyDataEnum.FAILED.getIndex());
                    this.updateInitStatus(CONFIG_FAIL);
                } else {
                    return true;
                }
            }
        }
        return false;
    }

    private void beginExecute(String key, RollInitObject rollInitObject, boolean hasData) {
        String loginIP = RequestContext.getOrCreate().getLoginIP();
        RollBudgetRequest rollBudgetRequest = new RollBudgetRequest();
        rollBudgetRequest.setModelId(this.getModelId());
        String rollConfigNumber = this.getPageCache().get("rollConfigNumber");
        rollBudgetRequest.setSchemeNumbers(Lists.newArrayList((Object[])new String[]{rollConfigNumber}));
        rollBudgetRequest.setInitType((String)this.getModel().getValue("inittype"));
        rollBudgetRequest.setLoginIp(loginIP);
        rollBudgetRequest.setHasData(hasData);
        rollBudgetRequest.setTarAuditTrailNumbers(rollInitObject.getTarTrial().getMembers().stream().map(x -> x.getNumber()).collect(Collectors.toList()));
        rollBudgetRequest.setSrcAuditTrailNumbers(rollInitObject.getSrcTrial().getMembers().stream().map(x -> x.getNumber()).collect(Collectors.toList()));
        JobInfo jobInfo = this.createJobInfo(rollBudgetRequest, this.getView());
        JobFormInfo jobFormInfo = this.createJobFormInfo(jobInfo, this.getView(), this);
        JobForm.dispatch((JobFormInfo)jobFormInfo, (IFormView)this.getView());
        if (BACK_RUN.equals(key)) {
            this.getView().close();
        } else {
            this.openCopyProgressPage(rollInitObject);
        }
    }

    private JobFormInfo createJobFormInfo(JobInfo jobInfo, IFormView formView, AbstractFormPlugin abstractFormPlugin) {
        JobFormInfo jobFormInfo = new JobFormInfo(jobInfo);
        jobFormInfo.setJobInfo(jobInfo);
        String caption = ResManager.loadKDString((String)"\u6eda\u52a8\u9884\u7b97", (String)"EbRollInitV2Plugin_27", (String)"epm-eb-formplugin", (Object[])new Object[0]);
        jobFormInfo.setCaption(caption);
        jobFormInfo.setCanBackground(true);
        jobFormInfo.setTimeout(3600);
        jobFormInfo.setClickClassName("kd.epm.eb.formplugin.rollingbudget.job.RollBudgetTaskClick");
        jobFormInfo.setCloseCallBack(new CloseCallBack((IFormPlugin)abstractFormPlugin, "rollBudgetTaskAction"));
        jobFormInfo.setParentPageId(formView.getFormShowParameter().getPageId());
        jobFormInfo.setRootPageId(formView.getFormShowParameter().getRootPageId());
        return jobFormInfo;
    }

    private RollInitObject createRollInitObject() {
        DynamicObject srcDataTypeObj = (DynamicObject)this.getModel().getValue("srcdatatype");
        DynamicObject tarDataTypeObj = (DynamicObject)this.getModel().getValue("trgdatatype");
        DynamicObject srcVersionObj = (DynamicObject)this.getModel().getValue("srcversion");
        DynamicObject tarVersionObj = (DynamicObject)this.getModel().getValue("trgversion");
        DynamicObject beginPeriod = (DynamicObject)this.getModel().getValue("rollstartdate");
        DynamicObject actualVersionObj = (DynamicObject)this.getModel().getValue("actualversion");
        DynamicObject actualDatatypeObj = (DynamicObject)this.getModel().getValue("actualdatatype");
        DynamicObjectCollection src_entity = this.getModel().getEntryEntity(SRC_ENTITY);
        DynamicObjectCollection tar_entity = this.getModel().getEntryEntity(TAR_ENTITY);
        if (srcDataTypeObj == null || tarDataTypeObj == null || beginPeriod == null || srcVersionObj == null || tarVersionObj == null || actualVersionObj == null || actualDatatypeObj == null) {
            throw new KDBizException(ResManager.loadKDString((String)"\u9875\u9762\u7ef4\u5ea6\u7ec4\u5408\u672a\u9009\u62e9\u5b8c\u6574\u3002", (String)"EbRollInitV2Plugin_3", (String)"epm-eb-formplugin", (Object[])new Object[0]));
        }
        if (src_entity == null && tar_entity != null || src_entity != null && tar_entity == null) {
            throw new KDBizException(ResManager.loadKDString((String)"\u9875\u9762\u7ef4\u5ea6\u7ec4\u5408\u672a\u9009\u62e9\u5b8c\u6574\u3002", (String)"EbRollInitV2Plugin_3", (String)"epm-eb-formplugin", (Object[])new Object[0]));
        }
        kd.epm.eb.common.model.Dimension srcDataType = new kd.epm.eb.common.model.Dimension();
        srcDataType.setNumber(SysDimensionEnum.DataType.getNumber());
        srcDataType.getMembers().add(new Member(Long.valueOf(srcDataTypeObj.getLong("id")), null, srcDataTypeObj.getString("number")));
        kd.epm.eb.common.model.Dimension tarDataType = new kd.epm.eb.common.model.Dimension();
        tarDataType.setNumber(SysDimensionEnum.DataType.getNumber());
        tarDataType.getMembers().add(new Member(Long.valueOf(tarDataTypeObj.getLong("id")), null, tarDataTypeObj.getString("number")));
        kd.epm.eb.common.model.Dimension srcVersion = new kd.epm.eb.common.model.Dimension();
        srcVersion.setNumber(SysDimensionEnum.Version.getNumber());
        srcVersion.getMembers().add(new Member(Long.valueOf(srcVersionObj.getLong("id")), null, srcVersionObj.getString("number")));
        kd.epm.eb.common.model.Dimension tarVersion = new kd.epm.eb.common.model.Dimension();
        tarVersion.setNumber(SysDimensionEnum.Version.getNumber());
        tarVersion.getMembers().add(new Member(Long.valueOf(tarVersionObj.getLong("id")), null, tarVersionObj.getString("number")));
        kd.epm.eb.common.model.Dimension srcAT = new kd.epm.eb.common.model.Dimension();
        srcAT.setNumber(SysDimensionEnum.AuditTrail.getNumber());
        kd.epm.eb.common.model.Dimension tarAT = new kd.epm.eb.common.model.Dimension();
        tarAT.setNumber(SysDimensionEnum.AuditTrail.getNumber());
        if (CollectionUtils.isEmpty((Collection)src_entity) && CollectionUtils.isEmpty((Collection)tar_entity)) {
            Iterator modelCacheHelper = ModelCacheContext.getOrCreate((Long)this.getModelId());
            List members = modelCacheHelper.getMembers(0L, SysDimensionEnum.AuditTrail.getNumber());
            if (CollectionUtils.isEmpty((Collection)members)) {
                throw new KDBizException(ResManager.loadKDString((String)"\u9875\u9762\u7ef4\u5ea6\u7ec4\u5408\u672a\u9009\u62e9\u5b8c\u6574\u3002", (String)"EbRollInitV2Plugin_3", (String)"epm-eb-formplugin", (Object[])new Object[0]));
            }
            Set srcMembers = members.stream().filter(x -> x.getLevel() > 1 && x.isEnable() && !x.isDisable()).map(x -> new Member(x.getId(), null, x.getNumber())).collect(Collectors.toSet());
            srcAT.getMembers().addAll(srcMembers);
            tarAT.getMembers().addAll(srcMembers);
            List srcaudittrialIds = srcMembers.stream().map(x -> x.getId().toString()).collect(Collectors.toList());
            this.getPageCache().put("srcaudittrialIds", SerializationUtils.serializeToBase64(srcaudittrialIds));
            this.getPageCache().put("trgaudittrialIds", SerializationUtils.serializeToBase64(srcaudittrialIds));
        } else {
            for (DynamicObject dynamicObject : src_entity) {
                DynamicObject srcTrialObj = dynamicObject.getDynamicObject(SRC_TRIAL);
                srcAT.getMembers().add(new Member(Long.valueOf(srcTrialObj.getLong("id")), null, srcTrialObj.getString("number")));
            }
            for (DynamicObject dynamicObject : tar_entity) {
                DynamicObject tarTrialObj = dynamicObject.getDynamicObject(TAR_TRIAL);
                tarAT.getMembers().add(new Member(Long.valueOf(tarTrialObj.getLong("id")), null, tarTrialObj.getString("number")));
            }
        }
        Map<String, List<Member>> periodMap = this.getPeriodMap(beginPeriod, (String)this.getModel().getValue("inittype"));
        List<Member> nextPeriods = periodMap.get("next");
        kd.epm.eb.common.model.Dimension srcPeriod = new kd.epm.eb.common.model.Dimension();
        srcPeriod.setNumber(SysDimensionEnum.BudgetPeriod.getNumber());
        srcPeriod.getMembers().addAll(nextPeriods);
        kd.epm.eb.common.model.Dimension tarPeriod = new kd.epm.eb.common.model.Dimension();
        tarPeriod.setNumber(SysDimensionEnum.BudgetPeriod.getNumber());
        tarPeriod.getMembers().addAll(nextPeriods);
        RollInitObject rollInitObject = new RollInitObject(srcDataType, tarDataType, srcVersion, tarVersion, srcAT, tarAT, srcPeriod, tarPeriod);
        kd.epm.eb.common.model.Dimension acSrcDT = new kd.epm.eb.common.model.Dimension();
        acSrcDT.setNumber(SysDimensionEnum.DataType.getNumber());
        acSrcDT.getMembers().add(new Member(Long.valueOf(actualDatatypeObj.getLong("id")), null, actualDatatypeObj.getString("number")));
        kd.epm.eb.common.model.Dimension acSrcVersion = new kd.epm.eb.common.model.Dimension();
        acSrcVersion.setNumber(SysDimensionEnum.Version.getNumber());
        acSrcVersion.getMembers().add(new Member(Long.valueOf(actualVersionObj.getLong("id")), null, actualVersionObj.getString("number")));
        List<Member> prePeriods = periodMap.get("pre");
        kd.epm.eb.common.model.Dimension srcPrePeriod = new kd.epm.eb.common.model.Dimension();
        srcPrePeriod.setNumber(SysDimensionEnum.BudgetPeriod.getNumber());
        srcPrePeriod.getMembers().addAll(prePeriods);
        kd.epm.eb.common.model.Dimension tarPrePeriod = new kd.epm.eb.common.model.Dimension();
        tarPrePeriod.setNumber(SysDimensionEnum.BudgetPeriod.getNumber());
        tarPrePeriod.getMembers().addAll(prePeriods);
        rollInitObject.setActualSrcDataType(acSrcDT);
        rollInitObject.setActualSrcVersion(acSrcVersion);
        rollInitObject.setActualSrcPeriod(srcPrePeriod);
        rollInitObject.setActualTarPeriod(tarPrePeriod);
        String rollType = (String)this.getModel().getValue("basistype");
        rollInitObject.setRollType(rollType);
        rollInitObject.setIntiType((String)this.getModel().getValue("inittype"));
        return rollInitObject;
    }

    private Map<String, List<Member>> getPeriodMap(@NotNull DynamicObject beginPeriod, String initType) {
        LinkedHashMap<String, List<Member>> map = new LinkedHashMap<String, List<Member>>(16);
        long modelId = this.getModelId();
        DynamicObject period = BusinessDataServiceHelper.loadSingleFromCache((Object)beginPeriod.getPkValue(), (String)SysDimensionEnum.BudgetPeriod.getMemberTreemodel(), (String)"id, number, longnumber, level");
        if (period == null) {
            throw new KDBizException(ResManager.loadKDString((String)"\u6307\u5b9a\u5f00\u59cb\u6eda\u52a8\u7684\u8d77\u59cb\u671f\u95f4\u4e0d\u5b58\u5728\u3002", (String)"EbRollInitV2Plugin_24", (String)"epm-eb-formplugin", (Object[])new Object[0]));
        }
        String[] currPeriodNum = period.getString("number").split("\\.");
        if (currPeriodNum == null || currPeriodNum.length == 0) {
            throw new KDBizException(ResManager.loadKDString((String)"\u6307\u5b9a\u5f00\u59cb\u6eda\u52a8\u7684\u8d77\u59cb\u671f\u95f4\u4e0d\u5b58\u5728\u3002", (String)"EbRollInitV2Plugin_24", (String)"epm-eb-formplugin", (Object[])new Object[0]));
        }
        QFBuilder builder = new QFBuilder();
        builder.add(new QFilter("model", "=", (Object)modelId));
        builder.add(new QFilter("level", "=", (Object)beginPeriod.getInt("level")));
        builder.add(new QFilter("number", "like", (Object)(currPeriodNum[0] + '%')));
        builder.add(new QFilter("longnumber", "<", (Object)period.getString("longnumber")));
        ArrayList<Member> prePeriods = new ArrayList<Member>(60);
        DynamicObjectCollection pre = QueryServiceHelper.query((String)"epm_bperiodmembertree", (String)"id,number", (QFilter[])builder.toArrays(), (String)"longnumber desc", (int)60);
        if (pre != null) {
            for (DynamicObject dynamicObject : pre) {
                Member member = new Member(Long.valueOf(dynamicObject.getLong("id")), null, dynamicObject.getString("number"));
                prePeriods.add(member);
            }
        }
        map.put("pre", prePeriods);
        builder.clear();
        builder.add(new QFilter("model", "=", (Object)modelId));
        builder.add(new QFilter("level", "=", (Object)beginPeriod.getInt("level")));
        builder.add(new QFilter("longnumber", ">=", (Object)period.getString("longnumber")));
        DynamicObjectCollection next = QueryServiceHelper.query((String)"epm_bperiodmembertree", (String)"id,number", (QFilter[])builder.toArrays(), (String)"longnumber", (int)(60 - prePeriods.size()));
        if (next == null || next.size() == 0) {
            throw new KDBizException(ResManager.loadKDString((String)"\u671f\u95f4\u4e0d\u5b58\u5728", (String)"EbRollInitV2Plugin_5", (String)"epm-eb-formplugin", (Object[])new Object[0]));
        }
        ArrayList<Member> nextPeriods = new ArrayList<Member>(16);
        for (DynamicObject dynamicObject : next) {
            Member member = new Member(Long.valueOf(dynamicObject.getLong("id")), null, dynamicObject.getString("number"));
            nextPeriods.add(member);
        }
        if (CONFIG_FAIL.equals(initType)) {
            map.put("next", new ArrayList(16));
        } else {
            map.put("next", nextPeriods);
        }
        return map;
    }

    private void openCopyProgressPage(@NotNull RollInitObject rollInitObject) {
        FormShowParameter showParameter = new FormShowParameter();
        showParameter.setFormId("eb_copyprogress");
        showParameter.getOpenStyle().setShowType(ShowType.Modal);
        showParameter.setCaption(ResManager.loadKDString((String)"\u521d\u59cb\u5316\u6570\u636e\u590d\u5236\u4e2d\uff0c\u8bf7\u7a0d\u5019\u3002", (String)"EbRollInitV2Plugin_6", (String)"epm-eb-formplugin", (Object[])new Object[0]));
        showParameter.setCustomParam("msg", (Object)ResManager.loadKDString((String)"\u6b63\u5728\u6267\u884c\u6eda\u52a8\u9884\u7b97\u521d\u59cb\u5316\u590d\u5236\u3002", (String)"EbRollInitV2Plugin_7", (String)"epm-eb-formplugin", (Object[])new Object[0]));
        showParameter.setCustomParam(CACHEKEY_PROGRESS, (Object)rollInitObject.getProgressKey(this.getModelId()));
        CloseCallBack closeCallBack = new CloseCallBack((IFormPlugin)this, PROGRESS_PAGE);
        showParameter.setCloseCallBack(closeCallBack);
        showParameter.setShowTitle(true);
        this.getView().showForm(showParameter);
    }

    public void afterCreateNewData(EventObject e) {
        Map customParams = this.getView().getFormShowParameter().getCustomParams();
        IDataModel model = this.getModel();
        model.setValue("model", customParams.get("model"));
        model.setValue("rollstartdate", customParams.get("startdate"));
        model.setValue("srcdatatype", customParams.get("datatype"));
        model.setValue("srcversion", customParams.get("version"));
        model.setValue("trgdatatype", customParams.get("trgdatatype"));
        model.setValue("trgversion", customParams.get("rollversion"));
        model.setValue("actualversion", customParams.get("actversion"));
        model.setValue("basistype", customParams.get("basistype"));
        this.getPageCache().put("model", String.valueOf(customParams.get("model")));
        this.getPageCache().put("id", String.valueOf(customParams.get("id")));
        this.getPageCache().put("rollConfigNumber", customParams.get("rollConfigNumber").toString());
        this.getPageCache().put("rollConfigId", customParams.get("rollConfigId").toString());
        this.getPageCache().put("rolltemplateIds", (String)customParams.get("rolltemplateIds"));
        Long actualDataType = this.getActualDataTypeId();
        model.setValue("actualdatatype", (Object)actualDataType);
    }

    private Long getActualDataTypeId() {
        QFilter qf = new QFilter("model", "=", (Object)this.getModelId());
        QFilter qf1 = new QFilter("number", "=", (Object)"Actual");
        DynamicObject datatype = QueryServiceHelper.queryOne((String)"epm_datatypemembertree", (String)"id", (QFilter[])new QFilter[]{qf, qf1});
        if (datatype == null) {
            throw new KDBizException(ResManager.loadKDString((String)"\u4f53\u7cfb\u4e2d\u4e0d\u5b58\u5728\u7f16\u7801\u4e3a\u201cActual\u201d\u7684\u6570\u636e\u7c7b\u578b\u6210\u5458\u3002", (String)"EbRollInitV2Plugin_8", (String)"epm-eb-formplugin", (Object[])new Object[0]));
        }
        return datatype.getLong("id");
    }

    private void setValueToEntity(List<String> trialIds, boolean isSrc) {
        if (isSrc) {
            this.getModel().deleteEntryData(SRC_ENTITY);
            if (trialIds == null || trialIds.size() == 0) {
                return;
            }
            int[] rows = this.getModel().batchCreateNewEntryRow(SRC_ENTITY, trialIds.size());
            for (int row = 0; row < rows.length; ++row) {
                this.getModel().setValue(SRC_TRIAL, (Object)trialIds.get(row), row);
            }
        } else {
            this.getModel().deleteEntryData(TAR_ENTITY);
            if (trialIds == null || trialIds.size() == 0) {
                return;
            }
            int[] rows = this.getModel().batchCreateNewEntryRow(TAR_ENTITY, trialIds.size());
            for (int row = 0; row < rows.length; ++row) {
                this.getModel().setValue(TAR_TRIAL, (Object)trialIds.get(row), row);
            }
        }
    }

    @Override
    public void closedCallBack(ClosedCallBackEvent event) {
        super.closedCallBack(event);
        switch (event.getActionId()) {
            case "srcaudittrial": {
                this.clueCloseBack(event, SRCAUDITTRIAL, TRGAUDITTRIAL);
                break;
            }
            case "trgaudittrial": {
                this.clueCloseBack(event, TRGAUDITTRIAL, SRCAUDITTRIAL);
                break;
            }
            case "progresspage": {
                this.getView().close();
                break;
            }
            case "rollBudgetTaskAction": {
                Object backData = event.getReturnData();
                if (backData == null) break;
                Map backDataMap = (Map)backData;
                Map taskInfo = (Map)SerializationUtils.fromJsonString((String)((String)backDataMap.get("taskinfo")), HashMap.class);
                Map data = (Map)SerializationUtils.fromJsonString((String)((String)taskInfo.get("data")), HashMap.class);
                Object status = data.get("status");
                if (status == null) {
                    return;
                }
                if ("success".equals(status)) {
                    String msg = ResManager.loadKDString((String)"\u6eda\u52a8\u9884\u7b97\u521d\u59cb\u5316\u5b8c\u6210", (String)"EbRollInitV2Plugin_28", (String)"epm-eb-formplugin", (Object[])new Object[0]);
                    this.getView().showSuccessNotification(msg);
                    this.getView().close();
                    break;
                }
                this.getView().showTipNotification(data.get("exportResult").toString());
                break;
            }
        }
    }

    private Map<String, List<String>> getDimAndMem(@NotNull List<String> templates, @NotNull RollInitObject rollInitObject, @NotNull IModelCacheHelper modelCache, boolean isSrc, boolean isActual) {
        LinkedHashMap<String, List<String>> dimMap = new LinkedHashMap<String, List<String>>(16);
        return dimMap;
    }

    private Map<String, List<String>> getDimAndMem(@NotNull IModelCacheHelper modelCache, @NotNull Long datasetId, Map<String, List<Long>> viewIds, @NotNull RollInitObject rollInitObject, boolean isSrc, boolean isActual) {
        List dimensionList = modelCache.getDimensionList(datasetId);
        LinkedHashMap<String, List<String>> dimMap = new LinkedHashMap<String, List<String>>(dimensionList.size());
        for (Dimension dimension : dimensionList) {
            List tmpMembers;
            String dimNumber = dimension.getNumber();
            if (SysDimensionEnum.DataType.getNumber().equals(dimNumber)) {
                if (isSrc) {
                    kd.epm.eb.common.model.Dimension srcDataType = null;
                    srcDataType = isActual ? rollInitObject.getActualSrcDataType() : rollInitObject.getSrcDataType();
                    tmpMembers = srcDataType.getMembers().stream().map(Member::getNumber).collect(Collectors.toList());
                } else {
                    kd.epm.eb.common.model.Dimension tarDataType = rollInitObject.getTarDataType();
                    tmpMembers = tarDataType.getMembers().stream().map(Member::getNumber).collect(Collectors.toList());
                }
                List members = dimMap.computeIfAbsent(dimNumber, f -> Lists.newLinkedList());
                members.addAll(tmpMembers);
                continue;
            }
            if (SysDimensionEnum.BudgetPeriod.getNumber().equals(dimNumber)) {
                kd.epm.eb.common.model.Dimension srcPeriod = isActual ? rollInitObject.getActualSrcPeriod() : rollInitObject.getSrcPeriod();
                List list = srcPeriod.getMembers().stream().map(Member::getNumber).collect(Collectors.toList());
                dimMap.put(dimNumber, list);
                continue;
            }
            if (SysDimensionEnum.Version.getNumber().equals(dimNumber)) {
                if (isSrc) {
                    kd.epm.eb.common.model.Dimension srcVersion = null;
                    srcVersion = isActual ? rollInitObject.getActualSrcVersion() : rollInitObject.getSrcVersion();
                    tmpMembers = srcVersion.getMembers().stream().map(Member::getNumber).collect(Collectors.toList());
                } else {
                    tmpMembers = rollInitObject.getTarVersion().getMembers().stream().map(Member::getNumber).collect(Collectors.toList());
                }
                dimMap.put(dimNumber, tmpMembers);
                continue;
            }
            if (SysDimensionEnum.AuditTrail.getNumber().equals(dimNumber)) {
                tmpMembers = isSrc ? rollInitObject.getSrcTrial().getMembers().stream().map(Member::getNumber).collect(Collectors.toList()) : rollInitObject.getTarTrial().getMembers().stream().map(Member::getNumber).collect(Collectors.toList());
                dimMap.put(dimNumber, tmpMembers);
                continue;
            }
            if (SysDimensionEnum.ChangeType.getNumber().equals(dimNumber)) {
                List<Long> longs = viewIds.get(SysDimensionEnum.ChangeType.getNumber());
                if (!CollectionUtils.isNotEmpty(longs)) continue;
                ArrayList numbers = new ArrayList(16);
                for (Long aLong : longs) {
                    List allMmembers = modelCache.getMembers(aLong, SysDimensionEnum.ChangeType.getNumber());
                    List ebChanges = allMmembers.stream().filter(x -> !x.getNumber().equals("EBChanges") && !x.getLongNumber().startsWith("ChangeType!EBChanges!")).collect(Collectors.toList());
                    numbers.addAll(ebChanges.stream().map(BaseCache::getNumber).collect(Collectors.toList()));
                }
                dimMap.put(dimNumber, numbers);
                continue;
            }
            dimMap.put(dimNumber, this.queryMember(modelCache, dimension, viewIds));
        }
        return dimMap;
    }

    private List<String> queryMember(@NotNull IModelCacheHelper modelCacheHelper, @NotNull Dimension dimension, Map<String, List<Long>> viewIds) {
        List members = new ArrayList(16);
        if (viewIds.containsKey(dimension.getNumber())) {
            List<Long> longs = viewIds.get(dimension.getNumber());
            for (Long aLong : longs) {
                members.addAll(modelCacheHelper.getMembers(aLong, dimension.getNumber()));
            }
        } else {
            members = dimension.getLeafMembers();
        }
        return members.stream().map(BaseCache::getNumber).collect(Collectors.toList());
    }

    public void confirmCallBack(MessageBoxClosedEvent event) {
        super.confirmCallBack(event);
        String key = event.getCallBackId();
        if (MessageBoxResult.Yes.getValue() == event.getResult().getValue() && "copy_comfirm".equals(key)) {
            RollInitObject rollInitObject = this.createRollInitObject();
            this.beginExecute(key, rollInitObject, true);
        }
    }

    private void toAudittrialList(String actionId) {
        long modelId = this.getModelId();
        QFilter filter2 = new QFilter("use", "!=", (Object)"20");
        QFilter filter3 = new QFilter("use", "!=", (Object)"30");
        MemberF7Parameter f7Param = NewF7Utils.multipleF7((Long)modelId, (DynamicObject)NewF7Utils.getDimension((Long)modelId, (String)SysDimensionEnum.AuditTrail.getNumber()), (String)ListSelectedRow.class.getName());
        LinkedHashSet echoIds = new LinkedHashSet();
        if (SRCAUDITTRIAL.equals(actionId)) {
            String srcaudittrialIds = this.getPageCache().get("srcaudittrialIds");
            if (StringUtils.isNotEmpty((String)srcaudittrialIds)) {
                List srcTrialList = (List)SerializationUtils.deSerializeFromBase64((String)srcaudittrialIds);
                echoIds.addAll(IDUtils.toLongs((List)srcTrialList));
            }
        } else if (TRGAUDITTRIAL.equals(actionId)) {
            String trgaudittrialIds = this.getPageCache().get("trgaudittrialIds");
            if (StringUtils.isNotEmpty((String)trgaudittrialIds)) {
                List trgTrialList = (List)SerializationUtils.deSerializeFromBase64((String)trgaudittrialIds);
                echoIds.addAll(IDUtils.toLongs((List)trgTrialList));
            }
            f7Param.setOnlySelLeaf(true);
        }
        f7Param.setSelectIds(echoIds);
        f7Param.addCustomFilter(filter2.or(filter3));
        f7Param.setReturnAllData(true);
        NewF7Utils.openF7((IFormView)this.getView(), (MemberF7Parameter)f7Param, (CloseCallBack)new CloseCallBack((IFormPlugin)this, actionId));
    }

    private void clueCloseBack(ClosedCallBackEvent event, String actionId, String updateActionId) {
        if (Objects.nonNull(event.getReturnData())) {
            ListSelectedRowCollection returnData = (ListSelectedRowCollection)event.getReturnData();
            int size = 0;
            if (returnData == null || (size = returnData.size()) <= 0) {
                throw new KDBizException(ResManager.loadKDString((String)"\u672a\u9009\u62e9\u7ebf\u7d22\u3002", (String)"EbRollInitV2Plugin_9", (String)"epm-eb-formplugin", (Object[])new Object[0]));
            }
            if (TRGAUDITTRIAL.equals(actionId)) {
                for (ListSelectedRow row2 : returnData) {
                    Boolean isleaf = (Boolean)row2.getDataMap().get("isleaf");
                    if (isleaf.booleanValue()) continue;
                    throw new KDBizException(ResManager.loadKDString((String)"\u53ea\u5141\u8bb8\u52fe\u9009\u660e\u7ec6\u6210\u5458\u3002", (String)"EbRollInitV2Plugin_10", (String)"epm-eb-formplugin", (Object[])new Object[0]));
                }
            }
            StringBuilder namesb = new StringBuilder();
            ArrayList<String> ids = new ArrayList<String>(16);
            returnData.forEach(row -> {
                String names = row.getName();
                namesb.append(names);
                namesb.append(",");
                ids.add(row.toString());
            });
            String newName = namesb.substring(0, namesb.length() - 1);
            this.getModel().setValue(actionId, (Object)newName);
            if (size > 1) {
                if (SRCAUDITTRIAL.equals(actionId)) {
                    for (ListSelectedRow row3 : returnData) {
                        Boolean isleaf = (Boolean)row3.getDataMap().get("isleaf");
                        if (isleaf.booleanValue()) continue;
                        throw new KDBizException(ResManager.loadKDString((String)"\u6e90\u7ebf\u7d22\u591a\u9009\u53ea\u53ef\u9009\u62e9\u660e\u7ec6\u6210\u5458\uff0c\u8bf7\u91cd\u65b0\u9009\u62e9\u3002", (String)"EbRollInitV2Plugin_11", (String)"epm-eb-formplugin", (Object[])new Object[0]));
                    }
                }
                this.getModel().setValue(updateActionId, (Object)newName);
                this.setValueToEntity(ids, true);
                this.setValueToEntity(ids, false);
                this.getPageCache().put("srcaudittrialIds", SerializationUtils.serializeToBase64(ids));
                this.getPageCache().put("trgaudittrialIds", SerializationUtils.serializeToBase64(ids));
            } else {
                String updateActVal = (String)this.getModel().getValue(updateActionId);
                boolean contains = updateActVal.contains(",");
                Boolean isLeaf = (Boolean)returnData.get(0).getDataMap().get("isleaf");
                if (contains && isLeaf.booleanValue()) {
                    if (SRCAUDITTRIAL.equals(actionId)) {
                        this.getPageCache().put("trgaudittrialIds", SerializationUtils.serializeToBase64(ids));
                        this.setValueToEntity(ids, false);
                    } else {
                        this.getPageCache().put("srcaudittrialIds", SerializationUtils.serializeToBase64(ids));
                        this.setValueToEntity(ids, true);
                    }
                    this.getModel().setValue(updateActionId, (Object)newName);
                }
                if (SRCAUDITTRIAL.equals(actionId)) {
                    this.getPageCache().put("srcaudittrialIds", SerializationUtils.serializeToBase64(ids));
                    this.setValueToEntity(ids, true);
                } else {
                    this.getPageCache().put("trgaudittrialIds", SerializationUtils.serializeToBase64(ids));
                    this.setValueToEntity(ids, false);
                }
            }
        }
    }

    private Long saveExecuteLog(@NotNull RollInitObject rollInitObject, String msg, String status) {
        DynamicObject record = null;
        if (IDUtils.isNotNull((Long)rollInitObject.getLogRecordId())) {
            record = BusinessDataServiceHelper.loadSingleFromCache((Object)rollInitObject.getLogRecordId(), (String)"eb_rollinitrecord");
            boolean isCancel = record.getBoolean("iscancel");
            if (isCancel) {
                return -1L;
            }
        } else {
            record = BusinessDataServiceHelper.newDynamicObject((String)"eb_rollinitrecord");
            record.set("executor", (Object)UserUtils.getUserId());
            record.set("executedate", (Object)TimeServiceHelper.now());
            record.set("model", (Object)this.getModelId());
            record.set("inittype", (Object)rollInitObject.getIntiType());
            DynamicObjectCollection entry_trial = record.getDynamicObjectCollection("entry_trial");
            entry_trial.clear();
            this.fillTrialEntity(entry_trial);
            String configId = this.getPageCache().get("id");
            record.set("rollconfig", (Object)configId);
        }
        record.set("executestate", (Object)status);
        record.set("msg", (Object)msg);
        record.set("lastmodifytime", (Object)TimeServiceHelper.now());
        DynamicObject[] data = (DynamicObject[])SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{record});
        if (data != null && data.length > 0 && IDUtils.isNull((Long)rollInitObject.getLogRecordId())) {
            rollInitObject.setLogRecordId(data[0].getLong("id"));
        }
        return rollInitObject.getLogRecordId();
    }

    private void updateInitStatus(String initStatus) {
        String id = this.getPageCache().get("id");
        StringBuilder sql_update = new StringBuilder();
        sql_update.append("update t_eb_rollconfig set finitstatus = '").append(initStatus).append("' where fid = '").append(id).append("'");
        DB.execute((DBRoute)DBRoute.of((String)"epm"), (String)sql_update.toString());
    }

    private void fillTrialEntity(DynamicObjectCollection ent_trial) {
        DynamicObject row;
        String srcaudittrialIds = this.getPageCache().get("srcaudittrialIds");
        String trgaudittrialIds = this.getPageCache().get("trgaudittrialIds");
        if (StringUtils.isEmpty((String)srcaudittrialIds) || StringUtils.isEmpty((String)trgaudittrialIds)) {
            return;
        }
        List srcauditList = (List)SerializationUtils.deSerializeFromBase64((String)srcaudittrialIds);
        List trgauditList = (List)SerializationUtils.deSerializeFromBase64((String)trgaudittrialIds);
        if (srcauditList == null || srcauditList.size() == 0 || trgauditList == null || trgauditList.size() == 0) {
            return;
        }
        for (String str1 : srcauditList) {
            row = new DynamicObject(ent_trial.getDynamicObjectType());
            row.set("trial", (Object)str1);
            row.set("source", (Object)"0");
            ent_trial.add((Object)row);
        }
        for (String str2 : trgauditList) {
            row = new DynamicObject(ent_trial.getDynamicObjectType());
            row.set("trial", (Object)str2);
            row.set("source", (Object)"1");
            ent_trial.add((Object)row);
        }
    }

    @Override
    public Long getModelId() {
        String modelId = this.getPageCache().get("model");
        if (StringUtils.isEmpty((String)modelId)) {
            return 0L;
        }
        return Long.valueOf(modelId);
    }

    private String check(@NotNull RollInitObject rollInitObject) {
        kd.epm.eb.common.model.Dimension srcDataType = rollInitObject.getSrcDataType();
        kd.epm.eb.common.model.Dimension tarDataType = rollInitObject.getTarDataType();
        kd.epm.eb.common.model.Dimension srcTrial = rollInitObject.getSrcTrial();
        kd.epm.eb.common.model.Dimension tarTrial = rollInitObject.getTarTrial();
        kd.epm.eb.common.model.Dimension srcPeriod = rollInitObject.getSrcPeriod();
        if (srcDataType == null || tarDataType == null || srcTrial == null || tarTrial == null || srcPeriod == null) {
            return ResManager.loadKDString((String)"\u590d\u5236\u53c2\u6570\u672a\u914d\u7f6e\u5b8c\u6574\u3002", (String)"EbRollInitV2Plugin_18", (String)"epm-eb-formplugin", (Object[])new Object[0]);
        }
        if (srcTrial.getMembers().size() != tarTrial.getMembers().size()) {
            return ResManager.loadKDString((String)"\u6e90\u7248\u672c\u548c\u76ee\u6807\u7248\u672c\u7684\u7ebf\u7d22\u7ef4\u5ea6\u6210\u5458\u6570\u91cf\u4e0d\u5339\u914d\u3002", (String)"EbRollInitV2Plugin_19", (String)"epm-eb-formplugin", (Object[])new Object[0]);
        }
        return this.checkOlapData(rollInitObject);
    }

    private String checkOlapData(@NotNull RollInitObject rollInitObject) {
        long modelId = this.getModelId();
        IModelCacheHelper modelCache = ModelCacheContext.getOrCreate((Long)this.getModelId());
        Long[] datasetIds = null;
        Map<Long, List<String>> datasetAndTempMap = null;
        List<Dimension> pageDimension = this.getDimByArray(modelCache);
        if ("1".equals(rollInitObject.getRollType())) {
            datasetIds = DatasetServiceHelper.queryDatasetIds((Long)modelId);
        } else {
            datasetAndTempMap = this.getDatasetAndTempMap();
            datasetIds = datasetAndTempMap.keySet().toArray(new Long[datasetAndTempMap.size()]);
        }
        if (datasetIds == null || datasetIds.length == 0) {
            return ResManager.loadKDString((String)"\u6570\u636e\u96c6\u4e0d\u5b58\u5728", (String)"EbRollInitV2Plugin_20", (String)"epm-eb-formplugin", (Object[])new Object[0]);
        }
        ArrayList<Long> existNoDataDataSet = new ArrayList<Long>(datasetIds.length);
        Map<String, List<String>> memberMap = null;
        HashMap<String, List<Long>> viewIds = new HashMap(16);
        LogStats stats = new LogStats("budget-roll-log:");
        stats.addInfo("begin-check-data.");
        for (Long datasetId : datasetIds) {
            Dataset dataset = Dataset.of((DynamicObject)DatasetServiceHelper.loadDatasets((Long)datasetId));
            log.info("begin-check-dataset. id=" + datasetId + ", number=" + dataset.getNumber());
            stats.addInfo("begin-check-dataset. id=" + datasetId);
            viewIds = modelCache.getViewGroupViewsByDataSet(datasetId);
            if ("1".equals(rollInitObject.getRollType())) {
                memberMap = this.getDimAndMem(modelCache, datasetId, viewIds, rollInitObject, false, false);
            } else {
                if (datasetAndTempMap == null || datasetAndTempMap.get(datasetId) == null) continue;
                memberMap = this.getDimAndMem(datasetAndTempMap.get(datasetId), rollInitObject, modelCache, false, false);
            }
            List prePeriods = rollInitObject.getActualSrcPeriod().getMembers().stream().map(Member::getNumber).collect(Collectors.toList());
            memberMap.get(SysDimensionEnum.BudgetPeriod.getNumber()).addAll(prePeriods);
            if (memberMap == null) {
                stats.addInfo("member is null.");
                continue;
            }
            SelectCommandInfo select = new SelectCommandInfo();
            select.addDims(pageDimension.stream().map(BaseCache::getNumber).collect(Collectors.toList()).toArray(new String[0]));
            existNoDataDataSet.add(datasetId);
            boolean memberIsEmpty = false;
            for (Dimension dim : pageDimension) {
                List<String> _members = memberMap.get(dim.getNumber());
                if (SysDimensionEnum.Version.getNumber().equals(dim.getNumber())) {
                    String tarVersionNumber = ((Member)rollInitObject.getTarVersion().getMembers().get(0)).getNumber();
                    _members.removeIf(e -> !e.equals(tarVersionNumber));
                }
                if (!CollectionUtils.isEmpty(_members)) {
                    select.addFilter(dim.getNumber(), _members.toArray(new String[0]));
                    continue;
                }
                memberIsEmpty = true;
                break;
            }
            if (memberIsEmpty) continue;
            List longs = modelCache.getViewGroupViewsByDataSetAndDimNumber(dataset.getId(), SysDimensionEnum.ChangeType.getNumber());
            if (CollectionUtils.isNotEmpty((Collection)longs)) {
                ArrayList numbers = new ArrayList(16);
                for (Long aLong : longs) {
                    List allMmembers = modelCache.getMembers(aLong, SysDimensionEnum.ChangeType.getNumber());
                    List ebChanges = allMmembers.stream().filter(x -> !x.getNumber().equals("EBChanges") && !x.getLongNumber().startsWith("ChangeType!EBChanges!")).collect(Collectors.toList());
                    numbers.addAll(ebChanges.stream().map(BaseCache::getNumber).collect(Collectors.toList()));
                }
                select.addFilter(SysDimensionEnum.ChangeType.getNumber(), numbers.toArray(new String[0]));
            }
            ShrekOlapReader reader = ShrekOlapServiceHelper.queryReaderByExcludeDynamicCalc((Model)modelCache.getModelobj(), (Dataset)dataset, (SelectCommandInfo)select, (LogStats)stats);
            Object object = null;
            try {
                while (reader.hasNext()) {
                    Object[] values = reader.next();
                    if (values == null || values[0] == null) continue;
                    existNoDataDataSet.remove(datasetId);
                    break;
                }
            }
            catch (Throwable throwable) {
                object = throwable;
                throw throwable;
            }
            finally {
                if (reader != null) {
                    if (object != null) {
                        try {
                            reader.close();
                        }
                        catch (Throwable throwable) {
                            ((Throwable)object).addSuppressed(throwable);
                        }
                    } else {
                        reader.close();
                    }
                }
            }
            stats.addInfo("end-check-dataset.id=" + datasetId);
        }
        stats.addInfo("end-check-data.");
        log.info(stats.toString());
        if (existNoDataDataSet.size() == datasetIds.length) {
            return "";
        }
        return FLAG_MSG;
    }

    private List<Dimension> getDimByArray(@NotNull IModelCacheHelper modelCache) {
        ArrayList<Dimension> list = new ArrayList<Dimension>(DIMARRAY.length);
        for (String s : DIMARRAY) {
            Dimension dim = modelCache.getDimension(s);
            list.add(dim);
        }
        return list;
    }

    private Map<Long, List<String>> getDatasetAndTempMap() {
        String rolltemplateIds = this.getPageCache().get("rolltemplateIds");
        List templateIds = (List)SerializationUtils.deSerializeFromBase64((String)rolltemplateIds);
        if (templateIds == null || templateIds.isEmpty()) {
            return Collections.emptyMap();
        }
        QFilter[] filters = new QFilter[]{new QFilter("id", "in", (Object)templateIds)};
        LinkedHashMap<Long, List<String>> map = new LinkedHashMap<Long, List<String>>();
        try (DataSet ds = QueryServiceHelper.queryDataSet((String)"query-dataset-template", (String)"eb_templateentity", (String)"id,dataset,data", (QFilter[])filters, null);){
            if (ds != null) {
                for (Row row : ds) {
                    Long datasetId = row.getLong("dataset");
                    String data = row.getString("data");
                    List datas = map.computeIfAbsent(datasetId, f -> Lists.newLinkedList());
                    datas.add(data);
                }
            }
        }
        return map;
    }

    public void propertyChanged(PropertyChangedArgs e) {
        String key = e.getProperty().getName();
        ChangeData changeData = e.getChangeSet()[0];
        Object newValue = changeData.getNewValue();
        if (newValue == null || StringUtils.isEmpty((String)newValue.toString())) {
            if (SRCAUDITTRIAL.equals(key) && this.getModel().getValue(TRGAUDITTRIAL) != null) {
                this.getModel().setValue(TRGAUDITTRIAL, null);
                this.getPageCache().remove("srcaudittrialIds");
                this.getPageCache().remove("trgaudittrialIds");
                this.getModel().deleteEntryData(SRC_ENTITY);
                this.getModel().deleteEntryData(TAR_ENTITY);
            } else if (TRGAUDITTRIAL.equals(key) && this.getModel().getValue(SRCAUDITTRIAL) != null) {
                this.getModel().setValue(SRCAUDITTRIAL, null);
                this.getPageCache().remove("srcaudittrialIds");
                this.getPageCache().remove("trgaudittrialIds");
                this.getModel().deleteEntryData(SRC_ENTITY);
                this.getModel().deleteEntryData(TAR_ENTITY);
            }
        }
    }
}

