/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.formplugin.rollingbudget.job;

import com.alibaba.fastjson.JSON;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.exception.KDBizException;
import kd.bos.exception.KDException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.schedule.executor.AbstractTask;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.epm.eb.common.utils.StringUtils;
import kd.epm.eb.formplugin.rollingbudget.dto.RollBudgetRequest;
import kd.epm.eb.formplugin.rollingbudget.service.RollBudgetService;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.collections4.MapUtils;

public class RollBudgetTask
extends AbstractTask {
    private static final Log log = LogFactory.getLog(RollBudgetTask.class);
    private Long transportLogId;

    public void execute(RequestContext requestContext, Map<String, Object> map) throws KDException {
        log.info("\u6eda\u52a8\u9884\u7b97\u5b9a\u65f6\u4efb\u52a1\u53c2\u6570\uff1a" + JSON.toJSONString(map));
        HashMap<String, String> returnData = new HashMap<String, String>(16);
        if (map == null) {
            this.feedbackProgress(100);
            return;
        }
        Long modelId = MapUtils.getLong(map, (Object)"modelId");
        if (modelId == null) {
            String modelNumber = MapUtils.getString(map, (Object)"modelNumber");
            DynamicObject model = QueryServiceHelper.queryOne((String)"epm_model", (String)"id", (QFilter[])new QFilter("shownumber", "=", (Object)modelNumber).toArray());
            if (model == null) {
                throw new KDBizException(ResManager.loadResFormat((String)"\u7f16\u7801\u4e3a%1\u7684\u4f53\u7cfb\u4e0d\u5b58\u5728", (String)"DataIntegrationTaskBase_1", (String)"epm-eb-business", (Object[])new Object[]{modelNumber}));
            }
            modelId = model.getLong("id");
        }
        if (modelId == null) {
            throw new KDBizException(ResManager.loadKDString((String)"\u4f53\u7cfbid\u4e0d\u5b58\u5728\u3002", (String)"ModelDataUploadTask_3", (String)"epm-eb-formplugin", (Object[])new Object[0]));
        }
        RollBudgetRequest rollBudgetRequest = new RollBudgetRequest();
        rollBudgetRequest.setModelId(modelId);
        String initType = MapUtils.getString(map, (Object)"initType");
        initType = StringUtils.isEmpty((String)initType) ? "1" : initType;
        rollBudgetRequest.setInitType(initType);
        Boolean hasData = MapUtils.getBoolean(map, (Object)"hasData");
        hasData = hasData != null && hasData != false;
        rollBudgetRequest.setHasData(hasData);
        String schemeString = (String)map.get("schemeNumbers");
        if (StringUtils.isNotEmpty((String)schemeString)) {
            List schemeNumberList = (List)SerializationUtils.fromJsonString((String)schemeString, List.class);
            rollBudgetRequest.setSchemeNumbers(schemeNumberList);
        }
        ArrayList<String> tarAuditTrailNumbers = new ArrayList(16);
        String tarAuditTrailNumberJson = (String)map.get("tarAuditTrailNumbers");
        if (StringUtils.isNotEmpty((String)tarAuditTrailNumberJson)) {
            tarAuditTrailNumbers = (List)SerializationUtils.fromJsonString((String)tarAuditTrailNumberJson, List.class);
            rollBudgetRequest.setTarAuditTrailNumbers(tarAuditTrailNumbers);
        }
        List<String> srcAuditTrailNumbers = new ArrayList(16);
        String srcAuditTrailNumberJson = (String)map.get("srcAuditTrailNumbers");
        if (StringUtils.isNotEmpty((String)srcAuditTrailNumberJson)) {
            srcAuditTrailNumbers = (List)SerializationUtils.fromJsonString((String)srcAuditTrailNumberJson, List.class);
            rollBudgetRequest.setSrcAuditTrailNumbers(srcAuditTrailNumbers);
        }
        if (srcAuditTrailNumbers.size() != tarAuditTrailNumbers.size()) {
            throw new KDBizException(ResManager.loadKDString((String)"\u6e90\u7248\u672c\u548c\u76ee\u6807\u7248\u672c\u7684\u7ebf\u7d22\u7ef4\u5ea6\u6210\u5458\u6570\u91cf\u4e0d\u5339\u914d\u3002", (String)"EbRollInitV2Plugin_19", (String)"epm-eb-formplugin", (Object[])new Object[0]));
        }
        if (srcAuditTrailNumbers.size() > 1 && !srcAuditTrailNumbers.equals(tarAuditTrailNumbers)) {
            throw new KDBizException(ResManager.loadKDString((String)"\u6e90\u7248\u672c\u548c\u76ee\u6807\u7248\u672c\u7684\u7ebf\u7d22\u591a\u9009\u65f6\u9700\u8981\u4e00\u4e00\u5bf9\u5e94\u3002", (String)"RollBudgetTask_3", (String)"epm-eb-formplugin", (Object[])new Object[0]));
        }
        if (map.get("transportLogId") != null) {
            this.transportLogId = (Long)map.get("transportLogId");
            rollBudgetRequest.setTransportLogId(this.transportLogId);
        }
        rollBudgetRequest.setLoginIp((String)map.get("loginIp"));
        String errorMessage = "";
        try {
            List<String> schemeNumbers = rollBudgetRequest.getSchemeNumbers();
            if (CollectionUtils.isEmpty(schemeNumbers)) {
                this.feedbackProgress(100);
                return;
            }
            RollBudgetService rollBudgetService = new RollBudgetService(rollBudgetRequest);
            this.feedbackProgress(0, ResManager.loadKDString((String)"\u6b63\u5728\u8fdb\u884c\u6eda\u52a8\u9884\u7b97", (String)"RollBudgetTask_1", (String)"epm-eb-formplugin", (Object[])new Object[0]), null);
            rollBudgetService.rollBudget();
            returnData.put("status", "success");
            this.feedbackProgress(100);
            Thread.sleep(0L);
        }
        catch (Exception e) {
            errorMessage = e instanceof KDBizException ? e.getMessage() : ResManager.loadKDString((String)"\u6eda\u52a8\u9884\u7b97\u53d1\u751f\u5f02\u5e38\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u67e5\u770b\u65e5\u5fd7\u3002", (String)"RollBudgetTask_2", (String)"epm-eb-formplugin", (Object[])new Object[0]);
            returnData.put("status", "failed");
            returnData.put("exportResult", errorMessage);
            log.error((Throwable)e);
        }
        this.feedbackCustomdata(returnData);
    }
}

