/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.formplugin.rpa;

import java.util.EventObject;
import java.util.List;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.OrmLocaleValue;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.ListSelectedRow;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.form.CloseCallBack;
import kd.bos.form.events.BeforeClosedEvent;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.form.operate.FormOperate;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.orm.query.QFilter;
import kd.epm.eb.business.memberf7.NewF7Utils;
import kd.epm.eb.business.rpa.dao.RpaEntityRefDao;
import kd.epm.eb.business.rpa.dao.RpaSchemeDao;
import kd.epm.eb.common.cache.IModelCacheHelper;
import kd.epm.eb.common.cache.ModelCacheContext;
import kd.epm.eb.common.enums.SysDimensionEnum;
import kd.epm.eb.common.member.f7.MemberF7Parameter;
import kd.epm.eb.common.utils.IDUtils;
import kd.epm.eb.common.utils.StringUtils;
import kd.epm.eb.formplugin.AbstractBasePlugin;

public class RpaEntityRefEditPlugin
extends AbstractBasePlugin
implements BeforeF7SelectListener {
    private static final String ENTITY = "entity";
    private static final String VIEW = "view";
    private static final String CLOSE_CALLBACK_ENTITY = "entityCloseCallback";

    @Override
    public void registerListener(EventObject e) {
        super.registerListener(e);
        BasedataEdit businessModel = (BasedataEdit)this.getView().getControl(ENTITY);
        businessModel.addBeforeF7SelectListener((BeforeF7SelectListener)this);
    }

    @Override
    public void beforeF7Select(BeforeF7SelectEvent e) {
        String key = e.getProperty().getName();
        if (ENTITY.equals(key)) {
            List entityIds = RpaEntityRefDao.getInstance().getEntityIds(this.getIntegrationId());
            DynamicObject entity = (DynamicObject)this.getModel().getValue(ENTITY);
            if (null != entity) {
                entityIds.remove(entity.getLong("id"));
            }
            QFilter qf = new QFilter("model", "=", (Object)this.getModelId());
            qf.and(new QFilter("id", "not in", (Object)entityIds));
            MemberF7Parameter f7Param = NewF7Utils.singleF7((Long)this.getModelId(), (DynamicObject)NewF7Utils.getDimension((Long)this.getModelId(), (String)SysDimensionEnum.Entity.getNumber()), (String)ListSelectedRow.class.getName());
            f7Param.setCanSelectRoot(false);
            f7Param.addCustomFilter(qf);
            f7Param.setBusModelId(this.getBizModelId());
            DynamicObject view = (DynamicObject)this.getModel().getValue(VIEW);
            if (view != null) {
                f7Param.setViewId(Long.valueOf(view.getLong("id")));
            } else {
                IModelCacheHelper modelCache = ModelCacheContext.getOrCreate((Long)this.getModelId());
                Long defaultViewID = modelCache.getViewByBusModelAndDimNumber(this.getBizModelId(), SysDimensionEnum.Entity.getNumber());
                f7Param.setViewId(defaultViewID);
                this.getModel().setValue(VIEW, (Object)defaultViewID);
            }
            f7Param.setEnableView(true);
            NewF7Utils.openF7((BeforeF7SelectEvent)e, (MemberF7Parameter)f7Param, (CloseCallBack)new CloseCallBack((IFormPlugin)this, CLOSE_CALLBACK_ENTITY));
        }
    }

    public void afterLoadData(EventObject e) {
        Object id = this.getModel().getValue("id");
        DynamicObject data = RpaEntityRefDao.getInstance().load(IDUtils.toLong((Object)id));
        if (RpaSchemeDao.getInstance().checkEntityByRpaSchemeRef(new DynamicObject[]{data})) {
            this.getView().setEnable(Boolean.FALSE, new String[]{ENTITY});
        }
    }

    public void afterBindData(EventObject e) {
        super.beforeBindData(e);
        this.getModel().setValue("model", (Object)this.getModelId());
        this.getModel().setValue("rpainte", (Object)this.getIntegrationId());
    }

    @Override
    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        super.beforeDoOperation(args);
        String opType = ((FormOperate)args.getSource()).getType();
        Long id = (Long)this.getView().getFormShowParameter().getCustomParam("id");
        if ("save".equals(opType)) {
            String number = (String)this.getModel().getValue("number");
            if (StringUtils.isEmpty((String)number)) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u586b\u5199\u4f01\u4e1a\u4ee3\u7801\u3002", (String)"RpaEntityRefEditPlugin_1", (String)"epm-eb-formplugin", (Object[])new Object[0]), Integer.valueOf(5000));
                args.setCancel(true);
                return;
            }
            OrmLocaleValue name = (OrmLocaleValue)this.getModel().getValue("name");
            if (StringUtils.isEmpty((String)name.getLocaleValue())) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u8f93\u5165\u4f01\u4e1a\u540d\u79f0\u3002", (String)"RpaEntityRefEditPlugin_2", (String)"epm-eb-formplugin", (Object[])new Object[0]));
                args.setCancel(true);
                return;
            }
            DynamicObject entity = (DynamicObject)this.getModel().getValue(ENTITY);
            if (null == entity) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u7ec4\u7ec7\u3002", (String)"RpaEntityRefEditPlugin_5", (String)"epm-eb-formplugin", (Object[])new Object[0]));
                args.setCancel(true);
                return;
            }
            if (RpaEntityRefDao.getInstance().entityNumberIsExists(id, Long.valueOf(entity.getLong("id")), this.getIntegrationId())) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u7ec4\u7ec7\u91cd\u590d\uff0c\u8bf7\u4fee\u6539\u3002", (String)"RpaEntityRefEditPlugin_6", (String)"epm-eb-formplugin", (Object[])new Object[0]), Integer.valueOf(5000));
                args.setCancel(true);
                return;
            }
            String reportType = (String)this.getModel().getValue("reporttype");
            if (RpaEntityRefDao.getInstance().numberIsExists(id, number, reportType, this.getIntegrationId())) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u4f01\u4e1a\u4ee3\u7801\u548c\u62a5\u8868\u7c7b\u578b\u4e0d\u80fd\u91cd\u590d\uff0c\u8bf7\u4fee\u6539\u3002", (String)"RpaEntityRefEditPlugin_4", (String)"epm-eb-formplugin", (Object[])new Object[0]), Integer.valueOf(5000));
                args.setCancel(true);
                return;
            }
        }
        if ("close".equals(opType)) {
            this.getModel().setDataChanged(false);
        }
    }

    @Override
    public void closedCallBack(ClosedCallBackEvent closedCallBackEvent) {
        ListSelectedRowCollection members;
        super.closedCallBack(closedCallBackEvent);
        String actionId = closedCallBackEvent.getActionId();
        if (CLOSE_CALLBACK_ENTITY.equals(actionId) && closedCallBackEvent.getReturnData() != null && closedCallBackEvent.getReturnData() instanceof ListSelectedRowCollection && (members = (ListSelectedRowCollection)closedCallBackEvent.getReturnData()).size() == 1) {
            for (ListSelectedRow member : members) {
                Long viewId = IDUtils.toLong(member.getDataMap().get("viewid"));
                this.getModel().setValue(VIEW, (Object)viewId);
                this.getModel().setValue(ENTITY, member.getPrimaryKeyValue());
            }
        }
    }

    public void beforeClosed(BeforeClosedEvent e) {
        super.beforeClosed(e);
        this.getModel().setDataChanged(false);
    }

    @Override
    public Long getModelId() {
        return (Long)this.getView().getFormShowParameter().getCustomParam("KEY_MODEL_ID");
    }

    private Long getIntegrationId() {
        return (Long)this.getView().getFormShowParameter().getCustomParam("integrationId");
    }

    private Long getBizModelId() {
        return (Long)this.getView().getFormShowParameter().getCustomParam("bizmodel");
    }
}

