/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.formplugin.rpa;

import com.alibaba.fastjson.JSON;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.stream.Collectors;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.exception.KDBizException;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.IClientViewProxy;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.control.AttachmentPanel;
import kd.bos.form.control.Control;
import kd.bos.form.control.events.UploadEvent;
import kd.bos.form.control.events.UploadListener;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.servicehelper.TimeServiceHelper;
import kd.epm.eb.business.rpa.dao.RpaEntityRefDao;
import kd.epm.eb.business.rpa.dao.RpaIntegrationDao;
import kd.epm.eb.business.rpa.dao.RpaSchemeDao;
import kd.epm.eb.business.rpa.entity.RpaEntityRef;
import kd.epm.eb.common.cache.DimMembPermHelper;
import kd.epm.eb.common.cache.IModelCacheHelper;
import kd.epm.eb.common.cache.ModelCacheContext;
import kd.epm.eb.common.cache.impl.Dimension;
import kd.epm.eb.common.cache.impl.Member;
import kd.epm.eb.common.enums.SysDimensionEnum;
import kd.epm.eb.common.utils.DimensionViewServiceHelper;
import kd.epm.eb.common.utils.IDUtils;
import kd.epm.eb.common.utils.ModelServiceHelper;
import kd.epm.eb.common.utils.UploadUtil;
import kd.epm.eb.common.utils.excel.BgExcelReader;
import kd.epm.eb.common.utils.excel.BgExcelWriter;
import kd.epm.eb.common.utils.excelImport.POIUtils;
import kd.epm.eb.formplugin.AbstractBasePlugin;
import kd.epm.eb.formplugin.rpa.constant.RpaEntityRefEnum;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.collections4.MapUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.time.DateFormatUtils;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;
import org.apache.poi.ss.usermodel.CellStyle;
import org.apache.poi.ss.usermodel.Workbook;
import org.apache.poi.xssf.usermodel.XSSFWorkbook;

public class RpaEntityRefImportPlugin
extends AbstractBasePlugin
implements UploadListener {
    private static final Log log = LogFactory.getLog(RpaEntityRefImportPlugin.class);
    private static final String IMPORT_FILE = "importFile";
    private static final String KEY_ATTACHMENT_PANEL = "attachment";
    private static final String REFRESH_CONFORM_CALLBACK = "refreshConformCallback";
    private static final String IMPORT_TYPE = "importtype";
    private static final String IMPORT_ADD = "1";
    private static final String IMPORT_COVER = "2";

    @Override
    public void registerListener(EventObject e) {
        super.registerListener(e);
        AttachmentPanel attachmentPanel = (AttachmentPanel)this.getView().getControl(KEY_ATTACHMENT_PANEL);
        attachmentPanel.addUploadListener((UploadListener)this);
        this.addClickListeners(new String[]{"btn_import", "btn_downtemp"});
    }

    public void click(EventObject evt) {
        super.click(evt);
        Control control = (Control)evt.getSource();
        String key = control.getKey();
        if ("btn_import".equals(key)) {
            if (this.getPageCache().get(IMPORT_FILE) == null) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u4e0a\u4f20\u6587\u4ef6\u3002", (String)"RpaEntityRefImportPlugin_1", (String)"epm-eb-formplugin", (Object[])new Object[0]));
                return;
            }
            String importType = (String)this.getModel().getValue(IMPORT_TYPE);
            if (IMPORT_ADD.equals(importType)) {
                this.importData(IMPORT_ADD);
            } else {
                this.getView().showConfirm(ResManager.loadKDString((String)"\u786e\u5b9a\u5bfc\u5165\u6570\u636e\u8fdb\u884c\u8ffd\u52a0\u5e76\u66f4\u65b0?", (String)"RpaEntityRefImportPlugin_2", (String)"epm-eb-formplugin", (Object[])new Object[0]), MessageBoxOptions.OKCancel, new ConfirmCallBackListener(REFRESH_CONFORM_CALLBACK, (IFormPlugin)this));
            }
        } else if ("btn_downtemp".equals(key)) {
            this.exportTemplate();
        }
    }

    public void confirmCallBack(MessageBoxClosedEvent evt) {
        super.confirmCallBack(evt);
        String key = evt.getCallBackId();
        if (REFRESH_CONFORM_CALLBACK.equals(key) && MessageBoxResult.Yes.equals((Object)evt.getResult())) {
            this.importData(IMPORT_COVER);
        }
    }

    public void afterUpload(UploadEvent evt) {
        Object[] fileUrls = evt.getUrls();
        if (fileUrls != null && fileUrls.length > 0) {
            this.getPageCache().put(IMPORT_FILE, JSON.toJSONString((Object)fileUrls[0]));
        }
    }

    public void afterRemove(UploadEvent evt) {
        super.afterRemove(evt);
        this.getPageCache().remove(IMPORT_FILE);
    }

    private void importData(String op) {
        List dataList;
        Map fileMap = (Map)JSON.parseObject((String)this.getPageCache().get(IMPORT_FILE), Map.class);
        String name = (String)fileMap.get("name");
        if (StringUtils.isBlank((CharSequence)name)) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u91cd\u65b0\u4e0a\u4f20\u6587\u4ef6\u3002", (String)"RpaEntityRefImportPlugin_5", (String)"epm-eb-formplugin", (Object[])new Object[0]));
            return;
        }
        if (!name.endsWith("xlsx") && !name.endsWith("xls")) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u6587\u4ef6\u683c\u5f0f\u4e0d\u6b63\u786e\uff0c\u8bf7\u4f7f\u7528\u6a21\u677f\u4e0a\u4f20\u3002", (String)"RpaEntityRefImportPlugin_6", (String)"epm-eb-formplugin", (Object[])new Object[0]));
            return;
        }
        String fileUrl = (String)fileMap.get("url");
        if (StringUtils.isBlank((CharSequence)fileUrl)) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u91cd\u65b0\u4e0a\u4f20\u6587\u4ef6\u3002", (String)"RpaEntityRefImportPlugin_5", (String)"epm-eb-formplugin", (Object[])new Object[0]));
            return;
        }
        int celSize = 9;
        InputStream in = null;
        try {
            in = UploadUtil.getFileInputStream((String)fileUrl);
            Object wb = name.endsWith("xlsx") ? new XSSFWorkbook(in) : new HSSFWorkbook(in);
            dataList = BgExcelReader.getInstance().readByWorkbook((Workbook)wb).read(0, 0, celSize - 1);
        }
        catch (IOException e) {
            throw new KDBizException(ResManager.loadKDString((String)"\u6587\u4ef6\u89e3\u6790\u9519\u8bef\uff0c\u8bf7\u91cd\u65b0\u4e0a\u4f20\u6587\u4ef6\u3002", (String)"RpaEntityRefImportPlugin_7", (String)"epm-eb-formplugin", (Object[])new Object[0]));
        }
        finally {
            if (in != null) {
                try {
                    in.close();
                }
                catch (IOException e) {
                    log.error(e.getMessage(), (Throwable)e);
                }
            }
        }
        if (CollectionUtils.isEmpty((Collection)dataList) || dataList.size() <= 1) {
            throw new KDBizException(ResManager.loadKDString((String)"\u6587\u4ef6\u4e3a\u7a7a\uff0c\u5bfc\u5165\u5931\u8d25\u3002", (String)"RpaEntityRefImportPlugin_8", (String)"epm-eb-formplugin", (Object[])new Object[0]));
        }
        ArrayList<RpaEntityRef> dtoList = new ArrayList<RpaEntityRef>(dataList.size());
        HashMap<Integer, String> errorMap = new HashMap<Integer, String>(dataList.size());
        this.parseData(dataList, dtoList, errorMap, op);
        RpaEntityRefDao.getInstance().save(dtoList);
        if (MapUtils.isNotEmpty(errorMap)) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u4e0a\u4f20\u6587\u4ef6\u6709\u8bef\u3002\u8bf7\u67e5\u770b\u5bfc\u51fa\u6587\u4ef6\u3002", (String)"RpaEntityRefImportPlugin_4", (String)"epm-eb-formplugin", (Object[])new Object[0]));
            this.exportError(dataList, errorMap);
        } else {
            this.getView().returnDataToParent((Object)true);
            this.getView().close();
        }
    }

    private void parseData(List<List<String>> dataList, List<RpaEntityRef> dtoList, Map<Integer, String> errorMap, String op) {
        Long modelId = this.getModelId();
        IModelCacheHelper modelCache = ModelCacheContext.getOrCreate((Long)modelId);
        Dimension dimension = modelCache.getDimension(SysDimensionEnum.Entity.getNumber());
        List numbers = dataList.stream().map(list -> (String)list.get(0)).collect(Collectors.toList());
        List viewNumbers = dataList.stream().map(list -> (String)list.get(2)).collect(Collectors.toList());
        DynamicObjectCollection load = RpaIntegrationDao.getInstance().load(modelId, numbers);
        List integrations = load.stream().map(dy -> dy.getLong("id")).collect(Collectors.toList());
        Map viewIdByNumber = DimensionViewServiceHelper.getInstance().getViewIdByNumber(modelId, dimension.getId(), viewNumbers);
        DynamicObject[] entity = RpaEntityRefDao.getInstance().loadByIntegration(integrations);
        Map<String, DynamicObject> integrationMaps = load.stream().collect(Collectors.toMap(dy -> dy.getString("number"), dy -> dy));
        HashSet<String> entityNumbers = new HashSet<String>(dataList.size());
        HashSet<String> corpNumbers = new HashSet<String>(dataList.size());
        AtomicInteger dimRow = new AtomicInteger(0);
        for (List<String> data : dataList) {
            Set permMemberIds;
            int rowIndex = dimRow.getAndIncrement();
            if (rowIndex == 0) continue;
            String integrationNumber = data.get(0);
            String viewNumber = data.get(2);
            String entityNumber = data.get(4);
            String number = data.get(6);
            String name = data.get(7);
            String type = data.get(8);
            if (StringUtils.isEmpty((CharSequence)integrationNumber) || StringUtils.isEmpty((CharSequence)viewNumber) || StringUtils.isEmpty((CharSequence)entityNumber) || StringUtils.isEmpty((CharSequence)number) || StringUtils.isEmpty((CharSequence)name) || StringUtils.isEmpty((CharSequence)type)) {
                errorMap.put(rowIndex, ResManager.loadKDString((String)"\u8bf7\u586b\u5199*\u53f7\u5fc5\u586b\u9879\u6570\u636e\u3002", (String)"RpaEntityRefImportPlugin_9", (String)"epm-eb-formplugin", (Object[])new Object[0]));
                continue;
            }
            if (!viewIdByNumber.containsKey(viewNumber)) {
                errorMap.put(rowIndex, ResManager.loadKDString((String)"\u8be5\u4f53\u7cfb\u4e0b\uff0c\u89c6\u56fe\u7f16\u7801\u4e0d\u5b58\u5728\uff0c\u4e0d\u80fd\u65b0\u589e\u3002", (String)"RpaEntityRefImportPlugin_21", (String)"epm-eb-formplugin", (Object[])new Object[0]));
                continue;
            }
            String reportType = RpaEntityRefEnum.getRpaEntityRefByName(type).getNumber();
            if (entityNumbers.contains(integrationNumber + entityNumber) || corpNumbers.contains(integrationNumber + number + reportType)) {
                errorMap.put(rowIndex, ResManager.loadKDString((String)"\u5bfc\u5165\u6570\u636e\u5931\u8d25\uff0c\u7ec4\u7ec7\u7f16\u7801\u6216\u4f01\u4e1a\u4ee3\u7801\u91cd\u590d\u3002", (String)"RpaEntityRefImportPlugin_18", (String)"epm-eb-formplugin", (Object[])new Object[0]));
                continue;
            }
            if (number.length() > 50 || name.length() > 50) {
                errorMap.put(rowIndex, ResManager.loadKDString((String)"\u4f01\u4e1a\u4ee3\u7801\u3001\u4f01\u4e1a\u540d\u79f0\u4e0d\u80fd\u8d85\u8fc750\u4e2a\u5b57\u7b26\u3002", (String)"RpaEntityRefImportPlugin_16", (String)"epm-eb-formplugin", (Object[])new Object[0]));
                continue;
            }
            if (Arrays.stream(RpaEntityRefEnum.values()).noneMatch(e -> type.equals(e.getName()))) {
                errorMap.put(rowIndex, ResManager.loadKDString((String)"\u62a5\u8868\u7c7b\u578b\u4e0d\u7b26\u5408\u89c4\u8303\u3002", (String)"RpaEntityRefImportPlugin_17", (String)"epm-eb-formplugin", (Object[])new Object[0]));
                continue;
            }
            if (!integrationMaps.containsKey(integrationNumber)) {
                errorMap.put(rowIndex, ResManager.loadKDString((String)"\u5f53\u524d\u4f53\u7cfb\u4e0b\uff0c\u65b9\u6848\u7f16\u7801\u4e0d\u5b58\u5728\u3002", (String)"RpaEntityRefImportPlugin_11", (String)"epm-eb-formplugin", (Object[])new Object[0]));
                continue;
            }
            DynamicObject dynamicObject = integrationMaps.get(integrationNumber);
            Long integrationId = dynamicObject.getLong("id");
            Long bizModelId = dynamicObject.getLong("bizmodel");
            Long viewId = (Long)viewIdByNumber.get(viewNumber);
            Member member = modelCache.getMember(SysDimensionEnum.Entity.getNumber(), viewId, entityNumber);
            if (member == null) {
                errorMap.put(rowIndex, ResManager.loadKDString((String)"\u7ec4\u7ec7\u6210\u5458\u7f16\u7801\u4e0d\u5b58\u5728\u3002", (String)"RpaEntityRefImportPlugin_14", (String)"epm-eb-formplugin", (Object[])new Object[0]));
                continue;
            }
            boolean modelManager = ModelServiceHelper.isModelManager((Long)this.getModelId());
            if (!modelManager && (permMemberIds = DimMembPermHelper.getReadPermMembIds((String)SysDimensionEnum.Entity.getNumber(), (Long)modelId, (Long)bizModelId, (Long)viewId, (boolean)true)) != null && !permMemberIds.contains(member.getId())) {
                errorMap.put(rowIndex, ResManager.loadKDString((String)"\u6ca1\u6709\u8be5\u7ec4\u7ec7\u6210\u5458\u7f16\u7801\u7684\u8bfb\u53d6\u6743\u9650\u3002", (String)"RpaEntityRefImportPlugin_15", (String)"epm-eb-formplugin", (Object[])new Object[0]));
                continue;
            }
            Optional<DynamicObject> corpFilter = Arrays.stream(entity).filter(dy -> dy.getString("rpainte.number").equals(integrationNumber) && dy.getString("number").equals(number) && dy.getString("reporttype").equals(reportType)).findFirst();
            Optional<DynamicObject> entityFilter = Arrays.stream(entity).filter(dy -> dy.getString("rpainte.number").equals(integrationNumber) && dy.getString("entity.number").equals(entityNumber)).findFirst();
            if (IMPORT_ADD.equals(op)) {
                if (corpFilter.isPresent()) {
                    errorMap.put(rowIndex, ResManager.loadKDString((String)"\u8be5\u65b9\u6848\u4e0b\uff0c\u5df2\u5b58\u5728\u8be5\u4f01\u4e1a\u4ee3\u7801\u548c\u62a5\u8868\u7c7b\u578b\uff0c\u4e0d\u80fd\u65b0\u589e\u3002", (String)"RpaEntityRefImportPlugin_12", (String)"epm-eb-formplugin", (Object[])new Object[0]));
                    continue;
                }
                if (entityFilter.isPresent()) {
                    errorMap.put(rowIndex, ResManager.loadKDString((String)"\u8be5\u65b9\u6848\u4e0b\uff0c\u5df2\u5b58\u5728\u8be5\u7ec4\u7ec7\u7f16\u7801\uff0c\u4e0d\u80fd\u65b0\u589e\u3002", (String)"RpaEntityRefImportPlugin_13", (String)"epm-eb-formplugin", (Object[])new Object[0]));
                    continue;
                }
                this.dealRpaEntityRefData(dtoList, data, viewId, integrationId, member, null, entityNumbers, corpNumbers);
                continue;
            }
            if (entityFilter.isPresent() && corpFilter.isPresent()) {
                if (entityFilter.get().getLong("id") == corpFilter.get().getLong("id")) {
                    this.dealRpaEntityRefData(dtoList, data, viewId, integrationId, member, corpFilter.get().getLong("id"), entityNumbers, corpNumbers);
                } else {
                    errorMap.put(rowIndex, ResManager.loadKDString((String)"\u4f01\u4e1a\u4ee3\u7801\u7684\u7ec4\u7ec7\u7f16\u7801\u5df2\u5b58\u5728\uff0c\u4e0d\u5141\u8bb8\u66f4\u65b0\u3002", (String)"RpaEntityRefImportPlugin_10", (String)"epm-eb-formplugin", (Object[])new Object[0]));
                }
            }
            if (corpFilter.isPresent() && !entityFilter.isPresent()) {
                if (RpaSchemeDao.getInstance().checkEntityByRpaSchemeRef(new DynamicObject[]{corpFilter.get()})) {
                    errorMap.put(rowIndex, ResManager.loadKDString((String)"\u4f01\u4e1a\u4ee3\u7801\u7684\u7ec4\u7ec7\u7f16\u7801\u5df2\u88abRPA\u96c6\u6210\u65b9\u6848\u5f15\u7528\uff0c\u4e0d\u5141\u8bb8\u66f4\u65b0\u3002", (String)"RpaEntityRefImportPlugin_19", (String)"epm-eb-formplugin", (Object[])new Object[0]));
                } else {
                    this.dealRpaEntityRefData(dtoList, data, viewId, integrationId, member, corpFilter.get().getLong("id"), entityNumbers, corpNumbers);
                }
            }
            if (!corpFilter.isPresent() && entityFilter.isPresent()) {
                errorMap.put(rowIndex, ResManager.loadKDString((String)"\u7ec4\u7ec7\u7f16\u7801\u5df2\u5b58\u5728\uff0c\u4e0d\u5141\u8bb8\u4fee\u6539\u4f01\u4e1a\u7f16\u7801\u3002", (String)"RpaEntityRefImportPlugin_20", (String)"epm-eb-formplugin", (Object[])new Object[0]));
            }
            if (corpFilter.isPresent() || entityFilter.isPresent()) continue;
            this.dealRpaEntityRefData(dtoList, data, viewId, integrationId, member, null, entityNumbers, corpNumbers);
        }
    }

    private RpaEntityRef buildRpaEntityRef(List<String> data, Long viewId, Long integrationId, Member member) {
        Long modelId = this.getModelId();
        String number = data.get(6);
        String name = data.get(7);
        String type = data.get(8);
        Long userId = RequestContext.get().getCurrUserId();
        Date now = TimeServiceHelper.now();
        RpaEntityRef rpaEntityRef = new RpaEntityRef();
        rpaEntityRef.setModel(modelId);
        rpaEntityRef.setViewId(viewId);
        rpaEntityRef.setModifier(userId);
        rpaEntityRef.setModifyTime(now);
        rpaEntityRef.setCorpName(name);
        rpaEntityRef.setCorpNumber(number);
        rpaEntityRef.setReportType(RpaEntityRefEnum.getRpaEntityRefByName(type).getNumber());
        rpaEntityRef.setEntityId(member.getId());
        rpaEntityRef.setRpaInteId(integrationId);
        return rpaEntityRef;
    }

    private void dealRpaEntityRefData(List<RpaEntityRef> dtoList, List<String> data, Long viewId, Long integrationId, Member member, Long id, Set<String> entityNumbers, Set<String> corpNumbers) {
        RpaEntityRef model = this.buildRpaEntityRef(data, viewId, integrationId, member);
        if (IDUtils.isNotEmptyLong((Long)id).booleanValue()) {
            model.setId(id);
        }
        dtoList.add(model);
        entityNumbers.add(data.get(0) + member.getNumber());
        corpNumbers.add(data.get(0) + model.getCorpNumber() + model.getReportType());
    }

    private void exportError(List<List<String>> oriDataList, Map<Integer, String> errorMap) {
        BgExcelWriter excelWriter = BgExcelWriter.getInstance().readTemplateByClasspath("rpa/rpaEntityRef.xlsx");
        excelWriter.setStarPosition(0, 0);
        List<String> oriHeadLine = oriDataList.get(0);
        int colSize = oriHeadLine.size() + 1;
        ArrayList<String> newHeadLine = new ArrayList<String>(colSize);
        newHeadLine.addAll(oriHeadLine);
        newHeadLine.add(ResManager.loadKDString((String)"\u9519\u8bef\u4fe1\u606f", (String)"RpaEntityRefImportPlugin_3", (String)"epm-eb-formplugin", (Object[])new Object[0]));
        CellStyle cellStyle = POIUtils.get().getTextCellStyle(excelWriter.getWorkbook());
        excelWriter.createRow(cellStyle, newHeadLine);
        for (int row = 1; row < oriDataList.size(); ++row) {
            List<String> oriDataLine = oriDataList.get(row);
            ArrayList<String> newDataLine = new ArrayList<String>(colSize);
            newDataLine.addAll(oriDataLine);
            newDataLine.add(errorMap.get(row) == null ? "" : errorMap.get(row));
            excelWriter.createRow(cellStyle, newDataLine);
        }
        String fileName = ResManager.loadKDString((String)"\u5bfc\u5165\u9519\u8bef\u8be6\u60c5.xlsx", (String)"RpaEntityRefImportPlugin_0", (String)"epm-eb-formplugin", (Object[])new Object[0]);
        String url = excelWriter.getDownloadUrl(fileName);
        ((IClientViewProxy)this.getView().getService(IClientViewProxy.class)).addAction("download", (Object)url);
    }

    private void exportTemplate() {
        BgExcelWriter excelWriter = BgExcelWriter.getInstance().readTemplateByClasspath("rpa/rpaEntityRef.xlsx");
        excelWriter.setStarPosition(0, 0);
        this.buildHead(excelWriter);
        String fileName = ResManager.loadResFormat((String)"RPA\u7ec4\u7ec7\u6210\u5458\u6620\u5c04\u6570\u636e_%1", (String)"RpaEntityRefListPlugin_16", (String)"epm-eb-formplugin", (Object[])new Object[]{DateFormatUtils.format((Date)new Date(), (String)"yyyyMMdd")});
        fileName = fileName + ".xlsx";
        String url = excelWriter.getDownloadUrl(fileName);
        ((IClientViewProxy)this.getView().getService(IClientViewProxy.class)).addAction("download", (Object)url);
    }

    private void buildHead(BgExcelWriter excelWriter) {
        ArrayList<String> newHeadLine = new ArrayList<String>(8);
        newHeadLine.add(ResManager.loadKDString((String)"\u96c6\u6210\u65b9\u6848\u7f16\u7801*", (String)"RpaEntityRefListPlugin_9", (String)"epm-eb-formplugin", (Object[])new Object[0]));
        newHeadLine.add(ResManager.loadKDString((String)"\u96c6\u6210\u65b9\u6848\u540d\u79f0", (String)"RpaEntityRefListPlugin_10", (String)"epm-eb-formplugin", (Object[])new Object[0]));
        newHeadLine.add(ResManager.loadKDString((String)"\u7ec4\u7ec7\u89c6\u56fe\u7f16\u7801*", (String)"RpaEntityRefListPlugin_18", (String)"epm-eb-formplugin", (Object[])new Object[0]));
        newHeadLine.add(ResManager.loadKDString((String)"\u7ec4\u7ec7\u89c6\u56fe\u540d\u79f0", (String)"RpaEntityRefListPlugin_19", (String)"epm-eb-formplugin", (Object[])new Object[0]));
        newHeadLine.add(ResManager.loadKDString((String)"\u7ec4\u7ec7\u7f16\u7801*", (String)"RpaEntityRefListPlugin_11", (String)"epm-eb-formplugin", (Object[])new Object[0]));
        newHeadLine.add(ResManager.loadKDString((String)"\u7ec4\u7ec7\u540d\u79f0", (String)"RpaEntityRefListPlugin_12", (String)"epm-eb-formplugin", (Object[])new Object[0]));
        newHeadLine.add(ResManager.loadKDString((String)"\u4f01\u4e1a\u4ee3\u7801*", (String)"RpaEntityRefListPlugin_13", (String)"epm-eb-formplugin", (Object[])new Object[0]));
        newHeadLine.add(ResManager.loadKDString((String)"\u4f01\u4e1a\u540d\u79f0*", (String)"RpaEntityRefListPlugin_14", (String)"epm-eb-formplugin", (Object[])new Object[0]));
        newHeadLine.add(ResManager.loadKDString((String)"\u62a5\u8868\u7c7b\u578b*", (String)"RpaEntityRefListPlugin_15", (String)"epm-eb-formplugin", (Object[])new Object[0]));
        excelWriter.createRow(newHeadLine);
        String[] values = new String[]{ResManager.loadKDString((String)"\u5355\u6237\u8868", (String)"RpaEntityRefEnum_0", (String)"epm-eb-formplugin", (Object[])new Object[0]), ResManager.loadKDString((String)"\u96c6\u56e2\u5dee\u989d\u8868", (String)"RpaEntityRefEnum_1", (String)"epm-eb-formplugin", (Object[])new Object[0]), ResManager.loadKDString((String)"\u91d1\u878d\u5b50\u4f01\u4e1a\u8868", (String)"RpaEntityRefEnum_2", (String)"epm-eb-formplugin", (Object[])new Object[0]), ResManager.loadKDString((String)"\u5883\u5916\u5b50\u4f01\u4e1a\u8868", (String)"RpaEntityRefEnum_3", (String)"epm-eb-formplugin", (Object[])new Object[0]), ResManager.loadKDString((String)"\u4e8b\u4e1a\u5e76\u4f01\u4e1a\u8868", (String)"RpaEntityRefEnum_4", (String)"epm-eb-formplugin", (Object[])new Object[0]), ResManager.loadKDString((String)"\u57fa\u5efa\u5e76\u4f01\u4e1a\u8868", (String)"RpaEntityRefEnum_5", (String)"epm-eb-formplugin", (Object[])new Object[0]), ResManager.loadKDString((String)"\u96c6\u56e2\u5408\u5e76\u8868", (String)"RpaEntityRefEnum_6", (String)"epm-eb-formplugin", (Object[])new Object[0])};
        excelWriter.setDropDownBox(values, Integer.valueOf(2), Integer.valueOf(100), Integer.valueOf(9), Integer.valueOf(9));
    }

    @Override
    public Long getModelId() {
        return (Long)this.getView().getFormShowParameter().getCustomParam("KEY_MODEL_ID");
    }
}

