/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.formplugin.rpa;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.EventObject;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.base.BaseShowParameter;
import kd.bos.bill.OperationStatus;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.resource.promptenum.MultiLangEnumBridge;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.exception.KDBizException;
import kd.bos.filter.CommonFilterColumn;
import kd.bos.form.CloseCallBack;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IClientViewProxy;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.ShowType;
import kd.bos.form.control.events.ClickListener;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.FilterContainerInitArgs;
import kd.bos.form.events.FilterContainerSearchClickArgs;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.field.ComboItem;
import kd.bos.form.field.events.BeforeFilterF7SelectEvent;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.BillList;
import kd.bos.list.ListGridView;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.epm.eb.business.rpa.dao.RpaEntityRefDao;
import kd.epm.eb.business.rpa.dao.RpaIntegrationDao;
import kd.epm.eb.business.rpa.dao.RpaSchemeDao;
import kd.epm.eb.business.rpa.entity.RpaIntegration;
import kd.epm.eb.business.utils.ImportAndExportUtil;
import kd.epm.eb.common.cache.IModelCacheHelper;
import kd.epm.eb.common.enums.ApplicationTypeEnum;
import kd.epm.eb.common.enums.SysDimensionEnum;
import kd.epm.eb.common.utils.IDUtils;
import kd.epm.eb.common.utils.excel.BgExcelWriter;
import kd.epm.eb.common.utils.excelImport.POIUtils;
import kd.epm.eb.formplugin.AbstractListPlugin;
import kd.epm.eb.formplugin.rpa.constant.RpaEntityRefEnum;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.time.DateFormatUtils;
import org.apache.poi.ss.usermodel.CellStyle;

public class RpaEntityRefListPlugin
extends AbstractListPlugin {
    private static final String ENTITY_CLOSE_CALLBACK = "entityCloseCallback";
    private static final String IMPORT_CLOSE_CALLBACK = "importCloseCallback";
    private static final String DELETE_RPA_ENTITY_REF_CONFIRM = "deleteRpaEntityRefConfirm";

    public void filterContainerInit(FilterContainerInitArgs args) {
        super.filterContainerInit(args);
        Long integrationId = this.getIntegrationId();
        Long modelId = this.getModelId();
        List commonFilterColumns = args.getCommonFilterColumns();
        CommonFilterColumn filterColumn = commonFilterColumns.stream().filter(c -> c.getFieldName().equals("rpainte.name")).findFirst().orElse(null);
        if (filterColumn == null) {
            return;
        }
        DynamicObjectCollection col = RpaIntegrationDao.getInstance().loadByModel(modelId);
        filterColumn.getComboItems().clear();
        if (col.isEmpty()) {
            filterColumn.setDefaultValue("0");
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8be5\u4f53\u7cfb\u4e0b\u4e0d\u5b58\u5728RPA\u96c6\u6210\u65b9\u6848\uff0c\u8bf7\u65b0\u589eRPA\u96c6\u6210\u65b9\u6848\u3002", (String)"RpaEntityRefListPlugin_0", (String)"epm-eb-formplugin", (Object[])new Object[0]));
            return;
        }
        ArrayList<ComboItem> comboItems = new ArrayList<ComboItem>(16);
        col.forEach(e -> comboItems.add(new ComboItem(new LocaleString(e.getString("name")), e.getString("id"))));
        filterColumn.setComboItems(comboItems);
        if (RpaIntegrationDao.getInstance().checkRpaIntegrationExisted(integrationId)) {
            long count = comboItems.stream().filter(rpaScheme -> rpaScheme != null && integrationId.toString().equals(rpaScheme.getValue())).count();
            if (count == 0L) {
                this.noIntegration(filterColumn, comboItems);
            } else {
                filterColumn.setDefaultValue(integrationId.toString());
                this.getPageCache().put("integrationId", integrationId.toString());
            }
        } else {
            this.noIntegration(filterColumn, comboItems);
        }
    }

    private void noIntegration(CommonFilterColumn filterColumn, List<ComboItem> comboItems) {
        String value = comboItems != null && comboItems.size() > 0 ? comboItems.get(0).getValue() : "0";
        filterColumn.setDefaultValue(value);
        if ("0".equals(value)) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8be5\u4f53\u7cfb\u4e0b\u4e0d\u5b58\u5728RPA\u96c6\u6210\u65b9\u6848\uff0c\u8bf7\u65b0\u589eRPA\u96c6\u6210\u65b9\u6848\u3002", (String)"RpaEntityRefListPlugin_0", (String)"epm-eb-formplugin", (Object[])new Object[0]));
        }
    }

    public void filterContainerBeforeF7Select(BeforeFilterF7SelectEvent args) {
        super.filterContainerBeforeF7Select(args);
        if ("rpainte.id".equals(args.getFieldName())) {
            args.setCustomQFilters(Collections.singletonList(new QFilter("model", "=", (Object)this.getModelId())));
            args.getCustomParams().put("callFromRefBillEdit", true);
        }
    }

    public void filterContainerSearchClick(FilterContainerSearchClickArgs args) {
        Map currentCommonFilter;
        super.filterContainerSearchClick(args);
        if (args.getCurrentCommonFilter() != null && "rpainte.id".equals(((List)(currentCommonFilter = args.getCurrentCommonFilter()).get("FieldName")).get(0))) {
            String integrationId = String.valueOf(((List)currentCommonFilter.get("Value")).get(0));
            if (StringUtils.isBlank((CharSequence)integrationId)) {
                return;
            }
            RpaIntegration data = RpaIntegrationDao.getInstance().load(IDUtils.toLong((Object)integrationId));
            if (data == null) {
                return;
            }
            this.getPageCache().put("integrationId", integrationId);
            this.getPageCache().put("bizmodel", String.valueOf(data.getBizModelId()));
        }
    }

    @Override
    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addItemClickListeners(new String[]{"toolbarap"});
        ListGridView list = (ListGridView)this.getView().getControl("gridview");
        list.addClickListener((ClickListener)this);
        BillList billList = (BillList)this.getView().getControl("billlistap");
        billList.addSetFilterListener(setFilterEvent -> setFilterEvent.getQFilters().add(this.getQFilter()));
    }

    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        Long modelId = (Long)this.getView().getFormShowParameter().getCustomParam("KEY_MODEL_ID");
        this.getPageCache().put("KEY_MODEL_ID", modelId.toString());
        Long bizModelId = (Long)this.getView().getFormShowParameter().getCustomParam("bizmodel");
        this.getPageCache().put("bizmodel", bizModelId.toString());
        Long integrationId = (Long)this.getView().getFormShowParameter().getCustomParam("integrationId");
        this.getPageCache().put("integrationId", integrationId.toString());
    }

    public void itemClick(ItemClickEvent evt) {
        super.itemClick(evt);
        String key = evt.getItemKey();
        ListSelectedRowCollection selectedRows = ((BillList)this.getControl("billlistap")).getSelectedRows();
        switch (key) {
            case "btn_add": {
                this.openEntityPage(null);
                break;
            }
            case "btn_modify": {
                this.checkIsSelectOneData(selectedRows);
                this.openEntityPage(IDUtils.toLong((Object)selectedRows.get(0).getPrimaryKeyValue()));
                break;
            }
            case "btn_del": {
                this.checkByRpaSchemeRef(selectedRows);
                this.getView().showConfirm(ResManager.loadKDString((String)"\u786e\u8ba4\u5220\u9664\u6570\u636e\uff1f", (String)"RpaEntityRefListPlugin_4", (String)"epm-eb-formplugin", (Object[])new Object[0]), MessageBoxOptions.OKCancel, new ConfirmCallBackListener(DELETE_RPA_ENTITY_REF_CONFIRM, (IFormPlugin)this));
                break;
            }
            case "btn_import": {
                this.openImportPage();
                break;
            }
            case "btn_export": {
                this.exportEntityRef();
                break;
            }
            case "btn_refresh": {
                this.refreshBillList();
                break;
            }
        }
    }

    @Override
    public void closedCallBack(ClosedCallBackEvent closedCallBackEvent) {
        super.closedCallBack(closedCallBackEvent);
        String key = closedCallBackEvent.getActionId();
        if (ENTITY_CLOSE_CALLBACK.equals(key)) {
            this.refreshBillList();
        }
        if (IMPORT_CLOSE_CALLBACK.equals(key) && closedCallBackEvent.getReturnData() instanceof Boolean && ((Boolean)closedCallBackEvent.getReturnData()).booleanValue()) {
            this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u5bfc\u5165\u6210\u529f\u3002", (String)"RpaEntityRefListPlugin_17", (String)"epm-eb-formplugin", (Object[])new Object[0]));
            this.refreshBillList();
        }
    }

    public void confirmCallBack(MessageBoxClosedEvent e) {
        super.confirmCallBack(e);
        String callBackId = e.getCallBackId();
        if (callBackId.equals(DELETE_RPA_ENTITY_REF_CONFIRM) && e.getResult().equals((Object)MessageBoxResult.Yes)) {
            ListSelectedRowCollection selectedRows = ((BillList)this.getControl("billlistap")).getSelectedRows();
            List ids = selectedRows.stream().map(v -> IDUtils.toLong((Object)v.getPrimaryKeyValue().toString())).collect(Collectors.toList());
            RpaEntityRefDao.getInstance().delete(ids);
            this.refreshBillList();
            MultiLangEnumBridge opName = new MultiLangEnumBridge("\u5220\u9664", "RpaEntityRefListPlugin_6", "epm-eb-formplugin");
            MultiLangEnumBridge opDesc = new MultiLangEnumBridge("RPA\u7ec4\u7ec7\u6210\u5458id:%1$s\u5220\u9664\u6210\u529f\u3002", "RpaEntityRefListPlugin_7", "epm-eb-formplugin");
            this.writeLogWithEntityNumber(this.getView().getModel().getDataEntityType().getName(), null, "delete", opName, opDesc, new String[]{ids.toString()});
            this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u5220\u9664\u6210\u529f\u3002", (String)"RpaEntityRefListPlugin_5", (String)"epm-eb-formplugin", (Object[])new Object[0]));
        }
    }

    private void refreshBillList() {
        BillList billList = (BillList)this.getView().getControl("billlistap");
        billList.setClearSelection(true);
        billList.setFilter(this.getQFilter());
        billList.setOrderBy("id");
        billList.refresh();
    }

    private QFilter getQFilter() {
        return new QFilter("rpainte", "=", (Object)this.getIntegrationId());
    }

    private void openEntityPage(Long pkId) {
        this.checkRpaIntegrationExisted();
        BaseShowParameter showParameter = new BaseShowParameter();
        showParameter.setFormId("eb_rpa_entity_ref");
        CloseCallBack closeCallBack = new CloseCallBack((IFormPlugin)this, ENTITY_CLOSE_CALLBACK);
        showParameter.setCloseCallBack(closeCallBack);
        showParameter.getOpenStyle().setShowType(ShowType.Modal);
        showParameter.setShowTitle(true);
        showParameter.setCustomParam("KEY_MODEL_ID", (Object)this.getModelId());
        showParameter.setCustomParam("bizmodel", (Object)this.getBizModelId());
        showParameter.setCustomParam("integrationId", (Object)this.getIntegrationId());
        if (IDUtils.isNotEmptyLong((Long)pkId).booleanValue()) {
            showParameter.setPkId((Object)pkId);
            showParameter.setCustomParam("id", (Object)pkId);
            showParameter.setStatus(OperationStatus.EDIT);
        } else {
            showParameter.setStatus(OperationStatus.ADDNEW);
        }
        this.getView().showForm((FormShowParameter)showParameter);
    }

    private void openImportPage() {
        FormShowParameter showParameter = new FormShowParameter();
        showParameter.setFormId("eb_rpa_entity_import");
        CloseCallBack closeCallBack = new CloseCallBack((IFormPlugin)this, IMPORT_CLOSE_CALLBACK);
        showParameter.setCloseCallBack(closeCallBack);
        showParameter.getOpenStyle().setShowType(ShowType.Modal);
        showParameter.setShowTitle(true);
        showParameter.setCustomParam("KEY_MODEL_ID", (Object)this.getModelId());
        showParameter.setCustomParam("bizmodel", (Object)this.getBizModelId());
        this.getView().showForm(showParameter);
    }

    private void exportEntityRef() {
        BgExcelWriter excelWriter = BgExcelWriter.getInstance().readTemplateByClasspath("rpa/rpaEntityRef.xlsx");
        excelWriter.setStarPosition(0, 0);
        this.buildHead(excelWriter);
        this.dealExportData(excelWriter);
        String fileName = ResManager.loadResFormat((String)"RPA\u7ec4\u7ec7\u6210\u5458\u6620\u5c04\u6570\u636e_%1", (String)"RpaEntityRefListPlugin_16", (String)"epm-eb-formplugin", (Object[])new Object[]{DateFormatUtils.format((Date)new Date(), (String)"yyyyMMdd")});
        fileName = fileName + ".xlsx";
        String url = excelWriter.getDownloadUrl(fileName);
        ImportAndExportUtil.addTempFileCheck((String)url, (String)"eb_rpa_integration_list", (String)ApplicationTypeEnum.BGMD.getAppnum(), (int)10000);
        ((IClientViewProxy)this.getView().getService(IClientViewProxy.class)).addAction("download", (Object)url);
    }

    private void buildHead(BgExcelWriter excelWriter) {
        ArrayList<String> newHeadLine = new ArrayList<String>(8);
        newHeadLine.add(ResManager.loadKDString((String)"\u96c6\u6210\u65b9\u6848\u7f16\u7801*", (String)"RpaEntityRefListPlugin_9", (String)"epm-eb-formplugin", (Object[])new Object[0]));
        newHeadLine.add(ResManager.loadKDString((String)"\u96c6\u6210\u65b9\u6848\u540d\u79f0", (String)"RpaEntityRefListPlugin_10", (String)"epm-eb-formplugin", (Object[])new Object[0]));
        newHeadLine.add(ResManager.loadKDString((String)"\u7ec4\u7ec7\u89c6\u56fe\u7f16\u7801*", (String)"RpaEntityRefListPlugin_18", (String)"epm-eb-formplugin", (Object[])new Object[0]));
        newHeadLine.add(ResManager.loadKDString((String)"\u7ec4\u7ec7\u89c6\u56fe\u540d\u79f0", (String)"RpaEntityRefListPlugin_19", (String)"epm-eb-formplugin", (Object[])new Object[0]));
        newHeadLine.add(ResManager.loadKDString((String)"\u7ec4\u7ec7\u7f16\u7801*", (String)"RpaEntityRefListPlugin_11", (String)"epm-eb-formplugin", (Object[])new Object[0]));
        newHeadLine.add(ResManager.loadKDString((String)"\u7ec4\u7ec7\u540d\u79f0", (String)"RpaEntityRefListPlugin_12", (String)"epm-eb-formplugin", (Object[])new Object[0]));
        newHeadLine.add(ResManager.loadKDString((String)"\u4f01\u4e1a\u4ee3\u7801*", (String)"RpaEntityRefListPlugin_13", (String)"epm-eb-formplugin", (Object[])new Object[0]));
        newHeadLine.add(ResManager.loadKDString((String)"\u4f01\u4e1a\u540d\u79f0*", (String)"RpaEntityRefListPlugin_14", (String)"epm-eb-formplugin", (Object[])new Object[0]));
        newHeadLine.add(ResManager.loadKDString((String)"\u62a5\u8868\u7c7b\u578b*", (String)"RpaEntityRefListPlugin_15", (String)"epm-eb-formplugin", (Object[])new Object[0]));
        excelWriter.createRow(newHeadLine);
    }

    private void dealExportData(BgExcelWriter excelWriter) {
        DynamicObject[] data = RpaEntityRefDao.getInstance().loadByIntegration(Collections.singletonList(this.getIntegrationId()));
        DynamicObject defaultViewByBizModel = this.getDefaultViewByBizModel();
        CellStyle cellStyle = POIUtils.get().getTextCellStyle(excelWriter.getWorkbook());
        for (DynamicObject dy : data) {
            String viewNumber = dy.getString("view.number");
            String viewName = dy.getString("view.name");
            if ((StringUtils.isEmpty((CharSequence)viewNumber) || StringUtils.isEmpty((CharSequence)viewName)) && defaultViewByBizModel != null) {
                viewNumber = defaultViewByBizModel.getString("number");
                viewName = defaultViewByBizModel.getString("name");
            }
            ArrayList<String> dataLine = new ArrayList<String>(8);
            dataLine.add(dy.getString("rpainte.number"));
            dataLine.add(dy.getString("rpainte.name"));
            dataLine.add(viewNumber);
            dataLine.add(viewName);
            dataLine.add(dy.getString("entity.number"));
            dataLine.add(dy.getString("entity.name"));
            dataLine.add(dy.getString("number"));
            dataLine.add(dy.getString("name"));
            dataLine.add(RpaEntityRefEnum.getRpaEntityRefByNumber(dy.getString("reporttype")).getName());
            excelWriter.createRow(cellStyle, dataLine);
        }
    }

    private void checkIsSelectOneData(ListSelectedRowCollection selectedRows) {
        if (selectedRows.size() != 1) {
            throw new KDBizException(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u4e00\u6761\u6570\u636e\u8fdb\u884c\u4fee\u6539\u3002", (String)"RpaEntityRefListPlugin_1", (String)"epm-eb-formplugin", (Object[])new Object[0]));
        }
    }

    private void checkRpaIntegrationExisted() {
        if (!RpaIntegrationDao.getInstance().checkRpaIntegrationExisted(this.getIntegrationId())) {
            throw new KDBizException(ResManager.loadKDString((String)"RPA\u96c6\u6210\u65b9\u6848\u5df2\u5220\u9664\uff0c\u8bf7\u91cd\u65b0\u9009\u62e9\u3002", (String)"RpaEntityRefListPlugin_8", (String)"epm-eb-formplugin", (Object[])new Object[0]));
        }
    }

    private void checkByRpaSchemeRef(ListSelectedRowCollection selectedRows) {
        List ids = selectedRows.stream().map(v -> IDUtils.toLong((Object)v.getPrimaryKeyValue().toString())).collect(Collectors.toList());
        if (ids.isEmpty()) {
            throw new KDBizException(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u6570\u636e\u3002", (String)"RpaEntityRefListPlugin_2", (String)"epm-eb-formplugin", (Object[])new Object[0]));
        }
        DynamicObject[] dys = RpaEntityRefDao.getInstance().load(ids);
        if (RpaSchemeDao.getInstance().checkEntityByRpaSchemeRef(dys)) {
            throw new KDBizException(ResManager.loadKDString((String)"\u7ec4\u7ec7\u6210\u5458\u88abRPA\u673a\u5668\u4eba\u5f15\u7528\uff0c\u4e0d\u5141\u8bb8\u5220\u9664\u3002", (String)"RpaEntityRefListPlugin_3", (String)"epm-eb-formplugin", (Object[])new Object[0]));
        }
    }

    @Override
    public Long getModelId() {
        return IDUtils.toLong((Object)this.getPageCache().get("KEY_MODEL_ID"));
    }

    private Long getBizModelId() {
        return IDUtils.toLong((Object)this.getPageCache().get("bizmodel"));
    }

    private Long getIntegrationId() {
        return IDUtils.toLong((Object)this.getPageCache().get("integrationId"));
    }

    private DynamicObject getDefaultViewByBizModel() {
        IModelCacheHelper modelCacheHelper = this.getIModelCacheHelper();
        Long defaultView = modelCacheHelper.getViewByBusModelAndDimNumber(this.getBizModelId(), SysDimensionEnum.Entity.getNumber());
        QFilter qFilter = new QFilter("id", "=", (Object)defaultView);
        return QueryServiceHelper.queryOne((String)"eb_dimensionview", (String)"id, number, name", (QFilter[])qFilter.toArray());
    }
}

