/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.formplugin.rpa;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.EventObject;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.stream.Collectors;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.form.FormShowParameter;
import kd.bos.form.control.Control;
import kd.epm.eb.business.rpa.model.JQReport;
import kd.epm.eb.formplugin.AbstractBasePlugin;
import org.apache.commons.lang3.StringUtils;

public class RpaFieldEnumConfigPlugin
extends AbstractBasePlugin {
    private static final String ENTRY_ENTITY = "entryentity";
    private static final String FIELD_CODE = "code";
    private static final String FIELD_NAME = "name";
    private static final String FIELD_ENUM_FLAG = "isenum";
    private static final String BTN_OK = "btnok";

    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        FormShowParameter formShowParameter = this.getView().getFormShowParameter();
        String enumField = (String)formShowParameter.getCustomParam("enum_field");
        JQReport jqReport = (JQReport)SerializationUtils.fromJsonString((String)((String)formShowParameter.getCustomParam("jq_report")), JQReport.class);
        this.initEntry(enumField, jqReport);
    }

    private void initEntry(String enumField, JQReport jqReport) {
        Set enumFieldSet = StringUtils.isNotBlank((CharSequence)enumField) ? Arrays.stream(enumField.split(",")).collect(Collectors.toSet()) : Collections.emptySet();
        IDataModel dataModel = this.getControl(ENTRY_ENTITY).getModel();
        dataModel.deleteEntryData(ENTRY_ENTITY);
        Collection jqTables = jqReport.getTables().values();
        int fieldSize = jqTables.stream().mapToInt(v -> v.getFields().size()).sum();
        dataModel.batchCreateNewEntryRow(ENTRY_ENTITY, fieldSize);
        AtomicInteger index = new AtomicInteger(0);
        jqReport.getTables().values().forEach(jqTable -> {
            Map fieldNames = jqTable.getFieldNames();
            jqTable.getFields().forEach(fieldCode -> {
                int rowIndex = index.getAndIncrement();
                dataModel.setValue(FIELD_CODE, fieldCode, rowIndex);
                dataModel.setValue(FIELD_NAME, fieldNames.get(fieldCode), rowIndex);
                dataModel.setValue(FIELD_ENUM_FLAG, (Object)enumFieldSet.contains(fieldCode), rowIndex);
            });
        });
    }

    @Override
    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addClickListeners(new String[]{BTN_OK});
    }

    public void click(EventObject evt) {
        String key = ((Control)evt.getSource()).getKey();
        if (key == null) {
            return;
        }
        if (BTN_OK.equals(key)) {
            int rowCount = this.getModel().getEntryRowCount(ENTRY_ENTITY);
            LinkedHashSet<String> enumFieldSet = new LinkedHashSet<String>(rowCount);
            for (int i = 0; i < rowCount; ++i) {
                Boolean flag = (Boolean)this.getModel().getValue(FIELD_ENUM_FLAG, i);
                if (!flag.booleanValue()) continue;
                enumFieldSet.add((String)this.getModel().getValue(FIELD_CODE, i));
            }
            this.getView().returnDataToParent((Object)String.join((CharSequence)",", enumFieldSet));
            this.getView().close();
        }
    }
}

