/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.formplugin.rpa;

import java.util.EventObject;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.OrmLocaleValue;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.operate.Save;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeClosedEvent;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.operate.FormOperate;
import kd.epm.eb.business.rpa.dao.RpaIntegrationCateDao;
import kd.epm.eb.business.utils.CheckStringsUtil;
import kd.epm.eb.common.utils.IDUtils;
import kd.epm.eb.common.utils.StringUtils;
import kd.epm.eb.formplugin.AbstractBasePlugin;

public class RpaIntegrationCateEditPlugin
extends AbstractBasePlugin {
    public void afterLoadData(EventObject e) {
        super.afterLoadData(e);
        DynamicObject parent = (DynamicObject)this.getModel().getValue("parent");
        if (null != parent) {
            this.getModel().setValue("parentname", (Object)parent.getString("name"));
        }
    }

    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        Map map = this.getView().getFormShowParameter().getCustomParams();
        Long modelId = IDUtils.toLong(map.get("model"));
        Long parentId = IDUtils.toLong(map.get("parent"));
        this.getModel().setValue("model", (Object)modelId);
        if (IDUtils.isNotEmptyLong((Long)parentId).booleanValue()) {
            DynamicObject dy = RpaIntegrationCateDao.getInstance().load(parentId);
            this.getModel().setValue("parent", (Object)parentId);
            this.getModel().setValue("parentname", dy != null ? dy.getString("name") : null);
            int seq = RpaIntegrationCateDao.getInstance().getCurNodeSequence(modelId, parentId);
            this.getModel().setValue("sequence", (Object)seq);
        }
    }

    public void beforeClosed(BeforeClosedEvent e) {
        super.beforeClosed(e);
        this.getModel().setDataChanged(false);
    }

    @Override
    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        super.beforeDoOperation(args);
        String opType = ((FormOperate)args.getSource()).getType();
        if ("save".equals(opType)) {
            String number = (String)this.getModel().getValue("number");
            DynamicObject model = (DynamicObject)this.getModel().getValue("model");
            if (!CheckStringsUtil.check((String)number)) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u7f16\u7801\u53ea\u80fd\u7531\u534a\u89d2\u6570\u5b57\u548c\u534a\u89d2\u5b57\u6bcd\u7ec4\u6210\uff0c\u4e14\u4e0d\u5f97\u4ee5\u6570\u5b57\u5f00\u5934\uff0c\u8bf7\u4fee\u6539\u540e\u91cd\u8bd5\u3002", (String)"RpaIntegrationCateEditPlugin_0", (String)"epm-eb-formplugin", (Object[])new Object[0]), Integer.valueOf(5000));
                args.setCancel(true);
                return;
            }
            if (RpaIntegrationCateDao.getInstance().checkNumberExisted(IDUtils.toLong((Object)this.getModel().getValue("id")), Long.valueOf(model.getLong("id")), number)) {
                this.getView().showErrorNotification(ResManager.loadKDString((String)"\u76ee\u5f55\u7f16\u7801\u4e0d\u80fd\u91cd\u590d\u3002", (String)"RpaIntegrationCateEditPlugin_1", (String)"epm-eb-formplugin", (Object[])new Object[0]));
                args.setCancel(true);
                return;
            }
            OrmLocaleValue name = (OrmLocaleValue)this.getModel().getValue("name");
            if (StringUtils.isEmpty((String)name.getLocaleValue())) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u8f93\u5165\u540d\u79f0\u3002", (String)"RpaIntegrationCateEditPlugin_2", (String)"epm-eb-formplugin", (Object[])new Object[0]));
                args.setCancel(true);
            }
        }
    }

    @Override
    public void afterDoOperation(AfterDoOperationEventArgs e) {
        super.afterDoOperation(e);
        boolean isSuccess = e.getOperationResult().getValidateResult().isSuccess();
        List ids = e.getOperationResult().getSuccessPkIds();
        if (e.getSource() instanceof Save && isSuccess) {
            this.getView().returnDataToParent((Object)ids);
            this.getView().close();
        }
    }
}

