/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.formplugin.rpa;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import java.util.ArrayList;
import java.util.Collections;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.resource.promptenum.MultiLangEnumBridge;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.exception.KDBizException;
import kd.bos.form.CloseCallBack;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.ShowType;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.form.plugin.FormViewPluginProxy;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.epm.eb.business.rpa.CellMappingService;
import kd.epm.eb.business.rpa.RpaConstants;
import kd.epm.eb.business.rpa.RpaXmlOperatorHelper;
import kd.epm.eb.business.rpa.dao.RpaIntegrationCellDao;
import kd.epm.eb.business.rpa.dao.RpaIntegrationSheetDao;
import kd.epm.eb.business.rpa.entity.RpaIntegrationCell;
import kd.epm.eb.business.rpa.model.CellAreaMapping;
import kd.epm.eb.business.rpa.model.CellMapping;
import kd.epm.eb.business.rpa.model.JQReport;
import kd.epm.eb.common.enums.BgTemplateTypeEnum;
import kd.epm.eb.common.pageinteraction.CommandParam;
import kd.epm.eb.common.pageinteraction.MainPage;
import kd.epm.eb.common.utils.ExcelUtils;
import kd.epm.eb.common.utils.IDUtils;
import kd.epm.eb.common.utils.ObjectSerialUtil;
import kd.epm.eb.common.utils.OperationLogUtil;
import kd.epm.eb.common.utils.Point;
import kd.epm.eb.formplugin.AbstractBasePlugin;
import kd.epm.eb.formplugin.rpa.export.JqCsvService;
import kd.epm.eb.spread.baseplugin.AbstractReportPlugin;
import kd.epm.eb.spread.baseplugin.AbstractSpreadPlugin;
import kd.epm.eb.spread.command.rangedefined.CellArea;
import kd.epm.eb.spread.command.style.AreasStyle;
import kd.epm.eb.spread.command.style.CellStyleInfo;
import kd.epm.eb.spread.control.SpreadContainer;
import kd.epm.eb.spread.template.ITemplateModel;
import kd.epm.eb.spread.template.TemplateModelHelper;
import kd.epm.eb.spread.template.afix.multimanager.MultiAreaManager;
import kd.epm.eb.spread.template.spreadmanager.IEbSpreadManager;
import kd.epm.eb.spread.template.spreadmanager.sheet.ECell;
import kd.epm.eb.spread.template.spreadmanager.sheet.ISheet;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.collections4.MapUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.tuple.Pair;

public class RpaIntegrationCellEditPlugin
extends AbstractBasePlugin
implements BeforeF7SelectListener,
MainPage {
    private static final Log log = LogFactory.getLog(RpaIntegrationCellEditPlugin.class);
    private static final String EB_REPORT = "ebreport";
    private static final String EB_PAGE_ID = "eb_page_id";
    private static final String JQ_PAGE_ID = "jq_page_id";
    private static final String ALL_AREA = "all_area";
    private static final String ENUM_FIELD = "enum_field";
    private static final String HAS_MODIFY = "hasModify";
    private static final String TRUE_STR = "true";
    private static final String FALSE_STR = "false";
    private static final String ENUM_CONFIG_CLOSE_CALLBACK = "enumConfigCloseCallback";

    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        FormShowParameter formShowParameter = this.getView().getFormShowParameter();
        Long modelId = (Long)formShowParameter.getCustomParam("KEY_MODEL_ID");
        this.getPageCache().put("model", String.valueOf(modelId));
        this.getView().setVisible(Boolean.valueOf(false), new String[]{"sheetmappingbase"});
        this.initJqIframe();
        this.initEbIframe();
    }

    @Override
    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addItemClickListeners(new String[]{"toolbarap"});
        BasedataEdit sheetmappingbase = (BasedataEdit)this.getControl("sheetmappingbase");
        sheetmappingbase.addBeforeF7SelectListener((BeforeF7SelectListener)this);
    }

    @Override
    public void beforeF7Select(BeforeF7SelectEvent evt) {
    }

    public void itemClick(ItemClickEvent evt) {
        String key;
        super.itemClick(evt);
        switch (key = evt.getItemKey()) {
            case "btn_mapping": {
                this.mappingCell();
                break;
            }
            case "btn_save": {
                this.saveMappingCell();
                break;
            }
            case "btn_delete": {
                this.deleteMappingCell();
                break;
            }
            case "btn_excelmapping": {
                this.excelMappingCell();
                break;
            }
            case "btn_fieldenum": {
                this.openFieldEnumConfig();
                break;
            }
            case "btn_close": {
                this.closePage();
                break;
            }
        }
    }

    private void initEbIframe() {
        Long sheetMappingId = this.getSheetMappingId();
        String pageId = "eb_rpa_template_eb_" + this.getView().getPageId() + "_" + sheetMappingId;
        this.cachePageId(this.getPageCache(), "eb_rpa_template_eb", pageId);
        FormShowParameter showParameter = new FormShowParameter();
        showParameter.setPageId(pageId);
        showParameter.setFormId("eb_rpa_template_eb");
        showParameter.getOpenStyle().setShowType(ShowType.InContainer);
        showParameter.getOpenStyle().setTargetKey("splitpanelap1");
        showParameter.setCustomParam("KEY_MODEL_ID", (Object)this.getModelId());
        DynamicObject sheetMapping = RpaIntegrationSheetDao.getInstance().loadSingle(this.getSheetMappingId());
        this.setUnableBtn(sheetMapping, this.getRpaIntegrationId());
        long templateId = sheetMapping.getLong("template_id");
        Pair pair = TemplateModelHelper.getTemplateModel((String)String.valueOf(templateId));
        if (pair == null) {
            return;
        }
        ITemplateModel templateModel = (ITemplateModel)pair.getLeft();
        if (templateModel == null) {
            return;
        }
        showParameter.setCustomParam("templateid", (Object)templateId);
        showParameter.setCustomParam("bgtemplate_info", (Object)ObjectSerialUtil.toByteSerialized((Object)templateModel.getTemplateBaseInfo()));
        showParameter.setCustomParam("TemplateModel", pair.getRight());
        showParameter.setCustomParam("spreadserial", (Object)templateModel.getSpreadSerial());
        if (Integer.parseInt(BgTemplateTypeEnum.EBFIX.getNumber()) == templateModel.getTemplateBaseInfo().getTemplatetype()) {
            showParameter.addCustPlugin("kd.epm.eb.formplugin.rpa.report.FixTemplatePlugin");
        } else {
            showParameter.addCustPlugin("kd.epm.eb.formplugin.rpa.report.DynamicTemplatePlugin");
        }
        this.getPageCache().put(EB_PAGE_ID, pageId);
        this.getView().showForm(showParameter);
    }

    private void initJqIframe() {
        Long sheetMappingId = this.getSheetMappingId();
        String pageId = "eb_rpa_template_jq_" + this.getView().getPageId() + "_" + sheetMappingId;
        this.cachePageId(this.getPageCache(), "eb_rpa_template_jq", pageId);
        FormShowParameter showParameter = new FormShowParameter();
        showParameter.setFormId("eb_rpa_template_jq");
        showParameter.setPageId(pageId);
        showParameter.getOpenStyle().setShowType(ShowType.InContainer);
        showParameter.getOpenStyle().setTargetKey("splitpanelap2");
        showParameter.setCustomParam("sheetMappingId", (Object)this.getSheetMappingId());
        this.getPageCache().put(JQ_PAGE_ID, pageId);
        this.getView().showForm(showParameter);
    }

    private void initEbSpread() {
        JSONObject dataCacheMap = this.getDataCacheMap();
        if (dataCacheMap.isEmpty()) {
            return;
        }
        SpreadContainer ebSpreadContainer = this.getEbSpreadContainer();
        ArrayList<ECell> cells = new ArrayList<ECell>(dataCacheMap.size());
        for (String key : dataCacheMap.keySet()) {
            CellMapping cellMapping = (CellMapping)dataCacheMap.getObject(key, CellMapping.class);
            String[] rowColArr = cellMapping.getEbCell().split("#");
            String row = rowColArr[0];
            String col = rowColArr[1];
            String[] mappingValue = cellMapping.getJqCell().split("#");
            String mappingRow = mappingValue[0];
            String mappingCol = mappingValue[1];
            String cellValue = this.getNewValue(Integer.valueOf(mappingRow), Integer.valueOf(mappingCol));
            ECell eCell = new ECell(Integer.parseInt(row), Integer.parseInt(col), (Object)cellValue);
            cells.add(eCell);
        }
        ebSpreadContainer.updateCellValue2(cells);
        this.sendEbSpreadAction();
    }

    private void initArea() {
        Map areaMap = CellMappingService.getFloatArea((IEbSpreadManager)this.getEbSpreadManager(), (ITemplateModel)this.getTemplateModel());
        this.getPageCache().put(ALL_AREA, JSON.toJSONString((Object)areaMap));
    }

    private void setUnableBtn(DynamicObject sheetMapping, Long schemeId) {
        String effectStatus = sheetMapping.getString("effectstatus");
        if (RpaConstants.Status.ENABLE.getValue().equals(effectStatus)) {
            this.setBtnStatus(false);
            return;
        }
        DynamicObject scheme = BusinessDataServiceHelper.loadSingleFromCache((Object)schemeId, (String)"eb_rpa_integration");
        if (RpaConstants.Status.ENABLE.getValue().equals(effectStatus) || RpaConstants.Status.ENABLE.getValue().equals(scheme.getString("status"))) {
            this.setBtnStatus(false);
            return;
        }
        this.setBtnStatus(true);
    }

    private void setBtnStatus(boolean status) {
        this.getView().setEnable(Boolean.valueOf(status), new String[]{"btn_save", "btn_mapping", "btn_excelmapping", "btn_fieldenum", "btn_delete"});
        this.getView().setVisible(Boolean.valueOf(this.isZipExport() == false), new String[]{"btn_excelmapping"});
        this.getView().setVisible(this.isZipExport(), new String[]{"btn_fieldenum"});
    }

    private void openFieldEnumConfig() {
        JQReport jqReport = this.getJQReport();
        if (jqReport == null) {
            return;
        }
        String enumField = this.getPageCache().get(ENUM_FIELD);
        if (enumField == null) {
            DynamicObject dyObj = RpaIntegrationSheetDao.getInstance().loadSingle(this.getSheetMappingId());
            enumField = dyObj.getString("enumfield");
            this.getPageCache().put(ENUM_FIELD, enumField);
        }
        FormShowParameter showParameter = new FormShowParameter();
        showParameter.setFormId("eb_rpa_field_enum");
        showParameter.getOpenStyle().setShowType(ShowType.Modal);
        showParameter.setShowTitle(true);
        showParameter.setCaption(ResManager.loadResFormat((String)"\u679a\u4e3e\u5b57\u6bb5\u914d\u7f6e%1", (String)"RpaIntegrationCellEditPlugin_12", (String)"epm-eb-formplugin", (Object[])new Object[]{" - " + jqReport.getDesc()}));
        showParameter.setCustomParam(ENUM_FIELD, (Object)enumField);
        showParameter.setCustomParam("jq_report", (Object)SerializationUtils.toJsonString((Object)jqReport));
        showParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, ENUM_CONFIG_CLOSE_CALLBACK));
        this.getView().showForm(showParameter);
    }

    @Override
    public void closedCallBack(ClosedCallBackEvent closedCallBackEvent) {
        Object returnData;
        super.closedCallBack(closedCallBackEvent);
        String key = closedCallBackEvent.getActionId();
        if (ENUM_CONFIG_CLOSE_CALLBACK.equals(key) && (returnData = closedCallBackEvent.getReturnData()) != null) {
            this.getPageCache().put(ENUM_FIELD, returnData.toString());
        }
    }

    public void dealMsg(CommandParam com) {
        super.dealMsg(com);
        String operation = com.getOperation();
        if ("hideBtn".equals(operation)) {
            this.setBtnStatus(false);
        } else if ("lightCell".equals(operation)) {
            this.handCellLight(com);
        } else if ("clearStyle".equals(operation)) {
            this.blackPreLight();
        } else if ("ebSpreadLoadData".equals(operation)) {
            this.initEbSpread();
        }
    }

    private void blackPreLight() {
        String lightRow = this.getPageCache().get("light_rows");
        String lightCol = this.getPageCache().get("light_cols");
        if (StringUtils.isEmpty((CharSequence)lightRow) || StringUtils.isEmpty((CharSequence)lightCol)) {
            return;
        }
        List mappingRows = JSON.parseArray((String)lightRow, Integer.class);
        List mappingCols = JSON.parseArray((String)lightCol, Integer.class);
        ArrayList<CellArea> cellAreaList = new ArrayList<CellArea>(mappingRows.size() * mappingCols.size());
        for (Integer mappingRow : mappingRows) {
            for (Integer mappingCol : mappingCols) {
                cellAreaList.add(new CellArea(mappingRow.intValue(), mappingCol.intValue(), 1, 1));
            }
        }
        if (CollectionUtils.isNotEmpty(cellAreaList)) {
            CellStyleInfo cellStyleInfo = new CellStyleInfo();
            cellStyleInfo.setBkc("#ffffff");
            AreasStyle areasStyle = new AreasStyle(cellAreaList, cellStyleInfo);
            this.getEbSpreadContainer().setCellStyle(Collections.singletonList(areasStyle));
            this.sendEbSpreadAction();
        }
    }

    private void handCellLight(CommandParam command) {
        this.blackPreLight();
        List param = command.getParam();
        List selRows = (List)param.get(0);
        List selCols = (List)param.get(1);
        ArrayList<Integer> mappingRows = new ArrayList<Integer>();
        ArrayList<Integer> mappingCols = new ArrayList<Integer>();
        JSONObject dataCacheMap = this.getDataCacheMap();
        Map<String, String> reverseDataCacheMap = this.reverseDataCache(dataCacheMap);
        ArrayList<CellArea> cellAreaList = new ArrayList<CellArea>(selRows.size() * selCols.size());
        for (Integer selRow : selRows) {
            for (Integer selCol : selCols) {
                String key = selRow + "#" + selCol;
                if (!reverseDataCacheMap.containsKey(key)) continue;
                String locationStr = reverseDataCacheMap.get(key);
                String[] split = locationStr.split("#");
                int mappingRow = Integer.parseInt(split[0]);
                mappingRows.add(mappingRow);
                int mappingCol = Integer.parseInt(split[1]);
                mappingCols.add(mappingCol);
                cellAreaList.add(new CellArea(mappingRow, mappingCol, 1, 1));
            }
        }
        if (CollectionUtils.isNotEmpty(cellAreaList)) {
            CellStyleInfo cellStyleInfo = new CellStyleInfo();
            cellStyleInfo.setBkc("#00ff00");
            AreasStyle areasStyle = new AreasStyle(cellAreaList, cellStyleInfo);
            this.getEbSpreadContainer().setCellStyle(Collections.singletonList(areasStyle));
            this.sendEbSpreadAction();
        }
        this.getPageCache().put("light_rows", JSON.toJSONString(mappingRows));
        this.getPageCache().put("light_cols", JSON.toJSONString(mappingCols));
    }

    private JSONObject getDataCacheMap() {
        JSONObject cacheMap = new JSONObject();
        String dataStr = this.getPageCache().get("eb_cache_data");
        if (StringUtils.isEmpty((CharSequence)dataStr)) {
            RpaIntegrationCell rpaIntegrationCell = RpaIntegrationCellDao.getInstance().load(this.getRpaIntegrationId(), this.getSheetMappingId());
            if (rpaIntegrationCell == null) {
                return cacheMap;
            }
            dataStr = rpaIntegrationCell.getRefData();
            if (StringUtils.isEmpty((CharSequence)dataStr)) {
                return cacheMap;
            }
            JSONArray dataArr = JSONObject.parseObject((String)dataStr).getJSONArray("data");
            if (dataArr == null) {
                return cacheMap;
            }
            dataArr.forEach(data -> {
                CellAreaMapping cellAreaMapping = (CellAreaMapping)((JSONObject)data).toJavaObject(CellAreaMapping.class);
                for (Object obj : cellAreaMapping.getMappings()) {
                    CellMapping cellMapping = obj instanceof JSONObject ? (CellMapping)((JSONObject)obj).toJavaObject(CellMapping.class) : (CellMapping)obj;
                    cacheMap.put(cellMapping.getEbCell(), (Object)cellMapping);
                }
            });
            this.getPageCache().put("eb_cache_data", JSON.toJSONString((Object)cacheMap));
            return cacheMap;
        }
        return JSON.parseObject((String)dataStr);
    }

    private void saveDataCacheMap(JSONObject dataCacheMap) {
        this.getPageCache().put("eb_cache_data", dataCacheMap.toJSONString());
        this.getPageCache().put(HAS_MODIFY, TRUE_STR);
    }

    private Map<String, String> reverseDataCache(JSONObject dataCacheMap) {
        HashMap<String, String> reverseDataCacheMap = new HashMap<String, String>(dataCacheMap.size());
        for (String key : dataCacheMap.keySet()) {
            CellMapping cellMapping = (CellMapping)dataCacheMap.getObject(key, CellMapping.class);
            reverseDataCacheMap.put(cellMapping.getJqCell(), cellMapping.getEbCell());
        }
        return reverseDataCacheMap;
    }

    private List<Pair<Integer[], List<Integer[]>>> getAreaInt(String filterArea) {
        Map<String, List<String>> areaMap = this.getAreaCache();
        if (MapUtils.isEmpty(areaMap)) {
            return Collections.emptyList();
        }
        return areaMap.entrySet().stream().map(entry -> {
            if (StringUtils.isNotEmpty((CharSequence)filterArea) && !filterArea.equals(entry.getKey())) {
                return null;
            }
            Integer[] allArea = (Integer[])CellMappingService.getAreaInt(Collections.singletonList(entry.getKey())).get(0);
            List floatArea = CellMappingService.getAreaInt((List)((List)entry.getValue()));
            return Pair.of((Object)allArea, (Object)floatArea);
        }).filter(Objects::nonNull).collect(Collectors.toList());
    }

    private Map<String, List<String>> getAreaCache() {
        String areaStr = this.getPageCache().get(ALL_AREA);
        if (StringUtils.isBlank((CharSequence)areaStr)) {
            this.initArea();
            areaStr = this.getPageCache().get(ALL_AREA);
        }
        if (StringUtils.isBlank((CharSequence)areaStr)) {
            return Collections.emptyMap();
        }
        return (Map)JSONObject.parseObject((String)areaStr, Map.class);
    }

    private void closePage() {
        String hasModify = this.getPageCache().get(HAS_MODIFY);
        if (TRUE_STR.equals(hasModify)) {
            this.getView().showConfirm(ResManager.loadKDString((String)"\u5355\u5143\u683c\u6620\u5c04\u5df2\u53d8\u66f4\uff0c\u662f\u5426\u4fdd\u5b58\uff1f", (String)"RpaIntegrationCellEditPlugin_0", (String)"epm-eb-formplugin", (Object[])new Object[0]), MessageBoxOptions.YesNo, new ConfirmCallBackListener("closePage", (IFormPlugin)this));
        } else {
            this.getView().close();
        }
    }

    public void confirmCallBack(MessageBoxClosedEvent evt) {
        super.confirmCallBack(evt);
        String callBackId = evt.getCallBackId();
        if (MessageBoxResult.No.equals((Object)evt.getResult()) && "closePage".equals(callBackId)) {
            this.getView().close();
            return;
        }
        if (MessageBoxResult.No.equals((Object)evt.getResult())) {
            return;
        }
        if ("closePage".equals(callBackId)) {
            this.saveMappingCell();
            this.getView().close();
        }
    }

    private void excelMappingCell() {
        boolean hasMapping = false;
        IEbSpreadManager spreadManager = this.getEbSpreadManager();
        List areaManagers = spreadManager.getMultiAreaManager();
        for (MultiAreaManager areaManager : areaManagers) {
            IEbSpreadManager jqSpreadManager = this.getJqSpreadManager();
            JSONObject dataCacheMap = this.getDataCacheMap();
            String areaRange = areaManager.getAreaRange().toString();
            List<Pair<Integer[], List<Integer[]>>> areaIntList = this.getAreaInt(areaRange);
            if (CollectionUtils.isEmpty(areaIntList)) continue;
            String[] areaArr = areaRange.split(":");
            Point startPoint = ExcelUtils.pos2Point((String)areaArr[0]);
            Point endPoint = areaArr.length == 1 ? ExcelUtils.pos2Point((String)areaArr[0]) : ExcelUtils.pos2Point((String)areaArr[1]);
            JQReport jqReport = this.getJQReport();
            ArrayList<ECell> cells = new ArrayList<ECell>();
            for (int row = startPoint.y; row <= endPoint.y; ++row) {
                for (int col = startPoint.x; col <= endPoint.x; ++col) {
                    String fixValue;
                    ECell jqCell;
                    int isInFloatArea = CellMappingService.isInFloatArea((int)row, (int)col, areaIntList);
                    if (jqSpreadManager == null || isInFloatArea != 1 && isInFloatArea != 3 || this.checkNotStandardContent(jqCell = jqSpreadManager.getEbook().getSheet(0).getECell(row, col)) || StringUtils.isEmpty((CharSequence)(fixValue = this.getFixValue(jqCell.valueToString(), jqSpreadManager.getEbook().getSheet(0), row)))) continue;
                    if (this.isZipExport().booleanValue() && jqReport != null) {
                        Boolean isFloat = JqCsvService.getInstance().isFloat(jqCell.valueToString(), jqReport);
                        if (isFloat == null) {
                            this.getView().showTipNotification(ResManager.loadKDString((String)"\u65e0\u6548\u5355\u5143\u683c\u4e0d\u80fd\u6620\u5c04\uff0c\u8bf7\u68c0\u67e5xml\u914d\u7f6e\u6587\u4ef6\u8ddfexcel\u6a21\u677f\u662f\u5426\u5339\u914d\u3002", (String)"RpaIntegrationCellEditPlugin_11", (String)"epm-eb-formplugin", (Object[])new Object[0]));
                            continue;
                        }
                        if (isInFloatArea == 1 && !isFloat.booleanValue()) {
                            this.getView().showTipNotification(ResManager.loadKDString((String)"\u56fa\u5b9a\u5355\u5143\u683c\u4e0d\u80fd\u6620\u5c04\u5230\u6d6e\u52a8\u884c\u3002", (String)"RpaIntegrationCellEditPlugin_8", (String)"epm-eb-formplugin", (Object[])new Object[0]));
                            continue;
                        }
                        if (isInFloatArea == 3 && isFloat.booleanValue()) {
                            this.getView().showTipNotification(ResManager.loadKDString((String)"\u6d6e\u52a8\u5355\u5143\u683c\u4e0d\u80fd\u6620\u5c04\u5230\u56fa\u5b9a\u533a\u57df\u3002", (String)"RpaIntegrationCellEditPlugin_9", (String)"epm-eb-formplugin", (Object[])new Object[0]));
                            continue;
                        }
                    }
                    String newValue = this.getNewValue(row, col);
                    ECell eCell = new ECell(row, col, (Object)newValue);
                    cells.add(eCell);
                    this.cacheMappingData(row, col, row, col, fixValue, dataCacheMap);
                    hasMapping = true;
                }
            }
            if (!CollectionUtils.isNotEmpty(cells)) continue;
            this.getEbSpreadContainer().updateCellValue2(cells);
            this.sendEbSpreadAction();
            this.saveDataCacheMap(dataCacheMap);
        }
        if (!hasMapping) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u65e0\u53ef\u6620\u5c04\u5355\u5143\u683c\u3002", (String)"RpaIntegrationCellEditPlugin_1", (String)"epm-eb-formplugin", (Object[])new Object[0]));
        }
    }

    private void deleteMappingCell() {
        String ebDataStr = this.getChildView(EB_PAGE_ID).getPageCache().get("eb_report_cell_data");
        if (ebDataStr == null) {
            return;
        }
        JSONObject ebObject = JSONObject.parseObject((String)ebDataStr);
        JSONArray ebSelRows = ebObject.getJSONArray("selRows");
        JSONArray ebSelCols = ebObject.getJSONArray("selCols");
        JSONObject dataCacheMap = this.getDataCacheMap();
        SpreadContainer ebSpreadContainer = this.getEbSpreadContainer();
        ArrayList<ECell> cells = new ArrayList<ECell>();
        for (Object ebSelRow : ebSelRows) {
            for (Object ebSelCol : ebSelCols) {
                Integer ebSelRowInt = (Integer)ebSelRow;
                Integer ebSelColInt = (Integer)ebSelCol;
                if (!dataCacheMap.containsKey((Object)(ebSelRowInt + "#" + ebSelColInt))) continue;
                ECell eCell = new ECell(ebSelRowInt.intValue(), ebSelColInt.intValue(), null);
                cells.add(eCell);
                dataCacheMap.remove((Object)(ebSelRowInt + "#" + ebSelColInt));
            }
        }
        ebSpreadContainer.updateCellValue2(cells);
        this.sendEbSpreadAction();
        this.saveDataCacheMap(dataCacheMap);
        CommandParam cmd = new CommandParam("eb_rpa_cellmapping", "eb_rpa_template_jq", "clearStyle", new Object[0]);
        this.dealMsg(cmd);
        this.sendMsg(this.getView(), cmd);
    }

    private void saveMappingCell() {
        try {
            JSONObject dataCacheMap = this.getDataCacheMap();
            Long sheetMappingId = this.getSheetMappingId();
            Long rpaIntegrationId = this.getRpaIntegrationId();
            IEbSpreadManager spreadManager = this.getEbSpreadManager();
            Map<String, List<String>> areaMap = this.getAreaCache();
            String enumFieldConfig = this.getPageCache().get(ENUM_FIELD);
            CellMappingService.saveMappingCell((JSONObject)dataCacheMap, (Long)sheetMappingId, (Long)rpaIntegrationId, (IEbSpreadManager)spreadManager, areaMap, (String)enumFieldConfig);
            this.getPageCache().put(HAS_MODIFY, FALSE_STR);
            MultiLangEnumBridge opName = new MultiLangEnumBridge("\u4fdd\u5b58", "RpaIntegrationCellEditPlugin_6", "epm-eb-formplugin");
            MultiLangEnumBridge opDesc = new MultiLangEnumBridge("RPA\u96c6\u6210\u65b9\u6848ID\u201c%1$s\u201d\uff0c\u8868\u683c\u6620\u5c04ID\u201c%2$s\u201d\uff0c\u5df2\u4fdd\u5b58\u3002", "RpaIntegrationCellEditPlugin_7", "epm-eb-formplugin");
            OperationLogUtil.log((String)this.getView().getFormShowParameter().getAppId(), (String)this.getView().getModel().getDataEntityType().getName(), null, (String)"save", (MultiLangEnumBridge)opName, (MultiLangEnumBridge)opDesc, (String[])new String[]{String.valueOf(rpaIntegrationId), String.valueOf(rpaIntegrationId)});
            this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u4fdd\u5b58\u6210\u529f\u3002", (String)"RpaIntegrationCellEditPlugin_2", (String)"epm-eb-formplugin", (Object[])new Object[0]));
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            throw new KDBizException(e.getMessage());
        }
    }

    private void mappingCell() {
        JSONArray ebSelCols;
        IEbSpreadManager spreadManager;
        JSONArray jqSelCols;
        IFormView jqChildFormView = this.getChildView(JQ_PAGE_ID);
        String jqDataStr = jqChildFormView.getPageCache().get("jq_report_cell_data");
        if (jqDataStr == null) {
            return;
        }
        JSONObject jqObject = JSONObject.parseObject((String)jqDataStr);
        JSONArray jqSelRows = jqObject.getJSONArray("selRows");
        boolean isStandardContent = this.checkNotStandardContent((List<Object>)jqSelRows, (List<Object>)(jqSelCols = jqObject.getJSONArray("selCols")), spreadManager = this.getJqSpreadManager());
        if (!isStandardContent && !this.isZipExport().booleanValue()) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u4e45\u5176\u5355\u5143\u683c\u9700\u4e3a\uff1a[,]\u3001[]\uff1b\u4f8b\u5982\uff1a[36,1]\u3001[MX4]\u3002", (String)"RpaIntegrationCellEditPlugin_3", (String)"epm-eb-formplugin", (Object[])new Object[0]));
            return;
        }
        if (isStandardContent && this.isZipExport().booleanValue()) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u63a5\u53e3\u5bfc\u51fa\u65b9\u5f0f\u4e0d\u652f\u6301\u5e26\u4e2d\u62ec\u53f7\u7684\u5355\u5143\u683c\u6620\u5c04\u3002", (String)"RpaIntegrationCellEditPlugin_10", (String)"epm-eb-formplugin", (Object[])new Object[0]));
            return;
        }
        IFormView ebChildFormView = this.getChildView(EB_PAGE_ID);
        String ebDataStr = ebChildFormView.getPageCache().get("eb_report_cell_data");
        if (ebDataStr == null) {
            return;
        }
        JSONObject ebObject = JSONObject.parseObject((String)ebDataStr);
        JSONArray ebSelRows = ebObject.getJSONArray("selRows");
        if (!this.checkMappingArea((List<Object>)ebSelRows, (List<Object>)(ebSelCols = ebObject.getJSONArray("selCols")))) {
            return;
        }
        JQReport jqReport = this.getJQReport();
        JSONObject dataCacheMap = this.getDataCacheMap();
        Map<String, String> reverseDataCacheMap = this.reverseDataCache(dataCacheMap);
        ArrayList<ECell> cells = new ArrayList<ECell>();
        for (int i = 0; i < ebSelRows.size() && jqSelRows.size() >= i + 1; ++i) {
            for (int j = 0; j < ebSelCols.size() && jqSelCols.size() >= j + 1; ++j) {
                ECell cell;
                String fixValue;
                Integer jqSelRowInt = (Integer)jqSelRows.get(i);
                Integer jqSelColInt = (Integer)jqSelCols.get(j);
                String key = jqSelRowInt + "#" + jqSelColInt;
                if (reverseDataCacheMap.containsKey(key) || StringUtils.isEmpty((CharSequence)(fixValue = this.getFixValue((cell = spreadManager.getEbook().getSheet(0).getECell(jqSelRowInt.intValue(), jqSelColInt.intValue())).valueToString(), spreadManager.getEbook().getSheet(0), jqSelRowInt)))) continue;
                Integer ebSelRowInt = (Integer)ebSelRows.get(i);
                Integer ebSelColInt = (Integer)ebSelCols.get(j);
                if (this.isZipExport().booleanValue() && jqReport != null) {
                    int isInFloatArea = CellMappingService.isInFloatArea((int)ebSelRowInt, (int)ebSelColInt, this.getAreaInt(null));
                    Boolean isFloat = JqCsvService.getInstance().isFloat(cell.valueToString(), jqReport);
                    if (isFloat == null) {
                        this.getView().showTipNotification(ResManager.loadKDString((String)"\u65e0\u6548\u5355\u5143\u683c\u4e0d\u80fd\u6620\u5c04\uff0c\u8bf7\u68c0\u67e5xml\u914d\u7f6e\u6587\u4ef6\u8ddfexcel\u6a21\u677f\u662f\u5426\u5339\u914d\u3002", (String)"RpaIntegrationCellEditPlugin_11", (String)"epm-eb-formplugin", (Object[])new Object[0]));
                        continue;
                    }
                    if (isInFloatArea == 1 && !isFloat.booleanValue()) {
                        this.getView().showTipNotification(ResManager.loadKDString((String)"\u56fa\u5b9a\u5355\u5143\u683c\u4e0d\u80fd\u6620\u5c04\u5230\u6d6e\u52a8\u884c\u3002", (String)"RpaIntegrationCellEditPlugin_8", (String)"epm-eb-formplugin", (Object[])new Object[0]));
                        continue;
                    }
                    if (isInFloatArea == 3 && isFloat.booleanValue()) {
                        this.getView().showTipNotification(ResManager.loadKDString((String)"\u6d6e\u52a8\u5355\u5143\u683c\u4e0d\u80fd\u6620\u5c04\u5230\u56fa\u5b9a\u533a\u57df\u3002", (String)"RpaIntegrationCellEditPlugin_9", (String)"epm-eb-formplugin", (Object[])new Object[0]));
                        continue;
                    }
                }
                String newValue = this.getNewValue(jqSelRowInt, jqSelColInt);
                ECell eCell = new ECell(ebSelRowInt.intValue(), ebSelColInt.intValue(), (Object)newValue);
                cells.add(eCell);
                this.cacheMappingData(ebSelRowInt, ebSelColInt, jqSelRowInt, jqSelColInt, fixValue, dataCacheMap);
            }
        }
        if (CollectionUtils.isNotEmpty(cells)) {
            this.getEbSpreadContainer().updateCellValue2(cells);
            this.sendEbSpreadAction();
            this.saveDataCacheMap(dataCacheMap);
        }
    }

    private void cacheMappingData(Integer ebSelRowInt, Integer ebSelColInt, Integer jqSelRowInt, Integer jqSelColInt, String cellValue, JSONObject dataCacheMap) {
        String ebCell = ebSelRowInt + "#" + ebSelColInt;
        String jqCell = jqSelRowInt + "#" + jqSelColInt;
        dataCacheMap.put(ebCell, (Object)new CellMapping(ebCell, jqCell, cellValue));
    }

    private boolean checkNotStandardContent(List<Object> jqSelRows, List<Object> jqSelCols, IEbSpreadManager spreadManager) {
        ISheet sheet = spreadManager.getEbook().getSheet(0);
        for (Object selRow : jqSelRows) {
            for (Object selCol : jqSelCols) {
                ECell cell = sheet.getECell(((Integer)selRow).intValue(), ((Integer)selCol).intValue());
                if (!this.checkNotStandardContent(cell)) continue;
                return false;
            }
        }
        return true;
    }

    private boolean checkNotStandardContent(ECell cell) {
        if (cell == null) {
            return true;
        }
        String valueToString = cell.valueToString();
        if (valueToString == null) {
            return true;
        }
        return !valueToString.startsWith("[") || !valueToString.endsWith("]");
    }

    private boolean checkMappingArea(List<Object> ebSelRows, List<Object> ebSelCols) {
        for (Object ebSelRow : ebSelRows) {
            for (Object ebSelCol : ebSelCols) {
                int col;
                int row = (Integer)ebSelRow;
                int isInFloatArea = CellMappingService.isInFloatArea((int)row, (int)(col = ((Integer)ebSelCol).intValue()), this.getAreaInt(null));
                if (isInFloatArea == 2) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u6d6e\u52a8\u533a\u57df\u53ea\u80fd\u6620\u5c04\u5728\u7b2c\u4e00\u884c\u3002", (String)"RpaIntegrationCellEditPlugin_4", (String)"epm-eb-formplugin", (Object[])new Object[0]));
                    return false;
                }
                if (isInFloatArea != 4) continue;
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u53ea\u80fd\u6620\u5c04\u5728\u6570\u636e\u533a\u57df\u5185\u3002", (String)"RpaIntegrationCellEditPlugin_5", (String)"epm-eb-formplugin", (Object[])new Object[0]));
                return false;
            }
        }
        return true;
    }

    private String getFixValue(String value, ISheet sheet, Integer row) {
        if (StringUtils.isEmpty((CharSequence)value)) {
            return value;
        }
        if (value.startsWith("[") && value.endsWith("]")) {
            if (value.contains(",")) {
                return value;
            }
            value = value.replaceAll("\\[", "").replaceAll("]", "");
        }
        if (StringUtils.isEmpty((CharSequence)value)) {
            return value;
        }
        int maxColumnCount = sheet.getMaxColumnCount();
        for (int i = 0; i < maxColumnCount; ++i) {
            String valueToString;
            ECell cell = sheet.getECell(row.intValue(), i);
            if (cell == null || StringUtils.isEmpty((CharSequence)(valueToString = cell.valueToString())) || !valueToString.startsWith("[") || !valueToString.endsWith("]") || !valueToString.contains(",")) continue;
            String realRow = valueToString.split(",")[0].substring(1);
            return "[" + realRow + "," + value + "]";
        }
        return "[-1," + value + "]";
    }

    private String getNewValue(Integer jqSelRowInt, Integer jqSelColInt) {
        return "[" + ExcelUtils.int2pos((int)jqSelColInt) + "," + (jqSelRowInt + 1) + "]";
    }

    private IFormView getChildView(String pageKey) {
        String pageId = this.getPageCache().get(pageKey);
        return this.getView().getView(pageId);
    }

    private SpreadContainer getEbSpreadContainer() {
        IFormView childView = this.getChildView(EB_PAGE_ID);
        return new SpreadContainer(childView, EB_REPORT);
    }

    private void sendEbSpreadAction() {
        this.getView().sendFormAction(this.getChildView(EB_PAGE_ID));
    }

    private IEbSpreadManager getEbSpreadManager() {
        AbstractReportPlugin reportPlugin = this.getReportPlugin(EB_PAGE_ID);
        if (reportPlugin != null) {
            return reportPlugin.getSpreadManager();
        }
        throw new KDBizException("getReportPlugin null");
    }

    private IEbSpreadManager getJqSpreadManager() {
        AbstractSpreadPlugin reportPlugin = this.getSpreadPlugin(JQ_PAGE_ID);
        if (reportPlugin != null) {
            return reportPlugin.getSpreadManager();
        }
        throw new KDBizException("getSpreadPlugin null");
    }

    private ITemplateModel getTemplateModel() {
        AbstractReportPlugin reportPlugin = this.getReportPlugin(EB_PAGE_ID);
        if (reportPlugin != null) {
            return reportPlugin.getTemplateModel();
        }
        throw new KDBizException("getReportPlugin null");
    }

    private AbstractReportPlugin getReportPlugin(String pageKey) {
        IFormView childView = this.getChildView(pageKey);
        FormViewPluginProxy proxy = (FormViewPluginProxy)childView.getService(FormViewPluginProxy.class);
        Optional<IFormPlugin> optional = proxy.getPlugIns().stream().filter(e -> AbstractReportPlugin.class.isAssignableFrom(e.getClass())).findFirst();
        return optional.orElse(null);
    }

    private AbstractSpreadPlugin getSpreadPlugin(String pageKey) {
        IFormView childView = this.getChildView(pageKey);
        FormViewPluginProxy proxy = (FormViewPluginProxy)childView.getService(FormViewPluginProxy.class);
        Optional<IFormPlugin> optional = proxy.getPlugIns().stream().filter(e -> AbstractSpreadPlugin.class.isAssignableFrom(e.getClass())).findFirst();
        return optional.orElse(null);
    }

    private Long getSheetMappingId() {
        return (Long)this.getView().getFormShowParameter().getCustomParam("sheetMappingId");
    }

    private Long getRpaIntegrationId() {
        return (Long)this.getView().getFormShowParameter().getCustomParam("integrationId");
    }

    @Override
    public Long getModelId() {
        return IDUtils.toLong((Object)this.getPageCache().get("model"));
    }

    private Boolean isZipExport() {
        String customParam = (String)this.getView().getFormShowParameter().getCustomParam("isZipExport");
        return Boolean.parseBoolean(customParam);
    }

    private JQReport getJQReport() {
        JQReport jqReport;
        if (!this.isZipExport().booleanValue()) {
            return null;
        }
        JQReport jQReport = jqReport = this.getPageCache().get("JQReportData") == null ? null : (JQReport)SerializationUtils.fromJsonString((String)this.getPageCache().get("JQReportData"), JQReport.class);
        if (jqReport == null) {
            String sheetName = (String)this.getView().getFormShowParameter().getCustomParam("sheetName");
            Map jqReportMap = RpaXmlOperatorHelper.getReport((Long)this.getRpaIntegrationId());
            jqReport = (JQReport)jqReportMap.get(sheetName.toLowerCase());
            if (jqReport == null) {
                throw new KDBizException(ResManager.loadResFormat((String)"xml\u914d\u7f6e\u6587\u4ef6\u4e2d\u672a\u627e\u5230[%1]\u7684\u914d\u7f6e\uff0c\u8bf7\u68c0\u67e5\u3002", (String)"RpaIntegrationCellEditPlugin_13", (String)"epm-eb-formplugin", (Object[])new Object[]{sheetName}));
            }
            this.getPageCache().put("JQReportData", SerializationUtils.toJsonString((Object)jqReport));
        }
        return jqReport;
    }
}

