/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.formplugin.rpa;

import java.util.EventObject;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.bill.OperationStatus;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.OrmLocaleValue;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.operate.Save;
import kd.bos.form.control.AttachmentPanel;
import kd.bos.form.control.events.UploadEvent;
import kd.bos.form.control.events.UploadListener;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeClosedEvent;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.form.operate.FormOperate;
import kd.bos.list.ListShowParameter;
import kd.bos.orm.query.QFilter;
import kd.epm.eb.business.rpa.RpaConstants;
import kd.epm.eb.business.rpa.dao.RpaIntegrationDao;
import kd.epm.eb.business.rpa.dao.RpaIntegrationSheetDao;
import kd.epm.eb.business.utils.CheckStringsUtil;
import kd.epm.eb.common.utils.IDUtils;
import kd.epm.eb.common.utils.StringUtils;
import kd.epm.eb.formplugin.AbstractBasePlugin;

public class RpaIntegrationEditPlugin
extends AbstractBasePlugin
implements BeforeF7SelectListener,
UploadListener {
    private static final String CATE_ID = "cateid";
    private static final String MODEL = "model";
    private static final String BIZ_MODEL = "bizmodel";
    private static final String EXPORT_TYPE = "type";
    private static final String KEY_BIZ_MODEL = "keyBizModel";
    private static final String ATTACHMENT_PANEL = "attachmentpanelap";
    private static final String ATTACHMENT_STATUS = "attachmentStatus";

    @Override
    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addClickListeners(new String[]{"save", "close"});
        AttachmentPanel panel = (AttachmentPanel)this.getView().getControl(ATTACHMENT_PANEL);
        panel.addUploadListener((UploadListener)this);
        BasedataEdit businessModel = (BasedataEdit)this.getView().getControl(BIZ_MODEL);
        businessModel.addBeforeF7SelectListener((BeforeF7SelectListener)this);
    }

    public void afterLoadData(EventObject e) {
        super.afterLoadData(e);
        Long rpaIntegrationId = IDUtils.toLong((Object)this.getModel().getValue("id"));
        if (RpaIntegrationSheetDao.getInstance().existedSheetMappingData(rpaIntegrationId)) {
            this.getView().setEnable(Boolean.valueOf(false), new String[]{ATTACHMENT_PANEL});
        }
    }

    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        Map map = this.getView().getFormShowParameter().getCustomParams();
        Object objModel = map.get("KEY_MODEL_ID");
        Object objParent = map.get("key_cate_id");
        if (!"0".equals(objModel)) {
            this.getModel().setValue(MODEL, objModel);
            this.getPageCache().put(MODEL, objModel.toString());
        }
        if (!"0".equals(objParent)) {
            this.getModel().setValue(CATE_ID, objParent);
        }
    }

    @Override
    public void beforeF7Select(BeforeF7SelectEvent e) {
        String key = e.getProperty().getName();
        if (BIZ_MODEL.equals(key)) {
            QFilter qf = new QFilter(MODEL, "=", (Object)this.getModelId());
            ListShowParameter param = (ListShowParameter)e.getFormShowParameter();
            param.getListFilterParameter().setFilter(qf);
        }
    }

    @Override
    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        super.beforeDoOperation(args);
        String opType = ((FormOperate)args.getSource()).getType();
        if ("save".equals(opType)) {
            IDataModel dataModel = this.getModel();
            dataModel.setValue("modifier", (Object)this.getUserId());
            DynamicObject model = (DynamicObject)dataModel.getValue(MODEL);
            if (model == null) {
                args.setCancel(true);
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bfb\u53d6\u4f53\u7cfb\u5931\u8d25\uff0c\u8bf7\u8fd4\u56de\u540e\u91cd\u8bd5\u3002", (String)"RpaIntegrationEditPlugin_1", (String)"epm-eb-formplugin", (Object[])new Object[0]));
                return;
            }
            String number = (String)dataModel.getValue("number");
            if (StringUtils.isEmpty((String)number)) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u8f93\u5165\u7f16\u7801\u3002", (String)"ApprovePlanClassifyPlugin_02", (String)"epm-eb-formplugin", (Object[])new Object[0]));
                args.setCancel(true);
                return;
            }
            if (!CheckStringsUtil.check((String)number)) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u7f16\u7801\u53ea\u80fd\u5305\u542b\u534a\u89d2\u6570\u5b57\u548c\u534a\u89d2\u5b57\u6bcd\uff0c\u4e14\u4e0d\u80fd\u4ee5\u6570\u5b57\u5f00\u5934\uff0c\u8bf7\u4fee\u6539\u540e\u91cd\u8bd5\u3002", (String)"RpaIntegrationEditPlugin_2", (String)"epm-eb-formplugin", (Object[])new Object[0]), Integer.valueOf(5000));
                args.setCancel(true);
                return;
            }
            if (RpaIntegrationDao.getInstance().checkNumberExisted(IDUtils.toLong((Object)this.getModel().getValue("id")), Long.valueOf(model.getLong("id")), number)) {
                this.getView().showErrorNotification(ResManager.loadKDString((String)"\u540c\u4e00\u4f53\u7cfb\u4e0b\u5df2\u5b58\u5728\u76f8\u540c\u7f16\u7801\u7684RPA\u96c6\u6210\u65b9\u6848\u3002", (String)"RpaIntegrationEditPlugin_3", (String)"epm-eb-formplugin", (Object[])new Object[0]));
                args.setCancel(true);
                return;
            }
            OrmLocaleValue name = (OrmLocaleValue)this.getModel().getValue("name");
            if (StringUtils.isEmpty((String)name.getLocaleValue())) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u8f93\u5165\u540d\u79f0\u3002", (String)"RpaIntegrationEditPlugin_4", (String)"epm-eb-formplugin", (Object[])new Object[0]));
                args.setCancel(true);
                return;
            }
            DynamicObject bizModel = (DynamicObject)this.getModel().getValue(BIZ_MODEL);
            if (bizModel == null) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u4e1a\u52a1\u6a21\u578b\u3002", (String)"RpaIntegrationEditPlugin_5", (String)"epm-eb-formplugin", (Object[])new Object[0]));
                args.setCancel(true);
                return;
            }
            args.setCancel(this.checkAttachFile());
        }
    }

    public void beforeClosed(BeforeClosedEvent e) {
        super.beforeClosed(e);
        if (OperationStatus.EDIT.equals((Object)this.getView().getFormShowParameter().getStatus())) {
            if (Boolean.parseBoolean(this.getPageCache().get(ATTACHMENT_STATUS))) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u9644\u4ef6\u88ab\u4fee\u6539\uff0c\u8bf7\u5148\u4fdd\u5b58\u3002", (String)"RpaIntegrationEditPlugin_8", (String)"epm-eb-formplugin", (Object[])new Object[0]));
                e.setCancel(true);
                return;
            }
            e.setCancel(this.checkAttachFile());
        }
        this.getModel().setDataChanged(false);
    }

    @Override
    public void afterDoOperation(AfterDoOperationEventArgs e) {
        super.afterDoOperation(e);
        boolean isSuccess = e.getOperationResult().getValidateResult().isSuccess();
        List ids = e.getOperationResult().getSuccessPkIds();
        if (e.getSource() instanceof Save && isSuccess && ids.size() > 0) {
            Long rpaIntegrationId = (Long)ids.get(0);
            this.getView().returnDataToParent((Object)rpaIntegrationId);
            this.getPageCache().put(ATTACHMENT_STATUS, "false");
            this.getView().close();
        }
    }

    @Override
    public void closedCallBack(ClosedCallBackEvent closedCallBackEvent) {
        super.closedCallBack(closedCallBackEvent);
        String key = closedCallBackEvent.getActionId();
        if (KEY_BIZ_MODEL.equals(key)) {
            String id = (String)closedCallBackEvent.getReturnData();
            if (StringUtils.isEmpty((String)id)) {
                return;
            }
            this.getModel().setValue(BIZ_MODEL, (Object)id);
        }
    }

    public void afterRemove(UploadEvent evt) {
        this.getPageCache().put(ATTACHMENT_STATUS, "true");
    }

    public void afterUpload(UploadEvent evt) {
        this.getPageCache().put(ATTACHMENT_STATUS, "true");
    }

    @Override
    public Long getModelId() {
        Long modelId;
        if (this.getPageCache().get(MODEL) == null || Long.parseLong(this.getPageCache().get(MODEL)) == 0L) {
            DynamicObject model = (DynamicObject)this.getModel().getValue(MODEL);
            if (model == null) {
                return 0L;
            }
            modelId = model.getLong("id");
            this.getPageCache().put(MODEL, modelId.toString());
        } else {
            modelId = Long.valueOf(this.getPageCache().get(MODEL));
        }
        return modelId;
    }

    private boolean checkAttachFile() {
        String exportType = (String)this.getModel().getValue(EXPORT_TYPE);
        AttachmentPanel panel = (AttachmentPanel)this.getView().getControl(ATTACHMENT_PANEL);
        List attachmentData = panel.getAttachmentData();
        List fileNames = attachmentData.stream().map(e -> String.valueOf(e.get("name")).toLowerCase(Locale.ENGLISH)).collect(Collectors.toList());
        boolean matchExcel = fileNames.stream().anyMatch(e -> e.endsWith(".xls") || e.endsWith(".xlsx"));
        if (RpaConstants.ExportType.ZIP.getValue().equals(exportType)) {
            boolean matchXml = fileNames.stream().anyMatch(e -> e.endsWith(".xml"));
            if (!matchExcel || !matchXml) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u5bfc\u51fa\u65b9\u5f0f\u4e3a\u201c\u63a5\u53e3\u201d\u65f6\uff0c\u5fc5\u987b\u4e0a\u4f20\u4e00\u4e2a\u540e\u7f00\u4e3a\u201c.xls\u201d\u3001\u201c.xlsx\u201d\u6216\u8005\u201c.xml\u201d\u683c\u5f0f\u7684\u9644\u4ef6\u3002", (String)"RpaIntegrationEditPlugin_7", (String)"epm-eb-formplugin", (Object[])new Object[0]));
                return true;
            }
        } else if (attachmentData.size() != 1 || !matchExcel) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u5bfc\u51fa\u65b9\u5f0f\u4e3a\u201c\u5bfc\u51faexcel\u201d\u65f6\uff0c\u5fc5\u987b\u4e0a\u4f20\u4e00\u4e2a\u540e\u7f00\u4e3a\u201c.xls\u201d\u6216\u8005\u201c.xlsx\u201d\u683c\u5f0f\u7684\u9644\u4ef6\u3002", (String)"RpaIntegrationEditPlugin_6", (String)"epm-eb-formplugin", (Object[])new Object[0]));
            return true;
        }
        return false;
    }
}

