/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.formplugin.rpa;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.base.BaseShowParameter;
import kd.bos.bill.OperationStatus;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.resource.promptenum.MultiLangEnumBridge;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.ObjectUtils;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.tree.TreeNode;
import kd.bos.exception.KDBizException;
import kd.bos.form.CloseCallBack;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.IPageCache;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.ShowType;
import kd.bos.form.control.Control;
import kd.bos.form.control.TreeView;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.form.control.events.TreeNodeClickListener;
import kd.bos.form.control.events.TreeNodeEvent;
import kd.bos.form.events.BillListHyperLinkClickEvent;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.HyperLinkClickArgs;
import kd.bos.form.events.HyperLinkClickEvent;
import kd.bos.form.events.HyperLinkClickListener;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.events.SetFilterEvent;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.BillList;
import kd.bos.list.ListFilterParameter;
import kd.bos.list.ListShowParameter;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.mvc.form.FormView;
import kd.bos.orm.query.QFilter;
import kd.bos.util.StringUtils;
import kd.epm.eb.business.rpa.RpaConstants;
import kd.epm.eb.business.rpa.dao.RpaIntegrationAttachmentDao;
import kd.epm.eb.business.rpa.dao.RpaIntegrationCateDao;
import kd.epm.eb.business.rpa.dao.RpaIntegrationDao;
import kd.epm.eb.business.rpa.dao.RpaIntegrationSheetDao;
import kd.epm.eb.business.rpa.dao.RpaSchemeDao;
import kd.epm.eb.business.rpa.entity.RpaIntegration;
import kd.epm.eb.common.tree.ITreeNode;
import kd.epm.eb.common.tree.TreeModel;
import kd.epm.eb.common.tree.integrationcate.IntegrationCateTree;
import kd.epm.eb.common.tree.integrationcate.IntegrationCateTreeBuild;
import kd.epm.eb.common.utils.IDUtils;
import kd.epm.eb.common.utils.base.ObjUtils;
import kd.epm.eb.formplugin.AbstractListPlugin;
import kd.epm.eb.formplugin.utils.TreeSearchUtil;
import kd.epm.eb.model.utils.ModelUtil;
import kd.epm.eb.model.utils.UserSelectUtil;
import org.apache.commons.collections4.CollectionUtils;

public class RpaIntegrationListPlugin
extends AbstractListPlugin
implements BeforeF7SelectListener {
    private static final Log log = LogFactory.getLog(RpaIntegrationListPlugin.class);
    private static final String CATE_TREE = "catetree";
    private static final String TREE_CHECK_BOX = "treecheckbox";
    private static final String INTEGRATION_CLOSE_CALLBACK = "integrationCloseCallback";
    private static final String INTEGRATION_CATE_CLOSE_CALLBACK = "integrationCateCloseCallback";
    private static final String INTEGRATION_MOVE_CLOSE_CALLBACK = "integrationMoveCloseCallback";
    private static final String DELETE_CATE_CONFIRM = "deleteCateConfirm";
    private static final String DELETE_RPA_INTEGRATION_CONFIRM = "deleteRpaIntegrationConfirm";

    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        Long modelId = UserSelectUtil.getModelIdAfterCreateNewData((IFormView)this.getView(), (String)"model", (boolean)false);
        if (IDUtils.isNull((Long)modelId)) {
            BillList billList = (BillList)this.getView().getControl("billlistap");
            billList.setFilter(new QFilter("1", "!=", (Object)1));
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u65b0\u589e\u4f53\u7cfb\u3002", (String)"RpaIntegrationListPlugin_1", (String)"epm-eb-formplugin", (Object[])new Object[0]));
            return;
        }
        this.getModel().setValue("model", (Object)modelId);
        this.cacheModelId(modelId);
        this.refreshTreeAndBillListData();
    }

    @Override
    public void registerListener(EventObject e) {
        super.registerListener(e);
        if (this.getView().getClass().equals(FormView.class)) {
            this.addItemClickListeners(new String[]{"toolbarap"});
        }
        this.addClickListeners(new String[]{"btn_addcate", "btn_deletecate", "btn_modifycate"});
        BasedataEdit basedataEdit = (BasedataEdit)this.getControl("model");
        if (basedataEdit != null) {
            basedataEdit.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        }
        TreeView tview = (TreeView)this.getControl(CATE_TREE);
        tview.addTreeNodeClickListener(new TreeNodeClickListener(){

            public void treeNodeClick(TreeNodeEvent evt) {
                super.treeNodeClick(evt);
                RpaIntegrationListPlugin.this.refreshBillList();
            }
        });
        BillList billList = (BillList)this.getControl("billlistap");
        billList.addHyperClickListener((HyperLinkClickListener)this);
    }

    public void propertyChanged(PropertyChangedArgs e) {
        String key;
        super.propertyChanged(e);
        switch (key = e.getProperty().getName()) {
            case "treecheckbox": {
                this.refreshBillList();
                break;
            }
            case "model": {
                Long modelId = UserSelectUtil.getF7SelectId((IFormView)this.getView(), (String)"model");
                if (IDUtils.isNull((Long)modelId)) {
                    this.getModel().setValue("model", (Object)this.getPageCache().get("KEY_MODEL_ID"));
                    break;
                }
                if (modelId.equals(IDUtils.toLong((Object)this.getPageCache().get("KEY_MODEL_ID")))) {
                    return;
                }
                UserSelectUtil.saveUserSelectWhenModelChange((IFormView)this.getView(), (Long)modelId);
                this.cacheModelId(modelId);
                this.refreshTreeAndBillListData();
                break;
            }
        }
    }

    @Override
    public Long getModelId() {
        long modelId = 0L;
        String model = this.getPageCache().get("KEY_MODEL_ID");
        if (model != null) {
            modelId = Long.parseLong(model);
        }
        return modelId;
    }

    public void setFilter(SetFilterEvent e) {
        super.setFilter(e);
        e.getQFilters().add(this.getBillListQFilter());
        e.setOrderBy("id");
    }

    @Override
    public void beforeF7Select(BeforeF7SelectEvent e) {
        String key = e.getProperty().getName();
        if ("model".equals(key) && this.getControl("model") != null) {
            ListShowParameter showParameter = (ListShowParameter)e.getFormShowParameter();
            ArrayList qFilterList = ((BasedataEdit)this.getControl("model")).getQFilters();
            if (qFilterList == null) {
                qFilterList = new ArrayList();
            }
            qFilterList.addAll(ModelUtil.getModelFilter((IFormView)this.getView()));
            showParameter.setListFilterParameter(new ListFilterParameter(qFilterList, null));
        }
    }

    public void itemClick(ItemClickEvent evt) {
        super.itemClick(evt);
        this.checkPermission(this.getView(), evt.getItemKey());
        if (!this.validator()) {
            return;
        }
        String key = evt.getItemKey();
        ListSelectedRowCollection selectedRows = ((BillList)this.getControl("billlistap")).getSelectedRows();
        switch (key) {
            case "btn_add": {
                this.openIntegrationPage(null);
                break;
            }
            case "btn_copy": {
                this.copyRpaIntegration();
                break;
            }
            case "btn_delete": {
                this.checkIsSelectData(selectedRows);
                this.checkDataIsExistedEnable(selectedRows);
                this.checkByRpaSchemeRef(selectedRows, null);
                this.getView().showConfirm(ResManager.loadKDString((String)"\u786e\u8ba4\u5220\u9664\u6570\u636e\uff1f", (String)"RpaIntegrationListPlugin_22", (String)"epm-eb-formplugin", (Object[])new Object[0]), MessageBoxOptions.OKCancel, new ConfirmCallBackListener(DELETE_RPA_INTEGRATION_CONFIRM, (IFormPlugin)this));
                break;
            }
            case "btn_move": {
                this.checkIsSelectData(selectedRows);
                this.openIntegrationMovePage(selectedRows);
                break;
            }
            case "btn_enable": {
                this.checkIsSelectData(selectedRows);
                this.modifyRpaIntegrationStatus(RpaConstants.Status.ENABLE);
                break;
            }
            case "btn_disable": {
                this.checkIsSelectData(selectedRows);
                this.checkByRpaSchemeRef(selectedRows, RpaConstants.Status.ENABLE);
                this.modifyRpaIntegrationStatus(RpaConstants.Status.DISABLE);
                break;
            }
            case "btn_refresh": {
                this.refreshBillList();
                break;
            }
            case "btn_sheetmapping": {
                this.checkIsSelectOneData(selectedRows);
                this.openSheetMapping(selectedRows);
                break;
            }
            case "btn_entity": {
                this.checkIsSelectOneData(selectedRows);
                this.openEntityPage(IDUtils.toLong((Object)selectedRows.get(0).getPrimaryKeyValue()));
                break;
            }
        }
    }

    public void click(EventObject evt) {
        super.click(evt);
        Control c = (Control)evt.getSource();
        if (!this.validator()) {
            return;
        }
        String nodeId = ((TreeView)this.getControl(CATE_TREE)).getTreeState().getFocusNodeId();
        if (StringUtils.isEmpty((String)nodeId)) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u4e00\u6761\u65b9\u6848\u5206\u7c7b\u3002", (String)"RpaIntegrationListPlugin_2", (String)"epm-eb-formplugin", (Object[])new Object[0]));
            return;
        }
        switch (c.getKey().toLowerCase()) {
            case "btn_addcate": {
                this.openIntegrationCatePage(nodeId, true);
                break;
            }
            case "btn_deletecate": {
                if (this.isRootCatalog(nodeId)) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u6839\u8282\u70b9\u4e0d\u5141\u8bb8\u5220\u9664\u3002", (String)"RpaIntegrationListPlugin_4", (String)"epm-eb-formplugin", (Object[])new Object[0]));
                    return;
                }
                this.checkIsCateAndSubCateExistedIntegration();
                this.getView().showConfirm(ResManager.loadKDString((String)"\u65b9\u6848\u5206\u7c7b\u53ca\u5b50\u5206\u7c7b\u5c06\u88ab\u5220\u9664\uff0c\u662f\u5426\u7ee7\u7eed\u5220\u9664\uff1f", (String)"RpaIntegrationListPlugin_5", (String)"epm-eb-formplugin", (Object[])new Object[0]), MessageBoxOptions.OKCancel, new ConfirmCallBackListener(DELETE_CATE_CONFIRM, (IFormPlugin)this));
                break;
            }
            case "btn_modifycate": {
                this.openIntegrationCatePage(nodeId, false);
                break;
            }
        }
    }

    @Override
    public void hyperLinkClick(HyperLinkClickEvent e) {
        super.hyperLinkClick(e);
        Object pkId = ((BillListHyperLinkClickEvent)e).getCurrentRow().getPrimaryKeyValue();
        this.openIntegrationPage(IDUtils.toLong((Object)pkId));
    }

    @Override
    public void billListHyperLinkClick(HyperLinkClickArgs args) {
        super.billListHyperLinkClick(args);
        args.setCancel(true);
    }

    @Override
    public void closedCallBack(ClosedCallBackEvent closedCallBackEvent) {
        String key;
        super.closedCallBack(closedCallBackEvent);
        switch (key = closedCallBackEvent.getActionId()) {
            case "integrationCloseCallback": {
                Long returnData = (Long)closedCallBackEvent.getReturnData();
                if (!IDUtils.isNotEmptyLong((Long)returnData).booleanValue()) break;
                this.refreshBillList();
                break;
            }
            case "integrationCateCloseCallback": {
                ArrayList ids;
                ArrayList arrayList = ids = closedCallBackEvent.getReturnData() == null ? null : (ArrayList)closedCallBackEvent.getReturnData();
                if (ids == null || ids.size() <= 0) break;
                Long nodeId = (Long)ids.get(0);
                this.refreshTreeById(String.valueOf(nodeId));
                break;
            }
            case "integrationMoveCloseCallback": {
                String nodeId;
                String string = nodeId = closedCallBackEvent.getReturnData() == null ? null : (String)closedCallBackEvent.getReturnData();
                if (!StringUtils.isNotEmpty((String)nodeId)) break;
                this.refreshTreeById(nodeId);
            }
        }
    }

    public void confirmCallBack(MessageBoxClosedEvent e) {
        super.confirmCallBack(e);
        String callBackId = e.getCallBackId();
        if (callBackId.equals(DELETE_CATE_CONFIRM) && e.getResult().equals((Object)MessageBoxResult.Yes)) {
            this.deleteRpaIntegrationCate();
        }
        if (callBackId.equals(DELETE_RPA_INTEGRATION_CONFIRM) && e.getResult().equals((Object)MessageBoxResult.Yes)) {
            this.deleteRpaIntegration();
        }
    }

    private void refreshBillList() {
        BillList billList = (BillList)this.getView().getControl("billlistap");
        billList.setFilter(this.getBillListQFilter());
        billList.setOrderBy("id");
        billList.setClearSelection(true);
        billList.refresh();
    }

    private QFilter getBillListQFilter() {
        QFilter qFilter = new QFilter("model", "=", (Object)this.getModelId());
        String focusNodeId = ((TreeView)this.getControl(CATE_TREE)).getTreeState().getFocusNodeId();
        if (focusNodeId != null) {
            boolean isAllChild = Boolean.parseBoolean(this.getModel().getValue(TREE_CHECK_BOX).toString());
            QFilter qFilter1 = new QFilter("cateid", "=", (Object)IDUtils.toLong((Object)focusNodeId));
            if (isAllChild) {
                TreeModel treeModel = TreeModel.toTreeModel((IPageCache)this.getPageCache());
                List childrenIds = treeModel.seekChildrenByGivenNodeIds(Long.valueOf(Long.parseLong(focusNodeId)), true);
                qFilter1 = new QFilter("cateid", "in", (Object)childrenIds);
            }
            qFilter = qFilter.and(qFilter1);
        }
        return qFilter;
    }

    private void cacheModelId(Long modelId) {
        this.getPageCache().put("KEY_MODEL_ID", modelId.toString());
    }

    private Long getModelIdFromCache() {
        return IDUtils.toLong((Object)this.getPageCache().get("KEY_MODEL_ID"));
    }

    private void refreshTreeAndBillListData() {
        this.refreshTree();
        this.refreshBillList();
    }

    private TreeModel<IntegrationCateTree> refreshTree() {
        TreeView treeview = (TreeView)this.getControl(CATE_TREE);
        Long modelId = this.getModelIdFromCache();
        IntegrationCateTree root = IntegrationCateTreeBuild.getIntegrationCateTree((Long)modelId);
        TreeModel treeModel = new TreeModel((ITreeNode)root);
        TreeNode treeNode = treeModel.buildEntryTree(treeview);
        this.getPageCache().put("treeCacheName", SerializationUtils.toJsonString((Object)treeNode));
        TreeSearchUtil.clearSearchPageCache(this.getPageCache(), new TreeSearchUtil.TreeSearchParam());
        treeModel.cache2page(this.getPageCache());
        treeview.focusNode(new TreeNode(null, String.valueOf(root.getId()), null));
        return treeModel;
    }

    private void refreshTreeById(String nodeId) {
        TreeModel<IntegrationCateTree> treeModel = this.refreshTree();
        ITreeNode currentNode = treeModel.searchByNodeId(IDUtils.toLong((Object)nodeId));
        String parentId = currentNode.getParent() == null ? null : currentNode.getParent().getId().toString();
        TreeView treeview = (TreeView)this.getControl(CATE_TREE);
        treeview.focusNode(new TreeNode(parentId, nodeId, null));
        this.refreshBillList();
    }

    private void openIntegrationPage(Long pkId) {
        if (!this.validator()) {
            return;
        }
        Long modelId = this.getModelIdFromCache();
        TreeView treeView = (TreeView)this.getControl(CATE_TREE);
        String cateId = treeView.getTreeState().getFocusNodeId();
        if (StringUtils.isEmpty((String)cateId)) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u4e00\u6761\u65b9\u6848\u5206\u7c7b\u3002", (String)"RpaIntegrationListPlugin_2", (String)"epm-eb-formplugin", (Object[])new Object[0]));
            return;
        }
        BaseShowParameter showParameter = new BaseShowParameter();
        showParameter.setFormId("eb_rpa_integration");
        CloseCallBack closeCallBack = new CloseCallBack((IFormPlugin)this, INTEGRATION_CLOSE_CALLBACK);
        showParameter.setCloseCallBack(closeCallBack);
        showParameter.getOpenStyle().setShowType(ShowType.Modal);
        showParameter.setShowTitle(true);
        showParameter.setCaption(ResManager.loadKDString((String)"RPA\u96c6\u6210\u65b9\u6848", (String)"RpaIntegrationListPlugin_3", (String)"epm-eb-formplugin", (Object[])new Object[0]));
        if (IDUtils.isNotEmptyLong((Long)pkId).booleanValue()) {
            showParameter.setPkId((Object)pkId);
            showParameter.setStatus(OperationStatus.EDIT);
        } else {
            showParameter.setStatus(OperationStatus.ADDNEW);
            showParameter.setCustomParam("KEY_MODEL_ID", (Object)modelId);
            showParameter.setCustomParam("key_cate_id", (Object)cateId);
        }
        this.getView().showForm((FormShowParameter)showParameter);
    }

    private void openIntegrationMovePage(ListSelectedRowCollection selectedRows) {
        List ids = selectedRows.stream().map(v -> IDUtils.toLong((Object)v.getPrimaryKeyValue().toString())).collect(Collectors.toList());
        String focusNodeId = ((TreeView)this.getControl(CATE_TREE)).getTreeState().getFocusNodeId();
        TreeModel treeModel = TreeModel.toTreeModel((IPageCache)this.getPageCache());
        if (treeModel == null || treeModel.getRoot() == null || treeModel.getRoot().getChildren().size() == 0) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u65e0\u6cd5\u79fb\u52a8\u5230\u5bf9\u5e94\u7684\u65b9\u6848\u5206\u7c7b\uff0c\u8bf7\u65b0\u589e\u65b9\u6848\u5206\u7c7b\u3002", (String)"RpaIntegrationListPlugin_29", (String)"epm-eb-formplugin", (Object[])new Object[0]));
            return;
        }
        Long modelId = this.getModelIdFromCache();
        FormShowParameter showParameter = new FormShowParameter();
        showParameter.setFormId("eb_rpa_integration_move");
        showParameter.setCustomParam("KEY_MODEL_ID", (Object)modelId);
        showParameter.setCustomParam("cateId", (Object)focusNodeId);
        showParameter.setCustomParam("integrationId", ids);
        showParameter.getOpenStyle().setShowType(ShowType.Modal);
        CloseCallBack closeCallBack = new CloseCallBack((IFormPlugin)this, INTEGRATION_MOVE_CLOSE_CALLBACK);
        showParameter.setCloseCallBack(closeCallBack);
        this.getView().showForm(showParameter);
    }

    private void openIntegrationCatePage(String nodeId, boolean isAddNew) {
        HashMap<String, Object> params = new HashMap<String, Object>();
        Long modelId = this.getModelIdFromCache();
        params.put("model", modelId);
        CloseCallBack closeCallBack = new CloseCallBack((IFormPlugin)this, INTEGRATION_CATE_CLOSE_CALLBACK);
        if (isAddNew) {
            long id = Long.parseLong(nodeId);
            params.put("parent", id);
            this.showRpaIntegrationCateForm(params, closeCallBack, 0L);
        } else if (this.isRootCatalog(nodeId)) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u6839\u8282\u70b9\u4e0d\u5141\u8bb8\u4fee\u6539\u3002", (String)"RpaIntegrationListPlugin_9", (String)"epm-eb-formplugin", (Object[])new Object[0]));
        } else {
            long id = Long.parseLong(nodeId);
            this.showRpaIntegrationCateForm(params, closeCallBack, id);
        }
    }

    private void showRpaIntegrationCateForm(Map<String, Object> params, CloseCallBack closeCallBack, long id) {
        BaseShowParameter param = new BaseShowParameter();
        param.getOpenStyle().setShowType(ShowType.Modal);
        param.setFormId("eb_rpa_integration_cate");
        if (id != 0L) {
            param.setPkId((Object)id);
            param.setStatus(OperationStatus.EDIT);
        }
        if (params.size() > 0) {
            param.setCustomParams(params);
        }
        if (closeCallBack != null) {
            param.setCloseCallBack(closeCallBack);
        }
        this.getView().showForm((FormShowParameter)param);
    }

    private boolean validator() {
        String modelId = this.getPageCache().get("KEY_MODEL_ID");
        if (StringUtils.isEmpty((String)modelId)) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u65b0\u589e\u4f53\u7cfb\u3002", (String)"RpaIntegrationListPlugin_1", (String)"epm-eb-formplugin", (Object[])new Object[0]));
            return false;
        }
        return true;
    }

    private boolean isRootCatalog(String nodeId) {
        TreeModel treeModel = TreeModel.toTreeModel((IPageCache)this.getPageCache());
        if (treeModel == null) {
            return true;
        }
        ITreeNode treeNode = treeModel.searchByNodeId(Long.valueOf(Long.parseLong(nodeId)));
        return treeNode != null && (treeNode.getParent() == null || treeNode.getParent().getId() == 0L);
    }

    private void deleteRpaIntegration() {
        ListSelectedRowCollection selectedRows = ((BillList)this.getControl("billlistap")).getSelectedRows();
        List ids = selectedRows.stream().map(v -> IDUtils.toLong((Object)v.getPrimaryKeyValue().toString())).collect(Collectors.toList());
        if (CollectionUtils.isEmpty(ids)) {
            return;
        }
        RpaIntegrationDao.getInstance().delete(ids);
        MultiLangEnumBridge opName = new MultiLangEnumBridge("\u5220\u9664", "RpaIntegrationListPlugin_6", "epm-eb-formplugin");
        MultiLangEnumBridge opDesc = new MultiLangEnumBridge("RPA\u96c6\u6210\u65b9\u6848id:%1$s\u5220\u9664\u6210\u529f\u3002", "RpaIntegrationListPlugin_10", "epm-eb-formplugin");
        this.writeLogWithEntityNumber(this.getView().getModel().getDataEntityType().getName(), null, "delete", opName, opDesc, new String[]{ids.toString()});
        this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u5220\u9664\u6210\u529f\u3002", (String)"RpaIntegrationListPlugin_7", (String)"epm-eb-formplugin", (Object[])new Object[0]));
        this.refreshBillList();
    }

    private void deleteRpaIntegrationCate() {
        RpaIntegrationCateDao.getInstance().deleteById(this.getCurrentCateChildIds());
        MultiLangEnumBridge opName = new MultiLangEnumBridge("\u5220\u9664", "RpaIntegrationListPlugin_6", "epm-eb-formplugin");
        MultiLangEnumBridge opDesc = new MultiLangEnumBridge("\u65b9\u6848\u5206\u7c7b\u5df2\u5220\u9664\u3002", "RpaIntegrationListPlugin_8", "epm-eb-formplugin");
        this.writeLogWithEntityNumber(this.getView().getModel().getDataEntityType().getName(), null, "delete", opName, opDesc, null);
        this.refreshTree();
        this.refreshBillList();
        this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u5220\u9664\u6210\u529f\u3002", (String)"RpaIntegrationListPlugin_7", (String)"epm-eb-formplugin", (Object[])new Object[0]));
    }

    private List<Long> getCurrentCateChildIds() {
        TreeView tree = (TreeView)this.getControl(CATE_TREE);
        TreeModel treemodel = TreeModel.toTreeModel((IPageCache)this.getPageCache());
        ITreeNode currentTreeNode = treemodel.searchByNodeId(Long.valueOf(Long.parseLong(tree.getTreeState().getFocusNodeId())));
        List childIds = treemodel.seekChildrenByGivenNodeIds(currentTreeNode.getId(), true);
        return childIds;
    }

    private void copyRpaIntegration() {
        ListSelectedRowCollection selectedRows = ((BillList)this.getControl("billlistap")).getSelectedRows();
        if (selectedRows.size() != 1) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u4e00\u884c\u8981\u590d\u5236\u7684\u6570\u636e\u3002", (String)"RpaIntegrationListPlugin_11", (String)"epm-eb-formplugin", (Object[])new Object[0]));
            return;
        }
        Long id = IDUtils.toLong((Object)selectedRows.get(0).getPrimaryKeyValue().toString());
        RpaIntegrationDao.getInstance().copyRpaIntegration(id);
        MultiLangEnumBridge opName = new MultiLangEnumBridge("\u590d\u5236", "RpaIntegrationListPlugin_12", "epm-eb-formplugin");
        MultiLangEnumBridge opDesc = new MultiLangEnumBridge("RPA\u96c6\u6210\u65b9\u6848id\uff1a%1$s\u590d\u5236\u6210\u529f\u3002", "RpaIntegrationListPlugin_13", "epm-eb-formplugin");
        this.writeLogWithEntityNumber(this.getView().getModel().getDataEntityType().getName(), null, "copy", opName, opDesc, ObjUtils.getStringArray((Object[])new Object[]{id}));
        this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u590d\u5236\u6210\u529f\u3002", (String)"RpaIntegrationListPlugin_14", (String)"epm-eb-formplugin", (Object[])new Object[0]));
        this.refreshBillList();
    }

    private void checkIsCateAndSubCateExistedIntegration() {
        if (RpaIntegrationDao.getInstance().queryExistedIntegrationByCateId(this.getCurrentCateChildIds())) {
            throw new KDBizException(ResManager.loadKDString((String)"\u8be5\u76ee\u5f55\u53ca\u5b50\u76ee\u5f55\u5b58\u5728RPA\u96c6\u6210\u65b9\u6848\uff0c\u4e0d\u80fd\u88ab\u5220\u9664\u3002", (String)"RpaIntegrationListPlugin_26", (String)"epm-eb-formplugin", (Object[])new Object[0]));
        }
    }

    private void checkIsSelectData(ListSelectedRowCollection selectedRows) {
        if (selectedRows.size() == 0) {
            throw new KDBizException(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u6570\u636e\u3002", (String)"RpaIntegrationListPlugin_23", (String)"epm-eb-formplugin", (Object[])new Object[0]));
        }
    }

    private void checkIsSelectOneData(ListSelectedRowCollection selectedRows) {
        if (selectedRows.size() != 1) {
            throw new KDBizException(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u65b9\u6848\u3002", (String)"RpaIntegrationListPlugin_24", (String)"epm-eb-formplugin", (Object[])new Object[0]));
        }
    }

    private void checkDataIsExistedEnable(ListSelectedRowCollection selectedRows) {
        List ids = selectedRows.stream().map(v -> IDUtils.toLong((Object)v.getPrimaryKeyValue().toString())).collect(Collectors.toList());
        DynamicObjectCollection dynamicObjects = RpaIntegrationDao.getInstance().queryStatus(ids);
        if (dynamicObjects.stream().anyMatch(dynamicObject -> RpaConstants.Status.ENABLE.getValue().equals(dynamicObject.getString("status")))) {
            throw new KDBizException(ResManager.loadKDString((String)"RPA\u96c6\u6210\u65b9\u6848\u5df2\u542f\u7528\uff0c\u65e0\u6cd5\u5220\u9664\u3002", (String)"RpaIntegrationListPlugin_21", (String)"epm-eb-formplugin", (Object[])new Object[0]));
        }
    }

    private void checkByRpaSchemeRef(ListSelectedRowCollection selectedRows, RpaConstants.Status status) {
        List ids = selectedRows.stream().map(v -> IDUtils.toLong((Object)v.getPrimaryKeyValue().toString())).collect(Collectors.toList());
        if (RpaSchemeDao.getInstance().checkRpaIntegrationByRef(ids, status)) {
            throw new KDBizException(ResManager.loadKDString((String)"RPA\u96c6\u6210\u65b9\u6848\u5df2\u88abRPA\u673a\u5668\u4eba\u5f15\u7528\uff0c\u65e0\u6cd5\u5220\u9664\u6216\u7981\u7528\u3002", (String)"RpaIntegrationListPlugin_27", (String)"epm-eb-formplugin", (Object[])new Object[0]));
        }
    }

    private List<Long> checkSheetEffectStatus(List<Long> ids) {
        DynamicObject[] dynamicObjects = RpaIntegrationSheetDao.getInstance().queryStatusByRpaIntegration(ids);
        ArrayList<Long> removeIds = new ArrayList<Long>(ids.size());
        ids.forEach(id -> {
            List filter = Arrays.stream(dynamicObjects).filter(dynamicObject -> id.equals(dynamicObject.getLong("rpainte.id"))).collect(Collectors.toList());
            if (filter.isEmpty() || filter.stream().anyMatch(dynamicObject -> RpaConstants.EffectStatus.NONEFFECTIVE.getValue().equals(dynamicObject.getString("effectstatus")))) {
                removeIds.add((Long)id);
            }
        });
        return removeIds;
    }

    private void modifyRpaIntegrationStatus(RpaConstants.Status status) {
        ListSelectedRowCollection selectedRows = ((BillList)this.getControl("billlistap")).getSelectedRows();
        List<Long> ids = selectedRows.stream().map(v -> IDUtils.toLong((Object)v.getPrimaryKeyValue().toString())).collect(Collectors.toList());
        if (CollectionUtils.isEmpty(ids)) {
            return;
        }
        if (status == RpaConstants.Status.ENABLE) {
            List<Long> removeIds = this.checkSheetEffectStatus(ids);
            if (!removeIds.isEmpty()) {
                ids.removeAll(removeIds);
                RpaIntegrationDao.getInstance().updateStatus(status, ids);
                this.getView().showTipNotification(ResManager.loadKDString((String)"RPA\u96c6\u6210\u65b9\u6848\u65e0\u6cd5\u542f\u7528\uff0c\u8868\u683c\u6620\u5c04\u65e0\u6570\u636e\u6216\u6570\u636e\u672a\u5168\u90e8\u751f\u6548\u3002", (String)"RpaIntegrationListPlugin_28", (String)"epm-eb-formplugin", (Object[])new Object[0]));
            } else {
                RpaIntegrationDao.getInstance().updateStatus(status, ids);
                this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u542f\u7528\u6210\u529f\u3002", (String)"RpaIntegrationListPlugin_17", (String)"epm-eb-formplugin", (Object[])new Object[0]));
            }
            MultiLangEnumBridge opName = new MultiLangEnumBridge("\u542f\u7528", "RpaIntegrationListPlugin_15", "epm-eb-formplugin");
            MultiLangEnumBridge opDesc = new MultiLangEnumBridge("RPA\u96c6\u6210\u65b9\u6848id\uff1a%1$s\u542f\u7528\u6210\u529f\u3002", "RpaIntegrationListPlugin_16", "epm-eb-formplugin");
            this.writeLogWithEntityNumber(this.getView().getModel().getDataEntityType().getName(), null, "enable", opName, opDesc, ObjUtils.getStringArray((Object[])new Object[]{ids.toString()}));
        }
        if (status == RpaConstants.Status.DISABLE) {
            RpaIntegrationDao.getInstance().updateStatus(status, ids);
            MultiLangEnumBridge opName = new MultiLangEnumBridge("\u7981\u7528", "RpaIntegrationListPlugin_18", "epm-eb-formplugin");
            MultiLangEnumBridge opDesc = new MultiLangEnumBridge("RPA\u96c6\u6210\u65b9\u6848id\uff1a%1$s\u7981\u7528\u6210\u529f\u3002", "RpaIntegrationListPlugin_19", "epm-eb-formplugin");
            this.writeLogWithEntityNumber(this.getView().getModel().getDataEntityType().getName(), null, "disable", opName, opDesc, ObjUtils.getStringArray((Object[])new Object[]{ids.toString()}));
            this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u7981\u7528\u6210\u529f\u3002", (String)"RpaIntegrationListPlugin_20", (String)"epm-eb-formplugin", (Object[])new Object[0]));
        }
        this.refreshBillList();
    }

    private void openSheetMapping(ListSelectedRowCollection selectedRows) {
        Object primaryKeyValue = selectedRows.get(0).getPrimaryKeyValue();
        boolean isExcelImport = RpaIntegrationAttachmentDao.getInstance().checkAttachmentExisted(IDUtils.toLong((Object)primaryKeyValue));
        if (!isExcelImport) {
            throw new KDBizException(ResManager.loadKDString((String)"RPA\u96c6\u6210\u65b9\u6848\u65e0\u9644\u4ef6\uff0c\u65e0\u6cd5\u6253\u5f00\u8868\u683c\u6620\u5c04\u754c\u9762\u3002", (String)"RpaIntegrationListPlugin_25", (String)"epm-eb-formplugin", (Object[])new Object[0]));
        }
        Long bizModel = RpaIntegrationDao.getInstance().queryBizModel(IDUtils.toLong((Object)primaryKeyValue));
        String pageId = this.getView().getPageId() + primaryKeyValue + "actionSheetMapping";
        IFormView view = this.getView();
        IFormView mainPageView = view.getMainView();
        if (ObjectUtils.isEmpty((Object)mainPageView) || ObjectUtils.isEmpty((Object)mainPageView.getView(pageId))) {
            ListShowParameter showParameter = new ListShowParameter();
            showParameter.setFormId("eb_rpa_sheetmapping_list");
            showParameter.setPageId(pageId);
            showParameter.setCustomParam("KEY_MODEL_ID", (Object)this.getModelId());
            showParameter.setCustomParam("integrationId", primaryKeyValue);
            showParameter.setCustomParam("bizmodel", (Object)bizModel);
            showParameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
            IFormView parentView = view.getParentView();
            if (ObjectUtils.isEmpty((Object)parentView)) {
                this.getView().showForm((FormShowParameter)showParameter);
            } else {
                parentView.showForm((FormShowParameter)showParameter);
                view.sendFormAction(parentView);
            }
        } else {
            IFormView childView = mainPageView.getView(pageId);
            childView.activate();
            view.sendFormAction(childView);
        }
    }

    private void openEntityPage(Long integrationId) {
        RpaIntegration data = RpaIntegrationDao.getInstance().load(integrationId);
        String pageId = this.getView().getPageId() + integrationId + "actionEntity";
        ListShowParameter lsp = new ListShowParameter();
        lsp.setPageId(pageId);
        lsp.getOpenStyle().setShowType(ShowType.MainNewTabPage);
        lsp.setBillFormId("eb_rpa_entity_ref");
        lsp.setCustomParam("KEY_MODEL_ID", (Object)this.getModelId());
        lsp.setCustomParam("integrationId", (Object)integrationId);
        lsp.setCustomParam("bizmodel", (Object)data.getBizModelId());
        this.getView().showForm((FormShowParameter)lsp);
    }
}

