/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.formplugin.rpa;

import java.util.ArrayList;
import java.util.EventObject;
import java.util.List;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.resource.promptenum.MultiLangEnumBridge;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.entity.tree.TreeNode;
import kd.bos.form.control.Control;
import kd.bos.form.control.Search;
import kd.bos.form.control.TreeView;
import kd.bos.form.control.events.TreeNodeClickListener;
import kd.bos.form.control.events.TreeNodeEvent;
import kd.epm.eb.business.rpa.dao.RpaIntegrationDao;
import kd.epm.eb.common.constant.MessageConstant;
import kd.epm.eb.common.tree.ITreeNode;
import kd.epm.eb.common.tree.TreeModel;
import kd.epm.eb.common.tree.integrationcate.IntegrationCateTree;
import kd.epm.eb.common.tree.integrationcate.IntegrationCateTreeBuild;
import kd.epm.eb.common.utils.IDUtils;
import kd.epm.eb.common.utils.ObjectSerialUtil;
import kd.epm.eb.formplugin.AbstractFormPlugin;
import kd.epm.eb.formplugin.utils.TreeSearchUtil;

public class RpaIntegrationMovePlugin
extends AbstractFormPlugin {
    private static final String ROW_LIST = "rowlist";
    private static final String FOCUS = "focus";
    private static final String SEARCH_AP = "searchap";
    private static final String CATE_TREE = "catetree";

    @Override
    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addClickListeners(new String[]{"btn_save", "close"});
        TreeView tview = (TreeView)this.getControl(CATE_TREE);
        tview.addTreeNodeClickListener(new TreeNodeClickListener(){

            public void treeNodeClick(TreeNodeEvent evt) {
                super.treeNodeClick(evt);
            }
        });
        Search se = (Search)this.getControl(SEARCH_AP);
        se.addEnterListener(event -> {
            if (event.getText() != null && !"".equals(event.getText())) {
                this.searchMember(event.getText().toLowerCase().trim());
            } else {
                this.getPageCache().put(ROW_LIST, null);
                this.getView().showTipNotification(MessageConstant.getMEMBER_NOINPUT());
            }
        });
    }

    @Override
    public void beforeBindData(EventObject e) {
        super.beforeBindData(e);
        String nodeId = (String)this.getView().getFormShowParameter().getCustomParam("cateId");
        TreeModel<IntegrationCateTree> treeModel = this.initTree();
        ITreeNode currentNode = treeModel.searchByNodeId(IDUtils.toLong((Object)nodeId));
        String parentId = currentNode.getParent() == null ? null : currentNode.getParent().getId().toString();
        TreeView treeview = (TreeView)this.getControl(CATE_TREE);
        treeview.focusNode(new TreeNode(parentId, nodeId, null));
    }

    private TreeModel<IntegrationCateTree> initTree() {
        TreeView treeview = (TreeView)this.getControl(CATE_TREE);
        Long modelId = this.getModelId();
        IntegrationCateTree root = IntegrationCateTreeBuild.getIntegrationCateTree((Long)modelId);
        TreeModel treeModel = new TreeModel((ITreeNode)root);
        TreeNode treeNode = treeModel.buildEntryTree(treeview);
        this.getPageCache().put("treeCacheName", SerializationUtils.toJsonString((Object)treeNode));
        TreeSearchUtil.clearSearchPageCache(this.getPageCache(), new TreeSearchUtil.TreeSearchParam());
        treeModel.cache2page(this.getPageCache());
        treeview.focusNode(new TreeNode(null, String.valueOf(root.getId()), null));
        return treeModel;
    }

    @Override
    public Long getModelId() {
        return IDUtils.toLong((Object)this.getView().getFormShowParameter().getCustomParam("KEY_MODEL_ID"));
    }

    public void click(EventObject evt) {
        super.click(evt);
        Control Control2 = (Control)evt.getSource();
        String key = Control2.getKey();
        if ("btn_save".equals(key)) {
            this.moveIntegration();
            this.getView().close();
        }
    }

    private void moveIntegration() {
        String newNodeId = ((TreeView)this.getControl(CATE_TREE)).getTreeState().getFocusNodeId();
        String oldNodeId = (String)this.getView().getFormShowParameter().getCustomParam("cateId");
        if (oldNodeId.equals(newNodeId)) {
            return;
        }
        List integrationIds = (List)this.getView().getFormShowParameter().getCustomParam("integrationId");
        RpaIntegrationDao.getInstance().updateCateId(integrationIds, IDUtils.toLong((Object)newNodeId));
        MultiLangEnumBridge opName = new MultiLangEnumBridge("\u79fb\u52a8", "RpaIntegrationMovePlugin_1", "epm-eb-formplugin");
        MultiLangEnumBridge opDesc = new MultiLangEnumBridge("RPA\u96c6\u6210\u65b9\u6848\u79fb\u52a8\u6210\u529f\u3002", "RpaIntegrationMovePlugin_2", "epm-eb-formplugin");
        this.writeLog("move", opName, opDesc);
        this.getView().returnDataToParent((Object)newNodeId);
    }

    private void searchMember(String text) {
        TreeNode root = (TreeNode)SerializationUtils.fromJsonString((String)this.getPageCache().get("treeCacheName"), TreeNode.class);
        TreeView mTree = (TreeView)this.getControl(CATE_TREE);
        ArrayList<TreeNode> treeNodes = new ArrayList<TreeNode>(16);
        this.getTreeNodeListByText(root, treeNodes, text);
        ArrayList<TreeNode> allTreeNodes = new ArrayList<TreeNode>(16);
        this.getTreeNodeListByText(root, allTreeNodes, "");
        for (TreeNode treeNode : allTreeNodes) {
            treeNode.setIsOpened(true);
        }
        mTree.updateNodes(allTreeNodes);
        if (treeNodes.size() > 0) {
            this.getPageCache().put(ROW_LIST, SerializationUtils.toJsonString((Object)treeNodes.toArray()));
            TreeNode asd = (TreeNode)treeNodes.get(0);
            this.getPageCache().put(FOCUS, ObjectSerialUtil.toByteSerialized((Object)0));
            mTree.updateNode(asd);
            mTree.focusNode(asd);
        } else {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u6682\u65e0\u76f8\u5173\u6570\u636e\u3002", (String)"RpaIntegrationMovePlugin_0", (String)"epm-eb-formplugin", (Object[])new Object[0]));
        }
    }

    private void getTreeNodeListByText(TreeNode node, List<TreeNode> treeNodes, String text) {
        if (node.getText().toLowerCase().contains(text.toLowerCase())) {
            treeNodes.add(node);
        }
        if (node.getChildren() != null) {
            for (TreeNode child : node.getChildren()) {
                this.getTreeNodeListByText(child, treeNodes, text);
            }
        }
    }
}

