/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.formplugin.rpa;

import com.alibaba.fastjson.JSON;
import java.util.EventObject;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.promptenum.MultiLangEnumBridge;
import kd.bos.form.control.Control;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.list.ListShowParameter;
import kd.bos.orm.query.QFilter;
import kd.epm.eb.budget.formplugin.AbstractBaseFormPlugin;
import kd.epm.eb.business.rpa.RpaConstants;
import kd.epm.eb.business.rpa.dao.RpaIntegrationSheetDao;
import kd.epm.eb.business.rpa.entity.RpaIntegrationSheet;
import kd.epm.eb.common.enums.BgTemplateTypeEnum;
import kd.epm.eb.common.utils.DatasetServiceHelper;
import kd.epm.eb.common.utils.IDUtils;

public class RpaIntegrationSheetEditPlugin
extends AbstractBaseFormPlugin {
    private static final String BTN_OK = "btnok";
    private static final String SHEET_MAPPING = "sheetmapping";
    private static final String SHEET_NAMES = "sheetNames";
    private static final String TEMPLATE = "template";

    public void initialize() {
        super.initialize();
    }

    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addClickListeners(new String[]{BTN_OK});
        BasedataEdit template = (BasedataEdit)this.getControl(TEMPLATE);
        template.addBeforeF7SelectListener((BeforeF7SelectListener)this);
    }

    public void beforeF7Select(BeforeF7SelectEvent e) {
        String key = e.getProperty().getName();
        if (TEMPLATE.equals(key)) {
            List dataSetIds = JSON.parseArray((String)this.getPageCache().get("dataset"), Long.class);
            QFilter qFilter = new QFilter("dataset", "in", (Object)dataSetIds);
            qFilter.and("templatetype", "=", (Object)BgTemplateTypeEnum.EBFIX.getNumber());
            ListShowParameter param = (ListShowParameter)e.getFormShowParameter();
            param.getListFilterParameter().setFilter(qFilter);
            param.setMultiSelect(false);
            e.getFormShowParameter().setCustomParam("analysis.modelId", (Object)this.getModelId());
        }
    }

    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        this.initData();
        List dataSetIds = DatasetServiceHelper.getInstance().getDataSetIdByBizModelId(this.getBizModel());
        this.getPageCache().put("dataset", JSON.toJSONString((Object)dataSetIds));
    }

    public void click(EventObject evt) {
        super.click(evt);
        String key = ((Control)evt.getSource()).getKey();
        if (BTN_OK.equals(key)) {
            DynamicObjectCollection sheetMapping = this.getModel().getEntryEntity(SHEET_MAPPING);
            sheetMapping.removeIf(next -> IDUtils.isEmptyLong((Long)next.getLong("template.id")));
            RpaIntegrationSheetDao.getInstance().saveMapping(this.getIntegration(), sheetMapping);
            MultiLangEnumBridge opName = new MultiLangEnumBridge("\u8868\u683c\u6620\u5c04", "RpaIntegrationSheetEditPlugin_0", "epm-eb-formplugin");
            MultiLangEnumBridge opDesc = new MultiLangEnumBridge("\u8868\u683c\u6620\u5c04\u6210\u529f\u3002", "RpaIntegrationSheetEditPlugin_1", "epm-eb-formplugin");
            this.writeLog(null, null, opName, opDesc, null);
            this.getView().returnDataToParent(null);
            this.getView().close();
        }
    }

    private void initData() {
        Map mappedMap;
        List sheetNames = (List)this.getView().getFormShowParameter().getCustomParam(SHEET_NAMES);
        Map<String, RpaIntegrationSheet> dataMap = this.collectSheetStatus(sheetNames, mappedMap = RpaIntegrationSheetDao.getInstance().getNameMapping(this.getIntegration()));
        if (dataMap.size() > 0) {
            this.getModel().batchCreateNewEntryRow(SHEET_MAPPING, dataMap.size());
        }
        int i = 0;
        for (Map.Entry<String, RpaIntegrationSheet> entry : dataMap.entrySet()) {
            String effectStatus = entry.getValue().getEffectStatus();
            String mappingStatus = entry.getValue().getMappingStatus();
            this.getModel().setValue("id", (Object)entry.getValue().getId(), i);
            this.getModel().setValue("sheetname", (Object)entry.getKey(), i);
            this.getModel().setValue("effectStatus", (Object)effectStatus, i);
            this.getModel().setValue(TEMPLATE, (Object)entry.getValue().getTemplateId(), i);
            this.getModel().setValue("mappingstatus", (Object)mappingStatus, i);
            if (RpaConstants.EffectStatus.EFFECTIVE.getValue().equals(effectStatus) || RpaConstants.MappingStatus.MAPPING.getValue().equals(mappingStatus)) {
                this.getView().setEnable(Boolean.FALSE, i, new String[]{TEMPLATE});
            }
            ++i;
        }
    }

    private Long getIntegration() {
        return (Long)this.getView().getFormShowParameter().getCustomParam("integrationId");
    }

    public Long getModelId() {
        return (Long)this.getView().getFormShowParameter().getCustomParam("KEY_MODEL_ID");
    }

    public Long getBizModel() {
        return (Long)this.getView().getFormShowParameter().getCustomParam("bizmodel");
    }

    private Map<String, RpaIntegrationSheet> collectSheetStatus(List<String> sheetNames, Map<String, DynamicObject> mappedMap) {
        LinkedHashMap<String, RpaIntegrationSheet> newMap = new LinkedHashMap<String, RpaIntegrationSheet>(16);
        sheetNames.forEach(sheetName -> {
            DynamicObject mappedObj = (DynamicObject)mappedMap.get(sheetName);
            if (mappedObj == null) {
                newMap.put((String)sheetName, new RpaIntegrationSheet(Long.valueOf(0L), null, RpaConstants.MappingStatus.NO_MAPPING.getValue(), RpaConstants.EffectStatus.NONEFFECTIVE.getValue()));
            } else {
                newMap.put((String)sheetName, new RpaIntegrationSheet(Long.valueOf(mappedObj.getLong("id")), Long.valueOf(mappedObj.getLong(TEMPLATE)), mappedObj.getString("mappingstatus"), mappedObj.getString("effectStatus")));
            }
        });
        return newMap;
    }
}

