/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.formplugin.rpa;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.ListSelectedRow;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.operate.Save;
import kd.bos.exception.KDBizException;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.ShowType;
import kd.bos.form.control.Control;
import kd.bos.form.control.Label;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeClosedEvent;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.ComboEdit;
import kd.bos.form.field.ComboItem;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.form.operate.FormOperate;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.ListShowParameter;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.epm.eb.business.memberf7.NewF7Utils;
import kd.epm.eb.business.rpa.RpaConstants;
import kd.epm.eb.business.rpa.RpaService;
import kd.epm.eb.business.rpa.dao.RpaEntityRefDao;
import kd.epm.eb.business.rpa.dao.RpaIntegrationSheetDao;
import kd.epm.eb.business.rpa.dao.RpaSchemeDao;
import kd.epm.eb.common.enums.JoinerTypeEnum;
import kd.epm.eb.common.enums.RangeEnum;
import kd.epm.eb.common.enums.SysDimensionEnum;
import kd.epm.eb.common.member.f7.MemberF7Parameter;
import kd.epm.eb.common.utils.IDUtils;
import kd.epm.eb.formplugin.AbstractBasePlugin;
import kd.epm.eb.formplugin.report.excel.BgmReportExportFileRulePlugin;
import kd.epm.eb.model.utils.ModelUtil;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.collections4.MapUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.tuple.Pair;

public class RpaSchemeEditPlugin
extends AbstractBasePlugin
implements BeforeF7SelectListener {
    private static final Log log = LogFactory.getLog(RpaSchemeEditPlugin.class);
    private static final String RPA_PROCESS = "rpaprocess";
    private static final String RPA_ROBOT = "rparobot";
    private static final String FILE_NAME = "filename";
    private static final String SHEET_NAME = "sheetname";
    private static final String FILE_NAME_CLICK = "filenameclick";
    private static final String SHEET_NAME_CLICK = "sheetnameclick";
    private static final String ENTRY_TEMPLATE = "entrytemplate";
    private static final String ENTRY_ENTITY = "entryentity";

    @Override
    public void beforeBindData(EventObject e) {
        super.beforeBindData(e);
        this.getView().getPageCache().put("hasRight", "true");
        boolean fromSchemeInh = "eb_rpa_scheme_inh".equals(((ListShowParameter)this.getView().getParentView().getFormShowParameter()).getBillFormId());
        if (fromSchemeInh) {
            this.getView().setVisible(Boolean.FALSE, new String[]{RPA_PROCESS, RPA_ROBOT});
        } else {
            this.initRpaProcess();
            Object rpaProcess = this.getModel().getValue(RPA_PROCESS);
            if (rpaProcess != null) {
                this.initRpaRobot(rpaProcess.toString());
            }
        }
        this.initFileRuleData();
        this.setFileNameClickLabel(FILE_NAME, SHEET_NAME);
        DynamicObject model = (DynamicObject)this.getModel().getValue("model");
        Object id = this.getModel().getValue("id");
        Set permIds = ModelUtil.getModelIds((IFormView)this.getView(), (boolean)true);
        boolean perm = CollectionUtils.isNotEmpty((Collection)permIds) && permIds.contains(model.getLong("id"));
        boolean own = RpaSchemeDao.getInstance().checkDataBelongToCurrentUser(Collections.singletonList(IDUtils.toLong((Object)id)), this.getUserId());
        if (!perm && !own) {
            this.getView().setEnable(Boolean.valueOf(false), new String[]{"flexpanelap3"});
        }
        this.showByIntegrationType((DynamicObject)this.getModel().getValue("rpaintegration"));
    }

    public void afterCreateNewData(EventObject e) {
        FormShowParameter formShowParameter = this.getView().getFormShowParameter();
        Long modelId = (Long)formShowParameter.getCustomParam("model");
        this.getPageCache().put("model", String.valueOf(modelId));
        this.getModel().setValue("model", (Object)modelId);
    }

    public void propertyChanged(PropertyChangedArgs e) {
        String newVal;
        String key = e.getProperty().getName();
        if (RPA_PROCESS.equals(key)) {
            newVal = (String)e.getChangeSet()[0].getNewValue();
            this.getModel().setValue(RPA_ROBOT, null);
            if (StringUtils.isNotEmpty((CharSequence)newVal)) {
                this.initRpaRobot(newVal);
            }
        }
        if ("bizmodel".equals(key)) {
            this.getModel().setValue("rpaintegration", null);
            this.getModel().setValue("datatype", null);
            this.getModel().setValue("version", null);
            this.getModel().setValue("period", null);
            this.getModel().deleteEntryData(ENTRY_TEMPLATE);
            this.getModel().deleteEntryData(ENTRY_ENTITY);
        }
        if ("rpaintegration".equals(key)) {
            newVal = (DynamicObject)e.getChangeSet()[0].getNewValue();
            DynamicObject oldVal = (DynamicObject)e.getChangeSet()[0].getOldValue();
            this.showByIntegrationType((DynamicObject)newVal);
            if (newVal != null && oldVal != null && !Objects.equals(newVal.getLong("id"), oldVal.getLong("id"))) {
                this.getModel().deleteEntryData(ENTRY_TEMPLATE);
                this.getModel().deleteEntryData(ENTRY_ENTITY);
            }
        }
    }

    private void showByIntegrationType(DynamicObject newVal) {
        boolean isZip = newVal != null && RpaConstants.ExportType.ZIP.getValue().equals(newVal.getString("type"));
        this.getView().setVisible(Boolean.valueOf(!isZip), new String[]{"labelapfilename", FILE_NAME_CLICK, "labelapsheet", SHEET_NAME_CLICK, "createini", "filetype"});
    }

    private void initRpaProcess() {
        ComboEdit comboEdit = (ComboEdit)this.getControl(RPA_PROCESS);
        ArrayList data = new ArrayList();
        try {
            List processList = RpaService.getInstance().getProcessList();
            processList.forEach(map -> data.add(new ComboItem(new LocaleString(map.get("procName").toString()), RpaService.getInstance().getProcessComboId(map.get("id").toString(), map.get("procCode").toString()))));
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            this.getView().showTipNotification(ResManager.loadResFormat((String)"\u83b7\u53d6RPA\u6d41\u7a0b\u5f02\u5e38\uff1a%1\u3002", (String)"RpaSchemeEditPlugin_5", (String)"epm-eb-formplugin", (Object[])new Object[]{e.getMessage()}));
        }
        comboEdit.setComboItems(data);
    }

    private void initRpaRobot(String procValue) {
        if (StringUtils.isBlank((CharSequence)procValue)) {
            return;
        }
        ComboEdit comboEdit = (ComboEdit)this.getControl(RPA_ROBOT);
        ArrayList data = new ArrayList();
        try {
            Pair pair = RpaService.getInstance().getProcessIdAndCode(procValue);
            String procId = (String)pair.getLeft();
            List robotList = RpaService.getInstance().getRobotList(procId);
            robotList.forEach(map -> data.add(new ComboItem(new LocaleString(map.get("agentAlias").toString()), map.get("id").toString())));
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            this.getView().showErrorNotification(ResManager.loadResFormat((String)"\u83b7\u53d6RPA\u673a\u5668\u4eba\u5217\u8868\u5f02\u5e38\u3002", (String)"RpaSchemeEditPlugin_7", (String)"epm-eb-formplugin", (Object[])new Object[]{""}));
        }
        comboEdit.setComboItems(data);
    }

    public void beforeClosed(BeforeClosedEvent e) {
        super.beforeClosed(e);
        this.getModel().setDataChanged(false);
    }

    @Override
    public void registerListener(EventObject e) {
        super.registerListener(e);
        BasedataEdit bizModel = (BasedataEdit)this.getView().getControl("bizmodel");
        bizModel.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        BasedataEdit dataType = (BasedataEdit)this.getView().getControl("datatype");
        dataType.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        BasedataEdit version = (BasedataEdit)this.getView().getControl("version");
        version.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        BasedataEdit period = (BasedataEdit)this.getView().getControl("period");
        period.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        BasedataEdit rpaIntegration = (BasedataEdit)this.getView().getControl("rpaintegration");
        rpaIntegration.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        BasedataEdit template = (BasedataEdit)this.getView().getControl("template");
        template.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        BasedataEdit entity = (BasedataEdit)this.getView().getControl("entity");
        entity.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        this.addClickListeners(new String[]{FILE_NAME_CLICK});
    }

    @Override
    public void beforeF7Select(BeforeF7SelectEvent evt) {
        List filter;
        Long integrationId;
        long modelId = this.getModelId();
        QFilter qFilter = new QFilter("model", "=", (Object)modelId);
        String dimNumber = null;
        HashMap dimMemRangeMap = new HashMap(16);
        String key = evt.getProperty().getName();
        if ("rpaintegration".equals(key)) {
            DynamicObject bizModel = (DynamicObject)this.getModel().getValue("bizmodel");
            if (null == bizModel) {
                throw new KDBizException(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u4e1a\u52a1\u6a21\u578b\u3002", (String)"RpaSchemeEditPlugin_3", (String)"epm-eb-formplugin", (Object[])new Object[0]));
            }
            qFilter.and("status", "=", (Object)RpaConstants.Status.ENABLE.getValue());
            qFilter.and("bizmodel", "=", (Object)bizModel.getLong("id"));
        } else if ("template".equals(key)) {
            integrationId = this.checkSelectIntegration();
            List templateIds = RpaIntegrationSheetDao.getInstance().getTemplateIds(integrationId);
            if (CollectionUtils.isEmpty((Collection)templateIds)) {
                throw new KDBizException(ResManager.loadKDString((String)"\u53ef\u9009\u6a21\u677f\u4e3a\u7a7a\uff0c\u8bf7\u5148\u8fdb\u884c\u8868\u683c\u6620\u5c04\u3002", (String)"RpaSchemeEditPlugin_1", (String)"epm-eb-formplugin", (Object[])new Object[0]));
            }
            evt.getFormShowParameter().setCustomParam("analysis.modelId", (Object)modelId);
            DynamicObjectCollection entryTemplate = this.getModel().getEntryEntity(ENTRY_TEMPLATE);
            filter = entryTemplate.stream().map(p -> p.getLong("template.id")).collect(Collectors.toList());
            DynamicObject entryRowEntity = this.getModel().getEntryRowEntity(ENTRY_TEMPLATE, this.getModel().getEntryCurrentRowIndex(ENTRY_TEMPLATE));
            filter.remove(entryRowEntity.getLong("template.id"));
            templateIds.removeAll(filter);
            qFilter.and("id", "in", (Object)templateIds);
        } else if ("entity".equals(key)) {
            integrationId = this.checkSelectIntegration();
            List entityIds = RpaEntityRefDao.getInstance().getEntityIds(integrationId);
            if (CollectionUtils.isEmpty((Collection)entityIds)) {
                throw new KDBizException(ResManager.loadKDString((String)"\u53ef\u9009\u7ec4\u7ec7\u4e3a\u7a7a\uff0c\u8bf7\u5148\u8fdb\u884c\u7ec4\u7ec7\u6210\u5458\u6620\u5c04\u3002", (String)"RpaSchemeEditPlugin_2", (String)"epm-eb-formplugin", (Object[])new Object[0]));
            }
            DynamicObjectCollection entryEntity = this.getModel().getEntryEntity(ENTRY_ENTITY);
            filter = entryEntity.stream().map(p -> p.getLong("entity.id")).collect(Collectors.toList());
            DynamicObject entryRowEntity = this.getModel().getEntryRowEntity(ENTRY_ENTITY, this.getModel().getEntryCurrentRowIndex(ENTRY_ENTITY));
            filter.remove(entryRowEntity.getLong("entity.id"));
            entityIds.removeAll(filter);
            if (CollectionUtils.isEmpty((Collection)entityIds)) {
                throw new KDBizException(ResManager.loadKDString((String)"\u53ef\u9009\u7ec4\u7ec7\u4e3a\u7a7a\uff0c\u8bf7\u5148\u8fdb\u884c\u7ec4\u7ec7\u6210\u5458\u6620\u5c04\u3002", (String)"RpaSchemeEditPlugin_2", (String)"epm-eb-formplugin", (Object[])new Object[0]));
            }
            entityIds.forEach(entityId -> dimMemRangeMap.put(entityId, RangeEnum.ONLY.getIndex()));
            dimNumber = SysDimensionEnum.Entity.getNumber();
        } else if ("datatype".equals(key)) {
            dimNumber = SysDimensionEnum.DataType.getNumber();
        } else if ("version".equals(key)) {
            dimNumber = SysDimensionEnum.Version.getNumber();
        } else if ("period".equals(key)) {
            dimNumber = SysDimensionEnum.BudgetPeriod.getNumber();
        }
        if (dimNumber != null) {
            Object bizModelObj = this.getModel().getValue("bizmodel");
            if (bizModelObj == null) {
                throw new KDBizException(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u4e1a\u52a1\u6a21\u578b\u3002", (String)"RpaSchemeEditPlugin_3", (String)"epm-eb-formplugin", (Object[])new Object[0]));
            }
            long bizModelId = ((DynamicObject)bizModelObj).getLong("id");
            MemberF7Parameter f7Param = SysDimensionEnum.Entity.getNumber().equals(dimNumber) ? NewF7Utils.multipleF7((Long)modelId, (DynamicObject)NewF7Utils.getDimension((Long)modelId, (String)dimNumber), (String)ListSelectedRow.class.getName()) : NewF7Utils.singleF7((Long)modelId, (DynamicObject)NewF7Utils.getDimension((Long)modelId, (String)dimNumber), (String)ListSelectedRow.class.getName());
            f7Param.setBusModelId(Long.valueOf(bizModelId));
            f7Param.setEnableView(true);
            f7Param.addSelectRange(dimMemRangeMap);
            NewF7Utils.openF7((BeforeF7SelectEvent)evt, (MemberF7Parameter)f7Param);
        } else {
            evt.addCustomQFilter(qFilter);
        }
    }

    public void click(EventObject evt) {
        super.click(evt);
        String key = ((Control)evt.getSource()).getKey();
        if (FILE_NAME_CLICK.equals(key)) {
            this.openFileNameRulePage(key);
        }
    }

    private void openFileNameRulePage(String key) {
        String nameSource = FILE_NAME_CLICK.equals(key) ? FILE_NAME : SHEET_NAME;
        FormShowParameter formShowParameter = new FormShowParameter();
        formShowParameter.setFormId("bgm_filesheetnamerule");
        if (SHEET_NAME.equals(key)) {
            formShowParameter.setCaption(ResManager.loadKDString((String)"\u62a5\u8868\u5bfc\u51fasheet\u9875\u547d\u540d\u89c4\u5219", (String)"BgmReportExportDataPlugin_7", (String)"epm-eb-formplugin", (Object[])new Object[0]));
        }
        formShowParameter.addCustPlugin("kd.epm.eb.formplugin.report.excel.BgmReportExportFileRulePlugin");
        formShowParameter.getOpenStyle().setShowType(ShowType.Modal);
        formShowParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, key));
        formShowParameter.setCustomParam("source", (Object)nameSource);
        Map<String, Object> fileNameFormat = this.getFileNameFormat(nameSource);
        if (MapUtils.isNotEmpty(fileNameFormat)) {
            formShowParameter.setCustomParam("selectedFiledStr", (Object)SerializationUtils.serializeToBase64((Object)fileNameFormat.get("selectedFiled")));
            formShowParameter.setCustomParam("joiner", fileNameFormat.get("joiner"));
            formShowParameter.setCustomParam("fixvalue", fileNameFormat.get("fixvalue"));
        } else {
            formShowParameter.setCustomParam("joiner", (Object)JoinerTypeEnum.CENTER_LINE.getIndex());
        }
        this.getView().showForm(formShowParameter);
    }

    @Override
    public void closedCallBack(ClosedCallBackEvent closedCallBackEvent) {
        super.closedCallBack(closedCallBackEvent);
        String actionId = closedCallBackEvent.getActionId();
        Object returnData = closedCallBackEvent.getReturnData();
        if (returnData == null) {
            return;
        }
        if (FILE_NAME_CLICK.equals(actionId)) {
            this.dealNameClosedCallBack(returnData);
        }
    }

    private void dealNameClosedCallBack(Object returnData) {
        Map nameFormatInfo = (Map)SerializationUtils.deSerializeFromBase64((String)((String)returnData));
        this.checkSelectEntity(nameFormatInfo);
        this.setName(nameFormatInfo);
        String nameSource = (String)nameFormatInfo.get("namesource");
        this.cacheFileNameFormat(nameSource, nameFormatInfo);
    }

    private void checkSelectEntity(Map<String, Object> nameFormatInfo) {
        List selectedFiled = (List)nameFormatInfo.get("selectedFiled");
        boolean b = selectedFiled.stream().anyMatch(field -> "entity.number".equals(field.getFiledNumber()) || "entity.name".equals(field.getFiledNumber()));
        if (!b) {
            throw new KDBizException(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u7ec4\u7ec7\u7f16\u7801\u6216\u7ec4\u7ec7\u540d\u79f0\u3002", (String)"RpaSchemeEditPlugin_6", (String)"epm-eb-formplugin", (Object[])new Object[0]));
        }
    }

    private void cacheFileNameFormat(String nameSource, Map<String, Object> nameFormatInfo) {
        String s = SerializationUtils.serializeToBase64(nameFormatInfo);
        this.getModel().setValue(nameSource, (Object)s);
        this.getView().getPageCache().put(nameSource, s);
    }

    private Map<String, Object> getFileNameFormat(String nameSource) {
        String nameFormatInfo = this.getView().getPageCache().get(nameSource);
        if (nameFormatInfo == null) {
            return Collections.emptyMap();
        }
        return (Map)SerializationUtils.deSerializeFromBase64((String)nameFormatInfo);
    }

    @Override
    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        Object id;
        super.beforeDoOperation(args);
        String opType = ((FormOperate)args.getSource()).getType();
        if ("save".equals(opType) && ((id = this.getModel().getValue("id")) == null || IDUtils.isNull((Long)((Long)id))) && RpaSchemeDao.getInstance().existsNumber(this.getModelId().longValue(), this.getModel().getValue("number").toString())) {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u5df2\u5b58\u5728\u76f8\u540c\u7f16\u7801\u65b9\u6848\u3002", (String)"RpaSchemeEditPlugin_4", (String)"epm-eb-formplugin", (Object[])new Object[0]));
            args.setCancel(true);
        }
    }

    @Override
    public void afterDoOperation(AfterDoOperationEventArgs args) {
        super.afterDoOperation(args);
        if (args.getOperationResult() != null) {
            boolean isSuccess = args.getOperationResult().getValidateResult().isSuccess();
            if (args.getSource() instanceof Save && isSuccess) {
                this.getView().setEnable(Boolean.FALSE, new String[]{"number"});
            }
        }
    }

    @Override
    public Long getModelId() {
        String modelId = this.getPageCache().get("model");
        if (StringUtils.isEmpty((CharSequence)modelId)) {
            DynamicObject value = (DynamicObject)this.getModel().getValue("model");
            if (value == null) {
                return 0L;
            }
            modelId = value.getString("id");
            this.getPageCache().put("model", modelId);
        }
        return IDUtils.toLong((Object)modelId);
    }

    private void setFileNameClickLabel(String ... types) {
        for (String type : types) {
            Map<String, Object> nameFormatInfo = this.getFileNameFormat(type);
            this.setName(nameFormatInfo);
        }
    }

    private void setName(Map<String, Object> nameFormatInfo) {
        List selectedFiled = (List)nameFormatInfo.get("selectedFiled");
        String joiner = (String)nameFormatInfo.get("joiner");
        String fixvalue = (String)nameFormatInfo.get("fixvalue");
        String namesource = (String)nameFormatInfo.get("namesource");
        ArrayList<String> selectedFiledNames = new ArrayList<String>(10);
        for (BgmReportExportFileRulePlugin.FiledMember filedMember : selectedFiled) {
            if ("fixvalue".equals(filedMember.getFiledNumber())) {
                selectedFiledNames.add(fixvalue);
                continue;
            }
            if (filedMember.getFiledNumber() != null) {
                String replace = filedMember.getFiledNumber().replace("org", "entity");
                filedMember.setFiledNumber(replace);
            }
            selectedFiledNames.add(filedMember.getFiledName());
        }
        Label nameLabel = (Label)this.getView().getControl(namesource.equals(FILE_NAME) ? FILE_NAME_CLICK : SHEET_NAME_CLICK);
        if (selectedFiledNames.size() > 0) {
            nameLabel.setText(StringUtils.join(selectedFiledNames, (String)JoinerTypeEnum.getSignByIndex((String)joiner)));
        }
    }

    private void initFileRuleData() {
        Map rpaSheet;
        Map<String, Object> rpaFile;
        IDataModel model = this.getModel();
        Long pkId = IDUtils.toLong((Object)model.getDataEntity().getPkValue());
        if (IDUtils.isNotEmptyLong((Long)pkId).booleanValue() && StringUtils.isNotBlank((CharSequence)String.valueOf(this.getModel().getValue(FILE_NAME))) && StringUtils.isNotBlank((CharSequence)String.valueOf(this.getModel().getValue(SHEET_NAME)))) {
            try {
                rpaFile = (Map<String, Object>)SerializationUtils.deSerializeFromBase64((String)String.valueOf(this.getModel().getValue(FILE_NAME)));
                rpaSheet = (Map)SerializationUtils.deSerializeFromBase64((String)String.valueOf(this.getModel().getValue(SHEET_NAME)));
            }
            catch (Exception e) {
                log.error(e.getMessage(), (Throwable)e);
                rpaFile = this.getDefaultRpaFile();
                rpaSheet = this.getDefaultRpaSheet();
            }
        } else {
            rpaFile = this.getDefaultRpaFile();
            rpaSheet = this.getDefaultRpaSheet();
        }
        this.cacheFileNameFormat(FILE_NAME, rpaFile);
        this.cacheFileNameFormat(SHEET_NAME, rpaSheet);
    }

    private Map<String, Object> getDefaultRpaFile() {
        HashMap<String, Object> rpaFile = new HashMap<String, Object>(4);
        List<BgmReportExportFileRulePlugin.FiledMember> fileFiled = Collections.singletonList(new BgmReportExportFileRulePlugin.FiledMember("entity.name", ResManager.loadKDString((String)"\u7ec4\u7ec7\u540d\u79f0", (String)"BgmReportExportFileRulePlugin_04", (String)"epm-eb-formplugin", (Object[])new Object[0]), true));
        rpaFile.put("selectedFiled", fileFiled);
        rpaFile.put("joiner", "2");
        rpaFile.put("fixvalue", "");
        rpaFile.put("namesource", FILE_NAME);
        return rpaFile;
    }

    private Map<String, Object> getDefaultRpaSheet() {
        HashMap<String, Object> rpaSheet = new HashMap<String, Object>(4);
        List<BgmReportExportFileRulePlugin.FiledMember> sheetField = Collections.singletonList(new BgmReportExportFileRulePlugin.FiledMember("report.name", ResManager.loadKDString((String)"\u62a5\u8868\u540d\u79f0", (String)"BgmReportExportFileRulePlugin_02", (String)"epm-eb-formplugin", (Object[])new Object[0]), true));
        rpaSheet.put("selectedFiled", sheetField);
        rpaSheet.put("joiner", "2");
        rpaSheet.put("fixvalue", "");
        rpaSheet.put("namesource", SHEET_NAME);
        return rpaSheet;
    }

    private Long checkSelectIntegration() {
        Object rpaIntegration = this.getModel().getValue("rpaintegration");
        if (rpaIntegration == null) {
            throw new KDBizException(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u96c6\u6210\u65b9\u6848\u3002", (String)"RpaSchemeEditPlugin_0", (String)"epm-eb-formplugin", (Object[])new Object[0]));
        }
        return ((DynamicObject)rpaIntegration).getLong("id");
    }
}

