/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.formplugin.rpa;

import com.alibaba.fastjson.JSONObject;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.EventObject;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.base.BaseShowParameter;
import kd.bos.bill.OperationStatus;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.resource.promptenum.MultiLangEnumBridge;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.entity.filter.ControlFilters;
import kd.bos.exception.KDBizException;
import kd.bos.filter.CommonFilterColumn;
import kd.bos.filter.FilterColumn;
import kd.bos.form.CloseCallBack;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IClientViewProxy;
import kd.bos.form.IFormView;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.ShowType;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.FilterContainerInitArgs;
import kd.bos.form.events.FilterContainerSearchClickArgs;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.events.SetFilterEvent;
import kd.bos.form.field.ComboItem;
import kd.bos.form.field.events.BeforeFilterF7SelectEvent;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.BillList;
import kd.bos.list.ListShowParameter;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.epm.eb.business.rpa.RpaConstants;
import kd.epm.eb.business.rpa.RpaService;
import kd.epm.eb.business.rpa.dao.RpaSchemeDao;
import kd.epm.eb.business.rpa.dao.RpaTaskLogDao;
import kd.epm.eb.business.rpa.entity.RpaScheme;
import kd.epm.eb.business.userselect.UserSelectUtils;
import kd.epm.eb.business.utils.ImportAndExportUtil;
import kd.epm.eb.common.cache.IModelCacheHelper;
import kd.epm.eb.common.cache.ModelCacheContext;
import kd.epm.eb.common.cache.impl.Model;
import kd.epm.eb.common.enums.ApplicationTypeEnum;
import kd.epm.eb.common.utils.IDUtils;
import kd.epm.eb.common.utils.base.ObjUtils;
import kd.epm.eb.formplugin.AbstractListPlugin;
import kd.epm.eb.formplugin.rpa.export.RpaExportService;
import kd.epm.eb.model.utils.ModelUtil;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.tuple.Pair;

public class RpaSchemeListPlugin
extends AbstractListPlugin {
    private static final Log log = LogFactory.getLog(RpaSchemeListPlugin.class);

    public void filterContainerInit(FilterContainerInitArgs args) {
        super.filterContainerInit(args);
        List commonFilterColumns = args.getCommonFilterColumns();
        this.setModelFilterComboItem(commonFilterColumns);
        this.setDefaultCreator(commonFilterColumns);
    }

    private void noModel(CommonFilterColumn filterColumn, List<ComboItem> comboItems) {
        String value = comboItems != null && comboItems.size() > 0 ? comboItems.get(0).getValue() : "0";
        filterColumn.setDefaultValue(value);
        if ("0".equals(value)) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u65b0\u589e\u4f53\u7cfb\u3002", (String)"RpaSchemeListPlugin_0", (String)"epm-eb-formplugin", (Object[])new Object[0]));
        }
    }

    private boolean isExistModel(String modelId) {
        IModelCacheHelper modelCache = ModelCacheContext.getOrCreate((Long)Long.parseLong(modelId));
        Model model = modelCache.getModelobj();
        if (model == null) {
            return Boolean.FALSE;
        }
        return Boolean.TRUE;
    }

    private void setModelFilterComboItem(List<FilterColumn> commonFilterColumns) {
        String modelId = this.getPageCache().get("KEY_MODEL_ID");
        if (modelId == null) {
            return;
        }
        this.getPageCache().put("KEY_MODEL_ID", null);
        CommonFilterColumn filterColumn = commonFilterColumns.stream().filter(c -> c.getFieldName().equals("model.name")).findFirst().orElse(null);
        if (filterColumn == null) {
            return;
        }
        ArrayList modelQFilters = new ArrayList(16);
        modelQFilters.addAll(ModelUtil.getModelFilter((IFormView)this.getView()));
        DynamicObjectCollection col = QueryServiceHelper.query((String)"model", (String)"epm_model", (String)"id,name", (QFilter[])modelQFilters.toArray(new QFilter[0]), null);
        filterColumn.getComboItems().clear();
        ArrayList<ComboItem> comboItems = new ArrayList<ComboItem>(16);
        col.forEach(e -> comboItems.add(new ComboItem(new LocaleString(e.getString("name")), e.getString("id"))));
        filterColumn.setComboItems(comboItems);
        if (this.isExistModel(modelId)) {
            long count = comboItems.stream().filter(model -> model != null && modelId.equals(model.getValue())).count();
            if (count == 0L) {
                this.noModel(filterColumn, comboItems);
            } else {
                filterColumn.setDefaultValue(modelId);
                this.getPageCache().put("KEY_MODEL_ID", modelId);
            }
        } else {
            this.noModel(filterColumn, comboItems);
        }
    }

    private void setDefaultCreator(List<FilterColumn> commonFilterColumns) {
        List creatorFilterColList = commonFilterColumns.stream().filter(e -> e.getFieldName().equals("creater.name")).collect(Collectors.toList());
        CommonFilterColumn creatorFilterCol = (CommonFilterColumn)creatorFilterColList.get(0);
        String selectCreator = "103";
        ControlFilters filters = creatorFilterCol.getContext().getControlFilters();
        if (filters != null && filters.getFilter("creater.id") != null && filters.getFilter("creater.id").size() > 0) {
            selectCreator = filters.getFilter("creater.id").get(0).toString();
        }
        creatorFilterCol.setDefaultValue(selectCreator);
    }

    public void filterContainerBeforeF7Select(BeforeFilterF7SelectEvent args) {
        super.filterContainerBeforeF7Select(args);
        if ("model.id".equals(args.getFieldName())) {
            args.setCustomQFilters(ModelUtil.getModelFilter((IFormView)this.getView()));
            args.getCustomParams().put("callFromRefBillEdit", true);
        }
    }

    public void filterContainerSearchClick(FilterContainerSearchClickArgs args) {
        super.filterContainerSearchClick(args);
        QFilter qFilter = args.getQFilter("model.id");
        Long modelId = 0L;
        if (qFilter != null) {
            modelId = IDUtils.toLong((Object)qFilter.getValue());
        }
        if (IDUtils.isNull((Long)modelId) && args.getSearchClickEvent().getSelectMainOrgIds().size() == 1) {
            modelId = (Long)args.getSearchClickEvent().getSelectMainOrgIds().get(0);
        }
        if (IDUtils.isNull((Long)modelId)) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u4f53\u7cfb\u3002", (String)"RpaSchemeListPlugin_1", (String)"epm-eb-formplugin", (Object[])new Object[0]));
        } else {
            UserSelectUtils.saveUserSelectModelId((IFormView)this.getView(), (long)modelId);
            this.getPageCache().put("KEY_MODEL_ID", modelId.toString());
        }
    }

    @Override
    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addItemClickListeners(new String[]{"toolbarap"});
    }

    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        Long modelId = 0L;
        try {
            modelId = UserSelectUtils.getUserSelectModelId((IFormView)this.getView());
            Set permIds = ModelUtil.getModelIds((IFormView)this.getView(), (boolean)false);
            if (CollectionUtils.isNotEmpty((Collection)permIds) && !permIds.contains(modelId)) {
                modelId = (Long)permIds.iterator().next();
            }
        }
        catch (Exception ex) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u65b0\u589e\u4f53\u7cfb\u3002", (String)"RpaSchemeListPlugin_0", (String)"epm-eb-formplugin", (Object[])new Object[0]));
        }
        if (IDUtils.isNull((Long)modelId)) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u65b0\u589e\u4f53\u7cfb\u3002", (String)"RpaSchemeListPlugin_0", (String)"epm-eb-formplugin", (Object[])new Object[0]));
        } else {
            this.getPageCache().put("KEY_MODEL_ID", modelId.toString());
        }
    }

    private void refreshBillList() {
        BillList billList = (BillList)this.getControl("billlistap");
        billList.clearSelection();
        billList.refresh();
    }

    public void itemClick(ItemClickEvent evt) {
        super.itemClick(evt);
        String itemKey = evt.getItemKey();
        ListSelectedRowCollection selectedRows = ((BillList)this.getControl("billlistap")).getSelectedRows();
        List ids = selectedRows.stream().map(v -> IDUtils.toLong((Object)v.getPrimaryKeyValue().toString())).collect(Collectors.toList());
        switch (itemKey) {
            case "btn_new": {
                this.openSchemePage();
                break;
            }
            case "btn_del": {
                this.checkIsSelectData(selectedRows);
                this.checkDataOwnerShip(selectedRows);
                this.checkDataIsExistedEnable(selectedRows);
                this.getView().showConfirm(ResManager.loadKDString((String)"\u786e\u8ba4\u5220\u9664\u6570\u636e\uff1f", (String)"RpaSchemeListPlugin_20", (String)"epm-eb-formplugin", (Object[])new Object[0]), MessageBoxOptions.OKCancel, new ConfirmCallBackListener("deleteConfirm", (IFormPlugin)this));
                break;
            }
            case "btn_copy": {
                this.copyRpaScheme();
                break;
            }
            case "btn_enable": {
                this.checkIsSelectData(selectedRows);
                this.checkDataOwnerShip(selectedRows);
                this.modifyRpaSchemeStatus(RpaConstants.Status.ENABLE);
                break;
            }
            case "btn_disable": {
                this.checkIsSelectData(selectedRows);
                this.checkDataOwnerShip(selectedRows);
                this.modifyRpaSchemeStatus(RpaConstants.Status.DISABLE);
                break;
            }
            case "btn_log": {
                this.checkIsSelectOneData(selectedRows);
                this.openRpaTaskLogPage(IDUtils.toLong((Object)selectedRows.get(0).getPrimaryKeyValue()));
                break;
            }
            case "btn_export": {
                this.checkIsSelectOneData(selectedRows);
                this.exportData(RpaConstants.RpaLogType.MANUAL);
                break;
            }
            case "btn_rpa": {
                this.checkIsSelectOneData(selectedRows);
                this.startRpa();
                break;
            }
            case "btn_refresh": {
                this.refreshBillList();
                break;
            }
        }
    }

    private void openSchemePage() {
        BaseShowParameter showParameter = new BaseShowParameter();
        showParameter.setFormId("eb_rpa_scheme");
        showParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, "closeCallback"));
        showParameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
        showParameter.setShowTitle(true);
        showParameter.setCaption(ResManager.loadKDString((String)"RPA\u673a\u5668\u4eba\u65b9\u6848", (String)"RpaSchemeListPlugin_2", (String)"epm-eb-formplugin", (Object[])new Object[0]));
        showParameter.setStatus(OperationStatus.ADDNEW);
        showParameter.setCustomParam("model", (Object)this.getModelId());
        this.getView().showForm((FormShowParameter)showParameter);
    }

    private void openRpaTaskLogPage(Long rpaSchemeId) {
        String pageId = this.getView().getPageId() + rpaSchemeId + "actionTaskLog";
        ListShowParameter lsp = new ListShowParameter();
        lsp.setPageId(pageId);
        lsp.getOpenStyle().setShowType(ShowType.MainNewTabPage);
        lsp.setBillFormId("eb_rpa_task_log");
        lsp.setCustomParam("KEY_MODEL_ID", (Object)this.getModelId());
        lsp.setCustomParam("schemeId", (Object)rpaSchemeId);
        this.getView().showForm((FormShowParameter)lsp);
    }

    private void deleteRpaScheme() {
        ListSelectedRowCollection selectedRows = ((BillList)this.getControl("billlistap")).getSelectedRows();
        List ids = selectedRows.stream().map(v -> IDUtils.toLong((Object)v.getPrimaryKeyValue().toString())).collect(Collectors.toList());
        if (CollectionUtils.isEmpty(ids)) {
            return;
        }
        RpaSchemeDao.getInstance().deleteById(ids);
        MultiLangEnumBridge opName = new MultiLangEnumBridge("\u5220\u9664", "RpaSchemeListPlugin_5", "epm-eb-formplugin");
        MultiLangEnumBridge opDesc = new MultiLangEnumBridge("RPA\u673a\u5668\u4eba\u65b9\u6848ID\u201c%1$s\u201d\u5df2\u5220\u9664\u3002", "RpaSchemeListPlugin_6", "epm-eb-formplugin");
        this.writeLogWithEntityNumber(this.getView().getModel().getDataEntityType().getName(), null, "delete", opName, opDesc, ObjUtils.getStringArray((Object[])new Object[]{ids.toString()}));
        this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u5220\u9664\u6210\u529f\u3002", (String)"RpaSchemeListPlugin_7", (String)"epm-eb-formplugin", (Object[])new Object[0]));
        this.refreshBillList();
    }

    private void copyRpaScheme() {
        ListSelectedRowCollection selectedRows = ((BillList)this.getControl("billlistap")).getSelectedRows();
        if (selectedRows.size() != 1) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u4e00\u884c\u6570\u636e\u3002", (String)"RpaSchemeListPlugin_8", (String)"epm-eb-formplugin", (Object[])new Object[0]));
            return;
        }
        Long id = IDUtils.toLong((Object)selectedRows.get(0).getPrimaryKeyValue().toString());
        RpaSchemeDao.getInstance().copyRpaScheme(id);
        MultiLangEnumBridge opName = new MultiLangEnumBridge("\u590d\u5236", "RpaSchemeListPlugin_9", "epm-eb-formplugin");
        MultiLangEnumBridge opDesc = new MultiLangEnumBridge("RPA\u673a\u5668\u4eba\u65b9\u6848, id: %1$s, \u590d\u5236\u6210\u529f\u3002", "RpaSchemeListPlugin_10", "epm-eb-formplugin");
        this.writeLogWithEntityNumber(this.getView().getModel().getDataEntityType().getName(), null, "copy", opName, opDesc, ObjUtils.getStringArray((Object[])new Object[]{id}));
        this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u590d\u5236\u6210\u529f\u3002", (String)"RpaSchemeListPlugin_11", (String)"epm-eb-formplugin", (Object[])new Object[0]));
        this.refreshBillList();
    }

    private String exportData(RpaConstants.RpaLogType rpaLogType) {
        Pair<String, String> pair;
        ListSelectedRowCollection selectedRows = ((BillList)this.getControl("billlistap")).getSelectedRows();
        this.checkIsSelectOneData(selectedRows);
        Long rpaSchemeId = IDUtils.toLong((Object)selectedRows.get(0).getPrimaryKeyValue().toString());
        this.checkSelectOneDataIsEnable(rpaSchemeId);
        if (rpaLogType == RpaConstants.RpaLogType.MANUAL) {
            RpaScheme rpaScheme = RpaSchemeDao.getInstance().loadToModel(rpaSchemeId);
            RpaTaskLogDao.getInstance().saveTaskLog("", "", "success", rpaScheme, RpaConstants.RpaLogType.MANUAL);
        }
        if ((pair = RpaExportService.getInstance().getExportUrl(rpaSchemeId, this.getView())) == null) {
            return null;
        }
        String url = (String)pair.getRight();
        ImportAndExportUtil.addTempFileCheck((String)url, (String)"eb_rpa_scheme", (String)ApplicationTypeEnum.BGMD.getAppnum(), (int)10000);
        ((IClientViewProxy)this.getView().getService(IClientViewProxy.class)).addAction("download", (Object)url);
        return (String)pair.getLeft();
    }

    private void startRpa() {
        ListSelectedRowCollection selectedRows = ((BillList)this.getControl("billlistap")).getSelectedRows();
        Long rpaSchemeId = IDUtils.toLong((Object)selectedRows.get(0).getPrimaryKeyValue().toString());
        RpaScheme rpaScheme = RpaSchemeDao.getInstance().loadToModel(rpaSchemeId);
        if (StringUtils.isBlank((CharSequence)rpaScheme.getRpaProcess())) {
            throw new KDBizException(ResManager.loadKDString((String)"\u672a\u914d\u7f6e\u673a\u5668\u4eba\u6d41\u7a0b\u3002", (String)"RpaSchemeListPlugin_25", (String)"epm-eb-formplugin", (Object[])new Object[0]));
        }
        String downloadFile = this.exportData(RpaConstants.RpaLogType.RPA);
        if (StringUtils.isBlank((CharSequence)downloadFile)) {
            return;
        }
        Pair processIdAndCode = RpaService.getInstance().getProcessIdAndCode(rpaScheme.getRpaProcess());
        List fileNames = Collections.emptyList();
        String exportFileNames = this.getPageCache().get("exportFileNames");
        if (StringUtils.isNotBlank((CharSequence)exportFileNames)) {
            fileNames = JSONObject.parseArray((String)exportFileNames, String.class);
        }
        try {
            RpaService.getInstance().addTask((String)processIdAndCode.getValue(), rpaScheme.getRpaRobot(), downloadFile, fileNames, rpaScheme);
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            throw new KDBizException(e.getMessage());
        }
        MultiLangEnumBridge opName = new MultiLangEnumBridge("\u542f\u52a8RPA", "RpaSchemeListPlugin_27", "epm-eb-formplugin");
        MultiLangEnumBridge opDesc = new MultiLangEnumBridge("RPA\u5df2\u542f\u52a8\u3002", "RpaSchemeListPlugin_28", "epm-eb-formplugin");
        this.writeLogWithEntityNumber(this.getView().getModel().getDataEntityType().getName(), null, "start", opName, opDesc, null);
        this.getView().showSuccessNotification(ResManager.loadKDString((String)"RPA\u673a\u5668\u4eba\u542f\u52a8\u5b8c\u6210\uff0c\u8bf7\u7559\u610f\u6267\u884c\u7ed3\u679c\u3002", (String)"RpaSchemeListPlugin_22", (String)"epm-eb-formplugin", (Object[])new Object[0]));
    }

    private void checkIsSelectData(ListSelectedRowCollection selectedRows) {
        if (selectedRows.size() == 0) {
            throw new KDBizException(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u6570\u636e\u3002", (String)"RpaSchemeListPlugin_12", (String)"epm-eb-formplugin", (Object[])new Object[0]));
        }
    }

    private void checkSelectOneDataIsEnable(Long RpaSchemeId) {
        DynamicObjectCollection dynamicObjects = RpaSchemeDao.getInstance().queryStatus(Collections.singletonList(RpaSchemeId));
        if (dynamicObjects.stream().anyMatch(dynamicObject -> RpaConstants.Status.DISABLE.getBoolVal() == dynamicObject.getBoolean("status"))) {
            throw new KDBizException(ResManager.loadKDString((String)"\u8bf7\u542f\u7528\u65b9\u6848\u540e\uff0c\u518d\u542f\u52a8RPA\u6216\u5bfc\u51fa\u6570\u636e\u3002", (String)"RpaSchemeListPlugin_24", (String)"epm-eb-formplugin", (Object[])new Object[0]));
        }
    }

    private void checkIsSelectOneData(ListSelectedRowCollection selectedRows) {
        if (selectedRows.size() != 1) {
            throw new KDBizException(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u4e00\u884c\u6570\u636e\u3002", (String)"RpaSchemeListPlugin_8", (String)"epm-eb-formplugin", (Object[])new Object[0]));
        }
    }

    private void checkDataOwnerShip(ListSelectedRowCollection selectedRows) {
        List ids = selectedRows.stream().map(v -> IDUtils.toLong((Object)v.getPrimaryKeyValue().toString())).collect(Collectors.toList());
        if (!this.checkIsModelPerm() && !RpaSchemeDao.getInstance().checkDataBelongToCurrentUser(ids, this.getUserId())) {
            throw new KDBizException(ResManager.loadKDString((String)"\u975e\u4f53\u7cfb\u7ba1\u7406\u5458\u53ea\u80fd\u64cd\u4f5c\u81ea\u5df1\u521b\u5efa\u7684RPA\u673a\u5668\u4eba\u65b9\u6848\u3002", (String)"RpaSchemeListPlugin_26", (String)"epm-eb-formplugin", (Object[])new Object[0]));
        }
    }

    private boolean checkIsModelPerm() {
        Set permIds = ModelUtil.getModelIds((IFormView)this.getView(), (boolean)true);
        return CollectionUtils.isNotEmpty((Collection)permIds) && permIds.contains(this.getModelId());
    }

    private void checkDataIsExistedEnable(ListSelectedRowCollection selectedRows) {
        List ids = selectedRows.stream().map(v -> IDUtils.toLong((Object)v.getPrimaryKeyValue().toString())).collect(Collectors.toList());
        DynamicObjectCollection dynamicObjects = RpaSchemeDao.getInstance().queryStatus(ids);
        if (dynamicObjects.stream().anyMatch(dynamicObject -> RpaConstants.Status.ENABLE.getBoolVal() == dynamicObject.getBoolean("status"))) {
            throw new KDBizException(ResManager.loadKDString((String)"\u5df2\u542f\u7528\u7684\u65b9\u6848\u4e0d\u53ef\u5220\u9664\u3002", (String)"RpaSchemeListPlugin_13", (String)"epm-eb-formplugin", (Object[])new Object[0]));
        }
    }

    private void modifyRpaSchemeStatus(RpaConstants.Status status) {
        MultiLangEnumBridge opDesc;
        MultiLangEnumBridge opName;
        ListSelectedRowCollection selectedRows = ((BillList)this.getControl("billlistap")).getSelectedRows();
        List ids = selectedRows.stream().map(v -> IDUtils.toLong((Object)v.getPrimaryKeyValue().toString())).collect(Collectors.toList());
        if (CollectionUtils.isEmpty(ids)) {
            return;
        }
        RpaSchemeDao.getInstance().updateStatus(status, ids);
        if (status == RpaConstants.Status.ENABLE) {
            opName = new MultiLangEnumBridge("\u542f\u7528", "RpaSchemeListPlugin_14", "epm-eb-formplugin");
            opDesc = new MultiLangEnumBridge("RPA\u673a\u5668\u4eba\u65b9\u6848, id: %1$s, \u542f\u7528\u6210\u529f\u3002", "RpaSchemeListPlugin_15", "epm-eb-formplugin");
            this.writeLogWithEntityNumber(this.getView().getModel().getDataEntityType().getName(), null, "enable", opName, opDesc, ObjUtils.getStringArray((Object[])new Object[]{ids.toString()}));
            this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u542f\u7528\u6210\u529f\u3002", (String)"RpaSchemeListPlugin_16", (String)"epm-eb-formplugin", (Object[])new Object[0]));
        }
        if (status == RpaConstants.Status.DISABLE) {
            opName = new MultiLangEnumBridge("\u7981\u7528", "RpaSchemeListPlugin_17", "epm-eb-formplugin");
            opDesc = new MultiLangEnumBridge("RPA\u673a\u5668\u4eba\u65b9\u6848, id: %1$s, \u7981\u7528\u6210\u529f\u3002", "RpaSchemeListPlugin_18", "epm-eb-formplugin");
            this.writeLogWithEntityNumber(this.getView().getModel().getDataEntityType().getName(), null, "disable", opName, opDesc, ObjUtils.getStringArray((Object[])new Object[]{ids.toString()}));
            this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u7981\u7528\u6210\u529f\u3002", (String)"RpaSchemeListPlugin_19", (String)"epm-eb-formplugin", (Object[])new Object[0]));
        }
        this.refreshBillList();
    }

    public void confirmCallBack(MessageBoxClosedEvent e) {
        super.confirmCallBack(e);
        String callBackId = e.getCallBackId();
        if (callBackId.equals("deleteConfirm") && e.getResult().equals((Object)MessageBoxResult.Yes)) {
            this.deleteRpaScheme();
        }
    }

    @Override
    public void closedCallBack(ClosedCallBackEvent closedCallBackEvent) {
        super.closedCallBack(closedCallBackEvent);
        this.refreshBillList();
    }

    public void setFilter(SetFilterEvent e) {
        super.setFilter(e);
        Optional<QFilter> first = e.getQFilters().stream().filter(q -> "creater.id".equals(q.getProperty()) && "103".equals(String.valueOf(q.getValue()))).findFirst();
        first.ifPresent(qFilter -> qFilter.__setValue((Object)this.getUserId()));
        e.setOrderBy("id desc");
    }

    @Override
    public Long getModelId() {
        String modelIdStr = this.getPageCache().get("KEY_MODEL_ID");
        if (StringUtils.isNotEmpty((CharSequence)modelIdStr)) {
            long modelId = Long.parseLong(modelIdStr);
            if (modelId == 0L) {
                throw new KDBizException(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u4f53\u7cfb\u3002", (String)"RpaSchemeListPlugin_1", (String)"epm-eb-formplugin", (Object[])new Object[0]));
            }
            return modelId;
        }
        throw new KDBizException(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u4f53\u7cfb\u3002", (String)"RpaSchemeListPlugin_1", (String)"epm-eb-formplugin", (Object[])new Object[0]));
    }
}

