/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.formplugin.rpa;

import java.util.EventObject;
import java.util.List;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.resource.promptenum.MultiLangEnumBridge;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.exception.KDBizException;
import kd.bos.form.CloseCallBack;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.FormShowParameter;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.ShowType;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.events.SetFilterEvent;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.BillList;
import kd.bos.orm.query.QFilter;
import kd.epm.eb.business.rpa.JoinCheerExcelService;
import kd.epm.eb.business.rpa.RpaConstants;
import kd.epm.eb.business.rpa.dao.RpaIntegrationAttachmentDao;
import kd.epm.eb.business.rpa.dao.RpaIntegrationDao;
import kd.epm.eb.business.rpa.dao.RpaIntegrationSheetDao;
import kd.epm.eb.common.utils.IDUtils;
import kd.epm.eb.common.utils.base.ObjUtils;
import kd.epm.eb.formplugin.AbstractListPlugin;
import kd.epm.eb.spread.template.TemplateModelHelper;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.tuple.Pair;

public class RpaSheetMappingListPlugin
extends AbstractListPlugin {
    private static final String BTN_MAPPING = "btn_mapping";
    private static final String BTN_CELLMAPPING = "btn_cellmapping";
    private static final String BTN_BATCHMAPPING = "btn_batchmapping";
    private static final String BTN_ENABLE = "btn_enable";
    private static final String BTN_DISENABLE = "btn_disenable";
    private static final String BTN_REFRESH = "btn_refresh";
    private static final String BTN_CLOSE = "close";
    private static final String BTN_DELETE = "btn_delete";
    private static final String SHEET_NAMES = "sheetNames";
    private static final String CLOSE_SHEET_MAPPING_CALLBACK = "close_sheet_mapping_callback";
    private static final String CLOSE_CELL_MAPPING_CALLBACK = "close_cell_mapping_callback";

    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        FormShowParameter formShowParameter = this.getView().getFormShowParameter();
        Long modelId = (Long)formShowParameter.getCustomParam("KEY_MODEL_ID");
        this.getPageCache().put("model", String.valueOf(modelId));
    }

    @Override
    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addItemClickListeners(new String[]{"toolbarap"});
    }

    private void refreshBillList() {
        BillList billList = (BillList)this.getView().getControl("billlistap");
        billList.clearSelection();
        billList.setFilter(this.getFilter());
        billList.setOrderBy("seqnum");
        billList.refresh();
    }

    private QFilter getFilter() {
        Long rpaIntegrationId = this.getRpaIntegrationId();
        return new QFilter("rpainte", "=", (Object)rpaIntegrationId);
    }

    public void setFilter(SetFilterEvent e) {
        super.setFilter(e);
        e.getQFilters().add(this.getFilter());
        e.setOrderBy("seqnum");
    }

    public void itemClick(ItemClickEvent evt) {
        super.itemClick(evt);
        String itemKey = evt.getItemKey();
        ListSelectedRowCollection selectedRows = ((BillList)this.getControl("billlistap")).getSelectedRows();
        this.checkIsSelectData(itemKey, selectedRows);
        if (!this.checkRpaIntegrationStatus(itemKey)) {
            this.refreshBillList();
            return;
        }
        List<Long> ids = selectedRows.stream().map(v -> IDUtils.toLong((Object)v.getPrimaryKeyValue().toString())).collect(Collectors.toList());
        switch (itemKey) {
            case "btn_mapping": {
                this.openSheetMapping();
                break;
            }
            case "btn_cellmapping": {
                if (ids.size() > 1) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u4e00\u884c\u6570\u636e\u3002", (String)"RpaSheetMappingListPlugin_4", (String)"epm-eb-formplugin", (Object[])new Object[0]));
                    break;
                }
                this.openCellMapping((Long)ids.get(0));
                break;
            }
            case "btn_enable": 
            case "btn_disenable": {
                RpaConstants.EffectStatus status = BTN_ENABLE.equals(itemKey) ? RpaConstants.EffectStatus.EFFECTIVE : RpaConstants.EffectStatus.NONEFFECTIVE;
                this.changeEnable(ids, status);
                this.refreshBillList();
                break;
            }
            case "btn_refresh": {
                this.refreshBillList();
                break;
            }
            case "btn_delete": {
                DynamicObjectCollection dynamicObjects = RpaIntegrationSheetDao.getInstance().queryStatus(ids);
                if (dynamicObjects.stream().anyMatch(dynamicObject -> RpaConstants.Status.ENABLE.getValue().equals(dynamicObject.getString("effectstatus")))) {
                    throw new KDBizException(ResManager.loadKDString((String)"\u6620\u5c04\u5df2\u751f\u6548\uff0c\u4e0d\u5141\u8bb8\u5220\u9664\u3002", (String)"RpaSheetMappingListPlugin_19", (String)"epm-eb-formplugin", (Object[])new Object[0]));
                }
                if (RpaIntegrationSheetDao.getInstance().queryTemplateRef(this.getRpaIntegrationId(), ids)) {
                    throw new KDBizException(ResManager.loadKDString((String)"\u5b58\u5728\u6570\u636e\u88abRPA\u673a\u5668\u4eba\u5f15\u7528\uff0c\u65e0\u6cd5\u5220\u9664\u3002", (String)"RpaSheetMappingListPlugin_18", (String)"epm-eb-formplugin", (Object[])new Object[0]));
                }
                this.getView().showConfirm(ResManager.loadKDString((String)"\u786e\u5b9a\u5220\u9664\u6240\u9009\u8bb0\u5f55\uff1f", (String)"RpaSheetMappingListPlugin_9", (String)"epm-eb-formplugin", (Object[])new Object[0]), MessageBoxOptions.YesNo, new ConfirmCallBackListener("confirm_del", (IFormPlugin)this));
                break;
            }
        }
    }

    @Override
    public void closedCallBack(ClosedCallBackEvent ccbe) {
        super.closedCallBack(ccbe);
        if (CLOSE_SHEET_MAPPING_CALLBACK.equals(ccbe.getActionId())) {
            this.refreshBillList();
        }
    }

    public void confirmCallBack(MessageBoxClosedEvent mbce) {
        super.confirmCallBack(mbce);
        String callBackId = mbce.getCallBackId();
        int result = mbce.getResult().getValue();
        if (MessageBoxResult.Yes.getValue() == result) {
            ListSelectedRowCollection selectedRows = ((BillList)this.getControl("billlistap")).getSelectedRows();
            List<Long> selectedIds = selectedRows.stream().map(v -> IDUtils.toLong((Object)v.getPrimaryKeyValue().toString())).collect(Collectors.toList());
            if (CollectionUtils.isEmpty(selectedIds)) {
                return;
            }
            if ("confirm_del".equals(callBackId)) {
                this.deleteRpaIntegrationSheet(selectedIds);
            }
            this.refreshBillList();
        }
    }

    private void openCellMapping(Long id) {
        DynamicObject sheetMapping = RpaIntegrationSheetDao.getInstance().loadSingle(id);
        if (sheetMapping == null) {
            throw new KDBizException(ResManager.loadKDString((String)"\u8be5\u6761\u8bb0\u5f55\u5df2\u4e0d\u5b58\u5728\uff0c\u8bf7\u5237\u65b0\u9875\u9762\u3002", (String)"RpaSheetMappingListPlugin_21", (String)"epm-eb-formplugin", (Object[])new Object[0]));
        }
        long templateId = sheetMapping.getLong("template_id");
        Pair pair = TemplateModelHelper.getTemplateModel((String)String.valueOf(templateId));
        if (pair == null || pair.getLeft() == null) {
            throw new KDBizException(ResManager.loadKDString((String)"\u62a5\u8868\u6a21\u677f\u4e0d\u5b58\u5728\uff0c\u8bf7\u68c0\u67e5\u3002", (String)"RpaSheetMappingListPlugin_22", (String)"epm-eb-formplugin", (Object[])new Object[0]));
        }
        String pageId = "eb_rpa_cellmapping_" + this.getView().getPageId() + "_" + id;
        String sheetName = sheetMapping.getString("sheetname");
        String pageTitle = ResManager.loadResFormat((String)"\u5355\u5143\u683c\u6620\u5c04-%1", (String)"RpaSheetMappingListPlugin_25", (String)"epm-eb-formplugin", (Object[])new Object[]{sheetName});
        boolean isZipExport = RpaIntegrationDao.getInstance().queryIsZipExport(this.getRpaIntegrationId());
        CloseCallBack closeCallBack = new CloseCallBack((IFormPlugin)this, CLOSE_CELL_MAPPING_CALLBACK);
        FormShowParameter formShowParameter = new FormShowParameter();
        formShowParameter.setParentPageId(this.getView().getPageId());
        formShowParameter.setPageId(pageId);
        formShowParameter.setFormId("eb_rpa_cellmapping");
        formShowParameter.setCaption(pageTitle);
        formShowParameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
        formShowParameter.setCloseCallBack(closeCallBack);
        formShowParameter.setCustomParam("integrationId", (Object)this.getRpaIntegrationId());
        formShowParameter.setCustomParam("sheetMappingId", (Object)id);
        formShowParameter.setCustomParam("isZipExport", (Object)String.valueOf(isZipExport));
        formShowParameter.setCustomParam("sheetName", (Object)sheetName);
        formShowParameter.setCustomParam("KEY_MODEL_ID", (Object)this.getModelId());
        this.getView().showForm(formShowParameter);
    }

    private void openSheetMapping() {
        Long integrationId = this.getRpaIntegrationId();
        String fileUrl = RpaIntegrationAttachmentDao.getInstance().getExcelFileUrl(integrationId);
        List sheetNames = JoinCheerExcelService.getInstance().getSheetNameList(fileUrl);
        boolean isZipExport = RpaIntegrationDao.getInstance().queryIsZipExport(integrationId);
        CloseCallBack closeCallBack = new CloseCallBack((IFormPlugin)this, CLOSE_SHEET_MAPPING_CALLBACK);
        FormShowParameter formShowParameter = new FormShowParameter();
        formShowParameter.setParentPageId(this.getView().getPageId());
        formShowParameter.setFormId("eb_rpa_sheetmapping_edit");
        formShowParameter.getOpenStyle().setShowType(ShowType.Modal);
        formShowParameter.setCloseCallBack(closeCallBack);
        formShowParameter.setCustomParam("integrationId", (Object)integrationId);
        formShowParameter.setCustomParam(SHEET_NAMES, (Object)sheetNames);
        formShowParameter.setCustomParam("isZipExport", (Object)String.valueOf(isZipExport));
        formShowParameter.setCustomParam("bizmodel", this.getView().getFormShowParameter().getCustomParam("bizmodel"));
        formShowParameter.setCustomParam("KEY_MODEL_ID", (Object)this.getModelId());
        this.getView().showForm(formShowParameter);
    }

    private void deleteRpaIntegrationSheet(List<Long> ids) {
        RpaIntegrationSheetDao.getInstance().delete(ids);
        MultiLangEnumBridge opName = new MultiLangEnumBridge("\u5220\u9664", "RpaSheetMappingListPlugin_23", "epm-eb-formplugin");
        MultiLangEnumBridge opDesc = new MultiLangEnumBridge("RPA\u8868\u683c\u6620\u5c04ID\u201c%1$s\u201d\u5df2\u5220\u9664\u3002", "RpaSheetMappingListPlugin_24", "epm-eb-formplugin");
        this.writeLogWithEntityNumber(this.getView().getModel().getDataEntityType().getName(), null, "delete", opName, opDesc, ObjUtils.getStringArray((Object[])new Object[]{ids.toString()}));
        this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u5220\u9664\u6210\u529f\u3002", (String)"RpaSheetMappingListPlugin_20", (String)"epm-eb-formplugin", (Object[])new Object[0]));
    }

    private void changeEnable(List<Long> ids, RpaConstants.EffectStatus status) {
        boolean isAllSuccess = RpaIntegrationSheetDao.getInstance().updateEffectStatus(ids, status);
        if (isAllSuccess) {
            if (RpaConstants.EffectStatus.EFFECTIVE == status) {
                String opDescString = ResManager.loadKDString((String)"\u751f\u6548\u72b6\u6001\u4fee\u6539\u6210\u529f\u3002", (String)"RpaSheetMappingListPlugin_11", (String)"epm-eb-formplugin", (Object[])new Object[0]);
                MultiLangEnumBridge opName = new MultiLangEnumBridge("\u751f\u6548", "RpaSheetMappingListPlugin_16", "epm-eb-formplugin");
                MultiLangEnumBridge opDesc = new MultiLangEnumBridge("\u751f\u6548\u72b6\u6001\u4fee\u6539\u6210\u529f\u3002", "RpaSheetMappingListPlugin_11", "epm-eb-formplugin");
                this.writeLogWithEntityNumber(this.getView().getModel().getDataEntityType().getName(), null, "enable", opName, opDesc, null);
                this.getView().showSuccessNotification(opDescString);
            } else {
                String opDescString = ResManager.loadKDString((String)"\u751f\u6548\u72b6\u6001\u4fee\u6539\u6210\u529f\u3002", (String)"RpaSheetMappingListPlugin_11", (String)"epm-eb-formplugin", (Object[])new Object[0]);
                MultiLangEnumBridge opName = new MultiLangEnumBridge("\u5931\u6548", "RpaSheetMappingListPlugin_17", "epm-eb-formplugin");
                MultiLangEnumBridge opDesc = new MultiLangEnumBridge("\u751f\u6548\u72b6\u6001\u4fee\u6539\u6210\u529f\u3002", "RpaSheetMappingListPlugin_11", "epm-eb-formplugin");
                this.writeLogWithEntityNumber(this.getView().getModel().getDataEntityType().getName(), null, "disable", opName, opDesc, null);
                this.getView().showSuccessNotification(opDescString);
            }
        } else {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u672a\u6620\u5c04\u7684\u6570\u636e\u4e0d\u5141\u8bb8\u4fee\u6539\u4e3a\u751f\u6548\u72b6\u6001\u3002", (String)"RpaSheetMappingListPlugin_14", (String)"epm-eb-formplugin", (Object[])new Object[0]));
        }
    }

    private void checkIsSelectData(String itemKey, ListSelectedRowCollection selectedRows) {
        if (!BTN_CLOSE.equals(itemKey) && !RpaIntegrationDao.getInstance().checkRpaIntegrationExisted(this.getRpaIntegrationId())) {
            throw new KDBizException(ResManager.loadKDString((String)"\u8868\u683c\u6620\u5c04\u7684RPA\u96c6\u6210\u65b9\u6848\u5df2\u5220\u9664\uff0c\u8bf7\u9000\u51fa\u3002", (String)"RpaSheetMappingListPlugin_5", (String)"epm-eb-formplugin", (Object[])new Object[0]));
        }
        if (selectedRows.isEmpty() && !BTN_MAPPING.equals(itemKey) && !BTN_REFRESH.equals(itemKey) && !BTN_CLOSE.equals(itemKey)) {
            throw new KDBizException(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u8981\u64cd\u4f5c\u7684\u884c\u3002", (String)"RpaSheetMappingListPlugin_3", (String)"epm-eb-formplugin", (Object[])new Object[0]));
        }
    }

    private boolean checkRpaIntegrationStatus(String itemKey) {
        RpaConstants.Status status = RpaIntegrationDao.getInstance().queryRpaIntegrationStatus(this.getRpaIntegrationId());
        if (status == null) {
            return false;
        }
        if (!(status != RpaConstants.Status.ENABLE || BTN_CELLMAPPING.equals(itemKey) || BTN_REFRESH.equals(itemKey) || BTN_CLOSE.equals(itemKey))) {
            throw new KDBizException(ResManager.loadKDString((String)"\u65b9\u6848\u5df2\u542f\u7528\uff0c\u8bf7\u7981\u7528\u540e\u91cd\u8bd5\u3002", (String)"RpaSheetMappingListPlugin_2", (String)"epm-eb-formplugin", (Object[])new Object[0]));
        }
        return true;
    }

    private Long getRpaIntegrationId() {
        return IDUtils.toLong((Object)this.getView().getFormShowParameter().getCustomParam("integrationId"));
    }

    @Override
    public Long getModelId() {
        return IDUtils.toLong((Object)this.getPageCache().get("model"));
    }
}

