/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.formplugin.rpa;

import java.util.ArrayList;
import java.util.Collections;
import java.util.EventObject;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.exception.KDBizException;
import kd.bos.filter.CommonFilterColumn;
import kd.bos.form.IFormView;
import kd.bos.form.control.events.ClickListener;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.FilterContainerInitArgs;
import kd.bos.form.events.FilterContainerSearchClickArgs;
import kd.bos.form.events.SetFilterEvent;
import kd.bos.form.field.ComboItem;
import kd.bos.form.field.events.BeforeFilterF7SelectEvent;
import kd.bos.list.BillList;
import kd.bos.list.ListGridView;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.util.StringUtils;
import kd.epm.eb.business.rpa.RpaService;
import kd.epm.eb.business.rpa.dao.RpaSchemeDao;
import kd.epm.eb.business.rpa.dao.RpaTaskLogDao;
import kd.epm.eb.business.userselect.UserSelectUtils;
import kd.epm.eb.common.enums.ApplicationTypeEnum;
import kd.epm.eb.common.permission.FunPermissionHelper;
import kd.epm.eb.common.utils.IDUtils;
import kd.epm.eb.common.utils.UserUtils;
import kd.epm.eb.formplugin.AbstractListPlugin;
import org.apache.commons.collections4.MapUtils;

public class RpaTaskLogListPlugin
extends AbstractListPlugin {
    private static final String TASK_LOG_CLOSE_CALLBACK = "taskLogCloseCallback";
    private CommonFilterColumn schemeFilterCol;

    public void filterContainerInit(FilterContainerInitArgs args) {
        super.filterContainerInit(args);
        this.modelFilterInit(args);
        this.rpaSchemeFilterInit(args);
    }

    private void modelFilterInit(FilterContainerInitArgs args) {
        List commonFilterColumns = args.getCommonFilterColumns();
        CommonFilterColumn filterColumn = commonFilterColumns.stream().filter(c -> c.getFieldName().equals("model.name")).findFirst().orElse(null);
        if (filterColumn == null) {
            return;
        }
        String modelId = String.valueOf(this.getModelId());
        Set perRoleIds = FunPermissionHelper.getRoleModel((Long)UserUtils.getUserId(), (String)"epm_model", (ApplicationTypeEnum)ApplicationTypeEnum.BGMD, (String)"eb_rpa_scheme", (String)"47150e89000000ac");
        QFilter qFilter = new QFilter("id", "in", (Object)perRoleIds);
        DynamicObjectCollection col = QueryServiceHelper.query((String)"model", (String)"epm_model", (String)"id,name", (QFilter[])qFilter.toArray(), null);
        filterColumn.getComboItems().clear();
        ArrayList comboItems = new ArrayList(16);
        col.forEach(e -> comboItems.add(new ComboItem(new LocaleString(e.getString("name")), e.getString("id"))));
        filterColumn.setComboItems(comboItems);
        filterColumn.setDefaultValue(modelId);
    }

    private void rpaSchemeFilterInit(FilterContainerInitArgs args) {
        List commonFilterColumns = args.getCommonFilterColumns();
        this.schemeFilterCol = commonFilterColumns.stream().filter(c -> c.getFieldName().equals("scheme.name")).findFirst().orElse(null);
        this.setSchemeFilterCol();
    }

    private void setSchemeFilterCol() {
        if (this.schemeFilterCol == null) {
            return;
        }
        Long rpaSchemeId = this.getRpaSchemeId();
        DynamicObjectCollection col = RpaSchemeDao.getInstance().loadByModel(this.getModelId());
        this.schemeFilterCol.getComboItems().clear();
        ArrayList comboItems = new ArrayList(16);
        col.forEach(e -> comboItems.add(new ComboItem(new LocaleString(e.getString("name")), e.getString("id"))));
        this.schemeFilterCol.setComboItems(comboItems);
        long count = comboItems.stream().filter(rpaScheme -> rpaScheme != null && rpaSchemeId.toString().equals(rpaScheme.getValue())).count();
        String rpaScheme2 = rpaSchemeId.toString();
        if (count > 0L) {
            this.schemeFilterCol.setDefaultValue(rpaScheme2);
        }
        this.getPageCache().put("schemeId", rpaScheme2);
    }

    public void filterContainerBeforeF7Select(BeforeFilterF7SelectEvent args) {
        super.filterContainerBeforeF7Select(args);
        if ("model.id".equals(args.getFieldName())) {
            Set perRoleIds = FunPermissionHelper.getRoleModel((Long)UserUtils.getUserId(), (String)"epm_model", (ApplicationTypeEnum)ApplicationTypeEnum.BGMD, (String)"eb_rpa_scheme", (String)"47150e89000000ac");
            QFilter qFilter = new QFilter("id", "in", (Object)perRoleIds);
            args.addCustomQFilter(qFilter);
            args.getCustomParams().put("callFromRefBillEdit", true);
        }
        if ("scheme.id".equals(args.getFieldName())) {
            args.setCustomQFilters(Collections.singletonList(new QFilter("model", "=", (Object)this.getModelId())));
            args.getQfilters().add(new QFilter("model", "=", (Object)this.getModelId()));
            args.getCustomParams().put("callFromRefBillEdit", true);
        }
    }

    public void filterContainerSearchClick(FilterContainerSearchClickArgs args) {
        super.filterContainerSearchClick(args);
        Map currentCommonFilter = args.getCurrentCommonFilter();
        if (currentCommonFilter != null) {
            if ("model.id".equals(((List)currentCommonFilter.get("FieldName")).get(0))) {
                Long modelId = IDUtils.toLong(((List)currentCommonFilter.get("Value")).get(0));
                if (IDUtils.isNull((Long)modelId)) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u4f53\u7cfb\u3002", (String)"RpaTaskLogListPlugin_4", (String)"epm-eb-formplugin", (Object[])new Object[0]));
                } else {
                    UserSelectUtils.saveUserSelectModelId((IFormView)this.getView(), (long)modelId);
                    this.getPageCache().put("KEY_MODEL_ID", modelId.toString());
                    DynamicObjectCollection col = RpaSchemeDao.getInstance().loadByModel(modelId);
                    if (col.isEmpty()) {
                        ((List)args.getFilterValues().get("customfilter")).removeIf(t -> ((List)t.get("FieldName")).get(0) != null && "scheme.id".equals(((List)t.get("FieldName")).get(0)));
                        this.getView().showTipNotification(ResManager.loadKDString((String)"\u8be5\u4f53\u7cfb\u4e0b\u65e0RPA\u673a\u5668\u4eba\u65b9\u6848\u3002", (String)"RpaTaskLogListPlugin_3", (String)"epm-eb-formplugin", (Object[])new Object[0]));
                    }
                    this.setSchemeFilterCol();
                }
            } else if ("scheme.id".equals(((List)currentCommonFilter.get("FieldName")).get(0))) {
                this.getPageCache().put("schemeId", String.valueOf(((List)currentCommonFilter.get("Value")).get(0)));
            }
        }
    }

    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        Long modelId = (Long)this.getView().getFormShowParameter().getCustomParam("KEY_MODEL_ID");
        Long rpaSchemeId = (Long)this.getView().getFormShowParameter().getCustomParam("schemeId");
        this.getPageCache().put("KEY_MODEL_ID", modelId.toString());
        this.getPageCache().put("schemeId", rpaSchemeId.toString());
    }

    @Override
    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addItemClickListeners(new String[]{"toolbarap"});
        ListGridView list = (ListGridView)this.getView().getControl("gridview");
        list.addClickListener((ClickListener)this);
    }

    public void itemClick(ItemClickEvent evt) {
        super.itemClick(evt);
        String key = evt.getItemKey();
        ListSelectedRowCollection selectedRows = ((BillList)this.getControl("billlistap")).getSelectedRows();
        switch (key) {
            case "btn_showlog": {
                this.checkIsSelectOneData(selectedRows);
                this.showLog(IDUtils.toLong((Object)selectedRows.get(0).getPrimaryKeyValue()));
                break;
            }
            case "btn_synctasklog": {
                this.checkIsSelectOneData(selectedRows);
                this.syncLog(IDUtils.toLong((Object)selectedRows.get(0).getPrimaryKeyValue()));
            }
            case "btn_refresh": {
                this.refreshBillList();
                break;
            }
        }
    }

    private void showLog(Long id) {
        String taskId;
        DynamicObject dynamicObject = RpaTaskLogDao.getInstance().load(id);
        if (dynamicObject != null && StringUtils.isNotEmpty((String)(taskId = dynamicObject.getString("taskid")))) {
            String url = RpaService.getInstance().getTaskLogUrl(taskId);
            this.getView().openUrl(url);
            return;
        }
        this.getView().showTipNotification(ResManager.loadKDString((String)"\u8be5\u65b9\u6848\u6682\u65e0\u65e5\u5fd7\u3002", (String)"RpaTaskLogListPlugin_1", (String)"epm-eb-formplugin", (Object[])new Object[0]), Integer.valueOf(1500));
    }

    private void syncLog(Long id) {
        Map taskInfo;
        String taskId;
        DynamicObject dynamicObject = RpaTaskLogDao.getInstance().load(id);
        if (dynamicObject != null && StringUtils.isNotEmpty((String)(taskId = dynamicObject.getString("taskid"))) && MapUtils.isNotEmpty((Map)(taskInfo = RpaService.getInstance().getTaskInfo(taskId)))) {
            RpaTaskLogDao.getInstance().updateStatus(taskId, taskInfo);
            return;
        }
        this.getView().showTipNotification(ResManager.loadKDString((String)"\u8be5\u65b9\u6848\u6682\u65e0\u65e5\u5fd7\u3002", (String)"RpaTaskLogListPlugin_1", (String)"epm-eb-formplugin", (Object[])new Object[0]), Integer.valueOf(1500));
    }

    @Override
    public void closedCallBack(ClosedCallBackEvent closedCallBackEvent) {
        super.closedCallBack(closedCallBackEvent);
        String key = closedCallBackEvent.getActionId();
        if (TASK_LOG_CLOSE_CALLBACK.equals(key)) {
            this.refreshBillList();
        }
    }

    private void refreshBillList() {
        BillList billList = (BillList)this.getView().getControl("billlistap");
        billList.setClearSelection(true);
        billList.setFilter(this.getQFilter());
        billList.setOrderBy("id desc");
        billList.refresh();
    }

    public void setFilter(SetFilterEvent e) {
        super.setFilter(e);
        e.setOrderBy("id desc");
    }

    private QFilter getQFilter() {
        QFilter q1 = new QFilter("scheme", "=", (Object)this.getRpaSchemeId());
        QFilter q2 = new QFilter("model", "=", (Object)this.getModelId());
        return q1.and(q2);
    }

    private void checkIsSelectOneData(ListSelectedRowCollection selectedRows) {
        if (selectedRows.size() != 1) {
            throw new KDBizException(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u4e00\u884c\u6570\u636e\u3002", (String)"RpaTaskLogListPlugin_0", (String)"epm-eb-formplugin", (Object[])new Object[0]));
        }
    }

    @Override
    public Long getModelId() {
        Long modelId = IDUtils.toLong((Object)this.getPageCache().get("KEY_MODEL_ID"));
        if (IDUtils.isEmptyLong((Long)modelId).booleanValue()) {
            modelId = (Long)this.getView().getFormShowParameter().getCustomParam("KEY_MODEL_ID");
            this.getPageCache().put("KEY_MODEL_ID", modelId.toString());
        }
        return modelId;
    }

    public Long getRpaSchemeId() {
        Long rpaSchemeId = IDUtils.toLong((Object)this.getPageCache().get("schemeId"));
        if (IDUtils.isEmptyLong((Long)rpaSchemeId).booleanValue()) {
            rpaSchemeId = (Long)this.getView().getFormShowParameter().getCustomParam("schemeId");
            this.getPageCache().put("schemeId", rpaSchemeId.toString());
        }
        return rpaSchemeId;
    }
}

