/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.formplugin.rpa.export;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.epm.eb.common.cache.IModelCacheHelper;
import kd.epm.eb.common.cache.ModelCacheContext;
import kd.epm.eb.common.cache.impl.Member;
import kd.epm.eb.common.enums.POIExportCallerEnum;
import kd.epm.eb.common.enums.ProcessTypeEnum;
import kd.epm.eb.common.enums.SysDimensionEnum;
import kd.epm.eb.common.report.excel.ExportExceptionHelper;
import kd.epm.eb.common.reportprocess.entity.domain.ReportProcess;
import kd.epm.eb.common.reportprocess.entity.dto.ReportProcessQuote;
import kd.epm.eb.common.reportprocess.service.impl.ReportProcessQuoteService;
import kd.epm.eb.common.reportprocess.service.impl.ReportProcessServiceImpl;
import kd.epm.eb.formplugin.report.excel.command.DataExportCommand;
import kd.epm.eb.formplugin.report.excel.command.POIExportCommand;
import kd.epm.eb.formplugin.report.excel.service.ExportLogService;
import kd.epm.eb.spread.report.excel.constant.ReportExportTypeEnum;
import kd.epm.eb.spread.report.excel.entity.request.ReportExportDataRequest;
import kd.epm.eb.spread.report.excel.entity.request.ReportExportTaskRequest;
import kd.epm.eb.spread.template.ITemplateModel;
import kd.epm.eb.spread.template.TemplateModelHelper;
import kd.epm.eb.spread.template.pagedim.IPageDimensionEntry;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.collections4.MapUtils;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.poi.ss.usermodel.Workbook;

public class EbReportDataService {
    private static final Log log = LogFactory.getLog(EbReportDataService.class);

    public static EbReportDataService getInstance() {
        return InnerClass.instance;
    }

    private EbReportDataService() {
    }

    public Workbook createWorkbook(DynamicObject rpaScheme, long entityId, Long entityViewId, String fileName, Map<Long, Map<Integer, String>> floatRowRangeMap) {
        List<ReportExportDataRequest> request = this.createReportExportDataRequestList(rpaScheme, entityId, entityViewId, fileName);
        ReportExportTaskRequest reportExportTaskRequest = ExportLogService.getInstance().createReportExportTaskRequest(request, 3600L);
        if (reportExportTaskRequest == null) {
            return null;
        }
        ExportExceptionHelper.getInstance().setTimeout(String.valueOf(reportExportTaskRequest.getExportLogId()), 3600);
        POIExportCommand exportCmd = new POIExportCommand(reportExportTaskRequest);
        List<Workbook> workbooks = exportCmd.writeToWorkbookV1(POIExportCallerEnum.RPA);
        Map<Long, Map<Integer, String>> wbFloatRowMap = exportCmd.getFloatRowRangeMap();
        if (MapUtils.isNotEmpty(wbFloatRowMap)) {
            floatRowRangeMap.putAll(wbFloatRowMap);
        }
        if (CollectionUtils.isNotEmpty(workbooks)) {
            return workbooks.get(0);
        }
        return null;
    }

    public Map<Long, Map<String, Object>> getReportData(DynamicObject rpaScheme, Long entityId, Long entityViewId, String fileName, Map<Long, Map<Integer, String>> floatRowRangeMap) {
        List<ReportExportDataRequest> request = this.createReportExportDataRequestList(rpaScheme, entityId, entityViewId, fileName);
        ReportExportTaskRequest reportExportTaskRequest = ExportLogService.getInstance().createReportExportTaskRequest(request, 3600L);
        if (reportExportTaskRequest == null) {
            return null;
        }
        ExportExceptionHelper.getInstance().setTimeout(String.valueOf(reportExportTaskRequest.getExportLogId()), 3600);
        DataExportCommand dataExportCmd = new DataExportCommand(reportExportTaskRequest);
        Map<Long, Map<String, Object>> reportData = dataExportCmd.getReportData();
        Map<Long, Map<Integer, String>> floatRowMap = dataExportCmd.getFloatRowRangeMap();
        if (MapUtils.isNotEmpty(floatRowMap)) {
            floatRowRangeMap.putAll(floatRowMap);
        }
        return reportData;
    }

    private List<ReportExportDataRequest> createReportExportDataRequestList(DynamicObject rpaScheme, Long entityId, Long entityViewId, String fileName) {
        long modelId = rpaScheme.getLong("model.id");
        long dataTypeId = rpaScheme.getLong("datatype.id");
        long versionId = rpaScheme.getLong("version.id");
        long periodId = rpaScheme.getLong("period.id");
        DynamicObjectCollection templateList = (DynamicObjectCollection)rpaScheme.get("entrytemplate");
        Map<Long, String> templateMap = templateList.stream().collect(Collectors.toMap(dy -> dy.getLong("template.id"), dy -> dy.getString("template.name")));
        ArrayList<ReportExportDataRequest> reportExportDataRequests = new ArrayList<ReportExportDataRequest>(16);
        for (Map.Entry<Long, String> entry : templateMap.entrySet()) {
            Map.Entry first;
            Set processQuotes;
            long templateId = entry.getKey();
            String sheetName = entry.getValue();
            ReportProcess reportProcess = ReportProcessServiceImpl.getInstance().getReportProcess(Long.valueOf(modelId), Long.valueOf(templateId), entityId, Long.valueOf(periodId), Long.valueOf(dataTypeId), Long.valueOf(versionId));
            if (reportProcess == null) continue;
            Long processId = reportProcess.getId();
            Map reportProcessQuote = ReportProcessQuoteService.getInstance().getReportProcessQuote(processId, Long.valueOf(modelId));
            if (MapUtils.isEmpty((Map)reportProcessQuote) || CollectionUtils.isEmpty((Collection)(processQuotes = (Set)(first = reportProcessQuote.entrySet().iterator().next()).getValue()))) continue;
            ProcessTypeEnum processType = (ProcessTypeEnum)first.getKey();
            long reportProcessId = ((ReportProcessQuote)processQuotes.iterator().next()).getSourceId2();
            Map<String, String> pageDimMemberMap = this.getPageDefaultMember(modelId, templateId, entityId, entityViewId, dataTypeId, versionId, periodId);
            ReportExportDataRequest reportExportDataRequest = new ReportExportDataRequest(Long.valueOf(templateId), entityId, entityViewId, processId, Long.valueOf(reportProcessId), processType, Long.valueOf(modelId), Boolean.valueOf(false), Boolean.valueOf(false), pageDimMemberMap, fileName, sheetName, ReportExportTypeEnum.EXPORT_DATA, true);
            reportExportDataRequest.setShowDimName(true);
            reportExportDataRequests.add(reportExportDataRequest);
        }
        return reportExportDataRequests;
    }

    private Map<String, String> getPageDefaultMember(long modelId, long templateId, long entityId, Long entityViewId, long dataTypeId, long versionId, long periodId) {
        HashMap<String, String> pageDimMemberMap = new HashMap<String, String>(16);
        Pair pair = TemplateModelHelper.getTemplateModel((String)String.valueOf(templateId));
        if (pair == null) {
            return pageDimMemberMap;
        }
        ITemplateModel templateModel = (ITemplateModel)pair.getLeft();
        if (templateModel == null) {
            return pageDimMemberMap;
        }
        IModelCacheHelper modelCache = ModelCacheContext.getOrCreate((Long)modelId);
        List pagemembentry = templateModel.getPagemembentry();
        for (IPageDimensionEntry dimensionEntry : pagemembentry) {
            Member member;
            String number = dimensionEntry.getDimension().getNumber();
            long memberId = 0L;
            Long viewId = 0L;
            if (SysDimensionEnum.Entity.getNumber().equals(number)) {
                memberId = entityId;
                viewId = entityViewId;
            } else if (SysDimensionEnum.Version.getNumber().equals(number)) {
                memberId = versionId;
            } else if (SysDimensionEnum.DataType.getNumber().equals(number)) {
                memberId = dataTypeId;
            } else if (SysDimensionEnum.BudgetPeriod.getNumber().equals(number)) {
                memberId = periodId;
            }
            if (memberId <= 0L || (member = modelCache.getMember(number, viewId, Long.valueOf(memberId))) == null) continue;
            pageDimMemberMap.put(number, member.getNumber());
        }
        return pageDimMemberMap;
    }

    private static class InnerClass {
        private static final EbReportDataService instance = new EbReportDataService();

        private InnerClass() {
        }
    }
}

