/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.formplugin.rpa.export;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.epm.eb.business.rpa.entity.RpaIntegrationCell;
import kd.epm.eb.business.rpa.model.CellAreaMapping;
import kd.epm.eb.business.rpa.model.CellMapping;
import kd.epm.eb.business.rpa.model.JQReport;
import kd.epm.eb.business.rpa.model.JQTable;
import kd.epm.eb.common.utils.ExcelUtils;
import kd.epm.eb.common.utils.Point;
import org.apache.commons.collections4.MapUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang3.tuple.Pair;

public class JqCsvService {
    private static final Log log = LogFactory.getLog(JqCsvService.class);
    private final String lineSeparator = System.getProperty("line.separator", "\n");

    public static JqCsvService getInstance() {
        return InnerClass.instance;
    }

    private JqCsvService() {
    }

    public void createCsvFile(DynamicObject entityRef, DynamicObjectCollection sheetMappings, List<RpaIntegrationCell> cellMappingList, Map<String, JQReport> jqReportMap, Map<String, Pair<String, StringBuilder>> csvFileMap, Map<Long, Map<String, Object>> reportDataMap, String postfix, Map<Long, Map<Integer, String>> floatRowRangeMap) {
        jqReportMap.values().forEach(jqReport -> jqReport.getTables().values().forEach(jqTable -> {
            jqTable.setFixDataMap(Collections.emptyMap());
            jqTable.setFloatDataList(Collections.emptyList());
        }));
        this.buildCellMapping(jqReportMap, sheetMappings, cellMappingList, floatRowRangeMap, reportDataMap);
        sheetMappings.forEach(dyn -> {
            String jqNumber = dyn.getString("number");
            String enumField = dyn.getString("enumfield");
            Set enumFieldSet = StringUtils.isNotBlank((String)enumField) ? Arrays.stream(enumField.split(",")).collect(Collectors.toSet()) : Collections.emptySet();
            JQReport jqReport = (JQReport)jqReportMap.get(jqNumber.toLowerCase());
            if (jqReport == null) {
                return;
            }
            if ("unitcat".equals(jqReport.getName())) {
                JQTable jqTable = (JQTable)jqReport.getTables().get(jqNumber.toLowerCase());
                String tableCode = jqTable.getCode();
                StringBuilder csvSb = this.getFile(tableCode, postfix, csvFileMap);
                StringBuilder sb = this.newLine(entityRef, true);
                jqTable.getFields().forEach(field -> this.addData(sb, this.getData((String)field, jqTable.getFixDataMap(), enumFieldSet)));
                csvSb.append(this.endLine(sb));
            } else {
                jqReport.getTables().values().forEach(table -> {
                    String tableCode = table.getCode();
                    StringBuilder csvSb = this.getFile(tableCode, postfix, csvFileMap);
                    if (!table.isFloat()) {
                        StringBuilder sb = this.newLine(entityRef, false);
                        table.getFields().forEach(field -> this.addData(sb, this.getData((String)field, table.getFixDataMap(), enumFieldSet)));
                        csvSb.append(this.endLine(sb));
                    } else {
                        table.getFloatDataList().forEach(floatData -> {
                            StringBuilder sb = this.newLine(entityRef, false);
                            table.getFields().forEach(field -> this.addData(sb, this.getData((String)field, (Map<String, Object>)floatData, enumFieldSet)));
                            csvSb.append(this.endLine(sb));
                        });
                    }
                });
            }
        });
    }

    private Object getData(String field, Map<String, Object> dataMap, Set<String> enumFieldSet) {
        Object data = dataMap.get(field);
        if (data == null) {
            return null;
        }
        if (!enumFieldSet.contains(field)) {
            return data;
        }
        String s = data.toString();
        int flagIndex = s.indexOf("|");
        if (flagIndex <= 0) {
            return s;
        }
        return s.substring(0, flagIndex).trim();
    }

    private StringBuilder newLine(DynamicObject entityRef, boolean isUnitcat) {
        String uuid = entityRef.getString("number") + entityRef.getString("reporttype");
        StringBuilder sb = new StringBuilder();
        this.addData(sb, uuid);
        this.addData(sb, isUnitcat ? uuid : "1");
        return sb;
    }

    private String endLine(StringBuilder sb) {
        return sb.substring(0, sb.length() - 1) + this.lineSeparator;
    }

    private void addData(StringBuilder sb, Object data) {
        if (Objects.isNull(data)) {
            sb.append("\"\"");
        } else {
            sb.append("\"");
            sb.append(data);
            sb.append("\"");
        }
        sb.append(",");
    }

    private StringBuilder getFile(String code, String postfix, Map<String, Pair<String, StringBuilder>> csvFileMap) {
        Pair<String, StringBuilder> pair = csvFileMap.get(code);
        if (pair == null) {
            String fileName = "-" + code + "-" + postfix;
            StringBuilder sb = new StringBuilder();
            csvFileMap.put(code, (Pair<String, StringBuilder>)Pair.of((Object)fileName, (Object)sb));
            return sb;
        }
        return (StringBuilder)pair.getRight();
    }

    private void buildCellMapping(Map<String, JQReport> jqReportMap, DynamicObjectCollection sheetMappings, List<RpaIntegrationCell> cellMappingList, Map<Long, Map<Integer, String>> floatRowRangeMap, Map<Long, Map<String, Object>> reportDataMap) {
        HashMap cellMappingMap = new HashMap(cellMappingList.size());
        cellMappingList.forEach(data -> cellMappingMap.put(data.getSheetId(), data));
        for (DynamicObject sheetMapping : sheetMappings) {
            JSONObject jsonMap;
            JSONArray dataArr;
            Map<String, Object> reportData;
            Long sheetMappingId = sheetMapping.getLong("id");
            Long templateId = sheetMapping.getLong("template.id");
            if (!cellMappingMap.containsKey(sheetMappingId) || MapUtils.isEmpty(reportData = reportDataMap.get(templateId))) continue;
            HashMap<String, Object> fixDataMap = new HashMap<String, Object>(100);
            JQReport jqReport = jqReportMap.get(sheetMapping.getString("number").toLowerCase());
            if (jqReport == null) continue;
            JQTable fixTable = this.findFixTable(jqReport);
            if (fixTable != null) {
                fixTable.setFixDataMap(fixDataMap);
            }
            if ((dataArr = (jsonMap = JSONObject.parseObject((String)((RpaIntegrationCell)cellMappingMap.get(sheetMappingId)).getRefData())).getJSONArray("data")) == null) continue;
            JSONObject floatIndexObj = jsonMap.getJSONObject("floatIndexMap");
            LinkedHashMap<Integer, Integer> floatIncRowMap = new LinkedHashMap<Integer, Integer>(dataArr.size());
            for (Object data2 : dataArr) {
                String floatRowRange;
                Map<Integer, String> floatRowRangeList;
                JSONObject jsonObject;
                Integer floatIndex;
                CellAreaMapping cellAreaMapping = (CellAreaMapping)((JSONObject)data2).toJavaObject(CellAreaMapping.class);
                String mappingAreaKey = cellAreaMapping.getArea();
                int dataAreaIndex = Integer.parseInt(mappingAreaKey.split("_")[1]);
                if (mappingAreaKey.startsWith("g_")) {
                    for (Object obj : cellAreaMapping.getMappings()) {
                        CellMapping cellMapping = obj instanceof JSONObject ? (CellMapping)((JSONObject)obj).toJavaObject(CellMapping.class) : (CellMapping)obj;
                        String[] jqRowCol = cellMapping.getValue().replaceAll("[\\[\\]]", "").split(",");
                        String[] excelRowCol = cellMapping.getEbCell().split("#");
                        int excelRow = Integer.parseInt(excelRowCol[0]) + 1;
                        int realRow = this.calcFixAreaRealRow(excelRow, floatIncRowMap, dataAreaIndex);
                        String ebCell = realRow - 1 + "#" + ExcelUtils.int2pos((int)Integer.parseInt(excelRowCol[1]));
                        Object cellVal = reportData.get(ebCell);
                        if (!Objects.nonNull(cellVal)) continue;
                        fixDataMap.put(jqRowCol[1], cellVal);
                    }
                    continue;
                }
                String jqRowIndex = "";
                ArrayList<String> jqColList = new ArrayList<String>(20);
                ArrayList<String> ebColList = new ArrayList<String>(20);
                ArrayList dataList = new ArrayList(50);
                JQTable jqTable = null;
                for (Object obj : cellAreaMapping.getMappings()) {
                    CellMapping cellMapping = obj instanceof JSONObject ? (CellMapping)((JSONObject)obj).toJavaObject(CellMapping.class) : (CellMapping)obj;
                    String[] jqRowCol = cellMapping.getValue().replaceAll("[\\[\\]]", "").split(",");
                    jqRowIndex = jqRowCol[0];
                    jqColList.add(jqRowCol[1]);
                    if (jqTable == null && (jqTable = this.findFloatTable(jqRowCol[1], jqReport)) != null) {
                        jqTable.setFloatDataList(dataList);
                    }
                    String[] excelRowCol = cellMapping.getEbCell().split("#");
                    ebColList.add(ExcelUtils.int2pos((int)Integer.parseInt(excelRowCol[1])));
                }
                if (jqTable == null || !StringUtils.isNotBlank((String)jqRowIndex) || (floatIndex = (jsonObject = floatIndexObj.getJSONObject(mappingAreaKey)).getInteger("index")) == null || (floatRowRangeList = floatRowRangeMap.get(templateId)) == null || (floatRowRange = floatRowRangeList.get(floatIndex)) == null) continue;
                String[] split = floatRowRange.split("~");
                int rowStart = Integer.parseInt(split[0]) - 1;
                int rowEnd = Integer.parseInt(split[1]) - 1;
                for (int rowIndex = rowStart; rowIndex <= rowEnd; ++rowIndex) {
                    HashMap rowDataMap = new HashMap(50);
                    boolean empty = true;
                    for (int k = 0; k < jqColList.size(); ++k) {
                        String ebCell;
                        Object cellVal;
                        if (k >= ebColList.size() || !Objects.nonNull(cellVal = reportData.get(ebCell = rowIndex + "#" + (String)ebColList.get(k)))) continue;
                        rowDataMap.put(jqColList.get(k), cellVal);
                        empty = false;
                    }
                    if (empty) continue;
                    dataList.add(rowDataMap);
                }
                this.calcFloatAreaIncRow(floatIncRowMap, dataAreaIndex, jsonObject, floatRowRange);
            }
        }
    }

    private JQTable findFloatTable(String jqCell, JQReport jqReport) {
        Optional<JQTable> optional = jqReport.getTables().values().stream().filter(JQTable::isFloat).filter(table -> table.getFields().contains(jqCell)).findFirst();
        return optional.orElse(null);
    }

    private JQTable findFixTable(JQReport jqReport) {
        Optional<JQTable> optional = jqReport.getTables().values().stream().filter(table -> !table.isFloat()).findFirst();
        return optional.orElse(null);
    }

    public Boolean isFloat(String jqCell, JQReport jqReport) {
        Optional<JQTable> optional = jqReport.getTables().values().stream().filter(table -> table.getFields().contains(jqCell)).findFirst();
        return optional.isPresent() ? Boolean.valueOf(optional.get().isFloat()) : null;
    }

    private int calcFixAreaRealRow(int excelRow, Map<Integer, Integer> floatIncRowMap, int dataAreaIndex) {
        int realRow = excelRow;
        for (Map.Entry<Integer, Integer> entry : floatIncRowMap.entrySet()) {
            Integer floatDataAreaIndex = entry.getKey();
            if (dataAreaIndex <= floatDataAreaIndex) continue;
            realRow += entry.getValue() - 1;
        }
        return realRow;
    }

    private void calcFloatAreaIncRow(Map<Integer, Integer> floatIncRowMap, int dataAreaIndex, JSONObject floatInfo, String floatRowRange) {
        String[] split = floatRowRange.split("~");
        int floatDataRows = Integer.parseInt(split[1]) - Integer.parseInt(split[0]) + 1;
        String floatArea = floatInfo.getString("area");
        String[] floatAreaArr = floatArea.split(":");
        Point startPoint = ExcelUtils.pos2Point((String)floatAreaArr[0]);
        Point endPoint = ExcelUtils.pos2Point((String)floatAreaArr[1]);
        int floatTemplateRows = endPoint.y - startPoint.y + 1;
        int floatIncRows = 0;
        if (floatDataRows >= floatTemplateRows) {
            floatIncRows = floatDataRows - floatTemplateRows + 1;
        }
        floatIncRowMap.put(dataAreaIndex, floatIncRows);
    }

    private static class InnerClass {
        private static final JqCsvService instance = new JqCsvService();

        private InnerClass() {
        }
    }
}

