/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.formplugin.rpa.export;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.epm.eb.business.rpa.RpaConstants;
import kd.epm.eb.business.rpa.dao.RpaEntityRefDao;
import kd.epm.eb.business.rpa.dao.RpaIntegrationCellDao;
import kd.epm.eb.business.rpa.dao.RpaIntegrationSheetDao;
import kd.epm.eb.business.rpa.entity.RpaIntegrationCell;
import kd.epm.eb.business.rpa.model.CellAreaMapping;
import kd.epm.eb.business.rpa.model.CellMapping;
import kd.epm.eb.common.utils.ExcelUtils;
import kd.epm.eb.common.utils.Point;
import org.apache.commons.lang.StringUtils;

public class JqIniService {
    private static final Log log = LogFactory.getLog(JqIniService.class);
    private final String sp = System.getProperty("line.separator", "\n");

    public static JqIniService getInstance() {
        return InnerClass.instance;
    }

    private JqIniService() {
    }

    public String createINIFile(DynamicObject rpaScheme, long orgId, String fileName, String rootDirName, Map<Long, Map<Integer, String>> floatRowRangeMap) {
        DynamicObject entityRef = RpaEntityRefDao.getInstance().load(Long.valueOf(orgId), Long.valueOf(rpaScheme.getLong("rpaintegration.id")));
        return this.createINIFile(rootDirName, fileName, rpaScheme, entityRef, floatRowRangeMap);
    }

    private String createINIFile(String rootDirName, String fileName, DynamicObject rpaScheme, DynamicObject entityRef, Map<Long, Map<Integer, String>> floatRowRangeMap) {
        StringBuilder sb = new StringBuilder();
        DynamicObjectCollection templateList = (DynamicObjectCollection)rpaScheme.get("entrytemplate");
        Map<Long, DynamicObject> templateMap = templateList.stream().collect(Collectors.toMap(dy -> dy.getLong("template.id"), dy -> dy));
        DynamicObjectCollection sheetMappings = RpaIntegrationSheetDao.getInstance().query(Long.valueOf(rpaScheme.getLong("rpaintegration.id")), templateMap.keySet());
        ArrayList sheetMappingIds = new ArrayList(sheetMappings.size());
        sheetMappings.forEach(dyn -> sheetMappingIds.add(dyn.getLong("id")));
        List<RpaIntegrationCell> cellList = sheetMappingIds.stream().map(sheetId -> RpaIntegrationCellDao.getInstance().load(Long.valueOf(rpaScheme.getLong("rpaintegration.id")), sheetId)).collect(Collectors.toList());
        this.buildExportPath(sb, rpaScheme, rootDirName);
        this.buildFilePath(sb, fileName, entityRef, rpaScheme, rootDirName);
        this.buildSheetMapping(sb, sheetMappings);
        this.buildCellMapping(sb, sheetMappings, cellList, floatRowRangeMap);
        return sb.toString();
    }

    private void buildExportPath(StringBuilder sb, DynamicObject rpaScheme, String rootDirName) {
        sb.append("[Set]").append(this.sp);
        sb.append("Dir=");
        String exportPath = rpaScheme.getString("exportpath");
        sb.append(exportPath);
        if (!exportPath.endsWith("\\")) {
            sb.append("\\");
        }
        sb.append(rootDirName).append(this.sp);
    }

    private void buildFilePath(StringBuilder sb, String fileName, DynamicObject orgDyn, DynamicObject rpaScheme, String rootDirName) {
        sb.append(this.sp).append("[File]").append(this.sp);
        String fileNumber = orgDyn.getString("number") + orgDyn.getString("reporttype");
        String exportPath = rpaScheme.getString("exportpath");
        sb.append(fileNumber).append("=").append(orgDyn.getLocaleString("name").getLocaleValue()).append("&").append(exportPath);
        if (!exportPath.endsWith("\\")) {
            sb.append("\\");
        }
        String excelExtension = RpaConstants.FileType.XLSX.getValue().equals(rpaScheme.getString("filetype")) ? ".xlsx" : ".xls";
        sb.append(rootDirName).append("\\").append(fileName).append("\\").append(fileName).append(excelExtension).append(this.sp);
    }

    private void buildSheetMapping(StringBuilder sb, DynamicObjectCollection sheetMappings) {
        sb.append(this.sp).append("[Sheet]").append(this.sp);
        sheetMappings.forEach(dyn -> sb.append(dyn.getString("number")).append("=").append(dyn.getString("template.name")).append(this.sp));
    }

    private void buildCellMapping(StringBuilder sb, DynamicObjectCollection sheetMappings, List<RpaIntegrationCell> cellList, Map<Long, Map<Integer, String>> floatRowRangeMap) {
        sb.append(this.sp).append("[Nexus]").append(this.sp);
        HashMap cellMappingMap = new HashMap(cellList.size());
        cellList.forEach(data -> cellMappingMap.put(data.getSheetId(), data));
        for (DynamicObject sheetMapping : sheetMappings) {
            sb.append(sheetMapping.getString("number")).append("=");
            Long sheetMappingId = sheetMapping.getLong("id");
            Long templateId = sheetMapping.getLong("template.id");
            if (cellMappingMap.containsKey(sheetMappingId)) {
                JSONObject jsonMap = JSONObject.parseObject((String)((RpaIntegrationCell)cellMappingMap.get(sheetMappingId)).getRefData());
                JSONArray dataArr = jsonMap.getJSONArray("data");
                if (dataArr == null) continue;
                JSONObject floatIndexObj = jsonMap.getJSONObject("floatIndexMap");
                LinkedHashMap<Integer, Integer> floatIncRowMap = new LinkedHashMap<Integer, Integer>(dataArr.size());
                for (Object data2 : dataArr) {
                    String floatRowRange;
                    Map<Integer, String> floatRowRangeList;
                    JSONObject jsonObject;
                    Integer floatIndex;
                    CellAreaMapping cellAreaMapping = (CellAreaMapping)((JSONObject)data2).toJavaObject(CellAreaMapping.class);
                    String mappingAreaKey = cellAreaMapping.getArea();
                    int dataAreaIndex = Integer.parseInt(mappingAreaKey.split("_")[1]);
                    if (mappingAreaKey.startsWith("g_")) {
                        for (Object obj : cellAreaMapping.getMappings()) {
                            CellMapping cellMapping = obj instanceof JSONObject ? (CellMapping)((JSONObject)obj).toJavaObject(CellMapping.class) : (CellMapping)obj;
                            String[] jqRowCol = cellMapping.getValue().replaceAll("[\\[\\]]", "").split(",");
                            String jqIndex = "{" + jqRowCol[0] + "}{" + jqRowCol[1] + "}";
                            sb.append(jqIndex).append("=");
                            String[] excelRowCol = cellMapping.getEbCell().split("#");
                            int excelRow = Integer.parseInt(excelRowCol[0]) + 1;
                            int realRow = this.calcFixAreaRealRow(excelRow, floatIncRowMap, dataAreaIndex);
                            String excelIndex = "{" + realRow + "}{" + ExcelUtils.int2pos((int)Integer.parseInt(excelRowCol[1])) + "}";
                            sb.append(excelIndex).append(";");
                        }
                        continue;
                    }
                    String jqRowIndex = "";
                    ArrayList<String> jqColList = new ArrayList<String>(20);
                    ArrayList<String> excelColList = new ArrayList<String>(20);
                    for (Object obj : cellAreaMapping.getMappings()) {
                        CellMapping cellMapping = obj instanceof JSONObject ? (CellMapping)((JSONObject)obj).toJavaObject(CellMapping.class) : (CellMapping)obj;
                        String[] jqRowCol = cellMapping.getValue().replaceAll("[\\[\\]]", "").split(",");
                        jqRowIndex = jqRowCol[0];
                        jqColList.add(jqRowCol[1]);
                        String[] excelRowCol = cellMapping.getEbCell().split("#");
                        excelColList.add(ExcelUtils.int2pos((int)Integer.parseInt(excelRowCol[1])));
                    }
                    if (!StringUtils.isNotBlank((String)jqRowIndex) || (floatIndex = (jsonObject = floatIndexObj.getJSONObject(mappingAreaKey)).getInteger("index")) == null || (floatRowRangeList = floatRowRangeMap.get(templateId)) == null || (floatRowRange = floatRowRangeList.get(floatIndex)) == null) continue;
                    sb.append("{");
                    sb.append(jqRowIndex);
                    sb.append("}{");
                    sb.append(String.join((CharSequence)",", jqColList));
                    sb.append("}={");
                    sb.append(floatRowRange);
                    sb.append("}{");
                    sb.append(String.join((CharSequence)",", excelColList));
                    sb.append("};");
                    this.calcFloatAreaIncRow(floatIncRowMap, dataAreaIndex, jsonObject, floatRowRange);
                }
            }
            sb.append(this.sp);
        }
    }

    private int calcFixAreaRealRow(int excelRow, Map<Integer, Integer> floatIncRowMap, int dataAreaIndex) {
        int realRow = excelRow;
        for (Map.Entry<Integer, Integer> entry : floatIncRowMap.entrySet()) {
            Integer floatDataAreaIndex = entry.getKey();
            if (dataAreaIndex <= floatDataAreaIndex) continue;
            realRow += entry.getValue() - 1;
        }
        return realRow;
    }

    private void calcFloatAreaIncRow(Map<Integer, Integer> floatIncRowMap, int dataAreaIndex, JSONObject floatInfo, String floatRowRange) {
        String[] split = floatRowRange.split("~");
        int floatDataRows = Integer.parseInt(split[1]) - Integer.parseInt(split[0]) + 1;
        String floatArea = floatInfo.getString("area");
        String[] floatAreaArr = floatArea.split(":");
        Point startPoint = ExcelUtils.pos2Point((String)floatAreaArr[0]);
        Point endPoint = ExcelUtils.pos2Point((String)floatAreaArr[1]);
        int floatTemplateRows = endPoint.y - startPoint.y + 1;
        int floatIncRows = 0;
        if (floatDataRows >= floatTemplateRows) {
            floatIncRows = floatDataRows - floatTemplateRows + 1;
        }
        floatIncRowMap.put(dataAreaIndex, floatIncRows);
    }

    private static class InnerClass {
        private static final JqIniService instance = new JqIniService();

        private InnerClass() {
        }
    }
}

