/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.formplugin.rpa.export;

import com.alibaba.fastjson.JSONObject;
import com.google.common.base.Stopwatch;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import kd.bos.cache.CacheFactory;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.exception.KDBizException;
import kd.bos.form.IFormView;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.epm.eb.business.rpa.RpaConstants;
import kd.epm.eb.business.rpa.RpaXmlOperatorHelper;
import kd.epm.eb.business.rpa.dao.RpaEntityRefDao;
import kd.epm.eb.business.rpa.dao.RpaIntegrationCellDao;
import kd.epm.eb.business.rpa.dao.RpaIntegrationSheetDao;
import kd.epm.eb.business.rpa.dao.RpaSchemeDao;
import kd.epm.eb.business.rpa.entity.RpaScheme;
import kd.epm.eb.common.enums.JoinerTypeEnum;
import kd.epm.eb.common.utils.ExcelUtils;
import kd.epm.eb.common.utils.IDUtils;
import kd.epm.eb.formplugin.report.excel.BgmReportExportFileRulePlugin;
import kd.epm.eb.formplugin.rpa.export.EbReportDataService;
import kd.epm.eb.formplugin.rpa.export.JqCsvService;
import kd.epm.eb.formplugin.rpa.export.JqIniService;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.collections4.MapUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;
import org.apache.poi.ss.usermodel.Workbook;
import org.apache.poi.ss.usermodel.WorkbookFactory;
import org.apache.poi.xssf.streaming.SXSSFWorkbook;
import org.apache.poi.xssf.usermodel.XSSFWorkbook;

public class RpaExportService {
    private static final Log log = LogFactory.getLog(RpaExportService.class);
    private static final String LOG_PREFIX = "RPA-EXPORT";

    public static RpaExportService getInstance() {
        return InnerClass.instance;
    }

    private RpaExportService() {
    }

    public Pair<String, String> getExportUrl(long rpaSchemeId, IFormView formView) {
        DynamicObject rpaScheme = RpaSchemeDao.getInstance().loadToDyObj(Long.valueOf(rpaSchemeId));
        Map<Long, String> orgAndFileName = this.getOrgAndFileName(rpaScheme);
        Map<Long, Long> entityViewId = this.getEntityViewId(rpaScheme);
        if (RpaConstants.ExportType.ZIP.getValue().equals(rpaScheme.getString("rpaintegration.type"))) {
            return this.exportCsv(rpaScheme, orgAndFileName, entityViewId, formView);
        }
        return this.exportXls(rpaScheme, orgAndFileName, entityViewId, formView);
    }

    private Pair<String, String> exportXls(DynamicObject rpaScheme, Map<Long, String> orgAndFileName, Map<Long, Long> entityViewId, IFormView formView) {
        String downloadFileName = this.getDownloadFileName();
        HashMap<String, Workbook> workbookMap = new HashMap<String, Workbook>(orgAndFileName.size());
        HashMap<String, String> iniFileMap = new HashMap<String, String>(orgAndFileName.size());
        ArrayList<String> fileNames = new ArrayList<String>(orgAndFileName.size());
        orgAndFileName.forEach((entityId, fileName) -> {
            Stopwatch stepStopwatch = Stopwatch.createStarted();
            HashMap<Long, Map<Integer, String>> floatRowRangeMap = new HashMap<Long, Map<Integer, String>>(16);
            Workbook workbook = EbReportDataService.getInstance().createWorkbook(rpaScheme, (long)entityId, IDUtils.toLong(entityViewId.get(entityId)), (String)fileName, (Map<Long, Map<Integer, String>>)floatRowRangeMap);
            log.info("{} createWorkbook fileName:{} cost:{}ms", new Object[]{LOG_PREFIX, fileName, stepStopwatch.elapsed(TimeUnit.MILLISECONDS)});
            stepStopwatch.reset();
            if (workbook != null) {
                workbookMap.put((String)fileName, workbook);
                String iniContent = JqIniService.getInstance().createINIFile(rpaScheme, (long)entityId, (String)fileName, downloadFileName, (Map<Long, Map<Integer, String>>)floatRowRangeMap);
                log.info("{} createINIFile fileName:{} cost:{}ms", new Object[]{LOG_PREFIX, fileName, stepStopwatch.elapsed(TimeUnit.MILLISECONDS)});
                iniFileMap.put((String)fileName, iniContent);
                fileNames.add((String)fileName);
            }
        });
        formView.getPageCache().put("exportFileNames", JSONObject.toJSONString(fileNames));
        if (MapUtils.isEmpty(workbookMap)) {
            formView.showTipNotification(ResManager.loadKDString((String)"\u62a5\u8868\u6570\u636e\u4e3a\u7a7a\uff0c\u8bf7\u5148\u7f16\u5236\u62a5\u8868\u3002", (String)"RpaSchemeListPlugin_23", (String)"epm-eb-formplugin", (Object[])new Object[0]));
            return null;
        }
        Pair<String, String> zipFile = this.createXlsZipFile(rpaScheme.getLong("id"), workbookMap, iniFileMap, fileNames, downloadFileName);
        if (zipFile == null) {
            formView.showTipNotification(ResManager.loadKDString((String)"\u5bfc\u51fa\u7684\u5185\u5bb9\u4e3a\u7a7a\uff0c\u8bf7\u914d\u7f6e\u6a21\u677f\u548c\u7ec4\u7ec7\u3002", (String)"RpaSchemeListPlugin_21", (String)"epm-eb-formplugin", (Object[])new Object[0]));
        }
        return zipFile;
    }

    private Pair<String, String> exportCsv(DynamicObject rpaScheme, Map<Long, String> orgAndFileName, Map<Long, Long> entityViewId, IFormView formView) {
        long integrationId = rpaScheme.getLong("rpaintegration.id");
        DynamicObjectCollection templateList = (DynamicObjectCollection)rpaScheme.get("entrytemplate");
        Set templateIds = templateList.stream().map(dy -> dy.getLong("template.id")).collect(Collectors.toSet());
        DynamicObjectCollection sheetMappings = RpaIntegrationSheetDao.getInstance().query(Long.valueOf(integrationId), templateIds);
        List sheetMappingIds = sheetMappings.stream().map(dy -> dy.getLong("id")).collect(Collectors.toList());
        List cellMappingList = sheetMappingIds.stream().map(sheetId -> RpaIntegrationCellDao.getInstance().load(Long.valueOf(integrationId), sheetId)).collect(Collectors.toList());
        Map jqReportMap = RpaXmlOperatorHelper.getReport((Long)integrationId);
        LinkedHashMap<String, Pair<String, StringBuilder>> csvFileMap = new LinkedHashMap<String, Pair<String, StringBuilder>>(sheetMappings.size());
        String postfix = new SimpleDateFormat("yyyyMMddHHmmss").format(new Date());
        orgAndFileName.forEach((entityId, fileName) -> {
            Stopwatch stepStopwatch = Stopwatch.createStarted();
            DynamicObject entityRef = RpaEntityRefDao.getInstance().load(entityId, Long.valueOf(integrationId));
            HashMap<Long, Map<Integer, String>> floatRowRangeMap = new HashMap<Long, Map<Integer, String>>(16);
            Map<Long, Map<String, Object>> reportData = EbReportDataService.getInstance().getReportData(rpaScheme, (Long)entityId, IDUtils.toLong(entityViewId.get(entityId)), (String)fileName, (Map<Long, Map<Integer, String>>)floatRowRangeMap);
            if (MapUtils.isEmpty(reportData)) {
                return;
            }
            log.info("{} getReportData fileName:{} cost:{}ms", new Object[]{LOG_PREFIX, fileName, stepStopwatch.elapsed(TimeUnit.MILLISECONDS)});
            stepStopwatch.reset();
            JqCsvService.getInstance().createCsvFile(entityRef, sheetMappings, cellMappingList, jqReportMap, csvFileMap, reportData, postfix, floatRowRangeMap);
            log.info("{} createCsvFile fileName:{} cost:{}ms", new Object[]{LOG_PREFIX, fileName, stepStopwatch.elapsed(TimeUnit.MILLISECONDS)});
        });
        if (MapUtils.isEmpty(csvFileMap)) {
            formView.showTipNotification(ResManager.loadKDString((String)"\u62a5\u8868\u6570\u636e\u4e3a\u7a7a\uff0c\u8bf7\u5148\u7f16\u5236\u62a5\u8868\u3002", (String)"RpaSchemeListPlugin_23", (String)"epm-eb-formplugin", (Object[])new Object[0]));
            return null;
        }
        String xmlContent = RpaXmlOperatorHelper.createXML((Long)integrationId, csvFileMap);
        return this.createCsvZipFile(postfix, xmlContent, csvFileMap);
    }

    private String getDownloadFileName() {
        return new SimpleDateFormat("yyyyMMddHHmmssSSS").format(new Date());
    }

    public Map<Long, String> getOrgAndFileName(DynamicObject rpaScheme) {
        HashMap<Long, String> entityToFileNames = new HashMap<Long, String>(16);
        DynamicObjectCollection entityList = (DynamicObjectCollection)rpaScheme.get("entryentity");
        Map<String, Object> nameFormat = this.getNameFormat(rpaScheme.getString("filename"));
        List selectedFiled = (List)nameFormat.get("selectedFiled");
        String joiner = (String)nameFormat.get("joiner");
        String fixValue = (String)nameFormat.get("fixvalue");
        String periodNumber = rpaScheme.getString("period.number");
        String periodName = rpaScheme.getString("period.name");
        String datatypeNumber = rpaScheme.getString("datatype.number");
        String datatypeName = rpaScheme.getString("datatype.name");
        String versionNumber = rpaScheme.getString("version.number");
        String versionName = rpaScheme.getString("version.name");
        entityList.forEach(entity -> {
            String entityNumber = entity.getString("entity.number");
            String entityName = entity.getString("entity.name");
            ArrayList<String> names = new ArrayList<String>(10);
            for (BgmReportExportFileRulePlugin.FiledMember filedMember : selectedFiled) {
                String filedNumber = filedMember.getFiledNumber();
                String filedName = "fixvalue".equals(filedNumber) ? fixValue : ("entity.number".equals(filedNumber) ? entityNumber : ("entity.name".equals(filedNumber) ? entityName : ("period.number".equals(filedNumber) ? periodNumber : ("period.name".equals(filedNumber) ? periodName : ("datatype.number".equals(filedNumber) ? datatypeNumber : ("datatype.name".equals(filedNumber) ? datatypeName : ("version.number".equals(filedNumber) ? versionNumber : ("version.name".equals(filedNumber) ? versionName : ""))))))));
                names.add(filedName);
            }
            entityToFileNames.put(entity.getLong("entity.id"), StringUtils.join(names, (String)JoinerTypeEnum.getSignByIndex((String)joiner)));
        });
        return entityToFileNames;
    }

    private Map<Long, Long> getEntityViewId(DynamicObject rpaScheme) {
        DynamicObjectCollection entityList = (DynamicObjectCollection)rpaScheme.get("entryentity");
        List entityIds = entityList.stream().map(e -> e.getLong("entity.id")).collect(Collectors.toList());
        Long integration = rpaScheme.getLong("rpaintegration.id");
        return RpaEntityRefDao.getInstance().loadEntityView(integration, entityIds);
    }

    private Map<String, Object> getNameFormat(String nameFormatInfo) {
        try {
            return (Map)SerializationUtils.deSerializeFromBase64((String)nameFormatInfo);
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            HashMap<String, Object> rpaFile = new HashMap<String, Object>(4);
            List<BgmReportExportFileRulePlugin.FiledMember> fileFiled = Collections.singletonList(new BgmReportExportFileRulePlugin.FiledMember("entity.name", ResManager.loadKDString((String)"\u7ec4\u7ec7\u540d\u79f0", (String)"BgmReportExportFileRulePlugin_04", (String)"epm-eb-formplugin", (Object[])new Object[0]), true));
            rpaFile.put("selectedFiled", fileFiled);
            rpaFile.put("joiner", "2");
            rpaFile.put("fixvalue", "");
            rpaFile.put("namesource", "filename");
            return rpaFile;
        }
    }

    private Pair<String, String> createXlsZipFile(long rpaSchemeId, Map<String, Workbook> workbookMap, Map<String, String> iniFileMap, List<String> orgNameList, String downloadFileName) {
        if (CollectionUtils.isEmpty(orgNameList)) {
            return null;
        }
        Stopwatch totalStopwatch = Stopwatch.createStarted();
        RpaScheme rpaScheme = RpaSchemeDao.getInstance().loadToModel(Long.valueOf(rpaSchemeId));
        ByteArrayOutputStream outStream = new ByteArrayOutputStream();
        ZipOutputStream zipOut = new ZipOutputStream((OutputStream)outStream, StandardCharsets.UTF_8);
        try {
            for (String orgName : orgNameList) {
                Stopwatch stepStopwatch = Stopwatch.createStarted();
                Workbook xssfWb = workbookMap.get(orgName);
                if (xssfWb == null) continue;
                String excelExtension = RpaConstants.FileType.XLS.getValue().equals(rpaScheme.getFileType()) ? ".xls" : ".xlsx";
                String iniContent = iniFileMap.get(orgName);
                if (iniContent == null) continue;
                String excelName = orgName + File.separator + orgName + excelExtension;
                String iniFileName = orgName + File.separator + orgName + ".ini";
                try {
                    int readLen;
                    zipOut.putNextEntry(new ZipEntry(orgName + "/"));
                    zipOut.putNextEntry(new ZipEntry(excelName));
                    ByteArrayOutputStream excelOutput = new ByteArrayOutputStream();
                    if (RpaConstants.FileType.XLS.getValue().equals(rpaScheme.getFileType())) {
                        Workbook hssfWb = WorkbookFactory.create((boolean)false);
                        if (xssfWb instanceof XSSFWorkbook) {
                            ExcelUtils.xlsx2xls((XSSFWorkbook)((XSSFWorkbook)xssfWb), (HSSFWorkbook)((HSSFWorkbook)hssfWb));
                        }
                        if (xssfWb instanceof SXSSFWorkbook) {
                            ExcelUtils.xlsx2xls((SXSSFWorkbook)((SXSSFWorkbook)xssfWb), (HSSFWorkbook)((HSSFWorkbook)hssfWb));
                        }
                        log.info("{} xlsx2xls cost:{}ms", (Object)LOG_PREFIX, (Object)stepStopwatch.elapsed(TimeUnit.MILLISECONDS));
                        hssfWb.write((OutputStream)excelOutput);
                    } else {
                        xssfWb.write((OutputStream)excelOutput);
                    }
                    excelOutput.flush();
                    byte[] buf = new byte[1024];
                    ByteArrayInputStream excelInput = new ByteArrayInputStream(excelOutput.toByteArray());
                    while ((readLen = excelInput.read(buf)) != -1) {
                        zipOut.write(buf, 0, readLen);
                    }
                    zipOut.closeEntry();
                    excelInput.close();
                    zipOut.putNextEntry(new ZipEntry(iniFileName));
                    byte[] buf2 = new byte[1024];
                    ByteArrayInputStream iniInput = new ByteArrayInputStream(iniContent.getBytes(Charset.forName("GBK")));
                    while ((readLen = iniInput.read(buf2)) != -1) {
                        zipOut.write(buf2, 0, readLen);
                    }
                    zipOut.closeEntry();
                    iniInput.close();
                }
                catch (Exception e) {
                    log.error(e.getMessage(), (Throwable)e);
                }
            }
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            throw new KDBizException("system is error, please call manager." + e.getMessage());
        }
        finally {
            try {
                outStream.close();
                zipOut.close();
            }
            catch (IOException e) {
                log.error(e.getMessage(), (Throwable)e);
            }
        }
        ByteArrayInputStream inStream = new ByteArrayInputStream(outStream.toByteArray());
        String url = CacheFactory.getCommonCacheFactory().getTempFileCache().saveAsUrl(downloadFileName + ".zip", (InputStream)inStream, 10000);
        log.info("{} XlsZipFile cost:{}ms", (Object)LOG_PREFIX, (Object)totalStopwatch.elapsed(TimeUnit.MILLISECONDS));
        return Pair.of((Object)downloadFileName, (Object)url);
    }

    private Pair<String, String> createCsvZipFile(String postfix, String xmlContent, Map<String, Pair<String, StringBuilder>> csvFileMap) {
        Stopwatch totalStopwatch = Stopwatch.createStarted();
        ByteArrayOutputStream outStream = new ByteArrayOutputStream();
        ZipOutputStream zipOut = new ZipOutputStream((OutputStream)outStream, StandardCharsets.UTF_8);
        try {
            for (Map.Entry<String, Pair<String, StringBuilder>> entry : csvFileMap.entrySet()) {
                String fileName = (String)entry.getValue().getLeft();
                String csvFileName = fileName + ".csv";
                String csvContent = ((StringBuilder)entry.getValue().getRight()).toString();
                if (StringUtils.isEmpty((CharSequence)csvContent)) continue;
                try {
                    int readLen;
                    zipOut.putNextEntry(new ZipEntry(csvFileName));
                    byte[] buf2 = new byte[1024];
                    ByteArrayInputStream iniInput = new ByteArrayInputStream(csvContent.getBytes(Charset.forName("GBK")));
                    while ((readLen = iniInput.read(buf2)) != -1) {
                        zipOut.write(buf2, 0, readLen);
                    }
                    zipOut.closeEntry();
                    iniInput.close();
                }
                catch (Exception e) {
                    log.error(e.getMessage(), (Throwable)e);
                }
            }
            try {
                int readLen;
                String xmlFileName = "--" + postfix + ".xml";
                zipOut.putNextEntry(new ZipEntry(xmlFileName));
                byte[] buf2 = new byte[1024];
                ByteArrayInputStream iniInput = new ByteArrayInputStream(xmlContent.getBytes(Charset.forName("GBK")));
                while ((readLen = iniInput.read(buf2)) != -1) {
                    zipOut.write(buf2, 0, readLen);
                }
                zipOut.closeEntry();
                iniInput.close();
            }
            catch (Exception e) {
                log.error(e.getMessage(), (Throwable)e);
            }
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            throw new KDBizException("system is error, please call manager." + e.getMessage());
        }
        finally {
            try {
                outStream.close();
                zipOut.close();
            }
            catch (IOException e) {
                log.error(e.getMessage(), (Throwable)e);
            }
        }
        String downloadFileName = "--" + postfix;
        ByteArrayInputStream inStream = new ByteArrayInputStream(outStream.toByteArray());
        String url = CacheFactory.getCommonCacheFactory().getTempFileCache().saveAsUrl(downloadFileName + ".zip", (InputStream)inStream, 10000);
        log.info("{} CsvZipFile cost:{}ms", (Object)LOG_PREFIX, (Object)totalStopwatch.elapsed(TimeUnit.MILLISECONDS));
        return Pair.of((Object)downloadFileName, (Object)url);
    }

    private static class InnerClass {
        private static final RpaExportService instance = new RpaExportService();

        private InnerClass() {
        }
    }
}

