/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.formplugin.rpa.report;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.google.common.collect.Lists;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.form.IFormView;
import kd.epm.eb.business.rpa.CellMappingService;
import kd.epm.eb.business.rpa.RpaConstants;
import kd.epm.eb.business.rpa.dao.RpaIntegrationAttachmentDao;
import kd.epm.eb.business.rpa.dao.RpaIntegrationSheetDao;
import kd.epm.eb.business.rpa.model.CellMapping;
import kd.epm.eb.common.pageinteraction.CommandParam;
import kd.epm.eb.common.pageinteraction.SubPage;
import kd.epm.eb.common.utils.StringUtils;
import kd.epm.eb.ebSpread.domain.view.SpreadSelector;
import kd.epm.eb.spread.baseplugin.AbstractSpreadPlugin;
import kd.epm.eb.spread.command.rangedefined.CellArea;
import kd.epm.eb.spread.command.rangedefined.ContextMenuItemsEnum;
import kd.epm.eb.spread.command.style.AreasStyle;
import kd.epm.eb.spread.command.style.CellStyleInfo;
import kd.epm.eb.spread.command.style.HorizontalAlignEnum;
import kd.epm.eb.spread.command.style.VerticalAlignEnum;
import kd.epm.eb.spread.control.ISpreadContainer;
import kd.epm.eb.spread.template.spreadmanager.EbSpreadManager;
import kd.epm.eb.spread.template.spreadmanager.IEbSpreadManager;
import kd.epm.eb.spread.template.spreadmanager.book.EBook;
import kd.epm.eb.spread.template.spreadmanager.book.IEBook;
import kd.epm.eb.spread.template.spreadmanager.sheet.ECell;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.poi.hssf.usermodel.HSSFCell;
import org.apache.poi.hssf.usermodel.HSSFCellStyle;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;
import org.apache.poi.ss.usermodel.BorderStyle;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.CellBase;
import org.apache.poi.ss.usermodel.CellStyle;
import org.apache.poi.ss.usermodel.CellType;
import org.apache.poi.ss.usermodel.DateUtil;
import org.apache.poi.ss.usermodel.HorizontalAlignment;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.ss.usermodel.VerticalAlignment;
import org.apache.poi.ss.usermodel.Workbook;
import org.apache.poi.ss.util.CellRangeAddress;
import org.apache.poi.xssf.usermodel.XSSFCell;
import org.apache.poi.xssf.usermodel.XSSFCellStyle;
import org.apache.poi.xssf.usermodel.XSSFWorkbook;

public class JqReportTemplatePlugin
extends AbstractSpreadPlugin
implements SubPage {
    private static final String ROWSPAN = "rowSpan";
    private static final String COLSPAN = "colSpan";
    private static final String JQREPORT = "jqreport";
    private static final String JQSHEETNAME = "jqsheetname";
    private static final String JQREPORT_CELLLIGHT_1 = "jqreport_light_1";

    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        this.getspreadContainer().rebuildSpread(this.getInitSpreadJson());
        this.getspreadContainer().closeToolbar();
        this.setItemHide();
        this.buildSpreadJson();
    }

    private void setItemHide() {
        ArrayList hideItems = Lists.newArrayList((Object[])new ContextMenuItemsEnum[]{ContextMenuItemsEnum.CLEARCONTENTS});
        this.getspreadContainer().hideContextMenuItems((List)hideItems, null);
    }

    public void cellClick(SpreadSelector selector) {
        int i;
        super.cellClick(selector);
        ArrayList<Integer> selRows = new ArrayList<Integer>(16);
        ArrayList<Integer> selCols = new ArrayList<Integer>(16);
        for (i = selector.getStartRow(); i <= selector.getEndRow(); ++i) {
            selRows.add(i);
        }
        for (i = selector.getStartCol(); i <= selector.getEndCol(); ++i) {
            selCols.add(i);
        }
        this.setJqCacheData(selRows, selCols);
        this.lightCell(selRows, selCols);
    }

    public void dealMsg(CommandParam command) {
        if ("clearStyle".equals(command.getOperation())) {
            this.blackPreLight();
        } else if ("lightCell".equals(command.getOperation())) {
            this.handCellLight(command);
        }
    }

    private void handCellLight(CommandParam command) {
        this.blackPreLight();
        List param = command.getParam();
        List selRows = (List)param.get(0);
        List selCols = (List)param.get(1);
        ArrayList<Integer> mappingRows = new ArrayList<Integer>();
        ArrayList<Integer> mappingCols = new ArrayList<Integer>();
        JSONObject dataCacheMap = this.getEbDataCacheMap();
        ArrayList<CellArea> cellAreaList = new ArrayList<CellArea>(selRows.size() * selCols.size());
        for (Integer selRow : selRows) {
            for (Integer selCol : selCols) {
                String key = selRow + "#" + selCol;
                if (!dataCacheMap.containsKey((Object)key)) continue;
                CellMapping cellMapping = (CellMapping)dataCacheMap.getObject(key, CellMapping.class);
                String[] split = cellMapping.getJqCell().split("#");
                int mappingRow = Integer.parseInt(split[0]);
                mappingRows.add(mappingRow);
                int mappingCol = Integer.parseInt(split[1]);
                mappingCols.add(mappingCol);
                cellAreaList.add(new CellArea(mappingRow, mappingCol, 1, 1));
            }
        }
        if (CollectionUtils.isNotEmpty(cellAreaList)) {
            CellStyleInfo cellStyleInfo = new CellStyleInfo();
            cellStyleInfo.setBkc("#00ff00");
            AreasStyle areasStyle = new AreasStyle(cellAreaList, cellStyleInfo);
            this.getspreadContainer().setCellStyle(Collections.singletonList(areasStyle));
        }
        this.getPageCache().put("light_rows", JSONObject.toJSONString(mappingRows));
        this.getPageCache().put("light_cols", JSONObject.toJSONString(mappingCols));
    }

    private void lightCell(List<Integer> selRows, List<Integer> selCols) {
        this.blackPreLight();
        String first = this.getPageCache().get(JQREPORT_CELLLIGHT_1);
        if (first == null) {
            this.getPageCache().put(JQREPORT_CELLLIGHT_1, "");
            return;
        }
        CommandParam com = new CommandParam("eb_rpa_template_jq", "eb_rpa_cellmapping", "lightCell", new Object[]{selRows, selCols});
        this.sendMsg(this.getView(), com);
    }

    private void blackPreLight() {
        String lightRow = this.getPageCache().get("light_rows");
        String lightCol = this.getPageCache().get("light_cols");
        if (StringUtils.isEmpty((String)lightRow) || StringUtils.isEmpty((String)lightCol)) {
            return;
        }
        List mappingRows = JSON.parseArray((String)lightRow, Integer.class);
        List mappingCols = JSON.parseArray((String)lightCol, Integer.class);
        ArrayList<CellArea> cellAreaList = new ArrayList<CellArea>(mappingRows.size() * mappingCols.size());
        for (Integer mappingRow : mappingRows) {
            for (Integer mappingCol : mappingCols) {
                cellAreaList.add(new CellArea(mappingRow.intValue(), mappingCol.intValue(), 1, 1));
            }
        }
        if (CollectionUtils.isNotEmpty(cellAreaList)) {
            CellStyleInfo cellStyleInfo = new CellStyleInfo();
            cellStyleInfo.setBkc("#ffffff");
            AreasStyle areasStyle = new AreasStyle(cellAreaList, cellStyleInfo);
            this.getspreadContainer().setCellStyle(Collections.singletonList(areasStyle));
        }
    }

    private JSONObject getEbDataCacheMap() {
        IFormView parentView = this.getView().getParentView();
        String s = parentView.getPageCache().get("eb_cache_data");
        if (StringUtils.isEmpty((String)s)) {
            return new JSONObject();
        }
        return JSON.parseObject((String)s);
    }

    private void setJqCacheData(List<Integer> selRows, List<Integer> selCols) {
        String first = this.getPageCache().get("jq_report_cell_data_1");
        if (first == null) {
            this.getPageCache().put("jq_report_cell_data_1", "");
            return;
        }
        HashMap<String, List<Integer>> dataMap = new HashMap<String, List<Integer>>();
        dataMap.put("selRows", selRows);
        dataMap.put("selCols", selCols);
        this.getPageCache().put("jq_report_cell_data", JSONObject.toJSONString(dataMap));
    }

    private void buildSpreadJson() {
        DynamicObject sheetMapping = RpaIntegrationSheetDao.getInstance().loadSingle(this.getSheetMappingId());
        String sheetName = sheetMapping.getString("sheetname");
        long rpaIntegrationId = sheetMapping.getLong("rpainte.id");
        String url = RpaIntegrationAttachmentDao.getInstance().getExcelFileUrl(Long.valueOf(rpaIntegrationId));
        RpaConstants.FileType workbookType = CellMappingService.getWorkbookType((String)url);
        Workbook xwb = CellMappingService.getWorkbook((String)url, (RpaConstants.FileType)workbookType);
        int sheetCount = xwb.getNumberOfSheets();
        String innerSheetName = null;
        for (int i = 0; i < sheetCount && !sheetName.equals(innerSheetName = xwb.getSheetName(i)); ++i) {
            innerSheetName = null;
        }
        if (innerSheetName == null) {
            CommandParam com = new CommandParam("eb_rpa_template_jq", "eb_rpa_cellmapping", "hideBtn", new Object[0]);
            this.sendMsg(this.getView(), com);
            return;
        }
        this.getPageCache().put(JQSHEETNAME, innerSheetName);
        Object sheet = workbookType == RpaConstants.FileType.XLS ? ((HSSFWorkbook)xwb).getSheet(innerSheetName) : ((XSSFWorkbook)xwb).getSheet(innerSheetName);
        List mergedRegions = sheet.getMergedRegions();
        int totalRowNum = sheet.getLastRowNum();
        EbSpreadManager spreadManager = new EbSpreadManager();
        EBook ieBook = new EBook(new String[]{"Sheet1"});
        spreadManager.setEbook((IEBook)ieBook);
        ieBook.getSheet(0).setStyleCell(true);
        this.setEbSpreadManager((IEbSpreadManager)spreadManager);
        ISpreadContainer spreadContainer = this.getspreadContainer();
        ArrayList<CellArea> spanCells = new ArrayList<CellArea>(256);
        ArrayList<ECell> cellList = new ArrayList<ECell>(256);
        HashMap<Integer, List<Integer>> rowHeightMap = new HashMap<Integer, List<Integer>>(256);
        HashMap<Integer, List<Integer>> colWidthMap = new HashMap<Integer, List<Integer>>(256);
        ArrayList<AreasStyle> areasStyleList = new ArrayList<AreasStyle>(256);
        for (int i = 0; i <= totalRowNum; ++i) {
            this.getRowHeight((Sheet)sheet, i, rowHeightMap);
            Row row = sheet.getRow(i);
            if (row == null) continue;
            int lastCellNum = row.getLastCellNum();
            for (int j = 0; j <= lastCellNum; ++j) {
                CellBase cell;
                if (i == 0) {
                    this.getColWidth((Sheet)sheet, j, colWidthMap);
                }
                if ((cell = (CellBase)row.getCell(j)) == null) continue;
                JSONObject rowColSpan = this.getRowColSpan((Cell)cell, mergedRegions);
                if (rowColSpan != null) {
                    spanCells.add(new CellArea(i, j, rowColSpan.getInteger(ROWSPAN).intValue(), rowColSpan.getInteger(COLSPAN).intValue()));
                }
                CellStyleInfo cellStyleInfo = this.getCellStyle(cell);
                this.addCellStyle(i, j, cellStyleInfo, areasStyleList);
                CellType cellType = cell.getCellType();
                Object newValue = null;
                if (CellType.STRING.equals((Object)cellType)) {
                    newValue = cell.getStringCellValue();
                } else if (CellType.NUMERIC.equals((Object)cellType)) {
                    newValue = this.getNumericCellValue(cell);
                }
                cellList.add(new ECell(i, j, newValue));
                spreadManager.getEbook().getSheet(0).getECell(i, j).setValue(newValue);
            }
        }
        spreadContainer.setSpan(spanCells);
        spreadContainer.updateCellValue2(cellList);
        this.setRowHeight(rowHeightMap);
        this.setColWidth(colWidthMap);
        this.getspreadContainer().setCellStyle(areasStyleList);
        this.getspreadContainer().lockSheets((List)Lists.newArrayList((Object[])new String[]{spreadManager.getEbook().getSheet(0).getSheetName()}));
        this.cacheSpreadManager();
    }

    private void setColWidth(Map<Integer, List<Integer>> colWidthMap) {
        for (Map.Entry<Integer, List<Integer>> map : colWidthMap.entrySet()) {
            this.getspreadContainer().setColumnsWidth(map.getValue(), map.getKey().intValue());
        }
    }

    private void setRowHeight(Map<Integer, List<Integer>> rowHeight) {
        for (Map.Entry<Integer, List<Integer>> map : rowHeight.entrySet()) {
            this.getspreadContainer().setRowsHeight(map.getValue(), map.getKey().intValue());
        }
    }

    private Object getNumericCellValue(CellBase cell) {
        short format = cell.getCellStyle().getDataFormat();
        if (format == 14 || format == 31 || format == 57 || format == 58) {
            SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
            double value = cell.getNumericCellValue();
            Date date = DateUtil.getJavaDate((double)value);
            String cellValue = sdf.format(date);
            boolean iszh = "zh-CN".equals(RequestContext.get().getLang().getLangTag());
            if (format == 14) {
                return cellValue;
            }
            if (format == 31) {
                String[] split = cellValue.split("-");
                if (split.length >= 3) {
                    if (iszh) {
                        return String.format(ResManager.loadKDString((String)"%1$s\u5e74%2$s\u6708%3$s\u65e5", (String)"RpaIntegrationCellEditPlugin_16", (String)"epm-eb-formplugin", (Object[])new Object[0]), split[0], split[1], split[2]);
                    }
                    return cellValue;
                }
                return cell.getNumericCellValue();
            }
            if (format == 57) {
                String[] split = cellValue.split("-");
                if (split.length >= 2) {
                    if (iszh) {
                        return String.format(ResManager.loadKDString((String)"%1$s\u5e74%2$s\u6708", (String)"RpaIntegrationCellEditPlugin_15", (String)"epm-eb-formplugin", (Object[])new Object[0]), split[0], split[1]);
                    }
                    return cellValue;
                }
                return cell.getNumericCellValue();
            }
            String[] split = cellValue.split("-");
            if (split.length >= 3) {
                if (iszh) {
                    return String.format(ResManager.loadKDString((String)"%1$s\u6708%2$s\u65e5", (String)"RpaIntegrationCellEditPlugin_14", (String)"epm-eb-formplugin", (Object[])new Object[0]), split[1], split[2]);
                }
                return cellValue;
            }
            return cell.getNumericCellValue();
        }
        return cell.getNumericCellValue();
    }

    private void getColWidth(Sheet sheet, int j, Map<Integer, List<Integer>> colWidthMap) {
        int columnWidth = sheet.getColumnWidth(j);
        double colWidthD = (double)columnWidth / 35.0;
        colWidthMap.computeIfAbsent((int)colWidthD, k -> new ArrayList()).add(j);
    }

    private void getRowHeight(Sheet sheet, int i, Map<Integer, List<Integer>> rowHeightMap) {
        Row row = sheet.getRow(i);
        if (row == null) {
            return;
        }
        short height = row.getHeight();
        double heightReal = (double)height / 10.0 - 5.0;
        rowHeightMap.computeIfAbsent((int)heightReal, list -> new ArrayList()).add(i);
    }

    private void addCellStyle(int i, int j, CellStyleInfo cellStyleInfo, List<AreasStyle> areasStyleList) {
        CellArea cellArea = new CellArea(i, j, 1, 1);
        AreasStyle areasStyle = new AreasStyle((List)Lists.newArrayList((Object[])new CellArea[]{cellArea}), cellStyleInfo);
        areasStyleList.add(areasStyle);
    }

    private CellStyleInfo getCellStyle(CellBase cell) {
        CellStyleInfo cellStyleInfo = new CellStyleInfo();
        CellStyle cellStyle = cell.getCellStyle();
        HorizontalAlignment alignment = cellStyle.getAlignment();
        VerticalAlignment verticalAlignment = cellStyle.getVerticalAlignment();
        cellStyleInfo.setHa(HorizontalAlignEnum.find((int)(alignment.getCode() - 1)));
        cellStyleInfo.setVa(VerticalAlignEnum.find((int)verticalAlignment.ordinal()));
        BorderStyle borderBottom = cellStyle.getBorderBottom();
        BorderStyle borderLeft = cellStyle.getBorderLeft();
        BorderStyle borderTop = cellStyle.getBorderTop();
        BorderStyle borderRight = cellStyle.getBorderRight();
        if (!(BorderStyle.NONE.equals((Object)borderBottom) && BorderStyle.NONE.equals((Object)borderLeft) && BorderStyle.NONE.equals((Object)borderTop) && BorderStyle.NONE.equals((Object)borderRight))) {
            cellStyleInfo.setBlc((List)Lists.newArrayList((Object[])new String[]{"black"}));
            cellStyleInfo.setBls((List)Lists.newArrayList((Object[])new String[]{"thin"}));
        }
        String backgroundColor = null;
        int fontIndex = cellStyle.getFontIndexAsInt();
        if (cell instanceof HSSFCell) {
            HSSFCellStyle hsscellStyle = ((HSSFCell)cell).getCellStyle();
            backgroundColor = hsscellStyle.getFillBackgroundColorColor().getHexString();
            if (backgroundColor == null) {
                backgroundColor = hsscellStyle.getFillForegroundColorColor() == null ? null : hsscellStyle.getFillForegroundColorColor().getHexString();
            }
            fontIndex = fontIndex - 25 == 0 ? -1 : fontIndex - 25;
            cellStyleInfo.setF(fontIndex + "pt Arial");
        } else if (cell instanceof XSSFCell) {
            XSSFCellStyle xsscellStyle = ((XSSFCell)cell).getCellStyle();
            String string = backgroundColor = xsscellStyle.getFillBackgroundColorColor() == null ? null : xsscellStyle.getFillBackgroundColorColor().getARGBHex();
            if (backgroundColor == null) {
                backgroundColor = xsscellStyle.getFillForegroundColorColor() == null ? null : xsscellStyle.getFillForegroundColorColor().getARGBHex();
            }
            fontIndex = xsscellStyle.getFont().getFontHeight() / 20;
            cellStyleInfo.setF(fontIndex + "pt " + xsscellStyle.getFont().getFontName());
        }
        if (!"0:0:0".equals(backgroundColor) && backgroundColor != null && !"FFFFFFFF".equals(backgroundColor)) {
            cellStyleInfo.setBkc("#BFBFBF");
        }
        return cellStyleInfo;
    }

    private JSONObject getRowColSpan(Cell cell, List<CellRangeAddress> mergedRegions) {
        JSONObject rowColSpan = null;
        for (CellRangeAddress cellRangeAddress : mergedRegions) {
            if (!cellRangeAddress.isInRange(cell)) continue;
            rowColSpan = new JSONObject();
            rowColSpan.put(ROWSPAN, (Object)(cellRangeAddress.getLastRow() - cellRangeAddress.getFirstRow() + 1));
            rowColSpan.put(COLSPAN, (Object)(cellRangeAddress.getLastColumn() - cellRangeAddress.getFirstColumn() + 1));
            mergedRegions.remove(cellRangeAddress);
            return rowColSpan;
        }
        return rowColSpan;
    }

    private String getInitSpreadJson() {
        return "{\"version\":\"10.0.1\",\"sheetCount\":1,\"sheets\":{\"null\":{\"name\":\"null\",\"rowCount\":\"200\",\"columnCount\":\"100\",\"data\": {\"dataTable\": {}}}}}";
    }

    private Long getSheetMappingId() {
        return (Long)this.getView().getFormShowParameter().getCustomParam("sheetMappingId");
    }

    public String getSpreadKey() {
        return JQREPORT;
    }
}

