/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.formplugin.rpa.skill;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Lists;
import java.util.Date;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.ext.fi.fatvs.skilldata.ISkillRunnable;
import kd.bos.ext.fi.fatvs.skilldata.SkillRunContext;
import kd.bos.ext.fi.fatvs.skilldata.SkillRunResult;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.epm.eb.business.rpa.RpaConstants;
import kd.epm.eb.business.rpa.dao.RpaTaskLogDao;

public class RpaSkillAPI
implements ISkillRunnable {
    private static final Log log = LogFactory.getLog(RpaSkillAPI.class);

    public SkillRunResult pullData(SkillRunContext runContext) {
        log.info("RpaSkillAPI pullData skillId:{} skillNum:{} startTime:{} endTime:{}", new Object[]{runContext.getSkillId(), runContext.getSkillNum(), runContext.getStartTime(), runContext.getEndTime()});
        String skillNum = runContext.getSkillNum();
        Date startTime = runContext.getStartTime();
        Date endTime = runContext.getEndTime();
        DynamicObjectCollection dataList = RpaTaskLogDao.getInstance().queryByTime(startTime, endTime);
        int totalCount = dataList.size();
        long failCount = dataList.stream().filter(dyObj -> !"success".equals(dyObj.getString("status"))).count();
        int rpaRunTimes = 0;
        int rpaRunSuccessTimes = 0;
        int rpaRunEntityLength = 0;
        int rpaRunTemplateLength = 0;
        int manualRunTimes = 0;
        int manualRunSuccessTimes = 0;
        int manualRunEntityLength = 0;
        int manualRunTemplateLength = 0;
        for (DynamicObject dyObj2 : dataList) {
            if (RpaConstants.RpaLogType.RPA.name().equals(dyObj2.getString("tasktype"))) {
                ++rpaRunTimes;
                if ("success".equals(dyObj2.getString("status"))) {
                    ++rpaRunSuccessTimes;
                }
                rpaRunEntityLength += dyObj2.getString("entity").split(",").length;
                rpaRunTemplateLength += dyObj2.getString("template").split(",").length;
                continue;
            }
            ++manualRunTimes;
            if ("success".equals(dyObj2.getString("status"))) {
                ++manualRunSuccessTimes;
            }
            manualRunEntityLength += dyObj2.getString("entity").split(",").length;
            manualRunTemplateLength += dyObj2.getString("template").split(",").length;
        }
        SkillRunResult runResult = runContext.getSkillResult();
        if (runResult == null) {
            runResult = new SkillRunResult();
            runResult.setStartTime(startTime);
            runResult.setEndTime(endTime);
            runContext.setSkillResult(runResult);
        }
        runResult.setSkillNum(skillNum);
        runResult.setTotalCount(Integer.valueOf(totalCount));
        runResult.setFailCount(Integer.valueOf((int)failCount));
        ImmutableMap map1 = ImmutableMap.of((Object)"number", (Object)"RPARunTimes", (Object)"name", (Object)ResManager.loadKDString((String)"RPA\u6267\u884c\u6b21\u6570", (String)"RpaSkillAPI_1", (String)"epm-eb-formplugin", (Object[])new Object[0]), (Object)"value", (Object)String.valueOf(rpaRunTimes), (Object)"valueType", (Object)"0");
        ImmutableMap map2 = ImmutableMap.of((Object)"number", (Object)"RPARunSuccessTimes", (Object)"name", (Object)ResManager.loadKDString((String)"RPA\u6267\u884c\u6210\u529f\u6b21\u6570", (String)"RpaSkillAPI_2", (String)"epm-eb-formplugin", (Object[])new Object[0]), (Object)"value", (Object)String.valueOf(rpaRunSuccessTimes), (Object)"valueType", (Object)"0");
        ImmutableMap map3 = ImmutableMap.of((Object)"number", (Object)"RPAProcessDataSize", (Object)"name", (Object)ResManager.loadKDString((String)"RPA\u6210\u529f\u5904\u7406\u7684\u7ec4\u7ec7\u548c\u6a21\u677f\u6570", (String)"RpaSkillAPI_3", (String)"epm-eb-formplugin", (Object[])new Object[0]), (Object)"value", (Object)(rpaRunEntityLength + ", " + rpaRunTemplateLength), (Object)"valueType", (Object)"2");
        ImmutableMap map4 = ImmutableMap.of((Object)"number", (Object)"ManualRunTimes", (Object)"name", (Object)ResManager.loadKDString((String)"\u624b\u52a8\u5bfc\u51fa\u6b21\u6570", (String)"RpaSkillAPI_4", (String)"epm-eb-formplugin", (Object[])new Object[0]), (Object)"value", (Object)String.valueOf(manualRunTimes), (Object)"valueType", (Object)"0");
        ImmutableMap map5 = ImmutableMap.of((Object)"number", (Object)"ManualRunSuccessTimes", (Object)"name", (Object)ResManager.loadKDString((String)"\u624b\u52a8\u5bfc\u51fa\u6210\u529f\u6b21\u6570", (String)"RpaSkillAPI_5", (String)"epm-eb-formplugin", (Object[])new Object[0]), (Object)"value", (Object)String.valueOf(manualRunSuccessTimes), (Object)"valueType", (Object)"0");
        ImmutableMap map6 = ImmutableMap.of((Object)"number", (Object)"ManualProcessDataSize", (Object)"name", (Object)ResManager.loadKDString((String)"\u624b\u52a8\u5bfc\u51fa\u6210\u529f\u5904\u7406\u7684\u7ec4\u7ec7\u548c\u6a21\u677f\u6570", (String)"RpaSkillAPI_6", (String)"epm-eb-formplugin", (Object[])new Object[0]), (Object)"value", (Object)(manualRunEntityLength + ", " + manualRunTemplateLength), (Object)"valueType", (Object)"2");
        runResult.setData((List)Lists.newArrayList((Object[])new Map[]{map1, map2, map3, map4, map5, map6}));
        return runResult;
    }
}

