/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.formplugin.rulebatch;

import java.util.EventObject;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.resource.promptenum.MultiLangEnumBridge;
import kd.bos.form.CloseCallBack;
import kd.bos.form.IFormView;
import kd.bos.form.IPageCache;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.HyperLinkClickArgs;
import kd.bos.form.events.SetFilterEvent;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.BillList;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.DispatchServiceHelper;
import kd.epm.eb.common.enums.memberQuote.MemberQuoteResourceEnum;
import kd.epm.eb.common.pojo.DynamicAlertPojo;
import kd.epm.eb.common.pojo.ReturnDataToParentPojo;
import kd.epm.eb.common.pojo.StylePojo;
import kd.epm.eb.common.utils.CommonServiceHelper;
import kd.epm.eb.common.utils.base.CacheUtils;
import kd.epm.eb.common.utils.base.DynamicAlertUtils;
import kd.epm.eb.common.utils.base.JsonUtils;
import kd.epm.eb.common.utils.base.LambdaUtils;
import kd.epm.eb.common.utils.base.LockUtils;
import kd.epm.eb.common.utils.base.ObjUtils;
import kd.epm.eb.formplugin.AbstractListPlugin;
import kd.epm.eb.formplugin.rulebatch.OpenRuleBatchPojo;
import kd.epm.eb.formplugin.rulebatch.OpenRuleBatchPojoTypeEnum;
import kd.epm.eb.formplugin.rulebatch.RuleBatchListPageContextPojo;
import kd.epm.eb.formplugin.rulebatch.RuleBatchUtils;
import kd.epm.eb.formplugin.rulemanage.RuleManagePlugin3;
import org.apache.commons.lang3.StringUtils;

public class RuleBatchListPlugin
extends AbstractListPlugin {
    private static final Log log = LogFactory.getLog(RuleBatchListPlugin.class);
    public static final String btn_refresh = "btn_refresh";
    public static final String btn_add = "btn_add";
    public static final String btn_copy = "btn_copy";
    public static final String btn_delete = "btn_delete";

    @Override
    public void registerListener(EventObject e) {
        try {
            super.registerListener(e);
            this.addItemClickListeners(new String[]{"toolbarap"});
        }
        catch (Exception ex) {
            CommonServiceHelper.dealException((AbstractFormPlugin)this, (String)"RuleBatchListPlugin#registerListener", (Throwable)ex);
        }
    }

    public void setFilter(SetFilterEvent e) {
        try {
            RuleBatchListPageContextPojo ruleBatchListPageContextPojo = (RuleBatchListPageContextPojo)CacheUtils.get((IPageCache)this.getPageCache(), RuleBatchListPageContextPojo.class);
            e.getQFilters().add(new QFilter("model", "=", (Object)ruleBatchListPageContextPojo.getModelIdLong()));
            e.setOrderBy("id desc");
        }
        catch (Exception ex) {
            CommonServiceHelper.dealException((AbstractFormPlugin)this, (String)"RuleBatchListPlugin#setFilter", (Throwable)ex);
        }
    }

    public void afterCreateNewData(EventObject e) {
        try {
            Map customParamMap = this.getView().getFormShowParameter().getCustomParams();
            String jsonString = ObjUtils.getString(customParamMap.get(RuleBatchListPageContextPojo.class.getName()));
            RuleBatchListPageContextPojo ruleBatchListPageContextPojo = (RuleBatchListPageContextPojo)JsonUtils.readValue((String)jsonString, RuleBatchListPageContextPojo.class);
            CacheUtils.put((IPageCache)this.getPageCache(), (Object)ruleBatchListPageContextPojo);
            RuleBatchListPlugin.refreshBillList(this.getView(), ruleBatchListPageContextPojo);
        }
        catch (Exception ex) {
            CommonServiceHelper.dealException((AbstractFormPlugin)this, (String)"RuleBatchListPlugin#afterCreateNewData", (Throwable)ex);
        }
    }

    @Override
    public void billListHyperLinkClick(HyperLinkClickArgs args) {
        try {
            args.setCancel(Boolean.TRUE.booleanValue());
            BillList billList = (BillList)this.getView().getControl("billlistap");
            RuleBatchUtils.open(this.getView(), new OpenRuleBatchPojo().setRuleBatchIdLong(ObjUtils.getLong((Object)billList.getFocusRowPkId())).setTypeString(OpenRuleBatchPojoTypeEnum.OPEN.name()));
        }
        catch (Exception e) {
            CommonServiceHelper.dealException((AbstractFormPlugin)this, (String)"RuleBatchListPlugin#billListHyperLinkClick", (Throwable)e);
        }
    }

    public void itemClick(ItemClickEvent evt) {
        try {
            String itemKeyString;
            super.itemClick(evt);
            switch (itemKeyString = evt.getItemKey()) {
                case "btn_refresh": {
                    LambdaUtils.run(() -> {
                        RuleBatchListPageContextPojo ruleBatchListPageContextPojo = (RuleBatchListPageContextPojo)CacheUtils.get((IPageCache)this.getPageCache(), RuleBatchListPageContextPojo.class);
                        RuleBatchListPlugin.refreshBillList(this.getView(), ruleBatchListPageContextPojo);
                    });
                    break;
                }
                case "btn_add": {
                    LambdaUtils.run(() -> {
                        RuleBatchListPageContextPojo ruleBatchListPageContextPojo = (RuleBatchListPageContextPojo)CacheUtils.get((IPageCache)this.getPageCache(), RuleBatchListPageContextPojo.class);
                        RuleBatchUtils.open(this.getView(), new OpenRuleBatchPojo().setModelIdLong(ruleBatchListPageContextPojo.getModelIdLong()).setTypeString(OpenRuleBatchPojoTypeEnum.NEW.name()));
                    });
                    break;
                }
                case "btn_copy": {
                    LambdaUtils.run(() -> {
                        BillList billList = (BillList)this.getView().getControl("billlistap");
                        if (billList.getSelectedRows() == null || billList.getSelectedRows().size() != 1) {
                            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u4e00\u6761", (String)"RuleBatchListPlugin_3", (String)"epm-eb-formplugin", (Object[])new Object[0]));
                            return;
                        }
                        List ruleBatchIdLongList = billList.getSelectedRows().stream().map(item -> ObjUtils.getLong((Object)item.getPrimaryKeyValue())).collect(Collectors.toList());
                        RuleBatchUtils.open(this.getView(), new OpenRuleBatchPojo().setRuleBatchIdLong((Long)ruleBatchIdLongList.get(0)).setTypeString(OpenRuleBatchPojoTypeEnum.COPY.name()));
                    });
                    break;
                }
                case "btn_delete": {
                    LambdaUtils.run(() -> {
                        BillList billList = (BillList)this.getView().getControl("billlistap");
                        if (billList.getSelectedRows() == null || billList.getSelectedRows().size() == 0) {
                            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u81f3\u5c11\u4e00\u6761", (String)"RuleBatchListPlugin_2", (String)"epm-eb-formplugin", (Object[])new Object[0]));
                            return;
                        }
                        RuleBatchListPageContextPojo ruleBatchListPageContextPojo = (RuleBatchListPageContextPojo)CacheUtils.get((IPageCache)this.getPageCache(), RuleBatchListPageContextPojo.class);
                        RuleBatchUtils.deleteRuleBatchCheck(ruleBatchListPageContextPojo.getModelIdLong(), billList.getSelectedRows().stream().map(item -> ObjUtils.getLong((Object)item.getPrimaryKeyValue())).collect(Collectors.toList()));
                        RuleBatchListPlugin.openDynamicAlert(this.getView(), new CloseCallBack((IFormPlugin)this, btn_delete));
                    });
                    break;
                }
            }
        }
        catch (Exception e) {
            CommonServiceHelper.dealException((AbstractFormPlugin)this, (String)"RuleBatchListPlugin#itemClick", (Throwable)e);
        }
    }

    public static void openDynamicAlert(IFormView formView, CloseCallBack closeCallBack) {
        DynamicAlertPojo dynamicAlertPojo = new DynamicAlertPojo();
        dynamicAlertPojo.setStylePojo(new StylePojo().setHeightString("350px").setWidthString("460px"));
        dynamicAlertPojo.setPageTitleString(ResManager.loadKDString((String)"\u64cd\u4f5c\u786e\u8ba4", (String)"RuleBatchListPlugin_4", (String)"epm-eb-formplugin", (Object[])new Object[0]));
        dynamicAlertPojo.setTitleString(ResManager.loadKDString((String)"\u786e\u5b9a\u662f\u5426\u5220\u9664\uff1f", (String)"RuleBatchListPlugin_5", (String)"epm-eb-formplugin", (Object[])new Object[0]));
        DynamicAlertUtils.openDynamicAlert((IFormView)formView, (DynamicAlertPojo)dynamicAlertPojo, (CloseCallBack)closeCallBack);
    }

    @Override
    public void closedCallBack(ClosedCallBackEvent closedCallBackEvent) {
        try {
            String actionIdString;
            super.closedCallBack(closedCallBackEvent);
            switch (actionIdString = closedCallBackEvent.getActionId()) {
                case "btn_delete": {
                    LambdaUtils.run(() -> {
                        String jsonString = ObjUtils.getString((Object)closedCallBackEvent.getReturnData());
                        if (StringUtils.isBlank((CharSequence)jsonString)) {
                            return;
                        }
                        ReturnDataToParentPojo returnDataToParentPojo = (ReturnDataToParentPojo)JsonUtils.readValue((String)jsonString, ReturnDataToParentPojo.class);
                        if (returnDataToParentPojo == null || StringUtils.isBlank((CharSequence)returnDataToParentPojo.getTypeString()) || !"btnok".equals(returnDataToParentPojo.getTypeString())) {
                            return;
                        }
                        RuleBatchListPageContextPojo ruleBatchListPageContextPojo = (RuleBatchListPageContextPojo)CacheUtils.get((IPageCache)this.getPageCache(), RuleBatchListPageContextPojo.class);
                        LockUtils.lock((String)(RuleManagePlugin3.class.getName() + ruleBatchListPageContextPojo.getModelIdLong()), () -> {
                            BillList billList = (BillList)this.getView().getControl("billlistap");
                            List<Long> ruleBatchIdLongList = billList.getSelectedRows().stream().map(item -> ObjUtils.getLong((Object)item.getPrimaryKeyValue())).collect(Collectors.toList());
                            RuleBatchUtils.deleteRuleBatchCheck(ruleBatchListPageContextPojo.getModelIdLong(), ruleBatchIdLongList);
                            RuleBatchUtils.delete(ruleBatchListPageContextPojo.getModelIdLong(), ruleBatchIdLongList);
                            DispatchServiceHelper.invokeBizService((String)"epm", (String)"eb", (String)"MemberQuoteService", (String)"delete", (Object[])new Object[]{MemberQuoteResourceEnum.RULE_BATCH.getType(), ruleBatchIdLongList});
                            RuleBatchListPlugin.refreshBillList(this.getView(), ruleBatchListPageContextPojo);
                            this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u5220\u9664\u6210\u529f", (String)"RuleBatchListPlugin_1", (String)"epm-eb-formplugin", (Object[])new Object[0]));
                            this.writeLog("delete", new MultiLangEnumBridge("\u5220\u9664", "AnalyzeListSet_1", "epm-eb-formplugin"), new MultiLangEnumBridge("\u5220\u9664\u6210\u529f", "DiffAnalyzeSchemeListPlugin_0", "epm-eb-formplugin"));
                        });
                    });
                    break;
                }
            }
        }
        catch (Exception e) {
            CommonServiceHelper.dealException((AbstractFormPlugin)this, (String)"RuleBatchListPlugin#closedCallBack", (Throwable)e);
        }
    }

    public static void refreshBillList(IFormView formView, RuleBatchListPageContextPojo ruleBatchListPageContextPojo) {
        BillList billList = (BillList)formView.getControl("billlistap");
        billList.setFilter(new QFilter("model", "=", (Object)ruleBatchListPageContextPojo.getModelIdLong()));
        billList.setClearSelection(true);
        billList.refresh();
    }
}

