/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.formplugin.ruleexec;

import com.fasterxml.jackson.core.type.TypeReference;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.EventObject;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.stream.Collectors;
import kd.bos.cache.CacheFactory;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.resource.promptenum.MultiLangEnumBridge;
import kd.bos.entity.datamodel.ListSelectedRow;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.entity.filter.FilterParameter;
import kd.bos.exception.KDBizException;
import kd.bos.form.CloseCallBack;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.FormConfig;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IClientViewProxy;
import kd.bos.form.IFormView;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.ShowType;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.form.events.BillListHyperLinkClickEvent;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.HyperLinkClickArgs;
import kd.bos.form.events.HyperLinkClickEvent;
import kd.bos.form.events.HyperLinkClickListener;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.events.SetFilterEvent;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.lang.Lang;
import kd.bos.list.BillList;
import kd.bos.list.ListFilterParameter;
import kd.bos.list.ListShowParameter;
import kd.bos.orm.query.QFilter;
import kd.bos.schedule.api.JobInfo;
import kd.bos.schedule.api.JobType;
import kd.bos.schedule.form.JobForm;
import kd.bos.schedule.form.JobFormInfo;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.DeleteServiceHelper;
import kd.epm.eb.common.enums.status.ReportRuleExecStatusEnum;
import kd.epm.eb.common.thread.EpmThreadPools;
import kd.epm.eb.common.utils.CommonServiceHelper;
import kd.epm.eb.common.utils.IDUtils;
import kd.epm.eb.common.utils.UserUtils;
import kd.epm.eb.common.utils.base.JsonUtils;
import kd.epm.eb.formplugin.AbstractListPlugin;
import kd.epm.eb.formplugin.ruleexec.command.RuleExecCommand;
import kd.epm.eb.formplugin.ruleexec.consumer.JobRuleExecConsumer;
import kd.epm.eb.formplugin.ruleexec.controller.ReportRuleExecController;
import kd.epm.eb.formplugin.ruleexec.entity.RuleCase;
import kd.epm.eb.formplugin.ruleexec.enums.CaseUpdateStatusEnum;
import kd.epm.eb.formplugin.ruleexec.service.RuleCaseService;
import kd.epm.eb.formplugin.ruleexec.service.RuleExecLogService;
import kd.epm.eb.spread.report.ruleexec.entity.request.ReportRuleExecRequest;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;

public class ReportRuleCaseExecPlugin
extends AbstractListPlugin {
    @Override
    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addItemClickListeners(new String[]{"toolbarap"});
        BillList billlistap = (BillList)this.getView().getControl("billlistap");
        billlistap.addHyperClickListener((HyperLinkClickListener)this);
    }

    public void afterCreateNewData(EventObject e) {
        try {
            Long modelId;
            Long reportProcessId = this.getReportProcessId();
            BillList billlistap = (BillList)this.getView().getControl("billlistap");
            FilterParameter fp = new FilterParameter();
            if (IDUtils.isNotEmptyLong((Long)reportProcessId).booleanValue()) {
                QFilter filter = new QFilter("reportprocess", "=", (Object)reportProcessId);
                fp.setFilter(filter);
            }
            if (IDUtils.isNotEmptyLong((Long)(modelId = this.getModelId())).booleanValue()) {
                QFilter filter = new QFilter("model", "=", (Object)modelId);
                fp.setFilter(filter);
            }
            billlistap.setFilterParameter(fp);
        }
        catch (Exception ex) {
            CommonServiceHelper.dealException((AbstractFormPlugin)this, (String)"ReportRuleCaseExecPlugin#afterCreateNewData", (Throwable)ex);
        }
    }

    public void setFilter(SetFilterEvent e) {
        try {
            Long modelId;
            super.setFilter(e);
            Long reportProcessId = this.getReportProcessId();
            if (IDUtils.isNotEmptyLong((Long)reportProcessId).booleanValue()) {
                e.getCustomQFilters().add(new QFilter("reportprocess", "=", (Object)reportProcessId));
            }
            if (IDUtils.isNotEmptyLong((Long)(modelId = this.getModelId())).booleanValue()) {
                e.getCustomQFilters().add(new QFilter("model", "=", (Object)modelId));
            }
        }
        catch (Exception ex) {
            CommonServiceHelper.dealException((AbstractFormPlugin)this, (String)"ReportRuleCaseExecPlugin#setFilter", (Throwable)ex);
        }
    }

    public void itemClick(ItemClickEvent evt) {
        try {
            String itemKey;
            super.itemClick(evt);
            switch (itemKey = evt.getItemKey()) {
                case "execute": {
                    ReportRuleExecRequest reportRuleExecRequest = new ReportRuleExecRequest();
                    reportRuleExecRequest.setModelId(this.getModelId());
                    reportRuleExecRequest.setBizModelId(this.getBizModelId());
                    reportRuleExecRequest.setReportProcessId(this.getReportProcessId());
                    reportRuleExecRequest.setEntityId(this.getEntityId());
                    reportRuleExecRequest.setTemplate(this.getTemplate());
                    reportRuleExecRequest.setExecMemberMap(this.getAllMembers());
                    reportRuleExecRequest.setViewMap(this.getViewMap());
                    Map<String, String> result = ReportRuleExecController.getInstance().execRuleCase(reportRuleExecRequest, this.getView(), new CloseCallBack());
                    if ("failed".equals(result.get("status"))) {
                        this.getView().showErrorNotification(result.get("msg"));
                        break;
                    }
                    JobInfo jobInfo = this.createJobInfo(result.get("logid"));
                    JobFormInfo jobFormInfo = this.createJobFormInfo(jobInfo);
                    JobForm.dispatch((JobFormInfo)jobFormInfo, (IFormView)this.getView());
                    break;
                }
                case "cancel": {
                    BillList billlistap = (BillList)this.getView().getControl("billlistap");
                    ListSelectedRowCollection selectedRows = billlistap.getSelectedRows();
                    if (CollectionUtils.isEmpty((Collection)selectedRows)) {
                        this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u8981\u64cd\u4f5c\u7684\u6267\u884c\u8bb0\u5f55\u3002", (String)"RuleCase_0", (String)"epm-eb-formplugin", (Object[])new Object[0]));
                        return;
                    }
                    Object[] primaryKeyValues = selectedRows.getPrimaryKeyValues();
                    Set<Long> collect = Arrays.stream(primaryKeyValues).map(v -> (Long)v).collect(Collectors.toSet());
                    RuleExecLogService.getInstance().cancelTaskLogs(collect);
                    this.writeLog("cancel", new MultiLangEnumBridge("\u53d6\u6d88\u6267\u884c", "ExecuteRuleServiceImpl_12", "epm-eb-formplugin"), new MultiLangEnumBridge("\u53d6\u6d88\u6267\u884c\u6210\u529f", "ExecuteRecordPlugin_2", "epm-eb-formplugin"));
                    this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u53d6\u6d88\u6210\u529f\u3002", (String)"DecomposeTaskPlugin_14", (String)"epm-eb-formplugin", (Object[])new Object[0]));
                    billlistap = (BillList)this.getView().getControl("billlistap");
                    billlistap.refresh();
                    break;
                }
                case "btn_continue": {
                    BillList billList = (BillList)this.getControl("billlistap");
                    Object[] billListPk = billList.getSelectedRows().getPrimaryKeyValues();
                    if (billListPk == null || billListPk.length != 1) {
                        this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u4e00\u6761\u8bb0\u5f55\u3002", (String)"BgAvailBalanceListPlugin_3", (String)"epm-eb-formplugin", (Object[])new Object[0]));
                        return;
                    }
                    DynamicObject logDoj = BusinessDataServiceHelper.loadSingle((Object)billListPk[0], (DynamicObjectType)billList.getEntityType());
                    String caseNumber = logDoj.getString("case");
                    caseNumber = StringUtils.substringBefore((String)caseNumber, (String)"-");
                    QFilter caseFilter = new QFilter("model", "=", (Object)this.getModelId());
                    caseFilter.and("number", "=", (Object)caseNumber);
                    DynamicObject caseOne = QueryServiceHelper.queryOne((String)"eb_ruleexeccase", (String)"id", (QFilter[])caseFilter.toArray());
                    if (caseOne == null) {
                        this.getView().showTipNotification(ResManager.loadKDString((String)"\u89c4\u5219\u65b9\u6848\u4e0d\u5b58\u5728\u3002", (String)"bizRuleGroupListPlugin_44", (String)"epm-eb-formplugin", (Object[])new Object[0]));
                        return;
                    }
                    DynamicObject caseDoj = BusinessDataServiceHelper.loadSingle((Object)caseOne.getLong("id"), (String)"eb_ruleexeccase");
                    CaseUpdateStatusEnum updatestatus = CaseUpdateStatusEnum.getStatusByCode(caseDoj.getString("updatestatus"));
                    if (CaseUpdateStatusEnum.STAGING == updatestatus || CaseUpdateStatusEnum.UPDATE_ING == updatestatus || CaseUpdateStatusEnum.UPDATE_FAIL == updatestatus) {
                        this.getView().showTipNotification(ResManager.loadKDString((String)"\u60a8\u9009\u62e9\u7684\u884c\u4e2d\u6709\u6682\u5b58/\u66f4\u65b0\u4e2d/\u66f4\u65b0\u5931\u8d25\u72b6\u6001\u7684\u65b9\u6848\uff0c\u8bf7\u68c0\u67e5\u3002", (String)"bizRuleGroupListPlugin_42", (String)"epm-eb-formplugin", (Object[])new Object[0]));
                        return;
                    }
                    if (CaseUpdateStatusEnum.UPDATE_WAIT == updatestatus) {
                        this.getView().showConfirm(ResManager.loadKDString((String)"\u60a8\u9009\u62e9\u7684\u884c\u4e2d\u6709\u5f85\u66f4\u65b0\u72b6\u6001\u7684\u65b9\u6848\uff0c\u8bf7\u786e\u8ba4\u662f\u5426\u81ea\u52a8\u66f4\u65b0\u3002", (String)"DataReleaseSchemeEditPlugin_22", (String)"epm-eb-formplugin", (Object[])new Object[0]), MessageBoxOptions.YesNo, new ConfirmCallBackListener("barExec", (IFormPlugin)this));
                        return;
                    }
                    Long logId = RuleExecLogService.getInstance().createJonLog(this.getModelId(), caseDoj.getString("number") + "-" + caseDoj.getString("name"));
                    try {
                        DynamicObject _doj = RuleCaseService.getInstance().updateCaseEntity(caseDoj);
                        RuleExecCommand ruleExecCommand = new RuleExecCommand();
                        ruleExecCommand.setRuleCase(RuleCase.of(_doj));
                        ruleExecCommand.setTaskLogId(logId);
                        ruleExecCommand.setContinueLogId(logDoj.getLong("id"));
                        JobRuleExecConsumer ruleExecConsumer = new JobRuleExecConsumer(ruleExecCommand);
                        EpmThreadPools.ruleCaseExecConsumerThreadPool.submit((Runnable)ruleExecConsumer);
                        this.writeLog("executeRule", new MultiLangEnumBridge("\u6267\u884c\u89c4\u5219\u65b9\u6848", "BizRuleGroupListPlugin2_54", "epm-eb-formplugin"), new MultiLangEnumBridge("\u6267\u884c\u89c4\u5219\u65b9\u6848[%1$s\u3001%2$s]\u6210\u529f\u3002", "BizRuleGroupListPlugin2_59", "epm-eb-formplugin"), new String[]{caseDoj.getString("number"), caseDoj.getString("name")});
                    }
                    catch (Exception e) {
                        this.getView().showTipNotification(ResManager.loadResFormat((String)"\u4efb\u52a1%1\u63d0\u4ea4\u5931\u8d25\uff0c\u8bf7\u7a0d\u540e\u91cd\u8bd5\u3002", (String)"", (String)caseDoj.getString("number"), (Object[])new Object[0]));
                        RuleExecLogService.getInstance().updateExecStatus(logId, null, ReportRuleExecStatusEnum.EXEC_FAIL.getCode(), e.getMessage());
                        this.writeLog("executeScheme", new MultiLangEnumBridge("\u6267\u884c\u89c4\u5219\u65b9\u6848", "BizRuleGroupListPlugin2_54", "epm-eb-formplugin"), new MultiLangEnumBridge("\u6267\u884c\u89c4\u5219\u65b9\u6848[%1$s\u3001%2$s]\u5931\u8d25\u3002", "BizRuleGroupListPlugin2_60", "epm-eb-formplugin"), new String[]{caseDoj.getString("number"), caseDoj.getString("name")});
                    }
                    JobInfo jobInfo = this.createJobInfo(logId + "");
                    JobFormInfo jobFormInfo = this.createJobFormInfo(jobInfo);
                    JobForm.dispatch((JobFormInfo)jobFormInfo, (IFormView)this.getView());
                    break;
                }
                case "download": {
                    DynamicObject[] load;
                    BillList billlist = (BillList)this.getControl("billlistap");
                    ListSelectedRowCollection selectedRows = billlist.getSelectedRows();
                    if (selectedRows == null || selectedRows.size() < 1) {
                        this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u4e00\u884c\u6570\u636e\u3002", (String)"ExecuteRecordPlugin_0", (String)"epm-eb-formplugin", (Object[])new Object[0]));
                        return;
                    }
                    Object[] primaryKeyValues = selectedRows.getPrimaryKeyValues();
                    for (DynamicObject dynamicObject : load = BusinessDataServiceHelper.load((Object[])primaryKeyValues, (DynamicObjectType)billlist.getEntityType())) {
                        this.downloadLog(dynamicObject);
                    }
                    break;
                }
                case "delete": {
                    BillList billlistap = (BillList)this.getView().getControl("billlistap");
                    ListSelectedRowCollection selectedRows = billlistap.getSelectedRows();
                    if (CollectionUtils.isEmpty((Collection)selectedRows)) {
                        this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u8981\u64cd\u4f5c\u7684\u6267\u884c\u8bb0\u5f55\u3002", (String)"RuleCase_0", (String)"epm-eb-formplugin", (Object[])new Object[0]));
                        break;
                    }
                    Object[] primaryKeyValues = selectedRows.getPrimaryKeyValues();
                    DynamicObjectCollection dojColl = QueryServiceHelper.query((String)"eb_ruleexeccaselog", (String)"status", (QFilter[])new QFilter("id", "in", (Object)primaryKeyValues).toArray());
                    for (DynamicObject doj : dojColl) {
                        String status = doj.getString("status");
                        if (!ReportRuleExecStatusEnum.EXEC_ING.getCode().equals(status) && !ReportRuleExecStatusEnum.QUEUE.getCode().equals(status) && !ReportRuleExecStatusEnum.EXEC_CANCEL_ING.getCode().equals(status)) continue;
                        throw new KDBizException(ResManager.loadKDString((String)"\u4e0d\u5141\u8bb8\u5220\u9664\u6b63\u5728\u6267\u884c\u6216\u6392\u961f\u4e2d\u7684\u7684\u6267\u884c\u8bb0\u5f55\u3002", (String)"RuleCase_1", (String)"epm-eb-formplugin", (Object[])new Object[0]));
                    }
                    this.getView().showConfirm(ResManager.loadKDString((String)"\u786e\u8ba4\u5220\u9664\u6570\u636e\uff1f", (String)"RpaEntityRefListPlugin_4", (String)"epm-eb-formplugin", (Object[])new Object[0]), MessageBoxOptions.OKCancel, new ConfirmCallBackListener("delete", (IFormPlugin)this));
                    break;
                }
                case "refresh": {
                    BillList billlistap = (BillList)this.getView().getControl("billlistap");
                    billlistap.refresh();
                }
            }
        }
        catch (Exception e) {
            CommonServiceHelper.dealException((AbstractFormPlugin)this, (String)"ReportRuleCaseExecPlugin#itemClick", (Throwable)e);
        }
    }

    private void downloadLog(DynamicObject doj) {
        QFilter qFilter;
        DynamicObjectCollection dojColl;
        long id = doj.getLong("id");
        String traceid = doj.getString("traceid");
        if (StringUtils.isEmpty((CharSequence)traceid)) {
            traceid = "notraceid";
        }
        if ((dojColl = QueryServiceHelper.query((String)"eb_rulecaselogdetaill", (String)"detaillog", (QFilter[])(qFilter = new QFilter("mainlog", "=", (Object)id)).toArray())).isEmpty()) {
            this.getView().showTipNotification(ResManager.loadResFormat((String)"[%1]\u65e0\u660e\u7ec6\u89c4\u5219\u3002", (String)"RuleCase_2", (String)"epm-eb-formplugin", (Object[])new Object[]{traceid}));
            return;
        }
        StringBuilder sb = new StringBuilder();
        for (DynamicObject childDoj : dojColl) {
            sb.append(childDoj.getString("detaillog")).append("\r\n");
        }
        String fileUrl = this.createFileUrl(sb.toString(), traceid);
        this.getClientViewProxy().addAction("download", (Object)fileUrl);
        this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u4e0b\u8f7d\u6210\u529f\u3002", (String)"RuleCase_3", (String)"epm-eb-formplugin", (Object[])new Object[0]));
    }

    private IClientViewProxy getClientViewProxy() {
        return (IClientViewProxy)this.getView().getService(IClientViewProxy.class);
    }

    private String createFileUrl(String log, String fileName) {
        ByteArrayOutputStream outStream = null;
        ByteArrayInputStream inStream = null;
        try {
            outStream = new ByteArrayOutputStream();
            outStream.write(log.getBytes());
            outStream.flush();
            inStream = new ByteArrayInputStream(outStream.toByteArray());
        }
        catch (Throwable ex) {
            throw new KDBizException(ex.getMessage());
        }
        return CacheFactory.getCommonCacheFactory().getTempFileCache().saveAsUrl(fileName + ".txt", (InputStream)inStream, 10000);
    }

    private JobFormInfo createJobFormInfo(JobInfo jobInfo) {
        JobFormInfo jobFormInfo = new JobFormInfo(jobInfo);
        jobFormInfo.setJobInfo(jobInfo);
        String caption = ResManager.loadKDString((String)"\u89c4\u5219\u6267\u884c", (String)"RuleCase_4", (String)"epm-eb-formplugin", (Object[])new Object[0]);
        jobFormInfo.setCaption(caption);
        jobFormInfo.setCanBackground(true);
        jobFormInfo.setTimeout(3600);
        jobFormInfo.setParentPageId(this.getView().getFormShowParameter().getPageId());
        jobFormInfo.setRootPageId(this.getView().getFormShowParameter().getRootPageId());
        jobFormInfo.setCloseCallBack(new CloseCallBack((IFormPlugin)this, "jobClose"));
        return jobFormInfo;
    }

    private JobInfo createJobInfo(String logId) {
        JobInfo jobInfo = new JobInfo();
        jobInfo.setRunByLang(Lang.get());
        jobInfo.setTaskClassname("kd.epm.eb.formplugin.ruleexec.task.ReportExecRuleTask");
        String jobName = ResManager.loadKDString((String)"\u7b49\u5f85\u6267\u884c\u4e1a\u52a1\u89c4\u5219", (String)"RuleCase_5", (String)"epm-eb-formplugin", (Object[])new Object[0]);
        jobInfo.setName(jobName);
        jobInfo.setId(UUID.randomUUID().toString());
        jobInfo.setCanStop(Boolean.valueOf(true));
        jobInfo.setFailNotify(true);
        jobInfo.setTimeout(3600);
        jobInfo.setOverTime(true);
        jobInfo.setExecuteTime(3600);
        jobInfo.setJobType(JobType.REALTIME);
        jobInfo.setRunByUserId(UserUtils.getUserId().longValue());
        jobInfo.setAppId(this.getView().getFormShowParameter().getServiceAppId());
        jobInfo.setFailNotify(true);
        jobInfo.setSuccessNotify(true);
        HashMap<String, String> customParams = new HashMap<String, String>(16);
        customParams.put("pageId", this.getView().getPageId());
        customParams.put("appId", this.getView().getFormShowParameter().getServiceAppId());
        FormConfig formConfig = this.getView().getFormShowParameter().getFormConfig();
        customParams.put("formConfig", formConfig.getEntityTypeId());
        customParams.put("parentPageId", this.getView().getFormShowParameter().getPageId());
        customParams.put("rootPageId", this.getView().getFormShowParameter().getRootPageId());
        customParams.put("logId", logId);
        jobInfo.setParams(customParams);
        return jobInfo;
    }

    public void confirmCallBack(MessageBoxClosedEvent event) {
        try {
            super.confirmCallBack(event);
            MessageBoxResult result = event.getResult();
            if (MessageBoxResult.Cancel == result) {
                return;
            }
            String callBackId = event.getCallBackId();
            if ("delete".equals(callBackId)) {
                BillList billlistap = (BillList)this.getView().getControl("billlistap");
                ListSelectedRowCollection selectedRows = billlistap.getSelectedRows();
                String entryEntity = billlistap.getEntryEntity();
                QFilter qFilter = new QFilter("id", "in", (Object)selectedRows.getPrimaryKeyValues());
                DeleteServiceHelper.delete((String)entryEntity, (QFilter[])qFilter.toArray());
                QFilter qFilter2 = new QFilter("mainlog", "in", (Object)selectedRows.getPrimaryKeyValues());
                DeleteServiceHelper.delete((String)"eb_rulecaselogdetaill", (QFilter[])qFilter2.toArray());
                this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u5220\u9664\u6210\u529f\u3002", (String)"RuleCase_6", (String)"epm-eb-formplugin", (Object[])new Object[0]));
                this.writeLog("delete", new MultiLangEnumBridge("\u5220\u9664", "QingAnalysisDsListPlugin_20", "epm-eb-formplugin"), new MultiLangEnumBridge("\u5220\u9664\u6210\u529f\u3002", "QingAnalysisDsListPlugin_6", "epm-eb-formplugin"));
                billlistap.refresh();
            }
        }
        catch (Exception e) {
            CommonServiceHelper.dealException((AbstractFormPlugin)this, (String)"ReportRuleCaseExecPlugin#confirmCallBack", (Throwable)e);
        }
    }

    @Override
    public void closedCallBack(ClosedCallBackEvent event) {
        try {
            super.closedCallBack(event);
            String actionId = event.getActionId();
            if ("jobClose".equals(actionId)) {
                BillList billlistap = (BillList)this.getView().getControl("billlistap");
                billlistap.refresh();
            }
        }
        catch (Exception e) {
            CommonServiceHelper.dealException((AbstractFormPlugin)this, (String)"ReportRuleCaseExecPlugin#closedCallBack", (Throwable)e);
        }
    }

    @Override
    public void hyperLinkClick(HyperLinkClickEvent hyperLinkClickEvent) {
    }

    @Override
    public void billListHyperLinkClick(HyperLinkClickArgs args) {
        try {
            args.setCancel(true);
            ListSelectedRow currentRow = ((BillListHyperLinkClickEvent)args.getHyperLinkClickEvent()).getCurrentRow();
            ListShowParameter formShowParameter = new ListShowParameter();
            formShowParameter.setFormId("bos_list");
            formShowParameter.setBillFormId("eb_rulecaselogdetaill");
            formShowParameter.setParentPageId(this.getView().getPageId());
            QFilter qFilter = new QFilter("mainlog", "=", currentRow.getPrimaryKeyValue());
            formShowParameter.setListFilterParameter(new ListFilterParameter(Collections.singletonList(qFilter), "execseq"));
            formShowParameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
            formShowParameter.setCaption(ResManager.loadKDString((String)"\u89c4\u5219\u65b9\u6848\u6267\u884c\u65e5\u5fd7\u660e\u7ec6\u5217\u8868", (String)"RuleCase_7", (String)"epm-eb-formplugin", (Object[])new Object[0]));
            this.getView().showForm((FormShowParameter)formShowParameter);
        }
        catch (Exception e) {
            CommonServiceHelper.dealException((AbstractFormPlugin)this, (String)"ReportRuleCaseExecPlugin#billListHyperLinkClick", (Throwable)e);
        }
    }

    private Long getReportProcessId() {
        return (Long)this.getFormCustomParam("reportProcessId");
    }

    @Override
    public Long getModelId() {
        return (Long)this.getFormCustomParam("modelId");
    }

    public Long getBizModelId() {
        return (Long)this.getFormCustomParam("bizModelId");
    }

    public String getTemplate() {
        return (String)this.getFormCustomParam("template");
    }

    public Long getEntityId() {
        return (Long)this.getFormCustomParam("entityId");
    }

    public Map<String, Set<String>> getAllMembers() {
        String allMembers = (String)this.getFormCustomParam("allMembers");
        if (StringUtils.isEmpty((CharSequence)allMembers)) {
            return new HashMap<String, Set<String>>(0);
        }
        return (Map)JsonUtils.readValue((String)allMembers, (TypeReference)new TypeReference<Map<String, Set<String>>>(){});
    }

    public Map<String, Long> getViewMap() {
        String viewMapStr = (String)this.getFormCustomParam("viewMap");
        if (StringUtils.isEmpty((CharSequence)viewMapStr)) {
            return new HashMap<String, Long>(0);
        }
        return (Map)JsonUtils.readValue((String)viewMapStr, (TypeReference)new TypeReference<Map<String, Long>>(){});
    }
}

