/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.formplugin.ruleexec;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.bill.OperationStatus;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.ShowType;
import kd.epm.eb.common.cache.IModelCacheHelper;
import kd.epm.eb.common.cache.ModelCacheContext;
import kd.epm.eb.common.cache.impl.Member;
import kd.epm.eb.common.enums.SysDimensionEnum;
import kd.epm.eb.common.model.Dimension;
import kd.epm.eb.common.pojo.EdgePojo;
import kd.epm.eb.common.pojo.ElementPojo;
import kd.epm.eb.common.pojo.MethodPojo;
import kd.epm.eb.common.pojo.StylePojo;
import kd.epm.eb.common.rule.edit.FormulaMembPojo;
import kd.epm.eb.common.rule.edit.FormulaPojo;
import kd.epm.eb.common.rule.edit.RuleManageRowPojo;
import kd.epm.eb.common.rule.edit.RuleRangMemberPojo;
import kd.epm.eb.common.rule.edit.RuleRangePojo;
import kd.epm.eb.common.rule.relation.graph.RelationGraphDataPojo;
import kd.epm.eb.common.rule.relation.graph.RelationGraphLinkPojo;
import kd.epm.eb.common.rule.relation.graph.RelationGraphModelPojo;
import kd.epm.eb.common.rule.relation.graph.RelationGraphNodePojo;
import kd.epm.eb.common.rule.relation.graph.data.RelationGraphNodeDataAreaPojo;
import kd.epm.eb.common.rule.relation.graph.data.RelationGraphNodeDataCellPojo;
import kd.epm.eb.common.rule.relation.graph.data.RelationGraphNodeDataPojo;
import kd.epm.eb.common.rule.relation.graph.data.RelationGraphNodeDataRowPojo;
import kd.epm.eb.common.rule.relation.pojo.RelationGraphDataTrackingItemPojo;
import kd.epm.eb.common.rule.relation.pojo.RelationGraphDataTrackingTypeEnum;
import kd.epm.eb.common.rule.relation.pojo.RelationGraphInteractionTypeEnum;
import kd.epm.eb.common.rule.relation.pojo.RelationGraphTypeEnum;
import kd.epm.eb.common.utils.DatasetServiceHelper;
import kd.epm.eb.common.utils.base.ElementUtils;
import kd.epm.eb.common.utils.base.JsonUtils;
import kd.epm.eb.common.utils.base.LambdaUtils;
import kd.epm.eb.common.utils.base.MapPlusUtils;
import kd.epm.eb.common.utils.base.ObjUtils;
import kd.epm.eb.common.utils.base.StrUtils;
import kd.epm.eb.formplugin.rulemanage.RelationGraphUtils;
import kd.epm.eb.formplugin.rulemanage.action.RuleTextJsAction;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;

public class RuleExecGraphUtils {
    public static void openRelationGraph(IFormView currentFormView, RelationGraphModelPojo relationGraphModelPojo) {
        RuleExecGraphUtils.openRelationGraph(currentFormView, relationGraphModelPojo, null);
    }

    public static void openRelationGraph(IFormView currentFormView, RelationGraphModelPojo relationGraphModelPojo, Boolean skipCheckAndReorganizeBoolean) {
        if (currentFormView == null || relationGraphModelPojo == null) {
            return;
        }
        FormShowParameter formShowParameter = new FormShowParameter();
        formShowParameter.setFormId("eb_rule_graph");
        formShowParameter.setParentPageId(currentFormView.getPageId());
        formShowParameter.setStatus(OperationStatus.ADDNEW);
        formShowParameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
        if (!Boolean.TRUE.equals(skipCheckAndReorganizeBoolean)) {
            RelationGraphUtils.checkAndReorganize(relationGraphModelPojo);
        }
        formShowParameter.setCustomParam(RelationGraphModelPojo.class.getName(), (Object)JsonUtils.getJsonString((Object)relationGraphModelPojo));
        String titleString = relationGraphModelPojo.getTitleString();
        if (StringUtils.isNotBlank((CharSequence)titleString)) {
            formShowParameter.setCaption(titleString);
        }
        currentFormView.showForm(formShowParameter);
    }

    public static RelationGraphDataPojo getRelationGraphDataPojo(Set<Long> graphRuleIdLongSet, List<EdgePojo> graphEdgePojoList) {
        RelationGraphDataPojo relationGraphDataPojo = new RelationGraphDataPojo();
        ArrayList<RelationGraphNodePojo> ruleGraphNodePojoList = new ArrayList<RelationGraphNodePojo>(graphRuleIdLongSet.size());
        relationGraphDataPojo.setRelationGraphNodePojoList(ruleGraphNodePojoList);
        for (Long graphRuleIdLong : graphRuleIdLongSet) {
            String nodeString = ObjUtils.getString((Object)graphRuleIdLong);
            RelationGraphNodePojo relationGraphNodeVoPojo = new RelationGraphNodePojo();
            relationGraphNodeVoPojo.setIdString(nodeString);
            relationGraphNodeVoPojo.setTextString(nodeString);
            ruleGraphNodePojoList.add(relationGraphNodeVoPojo);
        }
        if (CollectionUtils.isEmpty(graphEdgePojoList)) {
            return relationGraphDataPojo;
        }
        ArrayList<RelationGraphLinkPojo> relationGraphLinkPojoList = new ArrayList<RelationGraphLinkPojo>(graphEdgePojoList.size());
        relationGraphDataPojo.setRelationGraphLinkPojoList(relationGraphLinkPojoList);
        for (EdgePojo edgePojo : graphEdgePojoList) {
            RelationGraphLinkPojo relationGraphLinkPojo = new RelationGraphLinkPojo();
            relationGraphLinkPojo.setFromString(edgePojo.getFromString());
            relationGraphLinkPojo.setToString(edgePojo.getToString());
            relationGraphLinkPojoList.add(relationGraphLinkPojo);
        }
        return relationGraphDataPojo;
    }

    public static String getInfoHtmlString(RuleManageRowPojo ruleManageRowPojo, String formulaPojoKeyString) {
        List<List<String>> rowList = RuleExecGraphUtils.getRowList(ruleManageRowPojo, formulaPojoKeyString);
        if (CollectionUtils.isEmpty(rowList)) {
            return "empty";
        }
        LinkedList<String> headerStringList = new LinkedList<String>();
        headerStringList.add(ResManager.loadKDString((String)"\u7ef4\u5ea6\u540d\u79f0", (String)"RuleCase_23", (String)"epm-eb-formplugin", (Object[])new Object[0]));
        headerStringList.add(ResManager.loadKDString((String)"\u7ef4\u5ea6\u6210\u5458", (String)"RuleCase_24", (String)"epm-eb-formplugin", (Object[])new Object[0]));
        headerStringList.add(ResManager.loadKDString((String)"\u7ef4\u5ea6\u7f16\u7801", (String)"RuleCase_25", (String)"epm-eb-formplugin", (Object[])new Object[0]));
        rowList.add(0, headerStringList);
        ElementPojo tableElementPojo = ElementUtils.create((String)"table").setElementPojoList(new LinkedList());
        tableElementPojo.setStylePojo(new StylePojo().setBorderColorString("#F4F4F4").setTextAlignString("center").setWordBreakString("break-all").setWidthString("100%"));
        ElementPojo tbodyElementPojo = ElementUtils.create((String)"tbody").setElementPojoList(new LinkedList());
        tableElementPojo.setElementPojoList((List)Lists.newArrayList((Object[])new ElementPojo[]{tbodyElementPojo}));
        tableElementPojo.setAttributeMap(MapPlusUtils.getStringMap((String[])new String[]{"border", "1", "cellspacing", "0", "cellpadding", "0"}));
        int rowListSizeInt = rowList.size();
        for (int i = 0; i < rowListSizeInt; ++i) {
            List<String> stringList = rowList.get(i);
            ElementPojo trElementPojo = ElementUtils.create((String)"tr").setElementPojoList(new LinkedList());
            StylePojo stylePojo = new StylePojo().setHeightString("32px");
            trElementPojo.setStylePojo(stylePojo);
            if (i == 0) {
                stylePojo.setBackgroundColorString("#F4F4F4");
            }
            tbodyElementPojo.getElementPojoList().add(trElementPojo);
            int stringListSizeInt = stringList.size();
            for (int j = 0; j < stringListSizeInt; ++j) {
                String string = stringList.get(j);
                if (string == null) {
                    string = "";
                }
                ElementPojo tdElementPojo = ElementUtils.create((String)"td");
                ElementPojo elementPojo = ElementUtils.createDivElementPojo().setValueString(string);
                if (j == 0) {
                    elementPojo.setStylePojo(new StylePojo().setMinWidthString("30px"));
                }
                tdElementPojo.setElementPojoList((List)Lists.newArrayList((Object[])new ElementPojo[]{elementPojo}));
                trElementPojo.getElementPojoList().add(tdElementPojo);
            }
        }
        ElementPojo rootElementPojo = ElementUtils.createDivElementPojo();
        rootElementPojo.setStylePojo(new StylePojo().setPaddingLeftString("10px"));
        ElementPojo titleElementPojo = ElementUtils.createDivElementPojo();
        titleElementPojo.setValueString(ResManager.loadKDString((String)"\u6210\u5458\u8303\u56f4", (String)"RuleCase_26", (String)"epm-eb-formplugin", (Object[])new Object[0]));
        titleElementPojo.setStylePojo(new StylePojo().setHeightString("30px").setLineHeightString("30px").setFontSizeString("15px").setFontWeightString("600"));
        rootElementPojo.setElementPojoList((List)Lists.newArrayList((Object[])new ElementPojo[]{titleElementPojo, ElementUtils.createDivElementPojo().setElementPojoList((List)Lists.newArrayList((Object[])new ElementPojo[]{tableElementPojo}))}));
        return ElementUtils.getString((ElementPojo)rootElementPojo, (Boolean)false);
    }

    public static List<List<String>> getRowList(RuleManageRowPojo ruleManageRowPojo, String formulaPojoKeyString) {
        List formulaPojoList = ruleManageRowPojo.getFormulaPojoList().stream().filter(item -> "member".equals(item.getTypeString())).collect(Collectors.toList());
        FormulaPojo leftFormulaPojo = (FormulaPojo)formulaPojoList.get(0);
        LinkedList<List<String>> listList = new LinkedList<List<String>>();
        if (formulaPojoKeyString.equals(leftFormulaPojo.getKeyString())) {
            List ruleRangePojoList = ruleManageRowPojo.getRuleRangePojoList();
            Map<String, RuleRangePojo> ruleRangePojoMap = ruleRangePojoList.stream().collect(Collectors.toMap(item -> item.getNumberString(), item -> item));
            List dimensionList = (List)LambdaUtils.get(() -> {
                List _dimensionList;
                Long modelIdLong = ObjUtils.getLong((Object)ruleManageRowPojo.getModelIdLongString());
                IModelCacheHelper modelCacheHelper = ModelCacheContext.getOrCreate((Long)ObjUtils.getLong((Object)ruleManageRowPojo.getModelIdLongString()));
                if (SysDimensionEnum.Account.getNumber().equals(ruleManageRowPojo.getDimensionNumberString())) {
                    FormulaPojo formulaPojo = (FormulaPojo)ruleManageRowPojo.getFormulaPojoList().get(0);
                    Member accountMember = modelCacheHelper.getMember(SysDimensionEnum.Account.getNumber(), null, formulaPojo.getNumberString());
                    _dimensionList = DatasetServiceHelper.getInstance().listDimensionByAccountId(accountMember.getId(), modelIdLong);
                } else {
                    RuleRangePojo ruleRangePojo = (RuleRangePojo)LambdaUtils.getTarget((List)ruleManageRowPojo.getRuleRangePojoList(), item -> item != null && SysDimensionEnum.Account.getNumber().equals(item.getNumberString()));
                    Member accountMember = modelCacheHelper.getMember(SysDimensionEnum.Account.getNumber(), null, ((RuleRangMemberPojo)ruleRangePojo.getRuleRangMemberPojoList().get(0)).getNumberString());
                    _dimensionList = DatasetServiceHelper.getInstance().listDimensionByAccountId(accountMember.getId(), modelIdLong);
                }
                Dimension accountDim = new Dimension(Long.valueOf(0L), SysDimensionEnum.Account.getChineseName(), SysDimensionEnum.Account.getNumber());
                _dimensionList.add(0, accountDim);
                return _dimensionList;
            });
            dimensionList = dimensionList.stream().sorted(Comparator.comparingInt(Dimension::getSeq)).collect(Collectors.toList());
            for (Dimension dimension : dimensionList) {
                RuleRangePojo ruleRangePojo = ruleRangePojoMap.get(dimension.getNumber());
                LinkedList<String> rowList = new LinkedList<String>();
                listList.add(rowList);
                rowList.add(dimension.getName());
                if (dimension.getNumber().equals(ruleManageRowPojo.getDimensionNumberString())) {
                    rowList.add(leftFormulaPojo.getValueString());
                    rowList.add(leftFormulaPojo.getNumberString());
                    continue;
                }
                if (ruleRangePojo == null) {
                    rowList.add(null);
                    rowList.add(null);
                    continue;
                }
                List ruleRangMemberPojoList = ruleRangePojo.getRuleRangMemberPojoList();
                List removeRuleRangMemberPojoList = ruleRangePojo.getRemoveRuleRangMemberPojoList();
                LinkedList<String> nameStringList = new LinkedList<String>();
                LinkedList<String> removeNameStringList = new LinkedList<String>();
                LinkedList<String> numberStringList = new LinkedList<String>();
                LinkedList<String> removeNumberStringList = new LinkedList<String>();
                for (RuleRangMemberPojo ruleRangMemberPojo : ruleRangMemberPojoList) {
                    nameStringList.add(ruleRangMemberPojo.getNameString() + "." + ruleRangMemberPojo.getRangEnumNameString());
                    numberStringList.add(ruleRangMemberPojo.getNumberString() + "." + ruleRangMemberPojo.getRangEnumNumberString());
                }
                if (CollectionUtils.isNotEmpty((Collection)removeRuleRangMemberPojoList)) {
                    for (RuleRangMemberPojo removeRuleRangMemberPojo : removeRuleRangMemberPojoList) {
                        removeNameStringList.add(removeRuleRangMemberPojo.getNumberString() + "." + removeRuleRangMemberPojo.getRangEnumNameString());
                        removeNumberStringList.add(removeRuleRangMemberPojo.getNumberString() + "." + removeRuleRangMemberPojo.getRangEnumNumberString());
                    }
                }
                String nameString = String.join((CharSequence)"</br>", nameStringList);
                if (CollectionUtils.isNotEmpty(removeNameStringList)) {
                    nameString = nameString + "</br>Remove(</br>" + String.join((CharSequence)"</br>", removeNameStringList) + "</br>)";
                }
                rowList.add(nameString);
                String numberString = String.join((CharSequence)"</br>", numberStringList);
                if (CollectionUtils.isNotEmpty(removeNumberStringList)) {
                    numberString = numberString + "</br>Remove(</br>" + String.join((CharSequence)"</br>", removeNumberStringList) + "</br>)";
                }
                rowList.add(numberString);
            }
            return listList;
        }
        FormulaPojo formulaPojo = (FormulaPojo)LambdaUtils.getTarget(formulaPojoList, item -> formulaPojoKeyString.equals(item.getKeyString()));
        if (formulaPojo == null) {
            return null;
        }
        Map formulaMembPojoMap = (Map)LambdaUtils.get(() -> {
            List notMainFormulaMembPojoList = formulaPojo.getNotMainMemberList();
            if (CollectionUtils.isEmpty((Collection)notMainFormulaMembPojoList)) {
                return Collections.emptyMap();
            }
            return notMainFormulaMembPojoList.stream().collect(Collectors.toMap(item -> item.getDimNumber(), item -> item));
        });
        List<Dimension> dimensionList = RuleTextJsAction.getDimensionForFormulaMember(formulaPojo, ruleManageRowPojo);
        for (Dimension dimension : dimensionList) {
            LinkedList<String> rowList = new LinkedList<String>();
            listList.add(rowList);
            rowList.add(dimension.getName());
            FormulaMembPojo formulaMembPojo = (FormulaMembPojo)formulaMembPojoMap.get(dimension.getNumber());
            if (dimension.getNumber().equals(ruleManageRowPojo.getDimensionNumberString())) {
                rowList.add(formulaPojo.getValueString());
                rowList.add(formulaPojo.getNumberString());
                continue;
            }
            if (formulaMembPojo != null) {
                rowList.add(formulaMembPojo.getNameString());
                rowList.add(formulaMembPojo.getNumberString());
                continue;
            }
            rowList.add(null);
            rowList.add(null);
        }
        return listList;
    }

    public static List<RelationGraphDataTrackingItemPojo> getRelationGraphDataTrackingItemPojoList(Map<String, RuleManageRowPojo> ruleManageRowPojoMap, RelationGraphDataPojo relationGraphDataPojo) {
        LinkedList<RelationGraphDataTrackingItemPojo> relationGraphDataTrackingItemPojoList = new LinkedList<RelationGraphDataTrackingItemPojo>();
        for (RelationGraphNodePojo relationGraphNodePojo : relationGraphDataPojo.getRelationGraphNodePojoList()) {
            RuleManageRowPojo ruleManageRowPojo = ruleManageRowPojoMap.get(relationGraphNodePojo.getIdString());
            List formulaPojoList = ruleManageRowPojo.getFormulaPojoList();
            RelationGraphNodeDataPojo relationGraphNodeDataPojo = new RelationGraphNodeDataPojo();
            relationGraphNodePojo.setRelationGraphNodeDataPojo(relationGraphNodeDataPojo);
            RelationGraphNodeDataAreaPojo relationGraphNodeDataAreaPojo = new RelationGraphNodeDataAreaPojo();
            relationGraphNodeDataPojo.setRelationGraphNodeDataAreaPojo(relationGraphNodeDataAreaPojo);
            LinkedList<RelationGraphNodeDataRowPojo> relationGraphNodeDataRowPojoList = new LinkedList<RelationGraphNodeDataRowPojo>();
            relationGraphNodeDataAreaPojo.setRelationGraphNodeDataRowPojoList(relationGraphNodeDataRowPojoList);
            RuleExecGraphUtils.addRuleFormulaRow(relationGraphDataTrackingItemPojoList, relationGraphNodePojo, ruleManageRowPojo, formulaPojoList, relationGraphNodeDataRowPojoList);
            RuleExecGraphUtils.addRuleNumberRow(ruleManageRowPojo, relationGraphNodeDataRowPojoList);
            RuleExecGraphUtils.addRuleNameRow(ruleManageRowPojo, relationGraphNodeDataRowPojoList);
        }
        return relationGraphDataTrackingItemPojoList;
    }

    public static void addRuleNameRow(RuleManageRowPojo ruleManageRowPojo, List<RelationGraphNodeDataRowPojo> relationGraphNodeDataRowPojoList) {
        RelationGraphNodeDataRowPojo relationGraphNodeDataRowPojo = new RelationGraphNodeDataRowPojo();
        relationGraphNodeDataRowPojo.setStylePojo(new StylePojo().setPaddingString("5px"));
        relationGraphNodeDataRowPojoList.add(relationGraphNodeDataRowPojo);
        LinkedList relationGraphNodeDataCellPojoList = new LinkedList();
        relationGraphNodeDataRowPojo.setRelationGraphNodeDataCellPojoList(relationGraphNodeDataCellPojoList);
        LambdaUtils.run(() -> {
            RelationGraphNodeDataCellPojo relationGraphNodeDataCellPojo = new RelationGraphNodeDataCellPojo();
            relationGraphNodeDataCellPojoList.add(relationGraphNodeDataCellPojo);
            relationGraphNodeDataCellPojo.setValueString(ResManager.loadKDString((String)"\u89c4\u5219\u540d\u79f0:", (String)"RelationGraphPlugin_47", (String)"epm-eb-formplugin", (Object[])new Object[0]));
        });
        LambdaUtils.run(() -> {
            RelationGraphNodeDataCellPojo relationGraphNodeDataCellPojo = new RelationGraphNodeDataCellPojo();
            relationGraphNodeDataCellPojoList.add(relationGraphNodeDataCellPojo);
            relationGraphNodeDataCellPojo.setValueString(ruleManageRowPojo.getNameString());
        });
    }

    public static void addRuleNumberRow(RuleManageRowPojo ruleManageRowPojo, List<RelationGraphNodeDataRowPojo> relationGraphNodeDataRowPojoList) {
        RelationGraphNodeDataRowPojo relationGraphNodeDataRowPojo = new RelationGraphNodeDataRowPojo();
        relationGraphNodeDataRowPojoList.add(relationGraphNodeDataRowPojo);
        relationGraphNodeDataRowPojo.setStylePojo(new StylePojo().setPaddingString("5px 5px 0 5px"));
        LinkedList relationGraphNodeDataCellPojoList = new LinkedList();
        relationGraphNodeDataRowPojo.setRelationGraphNodeDataCellPojoList(relationGraphNodeDataCellPojoList);
        LambdaUtils.run(() -> {
            RelationGraphNodeDataCellPojo relationGraphNodeDataCellPojo = new RelationGraphNodeDataCellPojo();
            relationGraphNodeDataCellPojoList.add(relationGraphNodeDataCellPojo);
            relationGraphNodeDataCellPojo.setValueString(ResManager.loadKDString((String)"\u89c4\u5219\u7f16\u7801:", (String)"RelationGraphPlugin_43", (String)"epm-eb-formplugin", (Object[])new Object[0]));
        });
        LambdaUtils.run(() -> {
            RelationGraphNodeDataCellPojo relationGraphNodeDataCellPojo = new RelationGraphNodeDataCellPojo();
            relationGraphNodeDataCellPojoList.add(relationGraphNodeDataCellPojo);
            relationGraphNodeDataCellPojo.setValueString(ruleManageRowPojo.getNumberString());
            relationGraphNodeDataCellPojo.setStylePojo(new StylePojo().setCursorString("pointer").setColorString("#5582F3"));
            relationGraphNodeDataCellPojo.setTypeStringList((List)Lists.newArrayList((Object[])new String[]{RelationGraphTypeEnum.BACKGROUND_COLOR.name(), RelationGraphTypeEnum.RULE_NUMBER.name()}));
            LinkedList<MethodPojo> methodPojoList = new LinkedList<MethodPojo>();
            relationGraphNodeDataCellPojo.setMethodPojoList(methodPojoList);
            relationGraphNodeDataCellPojo.setIdString(ruleManageRowPojo.getIdString());
            methodPojoList.add(new MethodPojo().setListenMethodNameString("mouseover"));
            methodPojoList.add(new MethodPojo().setListenMethodNameString("mouseout"));
            methodPojoList.add(new MethodPojo().setListenMethodNameString("click").setEventNameString(RelationGraphInteractionTypeEnum.NODE_JUMP_TO_BIZ_RULE.name()));
        });
    }

    public static void addRuleFormulaRow(List<RelationGraphDataTrackingItemPojo> relationGraphDataTrackingItemPojoList, RelationGraphNodePojo relationGraphNodePojo, RuleManageRowPojo ruleManageRowPojo, List<FormulaPojo> formulaPojoList, List<RelationGraphNodeDataRowPojo> relationGraphNodeDataRowPojoList) {
        RelationGraphNodeDataRowPojo relationGraphNodeDataRowPojo = new RelationGraphNodeDataRowPojo();
        relationGraphNodeDataRowPojo.setStylePojo(new StylePojo().setBorderBottomString("#b2b2b2 dashed 1px").setPaddingString("5px"));
        relationGraphNodeDataRowPojoList.add(relationGraphNodeDataRowPojo);
        ArrayList<RelationGraphNodeDataCellPojo> relationGraphNodeDataCellPojoList = new ArrayList<RelationGraphNodeDataCellPojo>(formulaPojoList.size());
        relationGraphNodeDataRowPojo.setRelationGraphNodeDataCellPojoList(relationGraphNodeDataCellPojoList);
        for (FormulaPojo formulaPojo : formulaPojoList) {
            RelationGraphNodeDataCellPojo relationGraphNodeDataCellPojo = new RelationGraphNodeDataCellPojo();
            relationGraphNodeDataCellPojoList.add(relationGraphNodeDataCellPojo);
            if (!"member".equals(formulaPojo.getTypeString())) {
                relationGraphNodeDataCellPojo.setValueString(formulaPojo.getValueString());
                continue;
            }
            relationGraphNodeDataCellPojo.setIdString(StrUtils.getUuidIdWithDataString());
            relationGraphNodeDataCellPojo.setStylePojo(new StylePojo().setColorString("#5582F3").setCursorString("pointer").setTextAlignString("center"));
            relationGraphNodeDataCellPojo.setValueString(formulaPojo.getValueString());
            relationGraphNodeDataCellPojo.setTypeStringList((List)Lists.newArrayList((Object[])new String[]{RelationGraphTypeEnum.BACKGROUND_COLOR.name(), RelationGraphTypeEnum.RULE_MEMBER.name()}));
            LinkedList<MethodPojo> methodPojoList = new LinkedList<MethodPojo>();
            relationGraphNodeDataCellPojo.setMethodPojoList(methodPojoList);
            methodPojoList.add(new MethodPojo().setListenMethodNameString("mouseover"));
            methodPojoList.add(new MethodPojo().setListenMethodNameString("mouseout"));
            methodPojoList.add(new MethodPojo().setListenMethodNameString("click").setEventNameString(RelationGraphInteractionTypeEnum.RULE_EXEC_CLICK_CELL.name()));
            RelationGraphDataTrackingItemPojo relationGraphDataTrackingItemPojo = new RelationGraphDataTrackingItemPojo();
            relationGraphDataTrackingItemPojoList.add(relationGraphDataTrackingItemPojo);
            relationGraphDataTrackingItemPojo.setTypeString(RelationGraphDataTrackingTypeEnum.CELL.name());
            relationGraphDataTrackingItemPojo.setCurrentNodeIdString(relationGraphNodePojo.getIdString());
            relationGraphDataTrackingItemPojo.setCurrentCellIdString(relationGraphNodeDataCellPojo.getIdString());
            relationGraphDataTrackingItemPojo.setKeyString(formulaPojo.getKeyString());
            relationGraphDataTrackingItemPojo.setInfoHtmlString(RuleExecGraphUtils.getInfoHtmlString(ruleManageRowPojo, formulaPojo.getKeyString()));
        }
    }
}

