/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.formplugin.ruleexec.command;

import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import kd.bos.context.RequestContext;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.epm.eb.common.cache.IModelCacheHelper;
import kd.epm.eb.common.cache.ModelCacheContext;
import kd.epm.eb.common.cache.impl.Member;
import kd.epm.eb.common.constant.BgTaskExecuteConstant;
import kd.epm.eb.common.report.ruleexec.RuleCaseExecExceptionHelper;
import kd.epm.eb.formplugin.report.excel.helper.ReportExportJobCacheHelper;
import kd.epm.eb.formplugin.ruleexec.command.RuleExecCommand;
import kd.epm.eb.formplugin.ruleexec.service.ReportRuleExecJobCacheHelper;
import kd.epm.eb.formplugin.ruleexec.service.RuleCaseService;
import kd.epm.eb.spread.report.ruleexec.entity.request.ReportRuleExecRequest;
import kd.epm.eb.spread.report.ruleexec.entity.request.ReportRuleTaskRequest;
import org.apache.commons.collections4.CollectionUtils;

public class ReportRuleExecCommand
extends RuleExecCommand
implements BgTaskExecuteConstant {
    private static final Log log = LogFactory.getLog(ReportRuleExecCommand.class);
    private final ReportRuleTaskRequest reportRuleTaskRequest;

    public ReportRuleExecCommand(ReportRuleTaskRequest reportRuleTaskRequest) {
        this.reportRuleTaskRequest = reportRuleTaskRequest;
    }

    public void execute() {
        log.info("execute start:traceId:" + RequestContext.get().getTraceId());
        if (this.reportRuleTaskRequest == null) {
            return;
        }
        this.taskLogId = this.reportRuleTaskRequest.getTaskLogId();
        try {
            ReportRuleExecRequest reportRuleExecRequest = (ReportRuleExecRequest)this.reportRuleTaskRequest.getReportRuleExecRequests().get(0);
            Map<String, Set<String>> allLeafMemberMap = this.getAllLeafMemberMap(reportRuleExecRequest);
            this.ruleCase = RuleCaseService.getInstance().genVirtualCase(reportRuleExecRequest.getModelId(), reportRuleExecRequest.getBizModelId(), null, allLeafMemberMap);
            this.doExecute();
        }
        finally {
            this.afterExecute();
        }
    }

    private Map<String, Set<String>> getAllLeafMemberMap(ReportRuleExecRequest reportRuleExecRequest) {
        Long modelId = reportRuleExecRequest.getModelId();
        IModelCacheHelper modelCache = ModelCacheContext.getOrCreate((Long)modelId);
        Map viewMap = reportRuleExecRequest.getViewMap();
        Map execMemberMap = reportRuleExecRequest.getExecMemberMap();
        HashMap<String, Set<String>> allLeafMemberMap = new HashMap<String, Set<String>>(16);
        for (Map.Entry entry : execMemberMap.entrySet()) {
            String dimension = (String)entry.getKey();
            HashSet<String> sets = new HashSet<String>();
            Long viewId = (Long)viewMap.get(dimension);
            Set value = (Set)entry.getValue();
            for (String memNumber : value) {
                Member member = modelCache.getMemberByAnyView(reportRuleExecRequest.getBizModelId(), dimension, memNumber);
                if (member.isLeaf()) {
                    sets.add(member.getNumber());
                    continue;
                }
                sets.addAll(modelCache.getLeafOfNumbers(member));
            }
            allLeafMemberMap.put(dimension, sets);
        }
        return allLeafMemberMap;
    }

    private void afterExecute() {
        RuleCaseExecExceptionHelper.getInstance().removeCancelTaskLogIdCache(this.reportRuleTaskRequest.getTaskLogId());
        if (this.reportRuleTaskRequest != null && CollectionUtils.isNotEmpty((Collection)this.reportRuleTaskRequest.getReportRuleExecRequests())) {
            ReportRuleExecJobCacheHelper.remove(ReportExportJobCacheHelper.getReportExportJobInfoCacheKey(this.reportRuleTaskRequest.getModelId()), this.reportRuleTaskRequest);
        }
    }
}

