/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.formplugin.ruleexec.consumer;

import kd.bos.context.RequestContext;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.epm.eb.common.enums.status.ReportRuleExecStatusEnum;
import kd.epm.eb.formplugin.report.excel.mq.consumer.ReportExportConsumer;
import kd.epm.eb.formplugin.ruleexec.command.ReportRuleExecCommand;
import kd.epm.eb.formplugin.ruleexec.service.ReportRuleExecJobCacheHelper;
import kd.epm.eb.formplugin.ruleexec.service.RuleExecLogService;
import kd.epm.eb.spread.report.ruleexec.entity.request.ReportRuleTaskRequest;

public class ReportRuleExecConsumer
implements Runnable {
    private static final Log log = LogFactory.getLog(ReportExportConsumer.class);
    private ReportRuleTaskRequest reportRuleTaskRequest;

    public ReportRuleExecConsumer(ReportRuleTaskRequest reportRuleTaskRequest) {
        this.reportRuleTaskRequest = reportRuleTaskRequest;
        ReportRuleExecJobCacheHelper.cache(ReportRuleExecJobCacheHelper.getRuleCaseExecJobInfoCacheKey(reportRuleTaskRequest.getModelId()), reportRuleTaskRequest);
    }

    @Override
    public void run() {
        this.doExport();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doExport() {
        try {
            log.info("ruleCaseExec:traceId:" + RequestContext.get().getTraceId());
            log.info("ruleCaseExec:tenantId:" + RequestContext.get().getTenantId());
            log.info("ruleCaseExec:userName:" + RequestContext.get().getUserName());
            ReportRuleExecCommand reportRuleExecCommand = new ReportRuleExecCommand(this.reportRuleTaskRequest);
            reportRuleExecCommand.execute();
        }
        catch (Exception e) {
            log.info("ReportExportConsumer reportExportTaskRequest:" + SerializationUtils.toJsonString((Object)this.reportRuleTaskRequest));
            log.error((Throwable)e);
            String exceptionInfo = ResManager.loadResFormat((String)"\u6267\u884c\u5931\u8d25\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u5904\u7406\uff1a%1\u3002", (String)"RuleCase_44", (String)"epm-eb-formplugin", (Object[])new Object[]{RequestContext.get().getTraceId()});
            if (e.getCause() instanceof KDBizException) {
                exceptionInfo = e.getCause().getMessage();
            }
            log.info("--export consumer doExport update failed");
            RuleExecLogService.getInstance().updateExecStatus(this.reportRuleTaskRequest.getTaskLogId(), null, ReportRuleExecStatusEnum.EXEC_FAIL.getCode(), exceptionInfo);
        }
        finally {
            ReportRuleExecJobCacheHelper.remove(ReportRuleExecJobCacheHelper.getRuleCaseExecJobInfoCacheKey(this.reportRuleTaskRequest.getModelId()), this.reportRuleTaskRequest);
        }
    }
}

