/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.formplugin.ruleexec.controller;

import com.google.common.collect.Lists;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.exception.KDBizException;
import kd.bos.form.CloseCallBack;
import kd.bos.form.IFormView;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.epm.eb.common.enums.status.ReportRuleExecStatusEnum;
import kd.epm.eb.common.thread.EpmThreadPools;
import kd.epm.eb.common.utils.GlobalIdUtil;
import kd.epm.eb.formplugin.ruleexec.consumer.ReportRuleExecConsumer;
import kd.epm.eb.formplugin.ruleexec.service.ReportRuleExecJobCacheHelper;
import kd.epm.eb.formplugin.ruleexec.service.RuleExecLogService;
import kd.epm.eb.spread.report.ruleexec.entity.request.ReportRuleExecRequest;
import kd.epm.eb.spread.report.ruleexec.entity.request.ReportRuleTaskRequest;
import org.apache.commons.collections4.CollectionUtils;

public class ReportRuleExecController {
    private static final Log log = LogFactory.getLog(ReportRuleExecController.class);
    public static final Long currentQueueId = GlobalIdUtil.genGlobalLongId();

    public static ReportRuleExecController getInstance() {
        return InnerClass.INSTANCE;
    }

    private ReportRuleExecController() {
    }

    public Map<String, String> execRuleCase(ReportRuleExecRequest reportRuleExecRequest, IFormView formView, CloseCallBack closeCallBack) {
        HashMap<String, String> result = new HashMap<String, String>(16);
        result.put("status", "failed");
        boolean isRepeatInQueue = this.checkRequestIsRepeatInQueue(reportRuleExecRequest, reportRuleExecRequest.getModelId());
        if (isRepeatInQueue) {
            result.put("msg", ResManager.loadKDString((String)"\u5df2\u5b58\u5728\u76f8\u540c\u7684\u89c4\u5219\u6267\u884c\u4efb\u52a1\uff0c\u8bf7\u7a0d\u540e\u518d\u8bd5\u3002", (String)"RuleCase_45", (String)"epm-eb-formplugin", (Object[])new Object[0]));
            return result;
        }
        this.writeOpLog(reportRuleExecRequest);
        long timeoutMillions = 3600000L;
        ReportRuleTaskRequest reportRuleTaskRequest = RuleExecLogService.getInstance().createReportRuleTaskRequest(reportRuleExecRequest.getModelId(), Lists.newArrayList((Object[])new ReportRuleExecRequest[]{reportRuleExecRequest}), timeoutMillions);
        try {
            ReportRuleExecConsumer reportExportConsumer = new ReportRuleExecConsumer(reportRuleTaskRequest);
            EpmThreadPools.ruleCaseExecConsumerThreadPool.submit((Runnable)reportExportConsumer);
            result.put("status", "success");
            result.put("logid", reportRuleTaskRequest.getTaskLogId().toString());
            result.put("msg", ResManager.loadKDString((String)"\u89c4\u5219\u6267\u884c\u4efb\u52a1\u63d0\u4ea4\u6210\u529f\uff0c\u8bf7\u5173\u6ce8\u53f3\u4e0b\u89d2\u7684\u6267\u884c\u8fdb\u5ea6\u3002", (String)"RuleCase_46", (String)"epm-eb-formplugin", (Object[])new Object[0]));
        }
        catch (Exception e) {
            log.error("reportExport submit error.");
            String errorInfo = ResManager.loadResFormat((String)"\u89c4\u5219\u6267\u884c\u4efb\u52a1\u53d1\u751f\u5f02\u5e38%1\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u3002", (String)"RuleCase_47", (String)"epm-eb-formplugin", (Object[])new Object[]{RequestContext.get().getTraceId()});
            if (e instanceof KDBizException) {
                errorInfo = e.getMessage();
            }
            result.put("msg", errorInfo);
            ReportRuleExecJobCacheHelper.remove(ReportRuleExecJobCacheHelper.getRuleCaseExecJobInfoCacheKey(reportRuleExecRequest.getModelId()), reportRuleTaskRequest);
            RuleExecLogService.getInstance().updateExecStatus(reportRuleTaskRequest.getTaskLogId(), null, ReportRuleExecStatusEnum.EXEC_FAIL.getCode(), errorInfo);
        }
        return result;
    }

    private void writeOpLog(ReportRuleExecRequest reportRuleExecRequest) {
    }

    private boolean checkRequestIsRepeatInQueue(ReportRuleExecRequest requests, Long modelId) {
        String cacheKey = ReportRuleExecJobCacheHelper.getRuleCaseExecJobInfoCacheKey(modelId);
        Set<Integer> currentRequestHashCodeSet = ReportRuleExecJobCacheHelper.getJobInfoHashCodeSet(cacheKey);
        if (CollectionUtils.isEmpty(currentRequestHashCodeSet)) {
            return false;
        }
        return currentRequestHashCodeSet.contains(requests.hashCode());
    }

    private static class InnerClass {
        private static final ReportRuleExecController INSTANCE = new ReportRuleExecController();

        private InnerClass() {
        }
    }
}

