/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.formplugin.ruleexec.entity;

import com.fasterxml.jackson.core.type.TypeReference;
import java.io.Serializable;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.epm.eb.common.dao.formula.MemberCondition;
import kd.epm.eb.common.utils.StringUtils;
import kd.epm.eb.common.utils.base.JsonUtils;
import kd.epm.eb.formplugin.ruleexec.entity.RuleRow;
import kd.epm.eb.formplugin.ruleexec.enums.CaseUpdateStatusEnum;
import kd.epm.eb.olap.impl.bizrule.RuleCacheService;
import kd.epm.eb.olap.impl.bizrule.RuleService;
import kd.epm.eb.olap.impl.bizrule.entity.RuleCacheContext;
import kd.epm.eb.olap.impl.bizrule.entity.RuleDto;

public class RuleCase
implements Serializable {
    private static final long serialVersionUID = -7158281633536715516L;
    private Long id;
    private Long modelId;
    private Long bizModelId;
    private Long dataSetId;
    private String caseNumber;
    private String caseName;
    private CaseUpdateStatusEnum status;
    private List<RuleRow> rowList;
    private Boolean allowDisable;
    private String type;

    public Long getId() {
        return this.id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public Long getModelId() {
        return this.modelId;
    }

    public void setModelId(Long modelId) {
        this.modelId = modelId;
    }

    public Long getBizModelId() {
        return this.bizModelId;
    }

    public void setBizModelId(Long bizModelId) {
        this.bizModelId = bizModelId;
    }

    public Long getDataSetId() {
        return this.dataSetId;
    }

    public void setDataSetId(Long dataSetId) {
        this.dataSetId = dataSetId;
    }

    public String getCaseNumber() {
        return this.caseNumber;
    }

    public void setCaseNumber(String caseNumber) {
        this.caseNumber = caseNumber;
    }

    public String getCaseName() {
        return this.caseName;
    }

    public void setCaseName(String caseName) {
        this.caseName = caseName;
    }

    public CaseUpdateStatusEnum getStatus() {
        return this.status;
    }

    public void setStatus(CaseUpdateStatusEnum status) {
        this.status = status;
    }

    public List<RuleRow> getRowList() {
        return this.rowList;
    }

    public void setRowList(List<RuleRow> rowList) {
        this.rowList = rowList;
    }

    public Boolean getAllowDisable() {
        return this.allowDisable;
    }

    public void setAllowDisable(Boolean allowDisable) {
        this.allowDisable = allowDisable;
    }

    public String getType() {
        return this.type;
    }

    public void setType(String type) {
        this.type = type;
    }

    public static RuleCase of(DynamicObject doj) {
        RuleCase ruleCase = new RuleCase();
        ruleCase.setId(doj.getLong("id"));
        ruleCase.setModelId(doj.getLong("model.id"));
        ruleCase.setBizModelId(doj.getLong("bizmodel.id"));
        ruleCase.setDataSetId(doj.getLong("dataset.id"));
        ruleCase.setCaseNumber(doj.getString("number"));
        ruleCase.setCaseName(doj.getString("name"));
        ruleCase.setStatus(CaseUpdateStatusEnum.getStatusByCode(doj.getString("updatestatus")));
        ruleCase.setAllowDisable(doj.getBoolean("allowdisable"));
        ruleCase.setType(doj.getString("type"));
        LinkedList<RuleRow> rowList = new LinkedList<RuleRow>();
        DynamicObjectCollection dojColl = doj.getDynamicObjectCollection("selectruleentity");
        if (!dojColl.isEmpty()) {
            RuleCacheContext ruleCacheContext = RuleCacheService.getInstance().listRuleFromLocalCache(ruleCase.getBizModelId());
            List ruleDtoList = ruleCacheContext.getRuleDtoList();
            Map<Long, RuleDto> ruleDtoMap = ruleDtoList.stream().collect(Collectors.toMap(RuleDto::getId, v -> v));
            for (DynamicObject childDoj : dojColl) {
                List list;
                long ruleId = childDoj.getLong("rulename.id");
                RuleDto ruleDto = ruleDtoMap.get(ruleId);
                if (ruleDto == null && CaseUpdateStatusEnum.NONE == ruleCase.getStatus() && (list = RuleService.getInstance().listRule(ruleCase.getBizModelId(), null, Collections.singletonList(ruleId))).size() > 0) {
                    ruleDto = (RuleDto)list.get(0);
                }
                if (ruleDto == null) continue;
                RuleRow row = new RuleRow(ruleDto);
                Map<String, List<Object>> memberListMap = new HashMap<String, List<MemberCondition>>();
                String rangeJson = childDoj.getString("rangejson");
                if (StringUtils.isNotEmpty((String)rangeJson)) {
                    memberListMap = (Map)JsonUtils.readValue((String)rangeJson, (TypeReference)new TypeReference<Map<String, List<MemberCondition>>>(){});
                }
                row.setExecRange(memberListMap);
                rowList.add(row);
            }
        }
        ruleCase.setRowList(rowList);
        return ruleCase;
    }
}

