/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.formplugin.ruleexec.service;

import com.fasterxml.jackson.core.type.TypeReference;
import com.google.common.graph.EndpointPair;
import com.google.common.graph.Graph;
import com.google.common.graph.GraphBuilder;
import com.google.common.graph.Graphs;
import com.google.common.graph.MutableGraph;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.TimeServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.epm.eb.business.bizrule.LeafRuleTraceHelper;
import kd.epm.eb.business.bizrule.RuleGraphService;
import kd.epm.eb.business.bizrule.entity.GraphNode;
import kd.epm.eb.common.cache.IModelCacheHelper;
import kd.epm.eb.common.cache.ModelCacheContext;
import kd.epm.eb.common.cache.impl.BaseCache;
import kd.epm.eb.common.cache.impl.Member;
import kd.epm.eb.common.cache.propertycache.MemberPropCacheService;
import kd.epm.eb.common.cache.propertycache.entity.MemberPropCache;
import kd.epm.eb.common.dao.formula.MemberCondition;
import kd.epm.eb.common.entity.property.CustomPropertyValue;
import kd.epm.eb.common.enums.RangeEnum;
import kd.epm.eb.common.enums.SysDimensionEnum;
import kd.epm.eb.common.orm.EbBizruleset;
import kd.epm.eb.common.rule.relation.pojo.RelationGraphNodePojoTree;
import kd.epm.eb.common.utils.GlobalIdUtil;
import kd.epm.eb.common.utils.IDUtils;
import kd.epm.eb.common.utils.QFBuilder;
import kd.epm.eb.common.utils.StringUtils;
import kd.epm.eb.common.utils.UserUtils;
import kd.epm.eb.common.utils.base.JsonUtils;
import kd.epm.eb.common.utils.base.LambdaUtils;
import kd.epm.eb.common.utils.base.ObjUtils;
import kd.epm.eb.common.utils.base.OrmBuilder;
import kd.epm.eb.formplugin.ruleexec.entity.RuleCase;
import kd.epm.eb.formplugin.ruleexec.entity.RuleExecGenCaseRequest;
import kd.epm.eb.formplugin.ruleexec.entity.RuleRow;
import kd.epm.eb.formplugin.ruleexec.enums.CaseUpdateStatusEnum;
import kd.epm.eb.formplugin.ruleexec.enums.ExecCaseWizardStepEnum;
import kd.epm.eb.formplugin.ruleexec.enums.RuleExecCaseTypeEnum;
import kd.epm.eb.formplugin.rulemanage.RelationGraphUtils;
import kd.epm.eb.formplugin.rulemanage.ruleexecute.domain.ExecuteStatusEnum;
import kd.epm.eb.formplugin.rulemanage.ruleexecute.domain.ExecuteVo;
import kd.epm.eb.olap.impl.bizrule.RuleCacheService;
import kd.epm.eb.olap.impl.bizrule.RuleService;
import kd.epm.eb.olap.impl.bizrule.entity.RuleDto;
import org.apache.commons.collections.ListUtils;
import org.apache.commons.collections4.CollectionUtils;

public class RuleCaseService {
    private static final Log log = LogFactory.getLog(RuleCaseService.class);
    private static final RuleCaseService instance = new RuleCaseService();

    private RuleCaseService() {
    }

    public static RuleCaseService getInstance() {
        return instance;
    }

    public RuleCase genVirtualCase(Long modelId, Long bizModelId, Long datasetId, Map<String, Set<String>> execMemberMap) {
        RuleCase ruleCase = new RuleCase();
        ruleCase.setModelId(modelId);
        ruleCase.setBizModelId(bizModelId);
        ruleCase.setDataSetId(datasetId);
        try {
            IModelCacheHelper modelCache = ModelCacheContext.getOrCreate((Long)modelId);
            List ruleDtoList = RuleCacheService.getInstance().listRuleFromLocalCache(bizModelId).getRuleDtoList();
            MutableGraph<GraphNode> resultGraph = this.genGraph(bizModelId, modelCache, ruleDtoList, execMemberMap);
            List<Long> sortedRuleId = RuleCaseService.getInstance().getSortedRuleId(resultGraph);
            Map objectMap = ruleDtoList.stream().collect(Collectors.toMap(RuleDto::getId, Function.identity()));
            List<RuleRow> ruleRowList = sortedRuleId.stream().map(objectMap::get).map(RuleRow::new).collect(Collectors.toList());
            ruleCase.setRowList(ruleRowList);
            ruleCase.setStatus(CaseUpdateStatusEnum.UPDATE_END);
        }
        catch (Exception e) {
            log.error((Throwable)e);
            ruleCase.setStatus(CaseUpdateStatusEnum.UPDATE_FAIL);
        }
        return ruleCase;
    }

    public void updateStatus(Long modelId, Long bizModelId) {
        String sql = "update t_eb_ruleexeccase set fupdatestatus = 'C' where fmodelid = ? and fbizmodelid = ? and fupdatestatus in ('E')";
        DB.execute((DBRoute)DBRoute.of((String)"epm"), (String)sql, (Object[])new Object[]{modelId, bizModelId});
    }

    public MutableGraph<GraphNode> genGraph(RuleExecGenCaseRequest request) {
        IModelCacheHelper modelCache = ModelCacheContext.getOrCreate((Long)request.getModelId());
        MemberPropCache memberPropCache = MemberPropCacheService.getOrCreate((Long)request.getModelId());
        Map viewIds = modelCache.getViewsByBusModel(request.getBizModelId());
        Map<String, List<MemberCondition>> ranges = request.getRanges();
        HashMap<String, Set<String>> leafScope = new HashMap<String, Set<String>>(16);
        List metList = ranges.getOrDefault(SysDimensionEnum.Metric.getNumber(), Collections.emptyList());
        boolean hasAgg = metList.stream().allMatch(e -> modelCache.getMember(SysDimensionEnum.Metric.getNumber(), null, e.getNumber()).hasAgg());
        ranges.forEach((dimensionNum, v) -> {
            Long viewId = (Long)viewIds.get(dimensionNum);
            HashSet dimRef = new HashSet();
            for (MemberCondition memberCondition : v) {
                Long tempViewId = IDUtils.toLong((Object)memberCondition.getViewId());
                if (IDUtils.isEmptyLong((Long)tempViewId).booleanValue()) {
                    tempViewId = viewId;
                }
                if (memberCondition.isProp()) {
                    CustomPropertyValue customPropertyValue = MemberPropCache.getCustomPropertyValue((MemberPropCache)memberPropCache, (String)dimensionNum, (String)memberCondition.getLongnumber());
                    List propMemberList = MemberPropCache.getMembersByPropValues((IModelCacheHelper)modelCache, (MemberPropCache)memberPropCache, (Long)tempViewId, (CustomPropertyValue)customPropertyValue);
                    Set memberRef = propMemberList.stream().filter(Member::isLeaf).map(BaseCache::getNumber).collect(Collectors.toSet());
                    dimRef.addAll(memberRef);
                    continue;
                }
                String number = memberCondition.getNumber();
                List member = modelCache.getMember(dimensionNum, tempViewId, number, RangeEnum.ALL_DETAIL_INCLUDE.getIndex());
                Stream<Object> stream = member.stream();
                if (hasAgg) {
                    stream = stream.filter(Member::isLeaf);
                }
                Set memberRef = stream.map(BaseCache::getNumber).collect(Collectors.toSet());
                dimRef.addAll(memberRef);
            }
            if (dimRef.isEmpty()) {
                throw new KDBizException(ResManager.loadResFormat((String)"\u6210\u5458\u8303\u56f4\u4e2d\u7ef4\u5ea6\uff1a%1\u6ca1\u6709\u660e\u7ec6\u6210\u5458\uff0c\u751f\u6210\u6267\u884c\u65b9\u6848\u5931\u8d25\u3002", (String)"RuleCase_48", (String)"epm-eb-formplugin", (Object[])new Object[]{dimensionNum}));
            }
            leafScope.put((String)dimensionNum, dimRef);
        });
        List ruleDtoList = RuleCacheService.getInstance().listRuleFromLocalCache(request.getBizModelId()).getRuleDtoList();
        return this.genGraph(request.getBizModelId(), modelCache, ruleDtoList, leafScope);
    }

    private MutableGraph<GraphNode> genGraph(Long bizModelId, IModelCacheHelper modelCache, List<RuleDto> ruleDtoList, Map<String, Set<String>> leafScope) {
        MutableGraph totalGraph = RuleGraphService.getInstance().getDagGraphByBizmodel(bizModelId.longValue());
        LeafRuleTraceHelper.LeafRuleTraceContext leafRuleTraceContext = new LeafRuleTraceHelper.LeafRuleTraceContext(leafScope, ruleDtoList, totalGraph, modelCache);
        MutableGraph resultGraph = LeafRuleTraceHelper.findRuleToGraph((LeafRuleTraceHelper.LeafRuleTraceContext)leafRuleTraceContext);
        return resultGraph;
    }

    public List<Long> getSortedRuleId(MutableGraph<GraphNode> resultGraph) {
        LinkedList<Long> sortedRuleId = new LinkedList<Long>();
        while (!resultGraph.nodes().isEmpty()) {
            Set zeroNodes = RuleGraphService.getInstance().getZeroNodes(resultGraph);
            for (GraphNode zeroNode : zeroNodes) {
                sortedRuleId.add(zeroNode.getNodeId());
                resultGraph.removeNode((Object)zeroNode);
            }
        }
        return sortedRuleId;
    }

    public DynamicObject updateCaseEntity(Long modelId, String caseNumber) {
        QFBuilder qfBuilder = new QFBuilder();
        qfBuilder.add("model", "=", (Object)modelId);
        qfBuilder.add("number", "=", (Object)caseNumber);
        DynamicObject doj = BusinessDataServiceHelper.loadSingle((String)"eb_ruleexeccase", (QFilter[])qfBuilder.toArray());
        return this.updateCaseEntity(doj);
    }

    public DynamicObject updateCaseEntity(DynamicObject doj) {
        if (CaseUpdateStatusEnum.UPDATE_WAIT.getCode().equals(doj.getString("updatestatus")) || CaseUpdateStatusEnum.UPDATE_FAIL.getCode().equals(doj.getString("updatestatus"))) {
            Date beforeDate = TimeServiceHelper.now();
            doj.set("updatestatus", (Object)CaseUpdateStatusEnum.UPDATE_ING.getCode());
            doj.getDynamicObjectCollection("selectruleentity").clear();
            doj = (DynamicObject)SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{doj})[0];
            try {
                HashMap<String, List<MemberCondition>> maps = new HashMap<String, List<MemberCondition>>();
                DynamicObjectCollection rangeentity = doj.getDynamicObjectCollection("rangeentity");
                for (DynamicObject dynamicObject : rangeentity) {
                    String dimnumber = dynamicObject.getString("dimnumber");
                    String memberjson = dynamicObject.getString("memberjson");
                    if (!StringUtils.isNotEmpty((String)memberjson)) continue;
                    List memberList = (List)JsonUtils.readValue((String)memberjson, (TypeReference)new TypeReference<List<MemberCondition>>(){});
                    maps.put(dimnumber, memberList);
                }
                RuleExecGenCaseRequest request = new RuleExecGenCaseRequest(doj.getLong("model.id"), doj.getLong("bizmodel.id"), doj.getLong("dataset.id"));
                request.setRanges(maps);
                MutableGraph<GraphNode> resultGraph = this.genGraph(request);
                List<Long> sortedRuleId = RuleCaseService.getInstance().getSortedRuleId(resultGraph);
                DynamicObjectCollection entity = doj.getDynamicObjectCollection("selectruleentity");
                for (Long ruleId : sortedRuleId) {
                    DynamicObject dynamicObject = entity.addNew();
                    dynamicObject.set("rulename", (Object)ruleId);
                }
                doj.set("updatestatus", (Object)CaseUpdateStatusEnum.UPDATE_END.getCode());
            }
            catch (Exception e) {
                log.error("updateCaseError", (Throwable)e);
                doj.set("updatestatus", (Object)CaseUpdateStatusEnum.UPDATE_FAIL.getCode());
            }
            Date now = TimeServiceHelper.now();
            SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm");
            String formattedDate = sdf.format(now);
            long diffInSeconds = (now.getTime() - beforeDate.getTime() + 999L) / 1000L;
            doj.set("updatedetail", (Object)ResManager.loadResFormat((String)"\u66f4\u65b0\u65f6\u95f4\uff1a%1\uff0c\u8017\u65f6\uff1a%2s\u3002", (String)"RuleCase_49", (String)"epm-eb-formplugin", (Object[])new Object[]{formattedDate, diffInSeconds}));
            doj.set("ruleupdatetime", (Object)now);
            doj = (DynamicObject)SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{doj})[0];
        }
        return doj;
    }

    public DynamicObject createExecCase(Set<Long> ruleIdLongCollection) {
        if (CollectionUtils.isEmpty(ruleIdLongCollection)) {
            throw new KDBizException(ResManager.loadKDString((String)"\u53c2\u6570\u4e0d\u53ef\u4e3a\u7a7a", (String)"RuleManagePlugin3_31", (String)"epm-eb-formplugin", (Object[])new Object[0]));
        }
        Long firstRuleIdLong = ruleIdLongCollection.iterator().next();
        EbBizruleset firstEbBizruleset = (EbBizruleset)OrmBuilder.clazz(EbBizruleset.class).field(new String[]{"fmodel"}).whereEqual("fid", (Object)firstRuleIdLong).getTarget();
        if (firstEbBizruleset == null) {
            throw new KDBizException(ResManager.loadResFormat((String)"\u627e\u4e0d\u5230ID\u4e3a%1\u7684\u89c4\u5219\u3002", (String)"RuleManagePlugin3_34", (String)"epm-eb-formplugin", (Object[])new Object[]{firstRuleIdLong}));
        }
        List ebBizrulesetList = OrmBuilder.clazz(EbBizruleset.class).field(new String[]{"fid", "fmodel", "fbizctrlrangeid", "fusescope"}).whereIn("fid", ruleIdLongCollection).toRowList();
        if (CollectionUtils.isEmpty(ruleIdLongCollection)) {
            throw new KDBizException(ResManager.loadKDString((String)"\u53c2\u6570\u4e0d\u53ef\u4e3a\u7a7a", (String)"RuleManagePlugin3_31", (String)"epm-eb-formplugin", (Object[])new Object[0]));
        }
        Set<Long> ruleIdLongSet = ebBizrulesetList.stream().map(item -> item.getIdLong()).collect(Collectors.toSet());
        EbBizruleset ebBizruleset = (EbBizruleset)ebBizrulesetList.get(0);
        MutableGraph graph = RuleGraphService.getInstance().getDagGraphByBizmodel(ebBizruleset.getBizctrlrangeidLong().longValue());
        List<Long> sortedNodeIdLongList = this.getRelationSortedNodeIds(ruleIdLongCollection, ruleIdLongSet, (MutableGraph<GraphNode>)graph);
        List needSortEbBizrulesetList = (List)LambdaUtils.get(() -> {
            List extraRuleIdLongList = sortedNodeIdLongList.stream().filter(item -> !ruleIdLongSet.contains(item)).collect(Collectors.toList());
            if (CollectionUtils.isEmpty(extraRuleIdLongList)) {
                return ebBizrulesetList;
            }
            List extraEbBizrulesetList = OrmBuilder.clazz(EbBizruleset.class).field(new String[]{"fid", "fmodel", "fbizctrlrangeid", "fusescope"}).whereIn("fid", extraRuleIdLongList).toRowList();
            if (CollectionUtils.isEmpty((Collection)extraEbBizrulesetList)) {
                return ebBizrulesetList;
            }
            return ListUtils.union((List)ebBizrulesetList, (List)extraEbBizrulesetList);
        });
        needSortEbBizrulesetList = needSortEbBizrulesetList.stream().sorted(Comparator.comparing(item -> sortedNodeIdLongList.indexOf(item.getIdLong()) + 1)).collect(Collectors.toList());
        DynamicObject doj = BusinessDataServiceHelper.newDynamicObject((String)"eb_ruleexeccase");
        doj.set("id", (Object)GlobalIdUtil.genGlobalLongId());
        doj.set("number", (Object)("ZD-" + doj.get("id")));
        doj.set("name", doj.get("number"));
        doj.set("model", (Object)ebBizruleset.getModelLong());
        doj.set("bizmodel", (Object)ebBizruleset.getBizctrlrangeidLong());
        doj.set("updatestatus", (Object)CaseUpdateStatusEnum.NONE.getCode());
        doj.set("type", (Object)RuleExecCaseTypeEnum.RULE.getCode());
        doj.set("currstep", (Object)ExecCaseWizardStepEnum.Rule.getNumber());
        doj.set("creator", (Object)RequestContext.getOrCreate().getCurrUserId());
        DynamicObjectCollection ruleEntity = doj.getDynamicObjectCollection("selectruleentity");
        for (EbBizruleset bizruleset : needSortEbBizrulesetList) {
            DynamicObject childDoj = ruleEntity.addNew();
            childDoj.set("rulename", (Object)bizruleset.getIdLong());
        }
        doj = (DynamicObject)SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{doj})[0];
        return doj;
    }

    public List<Long> getRelationSortedNodeIds(Set<Long> ruleIdLongCollection, Set<Long> ruleIdLongSet, MutableGraph<GraphNode> graph) {
        MutableGraph mutableGraph = GraphBuilder.directed().allowsSelfLoops(false).build();
        for (GraphNode graphNode : graph.nodes()) {
            mutableGraph.addNode((Object)ObjUtils.getString((Object)graphNode.getNodeId()));
        }
        for (EndpointPair edge : graph.edges()) {
            mutableGraph.putEdge((Object)ObjUtils.getString((Object)((GraphNode)edge.nodeU()).getNodeId()), (Object)ObjUtils.getString((Object)((GraphNode)edge.nodeV()).getNodeId()));
        }
        HashSet notInGraphSet = new HashSet(16);
        ruleIdLongSet.forEach(e -> {
            if (!mutableGraph.nodes().contains(IDUtils.toString((Object)e))) {
                notInGraphSet.add(e);
            }
        });
        Set reachableNodeSet = ruleIdLongSet.stream().filter(e -> !notInGraphSet.contains(e)).map(item -> Graphs.reachableNodes((Graph)mutableGraph, (Object)ObjUtils.getString((Object)item))).flatMap(item -> item.stream()).collect(Collectors.toSet());
        MutableGraph subGraph = Graphs.inducedSubgraph((Graph)mutableGraph, reachableNodeSet);
        RelationGraphNodePojoTree relationGraphNodePojoTree = RelationGraphUtils.getRelationGraphNodePojoTree((MutableGraph<String>)subGraph);
        List ruldIdStringList = ruleIdLongCollection.stream().map(item -> ObjUtils.getString((Object)item)).collect(Collectors.toList());
        Comparator<RelationGraphNodePojoTree> relationGraphNodePojoTreeComparator = Comparator.comparing(RelationGraphNodePojoTree::getDeepInteger).thenComparing(item -> {
            int indexInt = ruldIdStringList.indexOf(item.getCurrentString());
            if (indexInt < 0) {
                return Integer.MAX_VALUE;
            }
            return indexInt + 1;
        }).thenComparing(RelationGraphNodePojoTree::getOrderInteger);
        List<Long> sortedNodeIdLongList = RelationGraphUtils.getItemRelationGraphNodePojoTreeList(relationGraphNodePojoTree).stream().filter(item -> !"DEFAULT_ROOT_NODE_ID_STRING".equals(item.getCurrentString())).sorted(relationGraphNodePojoTreeComparator).map(item -> ObjUtils.getLong((Object)item.getCurrentString())).collect(Collectors.toList());
        sortedNodeIdLongList.addAll(notInGraphSet);
        return sortedNodeIdLongList;
    }

    public void createExecCaseByOrder(List<Long> bizRuleIds, Long model, Long bizModel) {
        if (CollectionUtils.isEmpty(bizRuleIds)) {
            throw new KDBizException(ResManager.loadKDString((String)"\u65e0\u53ef\u751f\u6210\u6267\u884c\u65b9\u6848\u7684\u89c4\u5219", (String)"RuleManagePlugin3_59", (String)"epm-eb-formplugin", (Object[])new Object[0]));
        }
        SimpleDateFormat sdf = new SimpleDateFormat("yyyyMMddHHmmss");
        String date = sdf.format(new Date());
        DynamicObject doj = BusinessDataServiceHelper.newDynamicObject((String)"eb_ruleexeccase");
        doj.set("id", (Object)GlobalIdUtil.genGlobalLongId());
        doj.set("number", (Object)("ZD-ORDER-" + date));
        doj.set("name", (Object)ResManager.loadKDString((String)"\u6309\u987a\u5e8f\u6267\u884c\u89c4\u5219", (String)"RuleManagePlugin3_60", (String)"epm-eb-formplugin", (Object[])new Object[0]));
        doj.set("model", (Object)model);
        doj.set("bizmodel", (Object)bizModel);
        doj.set("updatestatus", (Object)CaseUpdateStatusEnum.NONE.getCode());
        doj.set("type", (Object)RuleExecCaseTypeEnum.RULE.getCode());
        doj.set("currstep", (Object)ExecCaseWizardStepEnum.Rule.getNumber());
        doj.set("creator", (Object)RequestContext.getOrCreate().getCurrUserId());
        DynamicObjectCollection ruleEntity = doj.getDynamicObjectCollection("selectruleentity");
        for (Long ruleId : bizRuleIds) {
            DynamicObject childDoj = ruleEntity.addNew();
            childDoj.set("rulename", (Object)ruleId);
        }
        SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{doj});
    }

    public DynamicObject updateCaseStatus(Long caseId, CaseUpdateStatusEnum updateStatus, List<Long> sortedRuleId, Date beforeDate) {
        if (caseId == null || caseId == 0L) {
            return null;
        }
        DynamicObject doj = BusinessDataServiceHelper.loadSingle((Object)caseId, (String)"eb_ruleexeccase");
        if (doj == null) {
            return null;
        }
        doj.set("updatestatus", (Object)updateStatus.getCode());
        if (sortedRuleId != null) {
            DynamicObjectCollection entity = doj.getDynamicObjectCollection("selectruleentity");
            entity.clear();
            for (Long ruleId : sortedRuleId) {
                DynamicObject dynamicObject = entity.addNew();
                dynamicObject.set("rulename", (Object)ruleId);
            }
            doj.set("ruleupdatetime", (Object)TimeServiceHelper.now());
            SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm");
            String formattedDate = sdf.format(doj.getDate("ruleupdatetime"));
            long diffInSeconds = (doj.getDate("ruleupdatetime").getTime() - beforeDate.getTime() + 999L) / 1000L;
            doj.set("updatedetail", (Object)ResManager.loadResFormat((String)"\u66f4\u65b0\u65f6\u95f4\uff1a%1\uff0c\u8017\u65f6\uff1a%2s\u3002", (String)"RuleCase_49", (String)"epm-eb-formplugin", (Object[])new Object[]{formattedDate, diffInSeconds}));
        }
        Object[] save = SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{doj});
        return (DynamicObject)save[0];
    }

    public List<ExecuteVo> queryExecuteVos(List<Long> selectIds) {
        ArrayList<ExecuteVo> executeVos = new ArrayList<ExecuteVo>();
        QFilter qFilter = new QFilter("id", "in", selectIds);
        Map returnMap = BusinessDataServiceHelper.loadFromCache((String)"eb_bizruleset", (String)"datasetid,number,usescope,account,metric", (QFilter[])qFilter.toArray());
        if (returnMap != null) {
            Map ruleDtoMap = (Map)LambdaUtils.get(() -> {
                if (CollectionUtils.isEmpty((Collection)selectIds)) {
                    return Collections.emptyMap();
                }
                List ruleDtoList = RuleService.getInstance().listRule(new QFilter("id", "in", (Object)selectIds), Boolean.valueOf(false), null);
                if (CollectionUtils.isEmpty((Collection)ruleDtoList)) {
                    return Collections.emptyMap();
                }
                return ruleDtoList.stream().collect(Collectors.toMap(item -> item.getId(), item -> item));
            });
            for (Long selectId : selectIds) {
                DynamicObject doj = (DynamicObject)returnMap.get(selectId);
                if (doj == null) continue;
                ExecuteVo vo = new ExecuteVo();
                long ruleId = doj.getLong("id");
                vo.setRuleId(ruleId);
                RuleDto ruleDto = (RuleDto)ruleDtoMap.get(ruleId);
                if (ruleDto != null) {
                    vo.setRuleDto(ruleDto);
                }
                executeVos.add(vo);
            }
        }
        return executeVos;
    }

    public String setRecordCancelExecute(Long focusRowPkId) {
        DynamicObject record = BusinessDataServiceHelper.loadSingle((Object)focusRowPkId, (String)"eb_executecaserecord");
        String executestatus = record.getString("executestatus");
        ExecuteStatusEnum enumByIndex = ExecuteStatusEnum.getEnumByIndex(executestatus);
        if (enumByIndex == null) {
            return "";
        }
        if (ExecuteStatusEnum.SUCCESS.getIndex().equals(executestatus) || ExecuteStatusEnum.FAILED.getIndex().equals(executestatus) || ExecuteStatusEnum.PARTFAILED.getIndex().equals(executestatus)) {
            return ResManager.loadKDString((String)"\u975e\u6267\u884c\u4e2d\u7684\u8bb0\u5f55\u4e0d\u5141\u8bb8\u4fee\u6539\u4e3a\u53d6\u6d88\u6267\u884c\u3002", (String)"ExecuteRuleServiceImpl_15", (String)"epm-eb-formplugin", (Object[])new Object[]{enumByIndex.getName()});
        }
        record.set("cancelor", (Object)UserUtils.getUserId());
        record.set("executestatus", (Object)ExecuteStatusEnum.CANCEL.getIndex());
        SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{record});
        return null;
    }
}

