/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.formplugin.ruleexec.service;

import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.dlock.DLock;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.TimeServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.epm.eb.common.cache.IModelCacheHelper;
import kd.epm.eb.common.cache.ModelCacheContext;
import kd.epm.eb.common.cache.impl.Member;
import kd.epm.eb.common.enums.SysDimensionEnum;
import kd.epm.eb.common.enums.status.DetailRuleExecStatusEnum;
import kd.epm.eb.common.enums.status.ReportRuleExecStatusEnum;
import kd.epm.eb.common.report.ruleexec.RuleCaseExecExceptionHelper;
import kd.epm.eb.common.utils.CollectionUtils;
import kd.epm.eb.common.utils.IDUtils;
import kd.epm.eb.common.utils.UserUtils;
import kd.epm.eb.common.utils.base.JsonUtils;
import kd.epm.eb.formplugin.report.excel.controller.ReportExportDataController;
import kd.epm.eb.formplugin.ruleexec.entity.RuleExecLog;
import kd.epm.eb.formplugin.ruleexec.entity.RuleRow;
import kd.epm.eb.formplugin.ruleexec.enums.TaskLogTypeEnum;
import kd.epm.eb.formplugin.ruleexec.service.ReportRuleExecJobCacheHelper;
import kd.epm.eb.spread.report.ruleexec.entity.request.ReportRuleExecRequest;
import kd.epm.eb.spread.report.ruleexec.entity.request.ReportRuleTaskRequest;
import org.apache.commons.lang3.StringUtils;

public class RuleExecLogService {
    private static final Log log = LogFactory.getLog(RuleExecLogService.class);
    private static final RuleExecLogService taskLogService = new RuleExecLogService();
    public static final long fileDeleteTimeout = 172800000L;
    private static final long lockTryTime = 5000L;
    public static final Set<String> canCancelStatus = Sets.newHashSet((Object[])new String[]{ReportRuleExecStatusEnum.EXEC_ING.getCode(), ReportRuleExecStatusEnum.QUEUE.getCode()});

    public static RuleExecLogService getInstance() {
        return taskLogService;
    }

    private RuleExecLogService() {
    }

    public Set<Long> getCanCancelTaskLogIds(Set<Long> taskLogIds) {
        HashSet<Long> result = new HashSet<Long>(16);
        DynamicObjectCollection query = QueryServiceHelper.query((String)"eb_ruleexeccaselog", (String)"id, status", (QFilter[])new QFilter[]{new QFilter("id", "in", taskLogIds)});
        for (DynamicObject dynamicObject : query) {
            String status = dynamicObject.getString("status");
            if (!canCancelStatus.contains(status)) continue;
            result.add(dynamicObject.getLong("id"));
        }
        return result;
    }

    public void cancelTaskLogs(Set<Long> taskLogIds) {
        Map<Long, Integer> canceledQueueIdCountMap = this.cancelTaskLogsStatus(taskLogIds);
        this.cancelTaskLogsOrder(canceledQueueIdCountMap);
        RuleCaseExecExceptionHelper.getInstance().cacheCancelTaskLogIds(taskLogIds);
    }

    public Map<Long, Integer> cancelTaskLogsStatus(Set<Long> taskLogIds) {
        HashMap<Long, Integer> canceledQueueIdCountMap = new HashMap<Long, Integer>(16);
        if (CollectionUtils.isEmpty(taskLogIds)) {
            return canceledQueueIdCountMap;
        }
        QFilter qFilter = new QFilter("id", "in", taskLogIds);
        qFilter.and("status", "in", canCancelStatus);
        DynamicObjectCollection query = QueryServiceHelper.query((String)"eb_ruleexeccaselog", (String)"id, status,queueid", (QFilter[])qFilter.toArray());
        if (CollectionUtils.isEmpty((Collection)query)) {
            throw new KDBizException(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u72b6\u6001\u4e3a\u201c\u6b63\u5728\u5bfc\u51fa\u201d\u6216\u201c\u6392\u961f\u4e2d\u201d\u7684\u6267\u884c\u8bb0\u5f55\u3002", (String)"RuleCase_50", (String)"epm-eb-formplugin", (Object[])new Object[0]));
        }
        String updateSql = "update t_eb_ruleexeccaselog set fstatus = ?, forder = 0,fmodifier = ?, fenddate = ? where fid = ? and fstatus in ('0', '6') ";
        ArrayList<Object[]> paramsList = new ArrayList<Object[]>(16);
        long userId = UserUtils.getUserId();
        Date now = TimeServiceHelper.now();
        for (DynamicObject dynamicObject : query) {
            Object[] paramArray = new Object[4];
            long id = dynamicObject.getLong("id");
            paramArray[3] = id;
            String status = dynamicObject.getString("status");
            if (ReportRuleExecStatusEnum.QUEUE.getCode().equalsIgnoreCase(status)) {
                paramArray[0] = ReportRuleExecStatusEnum.EXEC_CANCEL_END.getCode();
                Long queueid = dynamicObject.getLong("queueid");
                Integer count = (Integer)canceledQueueIdCountMap.get(queueid);
                if (count == null) {
                    count = 1;
                } else {
                    Integer n = count;
                    Integer n2 = count = Integer.valueOf(count + 1);
                }
                canceledQueueIdCountMap.put(queueid, count);
            } else if (ReportRuleExecStatusEnum.EXEC_ING.getCode().equalsIgnoreCase(status)) {
                paramArray[0] = ReportRuleExecStatusEnum.EXEC_CANCEL_ING.getCode();
            }
            paramArray[1] = userId;
            paramArray[2] = now;
            paramsList.add(paramArray);
        }
        if (CollectionUtils.isNotEmpty(paramsList)) {
            DB.executeBatch((DBRoute)DBRoute.of((String)"epm"), (String)updateSql, paramsList);
        }
        return canceledQueueIdCountMap;
    }

    private void cancelTaskLogsOrder(Map<Long, Integer> canceledQueueIdCountMap) {
        block21: {
            try (DLock lock = DLock.create((String)("eb/taskLogServiceUpdateQueue/" + ReportExportDataController.currentQueueId));){
                if (lock.tryLock(5000L)) {
                    if (canceledQueueIdCountMap == null || canceledQueueIdCountMap.size() == 0) {
                        return;
                    }
                    ArrayList<Object[]> params = new ArrayList<Object[]>(16);
                    for (Map.Entry<Long, Integer> entry : canceledQueueIdCountMap.entrySet()) {
                        Long queueId = entry.getKey();
                        Integer count = entry.getValue();
                        HashSet<Integer> hasNewOrders = new HashSet<Integer>(16);
                        QFilter qFilter = new QFilter("queueid", "=", (Object)queueId);
                        qFilter.and("status", "!=", (Object)ReportRuleExecStatusEnum.EXEC_CANCEL_ING.getCode());
                        DynamicObjectCollection taskLogs = QueryServiceHelper.query((String)"eb_ruleexeccaselog", (String)"order, id, model,message, executor", (QFilter[])new QFilter[]{qFilter}, (String)"order");
                        if (!CollectionUtils.isNotEmpty((Collection)taskLogs)) continue;
                        Date now = TimeServiceHelper.now();
                        long userId = UserUtils.getUserId();
                        for (DynamicObject taskLog : taskLogs) {
                            int newOrder;
                            int order = taskLog.getInt("order");
                            long id = taskLog.getLong("id");
                            Object[] param = new Object[4];
                            int n = newOrder = order - count <= 0 ? 1 : order - count;
                            if (hasNewOrders.contains(newOrder)) {
                                ++newOrder;
                            }
                            hasNewOrders.add(newOrder);
                            param[0] = newOrder;
                            param[1] = now;
                            param[2] = userId;
                            param[3] = id;
                            params.add(param);
                            String message = taskLog.getString("message");
                            long model = taskLog.getLong("model");
                            long creater = taskLog.getLong("executor");
                            this.clearTaskLogCache(message, model, id, creater);
                        }
                    }
                    if (CollectionUtils.isNotEmpty(params)) {
                        String updateSql = "update t_eb_ruleexeccaselog set forder = ?, fenddate = ?, fmodifier = ?  where fid = ? and fstatus = '6' ";
                        DB.executeBatch((DBRoute)DBRoute.of((String)"epm"), (String)updateSql, params);
                    }
                    break block21;
                }
                throw new KDBizException(ResManager.loadKDString((String)"\u7cfb\u7edf\u7e41\u5fd9\uff0c\u8bf7\u7a0d\u540e\u518d\u8bd5\u3002", (String)"RuleCase_51", (String)"epm-eb-formplugin", (Object[])new Object[0]));
            }
        }
    }

    public void clearTaskLogCache(String message, Long modelId, Long id, Long createrId) {
        if (StringUtils.isNotEmpty((CharSequence)message)) {
            ReportRuleExecJobCacheHelper.remove(ReportRuleExecJobCacheHelper.getRuleCaseExecJobInfoCacheKey(modelId), message);
        }
    }

    public void updateTaskLogOrderInQueue() {
        block15: {
            try (DLock lock = DLock.create((String)("eb/taskLogServiceUpdateQueue/" + ReportExportDataController.currentQueueId));){
                if (lock.tryLock(5000L)) {
                    int index = 1;
                    String sql = "update t_eb_ruleexeccaselog set forder = ?, fenddate = ?, fmodifier = ?  where fid = ?";
                    ArrayList<Object[]> params = new ArrayList<Object[]>(16);
                    QFilter qFilter = new QFilter("status", "=", (Object)ReportRuleExecStatusEnum.QUEUE.getCode());
                    qFilter.and("queueid", "=", (Object)ReportExportDataController.currentQueueId);
                    DynamicObjectCollection query = QueryServiceHelper.query((String)"eb_ruleexeccaselog", (String)"id", (QFilter[])new QFilter[]{qFilter}, (String)"order");
                    Date now = TimeServiceHelper.now();
                    long userId = UserUtils.getUserId();
                    for (DynamicObject dynamicObject : query) {
                        Object[] param = new Object[]{index, now, userId, dynamicObject.getLong("id")};
                        params.add(param);
                        ++index;
                    }
                    if (CollectionUtils.isNotEmpty(params)) {
                        DB.executeBatch((DBRoute)DBRoute.of((String)"epm"), (String)sql, params);
                    }
                    break block15;
                }
                throw new KDBizException(ResManager.loadKDString((String)"\u7cfb\u7edf\u7e41\u5fd9\uff0c\u8bf7\u7a0d\u540e\u518d\u8bd5\u3002", (String)"RuleCase_51", (String)"epm-eb-formplugin", (Object[])new Object[0]));
            }
        }
    }

    public void updateTaskLogOrder(Long taskLogId, int order) {
        if (IDUtils.isNotEmptyLong((Long)taskLogId).booleanValue()) {
            String sql = "update t_eb_ruleexeccaselog set forder = ?, fenddate = ?, fmodifier = ? where fid = ?";
            Object[] param = new Object[]{order, TimeServiceHelper.now(), UserUtils.getUserId(), taskLogId};
            DB.execute((DBRoute)DBRoute.of((String)"epm"), (String)sql, (Object[])param);
        }
    }

    public void updateExecStatus(Long logId, String url, String status, String message) {
        DynamicObject doj;
        if (IDUtils.isNotEmptyLong((Long)logId).booleanValue() && (doj = BusinessDataServiceHelper.loadSingle((Object)logId, (String)"eb_ruleexeccaselog")) != null) {
            if (!ReportRuleExecStatusEnum.EXEC_CANCEL_ING.getCode().equalsIgnoreCase(doj.getString("status")) || !ReportRuleExecStatusEnum.EXEC_END.getCode().equals(status)) {
                if (ReportRuleExecStatusEnum.EXEC_END.getCode().equals(status)) {
                    doj.set("progress", (Object)"100%");
                }
                if (StringUtils.isNotBlank((CharSequence)status)) {
                    doj.set("status", (Object)status);
                }
            }
            if (StringUtils.isNotBlank((CharSequence)message)) {
                doj.set("log", (Object)message);
            }
            SaveServiceHelper.update((DynamicObject)doj);
        }
    }

    public void updateExecLogProgress(Long logId, String progress) {
        DynamicObject dynamicObject;
        if (IDUtils.isNotEmptyLong((Long)logId).booleanValue() && (dynamicObject = BusinessDataServiceHelper.loadSingle((Object)logId, (String)"eb_ruleexeccaselog")) != null && StringUtils.isNotBlank((CharSequence)progress)) {
            dynamicObject.set("progress", (Object)progress);
            SaveServiceHelper.update((DynamicObject)dynamicObject);
        }
    }

    public Long createCronJonLog(long modelId, String caseNumber) {
        RuleExecLog ruleExecLog = new RuleExecLog();
        ruleExecLog.setModelId(modelId);
        ruleExecLog.setCaseName(caseNumber);
        ruleExecLog.setTaskLogTypeEnum(TaskLogTypeEnum.corn_job_exec);
        return ruleExecLog.create();
    }

    public Long createJonLog(long modelId, String caseName) {
        Throwable throwable = null;
        try (DLock lock = DLock.create((String)("eb/taskLogServiceUpdateQueue/" + ReportExportDataController.currentQueueId));){
            if (lock.tryLock(5000L)) {
                Integer order = this.getOrder(ReportExportDataController.currentQueueId);
                RuleExecLog ruleExecLog = new RuleExecLog();
                ruleExecLog.setModelId(modelId);
                ruleExecLog.setCaseName(caseName);
                ruleExecLog.setTaskLogTypeEnum(TaskLogTypeEnum.job_exec);
                ruleExecLog.setQueueId(ReportExportDataController.currentQueueId);
                ruleExecLog.setTaskLogTypeEnum(TaskLogTypeEnum.job_exec);
                if (order != null) {
                    ruleExecLog.setOrder(order);
                }
                Long l = ruleExecLog.create();
                return l;
            }
            try {
                throw new KDBizException(ResManager.loadKDString((String)"\u7cfb\u7edf\u7e41\u5fd9\uff0c\u8bf7\u7a0d\u540e\u518d\u8bd5\u3002", (String)"RuleCase_51", (String)"epm-eb-formplugin", (Object[])new Object[0]));
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
        }
    }

    public ReportRuleTaskRequest createReportRuleTaskRequest(Long modelId, List<ReportRuleExecRequest> reportRuleExecRequest, long timeout) {
        Long logId = this.createTaskLog(modelId, reportRuleExecRequest, ReportExportDataController.currentQueueId, timeout);
        return new ReportRuleTaskRequest(reportRuleExecRequest.get(0).getModelId(), logId, reportRuleExecRequest);
    }

    public Long createTaskLog(Long modelId, List<ReportRuleExecRequest> reportRuleExecRequests, Long currentQueueId, long timeout) {
        IModelCacheHelper modelCache = ModelCacheContext.getOrCreate((Long)modelId);
        Throwable throwable = null;
        try (DLock lock = DLock.create((String)("eb/taskLogServiceUpdateQueue/" + currentQueueId));){
            if (lock.tryLock(5000L)) {
                Integer order = this.getOrder(currentQueueId);
                ReportRuleExecRequest reportRuleExecRequest = reportRuleExecRequests.get(0);
                RuleExecLog ruleExecLog = new RuleExecLog();
                ruleExecLog.setModelId(reportRuleExecRequest.getModelId());
                ruleExecLog.setTemplate(reportRuleExecRequest.getTemplate());
                Long viewId = 0L;
                Map viewMap = reportRuleExecRequest.getViewMap();
                String entityNumber = SysDimensionEnum.Entity.getNumber();
                if (viewMap != null && viewMap.containsKey(entityNumber)) {
                    viewId = (Long)viewMap.get(entityNumber);
                }
                Long bizModelId = reportRuleExecRequest.getBizModelId();
                Member member = modelCache.getMemberByAnyView(bizModelId, entityNumber, reportRuleExecRequest.getEntityId());
                ruleExecLog.setExecEntity(member.getNumber() + "-" + member.getName());
                ruleExecLog.setReportProcessId(reportRuleExecRequest.getReportProcessId());
                ruleExecLog.setQueueId(currentQueueId);
                ruleExecLog.setMessage(reportRuleExecRequest.hashCode() + "");
                ruleExecLog.setTaskLogTypeEnum(TaskLogTypeEnum.report_exec);
                if (order != null) {
                    ruleExecLog.setOrder(order);
                }
                Long l = ruleExecLog.create();
                return l;
            }
            try {
                throw new KDBizException(ResManager.loadKDString((String)"\u7cfb\u7edf\u7e41\u5fd9\uff0c\u8bf7\u7a0d\u540e\u518d\u8bd5\u3002", (String)"RuleCase_51", (String)"epm-eb-formplugin", (Object[])new Object[0]));
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
        }
    }

    private Integer getOrder(Long currentQueueId) {
        QFilter qFilter = new QFilter("status", "=", (Object)ReportRuleExecStatusEnum.QUEUE.getCode());
        qFilter.and("queueid", "=", (Object)currentQueueId);
        DynamicObjectCollection query = QueryServiceHelper.query((String)"eb_ruleexeccaselog", (String)"order", (QFilter[])qFilter.toArray(), (String)"order desc");
        Integer order = null;
        if (CollectionUtils.isNotEmpty((Collection)query)) {
            order = ((DynamicObject)query.get(0)).getInt("order") + 1;
        }
        return order;
    }

    public Long createDetailLog(Long taskLogId, RuleRow ruleRow, int execseq, String detailLog) {
        DynamicObject doj = BusinessDataServiceHelper.newDynamicObject((String)"eb_rulecaselogdetaill");
        doj.set("traceid", (Object)RequestContext.getOrCreate().getTraceId());
        doj.set("mainlog", (Object)taskLogId);
        doj.set("bizrule", (Object)ruleRow.getRuleDto().getNumber());
        doj.set("execseq", (Object)execseq);
        doj.set("status", (Object)DetailRuleExecStatusEnum.EXEC_ING.getCode());
        doj.set("detaillog", (Object)detailLog);
        Object[] savez = SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{doj});
        return ((DynamicObject)savez[0]).getLong("id");
    }

    public void updateDetailLogStatus(Long detailLogId, Map<String, Set<String>> realExecRange) {
        DynamicObject doj = BusinessDataServiceHelper.loadSingle((Object)detailLogId, (String)"eb_rulecaselogdetaill");
        doj.set("execrange", (Object)JsonUtils.getJsonString(realExecRange));
        SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{doj});
    }

    public void updateDetailLogStatus(Long detailLogId, DetailRuleExecStatusEnum statusEnum, String detailLog) {
        DynamicObject doj = BusinessDataServiceHelper.loadSingle((Object)detailLogId, (String)"eb_rulecaselogdetaill");
        doj.set("status", (Object)statusEnum.getCode());
        doj.set("detaillog", (Object)detailLog);
        SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{doj});
    }
}

