/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.formplugin.ruleexec.task;

import com.google.common.graph.MutableGraph;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.exception.KDBizException;
import kd.bos.exception.KDException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.schedule.executor.AbstractTask;
import kd.bos.servicehelper.TimeServiceHelper;
import kd.epm.eb.business.bizrule.entity.GraphNode;
import kd.epm.eb.formplugin.dataModelTrans.util.DataModelUtil;
import kd.epm.eb.formplugin.ruleexec.entity.RuleExecGenCaseRequest;
import kd.epm.eb.formplugin.ruleexec.enums.CaseUpdateStatusEnum;
import kd.epm.eb.formplugin.ruleexec.service.RuleCaseService;

public class RuleExecGenCaseTask
extends AbstractTask {
    private static final Log log = LogFactory.getLog(RuleExecGenCaseTask.class);

    public void execute(RequestContext requestContext, Map<String, Object> map) throws KDException {
        HashMap<String, String> returnData = new HashMap<String, String>(16);
        try {
            if (map == null) {
                this.feedbackProgress(100);
                return;
            }
            Object requestStr = map.get("request");
            if (requestStr == null) {
                this.feedbackProgress(100);
                return;
            }
            RuleExecGenCaseRequest request = (RuleExecGenCaseRequest)SerializationUtils.deSerializeFromBase64((String)((String)requestStr));
            Date now = TimeServiceHelper.now();
            this.updateCaseStatus(request, CaseUpdateStatusEnum.UPDATE_ING);
            try {
                if (this.taskId != null) {
                    this.feedbackProgress(0, ResManager.loadKDString((String)"\u6b63\u5728\u751f\u6210\u5173\u8054\u4e1a\u52a1\u89c4\u5219\uff0c\u65f6\u95f4\u53ef\u80fd\u8f83\u957f\uff0c\u5efa\u8bae\u8f6c\u5165\u540e\u53f0\u8fd0\u884c\u3002", (String)"RuleCase_54", (String)"epm-eb-formplugin", (Object[])new Object[0]), null);
                }
                MutableGraph<GraphNode> resultGraph = RuleCaseService.getInstance().genGraph(request);
                List<Long> sortedRuleId = RuleCaseService.getInstance().getSortedRuleId(resultGraph);
                returnData.put("status", "true");
                DynamicObject dynamicObject = RuleCaseService.getInstance().updateCaseStatus(request.getCaseId(), CaseUpdateStatusEnum.UPDATE_END, sortedRuleId, now);
                DynamicObjectCollection selectruleentity = dynamicObject.getDynamicObjectCollection("selectruleentity");
                returnData.put("result", SerializationUtils.serializeToBase64(sortedRuleId));
                returnData.put("result2", SerializationUtils.serializeToBase64((Object)selectruleentity));
                if (this.taskId != null) {
                    this.feedbackProgress(100);
                }
                Thread.sleep(0L);
            }
            catch (Exception | StackOverflowError e) {
                this.updateCaseStatus(request, CaseUpdateStatusEnum.UPDATE_FAIL);
                DataModelUtil.doLog("genError exception.", log);
                returnData.put("status", "failed");
                returnData.put("result", e.getMessage());
                log.error(e);
            }
        }
        catch (KDBizException e) {
            returnData.put("status", "failed");
            returnData.put("result", e.getMessage());
        }
        if (this.taskId != null) {
            this.feedbackCustomdata(returnData);
        }
    }

    private void updateCaseStatus(RuleExecGenCaseRequest request, CaseUpdateStatusEnum updateIng) {
        try {
            RuleCaseService.getInstance().updateCaseStatus(request.getCaseId(), updateIng, null, null);
        }
        catch (Exception e) {
            log.error((Throwable)e);
            throw new KDBizException(ResManager.loadResFormat((String)"\u66f4\u65b0\u65b9\u6848\u5931\u8d25,\u53ef\u80fd\u65b9\u6848\u5df2\u88ab\u5220\u9664,\u8bf7\u91cd\u8bd5\u6216\u8054\u7cfb\u7ba1\u7406\u5458\u5904\u7406\u3002", (String)"RuleCase_67", (String)"epm-eb-formplugin", (Object[])new Object[0]));
        }
    }
}

