/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.formplugin.rulemanage;

import com.google.common.graph.Graph;
import com.google.common.graph.MutableGraph;
import java.util.ArrayList;
import java.util.Collection;
import java.util.EventObject;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.exception.KDBizException;
import kd.bos.form.IFormView;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.form.field.ComboEdit;
import kd.bos.form.field.ComboItem;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.epm.eb.business.DimensionView.ViewMemberUpgradeService;
import kd.epm.eb.business.bizrule.RuleGraphService;
import kd.epm.eb.business.bizrule.entity.GraphNode;
import kd.epm.eb.common.orm.EbBizruleset;
import kd.epm.eb.common.pojo.ReportProcessPojo;
import kd.epm.eb.common.rule.edit.RuleManageRowPojo;
import kd.epm.eb.common.rule.relation.graph.RelationGraphDataPojo;
import kd.epm.eb.common.utils.BusinessModelServiceHelper;
import kd.epm.eb.common.utils.CommonServiceHelper;
import kd.epm.eb.common.utils.base.JsonUtils;
import kd.epm.eb.common.utils.base.LambdaUtils;
import kd.epm.eb.common.utils.base.ObjUtils;
import kd.epm.eb.common.utils.base.OrmBuilder;
import kd.epm.eb.common.utils.base.StrUtils;
import kd.epm.eb.common.utils.base.ThrowableUtils;
import kd.epm.eb.formplugin.AbstractListPlugin;
import kd.epm.eb.formplugin.rulemanage.RelationGraphService;
import kd.epm.eb.formplugin.rulemanage.RelationGraphUtils;
import kd.epm.eb.formplugin.rulemanage.RuleManageQueryOp;
import kd.epm.eb.formplugin.rulemanage.utils.RuleUtils;
import kd.epm.eb.formplugin.unitupdate.UpdateUtils;
import kd.epm.eb.formplugin.unitupdate.pojo.UpdateItemPojo;
import kd.epm.eb.formplugin.unitupdate.pojo.UpdatePojo;
import kd.epm.eb.formplugin.unitupdate.unitdata.UnitDataUtils;
import kd.epm.eb.olap.impl.bizrule.RuleService;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;

public class RelationGraphConsolePlugin
extends AbstractListPlugin {
    private static final Log log = LogFactory.getLog(RelationGraphConsolePlugin.class);
    public static final String eb_relation_graph_console = "eb_relation_graph_console";
    public static final String toolbarap = "toolbarap";
    public static final String by_string_advcontoolbarap = "by_string_advcontoolbarap";
    public static final String by_model_advcontoolbarap = "by_model_advcontoolbarap";
    public static final String btn_exit = "btn_exit";
    public static final String by_string_textareafield = "by_string_textareafield";
    public static final String by_string_advconbaritemap = "by_string_advconbaritemap";
    public static final String model = "model";
    public static final String model2 = "model2";
    public static final String by_model_advconbaritemap = "by_model_advconbaritemap";
    public static final String biz_model = "biz_model";
    public static final String report_process_json_map = "report_process_json_map";
    public static final String get_report_process_json = "get_report_process_json";
    public static final String clear_report_process_json = "clear_report_process_json";
    public static final String report_process_json = "report_process_json";
    public static final String check_error_rule = "check_error_rule";
    public static final String viewmemberupgrade = "viewmemberupgrade";
    public static final String disable_rule = "disable_rule";
    public static final String delete_rule = "delete_rule";
    public static final String bizrule = "bizrule";
    public static final String rule_advcontoolbarap = "rule_advcontoolbarap";
    public static final String mul_model = "mul_model";
    public static final String mul_model_json_map = "mul_model_json_map";
    public static final String asyncviewmemberupgrade = "asyncviewmemberupgrade";
    public static final String unit_model_update = "unit_model_update";
    public static final String async_unit_model_update = "async_unit_model_update";

    @Override
    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addItemClickListeners(new String[]{toolbarap, by_string_advcontoolbarap, by_model_advcontoolbarap, report_process_json_map, rule_advcontoolbarap, mul_model_json_map});
    }

    public void itemClick(ItemClickEvent evt) {
        try {
            String itemKeyString;
            super.itemClick(evt);
            switch (itemKeyString = evt.getItemKey()) {
                case "btn_exit": {
                    this.getView().close();
                    break;
                }
                case "by_string_advconbaritemap": {
                    LambdaUtils.run(() -> {
                        String graphString = (String)this.getModel().getValue(by_string_textareafield);
                        if (StringUtils.isBlank((CharSequence)graphString)) {
                            return;
                        }
                        RelationGraphDataPojo relationGraphDataPojo = RelationGraphUtils.getRelationGraphDataPojoByGraphLogString(graphString);
                        RelationGraphUtils.openRelationGraph(this.getView(), relationGraphDataPojo);
                    });
                    break;
                }
                case "by_model_advconbaritemap": {
                    LambdaUtils.run(() -> {
                        try {
                            String bizModelIdString = (String)this.getModel().getValue(biz_model);
                            if (StringUtils.isBlank((CharSequence)bizModelIdString)) {
                                throw new KDBizException(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u4e1a\u52a1\u7ba1\u63a7\u8303\u56f4\u3002", (String)"RelationGraphConsolePlugin_1", (String)"epm-eb-formplugin", (Object[])new Object[0]));
                            }
                            Long bizModelIdLong = ObjUtils.getLong((Object)bizModelIdString);
                            MutableGraph graph = RuleGraphService.getInstance().getDagGraphByBizmodel(bizModelIdLong.longValue());
                            RelationGraphDataPojo relationGraphDataPojo = RelationGraphService.getRelationGraphDataPojo((Graph<GraphNode>)graph);
                            RelationGraphUtils.openRelationGraph(this.getView(), relationGraphDataPojo);
                        }
                        catch (Throwable throwable) {
                            this.getView().showTipNotification(ThrowableUtils.getMessageString((Throwable)throwable));
                            log.error(throwable);
                        }
                    });
                    break;
                }
                case "get_report_process_json": {
                    LambdaUtils.run(() -> {
                        DynamicObject modelDynamicObject = (DynamicObject)this.getModel().getValue(model2);
                        if (modelDynamicObject == null) {
                            throw new KDBizException(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u4f53\u7cfb", (String)"RelationGraphConsolePlugin_2", (String)"epm-eb-formplugin", (Object[])new Object[0]));
                        }
                        List<ReportProcessPojo> reportProcessPojoList = RelationGraphService.getReportProcessPojoListFromCache(modelDynamicObject.getLong("id"));
                        this.getModel().setValue(report_process_json, (Object)JsonUtils.getJsonString(reportProcessPojoList, (boolean)true));
                        this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u6210\u529f", (String)"RelationGraphConsolePlugin_5", (String)"epm-eb-formplugin", (Object[])new Object[0]));
                    });
                }
                case "clear_report_process_json": {
                    LambdaUtils.run(() -> {
                        DynamicObject modelDynamicObject = (DynamicObject)this.getModel().getValue(model2);
                        if (modelDynamicObject == null) {
                            throw new KDBizException(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u4f53\u7cfb", (String)"RelationGraphConsolePlugin_2", (String)"epm-eb-formplugin", (Object[])new Object[0]));
                        }
                        RelationGraphService.clearReportProcessPojoListFromCache(modelDynamicObject.getLong("id"));
                        this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u6210\u529f", (String)"RelationGraphConsolePlugin_5", (String)"epm-eb-formplugin", (Object[])new Object[0]));
                    });
                    break;
                }
                case "check_error_rule": {
                    LambdaUtils.run(() -> {
                        DynamicObject modelDynamicObject = (DynamicObject)this.getModel().getValue(model2);
                        if (modelDynamicObject == null) {
                            throw new KDBizException(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u4f53\u7cfb", (String)"RelationGraphConsolePlugin_2", (String)"epm-eb-formplugin", (Object[])new Object[0]));
                        }
                        long modelIdLong = modelDynamicObject.getLong("id");
                        List ebBizrulesetList = OrmBuilder.clazz(EbBizruleset.class).field(new String[]{"fid", "fnumber", "fstatus", "fbizctrlrangeid"}).whereEqual("fmodel", (Object)modelIdLong).toRowList();
                        LinkedList<String> errorMessageStringList = new LinkedList<String>();
                        LinkedList<Long> tempRuleIdLongList = new LinkedList<Long>();
                        for (EbBizruleset ebBizruleset : ebBizrulesetList) {
                            tempRuleIdLongList.clear();
                            tempRuleIdLongList.add(ebBizruleset.getIdLong());
                            try {
                                List<RuleManageRowPojo> ruleManageRowPojoList = RuleManageQueryOp.getRuleManageRowPojoList(tempRuleIdLongList);
                                if (CollectionUtils.isEmpty(ruleManageRowPojoList)) {
                                    errorMessageStringList.add(StrUtils.format((String)"{} {} {} {} {} {}", (Object[])new Object[]{"VIEW", ebBizruleset.getIdLong(), ebBizruleset.getNumberString(), ebBizruleset.getStatusString(), ebBizruleset.getBizctrlrangeidLong(), "Not exist"}));
                                }
                            }
                            catch (Throwable throwable) {
                                errorMessageStringList.add(StrUtils.format((String)"{} {} {} {} {} {}", (Object[])new Object[]{"VIEW_ERROR", ebBizruleset.getIdLong(), ebBizruleset.getNumberString(), ebBizruleset.getStatusString(), ebBizruleset.getBizctrlrangeidLong(), throwable}));
                            }
                            try {
                                List ruleDtoList = RuleService.getInstance().listRule(null, null, tempRuleIdLongList);
                                if (!CollectionUtils.isEmpty((Collection)ruleDtoList)) continue;
                                errorMessageStringList.add(StrUtils.format((String)"{} {} {} {} {} {}", (Object[])new Object[]{"GRAPH", ebBizruleset.getIdLong(), ebBizruleset.getNumberString(), ebBizruleset.getStatusString(), ebBizruleset.getBizctrlrangeidLong(), "Not exist"}));
                            }
                            catch (Throwable throwable) {
                                errorMessageStringList.add(StrUtils.format((String)"{} {} {} {} {} {}", (Object[])new Object[]{"GRAPH_ERROR", ebBizruleset.getIdLong(), ebBizruleset.getNumberString(), ebBizruleset.getStatusString(), ebBizruleset.getBizctrlrangeidLong(), throwable}));
                            }
                        }
                        if (CollectionUtils.isEmpty(errorMessageStringList)) {
                            this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u672a\u53d1\u73b0\u5f02\u5e38\u6570\u636e", (String)"RelationGraphConsolePlugin_3", (String)"epm-eb-formplugin", (Object[])new Object[0]));
                            return;
                        }
                        throw new KDBizException(ResManager.loadResFormat((String)"\u5f02\u5e38\u6570\u636e\uff1a%1", (String)"RelationGraphConsolePlugin_4", (String)"epm-eb-formplugin", (Object[])new Object[]{JsonUtils.getJsonString(errorMessageStringList)}));
                    });
                    break;
                }
                case "viewmemberupgrade": {
                    LambdaUtils.run(() -> {
                        DynamicObjectCollection modelDynamicObjectCollection = (DynamicObjectCollection)this.getModel().getValue(mul_model);
                        if (modelDynamicObjectCollection == null || modelDynamicObjectCollection.isEmpty()) {
                            throw new KDBizException(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u4f53\u7cfb", (String)"RelationGraphConsolePlugin_2", (String)"epm-eb-formplugin", (Object[])new Object[0]));
                        }
                        List modelIdLongList = modelDynamicObjectCollection.stream().map(item -> item.getDynamicObject("fbasedataid").getLong("id")).collect(Collectors.toList());
                        ViewMemberUpgradeService.viewMemberUpgradeByPage(modelIdLongList, (IFormView)this.getView());
                        this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u6210\u529f", (String)"RelationGraphConsolePlugin_5", (String)"epm-eb-formplugin", (Object[])new Object[0]));
                    });
                    break;
                }
                case "disable_rule": {
                    LambdaUtils.run(() -> {
                        DynamicObjectCollection ruleDynamicObjectCollection = (DynamicObjectCollection)this.getModel().getValue(bizrule);
                        if (ruleDynamicObjectCollection == null || ruleDynamicObjectCollection.isEmpty()) {
                            throw new KDBizException("Please select.");
                        }
                        List<Long> ruldIdLongList = ruleDynamicObjectCollection.stream().map(item -> item.getDynamicObject("fbasedataid").getLong("id")).collect(Collectors.toList());
                        RuleUtils.cancelRelease(ruldIdLongList);
                        this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u6210\u529f", (String)"RelationGraphConsolePlugin_5", (String)"epm-eb-formplugin", (Object[])new Object[0]));
                    });
                    break;
                }
                case "asyncviewmemberupgrade": {
                    LambdaUtils.run(() -> {
                        DynamicObjectCollection modelDynamicObjectCollection = (DynamicObjectCollection)this.getModel().getValue(mul_model);
                        if (modelDynamicObjectCollection == null || modelDynamicObjectCollection.isEmpty()) {
                            throw new KDBizException(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u4f53\u7cfb", (String)"RelationGraphConsolePlugin_2", (String)"epm-eb-formplugin", (Object[])new Object[0]));
                        }
                        List modelIdLongList = modelDynamicObjectCollection.stream().map(item -> item.getDynamicObject("fbasedataid").getLong("id")).collect(Collectors.toList());
                        UpdatePojo updatePojo = new UpdatePojo();
                        LinkedList<UpdateItemPojo> updateItemPojoList = new LinkedList<UpdateItemPojo>();
                        updatePojo.setUpdateItemPojoList(updateItemPojoList);
                        for (Long modelIdLong : modelIdLongList) {
                            UpdateItemPojo updateItemPojo = new UpdateItemPojo();
                            updateItemPojo.setModelIdLong(modelIdLong);
                            updateItemPojoList.add(updateItemPojo);
                        }
                        UpdateUtils.update(updatePojo);
                        this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u6210\u529f", (String)"RelationGraphConsolePlugin_5", (String)"epm-eb-formplugin", (Object[])new Object[0]));
                    });
                    break;
                }
                case "unit_model_update": {
                    LambdaUtils.run(() -> {
                        Set<Long> modelIdLongSet = UnitDataUtils.getUnitModelIdLongSet();
                        UpdatePojo updatePojo = new UpdatePojo();
                        LinkedList<UpdateItemPojo> updateItemPojoList = new LinkedList<UpdateItemPojo>();
                        updatePojo.setUpdateItemPojoList(updateItemPojoList);
                        for (Long modelIdLong : modelIdLongSet) {
                            UpdateItemPojo updateItemPojo = new UpdateItemPojo();
                            updateItemPojo.setModelIdLong(modelIdLong);
                            updateItemPojoList.add(updateItemPojo);
                        }
                        UpdateUtils.update(updatePojo);
                        this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u6210\u529f", (String)"RelationGraphConsolePlugin_5", (String)"epm-eb-formplugin", (Object[])new Object[0]));
                    });
                    break;
                }
                case "async_unit_model_update": {
                    LambdaUtils.run(() -> {
                        Set<Long> modelIdLongSet = UnitDataUtils.getUnitModelIdLongSet();
                        UpdatePojo updatePojo = new UpdatePojo();
                        updatePojo.setAsyncBoolean(true);
                        LinkedList<UpdateItemPojo> updateItemPojoList = new LinkedList<UpdateItemPojo>();
                        updatePojo.setUpdateItemPojoList(updateItemPojoList);
                        for (Long modelIdLong : modelIdLongSet) {
                            UpdateItemPojo updateItemPojo = new UpdateItemPojo();
                            updateItemPojo.setModelIdLong(modelIdLong);
                            updateItemPojoList.add(updateItemPojo);
                        }
                        UpdateUtils.update(updatePojo);
                        this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u6210\u529f", (String)"RelationGraphConsolePlugin_5", (String)"epm-eb-formplugin", (Object[])new Object[0]));
                    });
                    break;
                }
                case "delete_rule": {
                    LambdaUtils.run(() -> {
                        DynamicObjectCollection ruleDynamicObjectCollection = (DynamicObjectCollection)this.getModel().getValue(bizrule);
                        if (ruleDynamicObjectCollection == null || ruleDynamicObjectCollection.isEmpty()) {
                            throw new KDBizException("Please select.");
                        }
                        List ruleIdLongList = ruleDynamicObjectCollection.stream().map(item -> item.getDynamicObject("fbasedataid").getLong("id")).collect(Collectors.toList());
                        DynamicObjectCollection query = QueryServiceHelper.query((String)"eb_bizruleset", (String)"id,status", (QFilter[])new QFilter[]{new QFilter("id", "in", ruleIdLongList)});
                        if (query.stream().anyMatch(e -> e.getBoolean("status"))) {
                            throw new KDBizException(ResManager.loadKDString((String)"\u6240\u9009\u89c4\u5219\u6709\u5df2\u53d1\u5e03\u7684\u89c4\u5219\uff0c\u8bf7\u5148\u7981\u7528\u5bf9\u5e94\u89c4\u5219\u518d\u5220\u9664\u3002", (String)"RelationGraphConsolePlugin_6", (String)"epm-eb-formplugin", (Object[])new Object[0]));
                        }
                        HashSet<Long> ruldIdLongSet = new HashSet<Long>(ruleIdLongList);
                        RuleUtils.deleteRule(ruldIdLongSet);
                        this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u6210\u529f", (String)"RelationGraphConsolePlugin_5", (String)"epm-eb-formplugin", (Object[])new Object[0]));
                    });
                    break;
                }
            }
        }
        catch (Exception e) {
            CommonServiceHelper.dealException((AbstractFormPlugin)this, (String)"RelationGraphConsolePlugin#itemClick", (Throwable)e);
        }
    }

    public void propertyChanged(PropertyChangedArgs e) {
        try {
            String nameString;
            switch (nameString = e.getProperty().getName()) {
                case "model": {
                    DynamicObject modelDynamicObject = (DynamicObject)this.getModel().getValue(model);
                    Long modelIdLong = modelDynamicObject.getLong("id");
                    ArrayList<ComboItem> comboItemList = new ArrayList<ComboItem>(16);
                    Map busModelsByModelIdMap = BusinessModelServiceHelper.getInstance().getBusModelsByModelId(modelIdLong);
                    for (DynamicObject busModelObjByDataset : busModelsByModelIdMap.values()) {
                        comboItemList.add(new ComboItem(new LocaleString(busModelObjByDataset.getString("name")), busModelObjByDataset.getString("id")));
                    }
                    ComboEdit comboEdit = (ComboEdit)this.getControl(biz_model);
                    comboEdit.setComboItems(comboItemList);
                    if (comboItemList.size() <= 0) break;
                    this.getModel().setValue(biz_model, (Object)((ComboItem)comboItemList.get(0)).getValue());
                    break;
                }
            }
        }
        catch (Exception ex) {
            CommonServiceHelper.dealException((AbstractFormPlugin)this, (String)"RelationGraphConsolePlugin#propertyChanged", (Throwable)ex);
        }
    }
}

