/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.formplugin.rulemanage;

import com.alibaba.fastjson.JSON;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.JsonNode;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.google.common.graph.Graph;
import com.google.common.graph.Graphs;
import com.google.common.graph.MutableGraph;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.TreeSet;
import java.util.stream.Collectors;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.exception.KDBizException;
import kd.bos.ext.form.control.CustomControl;
import kd.bos.form.CloseCallBack;
import kd.bos.form.IFormView;
import kd.bos.form.IPageCache;
import kd.bos.form.events.CustomEventArgs;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.epm.eb.business.bizrule.RuleGraphService;
import kd.epm.eb.business.bizrule.entity.GraphNode;
import kd.epm.eb.common.cache.IModelCacheHelper;
import kd.epm.eb.common.cache.ModelCacheContext;
import kd.epm.eb.common.cache.impl.BaseCache;
import kd.epm.eb.common.cache.impl.Dimension;
import kd.epm.eb.common.cache.impl.Member;
import kd.epm.eb.common.cache.propertycache.MemberPropCacheService;
import kd.epm.eb.common.cache.propertycache.entity.MemberPropCache;
import kd.epm.eb.common.ebcommon.common.util.ThrowableHelper;
import kd.epm.eb.common.enums.BgTaskStateEnum;
import kd.epm.eb.common.enums.ProcessTypeEnum;
import kd.epm.eb.common.enums.RangeEnum;
import kd.epm.eb.common.enums.SysDimensionEnum;
import kd.epm.eb.common.enums.ruleFunctionEnums.RuleFunctionEnum;
import kd.epm.eb.common.olapdao.AnalysisContext;
import kd.epm.eb.common.orm.EbRuleInstance;
import kd.epm.eb.common.orm.EbRuleInstanceDetail;
import kd.epm.eb.common.orm.EbTaskvariableset;
import kd.epm.eb.common.orm.EbTemplate;
import kd.epm.eb.common.pojo.CellPojo;
import kd.epm.eb.common.pojo.DimensionPojo;
import kd.epm.eb.common.pojo.DynamicEntryEntityPojo;
import kd.epm.eb.common.pojo.ElementPojo;
import kd.epm.eb.common.pojo.EvalPojo;
import kd.epm.eb.common.pojo.EventPojo;
import kd.epm.eb.common.pojo.MemberPojo;
import kd.epm.eb.common.pojo.MethodPojo;
import kd.epm.eb.common.pojo.OlapPojo;
import kd.epm.eb.common.pojo.ReportOrTaskPojo;
import kd.epm.eb.common.pojo.ReportProcessPojo;
import kd.epm.eb.common.pojo.StylePojo;
import kd.epm.eb.common.pojo.TemplatePojo;
import kd.epm.eb.common.reportprocess.entity.domain.ReportProcess;
import kd.epm.eb.common.reportprocess.entity.dto.ReportProcessQuote;
import kd.epm.eb.common.reportprocess.service.impl.ReportProcessQuoteService;
import kd.epm.eb.common.reportprocess.service.impl.ReportProcessServiceImpl;
import kd.epm.eb.common.rule.edit.FormulaPojo;
import kd.epm.eb.common.rule.edit.OpenRulePojo;
import kd.epm.eb.common.rule.relation.graph.RelationGraphDataPojo;
import kd.epm.eb.common.rule.relation.graph.RelationGraphLinkPojo;
import kd.epm.eb.common.rule.relation.graph.RelationGraphModelPojo;
import kd.epm.eb.common.rule.relation.graph.RelationGraphNodePojo;
import kd.epm.eb.common.rule.relation.graph.component.ContextmenuItemComponent;
import kd.epm.eb.common.rule.relation.graph.data.RelationGraphNodeDataAreaPojo;
import kd.epm.eb.common.rule.relation.graph.data.RelationGraphNodeDataCellPojo;
import kd.epm.eb.common.rule.relation.graph.data.RelationGraphNodeDataPojo;
import kd.epm.eb.common.rule.relation.graph.data.RelationGraphNodeDataRowPojo;
import kd.epm.eb.common.rule.relation.graph.ext.RelationGraphShowBoxParent;
import kd.epm.eb.common.rule.relation.graph.ext.RelationGraphShowBoxPojo;
import kd.epm.eb.common.rule.relation.pojo.RelationGraphActionPojo;
import kd.epm.eb.common.rule.relation.pojo.RelationGraphDataTrackingItemPojo;
import kd.epm.eb.common.rule.relation.pojo.RelationGraphDataTrackingPojo;
import kd.epm.eb.common.rule.relation.pojo.RelationGraphDataTrackingTypeEnum;
import kd.epm.eb.common.rule.relation.pojo.RelationGraphInteractionTypeEnum;
import kd.epm.eb.common.rule.relation.pojo.RelationGraphShowBoxTypeEnum;
import kd.epm.eb.common.rule.relation.pojo.RelationGraphTypeEnum;
import kd.epm.eb.common.rule.showbizrule.ReportShowBizRuleBo;
import kd.epm.eb.common.rule.showbizrule.ReportShowBizRuleMemberBo;
import kd.epm.eb.common.utils.base.CacheUtils;
import kd.epm.eb.common.utils.base.ElementUtils;
import kd.epm.eb.common.utils.base.EnumUtils;
import kd.epm.eb.common.utils.base.EventUtils;
import kd.epm.eb.common.utils.base.FrontUtils;
import kd.epm.eb.common.utils.base.JsonUtils;
import kd.epm.eb.common.utils.base.KdUtils;
import kd.epm.eb.common.utils.base.LambdaUtils;
import kd.epm.eb.common.utils.base.MapPlusUtils;
import kd.epm.eb.common.utils.base.ObjUtils;
import kd.epm.eb.common.utils.base.OlapUtils;
import kd.epm.eb.common.utils.base.OrmBuilder;
import kd.epm.eb.common.utils.base.StrUtils;
import kd.epm.eb.formplugin.rulemanage.RelationGraphPlugin;
import kd.epm.eb.formplugin.rulemanage.RelationGraphService2;
import kd.epm.eb.formplugin.rulemanage.RelationGraphUtils;
import kd.epm.eb.formplugin.rulemanage.RuleJsUtils;
import kd.epm.eb.formplugin.rulemanage.RuleManageQueryOp;
import kd.epm.eb.formplugin.rulemanage.dynamic.DynamicEntryEntityUtils;
import kd.epm.eb.formplugin.rulemanage.utils.RuleUtils;
import kd.epm.eb.formplugin.utils.ReportOpenUtil;
import kd.epm.eb.olap.impl.bizrule.RuleService;
import kd.epm.eb.olap.impl.bizrule.entity.RuleDto;
import kd.epm.eb.olap.service.ShowBizRuleUtils;
import kd.epm.eb.spread.template.ITemplateModel;
import kd.epm.eb.spread.template.TemplateModelJSONUtil;
import kd.epm.eb.spread.template.afix.serializer.FixtemplateSerializerUtil;
import kd.epm.eb.spread.template.dimension.IDimension;
import kd.epm.eb.spread.template.dimension.IDimensionMember;
import kd.epm.eb.spread.template.dimension.userdefinedproperty.PropertyEntry;
import kd.epm.eb.spread.template.dimension.userdefinedproperty.PropertyValueEntry;
import kd.epm.eb.spread.template.pagedim.IPageDimensionEntry;
import kd.epm.eb.spread.template.pagedim.pageprop.IPageDimPropEntry;
import kd.epm.eb.spread.template.viewpointdim.IViewPointDimensionEntry;
import kd.epm.eb.spread.utils.ReportVar.ReportVarUtil;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.collections4.MapUtils;
import org.apache.commons.lang3.BooleanUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.math.NumberUtils;
import org.apache.commons.lang3.tuple.Pair;

public class RelationGraphService {
    private static final Log log = LogFactory.getLog(RelationGraphService.class);
    public static final String CUSTOM_PARAM_MAP = "CUSTOM_PARAM_MAP";
    public static final String REPORT_NUMBER = "REPORT_NUMBER";
    public static final String TASK_NUMBER = "TASK_NUMBER";
    public static final String ANALYSIS_CONTEXT = "ANALYSIS_CONTEXT";
    public static final Set<String> NEED_HANDLE_MEMBER_FUNC_SET = Sets.newHashSet((Object[])new String[]{RuleFunctionEnum.YearValue.getName(), RuleFunctionEnum.RecognitionP.getName(), RuleFunctionEnum.RecognitionSP.getName(), RuleFunctionEnum.RecognitionPC.getName(), RuleFunctionEnum.Member.getName()});

    public static void openRelationGraphByRuleIdLong(IFormView formView, Long ruleIdLong) {
        RelationGraphModelPojo relationGraphModelPojo = RelationGraphService.getRelationGraphModelPojoByRuleIdLong(ruleIdLong);
        if (relationGraphModelPojo == null) {
            return;
        }
        relationGraphModelPojo.setDisableContextmenuBoolean(Boolean.valueOf(true));
        RelationGraphUtils.openRelationGraph(formView, relationGraphModelPojo);
    }

    public static RelationGraphModelPojo getRelationGraphModelPojoByRuleIdLong(Long ruleIdLong) {
        Map<Long, RuleDto> ruleDtoMap = RelationGraphService.getRuleDtoMap(ruleIdLong);
        if (MapUtils.isEmpty(ruleDtoMap)) {
            return null;
        }
        RelationGraphModelPojo relationGraphModelPojo = new RelationGraphModelPojo();
        relationGraphModelPojo.setFocusNodeIdString(ObjUtils.getString((Object)ruleIdLong));
        MutableGraph<GraphNode> graph = RuleGraphService.getInstance().getDagGraphByBizmodel(ruleDtoMap.get(ruleIdLong).getBizCtrlRangeId().longValue());
        graph = RelationGraphService.getInducedSubgraph((Graph<GraphNode>)graph, Collections.singleton(ruleIdLong));
        relationGraphModelPojo.setRelationGraphDataPojo(RelationGraphService.getRelationGraphDataPojo(graph));
        relationGraphModelPojo.setRelationGraphShowBoxParent(RelationGraphService.getRelationGraphShowBoxParent());
        return relationGraphModelPojo;
    }

    public static RelationGraphDataPojo getRelationGraphDataPojo(Graph<GraphNode> graph) {
        RelationGraphDataPojo relationGraphDataPojo = new RelationGraphDataPojo();
        List relationGraphNodePojoList = graph.nodes().stream().map(item -> {
            RelationGraphNodePojo relationGraphNodePojo = new RelationGraphNodePojo();
            relationGraphNodePojo.setIdString(ObjUtils.getString((Object)item.getNodeId()));
            relationGraphNodePojo.setTextString(item.getNodeNumber());
            return relationGraphNodePojo;
        }).collect(Collectors.toList());
        relationGraphDataPojo.setRelationGraphNodePojoList(relationGraphNodePojoList);
        relationGraphDataPojo.setRelationGraphLinkPojoList(RelationGraphService.getRelationGraphLinkPojoList(graph));
        return relationGraphDataPojo;
    }

    public static Map<Long, RuleDto> getRuleDtoMap(Long ruleIdLong) {
        List targetRuleDtoList = RuleService.getInstance().listRule(new QFilter("id", "=", (Object)ruleIdLong), Boolean.valueOf(true), null);
        if (CollectionUtils.isEmpty((Collection)targetRuleDtoList)) {
            throw new KDBizException(ResManager.loadKDString((String)"\u672a\u627e\u5230\u6307\u5b9a\u4e1a\u52a1\u89c4\u5219\u3002", (String)"RelationGraphPlugin_7", (String)"epm-eb-formplugin", (Object[])new Object[0]));
        }
        RuleDto targetRuleDto = (RuleDto)targetRuleDtoList.get(0);
        if (BooleanUtils.isFalse((Boolean)targetRuleDto.getStatus())) {
            throw new KDBizException(ResManager.loadKDString((String)"\u4e1a\u52a1\u89c4\u5219\u5df2\u7981\u7528\u3002", (String)"RelationGraphPlugin_8", (String)"epm-eb-formplugin", (Object[])new Object[0]));
        }
        return RuleService.getInstance().listRule(targetRuleDto.getBizCtrlRangeId(), Boolean.valueOf(true), null).stream().collect(Collectors.toMap(RuleDto::getId, ruleDto -> ruleDto));
    }

    public static RelationGraphShowBoxParent getRelationGraphShowBoxParent() {
        RelationGraphShowBoxPojo relationGraphShowBoxPojo = new RelationGraphShowBoxPojo();
        relationGraphShowBoxPojo.setTypeString(RelationGraphShowBoxTypeEnum.CONTEXTMENU.name());
        ContextmenuItemComponent contextmenuItemComponent = new ContextmenuItemComponent();
        contextmenuItemComponent.setTypeString(RelationGraphInteractionTypeEnum.NODE_JUMP_TO_BIZ_RULE.name());
        contextmenuItemComponent.setValueString(ResManager.loadKDString((String)"\u8df3\u8f6c\u524d\u5f80\u4e1a\u52a1\u89c4\u5219", (String)"RelationGraphPlugin_16", (String)"epm-eb-formplugin", (Object[])new Object[0]));
        contextmenuItemComponent.setSelectedBoolean(Boolean.valueOf(false));
        relationGraphShowBoxPojo.setContextmenuItemComponentList((List)Lists.newArrayList((Object[])new ContextmenuItemComponent[]{contextmenuItemComponent}));
        return new RelationGraphShowBoxParent().setRelationGraphShowBoxPojoList((List)Lists.newArrayList((Object[])new RelationGraphShowBoxPojo[]{relationGraphShowBoxPojo}));
    }

    public static List<RelationGraphLinkPojo> getRelationGraphLinkPojoList(Graph<GraphNode> graph) {
        return graph.edges().stream().map(item -> {
            RelationGraphLinkPojo relationGraphLinkPojo = new RelationGraphLinkPojo();
            relationGraphLinkPojo.setFromString(ObjUtils.getString((Object)((GraphNode)item.source()).getNodeId()));
            relationGraphLinkPojo.setToString(ObjUtils.getString((Object)((GraphNode)item.target()).getNodeId()));
            return relationGraphLinkPojo;
        }).collect(Collectors.toList());
    }

    public static MutableGraph<GraphNode> getInducedSubgraph(Graph<GraphNode> graph, Set<Long> selectedRuleIdLongSet) {
        Graph transposeGraph = Graphs.transpose(graph);
        Map<Long, GraphNode> graphNodeMap = graph.nodes().stream().filter(graphNode -> selectedRuleIdLongSet.contains(graphNode.getNodeId())).collect(Collectors.toMap(GraphNode::getNodeId, graphNode -> graphNode));
        HashMap<Long, GraphNode> reachableGraphNodeMap = new HashMap<Long, GraphNode>(graphNodeMap);
        for (GraphNode graphNode2 : graphNodeMap.values()) {
            Graphs.reachableNodes(graph, (Object)graphNode2).forEach(reachableGraphNode -> reachableGraphNodeMap.put(reachableGraphNode.getNodeId(), (GraphNode)reachableGraphNode));
            Graphs.reachableNodes((Graph)transposeGraph, (Object)graphNode2).forEach(reachableGraphNode -> reachableGraphNodeMap.put(reachableGraphNode.getNodeId(), (GraphNode)reachableGraphNode));
        }
        return Graphs.inducedSubgraph(graph, reachableGraphNodeMap.values());
    }

    public static void openRelationGraphByRuleInstanceIdLong(IFormView formView, Long ruleInstanceIdLong) {
        RelationGraphUtils.openRelationGraph(formView, RelationGraphService.getRelationGraphModelPojoByRuleInstanceIdLong(ruleInstanceIdLong));
    }

    public static RelationGraphModelPojo getRelationGraphModelPojoByRuleInstanceIdLong(Long ruleInstanceIdLong) {
        List ebRuleInstanceList = OrmBuilder.clazz(EbRuleInstance.class).field(new String[]{"fexegraph"}).whereEqual("fid", (Object)ruleInstanceIdLong).toRowList();
        if (CollectionUtils.isEmpty((Collection)ebRuleInstanceList)) {
            throw new KDBizException(ResManager.loadKDString((String)"\u672a\u627e\u5230\u6307\u5b9a\u89c4\u5219\u6267\u884c\u5b9e\u4f8b\u3002", (String)"RelationGraphPlugin_9", (String)"epm-eb-formplugin", (Object[])new Object[0]));
        }
        String fexegraphString = ((EbRuleInstance)ebRuleInstanceList.get(0)).getExegraphString();
        if (StringUtils.isBlank((CharSequence)fexegraphString)) {
            throw new KDBizException(ResManager.loadKDString((String)"\u89c4\u5219\u6267\u884c\u5b9e\u4f8b\u5bf9\u5e94\u7684\u5173\u7cfb\u56fe\u65e5\u5fd7\u4e3a\u7a7a\u3002", (String)"RelationGraphPlugin_10", (String)"epm-eb-formplugin", (Object[])new Object[0]));
        }
        RelationGraphDataPojo relationGraphDataPojo = RelationGraphUtils.getRelationGraphDataPojoByGraphLogString(fexegraphString);
        return new RelationGraphModelPojo().setRelationGraphDataPojo(relationGraphDataPojo);
    }

    public static void openRelationGraphByRuleInstanceDetailIdLong(IFormView formView, Long ruleInstanceDetailIdLong) {
        List ebRuleInstanceDetailList = OrmBuilder.clazz(EbRuleInstanceDetail.class).field(new String[]{"flogid"}).whereEqual("fid", (Object)ruleInstanceDetailIdLong).toRowList();
        if (CollectionUtils.isEmpty((Collection)ebRuleInstanceDetailList)) {
            formView.showTipNotification(ResManager.loadKDString((String)"\u672a\u627e\u5230\u6307\u5b9a\u89c4\u5219\u6267\u884c\u5b9e\u4f8b\u8be6\u60c5\u3002", (String)"RelationGraphPlugin_11", (String)"epm-eb-formplugin", (Object[])new Object[0]));
            return;
        }
        RelationGraphModelPojo relationGraphModelPojo = RelationGraphService.getRelationGraphModelPojoByRuleInstanceIdLong(((EbRuleInstanceDetail)ebRuleInstanceDetailList.get(0)).getLogidLong());
        relationGraphModelPojo.setRelationGraphShowBoxParent(RelationGraphService.getRelationGraphShowBoxParent());
        RelationGraphUtils.openRelationGraph(formView, relationGraphModelPojo);
    }

    public static void actionMethod(CustomControl customControl, CustomEventArgs customEventArgs, RelationGraphInteractionTypeEnum relationGraphInteractionTypeEnum) {
        JsonNode jsonNode = JsonUtils.readTree((String)customEventArgs.getEventArgs());
        JsonNode relationGraphModelPojoJsonNode = jsonNode.get(FrontUtils.getNameString(RelationGraphModelPojo.class));
        RelationGraphModelPojo relationGraphModelPojo = (RelationGraphModelPojo)JsonUtils.readValue((JsonNode)relationGraphModelPojoJsonNode, RelationGraphModelPojo.class);
        RelationGraphActionPojo relationGraphActionPojo = relationGraphModelPojo.getRelationGraphActionPojo();
        MutableGraph<String> currentGraph = RelationGraphUtils.getWithoutDefaultRootGraph(relationGraphModelPojo.getRelationGraphDataPojo());
        TreeSet<String> currentNodeIdStringSet = new TreeSet<String>(currentGraph.nodes());
        if (relationGraphModelPojo.getFullRelationGraphDataPojo() == null) {
            relationGraphModelPojo.setFullRelationGraphDataPojo(relationGraphModelPojo.getRelationGraphDataPojo());
        }
        RelationGraphDataPojo fullRelationGraphDataPojo = relationGraphModelPojo.getFullRelationGraphDataPojo();
        switch (relationGraphInteractionTypeEnum) {
            case NODE_PREVIOUS_EXPANDE: {
                LambdaUtils.run(() -> {
                    MutableGraph<String> fullGraph = RelationGraphUtils.getWithoutDefaultRootGraph(fullRelationGraphDataPojo);
                    Set fullGraphPreviousGraphNodeIdStringSet = fullGraph.predecessors((Object)relationGraphActionPojo.getIdString());
                    Set currentGraphPreviousGraphNodeIdStringSet = currentGraph.predecessors((Object)relationGraphActionPojo.getIdString());
                    if (fullGraphPreviousGraphNodeIdStringSet.size() == currentGraphPreviousGraphNodeIdStringSet.size()) {
                        Set<String> previousGraphNodeIdStringSet = RelationGraphUtils.getPreviousGraphNodeIdStringSet((Graph<String>)currentGraph, relationGraphActionPojo.getIdString());
                        currentNodeIdStringSet.removeAll(previousGraphNodeIdStringSet);
                    } else {
                        currentNodeIdStringSet.addAll(fullGraphPreviousGraphNodeIdStringSet);
                    }
                });
                break;
            }
            case NODE_LATER_EXPANDE: {
                LambdaUtils.run(() -> {
                    MutableGraph<String> fullGraph = RelationGraphUtils.getWithoutDefaultRootGraph(fullRelationGraphDataPojo);
                    Set fullGraphLaterGraphNodeIdStringSet = fullGraph.successors((Object)relationGraphActionPojo.getIdString());
                    Set currentGraphLaterGraphNodeIdStringSet = currentGraph.successors((Object)relationGraphActionPojo.getIdString());
                    if (fullGraphLaterGraphNodeIdStringSet.size() == currentGraphLaterGraphNodeIdStringSet.size()) {
                        Set<String> laterGraphNodeIdStringSet = RelationGraphUtils.getLaterGraphNodeIdStringSet((Graph<String>)currentGraph, relationGraphActionPojo.getIdString());
                        currentNodeIdStringSet.removeAll(laterGraphNodeIdStringSet);
                    } else {
                        currentNodeIdStringSet.addAll(fullGraphLaterGraphNodeIdStringSet);
                    }
                });
                break;
            }
            case NODE_REMOVE_CURRENT: {
                currentNodeIdStringSet.remove(relationGraphActionPojo.getIdString());
                break;
            }
            case NODE_HIDE_NO_RELATED_NODES: {
                LambdaUtils.run(() -> {
                    Set<String> previousGraphNodeIdStringSet = RelationGraphUtils.getPreviousGraphNodeIdStringSet((Graph<String>)currentGraph, relationGraphActionPojo.getIdString());
                    Set<String> laterGraphNodeIdStringSet = RelationGraphUtils.getLaterGraphNodeIdStringSet((Graph<String>)currentGraph, relationGraphActionPojo.getIdString());
                    currentNodeIdStringSet.clear();
                    currentNodeIdStringSet.addAll(previousGraphNodeIdStringSet);
                    currentNodeIdStringSet.addAll(laterGraphNodeIdStringSet);
                    currentNodeIdStringSet.add(relationGraphActionPojo.getIdString());
                });
                break;
            }
            case NODE_EXPAND_ALL_RELATED_NODES: {
                LambdaUtils.run(() -> {
                    MutableGraph<String> fullGraph = RelationGraphUtils.getWithoutDefaultRootGraph(fullRelationGraphDataPojo);
                    Set<String> previousGraphNodeIdStringSet = RelationGraphUtils.getPreviousGraphNodeIdStringSet(fullGraph, relationGraphActionPojo.getIdString());
                    Set<String> laterGraphNodeIdStringSet = RelationGraphUtils.getLaterGraphNodeIdStringSet(fullGraph, relationGraphActionPojo.getIdString());
                    currentNodeIdStringSet.clear();
                    currentNodeIdStringSet.addAll(previousGraphNodeIdStringSet);
                    currentNodeIdStringSet.addAll(laterGraphNodeIdStringSet);
                    currentNodeIdStringSet.add(relationGraphActionPojo.getIdString());
                });
                break;
            }
            case NODE_DELETE_CURRENT_NODE: {
                currentNodeIdStringSet.remove(relationGraphActionPojo.getIdString());
                RelationGraphUtils.removeNodeIdString(fullRelationGraphDataPojo, relationGraphActionPojo.getIdString());
                break;
            }
        }
        if (CollectionUtils.isEmpty(currentNodeIdStringSet)) {
            throw new KDBizException(ResManager.loadKDString((String)"\u8be5\u5173\u7cfb\u56fe\u8282\u70b9\u4e0d\u5141\u8bb8\u5220\u9664\u3002", (String)"RelationGraphPlugin_6", (String)"epm-eb-formplugin", (Object[])new Object[0]));
        }
        RelationGraphDataPojo relationGraphDataPojo = RelationGraphUtils.getRelationGraphDataPojo(fullRelationGraphDataPojo, currentNodeIdStringSet);
        relationGraphDataPojo.getRelationGraphNodePojoList().forEach(item -> {
            if (StringUtils.equalsAny((CharSequence)relationGraphActionPojo.getIdString(), (CharSequence[])new CharSequence[]{relationGraphModelPojo.getFocusNodeIdString(), "DEFAULT_ROOT_NODE_ID_STRING"})) {
                return;
            }
            if (relationGraphActionPojo.getIdString().equals(item.getIdString())) {
                item.setColorString("teal");
            } else {
                item.setColorString(null);
            }
        });
        RelationGraphDataPojo originRelationGraphDataPojo = relationGraphModelPojo.getRelationGraphDataPojo();
        relationGraphModelPojo.setRelationGraphDataPojo(relationGraphDataPojo);
        if (customControl != null) {
            RelationGraphUtils.checkAndReorganize(relationGraphModelPojo);
            Map<String, RelationGraphNodePojo> originRelationGraphNodePojoMap = originRelationGraphDataPojo.getRelationGraphNodePojoList().stream().collect(Collectors.toMap(item -> item.getIdString(), item -> item));
            if (originRelationGraphNodePojoMap.keySet().containsAll(currentNodeIdStringSet)) {
                for (RelationGraphNodePojo relationGraphNodePojo : relationGraphDataPojo.getRelationGraphNodePojoList()) {
                    RelationGraphNodePojo originRelationGraphNodePojo = originRelationGraphNodePojoMap.get(relationGraphNodePojo.getIdString());
                    relationGraphNodePojo.setYaxisInteger(originRelationGraphNodePojo.getYaxisInteger());
                    relationGraphNodePojo.setXaxisInteger(originRelationGraphNodePojo.getXaxisInteger());
                }
            }
            RuleJsUtils.invokeCustom(customControl, customEventArgs.getEventName(), "updateModelPojo", JsonUtils.getWithoutNullJsonString((Object)relationGraphModelPojo), null);
        }
    }

    public static void bizRuleActionMethod(IFormView formView, CustomEventArgs customEventArgs) {
        try {
            JsonNode jsonNode = JsonUtils.readTree((String)customEventArgs.getEventArgs());
            OpenRulePojo openRulePojo = new OpenRulePojo().setReadonlyBoolean(Boolean.valueOf(true));
            RelationGraphNodeDataCellPojo relationGraphNodeDataCellPojo = (RelationGraphNodeDataCellPojo)JsonUtils.readValue((JsonNode)jsonNode.get(FrontUtils.getNameString(RelationGraphNodeDataCellPojo.class)), RelationGraphNodeDataCellPojo.class);
            if (relationGraphNodeDataCellPojo != null) {
                openRulePojo.singleRuleIdLong(ObjUtils.getLong((Object)relationGraphNodeDataCellPojo.getIdString()));
            } else {
                RelationGraphModelPojo relationGraphModelPojo = (RelationGraphModelPojo)JsonUtils.readValue((JsonNode)jsonNode.get(FrontUtils.getNameString(RelationGraphModelPojo.class)), RelationGraphModelPojo.class);
                RelationGraphActionPojo relationGraphActionPojo = relationGraphModelPojo.getRelationGraphActionPojo();
                openRulePojo.singleRuleIdLong(ObjUtils.getLong((Object)relationGraphActionPojo.getIdString()));
            }
            RuleUtils.openRule(formView, openRulePojo);
        }
        catch (Throwable throwable) {
            String uuidIdWithDataString = StrUtils.getUuidIdWithDataString();
            log.warn(uuidIdWithDataString, throwable);
            formView.showTipNotification(ResManager.loadResFormat((String)"\u51fa\u73b0\u5f02\u5e38\uff0c\u8bf7\u67e5\u770b\u65e5\u5fd7\uff1a%1\u3002", (String)"RelationGraphPlugin_19", (String)"epm-eb-formplugin", (Object[])new Object[]{uuidIdWithDataString}));
        }
    }

    public static RelationGraphModelPojo getCurrentRelationGraphModelPojo(ReportShowBizRuleBo reportShowBizRuleBo, Long modelIdLong) {
        ArrayList<RelationGraphDataTrackingItemPojo> relationGraphDataTrackingItemPojoList = new ArrayList<RelationGraphDataTrackingItemPojo>(16);
        RelationGraphNodePojo relationGraphNodePojo = RelationGraphService.getRelationGraphNodePojo(reportShowBizRuleBo, relationGraphDataTrackingItemPojoList, modelIdLong);
        RelationGraphModelPojo relationGraphModelPojo = new RelationGraphModelPojo();
        IModelCacheHelper modelCacheHelper = ModelCacheContext.getOrCreate((Long)modelIdLong);
        relationGraphModelPojo.setFocusNodeIdString(relationGraphNodePojo.getIdString());
        relationGraphModelPojo.setTitleString(ResManager.loadKDString((String)"\u6570\u636e\u8ffd\u8e2a", (String)"RelationGraphPlugin_35", (String)"epm-eb-formplugin", (Object[])new Object[0]));
        RelationGraphDataPojo relationGraphDataPojo = new RelationGraphDataPojo();
        relationGraphModelPojo.setRelationGraphDataPojo(relationGraphDataPojo);
        ArrayList<RelationGraphNodePojo> relationGraphNodePojoList = new ArrayList<RelationGraphNodePojo>(16);
        relationGraphNodePojoList.add(relationGraphNodePojo);
        relationGraphDataPojo.setRelationGraphNodePojoList(relationGraphNodePojoList);
        RelationGraphShowBoxParent relationGraphShowBoxParent = new RelationGraphShowBoxParent();
        relationGraphModelPojo.setRelationGraphShowBoxParent(relationGraphShowBoxParent);
        relationGraphShowBoxParent.setEnableMourceBoxBoolean(Boolean.valueOf(true));
        ArrayList relationGraphShowBoxPojoList = new ArrayList(16);
        relationGraphShowBoxParent.setRelationGraphShowBoxPojoList(relationGraphShowBoxPojoList);
        Long busModelByDataSet = reportShowBizRuleBo.getBusModelByDataSet();
        LambdaUtils.run(() -> {
            List cellRelationGraphDataTrackingItemPojoList = relationGraphDataTrackingItemPojoList.stream().filter(item -> RelationGraphDataTrackingTypeEnum.CELL.name().equals(item.getTypeString())).collect(Collectors.toList());
            for (RelationGraphDataTrackingItemPojo cellRelationGraphDataTrackingItemPojo : cellRelationGraphDataTrackingItemPojoList) {
                Map dimensionAndMemberNumberMap = cellRelationGraphDataTrackingItemPojo.getDimensionAndMemberNumberMap();
                if (MapUtils.isEmpty((Map)dimensionAndMemberNumberMap)) continue;
                ArrayList memberPojoList = new ArrayList(16);
                cellRelationGraphDataTrackingItemPojo.setMemberPojoList(memberPojoList);
                relationGraphShowBoxPojoList.add(LambdaUtils.get(() -> {
                    RelationGraphShowBoxPojo relationGraphShowBoxPojo = new RelationGraphShowBoxPojo();
                    relationGraphShowBoxPojo.setTypeString(RelationGraphShowBoxTypeEnum.MOURCE.name());
                    relationGraphShowBoxPojo.setIdString(cellRelationGraphDataTrackingItemPojo.getCurrentCellIdString());
                    relationGraphShowBoxPojo.setBoxStyleTypeString("HTML");
                    ArrayList elementPojoList = new ArrayList(16);
                    ElementPojo elementPojo1 = (ElementPojo)LambdaUtils.get(() -> {
                        ElementPojo elementPojo = ElementUtils.createDivElementPojo();
                        elementPojo.setStylePojo(new StylePojo().setWhiteSpaceString("nowrap").setPaddingString("5px"));
                        elementPojoList.add(elementPojo);
                        return elementPojo;
                    });
                    ElementPojo elementPojo1Sub1 = (ElementPojo)LambdaUtils.get(() -> {
                        ElementPojo elementPojo = ElementUtils.createDivElementPojo();
                        elementPojo.setParentElementPojo(elementPojo1);
                        elementPojoList.add(elementPojo);
                        return elementPojo;
                    });
                    LambdaUtils.get(() -> {
                        ElementPojo elementPojo = ElementUtils.createDivElementPojo();
                        elementPojo.setStylePojo(new StylePojo().setLineHeightString("20px").setHeightString("20px"));
                        elementPojo.setValueString(ResManager.loadKDString((String)"\u7ef4\u5ea6\u4fe1\u606f", (String)"RelationGraphPlugin_48", (String)"epm-eb-formplugin", (Object[])new Object[0]));
                        elementPojo.setParentElementPojo(elementPojo1Sub1);
                        elementPojoList.add(elementPojo);
                        return elementPojo;
                    });
                    Integer maxDimensionNumberStringCssLengthInteger = 0;
                    Integer maxMemberNumberStringCssLengthInteger = 0;
                    ArrayList dimensionElementPojoList = new ArrayList(16);
                    ArrayList memberElementPojoList = new ArrayList(16);
                    Map viewMap = OlapUtils.getViewMap((Long)modelIdLong, (Map)dimensionAndMemberNumberMap);
                    for (Map.Entry entry : dimensionAndMemberNumberMap.entrySet()) {
                        Integer memberNumberStringCssLengthInteger;
                        String dimensionNumberString = (String)entry.getKey();
                        String memberNumberString = (String)entry.getValue();
                        Integer dimensionNumberStringCssLengthInteger = RelationGraphUtils.getCssLength(dimensionNumberString);
                        if (dimensionNumberStringCssLengthInteger > maxDimensionNumberStringCssLengthInteger) {
                            maxDimensionNumberStringCssLengthInteger = dimensionNumberStringCssLengthInteger;
                        }
                        if ((memberNumberStringCssLengthInteger = RelationGraphUtils.getCssLength(memberNumberString)) > maxMemberNumberStringCssLengthInteger) {
                            maxMemberNumberStringCssLengthInteger = memberNumberStringCssLengthInteger;
                        }
                        ElementPojo elementPojo1Sub1Subn = (ElementPojo)LambdaUtils.get(() -> {
                            ElementPojo elementPojo = ElementUtils.createDivElementPojo();
                            elementPojo.setStylePojo(new StylePojo().setLineHeightString("20px").setHeightString("20px"));
                            elementPojo.setParentElementPojo(elementPojo1Sub1);
                            elementPojoList.add(elementPojo);
                            return elementPojo;
                        });
                        Dimension dimension = modelCacheHelper.getDimension(dimensionNumberString);
                        LambdaUtils.get(() -> {
                            ElementPojo elementPojo = ElementUtils.createDivElementPojo();
                            elementPojo.setValueString(dimension.getName());
                            elementPojo.setStylePojo(new StylePojo().setDisplayString("inline-block"));
                            elementPojo.setParentElementPojo(elementPojo1Sub1Subn);
                            elementPojoList.add(elementPojo);
                            dimensionElementPojoList.add(elementPojo);
                            return elementPojo;
                        });
                        Member member = modelCacheHelper.getMemberByAnyView(busModelByDataSet, dimensionNumberString, memberNumberString);
                        LambdaUtils.get(() -> {
                            ElementPojo elementPojo = ElementUtils.createDivElementPojo();
                            elementPojo.setValueString(member.getName());
                            elementPojo.setStylePojo(new StylePojo().setDisplayString("inline-block"));
                            elementPojo.setParentElementPojo(elementPojo1Sub1Subn);
                            elementPojoList.add(elementPojo);
                            memberElementPojoList.add(elementPojo);
                            return elementPojo;
                        });
                        MemberPojo memberPojo = new MemberPojo();
                        memberPojoList.add(memberPojo);
                        DimensionPojo dimensionPojo = new DimensionPojo();
                        memberPojo.setDimensionPojo(dimensionPojo);
                        dimensionPojo.setDimensionNumberString(dimension.getNumber());
                        dimensionPojo.setDimensionIdLong(dimension.getId());
                        dimensionPojo.setDimensionNameString(dimension.getName());
                        memberPojo.setMemberIdLong(member.getId());
                        memberPojo.setMemberNumberString(member.getNumber());
                        memberPojo.setMemberNameString(member.getName());
                    }
                    for (ElementPojo elementPojo : dimensionElementPojoList) {
                        elementPojo.getStylePojo().setWidthString(maxDimensionNumberStringCssLengthInteger + 20 + "px");
                    }
                    for (ElementPojo elementPojo : memberElementPojoList) {
                        elementPojo.getStylePojo().setWidthString(maxDimensionNumberStringCssLengthInteger + 20 + "px");
                    }
                    relationGraphShowBoxPojo.setMessageString(ElementUtils.getString(elementPojoList, (Boolean)false));
                    StylePojo stylePojo = new StylePojo();
                    int widthInt = maxDimensionNumberStringCssLengthInteger + maxDimensionNumberStringCssLengthInteger + 10;
                    if (widthInt < 300) {
                        widthInt = 300;
                    }
                    stylePojo.setWidthString(widthInt + "px");
                    stylePojo.setHeightString((dimensionAndMemberNumberMap.size() + 1) * 20 + 10 + "px");
                    relationGraphShowBoxPojo.setStylePojo(stylePojo);
                    return relationGraphShowBoxPojo;
                }));
            }
        });
        RelationGraphDataTrackingPojo relationGraphDataTrackingPojo = new RelationGraphDataTrackingPojo();
        relationGraphDataTrackingPojo.setModelIdLong(modelIdLong);
        relationGraphDataTrackingPojo.setRelationGraphDataTrackingItemPojoList(relationGraphDataTrackingItemPojoList);
        return relationGraphModelPojo.setCustomParamMap(MapPlusUtils.getStringMap((String[])new String[]{RelationGraphDataTrackingPojo.class.getName(), JsonUtils.getJsonString((Object)relationGraphDataTrackingPojo)}));
    }

    public static void openRelationGraphByReportShowBizRuleBo(IFormView formView, ReportShowBizRuleBo reportShowBizRuleBo, Long modelIdLong) {
        RelationGraphModelPojo relationGraphModelPojo = RelationGraphService.getCurrentRelationGraphModelPojo(reportShowBizRuleBo, modelIdLong);
        Map customParamMap = relationGraphModelPojo.getCustomParamMap();
        ReportOrTaskPojo reportOrTaskPojo = (ReportOrTaskPojo)LambdaUtils.get(() -> {
            Map formCustomParamMap = formView.getFormShowParameter().getCustomParams();
            if (MapUtils.isEmpty((Map)formCustomParamMap)) {
                return null;
            }
            Object reportOrTaskPojoJsonStringObject = formCustomParamMap.get(ReportOrTaskPojo.class.getName());
            if (!(reportOrTaskPojoJsonStringObject instanceof String)) {
                return null;
            }
            String reportOrTaskPojoJsonString = (String)reportOrTaskPojoJsonStringObject;
            if (StringUtils.isBlank((CharSequence)reportOrTaskPojoJsonString)) {
                return null;
            }
            customParamMap.put(ReportOrTaskPojo.class.getName(), reportOrTaskPojoJsonString);
            return (ReportOrTaskPojo)JsonUtils.readValue((String)reportOrTaskPojoJsonString, ReportOrTaskPojo.class);
        });
        LambdaUtils.run(() -> {
            if (reportOrTaskPojo == null) {
                return;
            }
            relationGraphModelPojo.setGraphTitleString(reportOrTaskPojo.getTitleString());
        });
        RelationGraphDataTrackingPojo relationGraphDataTrackingPojo = (RelationGraphDataTrackingPojo)JsonUtils.readValue((String)((String)customParamMap.get(RelationGraphDataTrackingPojo.class.getName())), RelationGraphDataTrackingPojo.class);
        LambdaUtils.run(() -> {
            RelationGraphDataTrackingItemPojo leftRelationGraphDataTrackingItemPojo = (RelationGraphDataTrackingItemPojo)LambdaUtils.getTarget((List)relationGraphDataTrackingPojo.getRelationGraphDataTrackingItemPojoList(), item -> RelationGraphDataTrackingTypeEnum.CELL.name().equals(item.getTypeString()) && BooleanUtils.isTrue((Boolean)item.getLeftBoolean()));
            if (leftRelationGraphDataTrackingItemPojo == null) {
                return;
            }
            LambdaUtils.run(() -> {
                leftRelationGraphDataTrackingItemPojo.setInfoHtmlString(RelationGraphService.getFirstInfoHtmlString(formView.getPageId(), modelIdLong, leftRelationGraphDataTrackingItemPojo.getMemberPojoList(), reportOrTaskPojo));
                RelationGraphUtils.updateRelationGraphModelPojoInfoHtmlString(relationGraphModelPojo, leftRelationGraphDataTrackingItemPojo.getInfoHtmlString());
                customParamMap.put(RelationGraphDataTrackingPojo.class.getName(), JsonUtils.getJsonString((Object)relationGraphDataTrackingPojo));
            }, throwable -> {
                log.info(ThrowableHelper.printError((Throwable)throwable));
                String messageString = throwable.getMessage();
                if (StringUtils.isBlank((CharSequence)messageString)) {
                    messageString = throwable.toString();
                }
                formView.showTipNotification(messageString);
            });
            RelationGraphNodeDataCellPojo targetRelationGraphNodeDataCellPojo = (RelationGraphNodeDataCellPojo)LambdaUtils.get(() -> {
                List relationGraphNodePojoList = relationGraphModelPojo.getRelationGraphDataPojo().getRelationGraphNodePojoList();
                for (RelationGraphNodePojo relationGraphNodePojo : relationGraphNodePojoList) {
                    if (!leftRelationGraphDataTrackingItemPojo.getCurrentNodeIdString().equals(relationGraphNodePojo.getIdString())) continue;
                    List relationGraphNodeDataRowPojoList = relationGraphNodePojo.getRelationGraphNodeDataPojo().getRelationGraphNodeDataAreaPojo().getRelationGraphNodeDataRowPojoList();
                    for (RelationGraphNodeDataRowPojo relationGraphNodeDataRowPojo : relationGraphNodeDataRowPojoList) {
                        List relationGraphNodeDataCellPojoList = relationGraphNodeDataRowPojo.getRelationGraphNodeDataCellPojoList();
                        for (RelationGraphNodeDataCellPojo relationGraphNodeDataCellPojo : relationGraphNodeDataCellPojoList) {
                            if (!leftRelationGraphDataTrackingItemPojo.getCurrentCellIdString().equals(relationGraphNodeDataCellPojo.getIdString())) continue;
                            return relationGraphNodeDataCellPojo;
                        }
                    }
                }
                return null;
            });
            if (targetRelationGraphNodeDataCellPojo == null) {
                return;
            }
            StylePojo stylePojo = targetRelationGraphNodeDataCellPojo.getStylePojo();
            if (stylePojo == null) {
                stylePojo = new StylePojo();
                targetRelationGraphNodeDataCellPojo.setStylePojo(stylePojo);
            }
            stylePojo.setBackgroundColorString("#E1E7EE");
        });
        relationGraphModelPojo.setClickToExpandBoolean(Boolean.valueOf(true));
        relationGraphModelPojo.setDisableContextmenuBoolean(Boolean.valueOf(true));
        RelationGraphUtils.openRelationGraph(formView, relationGraphModelPojo);
    }

    public static RelationGraphNodePojo getRelationGraphNodePojo(ReportShowBizRuleBo reportShowBizRuleBo, List<RelationGraphDataTrackingItemPojo> relationGraphDataTrackingItemPojoList, Long modelIdLong) {
        IModelCacheHelper modelCacheHelper = ModelCacheContext.getOrCreate((Long)modelIdLong);
        List<FormulaPojo> formulaPojoList = RuleManageQueryOp.getFormulaPojoList(reportShowBizRuleBo.getId());
        Map<String, ReportShowBizRuleMemberBo> reportShowBizRuleMemberBoMap = RelationGraphService.getReportShowBizRuleMemberBoMap(reportShowBizRuleBo);
        String leftMemberKeyString = reportShowBizRuleBo.getLeftMember().getMemberKey();
        RelationGraphNodePojo relationGraphNodePojo = new RelationGraphNodePojo();
        LambdaUtils.run(() -> {
            relationGraphNodePojo.setIdString(StrUtils.getUuidIdWithDataString());
            RelationGraphDataTrackingItemPojo relationGraphDataTrackingItemPojo = new RelationGraphDataTrackingItemPojo();
            relationGraphDataTrackingItemPojoList.add(relationGraphDataTrackingItemPojo);
            relationGraphDataTrackingItemPojo.setTypeString(RelationGraphDataTrackingTypeEnum.NODE.name());
            relationGraphDataTrackingItemPojo.setCurrentNodeIdString(relationGraphNodePojo.getIdString());
        });
        RelationGraphNodeDataPojo relationGraphNodeDataPojo = new RelationGraphNodeDataPojo();
        relationGraphNodePojo.setRelationGraphNodeDataPojo(relationGraphNodeDataPojo);
        RelationGraphNodeDataAreaPojo relationGraphNodeDataAreaPojo = new RelationGraphNodeDataAreaPojo();
        relationGraphNodeDataPojo.setRelationGraphNodeDataAreaPojo(relationGraphNodeDataAreaPojo);
        ArrayList relationGraphNodeDataRowPojoList = new ArrayList(3);
        relationGraphNodeDataAreaPojo.setRelationGraphNodeDataRowPojoList(relationGraphNodeDataRowPojoList);
        LambdaUtils.run(() -> {
            RelationGraphNodeDataRowPojo relationGraphNodeDataRowPojo = new RelationGraphNodeDataRowPojo();
            relationGraphNodeDataRowPojo.setStylePojo(new StylePojo().setBorderBottomString("#b2b2b2 dashed 1px").setPaddingString("5px"));
            relationGraphNodeDataRowPojoList.add(relationGraphNodeDataRowPojo);
            ArrayList<RelationGraphNodeDataCellPojo> relationGraphNodeDataCellPojoList = new ArrayList<RelationGraphNodeDataCellPojo>(formulaPojoList.size());
            relationGraphNodeDataRowPojo.setRelationGraphNodeDataCellPojoList(relationGraphNodeDataCellPojoList);
            HashMap<String, Integer> showInPageFuncCountMap = new HashMap<String, Integer>(16);
            for (FormulaPojo formulaPojo : formulaPojoList) {
                ReportShowBizRuleMemberBo reportShowBizRuleMemberBo = (ReportShowBizRuleMemberBo)reportShowBizRuleMemberBoMap.get(formulaPojo.getKeyString());
                if (reportShowBizRuleMemberBo == null) {
                    RelationGraphNodeDataCellPojo relationGraphNodeDataCellPojo;
                    RelationGraphNodeDataCellPojo relationGraphNodeDataCellPojo2;
                    boolean handleMemberFunc;
                    boolean bl = handleMemberFunc = "function".equals(formulaPojo.getTypeString()) && NEED_HANDLE_MEMBER_FUNC_SET.contains(formulaPojo.getToolEnumKeyString());
                    if (handleMemberFunc) {
                        for (FormulaPojo pojo : formulaPojo.getSubFormulaPojoList()) {
                            ReportShowBizRuleMemberBo funcReportShowBizRuleMemberBo = (ReportShowBizRuleMemberBo)reportShowBizRuleMemberBoMap.get(pojo.getKeyString());
                            if (funcReportShowBizRuleMemberBo != null) {
                                RelationGraphService.handleReportShowMemberNode(relationGraphDataTrackingItemPojoList, modelCacheHelper, leftMemberKeyString, relationGraphNodePojo, relationGraphNodeDataCellPojoList, pojo, funcReportShowBizRuleMemberBo);
                                continue;
                            }
                            relationGraphNodeDataCellPojo2 = new RelationGraphNodeDataCellPojo();
                            relationGraphNodeDataCellPojoList.add(relationGraphNodeDataCellPojo2);
                            relationGraphNodeDataCellPojo2.setStylePojo(new StylePojo().setColorString("black"));
                            relationGraphNodeDataCellPojo2.setValueString(pojo.getValueString() + "</br>" + pojo.getValueString());
                        }
                        continue;
                    }
                    if ("function".equals(formulaPojo.getTypeString()) && reportShowBizRuleBo.getFuncValueMap().containsKey(formulaPojo.getKeyString())) {
                        relationGraphNodeDataCellPojo = new RelationGraphNodeDataCellPojo();
                        relationGraphNodeDataCellPojoList.add(relationGraphNodeDataCellPojo);
                        relationGraphNodeDataCellPojo.setStylePojo(new StylePojo().setColorString("black"));
                        relationGraphNodeDataCellPojo.setValueString(formulaPojo.getValueString() + "</br>" + (String)reportShowBizRuleBo.getFuncValueMap().get(formulaPojo.getKeyString()));
                        continue;
                    }
                    if ("other".equals(formulaPojo.getTypeString()) && reportShowBizRuleBo.getShowInPageFuncValueMap().containsKey(formulaPojo.getValueString())) {
                        String valueString = formulaPojo.getValueString();
                        Map countValueMap = (Map)reportShowBizRuleBo.getShowInPageFuncValueMap().get(valueString);
                        Integer count = showInPageFuncCountMap.computeIfAbsent(valueString, k -> 1);
                        relationGraphNodeDataCellPojo2 = new RelationGraphNodeDataCellPojo();
                        relationGraphNodeDataCellPojoList.add(relationGraphNodeDataCellPojo2);
                        relationGraphNodeDataCellPojo2.setStylePojo(new StylePojo().setColorString("black").setTextAlignString("center"));
                        Integer n = count;
                        Integer n2 = count = Integer.valueOf(count + 1);
                        relationGraphNodeDataCellPojo2.setValueString(formulaPojo.getValueString() + "</br>" + (String)countValueMap.get(n));
                        showInPageFuncCountMap.put(valueString, count);
                        continue;
                    }
                    relationGraphNodeDataCellPojo = new RelationGraphNodeDataCellPojo();
                    relationGraphNodeDataCellPojoList.add(relationGraphNodeDataCellPojo);
                    relationGraphNodeDataCellPojo.setStylePojo(new StylePojo().setColorString("black"));
                    relationGraphNodeDataCellPojo.setValueString(formulaPojo.getValueString() + "</br>" + formulaPojo.getValueString());
                    continue;
                }
                RelationGraphService.handleReportShowMemberNode(relationGraphDataTrackingItemPojoList, modelCacheHelper, leftMemberKeyString, relationGraphNodePojo, relationGraphNodeDataCellPojoList, formulaPojo, reportShowBizRuleMemberBo);
            }
        });
        LambdaUtils.run(() -> {
            RelationGraphNodeDataRowPojo relationGraphNodeDataRowPojo = new RelationGraphNodeDataRowPojo();
            relationGraphNodeDataRowPojoList.add(relationGraphNodeDataRowPojo);
            relationGraphNodeDataRowPojo.setStylePojo(new StylePojo().setPaddingString("5px 5px 0 5px"));
            ArrayList relationGraphNodeDataCellPojoList = new ArrayList(2);
            relationGraphNodeDataRowPojo.setRelationGraphNodeDataCellPojoList(relationGraphNodeDataCellPojoList);
            LambdaUtils.run(() -> {
                RelationGraphNodeDataCellPojo relationGraphNodeDataCellPojo = new RelationGraphNodeDataCellPojo();
                relationGraphNodeDataCellPojoList.add(relationGraphNodeDataCellPojo);
                relationGraphNodeDataCellPojo.setValueString(ResManager.loadKDString((String)"\u89c4\u5219\u7f16\u7801:", (String)"RelationGraphPlugin_43", (String)"epm-eb-formplugin", (Object[])new Object[0]));
            });
            LambdaUtils.run(() -> {
                RelationGraphNodeDataCellPojo relationGraphNodeDataCellPojo = new RelationGraphNodeDataCellPojo();
                relationGraphNodeDataCellPojoList.add(relationGraphNodeDataCellPojo);
                relationGraphNodeDataCellPojo.setValueString(reportShowBizRuleBo.getNumber());
                relationGraphNodeDataCellPojo.setStylePojo(new StylePojo().setCursorString("pointer").setColorString("#5582F3"));
                relationGraphNodeDataCellPojo.setTypeStringList((List)Lists.newArrayList((Object[])new String[]{RelationGraphTypeEnum.BACKGROUND_COLOR.name(), RelationGraphTypeEnum.RULE_NUMBER.name()}));
                ArrayList<MethodPojo> methodPojoList = new ArrayList<MethodPojo>(3);
                relationGraphNodeDataCellPojo.setMethodPojoList(methodPojoList);
                relationGraphNodeDataCellPojo.setIdString(ObjUtils.getString((Object)reportShowBizRuleBo.getId()));
                methodPojoList.add(new MethodPojo().setListenMethodNameString("mouseover"));
                methodPojoList.add(new MethodPojo().setListenMethodNameString("mouseout"));
                methodPojoList.add(new MethodPojo().setListenMethodNameString("click").setEventNameString(RelationGraphInteractionTypeEnum.NODE_JUMP_TO_BIZ_RULE.name()));
            });
        });
        LambdaUtils.run(() -> {
            RelationGraphNodeDataRowPojo relationGraphNodeDataRowPojo = new RelationGraphNodeDataRowPojo();
            relationGraphNodeDataRowPojo.setStylePojo(new StylePojo().setPaddingString("5px"));
            relationGraphNodeDataRowPojoList.add(relationGraphNodeDataRowPojo);
            ArrayList relationGraphNodeDataCellPojoList = new ArrayList(2);
            relationGraphNodeDataRowPojo.setRelationGraphNodeDataCellPojoList(relationGraphNodeDataCellPojoList);
            LambdaUtils.run(() -> {
                RelationGraphNodeDataCellPojo relationGraphNodeDataCellPojo = new RelationGraphNodeDataCellPojo();
                relationGraphNodeDataCellPojoList.add(relationGraphNodeDataCellPojo);
                relationGraphNodeDataCellPojo.setValueString(ResManager.loadKDString((String)"\u89c4\u5219\u540d\u79f0:", (String)"RelationGraphPlugin_47", (String)"epm-eb-formplugin", (Object[])new Object[0]));
            });
            LambdaUtils.run(() -> {
                RelationGraphNodeDataCellPojo relationGraphNodeDataCellPojo = new RelationGraphNodeDataCellPojo();
                relationGraphNodeDataCellPojoList.add(relationGraphNodeDataCellPojo);
                relationGraphNodeDataCellPojo.setValueString(reportShowBizRuleBo.getName());
            });
        });
        return relationGraphNodePojo;
    }

    private static void handleReportShowMemberNode(List<RelationGraphDataTrackingItemPojo> relationGraphDataTrackingItemPojoList, IModelCacheHelper modelCacheHelper, String leftMemberKeyString, RelationGraphNodePojo relationGraphNodePojo, List<RelationGraphNodeDataCellPojo> relationGraphNodeDataCellPojoList, FormulaPojo formulaPojo, ReportShowBizRuleMemberBo reportShowBizRuleMemberBo) {
        RelationGraphNodeDataCellPojo relationGraphNodeDataCellPojo = new RelationGraphNodeDataCellPojo();
        relationGraphNodeDataCellPojoList.add(relationGraphNodeDataCellPojo);
        LambdaUtils.run(() -> {
            relationGraphNodeDataCellPojo.setIdString(StrUtils.getUuidIdWithDataString());
            RelationGraphDataTrackingItemPojo relationGraphDataTrackingItemPojo = new RelationGraphDataTrackingItemPojo();
            relationGraphDataTrackingItemPojoList.add(relationGraphDataTrackingItemPojo);
            relationGraphDataTrackingItemPojo.setTypeString(RelationGraphDataTrackingTypeEnum.CELL.name());
            relationGraphDataTrackingItemPojo.setCurrentNodeIdString(relationGraphNodePojo.getIdString());
            relationGraphDataTrackingItemPojo.setCurrentCellIdString(relationGraphNodeDataCellPojo.getIdString());
            Map sortedDimensionAndMemberNumberMap = (Map)LambdaUtils.get(() -> {
                Map dimensionAndMemberNumberMap = reportShowBizRuleMemberBo.getDimNumberToMemberNumber();
                if (MapUtils.isEmpty((Map)dimensionAndMemberNumberMap)) {
                    return dimensionAndMemberNumberMap;
                }
                ArrayList<Dimension> dimensionList = new ArrayList<Dimension>(dimensionAndMemberNumberMap.size());
                for (String dimensionNumberString : dimensionAndMemberNumberMap.keySet()) {
                    if (SysDimensionEnum.Account.getNumber().equals(dimensionNumberString)) continue;
                    Dimension dimension = modelCacheHelper.getDimension(dimensionNumberString);
                    if (dimension == null) {
                        return dimensionAndMemberNumberMap;
                    }
                    dimensionList.add(dimension);
                }
                List sortedDimensionList = dimensionList.stream().sorted(Comparator.comparing(BaseCache::getSeq)).collect(Collectors.toList());
                LinkedHashMap newDimensionAndMemberNumberMap = Maps.newLinkedHashMapWithExpectedSize((int)(sortedDimensionList.size() + 1));
                if (dimensionAndMemberNumberMap.containsKey(SysDimensionEnum.Account.getNumber())) {
                    newDimensionAndMemberNumberMap.put(SysDimensionEnum.Account.getNumber(), dimensionAndMemberNumberMap.get(SysDimensionEnum.Account.getNumber()));
                }
                for (Dimension dimension : sortedDimensionList) {
                    newDimensionAndMemberNumberMap.put(dimension.getNumber(), dimensionAndMemberNumberMap.get(dimension.getNumber()));
                }
                return newDimensionAndMemberNumberMap;
            });
            relationGraphDataTrackingItemPojo.setDimensionAndMemberNumberMap(sortedDimensionAndMemberNumberMap);
            relationGraphDataTrackingItemPojo.setNameString(reportShowBizRuleMemberBo.getName());
            if (formulaPojo.getKeyString().equals(leftMemberKeyString)) {
                relationGraphDataTrackingItemPojo.setLeftBoolean(Boolean.valueOf(true));
            }
            relationGraphDataTrackingItemPojo.setDimensionAndMemberNumberSetMap(reportShowBizRuleMemberBo.getDimToMemMap());
            if (StringUtils.isNotEmpty((CharSequence)reportShowBizRuleMemberBo.getRefFunctionKey())) {
                relationGraphDataTrackingItemPojo.setRefFuncFlag(Boolean.valueOf(true));
            } else {
                relationGraphDataTrackingItemPojo.setRefFuncFlag(Boolean.valueOf(false));
            }
        });
        relationGraphNodeDataCellPojo.setStylePojo(new StylePojo().setColorString("#5582F3").setCursorString("pointer").setTextAlignString("center"));
        String nameString = reportShowBizRuleMemberBo.getName();
        formulaPojo.setValueString(nameString);
        String valueString = (String)LambdaUtils.get(() -> {
            if (reportShowBizRuleMemberBo.getOriginValueObject() != null) {
                return KdUtils.getNumberString((Object)reportShowBizRuleMemberBo.getOriginValueObject(), (Boolean)true, (Integer)2);
            }
            if (reportShowBizRuleMemberBo.getValue() != null) {
                return KdUtils.getNumberString((Object)reportShowBizRuleMemberBo.getValue(), (Boolean)true, (Integer)2);
            }
            return "NULL";
        });
        if (valueString == null) {
            valueString = ObjUtils.getString((Object)reportShowBizRuleMemberBo.getOriginValueObject());
        }
        if (valueString == null) {
            valueString = ObjUtils.getString((Object)reportShowBizRuleMemberBo.getValue());
        }
        relationGraphNodeDataCellPojo.setValueString(nameString + "</br>" + valueString);
        relationGraphNodeDataCellPojo.setTypeStringList((List)Lists.newArrayList((Object[])new String[]{RelationGraphTypeEnum.BACKGROUND_COLOR.name(), RelationGraphTypeEnum.RULE_MEMBER.name()}));
        ArrayList<MethodPojo> methodPojoList = new ArrayList<MethodPojo>(3);
        relationGraphNodeDataCellPojo.setMethodPojoList(methodPojoList);
        methodPojoList.add(new MethodPojo().setListenMethodNameString("mouseover"));
        methodPojoList.add(new MethodPojo().setListenMethodNameString("mouseout"));
        methodPojoList.add(new MethodPojo().setListenMethodNameString("click").setEventNameString(RelationGraphInteractionTypeEnum.CLICK_CELL.name()));
    }

    public static Map<String, ReportShowBizRuleMemberBo> getReportShowBizRuleMemberBoMap(ReportShowBizRuleBo reportShowBizRuleBo) {
        ReportShowBizRuleMemberBo leftReportShowBizRuleMemberBo = reportShowBizRuleBo.getLeftMember();
        List rightReportShowBizRuleMemberBoList = reportShowBizRuleBo.getRightMembers();
        LinkedHashMap reportShowBizRuleMemberBoMap = Maps.newLinkedHashMapWithExpectedSize((int)(rightReportShowBizRuleMemberBoList.size() + 1));
        reportShowBizRuleMemberBoMap.put(leftReportShowBizRuleMemberBo.getMemberKey(), leftReportShowBizRuleMemberBo);
        for (ReportShowBizRuleMemberBo reportShowBizRuleMemberBo : rightReportShowBizRuleMemberBoList) {
            reportShowBizRuleMemberBoMap.put(reportShowBizRuleMemberBo.getMemberKey(), reportShowBizRuleMemberBo);
        }
        return reportShowBizRuleMemberBoMap;
    }

    private static AnalysisContext getAnalysisContext(IFormView view) {
        String cacheStr = view.getPageCache().get(ANALYSIS_CONTEXT);
        if (StringUtils.isBlank((CharSequence)cacheStr)) {
            return null;
        }
        return (AnalysisContext)JSON.parseObject((String)cacheStr, AnalysisContext.class);
    }

    public static String getInfoHtmlString(String pageIdString, Long modelIdLong, RelationGraphDataTrackingItemPojo relationGraphDataTrackingItemPojo, ReportOrTaskPojo reportOrTaskPojo) {
        return RelationGraphService.getInfoHtmlString(pageIdString, modelIdLong, relationGraphDataTrackingItemPojo.getDimensionAndMemberNumberMap(), relationGraphDataTrackingItemPojo.getMemberPojoList(), reportOrTaskPojo);
    }

    public static String getNeedMatchInfoHtmlString(String pageIdString, Long modelIdLong, RelationGraphDataTrackingItemPojo relationGraphDataTrackingItemPojo, ReportOrTaskPojo reportOrTaskPojo) {
        Long businessModelIdLong = 0L;
        if (reportOrTaskPojo != null) {
            businessModelIdLong = reportOrTaskPojo.getBusinessModelIdLong();
        }
        List<ElementPojo> elementPojoList = RelationGraphService.getBaseInfoHtmlElementPojoList(modelIdLong, businessModelIdLong, relationGraphDataTrackingItemPojo.getMemberPojoList());
        if (reportOrTaskPojo == null || !Boolean.TRUE.equals(reportOrTaskPojo.getEnableMatchReportBoolean())) {
            return ElementUtils.getString(elementPojoList, (Boolean)false);
        }
        ElementPojo rootElementPojo = (ElementPojo)LambdaUtils.getTarget(elementPojoList, item -> "ROOT_STRING".equals(item.getUniqueKeyString()));
        if (rootElementPojo == null) {
            return null;
        }
        LambdaUtils.run(() -> {
            ArrayList dataElementPojoList = new ArrayList(16);
            ElementPojo dataRootElementPojo = (ElementPojo)LambdaUtils.get(() -> {
                ElementPojo elementPojo = ElementUtils.createDivElementPojo();
                elementPojo.setStylePojo(new StylePojo().setBackgroundColorString("white").setWhiteSpaceString("nowrap"));
                dataElementPojoList.add(elementPojo);
                return elementPojo;
            });
            LambdaUtils.get(() -> {
                ElementPojo elementPojo = ElementUtils.createDivElementPojo();
                elementPojo.setValueString(ResManager.loadKDString((String)"\u6240\u5c5e\u62a5\u8868", (String)"RelationGraphPlugin_49", (String)"epm-eb-formplugin", (Object[])new Object[0]));
                elementPojo.setParentElementPojo(dataRootElementPojo);
                elementPojo.setStylePojo(new StylePojo().setHeightString("30px").setLineHeightString("30px").setFontSizeString("15px").setFontWeightString("600"));
                dataElementPojoList.add(elementPojo);
                return elementPojo;
            });
            ElementPojo elementPojo2 = (ElementPojo)LambdaUtils.get(() -> {
                ElementPojo elementPojo = ElementUtils.createDivElementPojo();
                elementPojo.setStylePojo(new StylePojo().setBorderString("#F4F4F4 solid 2px").setPaddingLeftString("10px"));
                elementPojo.setParentElementPojo(dataRootElementPojo);
                dataElementPojoList.add(elementPojo);
                return elementPojo;
            });
            LambdaUtils.get(() -> {
                ElementPojo elementPojo = ElementUtils.createDivElementPojo();
                if (ProcessTypeEnum.REPORT.name().equals(reportOrTaskPojo.getTypeString())) {
                    elementPojo.setValueString(ResManager.loadKDString((String)"\u62a5\u8868\u7f16\u5236", (String)"RelationGraphPlugin_50", (String)"epm-eb-formplugin", (Object[])new Object[0]));
                } else {
                    elementPojo.setValueString(ResManager.loadKDString((String)"\u6211\u6267\u884c\u7684\u4efb\u52a1", (String)"RelationGraphPlugin_54", (String)"epm-eb-formplugin", (Object[])new Object[0]));
                }
                elementPojo.setStylePojo(new StylePojo().setHeightString("25px").setLineHeightString("25px").setFontSizeString("10px").setFontWeightString("600"));
                elementPojo.setParentElementPojo(elementPojo2);
                dataElementPojoList.add(elementPojo);
                return elementPojo;
            });
            LambdaUtils.get(() -> {
                ElementPojo elementPojo = ElementUtils.createDivElementPojo();
                elementPojo.setValueString(ResManager.loadKDString((String)"\u5339\u914d\u62a5\u8868", (String)"RelationGraphPlugin_78", (String)"epm-eb-formplugin", (Object[])new Object[0]));
                StylePojo stylePojo = new StylePojo();
                elementPojo.setStylePojo(stylePojo);
                stylePojo.setHeightString("25px");
                stylePojo.setLineHeightString("25px");
                stylePojo.setColorString("white");
                stylePojo.setCursorString("pointer");
                stylePojo.setWidthString("100%");
                stylePojo.setBorderString("1px solid #0E5FD8");
                stylePojo.setTextAlignString("center");
                stylePojo.setBackgroundColorString("#0E5FD8");
                stylePojo.setBorderRadiusString("3px");
                elementPojo.setParentElementPojo(elementPojo2);
                dataElementPojoList.add(elementPojo);
                HashMap attributeMap = Maps.newHashMapWithExpectedSize((int)1);
                EventPojo eventPojo = new EventPojo();
                eventPojo.setPageIdString(pageIdString);
                eventPojo.setPreventDefaultBoolean(Boolean.valueOf(true));
                eventPojo.setMethodNameString("windowFrontMethodProxy");
                eventPojo.setEvalPojo(new EvalPojo().setEvalStringList((List)Lists.newArrayList((Object[])new String[]{StrUtils.format((String)"vm.$options.methods.invoke(vm.CommonUtils.getMap(vm.CommonUtils.EVENT_NAME_STRING, '{}', 'relationGraphModelPojo', vm.$data.relationGraphModelPojo, '{}', '{}'));", (Object[])new Object[]{RelationGraphInteractionTypeEnum.MATCH_REPORT.name(), "relationGraphDataTrackingItemPojo", StrUtils.getBase64EncodeString((String)JsonUtils.getJsonString((Object)relationGraphDataTrackingItemPojo))})})));
                attributeMap.put("onclick", EventUtils.getEventFunctionString((EventPojo)eventPojo));
                elementPojo.setAttributeMap((Map)attributeMap);
                return elementPojo;
            });
            ((ElementPojo)dataElementPojoList.get(0)).setParentElementPojo(rootElementPojo);
            elementPojoList.addAll(dataElementPojoList);
        });
        return ElementUtils.getString(elementPojoList, (Boolean)false);
    }

    public static List<ElementPojo> getBaseInfoHtmlElementPojoList(Long modelIdLong, Long businessModelIdLong, List<MemberPojo> memberPojoList) {
        ArrayList<ElementPojo> elementPojoList = new ArrayList<ElementPojo>(16);
        ElementPojo zeroElementPojo = (ElementPojo)LambdaUtils.get(() -> {
            ElementPojo elementPojo = ElementUtils.createDivElementPojo();
            elementPojo.setUniqueKeyString("ORIGIN_STRING");
            elementPojo.setStylePojo(new StylePojo().setBackgroundColorString("white").setWhiteSpaceString("nowrap"));
            elementPojoList.add(elementPojo);
            return elementPojo;
        });
        ElementPojo rootElementPojo = (ElementPojo)LambdaUtils.get(() -> {
            ElementPojo elementPojo = ElementUtils.createDivElementPojo();
            elementPojo.setUniqueKeyString("ROOT_STRING");
            elementPojo.setStylePojo(new StylePojo().setMarginString("10px"));
            elementPojo.setParentElementPojo(zeroElementPojo);
            elementPojoList.add(elementPojo);
            return elementPojo;
        });
        LambdaUtils.get(() -> {
            ElementPojo elementPojo = ElementUtils.createDivElementPojo();
            elementPojo.setValueString(ResManager.loadKDString((String)"\u7ef4\u5ea6\u4fe1\u606f", (String)"RelationGraphPlugin_48", (String)"epm-eb-formplugin", (Object[])new Object[0]));
            elementPojo.setStylePojo(new StylePojo().setHeightString("30px").setLineHeightString("30px").setFontSizeString("15px").setFontWeightString("600"));
            elementPojo.setParentElementPojo(rootElementPojo);
            elementPojoList.add(elementPojo);
            return elementPojo;
        });
        ElementPojo elementPojo1Sub1 = (ElementPojo)LambdaUtils.get(() -> {
            ElementPojo elementPojo = ElementUtils.createDivElementPojo();
            elementPojo.setStylePojo(new StylePojo().setLineHeightString("30px").setBorderString("#F4F4F4 solid 1px"));
            elementPojo.setParentElementPojo(rootElementPojo);
            elementPojoList.add(elementPojo);
            return elementPojo;
        });
        ElementPojo elementPojo1Sub1Sub1 = (ElementPojo)LambdaUtils.get(() -> {
            ElementPojo elementPojo = ElementUtils.createDivElementPojo();
            elementPojo.setStylePojo(new StylePojo().setHeightString("30px").setBackgroundColorString("#F4F4F4"));
            elementPojo.setParentElementPojo(elementPojo1Sub1);
            elementPojoList.add(elementPojo);
            return elementPojo;
        });
        ElementPojo elementPojo1Sub1Sub1Sub1 = (ElementPojo)LambdaUtils.get(() -> {
            ElementPojo elementPojo = ElementUtils.createDivElementPojo();
            elementPojo.setValueString(ResManager.loadKDString((String)"\u7ef4\u5ea6", (String)"RelationGraphPlugin_44", (String)"epm-eb-formplugin", (Object[])new Object[0]));
            elementPojo.setStylePojo(new StylePojo().setPaddingLeftString("5px").setDisplayString("inline-block").setBorderString("#F4F4F4 solid 1px"));
            elementPojo.setParentElementPojo(elementPojo1Sub1Sub1);
            elementPojoList.add(elementPojo);
            return elementPojo;
        });
        ElementPojo elementPojo1Sub1Sub1Sub2 = (ElementPojo)LambdaUtils.get(() -> {
            ElementPojo elementPojo = ElementUtils.createDivElementPojo();
            elementPojo.setValueString(ResManager.loadKDString((String)"\u7ef4\u5ea6\u6210\u5458", (String)"RelationGraphPlugin_45", (String)"epm-eb-formplugin", (Object[])new Object[0]));
            elementPojo.setStylePojo(new StylePojo().setPaddingLeftString("5px").setDisplayString("inline-block").setBorderString("#F4F4F4 solid 1px"));
            elementPojo.setParentElementPojo(elementPojo1Sub1Sub1);
            elementPojoList.add(elementPojo);
            return elementPojo;
        });
        ElementPojo elementPojo1Sub1Sub1Sub3 = (ElementPojo)LambdaUtils.get(() -> {
            ElementPojo elementPojo = ElementUtils.createDivElementPojo();
            elementPojo.setValueString(ResManager.loadKDString((String)"\u7ef4\u5ea6\u6210\u5458\u7f16\u7801", (String)"RelationGraphPlugin_61", (String)"epm-eb-formplugin", (Object[])new Object[0]));
            elementPojo.setStylePojo(new StylePojo().setPaddingLeftString("5px").setDisplayString("inline-block").setBorderString("#F4F4F4 solid 1px"));
            elementPojo.setParentElementPojo(elementPojo1Sub1Sub1);
            elementPojoList.add(elementPojo);
            return elementPojo;
        });
        ElementPojo elementPojo1Sub1Sub1Sub4 = (ElementPojo)LambdaUtils.get(() -> {
            ElementPojo elementPojo = ElementUtils.createDivElementPojo();
            elementPojo.setValueString(ResManager.loadKDString((String)"\u662f\u5426\u4e3a\u660e\u7ec6\u6210\u5458", (String)"RelationGraphPlugin_64", (String)"epm-eb-formplugin", (Object[])new Object[0]));
            elementPojo.setStylePojo(new StylePojo().setPaddingLeftString("5px").setDisplayString("inline-block").setBorderString("#F4F4F4 solid 1px"));
            elementPojo.setParentElementPojo(elementPojo1Sub1Sub1);
            elementPojoList.add(elementPojo);
            return elementPojo;
        });
        int dimensionMaxCssLengthInt = RelationGraphUtils.getCssLength(elementPojo1Sub1Sub1Sub1.getValueString());
        int memberNameMaxCssLengthInt = RelationGraphUtils.getCssLength(elementPojo1Sub1Sub1Sub2.getValueString());
        int memberNumberMaxCssLengthInt = RelationGraphUtils.getCssLength(elementPojo1Sub1Sub1Sub3.getValueString());
        int leafMemberMaxCssLengthInt = RelationGraphUtils.getCssLength(elementPojo1Sub1Sub1Sub4.getValueString());
        for (MemberPojo memberPojo : memberPojoList) {
            Integer dimensionCssLengthInt = RelationGraphUtils.getCssLength(memberPojo.getDimensionPojo().getDimensionNameString());
            Integer memberNameCssLengthInt = RelationGraphUtils.getCssLength(memberPojo.getMemberNameString());
            Integer memberNumberCssLengthInt = RelationGraphUtils.getCssLength(memberPojo.getMemberNumberString());
            if (dimensionMaxCssLengthInt < dimensionCssLengthInt) {
                dimensionMaxCssLengthInt = dimensionCssLengthInt;
            }
            if (memberNameMaxCssLengthInt < memberNameCssLengthInt) {
                memberNameMaxCssLengthInt = memberNameCssLengthInt;
            }
            if (memberNumberMaxCssLengthInt >= memberNumberCssLengthInt) continue;
            memberNumberMaxCssLengthInt = memberNumberCssLengthInt;
        }
        memberNumberMaxCssLengthInt += 5;
        leafMemberMaxCssLengthInt += 5;
        elementPojo1Sub1Sub1Sub1.getStylePojo().setWidthString((dimensionMaxCssLengthInt += 5) + "px");
        elementPojo1Sub1Sub1Sub2.getStylePojo().setWidthString((memberNameMaxCssLengthInt += 5) + "px");
        elementPojo1Sub1Sub1Sub3.getStylePojo().setWidthString(memberNumberMaxCssLengthInt + "px");
        elementPojo1Sub1Sub1Sub4.getStylePojo().setWidthString(leafMemberMaxCssLengthInt + "px");
        elementPojo1Sub1.getStylePojo().setWidthString(dimensionMaxCssLengthInt + memberNameMaxCssLengthInt + memberNumberMaxCssLengthInt + leafMemberMaxCssLengthInt + "px");
        int finalDimensionMaxCssLengthInt = dimensionMaxCssLengthInt;
        int finalMemberNameMaxCssLengthInt = memberNameMaxCssLengthInt;
        int finalMemberNumberMaxCssLengthInt = memberNumberMaxCssLengthInt;
        int finalLeafMemberMaxCssLengthInt = leafMemberMaxCssLengthInt;
        String accountMemberNumberString = memberPojoList.stream().filter(item -> SysDimensionEnum.Account.getNumber().equals(item.getDimensionPojo().getDimensionNumberString())).map(item -> item.getMemberNumberString()).findFirst().orElse(null);
        Map viewMap = OlapUtils.getViewMap((Long)modelIdLong, (String)accountMemberNumberString);
        for (MemberPojo memberPojo : memberPojoList) {
            ElementPojo elementPojo1Sub1Subn = (ElementPojo)LambdaUtils.get(() -> {
                ElementPojo elementPojo = ElementUtils.createDivElementPojo();
                elementPojo.setStylePojo(new StylePojo().setHeightString("30px"));
                elementPojo.setParentElementPojo(elementPojo1Sub1);
                elementPojoList.add(elementPojo);
                return elementPojo;
            });
            LambdaUtils.get(() -> {
                ElementPojo elementPojo = ElementUtils.createDivElementPojo();
                elementPojo.setValueString(memberPojo.getDimensionPojo().getDimensionNameString());
                elementPojo.setStylePojo(new StylePojo().setDisplayString("inline-block").setWidthString(finalDimensionMaxCssLengthInt + "px").setBorderString("#F4F4F4 solid 1px").setPaddingLeftString("5px"));
                elementPojo.setParentElementPojo(elementPojo1Sub1Subn);
                elementPojoList.add(elementPojo);
                return elementPojo;
            });
            LambdaUtils.get(() -> {
                ElementPojo elementPojo = ElementUtils.createDivElementPojo();
                elementPojo.setValueString(memberPojo.getMemberNameString());
                elementPojo.setStylePojo(new StylePojo().setWidthString(finalMemberNameMaxCssLengthInt + "px").setDisplayString("inline-block").setBorderString("#F4F4F4 solid 1px").setPaddingLeftString("5px"));
                elementPojo.setParentElementPojo(elementPojo1Sub1Subn);
                elementPojoList.add(elementPojo);
                return elementPojo;
            });
            LambdaUtils.get(() -> {
                ElementPojo elementPojo = ElementUtils.createDivElementPojo();
                elementPojo.setValueString(memberPojo.getMemberNumberString());
                elementPojo.setStylePojo(new StylePojo().setWidthString(finalMemberNumberMaxCssLengthInt + "px").setDisplayString("inline-block").setBorderString("#F4F4F4 solid 1px").setPaddingLeftString("5px"));
                elementPojo.setParentElementPojo(elementPojo1Sub1Subn);
                elementPojoList.add(elementPojo);
                return elementPojo;
            });
            LambdaUtils.get(() -> {
                IModelCacheHelper modelCacheHelper = ModelCacheContext.getOrCreate((Long)modelIdLong);
                Member member = modelCacheHelper.getMemberByAnyView(businessModelIdLong, memberPojo.getDimensionPojo().getDimensionNumberString(), memberPojo.getMemberNumberString());
                ElementPojo elementPojo = ElementUtils.createDivElementPojo();
                if (member.isLeaf()) {
                    elementPojo.setValueString(ResManager.loadKDString((String)"\u662f", (String)"RelationGraphPlugin_65", (String)"epm-eb-formplugin", (Object[])new Object[0]));
                } else {
                    elementPojo.setValueString(ResManager.loadKDString((String)"\u5426", (String)"RelationGraphPlugin_66", (String)"epm-eb-formplugin", (Object[])new Object[0]));
                }
                elementPojo.setStylePojo(new StylePojo().setWidthString(finalLeafMemberMaxCssLengthInt + "px").setDisplayString("inline-block").setBorderString("#F4F4F4 solid 1px").setPaddingLeftString("5px"));
                elementPojo.setParentElementPojo(elementPojo1Sub1Subn);
                elementPojoList.add(elementPojo);
                return elementPojo;
            });
        }
        return elementPojoList;
    }

    public static String getInfoHtmlString(String pageIdString, Long modelIdLong, Map<String, String> dimensionAndMemberNumberMap, List<MemberPojo> memberPojoList, ReportOrTaskPojo reportOrTaskPojo) {
        List<ElementPojo> elementPojoList;
        ElementPojo rootElementPojo;
        Long businessModelIdLong = 0L;
        if (reportOrTaskPojo != null) {
            businessModelIdLong = reportOrTaskPojo.getBusinessModelIdLong();
        }
        if ((rootElementPojo = (ElementPojo)LambdaUtils.getTarget(elementPojoList = RelationGraphService.getBaseInfoHtmlElementPojoList(modelIdLong, businessModelIdLong, memberPojoList), item -> "ROOT_STRING".equals(item.getUniqueKeyString()))) == null) {
            return null;
        }
        List reportOrTaskElementPojoList = (List)LambdaUtils.get(() -> {
            if (reportOrTaskPojo == null) {
                return null;
            }
            IModelCacheHelper modelCacheHelper = ModelCacheContext.getOrCreate((Long)modelIdLong);
            String accountMemberNumberString = (String)dimensionAndMemberNumberMap.get(SysDimensionEnum.Account.getNumber());
            if (StringUtils.isBlank((CharSequence)accountMemberNumberString)) {
                return null;
            }
            Member accountMember = modelCacheHelper.getMember(SysDimensionEnum.Account.getNumber(), null, accountMemberNumberString);
            List dimensionList = modelCacheHelper.getDimensionList(accountMember.getDatasetId());
            if (dimensionList.size() != dimensionAndMemberNumberMap.size()) {
                return null;
            }
            List<ElementPojo> reportElementPojoList = RelationGraphService.getReportElementPojoList(reportOrTaskPojo, dimensionAndMemberNumberMap, pageIdString);
            if (CollectionUtils.isNotEmpty(reportElementPojoList)) {
                reportElementPojoList.get(0).setParentElementPojo(rootElementPojo);
                elementPojoList.addAll(reportElementPojoList);
                return reportElementPojoList;
            }
            List<ElementPojo> taskDataElementPojoList = RelationGraphService.getTaskDataElementPojoList(reportOrTaskPojo, dimensionAndMemberNumberMap, pageIdString);
            if (CollectionUtils.isNotEmpty(taskDataElementPojoList)) {
                taskDataElementPojoList.get(0).setParentElementPojo(rootElementPojo);
                elementPojoList.addAll(taskDataElementPojoList);
                return taskDataElementPojoList;
            }
            return null;
        });
        if (CollectionUtils.isEmpty((Collection)reportOrTaskElementPojoList)) {
            elementPojoList.addAll(RelationGraphService.dataElementPojoList(rootElementPojo));
        }
        return ElementUtils.getString(elementPojoList, (Boolean)false);
    }

    public static String getFirstInfoHtmlString(String pageIdString, Long modelIdLong, List<MemberPojo> memberPojoList, ReportOrTaskPojo reportOrTaskPojo) {
        List<ElementPojo> elementPojoList;
        ElementPojo rootElementPojo;
        Long businessModelIdLong = 0L;
        if (reportOrTaskPojo != null) {
            businessModelIdLong = reportOrTaskPojo.getBusinessModelIdLong();
        }
        if ((rootElementPojo = (ElementPojo)LambdaUtils.getTarget(elementPojoList = RelationGraphService.getBaseInfoHtmlElementPojoList(modelIdLong, businessModelIdLong, memberPojoList), item -> "ROOT_STRING".equals(item.getUniqueKeyString()))) == null) {
            return null;
        }
        LambdaUtils.run(() -> {
            List<ElementPojo> reportElementPojoList;
            if (reportOrTaskPojo == null) {
                return;
            }
            ProcessTypeEnum processTypeEnum = (ProcessTypeEnum)EnumUtils.getEnum(ProcessTypeEnum.class, (String)reportOrTaskPojo.getTypeString());
            if (processTypeEnum == null) {
                return;
            }
            List<ReportProcessPojo> reportProcessPojoList = RelationGraphService.getByIdReportProcessPojoList(reportOrTaskPojo.getReportProcessIdLong());
            ReportProcessPojo reportProcessPojo = (ReportProcessPojo)LambdaUtils.getTarget(reportProcessPojoList, item -> reportOrTaskPojo.getTypeString().equals(item.getReportProcessTypeString()) && reportOrTaskPojo.getReportProcessIdLong().equals(item.getReportProcessIdLong()));
            if (reportProcessPojo == null) {
                return;
            }
            if (ProcessTypeEnum.TASK == processTypeEnum) {
                List<ElementPojo> taskDataElementPojoList = RelationGraphService.getTaskDataElementPojoList(Lists.newArrayList((Object[])new ReportProcessPojo[]{reportProcessPojo}), pageIdString);
                if (CollectionUtils.isNotEmpty(taskDataElementPojoList)) {
                    taskDataElementPojoList.get(0).setParentElementPojo(rootElementPojo);
                    for (ElementPojo elementPojo : taskDataElementPojoList) {
                        StylePojo stylePojo;
                        if (!TASK_NUMBER.equals(elementPojo.getUniqueKeyString()) || (stylePojo = elementPojo.getStylePojo()) == null) continue;
                        stylePojo.setColorString("#b2b2b2");
                        elementPojo.setUniqueKeyString(null);
                    }
                    elementPojoList.addAll(taskDataElementPojoList);
                }
            } else if (ProcessTypeEnum.REPORT == processTypeEnum && CollectionUtils.isNotEmpty(reportElementPojoList = RelationGraphService.getReportElementPojoList(Lists.newArrayList((Object[])new ReportProcessPojo[]{reportProcessPojo}), pageIdString))) {
                reportElementPojoList.get(0).setParentElementPojo(rootElementPojo);
                for (ElementPojo elementPojo : reportElementPojoList) {
                    StylePojo stylePojo;
                    if (!REPORT_NUMBER.equals(elementPojo.getUniqueKeyString()) || (stylePojo = elementPojo.getStylePojo()) == null) continue;
                    stylePojo.setColorString("#b2b2b2");
                    elementPojo.setUniqueKeyString(null);
                }
                elementPojoList.addAll(reportElementPojoList);
            }
        });
        return ElementUtils.getString(elementPojoList, (Boolean)false);
    }

    public static List<ElementPojo> getReportElementPojoList(ReportOrTaskPojo reportOrTaskPojo, Map<String, String> dimensionAndMemberNumberMap, String pageIdString) {
        if (reportOrTaskPojo == null || !ProcessTypeEnum.REPORT.name().equals(reportOrTaskPojo.getTypeString())) {
            return null;
        }
        return RelationGraphService.getReportElementPojoList(RelationGraphService2.getMatchedReportProcessPojoList(reportOrTaskPojo, dimensionAndMemberNumberMap), pageIdString, dimensionAndMemberNumberMap);
    }

    public static List<ElementPojo> getReportElementPojoList(List<ReportProcessPojo> matchedReportProcessPojoList, String pageIdString) {
        return RelationGraphService.getReportElementPojoList(matchedReportProcessPojoList, pageIdString, null);
    }

    public static List<ElementPojo> getReportElementPojoList(List<ReportProcessPojo> matchedReportProcessPojoList, String pageIdString, Map<String, String> dimensionAndMemberNumberMap) {
        if (matchedReportProcessPojoList == null || matchedReportProcessPojoList.isEmpty()) {
            return null;
        }
        ArrayList<ElementPojo> dataElementPojoList = new ArrayList<ElementPojo>(16);
        ElementPojo dataRootElementPojo = (ElementPojo)LambdaUtils.get(() -> {
            ElementPojo elementPojo = ElementUtils.createDivElementPojo();
            StylePojo stylePojo = new StylePojo();
            elementPojo.setStylePojo(stylePojo);
            stylePojo.setBackgroundColorString("white");
            stylePojo.setWhiteSpaceString("nowrap");
            dataElementPojoList.add(elementPojo);
            return elementPojo;
        });
        LambdaUtils.get(() -> {
            ElementPojo elementPojo = ElementUtils.createDivElementPojo();
            elementPojo.setValueString(ResManager.loadKDString((String)"\u6240\u5c5e\u62a5\u8868", (String)"RelationGraphPlugin_49", (String)"epm-eb-formplugin", (Object[])new Object[0]));
            elementPojo.setParentElementPojo(dataRootElementPojo);
            StylePojo stylePojo = new StylePojo();
            elementPojo.setStylePojo(stylePojo);
            stylePojo.setHeightString("30px");
            stylePojo.setLineHeightString("30px");
            stylePojo.setFontSizeString("15px");
            stylePojo.setFontWeightString("600");
            dataElementPojoList.add(elementPojo);
            return elementPojo;
        });
        int sizeInt = matchedReportProcessPojoList.size();
        for (int i = 0; i < sizeInt; ++i) {
            ReportProcessPojo reportProcessPojo = matchedReportProcessPojoList.get(i);
            ElementPojo elementPojo2 = (ElementPojo)LambdaUtils.get(() -> {
                ElementPojo elementPojo = ElementUtils.createDivElementPojo();
                StylePojo stylePojo = new StylePojo();
                elementPojo.setStylePojo(stylePojo);
                stylePojo.setBorderString("#F4F4F4 solid 2px");
                stylePojo.setPaddingLeftString("10px");
                elementPojo.setParentElementPojo(dataRootElementPojo);
                dataElementPojoList.add(elementPojo);
                return elementPojo;
            });
            if (i != 0) {
                elementPojo2.getStylePojo().setMarginTopString("5px");
            }
            LambdaUtils.get(() -> {
                ElementPojo elementPojo = ElementUtils.createDivElementPojo();
                elementPojo.setValueString(ResManager.loadKDString((String)"\u62a5\u8868\u7f16\u5236", (String)"RelationGraphPlugin_50", (String)"epm-eb-formplugin", (Object[])new Object[0]));
                StylePojo stylePojo = new StylePojo();
                elementPojo.setStylePojo(stylePojo);
                stylePojo.setHeightString("25px");
                stylePojo.setLineHeightString("25px");
                stylePojo.setFontSizeString("10px");
                stylePojo.setFontWeightString("600");
                elementPojo.setParentElementPojo(elementPojo2);
                dataElementPojoList.add(elementPojo);
                return elementPojo;
            });
            LambdaUtils.get(() -> {
                ElementPojo elementPojo = ElementUtils.createDivElementPojo();
                elementPojo.setValueString(reportProcessPojo.getTemplatePojo().getTemplateNumberString());
                elementPojo.setUniqueKeyString(REPORT_NUMBER);
                StylePojo stylePojo = new StylePojo();
                elementPojo.setStylePojo(stylePojo);
                stylePojo.setColorString("#5582F3");
                stylePojo.setCursorString("pointer");
                stylePojo.setHeightString("25px");
                stylePojo.setLineHeightString("25px");
                stylePojo.setFontSizeString("10px");
                elementPojo.setParentElementPojo(elementPojo2);
                HashMap attributeMap = Maps.newHashMapWithExpectedSize((int)3);
                LambdaUtils.run(() -> {
                    EventPojo eventPojo = new EventPojo();
                    eventPojo.setPageIdString(pageIdString);
                    eventPojo.setPreventDefaultBoolean(Boolean.valueOf(true));
                    eventPojo.setMethodNameString("windowFrontMethodProxy");
                    String evalString = MapUtils.isEmpty((Map)dimensionAndMemberNumberMap) ? StrUtils.format((String)"vm.$options.methods.invoke(vm.CommonUtils.getMap(vm.CommonUtils.EVENT_NAME_STRING, '{}', 'relationGraphModelPojo', vm.$data.relationGraphModelPojo, 'reportProcessPojo', '{}'));", (Object[])new Object[]{RelationGraphInteractionTypeEnum.DATA_TRACKING_JUMP_TO_REPORT_NUMBER.name(), StrUtils.getBase64EncodeString((String)JsonUtils.getJsonString((Object)reportProcessPojo))}) : StrUtils.format((String)"vm.$options.methods.invoke(vm.CommonUtils.getMap(vm.CommonUtils.EVENT_NAME_STRING, '{}', 'relationGraphModelPojo', vm.$data.relationGraphModelPojo, 'reportProcessPojo', '{}', '{}', '{}'));", (Object[])new Object[]{RelationGraphInteractionTypeEnum.DATA_TRACKING_JUMP_TO_REPORT_NUMBER.name(), StrUtils.getBase64EncodeString((String)JsonUtils.getJsonString((Object)reportProcessPojo)), "dimensionAndMemberNumberMap", StrUtils.getBase64EncodeString((String)JsonUtils.getJsonString((Object)dimensionAndMemberNumberMap))});
                    eventPojo.setEvalPojo(new EvalPojo().setEvalStringList((List)Lists.newArrayList((Object[])new String[]{evalString})));
                    attributeMap.put("onclick", EventUtils.getEventFunctionString((EventPojo)eventPojo));
                });
                LambdaUtils.run(() -> {
                    EventPojo eventPojo = new EventPojo();
                    eventPojo.setPageIdString(pageIdString);
                    eventPojo.setPreventDefaultBoolean(Boolean.valueOf(true));
                    eventPojo.setMethodNameString("windowFrontMethodProxy");
                    eventPojo.setEvalPojo(new EvalPojo().setEvalStringList((List)Lists.newArrayList((Object[])new String[]{"event.target.style.backgroundColor = '#E1E7EE';"})));
                    attributeMap.put("onmouseover", EventUtils.getEventFunctionString((EventPojo)eventPojo));
                });
                LambdaUtils.run(() -> {
                    EventPojo eventPojo = new EventPojo();
                    eventPojo.setPageIdString(pageIdString);
                    eventPojo.setPreventDefaultBoolean(Boolean.valueOf(true));
                    eventPojo.setMethodNameString("windowFrontMethodProxy");
                    eventPojo.setEvalPojo(new EvalPojo().setEvalStringList((List)Lists.newArrayList((Object[])new String[]{"event.target.style.backgroundColor = 'unset';"})));
                    attributeMap.put("onmouseout", EventUtils.getEventFunctionString((EventPojo)eventPojo));
                });
                elementPojo.setAttributeMap((Map)attributeMap);
                dataElementPojoList.add(elementPojo);
                return elementPojo;
            });
            LambdaUtils.get(() -> {
                ElementPojo elementPojo = ElementUtils.createDivElementPojo();
                elementPojo.setValueString(ResManager.loadResFormat((String)"\u62a5\u8868\u540d\u79f0:%1", (String)"RelationGraphPlugin_63", (String)"epm-eb-formplugin", (Object[])new Object[]{reportProcessPojo.getTemplatePojo().getTemplateNameString()}));
                StylePojo stylePojo = new StylePojo();
                elementPojo.setStylePojo(stylePojo);
                stylePojo.setColorString("#b2b2b2");
                stylePojo.setHeightString("25px");
                stylePojo.setLineHeightString("25px");
                stylePojo.setFontSizeString("10px");
                elementPojo.setParentElementPojo(elementPojo2);
                dataElementPojoList.add(elementPojo);
                return elementPojo;
            });
            LambdaUtils.get(() -> {
                ElementPojo elementPojo = ElementUtils.createDivElementPojo();
                MemberPojo entityMemberPojo = (MemberPojo)LambdaUtils.getTarget((List)reportProcessPojo.getMemberPojoList(), itemMemberPojo -> itemMemberPojo != null && itemMemberPojo.getDimensionPojo() != null && SysDimensionEnum.Entity.getNumber().equals(itemMemberPojo.getDimensionPojo().getDimensionNumberString()));
                elementPojo.setValueString(ResManager.loadResFormat((String)"\u7f16\u5236\u7ec4\u7ec7:%1", (String)"RelationGraphPlugin_51", (String)"epm-eb-formplugin", (Object[])new Object[]{entityMemberPojo.getMemberNameString()}));
                StylePojo stylePojo = new StylePojo();
                elementPojo.setStylePojo(stylePojo);
                stylePojo.setColorString("#b2b2b2");
                stylePojo.setHeightString("25px");
                stylePojo.setLineHeightString("25px");
                stylePojo.setFontSizeString("10px");
                elementPojo.setParentElementPojo(elementPojo2);
                dataElementPojoList.add(elementPojo);
                return elementPojo;
            });
            LambdaUtils.get(() -> {
                ElementPojo elementPojo = ElementUtils.createDivElementPojo();
                String statusString = (String)LambdaUtils.get(() -> {
                    if (StringUtils.isBlank((CharSequence)reportProcessPojo.getStatusString()) || !NumberUtils.isCreatable((String)reportProcessPojo.getStatusString())) {
                        return null;
                    }
                    BgTaskStateEnum bgTaskStateEnum = (BgTaskStateEnum)LambdaUtils.getTarget((Object[])BgTaskStateEnum.values(), item -> item.getNumber().equals(reportProcessPojo.getStatusString()));
                    if (bgTaskStateEnum != null) {
                        if (bgTaskStateEnum == BgTaskStateEnum.INCOMPLETE) {
                            return ResManager.loadKDString((String)"\u5ba1\u6838\u672a\u901a\u8fc7", (String)"BgTaskExecutePlugin_98", (String)"epm-eb-formplugin", (Object[])new Object[0]);
                        }
                        return bgTaskStateEnum.getName();
                    }
                    return null;
                });
                if (StringUtils.isBlank((CharSequence)statusString)) {
                    statusString = ResManager.loadKDString((String)"\u672a\u77e5", (String)"RelationGraphPlugin_75", (String)"epm-eb-formplugin", (Object[])new Object[0]);
                }
                elementPojo.setValueString(ResManager.loadResFormat((String)"\u72b6\u6001:%1", (String)"RelationGraphPlugin_74", (String)"epm-eb-formplugin", (Object[])new Object[]{statusString}));
                StylePojo stylePojo = new StylePojo();
                elementPojo.setStylePojo(stylePojo);
                stylePojo.setColorString("#b2b2b2");
                stylePojo.setHeightString("25px");
                stylePojo.setLineHeightString("25px");
                stylePojo.setFontSizeString("10px");
                elementPojo.setParentElementPojo(elementPojo2);
                dataElementPojoList.add(elementPojo);
                return elementPojo;
            });
        }
        return dataElementPojoList;
    }

    public static List<ElementPojo> getTaskDataElementPojoList(ReportOrTaskPojo reportOrTaskPojo, Map<String, String> dimensionAndMemberNumberMap, String pageIdString) {
        if (reportOrTaskPojo == null || !ProcessTypeEnum.TASK.name().equals(reportOrTaskPojo.getTypeString())) {
            return null;
        }
        return RelationGraphService.getTaskDataElementPojoList(RelationGraphService2.getMatchedReportProcessPojoList(reportOrTaskPojo, dimensionAndMemberNumberMap), pageIdString, dimensionAndMemberNumberMap);
    }

    public static List<ElementPojo> getTaskDataElementPojoList(List<ReportProcessPojo> matchedReportProcessPojoList, String pageIdString) {
        return RelationGraphService.getTaskDataElementPojoList(matchedReportProcessPojoList, pageIdString, null);
    }

    public static List<ElementPojo> getTaskDataElementPojoList(List<ReportProcessPojo> matchedReportProcessPojoList, String pageIdString, Map<String, String> dimensionAndMemberNumberMap) {
        if (matchedReportProcessPojoList == null || matchedReportProcessPojoList.isEmpty()) {
            return null;
        }
        ArrayList<ElementPojo> dataElementPojoList = new ArrayList<ElementPojo>(16);
        ElementPojo dataRootElementPojo = (ElementPojo)LambdaUtils.get(() -> {
            ElementPojo elementPojo = ElementUtils.createDivElementPojo();
            StylePojo stylePojo = new StylePojo();
            elementPojo.setStylePojo(stylePojo);
            stylePojo.setBackgroundColorString("white");
            stylePojo.setWhiteSpaceString("nowrap");
            dataElementPojoList.add(elementPojo);
            return elementPojo;
        });
        LambdaUtils.get(() -> {
            ElementPojo elementPojo = ElementUtils.createDivElementPojo();
            elementPojo.setValueString(ResManager.loadKDString((String)"\u6240\u5c5e\u62a5\u8868", (String)"RelationGraphPlugin_49", (String)"epm-eb-formplugin", (Object[])new Object[0]));
            elementPojo.setParentElementPojo(dataRootElementPojo);
            StylePojo stylePojo = new StylePojo();
            elementPojo.setStylePojo(stylePojo);
            stylePojo.setHeightString("30px");
            stylePojo.setLineHeightString("30px");
            stylePojo.setFontSizeString("15px");
            stylePojo.setFontWeightString("600");
            dataElementPojoList.add(elementPojo);
            return elementPojo;
        });
        int sizeInt = matchedReportProcessPojoList.size();
        for (int i = 0; i < sizeInt; ++i) {
            ReportProcessPojo reportProcessPojo = matchedReportProcessPojoList.get(i);
            ElementPojo elementPojo2 = (ElementPojo)LambdaUtils.get(() -> {
                ElementPojo elementPojo = ElementUtils.createDivElementPojo();
                StylePojo stylePojo = new StylePojo();
                elementPojo.setStylePojo(stylePojo);
                stylePojo.setBorderString("#F4F4F4 solid 1px");
                elementPojo.setParentElementPojo(dataRootElementPojo);
                dataElementPojoList.add(elementPojo);
                return elementPojo;
            });
            if (i != 0) {
                elementPojo2.getStylePojo().setMarginTopString("5px");
            }
            LambdaUtils.get(() -> {
                ElementPojo elementPojo = ElementUtils.createDivElementPojo();
                elementPojo.setValueString(ResManager.loadKDString((String)"\u6211\u6267\u884c\u7684\u4efb\u52a1", (String)"RelationGraphPlugin_54", (String)"epm-eb-formplugin", (Object[])new Object[0]));
                StylePojo stylePojo = new StylePojo();
                elementPojo.setStylePojo(stylePojo);
                stylePojo.setHeightString("25px");
                stylePojo.setLineHeightString("25px");
                stylePojo.setFontSizeString("10px");
                stylePojo.setFontWeightString("600");
                stylePojo.setPaddingLeftString("5px");
                elementPojo.setParentElementPojo(elementPojo2);
                dataElementPojoList.add(elementPojo);
                return elementPojo;
            });
            LambdaUtils.get(() -> {
                ElementPojo elementPojo = ElementUtils.createDivElementPojo();
                elementPojo.setValueString(reportProcessPojo.getTemplatePojo().getTemplateNumberString());
                elementPojo.setUniqueKeyString(TASK_NUMBER);
                StylePojo stylePojo = new StylePojo();
                elementPojo.setStylePojo(stylePojo);
                stylePojo.setColorString("#5582F3");
                stylePojo.setCursorString("pointer");
                stylePojo.setHeightString("25px");
                stylePojo.setLineHeightString("25px");
                stylePojo.setFontSizeString("10px");
                stylePojo.setPaddingLeftString("5px");
                elementPojo.setParentElementPojo(elementPojo2);
                HashMap attributeMap = Maps.newHashMapWithExpectedSize((int)3);
                LambdaUtils.run(() -> {
                    EventPojo eventPojo = new EventPojo();
                    eventPojo.setPageIdString(pageIdString);
                    eventPojo.setPreventDefaultBoolean(Boolean.valueOf(true));
                    eventPojo.setMethodNameString("windowFrontMethodProxy");
                    String evalString = MapUtils.isEmpty((Map)dimensionAndMemberNumberMap) ? StrUtils.format((String)"vm.$options.methods.invoke(vm.CommonUtils.getMap(vm.CommonUtils.EVENT_NAME_STRING, '{}', 'relationGraphModelPojo', vm.$data.relationGraphModelPojo, 'reportProcessPojo', '{}'));", (Object[])new Object[]{RelationGraphInteractionTypeEnum.DATA_TRACKING_JUMP_TO_REPORT_NUMBER.name(), StrUtils.getBase64EncodeString((String)JsonUtils.getJsonString((Object)reportProcessPojo))}) : StrUtils.format((String)"vm.$options.methods.invoke(vm.CommonUtils.getMap(vm.CommonUtils.EVENT_NAME_STRING, '{}', 'relationGraphModelPojo', vm.$data.relationGraphModelPojo, 'reportProcessPojo', '{}', '{}', '{}'));", (Object[])new Object[]{RelationGraphInteractionTypeEnum.DATA_TRACKING_JUMP_TO_REPORT_NUMBER.name(), StrUtils.getBase64EncodeString((String)JsonUtils.getJsonString((Object)reportProcessPojo)), "dimensionAndMemberNumberMap", StrUtils.getBase64EncodeString((String)JsonUtils.getJsonString((Object)dimensionAndMemberNumberMap))});
                    eventPojo.setEvalPojo(new EvalPojo().setEvalStringList((List)Lists.newArrayList((Object[])new String[]{evalString})));
                    attributeMap.put("onclick", EventUtils.getEventFunctionString((EventPojo)eventPojo));
                });
                LambdaUtils.run(() -> {
                    EventPojo eventPojo = new EventPojo();
                    eventPojo.setPageIdString(pageIdString);
                    eventPojo.setPreventDefaultBoolean(Boolean.valueOf(true));
                    eventPojo.setMethodNameString("windowFrontMethodProxy");
                    eventPojo.setEvalPojo(new EvalPojo().setEvalStringList((List)Lists.newArrayList((Object[])new String[]{"event.target.style.backgroundColor = '#E1E7EE';"})));
                    attributeMap.put("onmouseover", EventUtils.getEventFunctionString((EventPojo)eventPojo));
                });
                LambdaUtils.run(() -> {
                    EventPojo eventPojo = new EventPojo();
                    eventPojo.setPageIdString(pageIdString);
                    eventPojo.setPreventDefaultBoolean(Boolean.valueOf(true));
                    eventPojo.setMethodNameString("windowFrontMethodProxy");
                    eventPojo.setEvalPojo(new EvalPojo().setEvalStringList((List)Lists.newArrayList((Object[])new String[]{"event.target.style.backgroundColor = 'unset';"})));
                    attributeMap.put("onmouseout", EventUtils.getEventFunctionString((EventPojo)eventPojo));
                });
                elementPojo.setAttributeMap((Map)attributeMap);
                dataElementPojoList.add(elementPojo);
                return elementPojo;
            });
            LambdaUtils.get(() -> {
                ElementPojo elementPojo = ElementUtils.createDivElementPojo();
                elementPojo.setValueString(ResManager.loadResFormat((String)"\u62a5\u8868\u540d\u79f0:%1", (String)"RelationGraphPlugin_63", (String)"epm-eb-formplugin", (Object[])new Object[]{reportProcessPojo.getTemplatePojo().getTemplateNameString()}));
                StylePojo stylePojo = new StylePojo();
                elementPojo.setStylePojo(stylePojo);
                stylePojo.setColorString("#b2b2b2");
                stylePojo.setHeightString("25px");
                stylePojo.setLineHeightString("25px");
                stylePojo.setFontSizeString("10px");
                stylePojo.setPaddingLeftString("5px");
                elementPojo.setParentElementPojo(elementPojo2);
                dataElementPojoList.add(elementPojo);
                return elementPojo;
            });
            LambdaUtils.get(() -> {
                ElementPojo elementPojo = ElementUtils.createDivElementPojo();
                MemberPojo entityMemberPojo = (MemberPojo)LambdaUtils.getTarget((List)reportProcessPojo.getMemberPojoList(), itemMemberPojo -> itemMemberPojo != null && itemMemberPojo.getDimensionPojo() != null && SysDimensionEnum.Entity.getNumber().equals(itemMemberPojo.getDimensionPojo().getDimensionNumberString()));
                String memberName = entityMemberPojo == null ? "" : entityMemberPojo.getMemberNameString();
                elementPojo.setValueString(ResManager.loadResFormat((String)"\u7f16\u5236\u7ec4\u7ec7:%1", (String)"RelationGraphPlugin_51", (String)"epm-eb-formplugin", (Object[])new Object[]{memberName}));
                StylePojo stylePojo = new StylePojo();
                elementPojo.setStylePojo(stylePojo);
                stylePojo.setColorString("#b2b2b2");
                stylePojo.setHeightString("25px");
                stylePojo.setLineHeightString("25px");
                stylePojo.setFontSizeString("10px");
                stylePojo.setPaddingLeftString("5px");
                elementPojo.setParentElementPojo(elementPojo2);
                dataElementPojoList.add(elementPojo);
                return elementPojo;
            });
            LambdaUtils.get(() -> {
                ElementPojo elementPojo = ElementUtils.createDivElementPojo();
                String statusString = (String)LambdaUtils.get(() -> {
                    if (StringUtils.isBlank((CharSequence)reportProcessPojo.getStatusString()) || !NumberUtils.isCreatable((String)reportProcessPojo.getStatusString())) {
                        return null;
                    }
                    BgTaskStateEnum bgTaskStateEnum = (BgTaskStateEnum)LambdaUtils.getTarget((Object[])BgTaskStateEnum.values(), item -> item.getNumber().equals(reportProcessPojo.getStatusString()));
                    if (bgTaskStateEnum != null) {
                        if (bgTaskStateEnum == BgTaskStateEnum.INCOMPLETE) {
                            return ResManager.loadKDString((String)"\u5ba1\u6838\u672a\u901a\u8fc7", (String)"BgTaskExecutePlugin_98", (String)"epm-eb-formplugin", (Object[])new Object[0]);
                        }
                        return bgTaskStateEnum.getName();
                    }
                    return null;
                });
                if (StringUtils.isBlank((CharSequence)statusString)) {
                    statusString = ResManager.loadKDString((String)"\u672a\u77e5", (String)"RelationGraphPlugin_75", (String)"epm-eb-formplugin", (Object[])new Object[0]);
                }
                elementPojo.setValueString(ResManager.loadResFormat((String)"\u72b6\u6001:%1", (String)"RelationGraphPlugin_74", (String)"epm-eb-formplugin", (Object[])new Object[]{statusString}));
                StylePojo stylePojo = new StylePojo();
                elementPojo.setStylePojo(stylePojo);
                stylePojo.setColorString("#b2b2b2");
                stylePojo.setHeightString("25px");
                stylePojo.setLineHeightString("25px");
                stylePojo.setFontSizeString("10px");
                stylePojo.setPaddingLeftString("5px");
                elementPojo.setParentElementPojo(elementPojo2);
                dataElementPojoList.add(elementPojo);
                return elementPojo;
            });
        }
        return dataElementPojoList;
    }

    public static List<ElementPojo> dataElementPojoList(ElementPojo rootElementPojo) {
        ArrayList<ElementPojo> dataElementPojoList = new ArrayList<ElementPojo>(3);
        ElementPojo dataRootElementPojo = (ElementPojo)LambdaUtils.get(() -> {
            ElementPojo elementPojo = ElementUtils.createDivElementPojo();
            elementPojo.setParentElementPojo(rootElementPojo);
            StylePojo stylePojo = new StylePojo();
            elementPojo.setStylePojo(stylePojo);
            stylePojo.setBackgroundColorString("white");
            stylePojo.setWhiteSpaceString("nowrap");
            dataElementPojoList.add(elementPojo);
            return elementPojo;
        });
        LambdaUtils.get(() -> {
            ElementPojo elementPojo = ElementUtils.createDivElementPojo();
            elementPojo.setValueString(ResManager.loadKDString((String)"\u6240\u5c5e\u62a5\u8868", (String)"RelationGraphPlugin_49", (String)"epm-eb-formplugin", (Object[])new Object[0]));
            elementPojo.setParentElementPojo(dataRootElementPojo);
            StylePojo stylePojo = new StylePojo();
            elementPojo.setStylePojo(stylePojo);
            stylePojo.setHeightString("30px");
            stylePojo.setLineHeightString("30px");
            stylePojo.setFontSizeString("15px");
            stylePojo.setFontWeightString("600");
            dataElementPojoList.add(elementPojo);
            return elementPojo;
        });
        LambdaUtils.get(() -> {
            ElementPojo elementPojo = ElementUtils.createDivElementPojo();
            elementPojo.setValueString(ResManager.loadKDString((String)"\u672a\u5339\u914d\u5230\u76f8\u5173\u62a5\u8868\u3002", (String)"RelationGraphPlugin_62", (String)"epm-eb-formplugin", (Object[])new Object[0]));
            elementPojo.setParentElementPojo(dataRootElementPojo);
            StylePojo stylePojo = new StylePojo();
            elementPojo.setStylePojo(stylePojo);
            stylePojo.setColorString("#b2b2b2");
            stylePojo.setHeightString("25px");
            stylePojo.setLineHeightString("25px");
            stylePojo.setFontSizeString("10px");
            stylePojo.setPaddingLeftString("5px");
            dataElementPojoList.add(elementPojo);
            return elementPojo;
        });
        return dataElementPojoList;
    }

    public static List<ReportProcessPojo> getTargetReportProcessPojoList(IModelCacheHelper modelCacheHelper, List<ReportProcessPojo> reportProcessPojoList, Member entityMember, Map<String, Long> viewMap, Map<String, Long> analyzeViewMap, Long busModelByDataSet) {
        if (entityMember == null) {
            return null;
        }
        List<ReportProcessPojo> targetReportProcessPojoList = reportProcessPojoList.stream().filter(item -> {
            MemberPojo memberPojo = (MemberPojo)LambdaUtils.getTarget((List)item.getMemberPojoList(), itemMemberPojo -> itemMemberPojo != null && itemMemberPojo.getDimensionPojo() != null && SysDimensionEnum.Entity.getNumber().equals(itemMemberPojo.getDimensionPojo().getDimensionNumberString()));
            if (memberPojo == null) {
                return false;
            }
            Member member = modelCacheHelper.getMember(SysDimensionEnum.Entity.getNumber(), (Long)viewMap.get(SysDimensionEnum.Entity.getNumber()), memberPojo.getMemberNumberString());
            if (member != null && member.isAnalyzeMember() && MapUtils.isNotEmpty((Map)analyzeViewMap)) {
                Long viewIdLong = modelCacheHelper.getAnalyzeMemberViewId((Long)analyzeViewMap.get(SysDimensionEnum.Entity.getNumber()), member);
                member = modelCacheHelper.getMember(SysDimensionEnum.Entity.getNumber(), viewIdLong, member.getNumber());
                for (Member analyzeMember : member.getAllMembers()) {
                    if (!entityMember.getNumber().equals(analyzeMember.getNumber())) continue;
                    return true;
                }
            }
            return entityMember.getNumber().equals(memberPojo.getMemberNumberString());
        }).collect(Collectors.toList());
        if (targetReportProcessPojoList.isEmpty()) {
            String parentMemberNumberString = entityMember.getParentNumber();
            if (StringUtils.isBlank((CharSequence)parentMemberNumberString)) {
                return null;
            }
            Member parentEntityMember = modelCacheHelper.getMemberByAnyView(busModelByDataSet, SysDimensionEnum.Entity.getNumber(), parentMemberNumberString);
            if (parentEntityMember == null) {
                return null;
            }
            return RelationGraphService.getTargetReportProcessPojoList(modelCacheHelper, reportProcessPojoList, parentEntityMember, viewMap, analyzeViewMap, busModelByDataSet);
        }
        return targetReportProcessPojoList;
    }

    public static List<ReportProcessPojo> getReportProcessPojoList(Long modelIdLong) {
        return RelationGraphService.getReportProcessPojoList(ReportProcessServiceImpl.getInstance().getReportProcessList(modelIdLong, Boolean.valueOf(true)));
    }

    public static List<ReportProcessPojo> getByIdReportProcessPojoList(Long reportProcessIdLong) {
        if (ObjUtils.nullOrZero((Long[])new Long[]{reportProcessIdLong})) {
            return null;
        }
        return RelationGraphService.getReportProcessPojoList(ReportProcessServiceImpl.getInstance().getReportProcessList((Set)Sets.newHashSet((Object[])new Long[]{reportProcessIdLong})));
    }

    public static List<ReportProcessPojo> getReportProcessPojoList(List<ReportProcess> reportProcessList) {
        if (CollectionUtils.isEmpty(reportProcessList)) {
            return null;
        }
        Long modelIdLong = reportProcessList.get(0).getModelId();
        Map memberPojoKeyMap = (Map)LambdaUtils.get(() -> {
            IModelCacheHelper modelCacheHelper = ModelCacheContext.getOrCreate((Long)modelIdLong);
            HashMap resultMemberPojoKeyMap = Maps.newHashMapWithExpectedSize((int)reportProcessList.size());
            for (ReportProcess reportProcess : reportProcessList) {
                HashMap dimensionNumberAndMemberIdLongMap = Maps.newHashMapWithExpectedSize((int)4);
                dimensionNumberAndMemberIdLongMap.put(SysDimensionEnum.Entity.getNumber(), reportProcess.getEntityId());
                dimensionNumberAndMemberIdLongMap.put(SysDimensionEnum.Version.getNumber(), reportProcess.getVersionId());
                dimensionNumberAndMemberIdLongMap.put(SysDimensionEnum.DataType.getNumber(), reportProcess.getDataTypeId());
                dimensionNumberAndMemberIdLongMap.put(SysDimensionEnum.BudgetPeriod.getNumber(), reportProcess.getPeriodId());
                dimensionNumberAndMemberIdLongMap.forEach((dimensionNumberString, memberIdLong) -> {
                    Member member;
                    Dimension dimension = modelCacheHelper.getDimension(dimensionNumberString);
                    if (dimension == null) {
                        return;
                    }
                    if (!ObjUtils.notNullOrZero((Long[])new Long[]{memberIdLong})) {
                        return;
                    }
                    Long viewId = null;
                    if (SysDimensionEnum.Entity.getNumber().equals(dimensionNumberString)) {
                        viewId = reportProcess.getEntityViewId();
                    }
                    if ((member = dimension.getMember(viewId, memberIdLong)) == null) {
                        return;
                    }
                    String keyString = String.join((CharSequence)"!", dimensionNumberString, ObjUtils.getString((Object)member.getId()));
                    if (resultMemberPojoKeyMap.containsKey(keyString)) {
                        return;
                    }
                    MemberPojo memberPojo = new MemberPojo();
                    memberPojo.setMemberIdLong(member.getId());
                    memberPojo.setMemberNumberString(member.getNumber());
                    memberPojo.setMemberNameString(member.getName());
                    DimensionPojo dimensionPojo = new DimensionPojo();
                    memberPojo.setDimensionPojo(dimensionPojo);
                    dimensionPojo.setDimensionIdLong(dimension.getId());
                    dimensionPojo.setDimensionNumberString(dimension.getNumber());
                    dimensionPojo.setDimensionNameString(dimension.getName());
                    resultMemberPojoKeyMap.put(keyString, memberPojo);
                });
            }
            return resultMemberPojoKeyMap;
        });
        Map<Long, ReportProcess> reportProcessMap = reportProcessList.stream().collect(Collectors.toMap(ReportProcess::getId, item -> item));
        List reportProcessPojoList = (List)LambdaUtils.get(() -> {
            Map reportProcessQuoteMap = ReportProcessQuoteService.getInstance().getReportProcessQuote(reportProcessMap.keySet(), modelIdLong);
            if (MapUtils.isEmpty((Map)reportProcessQuoteMap)) {
                return null;
            }
            ArrayList<ReportProcessPojo> resultReportProcessPojoList = new ArrayList<ReportProcessPojo>(16);
            Collection reportProcessQuoteSetCollection = reportProcessQuoteMap.values();
            for (Set reportProcessQuoteSet : reportProcessQuoteSetCollection) {
                if (CollectionUtils.isEmpty((Collection)reportProcessQuoteSet)) continue;
                for (ReportProcessQuote reportProcessQuote : reportProcessQuoteSet) {
                    ReportProcessPojo reportProcessPojo = new ReportProcessPojo();
                    resultReportProcessPojoList.add(reportProcessPojo);
                    reportProcessPojo.setReportProcessTypeString(reportProcessQuote.getProcessTypeEnum().name());
                    reportProcessPojo.setReportOrTaskIdLong(reportProcessQuote.getReportOrTaskIdLong());
                    reportProcessPojo.setTaskOrAssignId(reportProcessQuote.getSourceId2());
                    reportProcessPojo.setReportProcessIdLong(reportProcessQuote.getReportProcessId());
                    if (ProcessTypeEnum.TASK == reportProcessQuote.getProcessTypeEnum()) {
                        reportProcessPojo.setTaskListIdLong(reportProcessQuote.getSourceId());
                    }
                    ReportProcess reportProcess = (ReportProcess)reportProcessMap.get(reportProcessPojo.getReportProcessIdLong());
                    List memberPojoList = (List)LambdaUtils.get(() -> {
                        ArrayList resultMemberPojoList = new ArrayList(4);
                        resultMemberPojoList.add(memberPojoKeyMap.get(String.join((CharSequence)"!", SysDimensionEnum.Entity.getNumber(), ObjUtils.getString((Object)reportProcess.getEntityId()))));
                        resultMemberPojoList.add(memberPojoKeyMap.get(String.join((CharSequence)"!", SysDimensionEnum.Version.getNumber(), ObjUtils.getString((Object)reportProcess.getVersionId()))));
                        resultMemberPojoList.add(memberPojoKeyMap.get(String.join((CharSequence)"!", SysDimensionEnum.DataType.getNumber(), ObjUtils.getString((Object)reportProcess.getDataTypeId()))));
                        resultMemberPojoList.add(memberPojoKeyMap.get(String.join((CharSequence)"!", SysDimensionEnum.BudgetPeriod.getNumber(), ObjUtils.getString((Object)reportProcess.getPeriodId()))));
                        return resultMemberPojoList.stream().filter(Objects::nonNull).collect(Collectors.toList());
                    });
                    reportProcessPojo.setMemberPojoList(memberPojoList);
                }
            }
            return resultReportProcessPojoList;
        });
        LambdaUtils.run(() -> {
            Set templateIdLongSet = reportProcessList.stream().map(ReportProcess::getTemplateId).collect(Collectors.toSet());
            if (CollectionUtils.isEmpty(templateIdLongSet)) {
                return;
            }
            Map ebTemplateMap = OrmBuilder.clazz(EbTemplate.class).field(new String[]{"fid", "fdata", "fnumber", "fname", "fdatasetid"}).whereIn("fid", templateIdLongSet).toLongRowMap("fid");
            if (MapUtils.isEmpty((Map)ebTemplateMap)) {
                return;
            }
            LambdaUtils.run(() -> {
                Map<Long, TemplatePojo> templatePojoMap = ebTemplateMap.entrySet().stream().collect(Collectors.toMap(item -> ((EbTemplate)item.getValue()).getIdLong(), item -> {
                    TemplatePojo templatePojo = new TemplatePojo();
                    EbTemplate ebTemplate = (EbTemplate)item.getValue();
                    templatePojo.setTemplateIdLong(ebTemplate.getIdLong());
                    templatePojo.setTemplateNumberString(ebTemplate.getNumberString());
                    templatePojo.setTemplateNameString(ebTemplate.getNameString());
                    templatePojo.setDatasetIdLong(ebTemplate.getDatasetidLong());
                    return templatePojo;
                }));
                for (ReportProcessPojo reportProcessPojo : reportProcessPojoList) {
                    ReportProcess reportProcess = (ReportProcess)reportProcessMap.get(reportProcessPojo.getReportProcessIdLong());
                    TemplatePojo templatePojo = templatePojoMap.get(reportProcess.getTemplateId());
                    reportProcessPojo.setTemplatePojo(templatePojo);
                }
            });
            LambdaUtils.run(() -> {
                Map<Long, Map<String, Set<String>>> templateIdAndDimNumberAndMemberSetNumberMap = RelationGraphService.getTemplateIdAndDimNumberAndMemberNumberSetMap(modelIdLong, ebTemplateMap.values());
                if (MapUtils.isEmpty(templateIdAndDimNumberAndMemberSetNumberMap)) {
                    return;
                }
                Set reportOrTaskIdLongSet = reportProcessPojoList.stream().map(ReportProcessPojo::getReportOrTaskIdLong).collect(Collectors.toSet());
                if (CollectionUtils.isEmpty(reportOrTaskIdLongSet)) {
                    return;
                }
                List ebTaskvariablesetList = OrmBuilder.clazz(EbTaskvariableset.class).field(new String[]{"fid", "fdimension", "fvariablejsontext"}).whereIn("fid", reportOrTaskIdLongSet).toRowList();
                Map<String, Map<String, Set<String>>> variableIdAndDimNumberMemberNumberSetMap = RelationGraphService.getVariableIdAndDimNumberMemberNumberSetMap(ebTaskvariablesetList, modelIdLong);
                for (ReportProcessPojo reportProcessPojo : reportProcessPojoList) {
                    Map<String, Set<String>> variableDimensionAndMemberSetNumberMap;
                    ReportProcess reportProcess = (ReportProcess)reportProcessMap.get(reportProcessPojo.getReportProcessIdLong());
                    reportProcessPojo.setStatusString(reportProcess.getStatus());
                    Map<String, Set<String>> dimNumberAndMemberNumberCollecionMap = templateIdAndDimNumberAndMemberSetNumberMap.get(reportProcess.getTemplateId());
                    if (MapUtils.isEmpty(dimNumberAndMemberNumberCollecionMap)) continue;
                    LinkedHashMap<String, Set<String>> dimensionAndMemberSetNumberMap = new LinkedHashMap<String, Set<String>>(dimNumberAndMemberNumberCollecionMap);
                    if (MapUtils.isNotEmpty(variableIdAndDimNumberMemberNumberSetMap) && MapUtils.isNotEmpty(variableDimensionAndMemberSetNumberMap = variableIdAndDimNumberMemberNumberSetMap.get(ObjUtils.getString((Object)reportProcessPojo.getReportOrTaskIdLong())))) {
                        for (Map.Entry<String, Set<String>> variableDimensionAndMemberSetNumberMapEntry : variableDimensionAndMemberSetNumberMap.entrySet()) {
                            String variableDimensionNumberString = variableDimensionAndMemberSetNumberMapEntry.getKey();
                            Set<String> memberNumberStringSet = variableDimensionAndMemberSetNumberMapEntry.getValue();
                            if (CollectionUtils.isEmpty(memberNumberStringSet)) {
                                return;
                            }
                            dimensionAndMemberSetNumberMap.computeIfAbsent(variableDimensionNumberString, k -> new LinkedHashSet(16)).addAll(memberNumberStringSet);
                        }
                    }
                    LambdaUtils.run(() -> {
                        Set budgetPeriodMemberNumberStringSet = dimensionAndMemberSetNumberMap.entrySet().stream().filter(item -> SysDimensionEnum.BudgetPeriod.getNumber().equals(item.getKey())).map(Map.Entry::getValue).flatMap(Collection::stream).collect(Collectors.toSet());
                        if (CollectionUtils.isEmpty(budgetPeriodMemberNumberStringSet)) {
                            return;
                        }
                        Pair matchedAndNotMatchedListPair = LambdaUtils.getMatchedAndNotMatchedListPair(budgetPeriodMemberNumberStringSet, item -> item.startsWith("@"));
                        List variableNumberStringList = (List)matchedAndNotMatchedListPair.getLeft();
                        if (CollectionUtils.isEmpty((Collection)variableNumberStringList)) {
                            return;
                        }
                        Map varValueMap = (Map)LambdaUtils.get(() -> {
                            if (ProcessTypeEnum.REPORT.name().equals(reportProcessPojo.getReportProcessTypeString())) {
                                return ReportVarUtil.getVarValues((Integer)ProcessTypeEnum.REPORT.getIndex(), (Long)modelIdLong, (Long)reportProcessPojo.getTaskOrAssignId());
                            }
                            return ReportVarUtil.getVarValues((Integer)ProcessTypeEnum.TASK.getIndex(), (Long)modelIdLong, (Long)reportProcessPojo.getTaskListIdLong());
                        });
                        if (MapUtils.isEmpty((Map)varValueMap)) {
                            return;
                        }
                        Set realMemberNumberStringSet = variableNumberStringList.stream().map(item -> ReportVarUtil.getRealDimByVar((Long)modelIdLong, (String)item, (String)SysDimensionEnum.BudgetPeriod.getNumber(), (Map)varValueMap)).collect(Collectors.toSet());
                        if (CollectionUtils.isEmpty(realMemberNumberStringSet)) {
                            return;
                        }
                        dimensionAndMemberSetNumberMap.put(SysDimensionEnum.BudgetPeriod.getNumber(), (Set<String>)Sets.union(new HashSet((Collection)matchedAndNotMatchedListPair.getRight()), realMemberNumberStringSet));
                    });
                    LambdaUtils.run(() -> {
                        Set entityMemberNumberStringSet = (Set)dimensionAndMemberSetNumberMap.get(SysDimensionEnum.Entity.getNumber());
                        if (CollectionUtils.isNotEmpty((Collection)entityMemberNumberStringSet)) {
                            return;
                        }
                        MemberPojo entityMemberPojo = (MemberPojo)LambdaUtils.getTarget((List)reportProcessPojo.getMemberPojoList(), item -> item.getDimensionPojo() != null && SysDimensionEnum.Entity.getNumber().equals(item.getDimensionPojo().getDimensionNumberString()));
                        if (entityMemberPojo == null) {
                            return;
                        }
                        dimensionAndMemberSetNumberMap.put(SysDimensionEnum.Entity.getNumber(), Sets.newHashSet((Object[])new String[]{entityMemberPojo.getMemberNumberString()}));
                    });
                    reportProcessPojo.setDimensionAndMemberSetNumberMap(dimensionAndMemberSetNumberMap);
                }
            });
        });
        return reportProcessPojoList;
    }

    public static Map<Long, Map<String, Set<String>>> getTemplateIdAndDimNumberAndMemberNumberSetMap(Long modelIdLong, Collection<EbTemplate> ebTemplateCollection) {
        if (CollectionUtils.isEmpty(ebTemplateCollection)) {
            return null;
        }
        LinkedHashMap<Long, Map<String, Set<String>>> templateIdAndDimNumberAndMemberNumberSetMap = new LinkedHashMap<Long, Map<String, Set<String>>>(16);
        IModelCacheHelper modelCacheHelper = ModelCacheContext.getOrCreate((Long)modelIdLong);
        MemberPropCache memberPropCache = MemberPropCacheService.getOrCreate((Long)modelIdLong);
        for (EbTemplate ebTemplate : ebTemplateCollection) {
            ITemplateModel templateModel;
            Long templateIdLong = ebTemplate.getIdLong();
            String dataString = ebTemplate.getDataString();
            if (StringUtils.isBlank((CharSequence)dataString) || (templateModel = dataString.startsWith("{") ? FixtemplateSerializerUtil.read((String)dataString) : TemplateModelJSONUtil.parseITemplateModel((String)dataString)) == null) continue;
            Map viewMap = modelCacheHelper.getViewsByDataSet(ebTemplate.getDatasetidLong());
            Map baseViewMap = modelCacheHelper.getViewsByDataSetIncludeBase(ebTemplate.getDatasetidLong());
            LinkedHashMap finalDimNumberAndMemberNumberMap = new LinkedHashMap(16);
            LambdaUtils.run(() -> {
                List pageDimPropEntryList = templateModel.getPagemembpropentry();
                if (CollectionUtils.isEmpty((Collection)pageDimPropEntryList)) {
                    return;
                }
                for (IPageDimPropEntry pageDimPropEntry : pageDimPropEntryList) {
                    IDimension dimension = pageDimPropEntry.getDimension();
                    List propertyEntryList = pageDimPropEntry.getPropertyEntries();
                    if (CollectionUtils.isEmpty((Collection)propertyEntryList)) continue;
                    for (PropertyEntry propertyEntry : propertyEntryList) {
                        List propertyValueEntryList = propertyEntry.getPropertyValueEntries();
                        if (CollectionUtils.isEmpty((Collection)propertyValueEntryList)) continue;
                        for (PropertyValueEntry propertyValueEntry : propertyValueEntryList) {
                            List memberList = memberPropCache.getMembersByPropValues(dimension.getId(), (Long)viewMap.get(dimension.getNumber()), propertyValueEntry.getId());
                            if (CollectionUtils.isEmpty((Collection)memberList)) continue;
                            Set memberNumberStringSet = finalDimNumberAndMemberNumberMap.computeIfAbsent(dimension.getNumber(), k -> new LinkedHashSet(16));
                            memberNumberStringSet.addAll(memberList.stream().map(item -> item.getNumber()).collect(Collectors.toSet()));
                        }
                    }
                }
            });
            LambdaUtils.run(() -> {
                Map membersWithScopeMap = templateModel.retrieveRowColMembersWithScope();
                if (MapUtils.isEmpty((Map)membersWithScopeMap)) {
                    return;
                }
                for (Map.Entry membersWithScopeMapEntry : membersWithScopeMap.entrySet()) {
                    String dimensionNumberString = (String)membersWithScopeMapEntry.getKey();
                    Collection memberCollection = (Collection)membersWithScopeMapEntry.getValue();
                    if (CollectionUtils.isEmpty((Collection)memberCollection)) continue;
                    Pair matchedAndNotMatchedListPair = LambdaUtils.getMatchedAndNotMatchedListPair((Collection)memberCollection, item -> item.getNumber().startsWith("@"));
                    Set variableMemberNumberStringSet = ((List)matchedAndNotMatchedListPair.getLeft()).stream().map(item -> item.getNumber()).collect(Collectors.toSet());
                    Set itemMemberNumberStringSet = ((List)matchedAndNotMatchedListPair.getRight()).stream().map(item -> (List)LambdaUtils.get(() -> {
                        Member member;
                        int rangeInt = item.getRange();
                        if (rangeInt <= 0) {
                            rangeInt = RangeEnum.ONLY.getIndex();
                        }
                        if ((member = modelCacheHelper.getMember(dimensionNumberString, (Long)viewMap.get(dimensionNumberString), item.getNumber())) == null) {
                            return null;
                        }
                        if (!member.isAnalyzeMember()) {
                            return modelCacheHelper.getMember(dimensionNumberString, (Long)viewMap.get(dimensionNumberString), item.getNumber(), rangeInt);
                        }
                        Long viewId = modelCacheHelper.getAnalyzeMemberViewId((Long)baseViewMap.get(dimensionNumberString), member);
                        return modelCacheHelper.getMember(dimensionNumberString, viewId, item.getNumber(), rangeInt);
                    })).filter(Objects::nonNull).flatMap(Collection::stream).filter(Objects::nonNull).map(item -> item.getNumber()).collect(Collectors.toSet());
                    Set memberNumberStringSet = finalDimNumberAndMemberNumberMap.computeIfAbsent(dimensionNumberString, k -> new LinkedHashSet(16));
                    memberNumberStringSet.addAll(itemMemberNumberStringSet);
                    memberNumberStringSet.addAll(variableMemberNumberStringSet);
                }
            });
            LambdaUtils.run(() -> {
                List viewPointDimensionEntryList = templateModel.getViewpointmembentry();
                if (CollectionUtils.isEmpty((Collection)viewPointDimensionEntryList)) {
                    return;
                }
                for (IViewPointDimensionEntry viewPointDimensionEntry : viewPointDimensionEntryList) {
                    IDimension dimension = viewPointDimensionEntry.getDimension();
                    IDimensionMember member = viewPointDimensionEntry.getMember();
                    Set memberNumberStringSet = finalDimNumberAndMemberNumberMap.computeIfAbsent(dimension.getNumber(), k -> new LinkedHashSet(16));
                    List memberList = (List)LambdaUtils.get(() -> {
                        String dimensionNumberString;
                        Member currentMember;
                        int scopeInt = member.getScope();
                        if (scopeInt <= 0) {
                            scopeInt = RangeEnum.ONLY.getIndex();
                        }
                        if ((currentMember = modelCacheHelper.getMember(dimensionNumberString = dimension.getNumber(), (Long)viewMap.get(dimensionNumberString), member.getNumber())) == null) {
                            return Collections.emptyList();
                        }
                        if (!currentMember.isAnalyzeMember()) {
                            return modelCacheHelper.getMember(dimensionNumberString, (Long)viewMap.get(dimensionNumberString), currentMember.getNumber(), scopeInt);
                        }
                        Long viewId = modelCacheHelper.getAnalyzeMemberViewId((Long)baseViewMap.get(dimensionNumberString), currentMember);
                        return modelCacheHelper.getMember(dimensionNumberString, viewId, currentMember.getNumber(), scopeInt);
                    });
                    memberNumberStringSet.addAll(memberList.stream().map(item -> item.getNumber()).collect(Collectors.toSet()));
                }
            });
            LambdaUtils.run(() -> {
                List pageDimensionEntryList = templateModel.getPagemembentry();
                if (CollectionUtils.isEmpty((Collection)pageDimensionEntryList)) {
                    return;
                }
                for (IPageDimensionEntry pageDimensionEntry : pageDimensionEntryList) {
                    IDimension dimension = pageDimensionEntry.getDimension();
                    List dimensionMemberList = pageDimensionEntry.getMembers();
                    if (CollectionUtils.isEmpty((Collection)dimensionMemberList)) continue;
                    Set memberNumberStringSet = finalDimNumberAndMemberNumberMap.computeIfAbsent(dimension.getNumber(), k -> new LinkedHashSet(16));
                    for (IDimensionMember member : dimensionMemberList) {
                        List memberList = (List)LambdaUtils.get(() -> {
                            String dimensionNumberString;
                            Member currentMember;
                            int scopeInt = member.getScope();
                            if (scopeInt <= 0) {
                                scopeInt = RangeEnum.ONLY.getIndex();
                            }
                            if ((currentMember = modelCacheHelper.getMember(dimensionNumberString = dimension.getNumber(), (Long)viewMap.get(dimensionNumberString), member.getNumber())) == null) {
                                return Collections.emptyList();
                            }
                            if (!currentMember.isAnalyzeMember()) {
                                return modelCacheHelper.getMember(dimensionNumberString, (Long)viewMap.get(dimensionNumberString), currentMember.getNumber(), scopeInt);
                            }
                            Long viewId = modelCacheHelper.getAnalyzeMemberViewId((Long)baseViewMap.get(dimensionNumberString), currentMember);
                            return modelCacheHelper.getMember(dimensionNumberString, viewId, currentMember.getNumber(), scopeInt);
                        });
                        memberNumberStringSet.addAll(memberList.stream().map(item -> item.getNumber()).collect(Collectors.toSet()));
                    }
                }
            });
            templateIdAndDimNumberAndMemberNumberSetMap.put(templateIdLong, finalDimNumberAndMemberNumberMap);
        }
        return templateIdAndDimNumberAndMemberNumberSetMap;
    }

    public static Map<String, Map<String, Set<String>>> getVariableIdAndDimNumberMemberNumberSetMap(List<EbTaskvariableset> ebTaskvariablesetList, Long modelIdLong) {
        if (CollectionUtils.isEmpty(ebTaskvariablesetList)) {
            return null;
        }
        IModelCacheHelper modelCacheHelper = ModelCacheContext.getOrCreate((Long)modelIdLong);
        LinkedHashMap<String, Map<String, Set<String>>> variableIdAndDimNumberMemberNumberSetMap = new LinkedHashMap<String, Map<String, Set<String>>>(16);
        ebTaskvariablesetList.forEach(item -> {
            Map dimNumberAndMemberNumberSetMap = variableIdAndDimNumberMemberNumberSetMap.computeIfAbsent(ObjUtils.getString((Object)item.getIdLong()), v -> new LinkedHashMap(16));
            Dimension dimension = modelCacheHelper.getDimension(item.getDimensionLong());
            if (dimension == null) {
                return;
            }
            String variablejsontextString = item.getVariablejsontextString();
            if (StringUtils.isBlank((CharSequence)variablejsontextString)) {
                return;
            }
            JsonNode jsonNode = JsonUtils.readTree((String)variablejsontextString);
            JsonNode memberNumberJsonNode = jsonNode.get("number");
            if (memberNumberJsonNode == null) {
                return;
            }
            String memberNumberString = memberNumberJsonNode.asText();
            if (StringUtils.isBlank((CharSequence)memberNumberString)) {
                return;
            }
            Member member = modelCacheHelper.getMemberByAnyView(dimension.getNumber(), memberNumberString);
            if (member == null) {
                return;
            }
            Set memberNumberStringSet = dimNumberAndMemberNumberSetMap.computeIfAbsent(dimension.getNumber(), v -> new LinkedHashSet());
            memberNumberStringSet.add(member.getNumber());
        });
        return variableIdAndDimNumberMemberNumberSetMap;
    }

    public static List<ReportProcessPojo> getReportProcessPojoListFromCache(Long modeIdLong) {
        return (List)CacheUtils.loadingCacheComputeIfAbsent((String)(ReportProcessPojo.class.getName() + modeIdLong), () -> {
            List<ReportProcessPojo> reportProcessPojoList = RelationGraphService.getReportProcessPojoList(modeIdLong);
            if (reportProcessPojoList == null) {
                reportProcessPojoList = new ArrayList<ReportProcessPojo>(16);
            }
            return reportProcessPojoList;
        });
    }

    public static void clearReportProcessPojoListFromCache(Long modelIdLong) {
        CacheUtils.loadingCacheInvalidate((String)(ReportProcessPojo.class.getName() + modelIdLong));
    }

    public static List<ReportProcessPojo> getMatchedReportProcessPojoListNoCache(Long modelIdLong, Map<String, String> dimensionAndMemberNumberMap, ProcessTypeEnum processTypeEnum) {
        IModelCacheHelper modelCacheHelper = ModelCacheContext.getOrCreate((Long)modelIdLong);
        Map viewMap = OlapUtils.getViewMap((Long)modelIdLong, dimensionAndMemberNumberMap);
        Long periodId = null;
        Long dataTypeId = null;
        Long versionId = null;
        Long entityId = null;
        for (Map.Entry<String, String> entry : dimensionAndMemberNumberMap.entrySet()) {
            Member member = modelCacheHelper.getMember(entry.getKey(), (Long)viewMap.get(entry.getKey()), entry.getValue());
            if (SysDimensionEnum.BudgetPeriod.getNumber().equals(entry.getKey())) {
                periodId = member.getId();
                continue;
            }
            if (SysDimensionEnum.DataType.getNumber().equals(entry.getKey())) {
                dataTypeId = member.getId();
                continue;
            }
            if (SysDimensionEnum.Version.getNumber().equals(entry.getKey())) {
                versionId = member.getId();
                continue;
            }
            if (!SysDimensionEnum.Entity.getNumber().equals(entry.getKey())) continue;
            entityId = member.getId();
        }
        List<ReportProcessPojo> reportProcessPojoList = RelationGraphService.getReportProcessPojoList(ReportProcessServiceImpl.getInstance().getReportProcessList(modelIdLong, periodId, dataTypeId, versionId, (Set)Sets.newHashSet((Object[])new Long[]{entityId}), null));
        if (CollectionUtils.isEmpty(reportProcessPojoList)) {
            return null;
        }
        LinkedHashMap dimensionAndMemberSetNumberMap = new LinkedHashMap(dimensionAndMemberNumberMap.size());
        dimensionAndMemberNumberMap.forEach((dimensonNumberString, memberNumberString) -> {
            if (SysDimensionEnum.Entity.getNumber().equals(dimensonNumberString)) {
                Member member = OlapUtils.getMember((IModelCacheHelper)modelCacheHelper, (String)SysDimensionEnum.Entity.getNumber(), (Map)viewMap, (String)memberNumberString);
                if (member != null) {
                    dimensionAndMemberSetNumberMap.put(dimensonNumberString, member.getAllMembers().stream().map(BaseCache::getNumber).collect(Collectors.toSet()));
                }
            } else {
                dimensionAndMemberSetNumberMap.put(dimensonNumberString, Sets.newHashSet((Object[])new String[]{memberNumberString}));
            }
        });
        List<ReportProcessPojo> matchedReportProcessPojoList = reportProcessPojoList.parallelStream().filter(item -> {
            if (item == null) {
                return false;
            }
            if (processTypeEnum == null || !processTypeEnum.name().equals(item.getReportProcessTypeString())) {
                return false;
            }
            return RelationGraphUtils.insideScopeBoolean(modelCacheHelper, viewMap, item.getDimensionAndMemberSetNumberMap(), dimensionAndMemberSetNumberMap);
        }).collect(Collectors.toList());
        if (CollectionUtils.isEmpty(matchedReportProcessPojoList)) {
            return null;
        }
        return RelationGraphService.getTargetReportProcessPojoList(matchedReportProcessPojoList, modelIdLong, dimensionAndMemberNumberMap);
    }

    public static List<ReportProcessPojo> getTargetReportProcessPojoList(List<ReportProcessPojo> matchedReportProcessPojoList, Long modelIdLong, Map<String, String> dimensionAndMemberNumberMap) {
        if (CollectionUtils.isEmpty(matchedReportProcessPojoList)) {
            return Collections.emptyList();
        }
        ProcessTypeEnum processTypeEnum = (ProcessTypeEnum)EnumUtils.getEnum(ProcessTypeEnum.class, (String)matchedReportProcessPojoList.get(0).getReportProcessTypeString());
        return RelationGraphService.getTargetReportProcessPojoList(matchedReportProcessPojoList, processTypeEnum, modelIdLong, dimensionAndMemberNumberMap);
    }

    public static List<ReportProcessPojo> getTargetReportProcessPojoList(List<ReportProcessPojo> inputMatchedReportProcessPojoList, ProcessTypeEnum processTypeEnum, Long modelIdLong, Map<String, String> dimensionAndMemberNumberMap) {
        Set reportProcessIdSet = inputMatchedReportProcessPojoList.stream().map(item -> item.getReportProcessIdLong()).collect(Collectors.toSet());
        Set filterReportProcessIdSet = ReportProcessQuoteService.getInstance().filterReportProcessByProcessType(reportProcessIdSet, processTypeEnum, modelIdLong);
        List<ReportProcessPojo> matchedReportProcessPojoList = inputMatchedReportProcessPojoList.stream().filter(item -> filterReportProcessIdSet.contains(item.getReportProcessIdLong())).collect(Collectors.toList());
        if (matchedReportProcessPojoList.isEmpty()) {
            return Collections.emptyList();
        }
        if (matchedReportProcessPojoList.size() == 1) {
            return matchedReportProcessPojoList;
        }
        IModelCacheHelper modelCacheHelper = ModelCacheContext.getOrCreate((Long)modelIdLong);
        Member accountMember = OlapUtils.getAccountMember((IModelCacheHelper)modelCacheHelper, dimensionAndMemberNumberMap);
        Long datasetId = accountMember.getDatasetId();
        Long busModelByDataSet = modelCacheHelper.getBusModelByDataSet(datasetId);
        Map viewMap = modelCacheHelper.getViewsByDataSet(datasetId);
        Map analyzeViewMap = modelCacheHelper.getViewsByDataSetIncludeBase(datasetId);
        String currentEntityMemberNumberString = dimensionAndMemberNumberMap.get(SysDimensionEnum.Entity.getNumber());
        Member currentEntityMember = modelCacheHelper.getMemberByAnyView(busModelByDataSet, SysDimensionEnum.Entity.getNumber(), currentEntityMemberNumberString);
        List<ReportProcessPojo> targetReportProcessPojoList = RelationGraphService.getTargetReportProcessPojoList(modelCacheHelper, matchedReportProcessPojoList, currentEntityMember, viewMap, analyzeViewMap, busModelByDataSet);
        if (targetReportProcessPojoList == null || targetReportProcessPojoList.isEmpty()) {
            targetReportProcessPojoList = matchedReportProcessPojoList;
        }
        if (targetReportProcessPojoList.size() == 1) {
            return targetReportProcessPojoList;
        }
        String currentVersionNumberString = dimensionAndMemberNumberMap.get(SysDimensionEnum.Version.getNumber());
        String currentDataTypeNumberString = dimensionAndMemberNumberMap.get(SysDimensionEnum.DataType.getNumber());
        String currentPeriodNumberString = dimensionAndMemberNumberMap.get(SysDimensionEnum.BudgetPeriod.getNumber());
        List<ReportProcessPojo> finalTargetReportProcessPojoList = targetReportProcessPojoList.stream().filter(item -> {
            List memberPojoList = item.getMemberPojoList();
            MemberPojo versionMemberPojo = (MemberPojo)LambdaUtils.getTarget((List)memberPojoList, itemMemberPojo -> itemMemberPojo != null && itemMemberPojo.getDimensionPojo() != null && SysDimensionEnum.Version.getNumber().equals(itemMemberPojo.getDimensionPojo().getDimensionNumberString()));
            if (versionMemberPojo == null || !currentVersionNumberString.equals(versionMemberPojo.getMemberNumberString())) {
                return false;
            }
            MemberPojo dataTypeMemberPojo = (MemberPojo)LambdaUtils.getTarget((List)memberPojoList, itemMemberPojo -> itemMemberPojo != null && itemMemberPojo.getDimensionPojo() != null && SysDimensionEnum.DataType.getNumber().equals(itemMemberPojo.getDimensionPojo().getDimensionNumberString()));
            if (dataTypeMemberPojo == null || !currentDataTypeNumberString.equals(dataTypeMemberPojo.getMemberNumberString())) {
                return false;
            }
            MemberPojo periodMemberPojo = (MemberPojo)LambdaUtils.getTarget((List)memberPojoList, itemMemberPojo -> itemMemberPojo != null && itemMemberPojo.getDimensionPojo() != null && SysDimensionEnum.BudgetPeriod.getNumber().equals(itemMemberPojo.getDimensionPojo().getDimensionNumberString()));
            return periodMemberPojo != null && currentPeriodNumberString.equals(periodMemberPojo.getMemberNumberString());
        }).collect(Collectors.toList());
        if (finalTargetReportProcessPojoList.size() == 1) {
            return finalTargetReportProcessPojoList;
        }
        if (CollectionUtils.isEmpty(finalTargetReportProcessPojoList)) {
            finalTargetReportProcessPojoList = targetReportProcessPojoList;
        }
        Map<Long, List<ReportProcessPojo>> templateIdReportProcessPojoListMap = finalTargetReportProcessPojoList.stream().collect(Collectors.groupingBy(item -> item.getTemplatePojo().getTemplateIdLong()));
        return templateIdReportProcessPojoListMap.values().stream().map(reportProcessPojoList -> {
            if (reportProcessPojoList.size() == 1) {
                return (ReportProcessPojo)reportProcessPojoList.get(0);
            }
            LinkedList<ReportProcessPojo> leafMemberReportProcessPojoList = new LinkedList<ReportProcessPojo>();
            for (ReportProcessPojo reportProcessPojo : reportProcessPojoList) {
                MemberPojo entityMemberPojo = (MemberPojo)LambdaUtils.getTarget((List)reportProcessPojo.getMemberPojoList(), item -> item != null && item.getDimensionPojo() != null && SysDimensionEnum.Entity.getNumber().equals(item.getDimensionPojo().getDimensionNumberString()));
                if (entityMemberPojo == null) continue;
                if (currentEntityMemberNumberString.equals(entityMemberPojo.getMemberNumberString())) {
                    return reportProcessPojo;
                }
                Member entityMember = modelCacheHelper.getMemberByAnyView(busModelByDataSet, SysDimensionEnum.Entity.getNumber(), entityMemberPojo.getMemberNumberString());
                if (entityMember == null || !entityMember.isLeaf()) continue;
                leafMemberReportProcessPojoList.add(reportProcessPojo);
            }
            if (!leafMemberReportProcessPojoList.isEmpty()) {
                return (ReportProcessPojo)leafMemberReportProcessPojoList.get(0);
            }
            return (ReportProcessPojo)reportProcessPojoList.get(0);
        }).collect(Collectors.toList());
    }

    public static void ruleSelectDimensionCombinationCallback(RelationGraphPlugin relationGraphPlugin, DynamicEntryEntityPojo dynamicEntryEntityPojo) {
        Map paramMap = dynamicEntryEntityPojo.getParamMap();
        RelationGraphActionPojo relationGraphActionPojo = (RelationGraphActionPojo)JsonUtils.readValue((String)((String)paramMap.get(RelationGraphActionPojo.class.getName())), RelationGraphActionPojo.class);
        Map customParamMap = (Map)CacheUtils.get((IPageCache)relationGraphPlugin.getPageCache(), (String)CUSTOM_PARAM_MAP, (TypeReference)new TypeReference<Map<String, String>>(){});
        RelationGraphDataTrackingPojo relationGraphDataTrackingPojo = (RelationGraphDataTrackingPojo)JsonUtils.readValue((String)((String)customParamMap.get(RelationGraphDataTrackingPojo.class.getName())), RelationGraphDataTrackingPojo.class);
        RelationGraphDataTrackingItemPojo cellRelationGraphDataTrackingItemPojo = (RelationGraphDataTrackingItemPojo)LambdaUtils.getTarget((List)relationGraphDataTrackingPojo.getRelationGraphDataTrackingItemPojoList(), item -> RelationGraphDataTrackingTypeEnum.NODE.name().equals(item.getTypeString()) && relationGraphActionPojo.getIdString().equals(item.getCurrentNodeIdString()));
        if (cellRelationGraphDataTrackingItemPojo == null) {
            return;
        }
        List cellPojoList = cellRelationGraphDataTrackingItemPojo.getCellPojoList();
        RelationGraphModelPojo relationGraphModelPojo = (RelationGraphModelPojo)CacheUtils.get((IPageCache)relationGraphPlugin.getPageCache(), (String)RelationGraphModelPojo.class.getName(), RelationGraphModelPojo.class);
        RelationGraphNodePojo relationGraphNodePojo = (RelationGraphNodePojo)LambdaUtils.getTarget((List)relationGraphModelPojo.getFullRelationGraphDataPojo().getRelationGraphNodePojoList(), item -> item != null && item.getIdString().equals(relationGraphActionPojo.getIdString()));
        List outputSelectRowIndexIntegerList = dynamicEntryEntityPojo.getOutputSelectRowIndexIntegerList();
        if (CollectionUtils.isEmpty((Collection)outputSelectRowIndexIntegerList)) {
            return;
        }
        List selectCellPojoList = outputSelectRowIndexIntegerList.stream().map(cellPojoList::get).collect(Collectors.toList());
        RelationGraphModelPojo itemRelationGraphModelPojo = (RelationGraphModelPojo)LambdaUtils.get(() -> {
            String indexString;
            LinkedHashMap<String, RelationGraphModelPojo> itemRelationGraphModelPojoMap = cellRelationGraphDataTrackingItemPojo.getItemRelationGraphModelPojoMap();
            if (itemRelationGraphModelPojoMap == null) {
                itemRelationGraphModelPojoMap = new LinkedHashMap<String, RelationGraphModelPojo>(16);
                cellRelationGraphDataTrackingItemPojo.setItemRelationGraphModelPojoMap(itemRelationGraphModelPojoMap);
            }
            if (itemRelationGraphModelPojoMap.containsKey(indexString = ObjUtils.getString(outputSelectRowIndexIntegerList.get(0)))) {
                return (RelationGraphModelPojo)itemRelationGraphModelPojoMap.get(indexString);
            }
            ReportShowBizRuleBo rightReportShowBizRuleBo = ShowBizRuleUtils.getReportShowBizRuleBo((Map)((CellPojo)selectCellPojoList.get(0)).getDimensionAndMemberStringMap(), (Long)relationGraphDataTrackingPojo.getModelIdLong(), (AnalysisContext)RelationGraphService.getAnalysisContext(relationGraphPlugin.getView()));
            if (rightReportShowBizRuleBo == null) {
                itemRelationGraphModelPojoMap.put(indexString, null);
                return null;
            }
            RelationGraphModelPojo targetItemRelationGraphModelPojo = RelationGraphService.getCurrentRelationGraphModelPojo(rightReportShowBizRuleBo, relationGraphDataTrackingPojo.getModelIdLong());
            itemRelationGraphModelPojoMap.put(indexString, targetItemRelationGraphModelPojo);
            return targetItemRelationGraphModelPojo;
        });
        if (itemRelationGraphModelPojo == null) {
            relationGraphPlugin.getView().showTipNotification(ResManager.loadKDString((String)"\u672a\u5339\u914d\u5230\u4e1a\u52a1\u89c4\u5219\u3002", (String)"RelationGraphPlugin_59", (String)"epm-eb-formplugin", (Object[])new Object[0]));
            return;
        }
        RelationGraphNodeDataAreaPojo relationGraphNodeDataAreaPojo = relationGraphNodePojo.getRelationGraphNodeDataPojo().getRelationGraphNodeDataAreaPojo();
        if (relationGraphNodeDataAreaPojo.getRelationGraphNodeDataRowPojoList().size() > 2) {
            RelationGraphNodeDataCellPojo leftRelationGraphNodeDataCellPojo = (RelationGraphNodeDataCellPojo)((RelationGraphNodeDataRowPojo)relationGraphNodeDataAreaPojo.getRelationGraphNodeDataRowPojoList().get(2)).getRelationGraphNodeDataCellPojoList().get(0);
            RelationGraphNodeDataCellPojo targetRelationGraphNodeDataCellPojo = (RelationGraphNodeDataCellPojo)((RelationGraphNodeDataRowPojo)((RelationGraphNodePojo)itemRelationGraphModelPojo.getRelationGraphDataPojo().getRelationGraphNodePojoList().get(0)).getRelationGraphNodeDataPojo().getRelationGraphNodeDataAreaPojo().getRelationGraphNodeDataRowPojoList().get(0)).getRelationGraphNodeDataCellPojoList().get(0);
            if (leftRelationGraphNodeDataCellPojo.getIdString().equals(targetRelationGraphNodeDataCellPojo.getIdString())) {
                return;
            }
        }
        LambdaUtils.run(() -> {
            RelationGraphDataTrackingPojo targetRelationGraphDataTrackingPojo = (RelationGraphDataTrackingPojo)JsonUtils.readValue((String)((String)itemRelationGraphModelPojo.getCustomParamMap().get(RelationGraphDataTrackingPojo.class.getName())), RelationGraphDataTrackingPojo.class);
            List targetRelationGraphDataTrackingItemPojoList = targetRelationGraphDataTrackingPojo.getRelationGraphDataTrackingItemPojoList();
            LambdaUtils.run(() -> {
                if (CollectionUtils.isEmpty((Collection)targetRelationGraphDataTrackingItemPojoList)) {
                    return;
                }
                Set cellRelationGraphDataTrackingItemPojoSet = targetRelationGraphDataTrackingItemPojoList.stream().filter(item -> RelationGraphDataTrackingTypeEnum.CELL.name().equals(item.getTypeString())).collect(Collectors.toSet());
                relationGraphDataTrackingPojo.getRelationGraphDataTrackingItemPojoList().addAll(cellRelationGraphDataTrackingItemPojoSet);
                RelationGraphDataTrackingItemPojo leftCellRelationGraphDataTrackingItemPojo = (RelationGraphDataTrackingItemPojo)LambdaUtils.getTarget(cellRelationGraphDataTrackingItemPojoSet, item -> BooleanUtils.isTrue((Boolean)item.getLeftBoolean()));
                if (leftCellRelationGraphDataTrackingItemPojo == null) {
                    return;
                }
                RelationGraphDataTrackingItemPojo beforeRelationGraphDataTrackingItemPojo = (RelationGraphDataTrackingItemPojo)LambdaUtils.getTarget((List)relationGraphDataTrackingPojo.getRelationGraphDataTrackingItemPojoList(), item -> {
                    if (!RelationGraphDataTrackingTypeEnum.NODE.name().equals(item.getTypeString())) {
                        return false;
                    }
                    return relationGraphNodePojo.getIdString().equals(item.getLaterNodeIdString());
                });
                if (beforeRelationGraphDataTrackingItemPojo == null) {
                    return;
                }
                LinkedHashSet<String> laterNodeLeftCellIdStringSet = beforeRelationGraphDataTrackingItemPojo.getLaterNodeLeftCellIdStringSet();
                if (laterNodeLeftCellIdStringSet == null) {
                    laterNodeLeftCellIdStringSet = new LinkedHashSet<String>(16);
                    beforeRelationGraphDataTrackingItemPojo.setLaterNodeLeftCellIdStringSet(laterNodeLeftCellIdStringSet);
                }
                laterNodeLeftCellIdStringSet.add(leftCellRelationGraphDataTrackingItemPojo.getCurrentCellIdString());
            });
            LambdaUtils.run(() -> {
                if (itemRelationGraphModelPojo.getRelationGraphShowBoxParent() == null) {
                    return;
                }
                List relationGraphShowBoxPojoList = itemRelationGraphModelPojo.getRelationGraphShowBoxParent().getRelationGraphShowBoxPojoList();
                if (CollectionUtils.isEmpty((Collection)relationGraphShowBoxPojoList)) {
                    return;
                }
                relationGraphModelPojo.getRelationGraphShowBoxParent().getRelationGraphShowBoxPojoList().addAll(relationGraphShowBoxPojoList);
            });
            LambdaUtils.run(() -> {
                List relationGraphNodeDataRowPojoList = relationGraphNodePojo.getRelationGraphNodeDataPojo().getRelationGraphNodeDataAreaPojo().getRelationGraphNodeDataRowPojoList();
                relationGraphNodeDataRowPojoList = relationGraphNodeDataRowPojoList.subList(0, 2);
                List targetRelationGraphNodeDataRowPojoList = ((RelationGraphNodePojo)itemRelationGraphModelPojo.getRelationGraphDataPojo().getRelationGraphNodePojoList().get(0)).getRelationGraphNodeDataPojo().getRelationGraphNodeDataAreaPojo().getRelationGraphNodeDataRowPojoList();
                relationGraphNodeDataRowPojoList.addAll(targetRelationGraphNodeDataRowPojoList);
                relationGraphNodePojo.getRelationGraphNodeDataPojo().getRelationGraphNodeDataAreaPojo().setRelationGraphNodeDataRowPojoList(relationGraphNodeDataRowPojoList);
                RelationGraphNodeDataRowPojo relationGraphNodeDataRowPojo = (RelationGraphNodeDataRowPojo)targetRelationGraphNodeDataRowPojoList.get(0);
                StylePojo stylePojo = relationGraphNodeDataRowPojo.getStylePojo();
                if (stylePojo == null) {
                    stylePojo = new StylePojo();
                    relationGraphNodeDataRowPojo.setStylePojo(stylePojo);
                }
                stylePojo.setBorderTopString("#b2b2b2 solid 1px");
            });
        });
        Set<String> currentNodeIdStringSet = relationGraphModelPojo.getRelationGraphDataPojo().getRelationGraphNodePojoList().stream().map(RelationGraphNodePojo::getIdString).collect(Collectors.toSet());
        MutableGraph<String> graph = RelationGraphUtils.getGraph(relationGraphModelPojo.getFullRelationGraphDataPojo());
        currentNodeIdStringSet.removeAll(RelationGraphUtils.getLaterGraphNodeIdStringSet(graph, relationGraphNodePojo.getIdString()));
        relationGraphModelPojo.setRelationGraphDataPojo(RelationGraphUtils.getRelationGraphDataPojo(relationGraphModelPojo.getFullRelationGraphDataPojo(), currentNodeIdStringSet));
        RelationGraphUtils.checkAndReorganize(relationGraphModelPojo);
        EventPojo eventPojo = new EventPojo();
        eventPojo.setPreventDefaultBoolean(Boolean.valueOf(true));
        ArrayList<String> evalStringList = new ArrayList<String>(3);
        evalStringList.add("Vue.set(vm.$data, 'relationGraphShowBoxPojoList', [])");
        evalStringList.add(StrUtils.format((String)"Vue.set(vm.$data, 'relationGraphModelPojo', {});", (Object[])new Object[]{JsonUtils.getWithoutNullJsonString((Object)relationGraphModelPojo)}));
        evalStringList.add("vm.$options.methods.updateRelationGraphByVueData();");
        eventPojo.setEvalPojo(new EvalPojo().setEvalStringList(evalStringList));
        RuleJsUtils.invokeCustom(relationGraphPlugin.getCustomControl(), null, "eval", EventUtils.getEventEvalString((EventPojo)eventPojo), null);
        customParamMap.put(RelationGraphDataTrackingPojo.class.getName(), JsonUtils.getJsonString((Object)relationGraphDataTrackingPojo));
        CacheUtils.put((IPageCache)relationGraphPlugin.getPageCache(), (String)CUSTOM_PARAM_MAP, (Object)customParamMap);
    }

    public static void clickCellActionMethod(RelationGraphPlugin relationGraphPlugin, CustomEventArgs customEventArgs) {
        JsonNode jsonNode = JsonUtils.readTree((String)customEventArgs.getEventArgs());
        RelationGraphModelPojo relationGraphModelPojo = (RelationGraphModelPojo)JsonUtils.readValue((JsonNode)jsonNode.get(FrontUtils.getNameString(RelationGraphModelPojo.class)), RelationGraphModelPojo.class);
        RelationGraphActionPojo relationGraphActionPojo = relationGraphModelPojo.getRelationGraphActionPojo();
        Map customParamMap = (Map)CacheUtils.get((IPageCache)relationGraphPlugin.getPageCache(), (String)CUSTOM_PARAM_MAP, (TypeReference)new TypeReference<Map<String, String>>(){});
        RelationGraphDataTrackingPojo relationGraphDataTrackingPojo = (RelationGraphDataTrackingPojo)JsonUtils.readValue((String)((String)customParamMap.get(RelationGraphDataTrackingPojo.class.getName())), RelationGraphDataTrackingPojo.class);
        Long modelIdLong = relationGraphDataTrackingPojo.getModelIdLong();
        IModelCacheHelper modelCacheHelper = ModelCacheContext.getOrCreate((Long)modelIdLong);
        RelationGraphDataTrackingItemPojo cellRelationGraphDataTrackingItemPojo = (RelationGraphDataTrackingItemPojo)LambdaUtils.getTarget((List)relationGraphDataTrackingPojo.getRelationGraphDataTrackingItemPojoList(), item -> RelationGraphDataTrackingTypeEnum.CELL.name().equals(item.getTypeString()) && item.getCurrentCellIdString().equals(relationGraphActionPojo.getCellIdString()));
        LambdaUtils.run(() -> {
            relationGraphModelPojo.setInfoHtmlString(null);
            if (cellRelationGraphDataTrackingItemPojo == null) {
                return;
            }
            if (StringUtils.isBlank((CharSequence)cellRelationGraphDataTrackingItemPojo.getInfoHtmlString())) {
                ReportOrTaskPojo reportOrTaskPojo = (ReportOrTaskPojo)LambdaUtils.get(() -> {
                    if (MapUtils.isEmpty((Map)customParamMap)) {
                        return null;
                    }
                    String reportOrTaskPojoJsonString = (String)customParamMap.get(ReportOrTaskPojo.class.getName());
                    if (StringUtils.isBlank((CharSequence)reportOrTaskPojoJsonString)) {
                        return null;
                    }
                    return (ReportOrTaskPojo)JsonUtils.readValue((String)reportOrTaskPojoJsonString, ReportOrTaskPojo.class);
                });
                cellRelationGraphDataTrackingItemPojo.setInfoHtmlString(RelationGraphService.getNeedMatchInfoHtmlString(relationGraphPlugin.getView().getPageId(), modelIdLong, cellRelationGraphDataTrackingItemPojo, reportOrTaskPojo));
            }
            RelationGraphUtils.updateRelationGraphModelPojoInfoHtmlString(relationGraphModelPojo, cellRelationGraphDataTrackingItemPojo.getInfoHtmlString());
        });
        LambdaUtils.run(() -> {
            if (cellRelationGraphDataTrackingItemPojo == null) {
                return;
            }
            Set<String> currentNodeIdStringSet = relationGraphModelPojo.getRelationGraphDataPojo().getRelationGraphNodePojoList().stream().map(RelationGraphNodePojo::getIdString).collect(Collectors.toSet());
            if (currentNodeIdStringSet.contains(cellRelationGraphDataTrackingItemPojo.getLaterNodeIdString())) {
                currentNodeIdStringSet.remove(cellRelationGraphDataTrackingItemPojo.getLaterNodeIdString());
                MutableGraph<String> currentGraph = RelationGraphUtils.getWithoutDefaultRootGraph(relationGraphModelPojo.getFullRelationGraphDataPojo());
                currentNodeIdStringSet.removeAll(RelationGraphUtils.getLaterGraphNodeIdStringSet(currentGraph, cellRelationGraphDataTrackingItemPojo.getLaterNodeIdString()));
            } else {
                currentNodeIdStringSet.add(cellRelationGraphDataTrackingItemPojo.getLaterNodeIdString());
            }
            relationGraphModelPojo.setRelationGraphDataPojo(RelationGraphUtils.getRelationGraphDataPojo(relationGraphModelPojo.getFullRelationGraphDataPojo(), currentNodeIdStringSet));
        });
        LambdaUtils.run(() -> {
            Map viewMap;
            if (cellRelationGraphDataTrackingItemPojo == null) {
                return;
            }
            if (RelationGraphDataTrackingTypeEnum.CELL.name().equals(cellRelationGraphDataTrackingItemPojo.getTypeString()) && BooleanUtils.isTrue((Boolean)cellRelationGraphDataTrackingItemPojo.getLeftBoolean())) {
                return;
            }
            String laterNodeIdString = cellRelationGraphDataTrackingItemPojo.getLaterNodeIdString();
            if (StringUtils.isNotBlank((CharSequence)laterNodeIdString)) {
                return;
            }
            if (BooleanUtils.isTrue((Boolean)cellRelationGraphDataTrackingItemPojo.getWithoutNextNodeBoolean())) {
                relationGraphPlugin.getView().showTipNotification(ResManager.loadKDString((String)"\u672a\u5339\u914d\u5230\u4e1a\u52a1\u89c4\u5219\u3002", (String)"RelationGraphPlugin_59", (String)"epm-eb-formplugin", (Object[])new Object[0]));
                return;
            }
            Map dimensionAndMemberNumberMap = cellRelationGraphDataTrackingItemPojo.getDimensionAndMemberNumberMap();
            Map dimensionAndMemberNumberSetMap = cellRelationGraphDataTrackingItemPojo.getDimensionAndMemberNumberSetMap();
            Boolean normalMemberBoolean = (Boolean)LambdaUtils.get(() -> RelationGraphService.lambda$null$169(dimensionAndMemberNumberSetMap, dimensionAndMemberNumberMap, modelCacheHelper, modelIdLong, viewMap = OlapUtils.getViewMap((Long)modelIdLong, (Map)dimensionAndMemberNumberMap)));
            if (normalMemberBoolean.booleanValue()) {
                LambdaUtils.run(() -> {
                    ReportShowBizRuleBo rightReportShowBizRuleBo = ShowBizRuleUtils.getReportShowBizRuleBo((Map)dimensionAndMemberNumberMap, (Long)modelIdLong, (AnalysisContext)RelationGraphService.getAnalysisContext(relationGraphPlugin.getView()));
                    if (rightReportShowBizRuleBo == null) {
                        cellRelationGraphDataTrackingItemPojo.setWithoutNextNodeBoolean(Boolean.valueOf(true));
                        relationGraphPlugin.getView().showTipNotification(ResManager.loadKDString((String)"\u672a\u5339\u914d\u5230\u4e1a\u52a1\u89c4\u5219\u3002", (String)"RelationGraphPlugin_59", (String)"epm-eb-formplugin", (Object[])new Object[0]));
                        return;
                    }
                    RelationGraphModelPojo targetRelationGraphModelPojo = RelationGraphService.getCurrentRelationGraphModelPojo(rightReportShowBizRuleBo, modelIdLong);
                    LambdaUtils.run(() -> {
                        RelationGraphNodePojo targetRelationGraphNodePojo = (RelationGraphNodePojo)targetRelationGraphModelPojo.getRelationGraphDataPojo().getRelationGraphNodePojoList().get(0);
                        relationGraphModelPojo.getFullRelationGraphDataPojo().getRelationGraphNodePojoList().add(targetRelationGraphNodePojo);
                        RelationGraphLinkPojo relationGraphLinkPojo = new RelationGraphLinkPojo();
                        relationGraphLinkPojo.setFromString(relationGraphActionPojo.getIdString());
                        relationGraphLinkPojo.setToString(targetRelationGraphNodePojo.getIdString());
                        relationGraphModelPojo.getFullRelationGraphDataPojo().getRelationGraphLinkPojoList().add(relationGraphLinkPojo);
                        Set<String> currentNodeIdStringSet = relationGraphModelPojo.getRelationGraphDataPojo().getRelationGraphNodePojoList().stream().map(RelationGraphNodePojo::getIdString).collect(Collectors.toSet());
                        currentNodeIdStringSet.add(targetRelationGraphNodePojo.getIdString());
                        relationGraphModelPojo.setRelationGraphDataPojo(RelationGraphUtils.getRelationGraphDataPojo(relationGraphModelPojo.getFullRelationGraphDataPojo(), currentNodeIdStringSet));
                    });
                    RelationGraphDataTrackingPojo targetRelationGraphDataTrackingPojo = (RelationGraphDataTrackingPojo)JsonUtils.readValue((String)((String)targetRelationGraphModelPojo.getCustomParamMap().get(RelationGraphDataTrackingPojo.class.getName())), RelationGraphDataTrackingPojo.class);
                    LambdaUtils.run(() -> {
                        RelationGraphDataTrackingItemPojo leftCellRelationGraphDataTrackingItemPojo;
                        List targetRelationGraphDataTrackingItemPojoList = targetRelationGraphDataTrackingPojo.getRelationGraphDataTrackingItemPojoList();
                        if (CollectionUtils.isEmpty((Collection)targetRelationGraphDataTrackingItemPojoList)) {
                            return;
                        }
                        relationGraphDataTrackingPojo.getRelationGraphDataTrackingItemPojoList().addAll(targetRelationGraphDataTrackingItemPojoList);
                        RelationGraphDataTrackingItemPojo laterNodeRelationGraphDataTrackingItemPojo = (RelationGraphDataTrackingItemPojo)LambdaUtils.getTarget((List)targetRelationGraphDataTrackingItemPojoList, item -> RelationGraphDataTrackingTypeEnum.NODE.name().equals(item.getTypeString()));
                        if (laterNodeRelationGraphDataTrackingItemPojo != null) {
                            cellRelationGraphDataTrackingItemPojo.setLaterNodeIdString(laterNodeRelationGraphDataTrackingItemPojo.getCurrentNodeIdString());
                        }
                        if ((leftCellRelationGraphDataTrackingItemPojo = (RelationGraphDataTrackingItemPojo)LambdaUtils.getTarget((List)targetRelationGraphDataTrackingItemPojoList, item -> RelationGraphDataTrackingTypeEnum.CELL.name().equals(item.getTypeString()) && BooleanUtils.isTrue((Boolean)item.getLeftBoolean()))) != null) {
                            LinkedHashSet<String> laterNodeLeftCellIdStringSet = cellRelationGraphDataTrackingItemPojo.getLaterNodeLeftCellIdStringSet();
                            if (laterNodeLeftCellIdStringSet == null) {
                                laterNodeLeftCellIdStringSet = new LinkedHashSet<String>(16);
                                cellRelationGraphDataTrackingItemPojo.setLaterNodeLeftCellIdStringSet(laterNodeLeftCellIdStringSet);
                            }
                            laterNodeLeftCellIdStringSet.add(leftCellRelationGraphDataTrackingItemPojo.getCurrentCellIdString());
                        }
                    });
                    LambdaUtils.run(() -> {
                        if (targetRelationGraphModelPojo.getRelationGraphShowBoxParent() == null) {
                            return;
                        }
                        List relationGraphShowBoxPojoList = targetRelationGraphModelPojo.getRelationGraphShowBoxParent().getRelationGraphShowBoxPojoList();
                        if (CollectionUtils.isEmpty((Collection)relationGraphShowBoxPojoList)) {
                            return;
                        }
                        relationGraphModelPojo.getRelationGraphShowBoxParent().getRelationGraphShowBoxPojoList().addAll(relationGraphShowBoxPojoList);
                    });
                });
                return;
            }
            OlapPojo olapPojo = new OlapPojo();
            olapPojo.setModelIdLong(modelIdLong);
            olapPojo.setDimensionAndMemberNumberSetMap(dimensionAndMemberNumberSetMap);
            olapPojo.setLeafMemberBoolean(Boolean.valueOf(true));
            olapPojo.setRefFuncFlag(cellRelationGraphDataTrackingItemPojo.getRefFuncFlag());
            List cellPojoList = ShowBizRuleUtils.getCellPojoList((OlapPojo)olapPojo, (AnalysisContext)RelationGraphService.getAnalysisContext(relationGraphPlugin.getView()));
            if (CollectionUtils.isEmpty((Collection)cellPojoList)) {
                relationGraphPlugin.getView().showTipNotification(ResManager.loadKDString((String)"\u672a\u5339\u914d\u5230\u4e1a\u52a1\u89c4\u5219\u3002", (String)"RelationGraphPlugin_59", (String)"epm-eb-formplugin", (Object[])new Object[0]));
                return;
            }
            RelationGraphNodePojo relationGraphNodePojo = new RelationGraphNodePojo();
            LambdaUtils.run(() -> {
                relationGraphNodePojo.setIdString(StrUtils.getUuidIdWithDataString());
                RelationGraphNodeDataPojo relationGraphNodeDataPojo = new RelationGraphNodeDataPojo();
                relationGraphNodePojo.setRelationGraphNodeDataPojo(relationGraphNodeDataPojo);
                RelationGraphNodeDataAreaPojo relationGraphNodeDataAreaPojo = new RelationGraphNodeDataAreaPojo();
                relationGraphNodeDataPojo.setRelationGraphNodeDataAreaPojo(relationGraphNodeDataAreaPojo);
                ArrayList relationGraphNodeDataRowPojoList = new ArrayList(16);
                relationGraphNodeDataAreaPojo.setRelationGraphNodeDataRowPojoList(relationGraphNodeDataRowPojoList);
                LambdaUtils.run(() -> {
                    RelationGraphNodeDataRowPojo relationGraphNodeDataRowPojo = new RelationGraphNodeDataRowPojo();
                    relationGraphNodeDataRowPojo.setStylePojo(new StylePojo().setPaddingString("5px 5px 0 5px").setPositionString("relative"));
                    relationGraphNodeDataRowPojoList.add(relationGraphNodeDataRowPojo);
                    ArrayList relationGraphNodeDataCellPojoList = new ArrayList(2);
                    relationGraphNodeDataRowPojo.setRelationGraphNodeDataCellPojoList(relationGraphNodeDataCellPojoList);
                    LambdaUtils.run(() -> {
                        RelationGraphNodeDataCellPojo relationGraphNodeDataCellPojo = new RelationGraphNodeDataCellPojo();
                        relationGraphNodeDataCellPojoList.add(relationGraphNodeDataCellPojo);
                        String valueString = cellRelationGraphDataTrackingItemPojo.getNameString();
                        if (StringUtils.isBlank((CharSequence)valueString)) {
                            valueString = ResManager.loadKDString((String)"\u7ef4\u5ea6\u6210\u5458", (String)"RelationGraphPlugin_55", (String)"epm-eb-formplugin", (Object[])new Object[0]);
                        }
                        relationGraphNodeDataCellPojo.setValueString(valueString);
                    });
                    LambdaUtils.run(() -> {
                        RelationGraphNodeDataCellPojo relationGraphNodeDataCellPojo = new RelationGraphNodeDataCellPojo();
                        relationGraphNodeDataCellPojoList.add(relationGraphNodeDataCellPojo);
                        relationGraphNodeDataCellPojo.setStylePojo(new StylePojo().setColorString("#b2b2b2").setPositionString("absolute").setRightString("0"));
                        relationGraphNodeDataCellPojo.setValueString(ResManager.loadResFormat((String)"\u5171%1\u4e2a\u6570\u636e", (String)"RelationGraphPlugin_56", (String)"epm-eb-formplugin", (Object[])new Object[]{cellPojoList.size()}));
                    });
                    LambdaUtils.run(() -> {
                        String rowValueString = relationGraphNodeDataRowPojo.getRelationGraphNodeDataCellPojoList().stream().map(item -> item.getValueString()).collect(Collectors.joining());
                        int lengthInt = RelationGraphUtils.getCssLength(rowValueString) + 20;
                        if (lengthInt < 150) {
                            lengthInt = 150;
                        }
                        relationGraphNodeDataRowPojo.getStylePojo().setMinWidthString(lengthInt + "px");
                    });
                });
                LambdaUtils.run(() -> {
                    RelationGraphNodeDataRowPojo relationGraphNodeDataRowPojo = new RelationGraphNodeDataRowPojo();
                    relationGraphNodeDataRowPojoList.add(relationGraphNodeDataRowPojo);
                    relationGraphNodeDataRowPojo.setStylePojo(new StylePojo().setPaddingString("5px"));
                    RelationGraphNodeDataCellPojo relationGraphNodeDataCellPojo = new RelationGraphNodeDataCellPojo();
                    relationGraphNodeDataCellPojo.setStylePojo(new StylePojo().setCursorString("pointer").setColorString("#5582F3"));
                    relationGraphNodeDataCellPojo.setValueString(ResManager.loadKDString((String)"\u9009\u62e9\u805a\u5408\u7684\u660e\u7ec6\u6570\u636e", (String)"RelationGraphPlugin_57", (String)"epm-eb-formplugin", (Object[])new Object[0]));
                    ArrayList<MethodPojo> methodPojoList = new ArrayList<MethodPojo>(3);
                    relationGraphNodeDataCellPojo.setMethodPojoList(methodPojoList);
                    relationGraphNodeDataCellPojo.setTypeStringList((List)Lists.newArrayList((Object[])new String[]{RelationGraphTypeEnum.BACKGROUND_COLOR.name()}));
                    methodPojoList.add(new MethodPojo().setListenMethodNameString("mouseover"));
                    methodPojoList.add(new MethodPojo().setListenMethodNameString("mouseout"));
                    methodPojoList.add(new MethodPojo().setListenMethodNameString("click").setEventNameString(RelationGraphInteractionTypeEnum.RULE_SELECT_DIMENSION_COMBINATION.name()));
                    relationGraphNodeDataRowPojo.setRelationGraphNodeDataCellPojoList((List)Lists.newArrayList((Object[])new RelationGraphNodeDataCellPojo[]{relationGraphNodeDataCellPojo}));
                });
            });
            cellRelationGraphDataTrackingItemPojo.setLaterNodeIdString(relationGraphNodePojo.getIdString());
            RelationGraphDataTrackingItemPojo newRelationGraphDataTrackingItemPojo = new RelationGraphDataTrackingItemPojo();
            relationGraphDataTrackingPojo.getRelationGraphDataTrackingItemPojoList().add(newRelationGraphDataTrackingItemPojo);
            newRelationGraphDataTrackingItemPojo.setDimensionAndMemberNumberMap(cellRelationGraphDataTrackingItemPojo.getDimensionAndMemberNumberMap());
            newRelationGraphDataTrackingItemPojo.setDimensionAndMemberNumberSetMap(cellRelationGraphDataTrackingItemPojo.getDimensionAndMemberNumberSetMap());
            newRelationGraphDataTrackingItemPojo.setTypeString(RelationGraphDataTrackingTypeEnum.NODE.name());
            newRelationGraphDataTrackingItemPojo.setCurrentNodeIdString(relationGraphNodePojo.getIdString());
            newRelationGraphDataTrackingItemPojo.setCellPojoList(cellPojoList);
            if (cellPojoList.size() == 1) {
                LambdaUtils.run(() -> {
                    ReportShowBizRuleBo rightReportShowBizRuleBo = ShowBizRuleUtils.getReportShowBizRuleBo((Map)((CellPojo)cellPojoList.get(0)).getDimensionAndMemberStringMap(), (Long)modelIdLong, (AnalysisContext)RelationGraphService.getAnalysisContext(relationGraphPlugin.getView()));
                    if (rightReportShowBizRuleBo == null) {
                        relationGraphPlugin.getView().showTipNotification(ResManager.loadKDString((String)"\u672a\u5339\u914d\u5230\u4e1a\u52a1\u89c4\u5219\u3002", (String)"RelationGraphPlugin_59", (String)"epm-eb-formplugin", (Object[])new Object[0]));
                        return;
                    }
                    RelationGraphModelPojo itemRelationGraphModelPojo = RelationGraphService.getCurrentRelationGraphModelPojo(rightReportShowBizRuleBo, modelIdLong);
                    LinkedHashMap<String, RelationGraphModelPojo> itemRelationGraphModelPojoMap = new LinkedHashMap<String, RelationGraphModelPojo>(16);
                    itemRelationGraphModelPojoMap.put(ObjUtils.getString((Object)0), itemRelationGraphModelPojo);
                    newRelationGraphDataTrackingItemPojo.setItemRelationGraphModelPojoMap(itemRelationGraphModelPojoMap);
                    RelationGraphDataTrackingPojo targetRelationGraphDataTrackingPojo = (RelationGraphDataTrackingPojo)JsonUtils.readValue((String)((String)itemRelationGraphModelPojo.getCustomParamMap().get(RelationGraphDataTrackingPojo.class.getName())), RelationGraphDataTrackingPojo.class);
                    List targetRelationGraphDataTrackingItemPojoList = targetRelationGraphDataTrackingPojo.getRelationGraphDataTrackingItemPojoList();
                    if (CollectionUtils.isEmpty((Collection)targetRelationGraphDataTrackingItemPojoList)) {
                        return;
                    }
                    List cellRelationGraphDataTrackingItemPojoList = targetRelationGraphDataTrackingItemPojoList.stream().filter(item -> RelationGraphDataTrackingTypeEnum.CELL.name().equals(item.getTypeString())).collect(Collectors.toList());
                    relationGraphDataTrackingPojo.getRelationGraphDataTrackingItemPojoList().addAll(cellRelationGraphDataTrackingItemPojoList);
                    RelationGraphDataTrackingItemPojo leftCellRelationGraphDataTrackingItemPojo = (RelationGraphDataTrackingItemPojo)LambdaUtils.getTarget(cellRelationGraphDataTrackingItemPojoList, item -> BooleanUtils.isTrue((Boolean)item.getLeftBoolean()));
                    if (leftCellRelationGraphDataTrackingItemPojo != null) {
                        LinkedHashSet<String> laterNodeLeftCellIdStringSet = cellRelationGraphDataTrackingItemPojo.getLaterNodeLeftCellIdStringSet();
                        if (laterNodeLeftCellIdStringSet == null) {
                            laterNodeLeftCellIdStringSet = new LinkedHashSet<String>(16);
                            cellRelationGraphDataTrackingItemPojo.setLaterNodeLeftCellIdStringSet(laterNodeLeftCellIdStringSet);
                        }
                        laterNodeLeftCellIdStringSet.add(leftCellRelationGraphDataTrackingItemPojo.getCurrentCellIdString());
                    }
                    LambdaUtils.run(() -> {
                        if (itemRelationGraphModelPojo.getRelationGraphShowBoxParent() == null) {
                            return;
                        }
                        List relationGraphShowBoxPojoList = itemRelationGraphModelPojo.getRelationGraphShowBoxParent().getRelationGraphShowBoxPojoList();
                        if (CollectionUtils.isEmpty((Collection)relationGraphShowBoxPojoList)) {
                            return;
                        }
                        relationGraphModelPojo.getRelationGraphShowBoxParent().getRelationGraphShowBoxPojoList().addAll(relationGraphShowBoxPojoList);
                    });
                    LambdaUtils.run(() -> {
                        List relationGraphNodeDataRowPojoList = relationGraphNodePojo.getRelationGraphNodeDataPojo().getRelationGraphNodeDataAreaPojo().getRelationGraphNodeDataRowPojoList();
                        List targetRelationGraphNodeDataRowPojoList = ((RelationGraphNodePojo)itemRelationGraphModelPojo.getRelationGraphDataPojo().getRelationGraphNodePojoList().get(0)).getRelationGraphNodeDataPojo().getRelationGraphNodeDataAreaPojo().getRelationGraphNodeDataRowPojoList();
                        relationGraphNodeDataRowPojoList.addAll(targetRelationGraphNodeDataRowPojoList);
                        RelationGraphNodeDataRowPojo relationGraphNodeDataRowPojo = (RelationGraphNodeDataRowPojo)targetRelationGraphNodeDataRowPojoList.get(0);
                        StylePojo stylePojo = relationGraphNodeDataRowPojo.getStylePojo();
                        if (stylePojo == null) {
                            stylePojo = new StylePojo();
                            relationGraphNodeDataRowPojo.setStylePojo(stylePojo);
                        }
                        stylePojo.setBorderTopString("#b2b2b2 solid 1px");
                    });
                });
            }
            relationGraphModelPojo.getFullRelationGraphDataPojo().getRelationGraphNodePojoList().add(relationGraphNodePojo);
            RelationGraphLinkPojo relationGraphLinkPojo = new RelationGraphLinkPojo();
            relationGraphLinkPojo.setFromString(relationGraphActionPojo.getIdString());
            relationGraphLinkPojo.setToString(relationGraphNodePojo.getIdString());
            relationGraphModelPojo.getFullRelationGraphDataPojo().getRelationGraphLinkPojoList().add(relationGraphLinkPojo);
            Set<String> currentNodeIdStringSet = relationGraphModelPojo.getRelationGraphDataPojo().getRelationGraphNodePojoList().stream().map(RelationGraphNodePojo::getIdString).collect(Collectors.toSet());
            currentNodeIdStringSet.add(relationGraphNodePojo.getIdString());
            relationGraphModelPojo.setRelationGraphDataPojo(RelationGraphUtils.getRelationGraphDataPojo(relationGraphModelPojo.getFullRelationGraphDataPojo(), currentNodeIdStringSet));
        });
        LambdaUtils.run(() -> {
            if (cellRelationGraphDataTrackingItemPojo == null) {
                return;
            }
            String laterNodeIdString = cellRelationGraphDataTrackingItemPojo.getLaterNodeIdString();
            RelationGraphNodePojo nextRelationGraphNodePojo = null;
            RelationGraphNodeDataCellPojo currentRelationGraphNodeDataCellPojo = null;
            List relationGraphNodePojoList = relationGraphModelPojo.getRelationGraphDataPojo().getRelationGraphNodePojoList();
            for (RelationGraphNodePojo relationGraphNodePojo : relationGraphNodePojoList) {
                RelationGraphNodeDataAreaPojo relationGraphNodeDataAreaPojo;
                RelationGraphNodeDataPojo relationGraphNodeDataPojo = relationGraphNodePojo.getRelationGraphNodeDataPojo();
                if (relationGraphNodeDataPojo == null || (relationGraphNodeDataAreaPojo = relationGraphNodeDataPojo.getRelationGraphNodeDataAreaPojo()) == null) continue;
                if (StringUtils.isNotBlank((CharSequence)laterNodeIdString) && laterNodeIdString.equals(relationGraphNodePojo.getIdString())) {
                    nextRelationGraphNodePojo = relationGraphNodePojo;
                }
                if (relationGraphNodeDataAreaPojo.getStylePojo() != null) {
                    relationGraphNodeDataAreaPojo.getStylePojo().setBackgroundColorString(null);
                }
                List relationGraphNodeDataRowPojoList = relationGraphNodeDataAreaPojo.getRelationGraphNodeDataRowPojoList();
                for (RelationGraphNodeDataRowPojo relationGraphNodeDataRowPojo : relationGraphNodeDataRowPojoList) {
                    List relationGraphNodeDataCellPojoList = relationGraphNodeDataRowPojo.getRelationGraphNodeDataCellPojoList();
                    for (RelationGraphNodeDataCellPojo relationGraphNodeDataCellPojo : relationGraphNodeDataCellPojoList) {
                        if (relationGraphActionPojo.getCellIdString().equals(relationGraphNodeDataCellPojo.getIdString())) {
                            currentRelationGraphNodeDataCellPojo = relationGraphNodeDataCellPojo;
                        }
                        if (relationGraphNodeDataCellPojo.getStylePojo() != null) {
                            relationGraphNodeDataCellPojo.getStylePojo().setBackgroundColorString(null);
                        }
                        relationGraphNodeDataCellPojo.setNotUpdateBackgroundColorBoolean(null);
                    }
                }
            }
            RelationGraphNodePojo finalNextRelationGraphNodePojo = nextRelationGraphNodePojo;
            LambdaUtils.run(() -> {
                if (finalNextRelationGraphNodePojo == null) {
                    return;
                }
                RelationGraphNodeDataPojo relationGraphNodeDataPojo = finalNextRelationGraphNodePojo.getRelationGraphNodeDataPojo();
                if (relationGraphNodeDataPojo == null) {
                    return;
                }
                RelationGraphNodeDataAreaPojo relationGraphNodeDataAreaPojo = relationGraphNodeDataPojo.getRelationGraphNodeDataAreaPojo();
                if (relationGraphNodeDataAreaPojo == null) {
                    return;
                }
                StylePojo stylePojo = relationGraphNodeDataAreaPojo.getStylePojo();
                if (stylePojo == null) {
                    stylePojo = new StylePojo();
                    relationGraphNodeDataAreaPojo.setStylePojo(stylePojo);
                }
                stylePojo.setBackgroundColorString("#E1E7EE");
            });
            RelationGraphNodeDataCellPojo finalCurrentRelationGraphNodeDataCellPojo = currentRelationGraphNodeDataCellPojo;
            LambdaUtils.run(() -> {
                if (finalCurrentRelationGraphNodeDataCellPojo == null) {
                    return;
                }
                StylePojo stylePojo = finalCurrentRelationGraphNodeDataCellPojo.getStylePojo();
                if (stylePojo == null) {
                    stylePojo = new StylePojo();
                    finalCurrentRelationGraphNodeDataCellPojo.setStylePojo(stylePojo);
                }
                stylePojo.setBackgroundColorString("#E1E7EE");
                finalCurrentRelationGraphNodeDataCellPojo.setNotUpdateBackgroundColorBoolean(Boolean.valueOf(true));
            });
        });
        customParamMap.put(RelationGraphDataTrackingPojo.class.getName(), JsonUtils.getJsonString((Object)relationGraphDataTrackingPojo));
        CacheUtils.put((IPageCache)relationGraphPlugin.getPageCache(), (String)CUSTOM_PARAM_MAP, (Object)customParamMap);
        RelationGraphUtils.checkAndReorganize(relationGraphModelPojo);
        ArrayList<String> evalStringList = new ArrayList<String>(3);
        evalStringList.add("Vue.set(vm.$data, 'relationGraphShowBoxPojoList', [])");
        evalStringList.add(StrUtils.format((String)"Vue.set(vm.$data, 'relationGraphModelPojo', {});", (Object[])new Object[]{JsonUtils.getWithoutNullJsonString((Object)relationGraphModelPojo)}));
        evalStringList.add("vm.$options.methods.updateRelationGraphByVueData();");
        EventPojo eventPojo = new EventPojo();
        eventPojo.setPreventDefaultBoolean(Boolean.valueOf(true));
        eventPojo.setEvalPojo(new EvalPojo().setEvalStringList(evalStringList));
        RuleJsUtils.invokeCustom(relationGraphPlugin.getCustomControl(), customEventArgs.getEventName(), "eval", EventUtils.getEventEvalString((EventPojo)eventPojo), null);
    }

    public static void dataTrackingJumpToReportNumberActionMethod(RelationGraphPlugin relationGraphPlugin, CustomEventArgs customEventArgs) {
        JsonNode jsonNode = JsonUtils.readTree((String)customEventArgs.getEventArgs());
        HashMap dimensionAndMemberNumberMap = (HashMap)LambdaUtils.get(() -> {
            JsonNode dimensionAndMemberNumberMapJsonNode = jsonNode.get("dimensionAndMemberNumberMap");
            if (dimensionAndMemberNumberMapJsonNode == null) {
                return null;
            }
            String base64unEncodeString = StrUtils.getBase64unEncodeString((String)dimensionAndMemberNumberMapJsonNode.asText());
            if (StringUtils.isBlank((CharSequence)base64unEncodeString)) {
                return null;
            }
            return (HashMap)JsonUtils.readValue((String)base64unEncodeString, (TypeReference)new TypeReference<HashMap<String, String>>(){});
        });
        String base64ReportProcessPojoJsonString = jsonNode.get(FrontUtils.getNameString(ReportProcessPojo.class)).asText();
        String reportProcessPojoJsonString = StrUtils.getBase64unEncodeString((String)base64ReportProcessPojoJsonString);
        ReportProcessPojo reportProcessPojo = (ReportProcessPojo)JsonUtils.readValue((String)reportProcessPojoJsonString, ReportProcessPojo.class);
        ReportOpenUtil.openReoprt(relationGraphPlugin.getView(), reportProcessPojo, dimensionAndMemberNumberMap);
    }

    public static void ruleSelectDimensionCombinationActionMethod(RelationGraphPlugin relationGraphPlugin, CustomEventArgs customEventArgs) {
        JsonNode jsonNode = JsonUtils.readTree((String)customEventArgs.getEventArgs());
        RelationGraphModelPojo relationGraphModelPojo = (RelationGraphModelPojo)JsonUtils.readValue((JsonNode)jsonNode.get(FrontUtils.getNameString(RelationGraphModelPojo.class)), RelationGraphModelPojo.class);
        RelationGraphActionPojo relationGraphActionPojo = relationGraphModelPojo.getRelationGraphActionPojo();
        Map customParamMap = (Map)CacheUtils.get((IPageCache)relationGraphPlugin.getPageCache(), (String)CUSTOM_PARAM_MAP, (TypeReference)new TypeReference<Map<String, String>>(){});
        RelationGraphDataTrackingPojo relationGraphDataTrackingPojo = (RelationGraphDataTrackingPojo)JsonUtils.readValue((String)((String)customParamMap.get(RelationGraphDataTrackingPojo.class.getName())), RelationGraphDataTrackingPojo.class);
        RelationGraphDataTrackingItemPojo nodeRelationGraphDataTrackingItemPojo = (RelationGraphDataTrackingItemPojo)LambdaUtils.getTarget((List)relationGraphDataTrackingPojo.getRelationGraphDataTrackingItemPojoList(), item -> RelationGraphDataTrackingTypeEnum.NODE.name().equals(item.getTypeString()) && relationGraphActionPojo.getIdString().equals(item.getCurrentNodeIdString()));
        if (nodeRelationGraphDataTrackingItemPojo == null) {
            return;
        }
        List cellPojoList = nodeRelationGraphDataTrackingItemPojo.getCellPojoList();
        if (CollectionUtils.isEmpty((Collection)cellPojoList)) {
            return;
        }
        IModelCacheHelper modelCacheHelper = ModelCacheContext.getOrCreate((Long)relationGraphDataTrackingPojo.getModelIdLong());
        LinkedHashMap<String, String> headerMap = new LinkedHashMap<String, String>(16);
        headerMap.put("value", ResManager.loadKDString((String)"\u503c", (String)"RelationGraphPlugin_58", (String)"epm-eb-formplugin", (Object[])new Object[0]));
        LambdaUtils.run(() -> {
            Map dimensionAndMemberNumberMap = nodeRelationGraphDataTrackingItemPojo.getDimensionAndMemberNumberMap();
            Map dimensionAndMemberNumberSetMap = nodeRelationGraphDataTrackingItemPojo.getDimensionAndMemberNumberSetMap();
            if (MapUtils.isEmpty((Map)dimensionAndMemberNumberMap) && MapUtils.isEmpty((Map)dimensionAndMemberNumberSetMap)) {
                return;
            }
            Map viewMap = OlapUtils.getViewMap((Long)relationGraphDataTrackingPojo.getModelIdLong(), (Map)dimensionAndMemberNumberMap);
            dimensionAndMemberNumberMap.forEach((dimensionNumberString, memberNumberString) -> {
                Dimension dimension = modelCacheHelper.getDimension(dimensionNumberString);
                if (dimension == null) {
                    return;
                }
                Member member = OlapUtils.getMember((Long)relationGraphDataTrackingPojo.getModelIdLong(), (String)dimensionNumberString, (Map)viewMap, (String)memberNumberString);
                if (member != null && !member.isLeaf()) {
                    headerMap.put((String)dimensionNumberString, dimension.getName());
                }
            });
            dimensionAndMemberNumberSetMap.forEach((dimensionNumberString, memberNumberStringSet) -> {
                Dimension dimension = modelCacheHelper.getDimension(dimensionNumberString);
                if (dimension == null || headerMap.containsKey(dimension.getNumber()) || CollectionUtils.isEmpty((Collection)memberNumberStringSet)) {
                    return;
                }
                if (memberNumberStringSet.size() > 1) {
                    headerMap.put((String)dimensionNumberString, dimension.getName());
                }
            });
        });
        LambdaUtils.run(() -> {
            Map dimensionAndMemberNumberSetMap = nodeRelationGraphDataTrackingItemPojo.getDimensionAndMemberNumberSetMap();
            if (MapUtils.isEmpty((Map)dimensionAndMemberNumberSetMap)) {
                return;
            }
            dimensionAndMemberNumberSetMap.forEach((dimensionNumberString, memberNumberStringSet) -> {
                Dimension dimension = modelCacheHelper.getDimension(dimensionNumberString);
                if (dimension == null || headerMap.containsKey(dimension.getNumber()) || CollectionUtils.isEmpty((Collection)memberNumberStringSet)) {
                    return;
                }
                if (memberNumberStringSet.size() > 1) {
                    headerMap.put((String)dimensionNumberString, dimension.getName());
                }
            });
        });
        LambdaUtils.run(() -> {
            if (headerMap.size() > 1) {
                return;
            }
            Map dimensionAndMemberNumberMap = nodeRelationGraphDataTrackingItemPojo.getDimensionAndMemberNumberMap();
            if (MapUtils.isEmpty((Map)dimensionAndMemberNumberMap)) {
                return;
            }
            Map viewMap = OlapUtils.getViewMap((Long)relationGraphDataTrackingPojo.getModelIdLong(), (Map)dimensionAndMemberNumberMap);
            dimensionAndMemberNumberMap.forEach((dimensionNumberString, memberNumberString) -> {
                Dimension dimension = modelCacheHelper.getDimension(dimensionNumberString);
                if (dimension == null) {
                    return;
                }
                Member member = OlapUtils.getMember((Long)relationGraphDataTrackingPojo.getModelIdLong(), (String)dimensionNumberString, (Map)viewMap, (String)memberNumberString);
                if (member != null) {
                    headerMap.put((String)dimensionNumberString, dimension.getName());
                }
            });
        });
        DynamicEntryEntityPojo dynamicEntryEntityPojo = new DynamicEntryEntityPojo();
        RelationGraphDataTrackingItemPojo previousRelationGraphDataTrackingItemPojo = (RelationGraphDataTrackingItemPojo)LambdaUtils.getTarget((List)relationGraphDataTrackingPojo.getRelationGraphDataTrackingItemPojoList(), item -> RelationGraphDataTrackingTypeEnum.CELL.name().equals(item.getTypeString()) && relationGraphActionPojo.getIdString().equals(item.getLaterNodeIdString()));
        ArrayList<String> stringList = new ArrayList<String>(2);
        stringList.add(previousRelationGraphDataTrackingItemPojo.getNameString());
        stringList.add(ResManager.loadKDString((String)"\u660e\u7ec6\u6570\u636e", (String)"RelationGraphPlugin_72", (String)"epm-eb-formplugin", (Object[])new Object[0]));
        dynamicEntryEntityPojo.setPageTitleString(String.join((CharSequence)"-", stringList));
        dynamicEntryEntityPojo.setHeaderMap(headerMap);
        ArrayList<LinkedHashMap> rowMapList = new ArrayList<LinkedHashMap>(cellPojoList.size());
        dynamicEntryEntityPojo.setRowMapList(rowMapList);
        for (CellPojo cellPojo : cellPojoList) {
            Map dimensionAndMemberStringMap = cellPojo.getDimensionAndMemberStringMap();
            LinkedHashMap rowMap = Maps.newLinkedHashMapWithExpectedSize((int)dimensionAndMemberStringMap.size());
            rowMap.put("value", cellPojo.getValueString());
            rowMapList.add(rowMap);
            Map viewMap = OlapUtils.getViewMap((Long)relationGraphDataTrackingPojo.getModelIdLong(), (Map)dimensionAndMemberStringMap);
            dimensionAndMemberStringMap.forEach((keyString, valueString) -> {
                if (MapUtils.isEmpty((Map)headerMap) || !headerMap.containsKey(keyString)) {
                    return;
                }
                Member member = OlapUtils.getMember((Long)relationGraphDataTrackingPojo.getModelIdLong(), (String)keyString, (Map)viewMap, (String)valueString);
                if (member == null) {
                    return;
                }
                rowMap.put(keyString, member.getName());
            });
        }
        dynamicEntryEntityPojo.setParamMap(MapPlusUtils.getStringMap((String[])new String[]{RelationGraphActionPojo.class.getName(), JsonUtils.getJsonString((Object)relationGraphActionPojo)}));
        CacheUtils.put((IPageCache)relationGraphPlugin.getPageCache(), (String)RelationGraphModelPojo.class.getName(), (Object)relationGraphModelPojo);
        DynamicEntryEntityUtils.openDynamicEntryEntity(relationGraphPlugin.getView(), dynamicEntryEntityPojo, new CloseCallBack((IFormPlugin)relationGraphPlugin, "btnok"));
    }

    public static void matchReportActionMethod(RelationGraphPlugin relationGraphPlugin, CustomEventArgs customEventArgs) {
        JsonNode jsonNode = JsonUtils.readTree((String)customEventArgs.getEventArgs());
        RelationGraphModelPojo relationGraphModelPojo = (RelationGraphModelPojo)JsonUtils.readValue((JsonNode)jsonNode.get(FrontUtils.getNameString(RelationGraphModelPojo.class)), RelationGraphModelPojo.class);
        String relationGraphDataTrackingItemPojoJsonString = StrUtils.getBase64unEncodeString((String)jsonNode.get(FrontUtils.getNameString(RelationGraphDataTrackingItemPojo.class)).asText());
        RelationGraphDataTrackingItemPojo relationGraphDataTrackingItemPojo = (RelationGraphDataTrackingItemPojo)JsonUtils.readValue((String)relationGraphDataTrackingItemPojoJsonString, RelationGraphDataTrackingItemPojo.class);
        Map customParamMap = (Map)CacheUtils.get((IPageCache)relationGraphPlugin.getPageCache(), (String)CUSTOM_PARAM_MAP, (TypeReference)new TypeReference<Map<String, String>>(){});
        RelationGraphDataTrackingPojo relationGraphDataTrackingPojo = (RelationGraphDataTrackingPojo)JsonUtils.readValue((String)((String)customParamMap.get(RelationGraphDataTrackingPojo.class.getName())), RelationGraphDataTrackingPojo.class);
        RelationGraphDataTrackingItemPojo cellRelationGraphDataTrackingItemPojo = (RelationGraphDataTrackingItemPojo)LambdaUtils.getTarget((List)relationGraphDataTrackingPojo.getRelationGraphDataTrackingItemPojoList(), item -> RelationGraphDataTrackingTypeEnum.CELL.name().equals(item.getTypeString()) && item.getCurrentCellIdString().equals(relationGraphDataTrackingItemPojo.getCurrentCellIdString()));
        ReportOrTaskPojo reportOrTaskPojo = (ReportOrTaskPojo)LambdaUtils.get(() -> {
            if (MapUtils.isEmpty((Map)customParamMap)) {
                return null;
            }
            String reportOrTaskPojoJsonString = (String)customParamMap.get(ReportOrTaskPojo.class.getName());
            if (StringUtils.isBlank((CharSequence)reportOrTaskPojoJsonString)) {
                return null;
            }
            return (ReportOrTaskPojo)JsonUtils.readValue((String)reportOrTaskPojoJsonString, ReportOrTaskPojo.class);
        });
        String infoHtmlString = RelationGraphService.getInfoHtmlString(relationGraphPlugin.getView().getPageId(), relationGraphDataTrackingPojo.getModelIdLong(), cellRelationGraphDataTrackingItemPojo, reportOrTaskPojo);
        cellRelationGraphDataTrackingItemPojo.setInfoHtmlString(infoHtmlString);
        RelationGraphUtils.updateRelationGraphModelPojoInfoHtmlString(relationGraphModelPojo, cellRelationGraphDataTrackingItemPojo.getInfoHtmlString());
        customParamMap.put(RelationGraphDataTrackingPojo.class.getName(), JsonUtils.getJsonString((Object)relationGraphDataTrackingPojo));
        CacheUtils.put((IPageCache)relationGraphPlugin.getPageCache(), (String)CUSTOM_PARAM_MAP, (Object)customParamMap);
        RelationGraphUtils.checkAndReorganize(relationGraphModelPojo);
        ArrayList<String> evalStringList = new ArrayList<String>(3);
        evalStringList.add("Vue.set(vm.$data, 'relationGraphShowBoxPojoList', [])");
        evalStringList.add(StrUtils.format((String)"Vue.set(vm.$data, 'relationGraphModelPojo', {});", (Object[])new Object[]{JsonUtils.getWithoutNullJsonString((Object)relationGraphModelPojo)}));
        evalStringList.add("vm.$options.methods.updateRelationGraphByVueData();");
        EventPojo eventPojo = new EventPojo();
        eventPojo.setPreventDefaultBoolean(Boolean.valueOf(true));
        eventPojo.setEvalPojo(new EvalPojo().setEvalStringList(evalStringList));
        RuleJsUtils.invokeCustom(relationGraphPlugin.getCustomControl(), customEventArgs.getEventName(), "eval", EventUtils.getEventEvalString((EventPojo)eventPojo), null);
    }

    private static /* synthetic */ Boolean lambda$null$169(Map dimensionAndMemberNumberSetMap, Map dimensionAndMemberNumberMap, IModelCacheHelper modelCacheHelper, Long modelIdLong, Map viewMap) {
        Member metricMember;
        boolean allLeafBoolean;
        if (MapUtils.isNotEmpty((Map)dimensionAndMemberNumberSetMap)) {
            if (dimensionAndMemberNumberSetMap.size() > dimensionAndMemberNumberMap.size()) {
                return false;
            }
            for (Map.Entry entry : dimensionAndMemberNumberSetMap.entrySet()) {
                Set memberNumberStringSet = (Set)entry.getValue();
                if (memberNumberStringSet.size() <= 1 && memberNumberStringSet.contains(dimensionAndMemberNumberMap.get(entry.getKey()))) continue;
                return false;
            }
        }
        if (!(allLeafBoolean = ((Boolean)LambdaUtils.get(() -> {
            for (Map.Entry entry : dimensionAndMemberNumberMap.entrySet()) {
                Member member = modelCacheHelper.getMemberByAnyView((String)entry.getKey(), (String)entry.getValue());
                if (member.isLeaf()) continue;
                return false;
            }
            return true;
        })).booleanValue()) && (metricMember = OlapUtils.getMember((Long)modelIdLong, (String)SysDimensionEnum.Metric.getNumber(), (Map)viewMap, (String)((String)dimensionAndMemberNumberMap.get(SysDimensionEnum.Metric.getNumber())))) != null && metricMember.hasAgg()) {
            return false;
        }
        return true;
    }
}

