/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.formplugin.rulemanage;

import java.util.List;
import java.util.Map;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.epm.eb.common.cache.IModelCacheHelper;
import kd.epm.eb.common.cache.ModelCacheContext;
import kd.epm.eb.common.enums.ProcessTypeEnum;
import kd.epm.eb.common.pojo.ReportOrTaskPojo;
import kd.epm.eb.common.pojo.ReportProcessPojo;
import kd.epm.eb.common.sdk.report.ReportSDKUtils;
import kd.epm.eb.common.utils.base.EnumUtils;
import kd.epm.eb.common.utils.base.JsonUtils;
import kd.epm.eb.formplugin.rulemanage.RelationGraphService;

public class RelationGraphService2 {
    private static final Log log = LogFactory.getLog(RelationGraphService2.class);

    public static List<ReportProcessPojo> getMatchedReportProcessPojoList(ReportOrTaskPojo reportOrTaskPojo, Map<String, String> dimensionAndMemberNumberMap) {
        IModelCacheHelper modelCacheHelper = ModelCacheContext.getOrCreate((Long)reportOrTaskPojo.getModelIdLong());
        ProcessTypeEnum processTypeEnum = (ProcessTypeEnum)EnumUtils.getEnum(ProcessTypeEnum.class, (String)reportOrTaskPojo.getTypeString());
        ReportSDKUtils.DataTracking dataTracking = RelationGraphService2.initDataTracking(reportOrTaskPojo, dimensionAndMemberNumberMap);
        return RelationGraphService.getTargetReportProcessPojoList(ReportSDKUtils.get().getReportProcessIds(dataTracking, modelCacheHelper, processTypeEnum), processTypeEnum, reportOrTaskPojo.getModelIdLong(), dimensionAndMemberNumberMap);
    }

    private static ReportSDKUtils.DataTracking initDataTracking(ReportOrTaskPojo reportOrTaskPojo, Map<String, String> dimensionAndMemberNumberMap) {
        ReportSDKUtils.DataTracking dataTracking = new ReportSDKUtils.DataTracking();
        dataTracking.modelId = reportOrTaskPojo.getModelIdLong();
        dataTracking.busModelId = reportOrTaskPojo.getBusinessModelIdLong();
        ProcessTypeEnum processTypeEnum = (ProcessTypeEnum)EnumUtils.getEnum(ProcessTypeEnum.class, (String)reportOrTaskPojo.getTypeString());
        if (ProcessTypeEnum.TASK == processTypeEnum) {
            dataTracking.taskListId = reportOrTaskPojo.getTaskListIdLong();
        } else if (ProcessTypeEnum.REPORT == processTypeEnum) {
            dataTracking.rptSchemaId = reportOrTaskPojo.getRptSchemaIdLong();
            dataTracking.budgetPeriodId = reportOrTaskPojo.getBudgetPeriodIdLong();
            dataTracking.versionId = reportOrTaskPojo.getVersionIdLong();
            dataTracking.dataTypeId = reportOrTaskPojo.getDataTypeIdLong();
        }
        dataTracking.member = dimensionAndMemberNumberMap;
        return dataTracking;
    }

    public static List<ReportProcessPojo> getExamineLinkReportProcessPojoList(ReportOrTaskPojo reportOrTaskPojo, Map<String, String> dimensionAndMemberNumberMap, Long templateId) {
        IModelCacheHelper modelCacheHelper = ModelCacheContext.getOrCreate((Long)reportOrTaskPojo.getModelIdLong());
        ProcessTypeEnum processTypeEnum = (ProcessTypeEnum)EnumUtils.getEnum(ProcessTypeEnum.class, (String)reportOrTaskPojo.getTypeString());
        ReportSDKUtils.DataTracking dataTracking = RelationGraphService2.initDataTracking(reportOrTaskPojo, dimensionAndMemberNumberMap);
        dataTracking.templateId = templateId;
        dataTracking.sourceType = ProcessTypeEnum.EXAMINE;
        log.info("getExamineLinkReportProcessPojoList:>>>" + JsonUtils.getJsonString(dimensionAndMemberNumberMap));
        return ReportSDKUtils.get().getReportProcessIds(dataTracking, modelCacheHelper, processTypeEnum);
    }

    public static List<ReportProcessPojo> getMatchedReportProcessPojoListNew(ReportOrTaskPojo reportOrTaskPojo, Map<String, String> dimensionAndMemberNumberMap, List<Long> reportTemplates) {
        IModelCacheHelper modelCacheHelper = ModelCacheContext.getOrCreate((Long)reportOrTaskPojo.getModelIdLong());
        ReportSDKUtils.DataTracking dataTracking = new ReportSDKUtils.DataTracking();
        dataTracking.modelId = reportOrTaskPojo.getModelIdLong();
        dataTracking.busModelId = reportOrTaskPojo.getBusinessModelIdLong();
        ProcessTypeEnum processTypeEnum = (ProcessTypeEnum)EnumUtils.getEnum(ProcessTypeEnum.class, (String)reportOrTaskPojo.getTypeString());
        if (ProcessTypeEnum.TASK == processTypeEnum) {
            dataTracking.taskListId = reportOrTaskPojo.getTaskListIdLong();
        } else if (ProcessTypeEnum.REPORT == processTypeEnum) {
            dataTracking.rptSchemaId = reportOrTaskPojo.getRptSchemaIdLong();
            dataTracking.budgetPeriodId = reportOrTaskPojo.getBudgetPeriodIdLong();
            dataTracking.versionId = reportOrTaskPojo.getVersionIdLong();
            dataTracking.dataTypeId = reportOrTaskPojo.getDataTypeIdLong();
        }
        dataTracking.member = dimensionAndMemberNumberMap;
        return ReportSDKUtils.get().getReportProcessIdsNew(dataTracking, modelCacheHelper, processTypeEnum, reportTemplates);
    }
}

