/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.formplugin.rulemanage;

import com.google.common.collect.Lists;
import com.google.common.graph.ElementOrder;
import com.google.common.graph.Graph;
import com.google.common.graph.GraphBuilder;
import com.google.common.graph.Graphs;
import com.google.common.graph.MutableGraph;
import java.util.Arrays;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import java.util.stream.Collectors;
import kd.bos.bill.OperationStatus;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.exception.KDBizException;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.ShowType;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.epm.eb.common.cache.IModelCacheHelper;
import kd.epm.eb.common.cache.impl.Member;
import kd.epm.eb.common.enums.SysDimensionEnum;
import kd.epm.eb.common.pojo.StylePojo;
import kd.epm.eb.common.rule.relation.graph.RelationGraphDataPojo;
import kd.epm.eb.common.rule.relation.graph.RelationGraphLinkPojo;
import kd.epm.eb.common.rule.relation.graph.RelationGraphModelPojo;
import kd.epm.eb.common.rule.relation.graph.RelationGraphNodePojo;
import kd.epm.eb.common.rule.relation.graph.RelationGraphOptionsDefaultLineMarkerPojo;
import kd.epm.eb.common.rule.relation.graph.RelationGraphOptionsLayoutsPojo;
import kd.epm.eb.common.rule.relation.graph.RelationGraphOptionsPojo;
import kd.epm.eb.common.rule.relation.graph.component.ContextmenuItemComponent;
import kd.epm.eb.common.rule.relation.graph.data.RelationGraphNodeDataAreaPojo;
import kd.epm.eb.common.rule.relation.graph.data.RelationGraphNodeDataCellPojo;
import kd.epm.eb.common.rule.relation.graph.data.RelationGraphNodeDataPojo;
import kd.epm.eb.common.rule.relation.graph.data.RelationGraphNodeDataRowPojo;
import kd.epm.eb.common.rule.relation.graph.ext.RelationGraphShowBoxParent;
import kd.epm.eb.common.rule.relation.graph.ext.RelationGraphShowBoxPojo;
import kd.epm.eb.common.rule.relation.pojo.AxisPojo;
import kd.epm.eb.common.rule.relation.pojo.RelationGraphActionPojo;
import kd.epm.eb.common.rule.relation.pojo.RelationGraphActionPositionPojo;
import kd.epm.eb.common.rule.relation.pojo.RelationGraphInteractionTypeEnum;
import kd.epm.eb.common.rule.relation.pojo.RelationGraphNodePojoTree;
import kd.epm.eb.common.rule.relation.pojo.RelationGraphShowBoxTypeEnum;
import kd.epm.eb.common.rule.relation.pojo.RelationGraphTypeEnum;
import kd.epm.eb.common.utils.base.JsonUtils;
import kd.epm.eb.common.utils.base.LambdaUtils;
import kd.epm.eb.common.utils.base.ObjUtils;
import kd.epm.eb.common.utils.base.StrUtils;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.collections4.MapUtils;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.BooleanUtils;
import org.apache.commons.lang3.EnumUtils;
import org.apache.commons.lang3.StringUtils;

public class RelationGraphUtils {
    private static final Log log = LogFactory.getLog(RelationGraphUtils.class);
    public static final String DEFAULT_ROOT_NODE_ID_STRING = "DEFAULT_ROOT_NODE_ID_STRING";
    public static final String AnalysisContext = "AnalysisContext";

    public static RelationGraphOptionsPojo getFixedRelationGraphOptionsPojo() {
        RelationGraphOptionsPojo relationGraphOptionsPojo = new RelationGraphOptionsPojo();
        relationGraphOptionsPojo.setDefaultNodeBorderWidthInteger(Integer.valueOf(0));
        relationGraphOptionsPojo.setAllowSwitchLineShapeBoolean(Boolean.valueOf(true));
        relationGraphOptionsPojo.setAllowSwitchJunctionPointBoolean(Boolean.valueOf(true));
        relationGraphOptionsPojo.setDefaultNodeShapeInteger(Integer.valueOf(1));
        relationGraphOptionsPojo.setMoveToCenterWhenResizeBoolean(Boolean.valueOf(false));
        relationGraphOptionsPojo.setDefaultLineShapeInteger(Integer.valueOf(1));
        relationGraphOptionsPojo.setDefaultJunctionPointString("lr");
        relationGraphOptionsPojo.setDefaultExpandHolderPositionString("hide");
        relationGraphOptionsPojo.setAllowShowMiniViewBoolean(Boolean.valueOf(false));
        relationGraphOptionsPojo.setAllowShowMiniNameFilterBoolean(Boolean.valueOf(false));
        relationGraphOptionsPojo.setDefaultShowLineLabelBoolean(Boolean.valueOf(false));
        relationGraphOptionsPojo.setDisableZoomBoolean(Boolean.valueOf(true));
        LinkedList<Object> relationGraphOptionsLayoutsPojoList = new LinkedList<Object>();
        relationGraphOptionsPojo.setRelationGraphOptionsLayoutsPojoList(relationGraphOptionsLayoutsPojoList);
        relationGraphOptionsLayoutsPojoList.add(LambdaUtils.get(() -> {
            RelationGraphOptionsLayoutsPojo relationGraphOptionsLayoutsPojo = new RelationGraphOptionsLayoutsPojo();
            relationGraphOptionsLayoutsPojo.setLayoutLabelString("test");
            relationGraphOptionsLayoutsPojo.setLayoutNameString("fixed");
            relationGraphOptionsLayoutsPojo.setLayoutClassNameString("seeks-layout-fixed");
            relationGraphOptionsLayoutsPojo.setFromString("left");
            relationGraphOptionsLayoutsPojo.setMinPerWidthInteger(Integer.valueOf(100));
            relationGraphOptionsLayoutsPojo.setMaxPerWidthInteger(Integer.valueOf(1000));
            relationGraphOptionsLayoutsPojo.setMinPerHeightInteger(Integer.valueOf(10));
            relationGraphOptionsLayoutsPojo.setMaxPerHeightInteger(Integer.valueOf(100));
            return relationGraphOptionsLayoutsPojo;
        }));
        relationGraphOptionsPojo.setRelationGraphOptionsDefaultLineMarkerPojo((RelationGraphOptionsDefaultLineMarkerPojo)LambdaUtils.get(() -> {
            RelationGraphOptionsDefaultLineMarkerPojo relationGraphOptionsDefaultLineMarkerPojo = new RelationGraphOptionsDefaultLineMarkerPojo();
            relationGraphOptionsDefaultLineMarkerPojo.setMarkerWidthInteger(Integer.valueOf(15));
            relationGraphOptionsDefaultLineMarkerPojo.setMarkerHeightInteger(Integer.valueOf(15));
            relationGraphOptionsDefaultLineMarkerPojo.setRefXaxisInteger(Integer.valueOf(30));
            relationGraphOptionsDefaultLineMarkerPojo.setRefYaxisInteger(Integer.valueOf(7));
            relationGraphOptionsDefaultLineMarkerPojo.setDataString("M 14 7 L 1 .3 L 4 7 L .4 13 L 14 7, Z");
            return relationGraphOptionsDefaultLineMarkerPojo;
        }));
        return relationGraphOptionsPojo;
    }

    public static RelationGraphNodePojo getRootRelationGraphNodePojo() {
        RelationGraphNodePojo rootRelationGraphNodePojo = new RelationGraphNodePojo();
        rootRelationGraphNodePojo.setIdString(DEFAULT_ROOT_NODE_ID_STRING);
        rootRelationGraphNodePojo.setTextString("o");
        rootRelationGraphNodePojo.setOpacityInteger(Integer.valueOf(0));
        return rootRelationGraphNodePojo;
    }

    public static MutableGraph<String> getGraph(RelationGraphDataPojo relationGraphDataPojo) {
        List ruleGraphNodePojoList = relationGraphDataPojo.getRelationGraphNodePojoList();
        MutableGraph graph = GraphBuilder.directed().nodeOrder(ElementOrder.insertion()).expectedNodeCount(ruleGraphNodePojoList.size()).allowsSelfLoops(false).build();
        ruleGraphNodePojoList.forEach(relationGraphNodePojo -> graph.addNode((Object)relationGraphNodePojo.getIdString()));
        List relationGraphLinkPojoVoList = relationGraphDataPojo.getRelationGraphLinkPojoList();
        if (CollectionUtils.isNotEmpty((Collection)relationGraphLinkPojoVoList)) {
            relationGraphLinkPojoVoList.forEach(relationGraphLinkPojo -> graph.putEdge((Object)relationGraphLinkPojo.getFromString(), (Object)relationGraphLinkPojo.getToString()));
        }
        return graph;
    }

    public static MutableGraph<String> getWithoutDefaultRootGraph(RelationGraphDataPojo relationGraphDataPojo) {
        RelationGraphDataPojo withoutDefaultRootGraphRelationGraphDataPojo = new RelationGraphDataPojo();
        List relationGraphNodePojoList = relationGraphDataPojo.getRelationGraphNodePojoList().stream().filter(item -> !item.getIdString().equals(DEFAULT_ROOT_NODE_ID_STRING)).collect(Collectors.toList());
        withoutDefaultRootGraphRelationGraphDataPojo.setRelationGraphNodePojoList(relationGraphNodePojoList);
        List relationGraphLinkPojoList = null;
        if (relationGraphDataPojo.getRelationGraphLinkPojoList() != null) {
            relationGraphLinkPojoList = relationGraphDataPojo.getRelationGraphLinkPojoList().stream().filter(item -> !StringUtils.equalsAny((CharSequence)DEFAULT_ROOT_NODE_ID_STRING, (CharSequence[])new CharSequence[]{item.getFromString(), item.getToString()})).collect(Collectors.toList());
        }
        withoutDefaultRootGraphRelationGraphDataPojo.setRelationGraphLinkPojoList(relationGraphLinkPojoList);
        return RelationGraphUtils.getGraph(withoutDefaultRootGraphRelationGraphDataPojo);
    }

    public static Set<String> getPreviousGraphNodeIdStringSet(Graph<String> graph, String idString) {
        Graph transposeGraph = Graphs.transpose(graph);
        TreeSet<String> nodeIdStringSet = new TreeSet<String>(Graphs.reachableNodes((Graph)transposeGraph, (Object)idString));
        nodeIdStringSet.remove(idString);
        return nodeIdStringSet;
    }

    public static Set<String> getLaterGraphNodeIdStringSet(Graph<String> graph, String idString) {
        TreeSet<String> nodeIdStringSet = new TreeSet<String>(Graphs.reachableNodes(graph, (Object)idString));
        nodeIdStringSet.remove(idString);
        return nodeIdStringSet;
    }

    public static RelationGraphDataPojo getRelationGraphDataPojo(RelationGraphDataPojo fullRelationGraphDataPojo, Set<String> neededNodeIdStringSet) {
        RelationGraphDataPojo outputRelationGraphDataPojo = new RelationGraphDataPojo();
        MutableGraph<String> currentGraph = RelationGraphUtils.getWithoutDefaultRootGraph(fullRelationGraphDataPojo);
        TreeSet fullNodeIdStringSet = new TreeSet(currentGraph.nodes());
        fullNodeIdStringSet.stream().forEach(item -> {
            if (!neededNodeIdStringSet.contains(item)) {
                currentGraph.removeNode(item);
            }
        });
        List relationGraphNodePojoList = fullRelationGraphDataPojo.getRelationGraphNodePojoList().stream().filter(item -> {
            if (DEFAULT_ROOT_NODE_ID_STRING.equals(item.getIdString())) {
                return false;
            }
            return neededNodeIdStringSet.contains(item.getIdString());
        }).collect(Collectors.toList());
        outputRelationGraphDataPojo.setRelationGraphNodePojoList(relationGraphNodePojoList);
        List relationGraphLinkPojoList = fullRelationGraphDataPojo.getRelationGraphLinkPojoList().stream().filter(item -> {
            List<String> fromAndToNodeIdStringList = Arrays.asList(item.getFromString(), item.getToString());
            if (fromAndToNodeIdStringList.contains(DEFAULT_ROOT_NODE_ID_STRING)) {
                return false;
            }
            return CollectionUtils.intersection((Iterable)neededNodeIdStringSet, fromAndToNodeIdStringList).size() == 2;
        }).collect(Collectors.toList());
        outputRelationGraphDataPojo.setRelationGraphLinkPojoList(relationGraphLinkPojoList);
        RelationGraphNodePojo rootRelationGraphNodePojo = RelationGraphUtils.getRootRelationGraphNodePojo();
        outputRelationGraphDataPojo.setRootIdString(rootRelationGraphNodePojo.getIdString());
        relationGraphNodePojoList.add(rootRelationGraphNodePojo);
        for (String nodeString : currentGraph.nodes()) {
            if (!CollectionUtils.isEmpty((Collection)currentGraph.predecessors((Object)nodeString))) continue;
            RelationGraphLinkPojo relationGraphLinkPojo = new RelationGraphLinkPojo();
            relationGraphLinkPojo.setFromString(rootRelationGraphNodePojo.getIdString());
            relationGraphLinkPojo.setToString(nodeString);
            relationGraphLinkPojo.setHideBoolean(Boolean.valueOf(true));
            relationGraphLinkPojoList.add(relationGraphLinkPojo);
        }
        MutableGraph<String> fullGraph = RelationGraphUtils.getWithoutDefaultRootGraph(fullRelationGraphDataPojo);
        outputRelationGraphDataPojo.getRelationGraphNodePojoList().forEach(relationGraphNodePojo -> {
            if (DEFAULT_ROOT_NODE_ID_STRING.equals(relationGraphNodePojo.getIdString())) {
                return;
            }
            RelationGraphNodeDataPojo relationGraphNodeDataPojo = relationGraphNodePojo.getRelationGraphNodeDataPojo();
            if (relationGraphNodeDataPojo == null) {
                relationGraphNodeDataPojo = new RelationGraphNodeDataPojo();
                relationGraphNodePojo.setRelationGraphNodeDataPojo(relationGraphNodeDataPojo);
            }
            Set<String> allGraphPreviousGraphNodeIdStringSet = RelationGraphUtils.getPreviousGraphNodeIdStringSet((Graph<String>)fullGraph, relationGraphNodePojo.getIdString());
            relationGraphNodeDataPojo.setPreviousBoolean(Boolean.valueOf(CollectionUtils.isNotEmpty(allGraphPreviousGraphNodeIdStringSet)));
            if (relationGraphNodeDataPojo.getPreviousBoolean().booleanValue()) {
                Set fullGraphPreviousGraphNodeIdStringSet = fullGraph.predecessors((Object)relationGraphNodePojo.getIdString());
                Set subGraphPreviousGraphNodeIdStringSet = currentGraph.predecessors((Object)relationGraphNodePojo.getIdString());
                relationGraphNodeDataPojo.setPreviousExpandBoolean(Boolean.valueOf(fullGraphPreviousGraphNodeIdStringSet.size() == subGraphPreviousGraphNodeIdStringSet.size()));
            } else {
                relationGraphNodeDataPojo.setPreviousExpandBoolean(Boolean.valueOf(false));
            }
            Set<String> allGraphLaterGraphNodeIdStringSet = RelationGraphUtils.getLaterGraphNodeIdStringSet((Graph<String>)fullGraph, relationGraphNodePojo.getIdString());
            relationGraphNodeDataPojo.setLaterBoolean(Boolean.valueOf(CollectionUtils.isNotEmpty(allGraphLaterGraphNodeIdStringSet)));
            if (relationGraphNodeDataPojo.getLaterBoolean().booleanValue()) {
                Set fullGraphLaterGraphNodeIdStringSet = fullGraph.successors((Object)relationGraphNodePojo.getIdString());
                Set subGraphLaterGraphNodeIdStringSet = currentGraph.successors((Object)relationGraphNodePojo.getIdString());
                relationGraphNodeDataPojo.setLaterExpandBoolean(Boolean.valueOf(fullGraphLaterGraphNodeIdStringSet.size() == subGraphLaterGraphNodeIdStringSet.size()));
            } else {
                relationGraphNodeDataPojo.setLaterExpandBoolean(Boolean.valueOf(false));
            }
        });
        return outputRelationGraphDataPojo;
    }

    public static void removeNodeIdString(RelationGraphDataPojo relationGraphDataPojo, String ... removeNodeIdStringArray) {
        if (ArrayUtils.isEmpty((Object[])removeNodeIdStringArray)) {
            return;
        }
        List relationGraphNodePojoList = relationGraphDataPojo.getRelationGraphNodePojoList();
        LinkedList<RelationGraphNodePojo> removeRelationGraphNodePojoList = new LinkedList<RelationGraphNodePojo>();
        for (RelationGraphNodePojo relationGraphNodePojo : relationGraphNodePojoList) {
            if (!StringUtils.equalsAny((CharSequence)relationGraphNodePojo.getIdString(), (CharSequence[])removeNodeIdStringArray)) continue;
            removeRelationGraphNodePojoList.add(relationGraphNodePojo);
        }
        relationGraphNodePojoList.removeAll(removeRelationGraphNodePojoList);
        relationGraphDataPojo.setRelationGraphNodePojoList(relationGraphNodePojoList);
        List relationGraphLinkPojoList = relationGraphDataPojo.getRelationGraphLinkPojoList();
        LinkedList<RelationGraphLinkPojo> removeRelationGraphLinkPojoList = new LinkedList<RelationGraphLinkPojo>();
        for (RelationGraphLinkPojo relationGraphLinkPojo : relationGraphLinkPojoList) {
            for (String removeNodeIdString : removeNodeIdStringArray) {
                if (!StringUtils.equalsAny((CharSequence)removeNodeIdString, (CharSequence[])new CharSequence[]{relationGraphLinkPojo.getFromString(), relationGraphLinkPojo.getToString()})) continue;
                removeRelationGraphLinkPojoList.add(relationGraphLinkPojo);
            }
        }
        relationGraphLinkPojoList.removeAll(removeRelationGraphLinkPojoList);
        relationGraphDataPojo.setRelationGraphLinkPojoList(relationGraphLinkPojoList);
    }

    public static RelationGraphShowBoxParent getFinalRelationGraphShowBoxParent(RelationGraphShowBoxParent relationGraphShowBoxParent) {
        RelationGraphShowBoxParent finalRelationGraphShowBoxParent = new RelationGraphShowBoxParent();
        finalRelationGraphShowBoxParent.setEnableMourceBoxBoolean(Boolean.valueOf(false));
        LinkedList<RelationGraphShowBoxPojo> relationGraphShowBoxPojoList = new LinkedList<RelationGraphShowBoxPojo>();
        finalRelationGraphShowBoxParent.setRelationGraphShowBoxPojoList(relationGraphShowBoxPojoList);
        RelationGraphShowBoxPojo contextmenuRelationGraphShowBoxPojo = new RelationGraphShowBoxPojo();
        relationGraphShowBoxPojoList.add(contextmenuRelationGraphShowBoxPojo);
        contextmenuRelationGraphShowBoxPojo.setTypeString(RelationGraphShowBoxTypeEnum.CONTEXTMENU.name());
        LinkedList<RelationGraphInteractionTypeEnum> prefabricatedRelationGraphInteractionTypeEnumList = new LinkedList<RelationGraphInteractionTypeEnum>();
        prefabricatedRelationGraphInteractionTypeEnumList.add(RelationGraphInteractionTypeEnum.NODE_HIDE_NO_RELATED_NODES);
        prefabricatedRelationGraphInteractionTypeEnumList.add(RelationGraphInteractionTypeEnum.NODE_EXPAND_ALL_RELATED_NODES);
        prefabricatedRelationGraphInteractionTypeEnumList.add(RelationGraphInteractionTypeEnum.NODE_DELETE_CURRENT_NODE);
        LinkedList<Object> contextmenuItemComponentList = new LinkedList<Object>();
        contextmenuRelationGraphShowBoxPojo.setContextmenuItemComponentList(contextmenuItemComponentList);
        contextmenuItemComponentList.add(LambdaUtils.get(() -> {
            ContextmenuItemComponent contextmenuItemComponent = new ContextmenuItemComponent();
            contextmenuItemComponent.setTypeString(RelationGraphInteractionTypeEnum.NODE_HIDE_NO_RELATED_NODES.name());
            contextmenuItemComponent.setValueString(ResManager.loadKDString((String)"\u9690\u85cf\u4e0e\u5f53\u524d\u8282\u70b9\u65e0\u5173\u7cfb\u7684\u8282\u70b9", (String)"RelationGraphPlugin_14", (String)"epm-eb-formplugin", (Object[])new Object[0]));
            contextmenuItemComponent.setSelectedBoolean(Boolean.valueOf(false));
            return contextmenuItemComponent;
        }));
        contextmenuItemComponentList.add(LambdaUtils.get(() -> {
            ContextmenuItemComponent contextmenuItemComponent = new ContextmenuItemComponent();
            contextmenuItemComponent.setTypeString(RelationGraphInteractionTypeEnum.NODE_EXPAND_ALL_RELATED_NODES.name());
            contextmenuItemComponent.setValueString(ResManager.loadKDString((String)"\u5c55\u5f00\u4e0e\u5f53\u524d\u8282\u70b9\u6709\u5173\u7cfb\u7684\u6240\u6709\u8282\u70b9", (String)"RelationGraphPlugin_15", (String)"epm-eb-formplugin", (Object[])new Object[0]));
            contextmenuItemComponent.setSelectedBoolean(Boolean.valueOf(false));
            return contextmenuItemComponent;
        }));
        contextmenuItemComponentList.add(LambdaUtils.get(() -> {
            ContextmenuItemComponent contextmenuItemComponent = new ContextmenuItemComponent();
            contextmenuItemComponent.setTypeString(RelationGraphInteractionTypeEnum.NODE_DELETE_CURRENT_NODE.name());
            contextmenuItemComponent.setValueString(ResManager.loadKDString((String)"\u5220\u9664\u5f53\u524d\u8282\u70b9", (String)"RelationGraphPlugin_40", (String)"epm-eb-formplugin", (Object[])new Object[0]));
            contextmenuItemComponent.setSelectedBoolean(Boolean.valueOf(false));
            return contextmenuItemComponent;
        }));
        if (relationGraphShowBoxParent == null) {
            return finalRelationGraphShowBoxParent;
        }
        finalRelationGraphShowBoxParent.setEnableMourceBoxBoolean(Boolean.valueOf(BooleanUtils.isTrue((Boolean)relationGraphShowBoxParent.getEnableMourceBoxBoolean())));
        List originRelationGraphShowBoxPojoList = relationGraphShowBoxParent.getRelationGraphShowBoxPojoList();
        if (CollectionUtils.isEmpty((Collection)originRelationGraphShowBoxPojoList)) {
            return finalRelationGraphShowBoxParent;
        }
        originRelationGraphShowBoxPojoList.forEach(item -> {
            if (RelationGraphShowBoxTypeEnum.CONTEXTMENU.name().equals(item.getTypeString())) {
                if (CollectionUtils.isNotEmpty((Collection)item.getContextmenuItemComponentList())) {
                    for (ContextmenuItemComponent contextmenuItemComponent : item.getContextmenuItemComponentList()) {
                        String typeString = contextmenuItemComponent.getTypeString();
                        RelationGraphInteractionTypeEnum relationGraphInteractionTypeEnum = (RelationGraphInteractionTypeEnum)EnumUtils.getEnum(RelationGraphInteractionTypeEnum.class, (String)typeString);
                        if (relationGraphInteractionTypeEnum != null && prefabricatedRelationGraphInteractionTypeEnumList.contains(relationGraphInteractionTypeEnum)) continue;
                        contextmenuRelationGraphShowBoxPojo.getContextmenuItemComponentList().add(contextmenuItemComponent);
                    }
                }
            } else {
                relationGraphShowBoxPojoList.add((RelationGraphShowBoxPojo)item);
            }
        });
        return finalRelationGraphShowBoxParent;
    }

    public static RelationGraphDataPojo getRelationGraphDataPojoByGraphLogString(String graphLogString) {
        RelationGraphDataPojo relationGraphDataPojo = new RelationGraphDataPojo();
        String nodesSignString = ", nodes: ";
        int nodesIndexInt = graphLogString.indexOf(nodesSignString);
        String edgesSignString = ", edges: ";
        int edgesIndexInt = graphLogString.indexOf(edgesSignString);
        String nodesString = graphLogString.substring(nodesIndexInt + nodesSignString.length() + 1, edgesIndexInt - 1);
        String[] nodeStringList = nodesString.split(", ");
        LinkedList<RelationGraphNodePojo> ruleGraphNodePojoList = new LinkedList<RelationGraphNodePojo>();
        relationGraphDataPojo.setRelationGraphNodePojoList(ruleGraphNodePojoList);
        for (String nodeString : nodeStringList) {
            RelationGraphNodePojo relationGraphNodeVoPojo = new RelationGraphNodePojo();
            relationGraphNodeVoPojo.setIdString(nodeString);
            relationGraphNodeVoPojo.setTextString(nodeString);
            ruleGraphNodePojoList.add(relationGraphNodeVoPojo);
        }
        LinkedList<RelationGraphLinkPojo> relationGraphLinkPojoList = new LinkedList<RelationGraphLinkPojo>();
        relationGraphDataPojo.setRelationGraphLinkPojoList(relationGraphLinkPojoList);
        String edgesString = graphLogString.substring(edgesIndexInt + edgesSignString.length() + 1, graphLogString.length() - 1);
        Object[] edgesStringArray = edgesString.split(", ");
        if (ArrayUtils.isEmpty((Object[])edgesStringArray)) {
            return relationGraphDataPojo;
        }
        for (Object edgeString : edgesStringArray) {
            if (StringUtils.isBlank((CharSequence)edgeString)) continue;
            String edgeSubString = ((String)edgeString).trim().substring(1, ((String)edgeString).length() - 1);
            List<String> edageSubStringList = Arrays.asList(edgeSubString.split(" -> "));
            RelationGraphLinkPojo relationGraphLinkPojo = new RelationGraphLinkPojo();
            relationGraphLinkPojo.setFromString(edageSubStringList.get(0));
            relationGraphLinkPojo.setToString(edageSubStringList.get(1));
            relationGraphLinkPojoList.add(relationGraphLinkPojo);
        }
        return relationGraphDataPojo;
    }

    public static RelationGraphModelPojo testRelationGraphModelPojo() {
        return RelationGraphUtils.testRelationGraphModelPojo(null);
    }

    public static RelationGraphModelPojo testRelationGraphModelPojo(AbstractFormPlugin abstractFormPlugin) {
        StylePojo memberCellStylePojo = new StylePojo();
        memberCellStylePojo.setColorString("#8CAAF4");
        memberCellStylePojo.setCursorString("pointer");
        memberCellStylePojo.setDisplayString("inline-block");
        RelationGraphNodePojo testRelationGraphNodePojo = (RelationGraphNodePojo)LambdaUtils.get(() -> {
            RelationGraphNodePojo relationGraphNodePojo = new RelationGraphNodePojo();
            RelationGraphNodeDataPojo relationGraphNodeDataPojo = new RelationGraphNodeDataPojo();
            relationGraphNodePojo.setRelationGraphNodeDataPojo(relationGraphNodeDataPojo);
            RelationGraphNodeDataAreaPojo relationGraphNodeDataAreaPojo = new RelationGraphNodeDataAreaPojo();
            StylePojo areaStylePojo = new StylePojo();
            areaStylePojo.setTextAlignString("left");
            areaStylePojo.setDisplayString("inline-block");
            areaStylePojo.setFontFamilyString("Simsun,sans-serif");
            relationGraphNodeDataAreaPojo.setStylePojo(areaStylePojo);
            relationGraphNodeDataPojo.setRelationGraphNodeDataAreaPojo(relationGraphNodeDataAreaPojo);
            LinkedList<Object> relationGraphNodeDataRowPojoList = new LinkedList<Object>();
            relationGraphNodeDataAreaPojo.setRelationGraphNodeDataRowPojoList(relationGraphNodeDataRowPojoList);
            relationGraphNodeDataRowPojoList.add(LambdaUtils.get(() -> {
                RelationGraphNodeDataRowPojo relationGraphNodeDataRowPojo = new RelationGraphNodeDataRowPojo();
                LinkedList<Object> relationGraphNodeDataCellPojoList = new LinkedList<Object>();
                relationGraphNodeDataRowPojo.setRelationGraphNodeDataCellPojoList(relationGraphNodeDataCellPojoList);
                relationGraphNodeDataCellPojoList.add(LambdaUtils.get(() -> {
                    RelationGraphNodeDataCellPojo relationGraphNodeDataCellPojo = new RelationGraphNodeDataCellPojo();
                    relationGraphNodeDataCellPojo.setValueString("aaa</br>100");
                    relationGraphNodeDataCellPojo.setTypeStringList((List)Lists.newArrayList((Object[])new String[]{RelationGraphTypeEnum.BACKGROUND_COLOR.name(), RelationGraphTypeEnum.RULE_MEMBER.name()}));
                    relationGraphNodeDataCellPojo.setStylePojo(memberCellStylePojo);
                    return relationGraphNodeDataCellPojo;
                }));
                relationGraphNodeDataCellPojoList.add(LambdaUtils.get(() -> {
                    RelationGraphNodeDataCellPojo relationGraphNodeDataCellPojo = new RelationGraphNodeDataCellPojo();
                    relationGraphNodeDataCellPojo.setValueString("=</br>=");
                    StylePojo cellStylePojo = new StylePojo();
                    cellStylePojo.setDisplayString("inline-block");
                    relationGraphNodeDataCellPojo.setStylePojo(cellStylePojo);
                    return relationGraphNodeDataCellPojo;
                }));
                relationGraphNodeDataCellPojoList.add(LambdaUtils.get(() -> {
                    RelationGraphNodeDataCellPojo relationGraphNodeDataCellPojo = new RelationGraphNodeDataCellPojo();
                    relationGraphNodeDataCellPojo.setValueString("AAA</br>20");
                    relationGraphNodeDataCellPojo.setTypeStringList((List)Lists.newArrayList((Object[])new String[]{RelationGraphTypeEnum.BACKGROUND_COLOR.name(), RelationGraphTypeEnum.RULE_MEMBER.name()}));
                    relationGraphNodeDataCellPojo.setStylePojo(memberCellStylePojo);
                    return relationGraphNodeDataCellPojo;
                }));
                relationGraphNodeDataCellPojoList.add(LambdaUtils.get(() -> {
                    RelationGraphNodeDataCellPojo relationGraphNodeDataCellPojo = new RelationGraphNodeDataCellPojo();
                    relationGraphNodeDataCellPojo.setValueString("*</br>*");
                    StylePojo cellStylePojo = new StylePojo();
                    cellStylePojo.setDisplayString("inline-block");
                    relationGraphNodeDataCellPojo.setStylePojo(cellStylePojo);
                    return relationGraphNodeDataCellPojo;
                }));
                relationGraphNodeDataCellPojoList.add(LambdaUtils.get(() -> {
                    RelationGraphNodeDataCellPojo relationGraphNodeDataCellPojo = new RelationGraphNodeDataCellPojo();
                    relationGraphNodeDataCellPojo.setValueString("bbb</br>5");
                    relationGraphNodeDataCellPojo.setTypeStringList((List)Lists.newArrayList((Object[])new String[]{RelationGraphTypeEnum.BACKGROUND_COLOR.name(), RelationGraphTypeEnum.RULE_MEMBER.name()}));
                    relationGraphNodeDataCellPojo.setStylePojo(memberCellStylePojo);
                    return relationGraphNodeDataCellPojo;
                }));
                return relationGraphNodeDataRowPojo;
            }));
            relationGraphNodeDataRowPojoList.add(LambdaUtils.get(() -> {
                RelationGraphNodeDataRowPojo relationGraphNodeDataRowPojo = new RelationGraphNodeDataRowPojo();
                StylePojo rowStylePojo = new StylePojo();
                rowStylePojo.setBorderTopString("#909399 dashed 1px");
                relationGraphNodeDataRowPojo.setStylePojo(rowStylePojo);
                LinkedList<Object> relationGraphNodeDataCellPojoList = new LinkedList<Object>();
                relationGraphNodeDataRowPojo.setRelationGraphNodeDataCellPojoList(relationGraphNodeDataCellPojoList);
                relationGraphNodeDataCellPojoList.add(LambdaUtils.get(() -> {
                    RelationGraphNodeDataCellPojo relationGraphNodeDataCellPojo = new RelationGraphNodeDataCellPojo();
                    relationGraphNodeDataCellPojo.setValueString("RuleNumber:");
                    StylePojo cellStylePojo = new StylePojo();
                    cellStylePojo.setColorString("#909399");
                    cellStylePojo.setDisplayString("inline-block");
                    relationGraphNodeDataCellPojo.setStylePojo(cellStylePojo);
                    return relationGraphNodeDataCellPojo;
                }));
                relationGraphNodeDataCellPojoList.add(LambdaUtils.get(() -> {
                    RelationGraphNodeDataCellPojo relationGraphNodeDataCellPojo = new RelationGraphNodeDataCellPojo();
                    StylePojo cellStylePojo = new StylePojo();
                    cellStylePojo.setColorString("#8CAAF4");
                    cellStylePojo.setDisplayString("inline-block");
                    relationGraphNodeDataCellPojo.setStylePojo(cellStylePojo);
                    relationGraphNodeDataCellPojo.setValueString("AAA");
                    relationGraphNodeDataCellPojo.setTypeStringList((List)Lists.newArrayList((Object[])new String[]{RelationGraphTypeEnum.BACKGROUND_COLOR.name(), RelationGraphTypeEnum.RULE_MEMBER.name()}));
                    return relationGraphNodeDataCellPojo;
                }));
                return relationGraphNodeDataRowPojo;
            }));
            relationGraphNodeDataRowPojoList.add(LambdaUtils.get(() -> {
                RelationGraphNodeDataRowPojo relationGraphNodeDataRowPojo = new RelationGraphNodeDataRowPojo();
                LinkedList<Object> relationGraphNodeDataCellPojoList = new LinkedList<Object>();
                relationGraphNodeDataRowPojo.setRelationGraphNodeDataCellPojoList(relationGraphNodeDataCellPojoList);
                relationGraphNodeDataCellPojoList.add(LambdaUtils.get(() -> {
                    RelationGraphNodeDataCellPojo relationGraphNodeDataCellPojo = new RelationGraphNodeDataCellPojo();
                    relationGraphNodeDataCellPojo.setValueString("RuleName:");
                    StylePojo cellStylePojo = new StylePojo();
                    cellStylePojo.setColorString("#909399");
                    cellStylePojo.setDisplayString("inline-block");
                    relationGraphNodeDataCellPojo.setStylePojo(cellStylePojo);
                    return relationGraphNodeDataCellPojo;
                }));
                relationGraphNodeDataCellPojoList.add(LambdaUtils.get(() -> {
                    RelationGraphNodeDataCellPojo relationGraphNodeDataCellPojo = new RelationGraphNodeDataCellPojo();
                    relationGraphNodeDataCellPojo.setValueString("AaaRule");
                    StylePojo cellStylePojo = new StylePojo();
                    cellStylePojo.setColorString("#909399");
                    cellStylePojo.setDisplayString("inline-block");
                    relationGraphNodeDataCellPojo.setStylePojo(cellStylePojo);
                    return relationGraphNodeDataCellPojo;
                }));
                return relationGraphNodeDataRowPojo;
            }));
            return relationGraphNodePojo;
        });
        RelationGraphModelPojo relationGraphModelPojo = new RelationGraphModelPojo();
        relationGraphModelPojo.setGraphTitleString("GRAPH_TITLE");
        RelationGraphDataPojo relationGraphDataPojo = new RelationGraphDataPojo();
        relationGraphModelPojo.setRelationGraphDataPojo(relationGraphDataPojo);
        LinkedList<Object> relationGraphNodePojoList = new LinkedList<Object>();
        relationGraphDataPojo.setRelationGraphNodePojoList(relationGraphNodePojoList);
        relationGraphNodePojoList.add(LambdaUtils.get(() -> {
            RelationGraphNodePojo relationGraphNodePojo = (RelationGraphNodePojo)JsonUtils.deepClone((Object)testRelationGraphNodePojo);
            relationGraphNodePojo.setIdString("aaa");
            return relationGraphNodePojo;
        }));
        relationGraphNodePojoList.add(LambdaUtils.get(() -> {
            RelationGraphNodePojo relationGraphNodePojo = (RelationGraphNodePojo)JsonUtils.deepClone((Object)testRelationGraphNodePojo);
            relationGraphNodePojo.setIdString("bbb");
            return relationGraphNodePojo;
        }));
        relationGraphNodePojoList.add(LambdaUtils.get(() -> {
            RelationGraphNodePojo relationGraphNodePojo = (RelationGraphNodePojo)JsonUtils.deepClone((Object)testRelationGraphNodePojo);
            relationGraphNodePojo.setIdString("ccc");
            return relationGraphNodePojo;
        }));
        LinkedList<Object> relationGraphLinkPojoList = new LinkedList<Object>();
        relationGraphDataPojo.setRelationGraphLinkPojoList(relationGraphLinkPojoList);
        relationGraphLinkPojoList.add(LambdaUtils.get(() -> {
            RelationGraphLinkPojo relationGraphLinkPojo = new RelationGraphLinkPojo();
            relationGraphLinkPojo.setFromString("aaa");
            relationGraphLinkPojo.setToString("bbb");
            return relationGraphLinkPojo;
        }));
        relationGraphLinkPojoList.add(LambdaUtils.get(() -> {
            RelationGraphLinkPojo relationGraphLinkPojo = new RelationGraphLinkPojo();
            relationGraphLinkPojo.setFromString("aaa");
            relationGraphLinkPojo.setToString("ccc");
            return relationGraphLinkPojo;
        }));
        relationGraphModelPojo.setRelationGraphOptionsPojo(RelationGraphUtils.getFixedRelationGraphOptionsPojo());
        RelationGraphUtils.checkAndReorganize(relationGraphModelPojo);
        return relationGraphModelPojo;
    }

    public static void openRelationGraph(IFormView currentFormView, RelationGraphModelPojo relationGraphModelPojo) {
        if (currentFormView == null || relationGraphModelPojo == null) {
            return;
        }
        FormShowParameter formShowParameter = new FormShowParameter();
        formShowParameter.setFormId("eb_relation_graph");
        formShowParameter.setParentPageId(currentFormView.getPageId());
        formShowParameter.setStatus(OperationStatus.ADDNEW);
        formShowParameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
        RelationGraphUtils.checkAndReorganize(relationGraphModelPojo);
        formShowParameter.setCustomParam(RelationGraphModelPojo.class.getName(), (Object)JsonUtils.getJsonString((Object)relationGraphModelPojo));
        formShowParameter.setCustomParam(AnalysisContext, (Object)currentFormView.getPageCache().get(AnalysisContext));
        String titleString = relationGraphModelPojo.getTitleString();
        if (StringUtils.isNotBlank((CharSequence)titleString)) {
            formShowParameter.setCaption(titleString);
        }
        currentFormView.showForm(formShowParameter);
    }

    public static void openRelationGraph(IFormView currentFormView, RelationGraphDataPojo relationGraphDataPojo) {
        RelationGraphModelPojo relationGraphModelPojo = new RelationGraphModelPojo();
        relationGraphModelPojo.setRelationGraphDataPojo(relationGraphDataPojo);
        RelationGraphUtils.openRelationGraph(currentFormView, relationGraphModelPojo);
    }

    public static void checkAndReorganize(RelationGraphModelPojo relationGraphModelPojo) {
        RelationGraphUtils.checkAndReorganize(relationGraphModelPojo, null);
    }

    public static void checkAndReorganize(RelationGraphModelPojo relationGraphModelPojo, Set<String> neededNodeIdStringSet) {
        try {
            RelationGraphDataPojo relationGraphDataPojo;
            List relationGraphNodePojoList;
            if (relationGraphModelPojo.getRelationGraphOptionsPojo() == null) {
                relationGraphModelPojo.setRelationGraphOptionsPojo(RelationGraphUtils.getFixedRelationGraphOptionsPojo());
            }
            relationGraphModelPojo.setRelationGraphShowBoxParent(RelationGraphUtils.getFinalRelationGraphShowBoxParent(relationGraphModelPojo.getRelationGraphShowBoxParent()));
            if (Boolean.TRUE.equals(relationGraphModelPojo.getDisableContextmenuBoolean())) {
                LambdaUtils.run(() -> {
                    RelationGraphShowBoxParent relationGraphShowBoxParent = relationGraphModelPojo.getRelationGraphShowBoxParent();
                    if (relationGraphShowBoxParent == null) {
                        return;
                    }
                    List relationGraphShowBoxPojoList = relationGraphShowBoxParent.getRelationGraphShowBoxPojoList();
                    if (CollectionUtils.isEmpty((Collection)relationGraphShowBoxPojoList)) {
                        return;
                    }
                    relationGraphShowBoxPojoList = relationGraphModelPojo.getRelationGraphShowBoxParent().getRelationGraphShowBoxPojoList().stream().filter(item -> !RelationGraphShowBoxTypeEnum.CONTEXTMENU.name().equals(item.getTypeString())).collect(Collectors.toList());
                    relationGraphShowBoxParent.setRelationGraphShowBoxPojoList(relationGraphShowBoxPojoList);
                });
            }
            if (CollectionUtils.isEmpty((Collection)(relationGraphNodePojoList = (relationGraphDataPojo = relationGraphModelPojo.getRelationGraphDataPojo()).getRelationGraphNodePojoList()))) {
                throw new KDBizException(ResManager.loadKDString((String)"\u5173\u7cfb\u56fe\u8282\u70b9\u4e0d\u53ef\u4e3a\u7a7a\u3002", (String)"RelationGraphPlugin_4", (String)"epm-eb-formplugin", (Object[])new Object[0]));
            }
            if (relationGraphDataPojo.getRelationGraphLinkPojoList() == null) {
                relationGraphDataPojo.setRelationGraphLinkPojoList(new LinkedList());
            }
            if (relationGraphDataPojo.getRootIdString() == null) {
                RelationGraphNodePojo rootRelationGraphNodePojo = RelationGraphUtils.getRootRelationGraphNodePojo();
                relationGraphDataPojo.setRootIdString(rootRelationGraphNodePojo.getIdString());
                if (relationGraphModelPojo.getFullRelationGraphDataPojo() == null) {
                    relationGraphModelPojo.setFullRelationGraphDataPojo(relationGraphDataPojo);
                }
                RelationGraphDataPojo fullRelationGraphDataPojo = relationGraphModelPojo.getFullRelationGraphDataPojo();
                List fullRelationGraphLinkPojoList = fullRelationGraphDataPojo.getRelationGraphLinkPojoList();
                MutableGraph<String> mutableGraph = RelationGraphUtils.getWithoutDefaultRootGraph(fullRelationGraphDataPojo);
                Set fullNodeIdStringSet = mutableGraph.nodes();
                for (String nodeString : fullNodeIdStringSet) {
                    if (!CollectionUtils.isEmpty((Collection)mutableGraph.predecessors((Object)nodeString))) continue;
                    RelationGraphLinkPojo relationGraphLinkPojo = new RelationGraphLinkPojo();
                    relationGraphLinkPojo.setFromString(rootRelationGraphNodePojo.getIdString());
                    relationGraphLinkPojo.setToString(nodeString);
                    relationGraphLinkPojo.setHideBoolean(Boolean.valueOf(true));
                    fullRelationGraphLinkPojoList.add(relationGraphLinkPojo);
                }
                relationGraphNodePojoList.add(rootRelationGraphNodePojo);
                String focusNodeIdString = relationGraphModelPojo.getFocusNodeIdString();
                LinkedHashSet<String> currentNeededNodeIdStringSet = new LinkedHashSet<String>(fullNodeIdStringSet);
                if (StringUtils.isNotBlank((CharSequence)focusNodeIdString) && fullNodeIdStringSet.contains(focusNodeIdString)) {
                    relationGraphNodePojoList.forEach(item -> {
                        if (StringUtils.isBlank((CharSequence)item.getTextString())) {
                            item.setTextString(item.getIdString());
                        }
                    });
                    currentNeededNodeIdStringSet.clear();
                    currentNeededNodeIdStringSet.addAll(mutableGraph.predecessors((Object)focusNodeIdString));
                    currentNeededNodeIdStringSet.addAll(mutableGraph.successors((Object)focusNodeIdString));
                    currentNeededNodeIdStringSet.add(focusNodeIdString);
                } else {
                    relationGraphModelPojo.setFocusNodeIdString(null);
                }
                if (CollectionUtils.isEmpty(neededNodeIdStringSet)) {
                    neededNodeIdStringSet = currentNeededNodeIdStringSet;
                }
            }
            if (CollectionUtils.isNotEmpty(neededNodeIdStringSet)) {
                RelationGraphDataPojo finalRelationGraphDataPojo = RelationGraphUtils.getRelationGraphDataPojo(relationGraphModelPojo.getFullRelationGraphDataPojo(), neededNodeIdStringSet);
                relationGraphModelPojo.setRelationGraphDataPojo(finalRelationGraphDataPojo);
            }
            relationGraphModelPojo.getRelationGraphDataPojo().getRelationGraphNodePojoList().forEach(item -> {
                if (StringUtils.equalsAny((CharSequence)item.getIdString(), (CharSequence[])new CharSequence[]{DEFAULT_ROOT_NODE_ID_STRING})) {
                    return;
                }
                if (StringUtils.equalsAny((CharSequence)item.getIdString(), (CharSequence[])new CharSequence[]{relationGraphModelPojo.getFocusNodeIdString()})) {
                    item.setColorString("orange");
                }
            });
            RelationGraphUtils.setXandY(relationGraphModelPojo.getRelationGraphDataPojo());
            LambdaUtils.run(() -> {
                List axisPojoListIdStringList;
                RelationGraphActionPojo relationGraphActionPojo = relationGraphModelPojo.getRelationGraphActionPojo();
                if (relationGraphActionPojo == null) {
                    return;
                }
                RelationGraphActionPositionPojo relationGraphActionPositionPojo = relationGraphActionPojo.getRelationGraphActionPositionPojo();
                if (relationGraphActionPositionPojo == null) {
                    return;
                }
                List axisPojoList = relationGraphActionPositionPojo.getAxisPojoList();
                if (CollectionUtils.isEmpty((Collection)axisPojoList)) {
                    return;
                }
                List relationGraphNodePojoNodeIdStringList = relationGraphModelPojo.getRelationGraphDataPojo().getRelationGraphNodePojoList().stream().map(RelationGraphNodePojo::getIdString).collect(Collectors.toList());
                Collection intersectionStringCollection = CollectionUtils.intersection(relationGraphNodePojoNodeIdStringList, axisPojoListIdStringList = axisPojoList.stream().map(AxisPojo::getIdString).collect(Collectors.toList()));
                if (CollectionUtils.isEmpty((Collection)intersectionStringCollection)) {
                    return;
                }
                String targetNodeIdString = intersectionStringCollection.contains(relationGraphActionPojo.getIdString()) ? relationGraphActionPojo.getIdString() : (String)intersectionStringCollection.iterator().next();
                String finalTargetNodeIdString = targetNodeIdString;
                RelationGraphNodePojo relationGraphNodePojo = (RelationGraphNodePojo)LambdaUtils.getTarget((List)relationGraphModelPojo.getRelationGraphDataPojo().getRelationGraphNodePojoList(), item -> item.getIdString().equals(finalTargetNodeIdString));
                AxisPojo targetAxisPojo = (AxisPojo)LambdaUtils.getTarget((List)axisPojoList, item -> item.getIdString().equals(finalTargetNodeIdString));
                if (relationGraphNodePojo.getXaxisInteger() == null || relationGraphNodePojo.getYaxisInteger() == null) {
                    return;
                }
                Integer targetXaxisInteger = (Integer)LambdaUtils.get(() -> {
                    String relationGraphActionPositionPojoMarginLeftString;
                    Integer relationGraphActionPositionPojoXaxisInteger = targetAxisPojo.getXaxisInteger();
                    if (relationGraphActionPositionPojoXaxisInteger == null) {
                        relationGraphActionPositionPojoXaxisInteger = 0;
                    }
                    if (StringUtils.isBlank((CharSequence)(relationGraphActionPositionPojoMarginLeftString = relationGraphActionPositionPojo.getMarginLeftString()))) {
                        return relationGraphActionPositionPojoXaxisInteger;
                    }
                    if (!relationGraphActionPositionPojoMarginLeftString.endsWith("px")) {
                        return relationGraphActionPositionPojoXaxisInteger;
                    }
                    Long resultLong = ObjUtils.getLong((Object)relationGraphActionPositionPojoMarginLeftString.substring(0, relationGraphActionPositionPojoMarginLeftString.length() - 2));
                    if (resultLong == null) {
                        return relationGraphActionPositionPojoXaxisInteger;
                    }
                    return relationGraphActionPositionPojoXaxisInteger + resultLong.intValue();
                });
                Integer targetYaxisInteger = (Integer)LambdaUtils.get(() -> {
                    String relationGraphActionPositionPojoMarginTopString;
                    Integer relationGraphActionPositionPojoYaxisInteger = targetAxisPojo.getYaxisInteger();
                    if (relationGraphActionPositionPojoYaxisInteger == null) {
                        relationGraphActionPositionPojoYaxisInteger = 0;
                    }
                    if (StringUtils.isBlank((CharSequence)(relationGraphActionPositionPojoMarginTopString = relationGraphActionPositionPojo.getMarginTopString()))) {
                        return relationGraphActionPositionPojoYaxisInteger;
                    }
                    if (!relationGraphActionPositionPojoMarginTopString.endsWith("px")) {
                        return relationGraphActionPositionPojoYaxisInteger;
                    }
                    Long resultLong = ObjUtils.getLong((Object)relationGraphActionPositionPojoMarginTopString.substring(0, relationGraphActionPositionPojoMarginTopString.length() - 2));
                    if (resultLong == null) {
                        return relationGraphActionPositionPojoYaxisInteger;
                    }
                    return relationGraphActionPositionPojoYaxisInteger + resultLong.intValue();
                });
                Integer shortXaxisInteger = targetXaxisInteger - relationGraphNodePojo.getXaxisInteger();
                Integer shortYaxisInteger = targetYaxisInteger - relationGraphNodePojo.getYaxisInteger();
                relationGraphModelPojo.getRelationGraphDataPojo().getRelationGraphNodePojoList().forEach(item -> {
                    item.setXaxisInteger(Integer.valueOf(item.getXaxisInteger() + shortXaxisInteger));
                    item.setYaxisInteger(Integer.valueOf(item.getYaxisInteger() + shortYaxisInteger));
                });
            });
            relationGraphModelPojo.setRelationGraphActionPojo(null);
        }
        catch (Throwable throwable) {
            log.info("checkAndReorganize", (Object)throwable);
            String throwableMessageString = throwable.getMessage();
            if (StringUtils.isBlank((CharSequence)throwableMessageString)) {
                throwableMessageString = throwable.toString();
            }
            throw new KDBizException(ResManager.loadResFormat((String)"\u5173\u7cfb\u56fe\u914d\u7f6e\u5bf9\u8c61\u5b58\u5728\u9519\u8bef\uff1a%1", (String)"RelationGraphPlugin_5", (String)"epm-eb-formplugin", (Object[])new Object[]{throwableMessageString}));
        }
    }

    public static void setXandY(RelationGraphDataPojo relationGraphDataPojo) {
        RelationGraphNodePojoTree relationGraphNodePojoTree = RelationGraphUtils.getRelationGraphNodePojoTree(RelationGraphUtils.getGraph(relationGraphDataPojo));
        Map<String, RelationGraphNodePojo> relationGraphNodePojoMap = relationGraphDataPojo.getRelationGraphNodePojoList().stream().collect(Collectors.toMap(RelationGraphNodePojo::getIdString, item -> item));
        RelationGraphUtils.setXandY(relationGraphNodePojoTree, relationGraphNodePojoMap);
    }

    public static RelationGraphNodePojoTree getRelationGraphNodePojoTree(RelationGraphNodePojoTree relationGraphNodePojoTree, MutableGraph<String> mutableGraph, MutableGraph<String> originMutableGraph) {
        if (relationGraphNodePojoTree == null) {
            relationGraphNodePojoTree = new RelationGraphNodePojoTree();
            relationGraphNodePojoTree.setDeepInteger(Integer.valueOf(1));
            relationGraphNodePojoTree.setOrderInteger(Integer.valueOf(1));
            relationGraphNodePojoTree.setTotalOrderInteger(Integer.valueOf(1));
            relationGraphNodePojoTree.setCurrentString(DEFAULT_ROOT_NODE_ID_STRING);
            mutableGraph.removeNode((Object)relationGraphNodePojoTree.getCurrentString());
        }
        List<String> laterStringList = new LinkedList<String>();
        for (String nodeIdString : mutableGraph.nodes()) {
            if (!CollectionUtils.isEmpty((Collection)mutableGraph.predecessors((Object)nodeIdString))) continue;
            laterStringList.add(nodeIdString);
        }
        if (laterStringList.isEmpty()) {
            return relationGraphNodePojoTree;
        }
        List<String> sortLaterStringList = RelationGraphUtils.getSortLaterStringList(originMutableGraph, laterStringList, relationGraphNodePojoTree);
        if (sortLaterStringList != null) {
            laterStringList = sortLaterStringList;
        }
        mutableGraph.removeNode((Object)relationGraphNodePojoTree.getCurrentString());
        if (CollectionUtils.isNotEmpty(laterStringList)) {
            laterStringList.forEach(arg_0 -> mutableGraph.removeNode(arg_0));
            LinkedList<RelationGraphNodePojoTree> laterRelationGraphNodePojoTreeList = new LinkedList<RelationGraphNodePojoTree>();
            int laterStringListSizeInt = laterStringList.size();
            for (int i = 0; i < laterStringListSizeInt; ++i) {
                RelationGraphNodePojoTree laterRelationGraphNodePojoTree = new RelationGraphNodePojoTree();
                laterRelationGraphNodePojoTreeList.add(laterRelationGraphNodePojoTree);
                laterRelationGraphNodePojoTree.setDeepInteger(Integer.valueOf(relationGraphNodePojoTree.getDeepInteger() + 1));
                laterRelationGraphNodePojoTree.setOrderInteger(Integer.valueOf(i + 1));
                laterRelationGraphNodePojoTree.setCurrentString(laterStringList.get(i));
                laterRelationGraphNodePojoTree.setTotalOrderInteger(Integer.valueOf(laterStringListSizeInt));
                laterRelationGraphNodePojoTree.setBeforeRelationGraphNodePojoTree(relationGraphNodePojoTree);
            }
            relationGraphNodePojoTree.setLaterRelationGraphNodePojoTreeList(laterRelationGraphNodePojoTreeList);
            RelationGraphUtils.getRelationGraphNodePojoTree((RelationGraphNodePojoTree)laterRelationGraphNodePojoTreeList.get(0), mutableGraph, originMutableGraph);
        }
        return relationGraphNodePojoTree;
    }

    public static RelationGraphNodePojoTree getRelationGraphNodePojoTree(MutableGraph<String> mutableGraph) {
        return RelationGraphUtils.getRelationGraphNodePojoTree(null, (MutableGraph<String>)Graphs.copyOf(mutableGraph), (MutableGraph<String>)Graphs.copyOf(mutableGraph));
    }

    public static List<RelationGraphNodePojoTree> getItemRelationGraphNodePojoTreeList(RelationGraphNodePojoTree relationGraphNodePojoTree) {
        return RelationGraphUtils.getItemRelationGraphNodePojoTreeList(Lists.newArrayList(), relationGraphNodePojoTree);
    }

    public static List<RelationGraphNodePojoTree> getItemRelationGraphNodePojoTreeList(List<RelationGraphNodePojoTree> itemRelationGraphNodePojoTreeList, RelationGraphNodePojoTree relationGraphNodePojoTree) {
        itemRelationGraphNodePojoTreeList.add(relationGraphNodePojoTree);
        List laterRelationGraphNodePojoTreeList = relationGraphNodePojoTree.getLaterRelationGraphNodePojoTreeList();
        if (CollectionUtils.isEmpty((Collection)laterRelationGraphNodePojoTreeList)) {
            return itemRelationGraphNodePojoTreeList;
        }
        for (RelationGraphNodePojoTree laterRelationGraphNodePojoTree : laterRelationGraphNodePojoTreeList) {
            RelationGraphUtils.getItemRelationGraphNodePojoTreeList(itemRelationGraphNodePojoTreeList, laterRelationGraphNodePojoTree);
        }
        return itemRelationGraphNodePojoTreeList;
    }

    public static void setXandY(RelationGraphNodePojoTree relationGraphNodePojoTree, Map<String, RelationGraphNodePojo> relationGraphNodePojoMap) {
        List laterRelationGraphNodePojoTreeList;
        RelationGraphUtils.setCurrentRelationGraphNodePojoTreeXandY(relationGraphNodePojoTree, relationGraphNodePojoMap);
        if (relationGraphNodePojoTree.getDeepInteger() > 1 && relationGraphNodePojoTree.getTotalOrderInteger() > 1) {
            List brotherRelationGraphNodePojoTreeList = relationGraphNodePojoTree.getBeforeRelationGraphNodePojoTree().getLaterRelationGraphNodePojoTreeList();
            for (int i = 1; i < relationGraphNodePojoTree.getTotalOrderInteger(); ++i) {
                RelationGraphUtils.setCurrentRelationGraphNodePojoTreeXandY((RelationGraphNodePojoTree)brotherRelationGraphNodePojoTreeList.get(i), relationGraphNodePojoMap);
            }
        }
        if (CollectionUtils.isEmpty((Collection)(laterRelationGraphNodePojoTreeList = relationGraphNodePojoTree.getLaterRelationGraphNodePojoTreeList()))) {
            return;
        }
        RelationGraphUtils.setXandY((RelationGraphNodePojoTree)laterRelationGraphNodePojoTreeList.get(0), relationGraphNodePojoMap);
    }

    public static void setCurrentRelationGraphNodePojoTreeXandY(RelationGraphNodePojoTree relationGraphNodePojoTree, Map<String, RelationGraphNodePojo> relationGraphNodePojoMap) {
        RelationGraphNodePojo relationGraphNodePojo = relationGraphNodePojoMap.get(relationGraphNodePojoTree.getCurrentString());
        relationGraphNodePojoTree.setCurrentRelationGraphNodePojo(relationGraphNodePojo);
        AxisPojo axisPojo = new AxisPojo();
        relationGraphNodePojoTree.setAxisPojo(axisPojo);
        if (relationGraphNodePojoTree.getDeepInteger() == 1) {
            relationGraphNodePojo.setXaxisInteger(Integer.valueOf(-100));
            relationGraphNodePojo.setYaxisInteger(Integer.valueOf(300));
            axisPojo.setWidthInteger(Integer.valueOf(10));
            axisPojo.setHeightInteger(Integer.valueOf(60));
            return;
        }
        RelationGraphNodePojoTree beforeRelationGraphNodePojoTree = relationGraphNodePojoTree.getBeforeRelationGraphNodePojoTree();
        RelationGraphNodePojo beforeRelationGraphNodePojo = beforeRelationGraphNodePojoTree.getCurrentRelationGraphNodePojo();
        if (relationGraphNodePojoTree.getOrderInteger() == 1) {
            relationGraphNodePojo.setYaxisInteger(Integer.valueOf(300));
        } else {
            RelationGraphNodePojoTree previousRelationGraphNodePojoTree = (RelationGraphNodePojoTree)beforeRelationGraphNodePojoTree.getLaterRelationGraphNodePojoTreeList().get(relationGraphNodePojoTree.getOrderInteger() - 2);
            relationGraphNodePojo.setYaxisInteger(Integer.valueOf(previousRelationGraphNodePojoTree.getCurrentRelationGraphNodePojo().getYaxisInteger() + previousRelationGraphNodePojoTree.getAxisPojo().getHeightInteger()));
        }
        if (relationGraphNodePojoTree.getDeepInteger() == 2) {
            relationGraphNodePojo.setXaxisInteger(Integer.valueOf(beforeRelationGraphNodePojo.getXaxisInteger() + beforeRelationGraphNodePojoTree.getAxisPojo().getWidthInteger() + 150));
        } else {
            int maxWidthInteger = 0;
            for (RelationGraphNodePojoTree tempBeforeRelationGraphNodePojoTree : beforeRelationGraphNodePojoTree.getBeforeRelationGraphNodePojoTree().getLaterRelationGraphNodePojoTreeList()) {
                Integer widthInteger = tempBeforeRelationGraphNodePojoTree.getAxisPojo().getWidthInteger();
                if (widthInteger <= maxWidthInteger) continue;
                maxWidthInteger = widthInteger;
            }
            relationGraphNodePojo.setXaxisInteger(Integer.valueOf(beforeRelationGraphNodePojo.getXaxisInteger() + maxWidthInteger + 150));
        }
        RelationGraphNodeDataPojo relationGraphNodeDataPojo = relationGraphNodePojo.getRelationGraphNodeDataPojo();
        if (relationGraphNodeDataPojo != null && relationGraphNodeDataPojo.getRelationGraphNodeDataAreaPojo() != null) {
            List relationGraphNodeDataRowPojoList = relationGraphNodeDataPojo.getRelationGraphNodeDataAreaPojo().getRelationGraphNodeDataRowPojoList();
            LinkedList<Integer> rowCssLengthIntList = new LinkedList<Integer>();
            for (RelationGraphNodeDataRowPojo relationGraphNodeDataRowPojo : relationGraphNodeDataRowPojoList) {
                int rowCssLengthInt = 0;
                for (RelationGraphNodeDataCellPojo relationGraphNodeDataCellPojo : relationGraphNodeDataRowPojo.getRelationGraphNodeDataCellPojoList()) {
                    rowCssLengthInt += RelationGraphUtils.getCssLength(relationGraphNodeDataCellPojo.getValueString()).intValue();
                }
                rowCssLengthIntList.add(rowCssLengthInt);
            }
            axisPojo.setWidthInteger((Integer)rowCssLengthIntList.stream().max(Integer::compareTo).orElse(null));
            axisPojo.setHeightInteger(Integer.valueOf(60 + relationGraphNodeDataRowPojoList.size() * 20));
        } else {
            axisPojo.setWidthInteger(RelationGraphUtils.getCssLength(relationGraphNodePojo.getTextString()));
            axisPojo.setHeightInteger(Integer.valueOf(80));
        }
    }

    public static Integer getCssLength(String string) {
        int stringCssLengthInt = 0;
        if (string == null) {
            return stringCssLengthInt;
        }
        if (string.contains("</br>")) {
            String[] stringArray;
            for (String itemString : stringArray = string.split("</br>")) {
                Integer cssLengthInteger = RelationGraphUtils.getCssLength(itemString);
                if (cssLengthInteger <= stringCssLengthInt) continue;
                stringCssLengthInt = cssLengthInteger;
            }
            return stringCssLengthInt;
        }
        for (char itemChar : string.toCharArray()) {
            Boolean chineseBoolean = (Boolean)LambdaUtils.get(() -> {
                Character.UnicodeBlock unicodeBlock = Character.UnicodeBlock.of(itemChar);
                if (unicodeBlock == Character.UnicodeBlock.CJK_UNIFIED_IDEOGRAPHS) {
                    return true;
                }
                if (unicodeBlock == Character.UnicodeBlock.CJK_COMPATIBILITY_IDEOGRAPHS) {
                    return true;
                }
                if (unicodeBlock == Character.UnicodeBlock.CJK_UNIFIED_IDEOGRAPHS_EXTENSION_A) {
                    return true;
                }
                if (unicodeBlock == Character.UnicodeBlock.CJK_UNIFIED_IDEOGRAPHS_EXTENSION_B) {
                    return true;
                }
                if (unicodeBlock == Character.UnicodeBlock.CJK_SYMBOLS_AND_PUNCTUATION) {
                    return true;
                }
                if (unicodeBlock == Character.UnicodeBlock.HALFWIDTH_AND_FULLWIDTH_FORMS) {
                    return true;
                }
                return unicodeBlock == Character.UnicodeBlock.GENERAL_PUNCTUATION;
            });
            if (chineseBoolean.booleanValue()) {
                stringCssLengthInt += 14;
                continue;
            }
            stringCssLengthInt += 7;
        }
        return stringCssLengthInt;
    }

    public static boolean insideScopeBoolean(IModelCacheHelper modelCacheHelper, Map<String, Long> viewMap, Map<String, Set<String>> reportProcessPojoDimensionAndMemberSetNumberMap, Map<String, Set<String>> cellDimensionAndMemberSetNumberMap) {
        if (MapUtils.isEmpty(reportProcessPojoDimensionAndMemberSetNumberMap) || MapUtils.isEmpty(cellDimensionAndMemberSetNumberMap)) {
            return false;
        }
        for (Map.Entry<String, Set<String>> entry : reportProcessPojoDimensionAndMemberSetNumberMap.entrySet()) {
            Set fullReportProcessPojoMemberNumberStringSet;
            Set<String> cellMemberNumberStringSet;
            Set<String> reportProcessPojoMemberNumberStringSet = entry.getValue();
            if (CollectionUtils.isEmpty(reportProcessPojoMemberNumberStringSet) || CollectionUtils.isEmpty(cellMemberNumberStringSet = cellDimensionAndMemberSetNumberMap.get(entry.getKey())) || !CollectionUtils.isEmpty((Collection)CollectionUtils.intersection(reportProcessPojoMemberNumberStringSet, cellMemberNumberStringSet)) || SysDimensionEnum.Entity.getNumber().equals(entry.getKey()) && modelCacheHelper != null && CollectionUtils.isNotEmpty((Collection)CollectionUtils.intersection(fullReportProcessPojoMemberNumberStringSet = reportProcessPojoMemberNumberStringSet.stream().map(item -> {
                Member member = modelCacheHelper.getMember(SysDimensionEnum.Entity.getNumber(), (Long)viewMap.get(SysDimensionEnum.Entity.getNumber()), item);
                if (member == null) {
                    return null;
                }
                return member.getAllMembers();
            }).filter(item -> CollectionUtils.isNotEmpty((Collection)item)).flatMap(Collection::stream).map(item -> item.getNumber()).collect(Collectors.toSet()), cellMemberNumberStringSet))) continue;
            return false;
        }
        return true;
    }

    public static List<String> getSortLaterStringList(MutableGraph<String> originMutableGraph, List<String> laterStringList, RelationGraphNodePojoTree parentRelationGraphNodePojoTree) {
        if (parentRelationGraphNodePojoTree == null) {
            return null;
        }
        RelationGraphNodePojoTree grandFatherRelationGraphNodePojoTree = parentRelationGraphNodePojoTree.getBeforeRelationGraphNodePojoTree();
        if (grandFatherRelationGraphNodePojoTree == null) {
            return null;
        }
        List laterRelationGraphNodePojoTreeList = grandFatherRelationGraphNodePojoTree.getLaterRelationGraphNodePojoTreeList();
        if (CollectionUtils.isEmpty((Collection)laterRelationGraphNodePojoTreeList) || laterRelationGraphNodePojoTreeList.size() == 1) {
            return null;
        }
        LinkedList<String> _sortLaterStringList = new LinkedList<String>();
        LinkedList<String> remainLaterStringList = new LinkedList<String>(laterStringList);
        for (RelationGraphNodePojoTree relationGraphNodePojoTree : laterRelationGraphNodePojoTreeList) {
            List intersectionNodeIdStringList;
            if (remainLaterStringList.isEmpty()) {
                return _sortLaterStringList;
            }
            Set successorNodeIdStringSet = originMutableGraph.successors((Object)relationGraphNodePojoTree.getCurrentString());
            if (CollectionUtils.isEmpty((Collection)successorNodeIdStringSet) || (intersectionNodeIdStringList = remainLaterStringList.stream().filter(successorNodeIdStringSet::contains).collect(Collectors.toList())).isEmpty()) continue;
            remainLaterStringList.removeAll(intersectionNodeIdStringList);
            _sortLaterStringList.addAll(intersectionNodeIdStringList);
        }
        _sortLaterStringList.addAll(remainLaterStringList);
        return _sortLaterStringList;
    }

    public static RelationGraphModelPojo updateRelationGraphModelPojoInfoHtmlString(RelationGraphModelPojo relationGraphModelPojo, String infoHtmlString) {
        relationGraphModelPojo.setInfoHtmlString(null);
        if (StringUtils.isBlank((CharSequence)infoHtmlString)) {
            return relationGraphModelPojo;
        }
        relationGraphModelPojo.setInfoHtmlString(StrUtils.getBase64EncodeString((String)infoHtmlString));
        return relationGraphModelPojo;
    }
}

