/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.formplugin.rulemanage;

import java.util.ArrayList;
import java.util.EventObject;
import java.util.List;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.field.ComboEdit;
import kd.bos.form.field.ComboItem;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.epm.eb.common.cache.IModelCacheHelper;
import kd.epm.eb.common.cache.impl.Dimension;
import kd.epm.eb.common.enums.SysDimensionEnum;
import kd.epm.eb.common.enums.ruleFunctionEnums.FunctionItemEnum;
import kd.epm.eb.common.enums.ruleFunctionEnums.RuleFunctionEnum;
import kd.epm.eb.common.enums.ruleFunctionEnums.RuleFunctionTypeEnum;
import kd.epm.eb.common.rule.ruleFunction.IRuleFunction;
import kd.epm.eb.common.utils.CommonServiceHelper;
import kd.epm.eb.common.utils.QFBuilder;
import kd.epm.eb.common.utils.StringUtils;
import kd.epm.eb.formplugin.rulemanage.functionEdit.RuleFunctionEditPlugin;

public class RelationRuleFunctionEditPlugin
extends RuleFunctionEditPlugin {
    @Override
    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        this.getView().setEnable(Boolean.valueOf(false), new String[]{"functiontype"});
    }

    @Override
    protected void updateFunTypeList() {
        ComboEdit itemc = (ComboEdit)this.getControl("functiontype");
        ArrayList<ComboItem> com = new ArrayList<ComboItem>(16);
        String parentFunName = (String)this.getCustomFormParam("parentFunName");
        RuleFunctionTypeEnum ruleFunctionTypeEnum = RuleFunctionTypeEnum.Relation;
        if (RuleFunctionEnum.Member.getName().equals(parentFunName)) {
            ruleFunctionTypeEnum = RuleFunctionTypeEnum.String;
        }
        com.add(new ComboItem(new LocaleString(ruleFunctionTypeEnum.getName()), ruleFunctionTypeEnum.getKey()));
        itemc.setComboItems(com);
        this.getModel().setValue("functiontype", (Object)ruleFunctionTypeEnum.getKey());
        this.getView().getFormShowParameter().setCustomParam("functionType", (Object)ruleFunctionTypeEnum.getKey());
    }

    @Override
    protected void initFunctionList() {
        try {
            List functionEnumList;
            String parentFunName = (String)this.getCustomFormParam("parentFunName");
            String parentFunItemKey = (String)this.getCustomFormParam("parentFunItemKey");
            if (FunctionItemEnum.RELATIONFUN.getKey().equalsIgnoreCase(parentFunItemKey)) {
                functionEnumList = RuleFunctionEnum.getFunctionsByType((RuleFunctionTypeEnum)RuleFunctionTypeEnum.Relation);
                functionEnumList.removeIf(e -> e.getName().equals(RuleFunctionEnum.GetAttribute.getName()));
            } else {
                functionEnumList = RuleFunctionEnum.getFunctionsByParentFunName((String)parentFunName);
            }
            IDataModel dataModel = this.getModel();
            dataModel.deleteEntryData("entryentity");
            IRuleFunction ruleFunction = null;
            String functionInfo = (String)this.getView().getFormShowParameter().getCustomParam("functionInfo");
            if (StringUtils.isNotEmpty((String)functionInfo)) {
                ruleFunction = (IRuleFunction)SerializationUtils.deSerializeFromBase64((String)functionInfo);
            }
            if (functionEnumList != null && functionEnumList.size() > 0) {
                dataModel.batchCreateNewEntryRow("entryentity", functionEnumList.size());
                int rowIndex = 0;
                int selectRowIndex = 0;
                for (RuleFunctionEnum functionEnum : functionEnumList) {
                    if (ruleFunction != null && functionEnum.getName().equals(ruleFunction.getFunctionName())) {
                        selectRowIndex = rowIndex;
                    }
                    dataModel.setValue("functionname", (Object)functionEnum.getName(), rowIndex++);
                }
                EntryGrid entryGrid = (EntryGrid)this.getControl("entryentity");
                entryGrid.selectRows(selectRowIndex);
                if (ruleFunction == null) {
                    String funName2 = ((RuleFunctionEnum)functionEnumList.get(0)).getName();
                    this.doAfterFunctionSelectChange(funName2);
                } else {
                    this.doAfterFunctionSelectChange(ruleFunction.getFunctionName());
                }
                this.getOrSetSelectFunctionRowAfterInit(selectRowIndex);
            }
            this.getOrCacheSearchStr("");
            this.getOrSetSearchRowIndex(-2);
            if (ruleFunction != null) {
                this.getFunctionEditPlugin().initPage(ruleFunction);
                this.getView().setEnable(Boolean.valueOf(false), new String[]{"functiontype"});
            }
        }
        catch (Exception e2) {
            CommonServiceHelper.dealException((AbstractFormPlugin)this, (String)"RelationRuleFunctionEditPlugin#initFunctionList", (Throwable)e2);
        }
    }

    @Override
    protected void doAfterFunctionSelectChange(String functionName) {
        try {
            super.doAfterFunctionSelectChange(functionName);
            String parentFunDim = (String)this.getCustomFormParam("parentFunDim");
            this.getModel().setValue(FunctionItemEnum.DIMENSIONLIST.getKey(), (Object)parentFunDim);
            if (RuleFunctionEnum.Attribute.getName().equals(functionName) || RuleFunctionEnum.GetAttribute.getName().equals(functionName) || RuleFunctionEnum.IsAttribute.getName().equals(functionName)) {
                this.getFunctionEditPlugin().updatePropList(parentFunDim);
            } else if (RuleFunctionEnum.YearValue.getName().equals(functionName)) {
                this.getFunctionEditPlugin().updateSpecifiedPeriodPropList();
            }
        }
        catch (Exception e) {
            CommonServiceHelper.dealException((AbstractFormPlugin)this, (String)"RelationRuleFunctionEditPlugin#doAfterFunctionSelectChange", (Throwable)e);
        }
    }

    @Override
    protected void initDimensionList2(String functionName) {
        try {
            this.initDimensionList(functionName);
        }
        catch (Exception e) {
            CommonServiceHelper.dealException((AbstractFormPlugin)this, (String)"RelationRuleFunctionEditPlugin#initDimensionList2", (Throwable)e);
        }
    }

    @Override
    protected void initDimensionList(String functionName) {
        try {
            String parentFunDim = (String)this.getCustomFormParam("parentFunDim");
            String parentFunName = (String)this.getCustomFormParam("parentFunName");
            String parentFunItemKey = (String)this.getCustomFormParam("parentFunItemKey");
            ComboEdit dimList = (ComboEdit)this.getControl(FunctionItemEnum.DIMENSIONLIST.getKey());
            IModelCacheHelper modelCache = this.getIModelCacheHelper();
            ArrayList<ComboItem> itemList = new ArrayList<ComboItem>(8);
            if (StringUtils.isNotEmpty((String)parentFunDim)) {
                Dimension dimension = modelCache.getDimension(parentFunDim);
                itemList.add(new ComboItem(new LocaleString(dimension.getName()), dimension.getNumber()));
                dimList.setComboItems(itemList);
                this.getModel().setValue(FunctionItemEnum.DIMENSIONLIST.getKey(), (Object)dimension.getNumber());
                this.getView().setEnable(Boolean.valueOf(false), new String[]{FunctionItemEnum.DIMENSIONLIST.getKey()});
                if (RuleFunctionEnum.GetNumber.getName().equals(functionName) || RuleFunctionEnum.GetName.getName().equals(functionName)) {
                    this.getView().setEnable(Boolean.valueOf(true), new String[]{FunctionItemEnum.DIMENSIONLIST.getKey()});
                    super.initDimensionList2(functionName);
                }
            } else if (FunctionItemEnum.RELATIONFUN.getKey().equalsIgnoreCase(parentFunItemKey) && RuleFunctionEnum.YearValue.getName().equalsIgnoreCase(parentFunName)) {
                List dims;
                String parentAccSelDims = (String)this.getCustomFormParam("parentAccSelDims");
                List parentAccSelDimList = new ArrayList(16);
                if (StringUtils.isNotEmpty((String)parentAccSelDims)) {
                    parentAccSelDimList = (List)SerializationUtils.fromJsonString((String)parentAccSelDims, List.class);
                }
                if (!(dims = modelCache.getDimensionList(Long.valueOf(this.getDatasetId()))).isEmpty()) {
                    for (Dimension dim : dims) {
                        String dimNumber = dim.getNumber();
                        if (parentAccSelDimList.contains(dimNumber) || SysDimensionEnum.BudgetPeriod.getNumber().equalsIgnoreCase(dimNumber)) continue;
                        itemList.add(new ComboItem(new LocaleString(dim.getName()), dim.getNumber()));
                    }
                    dimList.setComboItems(itemList);
                }
            }
        }
        catch (Exception e) {
            CommonServiceHelper.dealException((AbstractFormPlugin)this, (String)"RelationRuleFunctionEditPlugin#initDimensionList", (Throwable)e);
        }
    }

    @Override
    protected void initAttribute() {
        try {
            String parentFunAttribute = (String)this.getCustomFormParam("parentFunAttribute");
            if (StringUtils.isEmpty((String)parentFunAttribute)) {
                return;
            }
            ComboEdit attributeList = (ComboEdit)this.getControl(FunctionItemEnum.ATTRIBUTE.getKey());
            ArrayList<ComboItem> itemList = new ArrayList<ComboItem>(16);
            QFBuilder qb = new QFBuilder();
            qb.add("model", "=", (Object)this.getModelId());
            qb.add("number", "=", (Object)parentFunAttribute);
            DynamicObject attribute = QueryServiceHelper.queryOne((String)"eb_customproperty", (String)"number,name", (QFilter[])qb.toArrays());
            if (attribute != null) {
                itemList.add(new ComboItem(new LocaleString(attribute.getString("name")), attribute.getString("number")));
                attributeList.setComboItems(itemList);
                this.getModel().setValue(FunctionItemEnum.ATTRIBUTE.getKey(), (Object)attribute.getString("number"));
                this.getView().setEnable(Boolean.valueOf(false), new String[]{FunctionItemEnum.ATTRIBUTE.getKey()});
            }
        }
        catch (Exception e) {
            CommonServiceHelper.dealException((AbstractFormPlugin)this, (String)"RelationRuleFunctionEditPlugin#initAttribute", (Throwable)e);
        }
    }
}

